from http import HTTPStatus
from typing import Any, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.api_result_response_list_local_group_dto import ApiResultResponseListLocalGroupDTO
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    anchor_id: Union[Unset, str] = UNSET,
    context_size: Union[Unset, int] = UNSET,
    limit: Union[Unset, int] = UNSET,
    search: Union[Unset, str] = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["anchorId"] = anchor_id

    params["contextSize"] = context_size

    params["limit"] = limit

    params["search"] = search

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/v2/auth/local/group",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[ApiResultResponseListLocalGroupDTO]:
    if response.status_code == 200:
        response_200 = ApiResultResponseListLocalGroupDTO.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[ApiResultResponseListLocalGroupDTO]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    anchor_id: Union[Unset, str] = UNSET,
    context_size: Union[Unset, int] = UNSET,
    limit: Union[Unset, int] = UNSET,
    search: Union[Unset, str] = UNSET,
) -> Response[ApiResultResponseListLocalGroupDTO]:
    """Find the local group using a query parameter

    Args:
        anchor_id (Union[Unset, str]):
        context_size (Union[Unset, int]):
        limit (Union[Unset, int]):
        search (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiResultResponseListLocalGroupDTO]
    """

    kwargs = _get_kwargs(
        anchor_id=anchor_id,
        context_size=context_size,
        limit=limit,
        search=search,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    anchor_id: Union[Unset, str] = UNSET,
    context_size: Union[Unset, int] = UNSET,
    limit: Union[Unset, int] = UNSET,
    search: Union[Unset, str] = UNSET,
) -> Optional[ApiResultResponseListLocalGroupDTO]:
    """Find the local group using a query parameter

    Args:
        anchor_id (Union[Unset, str]):
        context_size (Union[Unset, int]):
        limit (Union[Unset, int]):
        search (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiResultResponseListLocalGroupDTO
    """

    return sync_detailed(
        client=client,
        anchor_id=anchor_id,
        context_size=context_size,
        limit=limit,
        search=search,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    anchor_id: Union[Unset, str] = UNSET,
    context_size: Union[Unset, int] = UNSET,
    limit: Union[Unset, int] = UNSET,
    search: Union[Unset, str] = UNSET,
) -> Response[ApiResultResponseListLocalGroupDTO]:
    """Find the local group using a query parameter

    Args:
        anchor_id (Union[Unset, str]):
        context_size (Union[Unset, int]):
        limit (Union[Unset, int]):
        search (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiResultResponseListLocalGroupDTO]
    """

    kwargs = _get_kwargs(
        anchor_id=anchor_id,
        context_size=context_size,
        limit=limit,
        search=search,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    anchor_id: Union[Unset, str] = UNSET,
    context_size: Union[Unset, int] = UNSET,
    limit: Union[Unset, int] = UNSET,
    search: Union[Unset, str] = UNSET,
) -> Optional[ApiResultResponseListLocalGroupDTO]:
    """Find the local group using a query parameter

    Args:
        anchor_id (Union[Unset, str]):
        context_size (Union[Unset, int]):
        limit (Union[Unset, int]):
        search (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiResultResponseListLocalGroupDTO
    """

    return (
        await asyncio_detailed(
            client=client,
            anchor_id=anchor_id,
            context_size=context_size,
            limit=limit,
            search=search,
        )
    ).parsed
