# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PeeringArgs', 'Peering']

@pulumi.input_type
class PeeringArgs:
    def __init__(__self__, *,
                 authorized_network: pulumi.Input[_builtins.str],
                 domain_resource: pulumi.Input[_builtins.str],
                 peering_id: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Peering resource.
        :param pulumi.Input[_builtins.str] authorized_network: The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        :param pulumi.Input[_builtins.str] domain_resource: Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        :param pulumi.Input[_builtins.str] peering_id: (Required)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels that can contain user-provided metadata
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] status: The current state of this Peering.
        :param pulumi.Input[_builtins.str] status_message: Additional information about the current status of this peering, if available.
        """
        pulumi.set(__self__, "authorized_network", authorized_network)
        pulumi.set(__self__, "domain_resource", domain_resource)
        pulumi.set(__self__, "peering_id", peering_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Input[_builtins.str]:
        """
        The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorized_network", value)

    @_builtins.property
    @pulumi.getter(name="domainResource")
    def domain_resource(self) -> pulumi.Input[_builtins.str]:
        """
        Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        """
        return pulumi.get(self, "domain_resource")

    @domain_resource.setter
    def domain_resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_resource", value)

    @_builtins.property
    @pulumi.getter(name="peeringId")
    def peering_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Required)
        """
        return pulumi.get(self, "peering_id")

    @peering_id.setter
    def peering_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peering_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels that can contain user-provided metadata
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of this Peering.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current status of this peering, if available.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_message", value)


@pulumi.input_type
class _PeeringState:
    def __init__(__self__, *,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Peering resources.
        :param pulumi.Input[_builtins.str] authorized_network: The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        :param pulumi.Input[_builtins.str] domain_resource: Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels that can contain user-provided metadata
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Unique name of the peering in this scope including projects and location using the form: projects/{projectId}/locations/global/peerings/{peeringId}.
        :param pulumi.Input[_builtins.str] peering_id: (Required)
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] status: The current state of this Peering.
        :param pulumi.Input[_builtins.str] status_message: Additional information about the current status of this peering, if available.
        """
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if domain_resource is not None:
            pulumi.set(__self__, "domain_resource", domain_resource)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_id is not None:
            pulumi.set(__self__, "peering_id", peering_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_network", value)

    @_builtins.property
    @pulumi.getter(name="domainResource")
    def domain_resource(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        """
        return pulumi.get(self, "domain_resource")

    @domain_resource.setter
    def domain_resource(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_resource", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels that can contain user-provided metadata
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name of the peering in this scope including projects and location using the form: projects/{projectId}/locations/global/peerings/{peeringId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peeringId")
    def peering_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required)
        """
        return pulumi.get(self, "peering_id")

    @peering_id.setter
    def peering_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of this Peering.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current status of this peering, if available.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_message", value)


@pulumi.type_token("gcp:activedirectory/peering:Peering")
class Peering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Peering for Managed AD instance.

        To get more information about Peering, see:

        * [API documentation](https://cloud.google.com/managed-microsoft-ad/reference/rest/v1beta1/projects.locations.global.peerings)
        * How-to Guides
            * [Active Directory Domain Peering](https://cloud.google.com/managed-microsoft-ad/docs/domain-peering)

        ## Example Usage

        ### Active Directory Peering Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_network = gcp.compute.Network("source-network", name="ad-network")
        ad_domain = gcp.activedirectory.Domain("ad-domain",
            domain_name="ad.test.hashicorptest.com",
            locations=["us-central1"],
            reserved_ip_range="192.168.255.0/24",
            authorized_networks=[source_network.id],
            deletion_protection=False)
        peered_project = gcp.organizations.Project("peered-project",
            name="my-peered-project",
            project_id="my-peered-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        compute = gcp.projects.Service("compute",
            project=peered_project.project_id,
            service="compute.googleapis.com")
        peered_network = gcp.compute.Network("peered-network",
            project=compute.project,
            name="ad-peered-network")
        ad_domain_peering = gcp.activedirectory.Peering("ad-domain-peering",
            domain_resource=ad_domain.name,
            peering_id="ad-domain-peering",
            authorized_network=peered_network.id,
            deletion_protection=False,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorized_network: The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        :param pulumi.Input[_builtins.str] domain_resource: Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels that can contain user-provided metadata
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] peering_id: (Required)
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] status: The current state of this Peering.
        :param pulumi.Input[_builtins.str] status_message: Additional information about the current status of this peering, if available.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Peering for Managed AD instance.

        To get more information about Peering, see:

        * [API documentation](https://cloud.google.com/managed-microsoft-ad/reference/rest/v1beta1/projects.locations.global.peerings)
        * How-to Guides
            * [Active Directory Domain Peering](https://cloud.google.com/managed-microsoft-ad/docs/domain-peering)

        ## Example Usage

        ### Active Directory Peering Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_network = gcp.compute.Network("source-network", name="ad-network")
        ad_domain = gcp.activedirectory.Domain("ad-domain",
            domain_name="ad.test.hashicorptest.com",
            locations=["us-central1"],
            reserved_ip_range="192.168.255.0/24",
            authorized_networks=[source_network.id],
            deletion_protection=False)
        peered_project = gcp.organizations.Project("peered-project",
            name="my-peered-project",
            project_id="my-peered-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        compute = gcp.projects.Service("compute",
            project=peered_project.project_id,
            service="compute.googleapis.com")
        peered_network = gcp.compute.Network("peered-network",
            project=compute.project,
            name="ad-peered-network")
        ad_domain_peering = gcp.activedirectory.Peering("ad-domain-peering",
            domain_resource=ad_domain.name,
            peering_id="ad-domain-peering",
            authorized_network=peered_network.id,
            deletion_protection=False,
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param PeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_resource: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_message: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringArgs.__new__(PeeringArgs)

            if authorized_network is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_network'")
            __props__.__dict__["authorized_network"] = authorized_network
            if domain_resource is None and not opts.urn:
                raise TypeError("Missing required property 'domain_resource'")
            __props__.__dict__["domain_resource"] = domain_resource
            __props__.__dict__["labels"] = labels
            if peering_id is None and not opts.urn:
                raise TypeError("Missing required property 'peering_id'")
            __props__.__dict__["peering_id"] = peering_id
            __props__.__dict__["project"] = project
            __props__.__dict__["status"] = status
            __props__.__dict__["status_message"] = status_message
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Peering, __self__).__init__(
            'gcp:activedirectory/peering:Peering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
            domain_resource: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peering_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_message: Optional[pulumi.Input[_builtins.str]] = None) -> 'Peering':
        """
        Get an existing Peering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorized_network: The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        :param pulumi.Input[_builtins.str] domain_resource: Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels that can contain user-provided metadata
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Unique name of the peering in this scope including projects and location using the form: projects/{projectId}/locations/global/peerings/{peeringId}.
        :param pulumi.Input[_builtins.str] peering_id: (Required)
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] status: The current state of this Peering.
        :param pulumi.Input[_builtins.str] status_message: Additional information about the current status of this peering, if available.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringState.__new__(_PeeringState)

        __props__.__dict__["authorized_network"] = authorized_network
        __props__.__dict__["domain_resource"] = domain_resource
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["peering_id"] = peering_id
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        return Peering(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[_builtins.str]:
        """
        The full names of the Google Compute Engine networks to which the instance is connected. Caller needs to make sure that CIDR subnets do not overlap between networks, else peering creation will fail.
        """
        return pulumi.get(self, "authorized_network")

    @_builtins.property
    @pulumi.getter(name="domainResource")
    def domain_resource(self) -> pulumi.Output[_builtins.str]:
        """
        Full domain resource path for the Managed AD Domain involved in peering. The resource path should be in the form projects/{projectId}/locations/global/domains/{domainName}
        """
        return pulumi.get(self, "domain_resource")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Resource labels that can contain user-provided metadata
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name of the peering in this scope including projects and location using the form: projects/{projectId}/locations/global/peerings/{peeringId}.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peeringId")
    def peering_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Required)
        """
        return pulumi.get(self, "peering_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The current state of this Peering.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional information about the current status of this peering, if available.
        """
        return pulumi.get(self, "status_message")

