# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupEncryptionConfig',
    'BackupEncryptionInfo',
    'BackupExpiryQuantity',
    'ClusterAutomatedBackupPolicy',
    'ClusterAutomatedBackupPolicyEncryptionConfig',
    'ClusterAutomatedBackupPolicyQuantityBasedRetention',
    'ClusterAutomatedBackupPolicyTimeBasedRetention',
    'ClusterAutomatedBackupPolicyWeeklySchedule',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTime',
    'ClusterBackupSource',
    'ClusterContinuousBackupConfig',
    'ClusterContinuousBackupConfigEncryptionConfig',
    'ClusterContinuousBackupInfo',
    'ClusterContinuousBackupInfoEncryptionInfo',
    'ClusterEncryptionConfig',
    'ClusterEncryptionInfo',
    'ClusterInitialUser',
    'ClusterMaintenanceUpdatePolicy',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindow',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime',
    'ClusterMigrationSource',
    'ClusterNetworkConfig',
    'ClusterPscConfig',
    'ClusterRestoreBackupSource',
    'ClusterRestoreContinuousBackupSource',
    'ClusterSecondaryConfig',
    'ClusterTrialMetadata',
    'InstanceClientConnectionConfig',
    'InstanceClientConnectionConfigSslConfig',
    'InstanceMachineConfig',
    'InstanceNetworkConfig',
    'InstanceNetworkConfigAuthorizedExternalNetwork',
    'InstanceObservabilityConfig',
    'InstancePscInstanceConfig',
    'InstancePscInstanceConfigPscAutoConnection',
    'InstancePscInstanceConfigPscInterfaceConfig',
    'InstanceQueryInsightsConfig',
    'InstanceReadPoolConfig',
    'GetClusterAutomatedBackupPolicyResult',
    'GetClusterAutomatedBackupPolicyEncryptionConfigResult',
    'GetClusterAutomatedBackupPolicyQuantityBasedRetentionResult',
    'GetClusterAutomatedBackupPolicyTimeBasedRetentionResult',
    'GetClusterAutomatedBackupPolicyWeeklyScheduleResult',
    'GetClusterAutomatedBackupPolicyWeeklyScheduleStartTimeResult',
    'GetClusterBackupSourceResult',
    'GetClusterContinuousBackupConfigResult',
    'GetClusterContinuousBackupConfigEncryptionConfigResult',
    'GetClusterContinuousBackupInfoResult',
    'GetClusterContinuousBackupInfoEncryptionInfoResult',
    'GetClusterEncryptionConfigResult',
    'GetClusterEncryptionInfoResult',
    'GetClusterInitialUserResult',
    'GetClusterMaintenanceUpdatePolicyResult',
    'GetClusterMaintenanceUpdatePolicyMaintenanceWindowResult',
    'GetClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeResult',
    'GetClusterMigrationSourceResult',
    'GetClusterNetworkConfigResult',
    'GetClusterPscConfigResult',
    'GetClusterRestoreBackupSourceResult',
    'GetClusterRestoreContinuousBackupSourceResult',
    'GetClusterSecondaryConfigResult',
    'GetClusterTrialMetadataResult',
    'GetInstanceClientConnectionConfigResult',
    'GetInstanceClientConnectionConfigSslConfigResult',
    'GetInstanceMachineConfigResult',
    'GetInstanceNetworkConfigResult',
    'GetInstanceNetworkConfigAuthorizedExternalNetworkResult',
    'GetInstanceObservabilityConfigResult',
    'GetInstancePscInstanceConfigResult',
    'GetInstancePscInstanceConfigPscAutoConnectionResult',
    'GetInstancePscInstanceConfigPscInterfaceConfigResult',
    'GetInstanceQueryInsightsConfigResult',
    'GetInstanceReadPoolConfigResult',
    'GetLocationsLocationResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
]

@pulumi.output_type
class BackupEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class BackupEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[_builtins.str] = None,
                 kms_key_versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[_builtins.str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class BackupExpiryQuantity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionCount":
            suggest = "retention_count"
        elif key == "totalRetentionCount":
            suggest = "total_retention_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupExpiryQuantity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupExpiryQuantity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupExpiryQuantity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_count: Optional[_builtins.int] = None,
                 total_retention_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int retention_count: (Output)
               Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        :param _builtins.int total_retention_count: (Output)
               Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        if retention_count is not None:
            pulumi.set(__self__, "retention_count", retention_count)
        if total_retention_count is not None:
            pulumi.set(__self__, "total_retention_count", total_retention_count)

    @_builtins.property
    @pulumi.getter(name="retentionCount")
    def retention_count(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        """
        return pulumi.get(self, "retention_count")

    @_builtins.property
    @pulumi.getter(name="totalRetentionCount")
    def total_retention_count(self) -> Optional[_builtins.int]:
        """
        (Output)
        Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        return pulumi.get(self, "total_retention_count")


@pulumi.output_type
class ClusterAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupWindow":
            suggest = "backup_window"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "quantityBasedRetention":
            suggest = "quantity_based_retention"
        elif key == "timeBasedRetention":
            suggest = "time_based_retention"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_window: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 encryption_config: Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig'] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 location: Optional[_builtins.str] = None,
                 quantity_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention'] = None,
                 time_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention'] = None,
                 weekly_schedule: Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule'] = None):
        """
        :param _builtins.str backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.bool enabled: Whether automated backups are enabled.
        :param 'ClusterAutomatedBackupPolicyEncryptionConfigArgs' encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param Mapping[str, _builtins.str] labels: Labels to apply to backups created using this configuration.
        :param _builtins.str location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param 'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs' quantity_based_retention: Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyTimeBasedRetentionArgs' time_based_retention: Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule for the Backup.
               Structure is documented below.
        """
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if quantity_based_retention is not None:
            pulumi.set(__self__, "quantity_based_retention", quantity_based_retention)
        if time_based_retention is not None:
            pulumi.set(__self__, "time_based_retention", time_based_retention)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @_builtins.property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[_builtins.str]:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="quantityBasedRetention")
    def quantity_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention']:
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "quantity_based_retention")

    @_builtins.property
    @pulumi.getter(name="timeBasedRetention")
    def time_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention']:
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "time_based_retention")

    @_builtins.property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule']:
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class ClusterAutomatedBackupPolicyEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterAutomatedBackupPolicyQuantityBasedRetention(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None):
        """
        :param _builtins.int count: The number of backups to retain.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class ClusterAutomatedBackupPolicyTimeBasedRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyTimeBasedRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: Optional[_builtins.str] = None):
        """
        :param _builtins.str retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[_builtins.str]:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimes":
            suggest = "start_times"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_times: Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime'],
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs'] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
               Structure is documented below.
        :param Sequence[_builtins.str] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        pulumi.set(__self__, "start_times", start_times)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @_builtins.property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime']:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        return pulumi.get(self, "start_times")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[_builtins.int] = None,
                 minutes: Optional[_builtins.int] = None,
                 nanos: Optional[_builtins.int] = None,
                 seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param _builtins.int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param _builtins.int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[_builtins.int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> Optional[_builtins.int]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> Optional[_builtins.int]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str backup_name: The name of the backup resource.
        """
        if backup_name is not None:
            pulumi.set(__self__, "backup_name", backup_name)

    @_builtins.property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> Optional[_builtins.str]:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterContinuousBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "recoveryWindowDays":
            suggest = "recovery_window_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 encryption_config: Optional['outputs.ClusterContinuousBackupConfigEncryptionConfig'] = None,
                 recovery_window_days: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Whether continuous backup recovery is enabled. If not set, defaults to true.
        :param 'ClusterContinuousBackupConfigEncryptionConfigArgs' encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param _builtins.int recovery_window_days: The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
               If not set, defaults to 14 days.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if recovery_window_days is not None:
            pulumi.set(__self__, "recovery_window_days", recovery_window_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether continuous backup recovery is enabled. If not set, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterContinuousBackupConfigEncryptionConfig']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @_builtins.property
    @pulumi.getter(name="recoveryWindowDays")
    def recovery_window_days(self) -> Optional[_builtins.int]:
        """
        The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
        If not set, defaults to 14 days.
        """
        return pulumi.get(self, "recovery_window_days")


@pulumi.output_type
class ClusterContinuousBackupConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterContinuousBackupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "earliestRestorableTime":
            suggest = "earliest_restorable_time"
        elif key == "enabledTime":
            suggest = "enabled_time"
        elif key == "encryptionInfos":
            suggest = "encryption_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 earliest_restorable_time: Optional[_builtins.str] = None,
                 enabled_time: Optional[_builtins.str] = None,
                 encryption_infos: Optional[Sequence['outputs.ClusterContinuousBackupInfoEncryptionInfo']] = None,
                 schedules: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str earliest_restorable_time: (Output)
               The earliest restorable time that can be restored to. Output only field.
        :param _builtins.str enabled_time: (Output)
               When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        :param Sequence['ClusterContinuousBackupInfoEncryptionInfoArgs'] encryption_infos: (Output)
               Output only. The encryption information for the WALs and backups required for ContinuousBackup.
               Structure is documented below.
        :param Sequence[_builtins.str] schedules: (Output)
               Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        if earliest_restorable_time is not None:
            pulumi.set(__self__, "earliest_restorable_time", earliest_restorable_time)
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if encryption_infos is not None:
            pulumi.set(__self__, "encryption_infos", encryption_infos)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)

    @_builtins.property
    @pulumi.getter(name="earliestRestorableTime")
    def earliest_restorable_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The earliest restorable time that can be restored to. Output only field.
        """
        return pulumi.get(self, "earliest_restorable_time")

    @_builtins.property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        """
        return pulumi.get(self, "enabled_time")

    @_builtins.property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> Optional[Sequence['outputs.ClusterContinuousBackupInfoEncryptionInfo']]:
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_infos")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        return pulumi.get(self, "schedules")


@pulumi.output_type
class ClusterContinuousBackupInfoEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupInfoEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupInfoEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupInfoEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[_builtins.str] = None,
                 kms_key_versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[_builtins.str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[_builtins.str] = None,
                 kms_key_versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[_builtins.str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterInitialUser(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param _builtins.str user: The database username.
        """
        pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindows":
            suggest = "maintenance_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintenance_windows: Optional[Sequence['outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindow']] = None):
        """
        :param Sequence['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs'] maintenance_windows: Preferred windows to perform maintenance. Currently limited to 1.
               Structure is documented below.
        """
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[Sequence['outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindow']]:
        """
        Preferred windows to perform maintenance. Currently limited to 1.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_windows")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceUpdatePolicyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceUpdatePolicyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceUpdatePolicyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: _builtins.str,
                 start_time: 'outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime'):
        """
        :param _builtins.str day: Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
               Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs' start_time: Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime':
        """
        Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: Optional[_builtins.int] = None,
                 nanos: Optional[_builtins.int] = None,
                 seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param _builtins.int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param _builtins.int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> Optional[_builtins.int]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> Optional[_builtins.int]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterMigrationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPort":
            suggest = "host_port"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMigrationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_port: Optional[_builtins.str] = None,
                 reference_id: Optional[_builtins.str] = None,
                 source_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_port: The host and port of the on-premises instance in host:port format
        :param _builtins.str reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param _builtins.str source_type: Type of migration source.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[_builtins.str]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @_builtins.property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[_builtins.str]:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[_builtins.str]:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class ClusterNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
               If set, the instance IPs for this cluster will be created in the allocated range.
        :param _builtins.str network: The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[_builtins.str]:
        """
        The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
        If set, the instance IPs for this cluster will be created in the allocated range.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscEnabled":
            suggest = "psc_enabled"
        elif key == "serviceOwnedProjectNumber":
            suggest = "service_owned_project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 psc_enabled: Optional[_builtins.bool] = None,
                 service_owned_project_number: Optional[_builtins.int] = None):
        """
        :param _builtins.bool psc_enabled: Create an instance that allows connections from Private Service Connect endpoints to the instance.
        :param _builtins.int service_owned_project_number: (Output)
               The project number that needs to be allowlisted on the network attachment to enable outbound connectivity, if the network attachment is configured to ACCEPT_MANUAL connections.
               In case the network attachment is configured to ACCEPT_AUTOMATIC, this project number does not need to be allowlisted explicitly.
        """
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)
        if service_owned_project_number is not None:
            pulumi.set(__self__, "service_owned_project_number", service_owned_project_number)

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[_builtins.bool]:
        """
        Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        return pulumi.get(self, "psc_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceOwnedProjectNumber")
    def service_owned_project_number(self) -> Optional[_builtins.int]:
        """
        (Output)
        The project number that needs to be allowlisted on the network attachment to enable outbound connectivity, if the network attachment is configured to ACCEPT_MANUAL connections.
        In case the network attachment is configured to ACCEPT_AUTOMATIC, this project number does not need to be allowlisted explicitly.
        """
        return pulumi.get(self, "service_owned_project_number")


@pulumi.output_type
class ClusterRestoreBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: _builtins.str):
        """
        :param _builtins.str backup_name: The name of the backup that this cluster is restored from.
        """
        pulumi.set(__self__, "backup_name", backup_name)

    @_builtins.property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> _builtins.str:
        """
        The name of the backup that this cluster is restored from.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterRestoreContinuousBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTime":
            suggest = "point_in_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreContinuousBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreContinuousBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreContinuousBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: _builtins.str,
                 point_in_time: _builtins.str):
        """
        :param _builtins.str cluster: The name of the source cluster that this cluster is restored from.
        :param _builtins.str point_in_time: The point in time that this cluster is restored to, in RFC 3339 format.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "point_in_time", point_in_time)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        The name of the source cluster that this cluster is restored from.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> _builtins.str:
        """
        The point in time that this cluster is restored to, in RFC 3339 format.
        """
        return pulumi.get(self, "point_in_time")


@pulumi.output_type
class ClusterSecondaryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryClusterName":
            suggest = "primary_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSecondaryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSecondaryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSecondaryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_cluster_name: _builtins.str):
        """
        :param _builtins.str primary_cluster_name: Name of the primary cluster must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "primary_cluster_name", primary_cluster_name)

    @_builtins.property
    @pulumi.getter(name="primaryClusterName")
    def primary_cluster_name(self) -> _builtins.str:
        """
        Name of the primary cluster must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "primary_cluster_name")


@pulumi.output_type
class ClusterTrialMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "graceEndTime":
            suggest = "grace_end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "upgradeTime":
            suggest = "upgrade_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrialMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrialMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrialMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 grace_end_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None,
                 upgrade_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: End time of the trial cluster.
        :param _builtins.str grace_end_time: Grace end time of the trial cluster.
        :param _builtins.str start_time: Start time of the trial cluster.
        :param _builtins.str upgrade_time: Upgrade time of the trial cluster to standard cluster.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if grace_end_time is not None:
            pulumi.set(__self__, "grace_end_time", grace_end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        End time of the trial cluster.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="graceEndTime")
    def grace_end_time(self) -> Optional[_builtins.str]:
        """
        Grace end time of the trial cluster.
        """
        return pulumi.get(self, "grace_end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Start time of the trial cluster.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[_builtins.str]:
        """
        Upgrade time of the trial cluster to standard cluster.
        """
        return pulumi.get(self, "upgrade_time")


@pulumi.output_type
class InstanceClientConnectionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requireConnectors":
            suggest = "require_connectors"
        elif key == "sslConfig":
            suggest = "ssl_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClientConnectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClientConnectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClientConnectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 require_connectors: Optional[_builtins.bool] = None,
                 ssl_config: Optional['outputs.InstanceClientConnectionConfigSslConfig'] = None):
        """
        :param _builtins.bool require_connectors: Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        :param 'InstanceClientConnectionConfigSslConfigArgs' ssl_config: SSL config option for this instance.
               Structure is documented below.
        """
        if require_connectors is not None:
            pulumi.set(__self__, "require_connectors", require_connectors)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @_builtins.property
    @pulumi.getter(name="requireConnectors")
    def require_connectors(self) -> Optional[_builtins.bool]:
        """
        Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        """
        return pulumi.get(self, "require_connectors")

    @_builtins.property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional['outputs.InstanceClientConnectionConfigSslConfig']:
        """
        SSL config option for this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")


@pulumi.output_type
class InstanceClientConnectionConfigSslConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClientConnectionConfigSslConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClientConnectionConfigSslConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClientConnectionConfigSslConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssl_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str ssl_mode: SSL mode. Specifies client-server SSL/TLS connection behavior.
               Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[_builtins.str]:
        """
        SSL mode. Specifies client-server SSL/TLS connection behavior.
        Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class InstanceMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[_builtins.int] = None,
                 machine_type: Optional[_builtins.str] = None):
        """
        :param _builtins.int cpu_count: The number of CPU's in the VM instance.
        :param _builtins.str machine_type: Machine type of the VM instance.
               E.g. "n2-highmem-4", "n2-highmem-8", "c4a-highmem-4-lssd".
               `cpu_count` must match the number of vCPUs in the machine type.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[_builtins.int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        Machine type of the VM instance.
        E.g. "n2-highmem-4", "n2-highmem-8", "c4a-highmem-4-lssd".
        `cpu_count` must match the number of vCPUs in the machine type.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class InstanceNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRangeOverride":
            suggest = "allocated_ip_range_override"
        elif key == "authorizedExternalNetworks":
            suggest = "authorized_external_networks"
        elif key == "enableOutboundPublicIp":
            suggest = "enable_outbound_public_ip"
        elif key == "enablePublicIp":
            suggest = "enable_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range_override: Optional[_builtins.str] = None,
                 authorized_external_networks: Optional[Sequence['outputs.InstanceNetworkConfigAuthorizedExternalNetwork']] = None,
                 enable_outbound_public_ip: Optional[_builtins.bool] = None,
                 enable_public_ip: Optional[_builtins.bool] = None):
        """
        :param _builtins.str allocated_ip_range_override: Name of the allocated IP range for the private IP AlloyDB instance, for example: "google-managed-services-default".
               If set, the instance IPs will be created from this allocated range and will override the IP range used by the parent cluster.
               The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence['InstanceNetworkConfigAuthorizedExternalNetworkArgs'] authorized_external_networks: A list of external networks authorized to access this instance. This
               field is only allowed to be set when `enable_public_ip` is set to
               true.
               Structure is documented below.
        :param _builtins.bool enable_outbound_public_ip: Enabling outbound public ip for the instance.
        :param _builtins.bool enable_public_ip: Enabling public ip for the instance. If a user wishes to disable this,
               please also clear the list of the authorized external networks set on
               the same instance.
        """
        if allocated_ip_range_override is not None:
            pulumi.set(__self__, "allocated_ip_range_override", allocated_ip_range_override)
        if authorized_external_networks is not None:
            pulumi.set(__self__, "authorized_external_networks", authorized_external_networks)
        if enable_outbound_public_ip is not None:
            pulumi.set(__self__, "enable_outbound_public_ip", enable_outbound_public_ip)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRangeOverride")
    def allocated_ip_range_override(self) -> Optional[_builtins.str]:
        """
        Name of the allocated IP range for the private IP AlloyDB instance, for example: "google-managed-services-default".
        If set, the instance IPs will be created from this allocated range and will override the IP range used by the parent cluster.
        The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range_override")

    @_builtins.property
    @pulumi.getter(name="authorizedExternalNetworks")
    def authorized_external_networks(self) -> Optional[Sequence['outputs.InstanceNetworkConfigAuthorizedExternalNetwork']]:
        """
        A list of external networks authorized to access this instance. This
        field is only allowed to be set when `enable_public_ip` is set to
        true.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_external_networks")

    @_builtins.property
    @pulumi.getter(name="enableOutboundPublicIp")
    def enable_outbound_public_ip(self) -> Optional[_builtins.bool]:
        """
        Enabling outbound public ip for the instance.
        """
        return pulumi.get(self, "enable_outbound_public_ip")

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[_builtins.bool]:
        """
        Enabling public ip for the instance. If a user wishes to disable this,
        please also clear the list of the authorized external networks set on
        the same instance.
        """
        return pulumi.get(self, "enable_public_ip")


@pulumi.output_type
class InstanceNetworkConfigAuthorizedExternalNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrRange":
            suggest = "cidr_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfigAuthorizedExternalNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfigAuthorizedExternalNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfigAuthorizedExternalNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_range: Optional[_builtins.str] = None):
        """
        :param _builtins.str cidr_range: CIDR range for one authorized network of the instance.
        """
        if cidr_range is not None:
            pulumi.set(__self__, "cidr_range", cidr_range)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> Optional[_builtins.str]:
        """
        CIDR range for one authorized network of the instance.
        """
        return pulumi.get(self, "cidr_range")


@pulumi.output_type
class InstanceObservabilityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assistiveExperiencesEnabled":
            suggest = "assistive_experiences_enabled"
        elif key == "maxQueryStringLength":
            suggest = "max_query_string_length"
        elif key == "preserveComments":
            suggest = "preserve_comments"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "trackActiveQueries":
            suggest = "track_active_queries"
        elif key == "trackWaitEventTypes":
            suggest = "track_wait_event_types"
        elif key == "trackWaitEvents":
            suggest = "track_wait_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceObservabilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceObservabilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceObservabilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assistive_experiences_enabled: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 max_query_string_length: Optional[_builtins.int] = None,
                 preserve_comments: Optional[_builtins.bool] = None,
                 query_plans_per_minute: Optional[_builtins.int] = None,
                 record_application_tags: Optional[_builtins.bool] = None,
                 track_active_queries: Optional[_builtins.bool] = None,
                 track_wait_event_types: Optional[_builtins.bool] = None,
                 track_wait_events: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool assistive_experiences_enabled: Whether assistive experiences are enabled for this AlloyDB instance.
        :param _builtins.bool enabled: Observability feature status for an instance.
        :param _builtins.int max_query_string_length: Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        :param _builtins.bool preserve_comments: Preserve comments in the query string.
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        :param _builtins.bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param _builtins.bool track_active_queries: Track actively running queries. If not set, default value is "off".
        :param _builtins.bool track_wait_event_types: Record wait event types during query execution for an instance.
        :param _builtins.bool track_wait_events: Record wait events during query execution for an instance.
        """
        if assistive_experiences_enabled is not None:
            pulumi.set(__self__, "assistive_experiences_enabled", assistive_experiences_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_query_string_length is not None:
            pulumi.set(__self__, "max_query_string_length", max_query_string_length)
        if preserve_comments is not None:
            pulumi.set(__self__, "preserve_comments", preserve_comments)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if track_active_queries is not None:
            pulumi.set(__self__, "track_active_queries", track_active_queries)
        if track_wait_event_types is not None:
            pulumi.set(__self__, "track_wait_event_types", track_wait_event_types)
        if track_wait_events is not None:
            pulumi.set(__self__, "track_wait_events", track_wait_events)

    @_builtins.property
    @pulumi.getter(name="assistiveExperiencesEnabled")
    def assistive_experiences_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether assistive experiences are enabled for this AlloyDB instance.
        """
        return pulumi.get(self, "assistive_experiences_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Observability feature status for an instance.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="maxQueryStringLength")
    def max_query_string_length(self) -> Optional[_builtins.int]:
        """
        Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        """
        return pulumi.get(self, "max_query_string_length")

    @_builtins.property
    @pulumi.getter(name="preserveComments")
    def preserve_comments(self) -> Optional[_builtins.bool]:
        """
        Preserve comments in the query string.
        """
        return pulumi.get(self, "preserve_comments")

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[_builtins.int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[_builtins.bool]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="trackActiveQueries")
    def track_active_queries(self) -> Optional[_builtins.bool]:
        """
        Track actively running queries. If not set, default value is "off".
        """
        return pulumi.get(self, "track_active_queries")

    @_builtins.property
    @pulumi.getter(name="trackWaitEventTypes")
    def track_wait_event_types(self) -> Optional[_builtins.bool]:
        """
        Record wait event types during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_event_types")

    @_builtins.property
    @pulumi.getter(name="trackWaitEvents")
    def track_wait_events(self) -> Optional[_builtins.bool]:
        """
        Record wait events during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_events")


@pulumi.output_type
class InstancePscInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedConsumerProjects":
            suggest = "allowed_consumer_projects"
        elif key == "pscAutoConnections":
            suggest = "psc_auto_connections"
        elif key == "pscDnsName":
            suggest = "psc_dns_name"
        elif key == "pscInterfaceConfigs":
            suggest = "psc_interface_configs"
        elif key == "serviceAttachmentLink":
            suggest = "service_attachment_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[Sequence[_builtins.str]] = None,
                 psc_auto_connections: Optional[Sequence['outputs.InstancePscInstanceConfigPscAutoConnection']] = None,
                 psc_dns_name: Optional[_builtins.str] = None,
                 psc_interface_configs: Optional[Sequence['outputs.InstancePscInstanceConfigPscInterfaceConfig']] = None,
                 service_attachment_link: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] allowed_consumer_projects: List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
               These should be specified as project numbers only.
        :param Sequence['InstancePscInstanceConfigPscAutoConnectionArgs'] psc_auto_connections: Configurations for setting up PSC service automation.
               Structure is documented below.
        :param _builtins.str psc_dns_name: (Output)
               The DNS name of the instance for PSC connectivity.
               Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        :param Sequence['InstancePscInstanceConfigPscInterfaceConfigArgs'] psc_interface_configs: Configurations for setting up PSC interfaces attached to the instance
               which are used for outbound connectivity. Currently, AlloyDB supports only 0 or 1 PSC interface.
               Structure is documented below.
        :param _builtins.str service_attachment_link: (Output)
               The service attachment created when Private Service Connect (PSC) is enabled for the instance.
               The name of the resource will be in the format of
               `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if psc_auto_connections is not None:
            pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        if psc_dns_name is not None:
            pulumi.set(__self__, "psc_dns_name", psc_dns_name)
        if psc_interface_configs is not None:
            pulumi.set(__self__, "psc_interface_configs", psc_interface_configs)
        if service_attachment_link is not None:
            pulumi.set(__self__, "service_attachment_link", service_attachment_link)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
        These should be specified as project numbers only.
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Optional[Sequence['outputs.InstancePscInstanceConfigPscAutoConnection']]:
        """
        Configurations for setting up PSC service automation.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pscDnsName")
    def psc_dns_name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The DNS name of the instance for PSC connectivity.
        Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        """
        return pulumi.get(self, "psc_dns_name")

    @_builtins.property
    @pulumi.getter(name="pscInterfaceConfigs")
    def psc_interface_configs(self) -> Optional[Sequence['outputs.InstancePscInstanceConfigPscInterfaceConfig']]:
        """
        Configurations for setting up PSC interfaces attached to the instance
        which are used for outbound connectivity. Currently, AlloyDB supports only 0 or 1 PSC interface.
        Structure is documented below.
        """
        return pulumi.get(self, "psc_interface_configs")

    @_builtins.property
    @pulumi.getter(name="serviceAttachmentLink")
    def service_attachment_link(self) -> Optional[_builtins.str]:
        """
        (Output)
        The service attachment created when Private Service Connect (PSC) is enabled for the instance.
        The name of the resource will be in the format of
        `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        return pulumi.get(self, "service_attachment_link")


@pulumi.output_type
class InstancePscInstanceConfigPscAutoConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerNetwork":
            suggest = "consumer_network"
        elif key == "consumerNetworkStatus":
            suggest = "consumer_network_status"
        elif key == "consumerProject":
            suggest = "consumer_project"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscInstanceConfigPscAutoConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscInstanceConfigPscAutoConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscInstanceConfigPscAutoConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_network: Optional[_builtins.str] = None,
                 consumer_network_status: Optional[_builtins.str] = None,
                 consumer_project: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str consumer_network: The consumer network for the PSC service automation, example:
               "projects/vpc-host-project/global/networks/default".
               The consumer network might be hosted a different project than the
               consumer project. The API expects the consumer project specified to be
               the project ID (and not the project number)
        :param _builtins.str consumer_network_status: (Output)
               The status of the service connection policy.
        :param _builtins.str consumer_project: The consumer project to which the PSC service automation endpoint will
               be created. The API expects the consumer project to be the project ID(
               and not the project number).
        :param _builtins.str ip_address: (Output)
               The IP address of the PSC service automation endpoint.
        :param _builtins.str status: (Output)
               The status of the PSC service automation connection.
        """
        if consumer_network is not None:
            pulumi.set(__self__, "consumer_network", consumer_network)
        if consumer_network_status is not None:
            pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        if consumer_project is not None:
            pulumi.set(__self__, "consumer_project", consumer_project)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> Optional[_builtins.str]:
        """
        The consumer network for the PSC service automation, example:
        "projects/vpc-host-project/global/networks/default".
        The consumer network might be hosted a different project than the
        consumer project. The API expects the consumer project specified to be
        the project ID (and not the project number)
        """
        return pulumi.get(self, "consumer_network")

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> Optional[_builtins.str]:
        """
        (Output)
        The status of the service connection policy.
        """
        return pulumi.get(self, "consumer_network_status")

    @_builtins.property
    @pulumi.getter(name="consumerProject")
    def consumer_project(self) -> Optional[_builtins.str]:
        """
        The consumer project to which the PSC service automation endpoint will
        be created. The API expects the consumer project to be the project ID(
        and not the project number).
        """
        return pulumi.get(self, "consumer_project")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        (Output)
        The IP address of the PSC service automation endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Output)
        The status of the PSC service automation connection.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstancePscInstanceConfigPscInterfaceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAttachmentResource":
            suggest = "network_attachment_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscInstanceConfigPscInterfaceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscInstanceConfigPscInterfaceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscInstanceConfigPscInterfaceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_attachment_resource: Optional[_builtins.str] = None):
        """
        :param _builtins.str network_attachment_resource: The network attachment resource created in the consumer project to which the PSC interface will be linked.
               This is of the format: "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".
               The network attachment must be in the same region as the instance.
        """
        if network_attachment_resource is not None:
            pulumi.set(__self__, "network_attachment_resource", network_attachment_resource)

    @_builtins.property
    @pulumi.getter(name="networkAttachmentResource")
    def network_attachment_resource(self) -> Optional[_builtins.str]:
        """
        The network attachment resource created in the consumer project to which the PSC interface will be linked.
        This is of the format: "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".
        The network attachment must be in the same region as the instance.
        """
        return pulumi.get(self, "network_attachment_resource")


@pulumi.output_type
class InstanceQueryInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceQueryInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceQueryInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceQueryInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_plans_per_minute: Optional[_builtins.int] = None,
                 query_string_length: Optional[_builtins.int] = None,
                 record_application_tags: Optional[_builtins.bool] = None,
                 record_client_address: Optional[_builtins.bool] = None):
        """
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        :param _builtins.int query_string_length: Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        :param _builtins.bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param _builtins.bool record_client_address: Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[_builtins.int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[_builtins.int]:
        """
        Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        """
        return pulumi.get(self, "query_string_length")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[_builtins.bool]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[_builtins.bool]:
        """
        Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class InstanceReadPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReadPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[_builtins.int]:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyResult(dict):
    def __init__(__self__, *,
                 backup_window: _builtins.str,
                 enabled: _builtins.bool,
                 encryption_configs: Sequence['outputs.GetClusterAutomatedBackupPolicyEncryptionConfigResult'],
                 labels: Mapping[str, _builtins.str],
                 location: _builtins.str,
                 quantity_based_retentions: Sequence['outputs.GetClusterAutomatedBackupPolicyQuantityBasedRetentionResult'],
                 time_based_retentions: Sequence['outputs.GetClusterAutomatedBackupPolicyTimeBasedRetentionResult'],
                 weekly_schedules: Sequence['outputs.GetClusterAutomatedBackupPolicyWeeklyScheduleResult']):
        """
        :param _builtins.str backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.bool enabled: Whether automated backups are enabled.
        :param Sequence['GetClusterAutomatedBackupPolicyEncryptionConfigArgs'] encryption_configs: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        :param Mapping[str, _builtins.str] labels: Labels to apply to backups created using this configuration.
        :param _builtins.str location: (optional)
               The canonical id of the location.If it is not provided, the provider project is used. For example: us-east1.
        :param Sequence['GetClusterAutomatedBackupPolicyQuantityBasedRetentionArgs'] quantity_based_retentions: Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        :param Sequence['GetClusterAutomatedBackupPolicyTimeBasedRetentionArgs'] time_based_retentions: Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        :param Sequence['GetClusterAutomatedBackupPolicyWeeklyScheduleArgs'] weekly_schedules: Weekly schedule for the Backup.
        """
        pulumi.set(__self__, "backup_window", backup_window)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "encryption_configs", encryption_configs)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "quantity_based_retentions", quantity_based_retentions)
        pulumi.set(__self__, "time_based_retentions", time_based_retentions)
        pulumi.set(__self__, "weekly_schedules", weekly_schedules)

    @_builtins.property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> _builtins.str:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.

        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionConfigs")
    def encryption_configs(self) -> Sequence['outputs.GetClusterAutomatedBackupPolicyEncryptionConfigResult']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        """
        return pulumi.get(self, "encryption_configs")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        (optional)
        The canonical id of the location.If it is not provided, the provider project is used. For example: us-east1.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="quantityBasedRetentions")
    def quantity_based_retentions(self) -> Sequence['outputs.GetClusterAutomatedBackupPolicyQuantityBasedRetentionResult']:
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        """
        return pulumi.get(self, "quantity_based_retentions")

    @_builtins.property
    @pulumi.getter(name="timeBasedRetentions")
    def time_based_retentions(self) -> Sequence['outputs.GetClusterAutomatedBackupPolicyTimeBasedRetentionResult']:
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        """
        return pulumi.get(self, "time_based_retentions")

    @_builtins.property
    @pulumi.getter(name="weeklySchedules")
    def weekly_schedules(self) -> Sequence['outputs.GetClusterAutomatedBackupPolicyWeeklyScheduleResult']:
        """
        Weekly schedule for the Backup.
        """
        return pulumi.get(self, "weekly_schedules")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyQuantityBasedRetentionResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int):
        """
        :param _builtins.int count: The number of backups to retain.
        """
        pulumi.set(__self__, "count", count)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyTimeBasedRetentionResult(dict):
    def __init__(__self__, *,
                 retention_period: _builtins.str):
        """
        :param _builtins.str retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.str:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyWeeklyScheduleResult(dict):
    def __init__(__self__, *,
                 days_of_weeks: Sequence[_builtins.str],
                 start_times: Sequence['outputs.GetClusterAutomatedBackupPolicyWeeklyScheduleStartTimeResult']):
        """
        :param Sequence[_builtins.str] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param Sequence['GetClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs'] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        """
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "start_times", start_times)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence[_builtins.str]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetClusterAutomatedBackupPolicyWeeklyScheduleStartTimeResult']:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetClusterAutomatedBackupPolicyWeeklyScheduleStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: _builtins.int,
                 nanos: _builtins.int,
                 seconds: _builtins.int):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param _builtins.int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param _builtins.int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> _builtins.int:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> _builtins.int:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetClusterBackupSourceResult(dict):
    def __init__(__self__, *,
                 backup_name: _builtins.str):
        """
        :param _builtins.str backup_name: The name of the backup resource.
        """
        pulumi.set(__self__, "backup_name", backup_name)

    @_builtins.property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> _builtins.str:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class GetClusterContinuousBackupConfigResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 encryption_configs: Sequence['outputs.GetClusterContinuousBackupConfigEncryptionConfigResult'],
                 recovery_window_days: _builtins.int):
        """
        :param _builtins.bool enabled: Whether continuous backup recovery is enabled. If not set, defaults to true.
        :param Sequence['GetClusterContinuousBackupConfigEncryptionConfigArgs'] encryption_configs: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        :param _builtins.int recovery_window_days: The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
               
               If not set, defaults to 14 days.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "encryption_configs", encryption_configs)
        pulumi.set(__self__, "recovery_window_days", recovery_window_days)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether continuous backup recovery is enabled. If not set, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionConfigs")
    def encryption_configs(self) -> Sequence['outputs.GetClusterContinuousBackupConfigEncryptionConfigResult']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        """
        return pulumi.get(self, "encryption_configs")

    @_builtins.property
    @pulumi.getter(name="recoveryWindowDays")
    def recovery_window_days(self) -> _builtins.int:
        """
        The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.

        If not set, defaults to 14 days.
        """
        return pulumi.get(self, "recovery_window_days")


@pulumi.output_type
class GetClusterContinuousBackupConfigEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetClusterContinuousBackupInfoResult(dict):
    def __init__(__self__, *,
                 earliest_restorable_time: _builtins.str,
                 enabled_time: _builtins.str,
                 encryption_infos: Sequence['outputs.GetClusterContinuousBackupInfoEncryptionInfoResult'],
                 schedules: Sequence[_builtins.str]):
        """
        :param _builtins.str earliest_restorable_time: The earliest restorable time that can be restored to. Output only field.
        :param _builtins.str enabled_time: When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        :param Sequence['GetClusterContinuousBackupInfoEncryptionInfoArgs'] encryption_infos: Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        :param Sequence[_builtins.str] schedules: Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        pulumi.set(__self__, "earliest_restorable_time", earliest_restorable_time)
        pulumi.set(__self__, "enabled_time", enabled_time)
        pulumi.set(__self__, "encryption_infos", encryption_infos)
        pulumi.set(__self__, "schedules", schedules)

    @_builtins.property
    @pulumi.getter(name="earliestRestorableTime")
    def earliest_restorable_time(self) -> _builtins.str:
        """
        The earliest restorable time that can be restored to. Output only field.
        """
        return pulumi.get(self, "earliest_restorable_time")

    @_builtins.property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> _builtins.str:
        """
        When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        """
        return pulumi.get(self, "enabled_time")

    @_builtins.property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> Sequence['outputs.GetClusterContinuousBackupInfoEncryptionInfoResult']:
        """
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        """
        return pulumi.get(self, "encryption_infos")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Sequence[_builtins.str]:
        """
        Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        return pulumi.get(self, "schedules")


@pulumi.output_type
class GetClusterContinuousBackupInfoEncryptionInfoResult(dict):
    def __init__(__self__, *,
                 encryption_type: _builtins.str,
                 kms_key_versions: Sequence[_builtins.str]):
        """
        :param _builtins.str encryption_type: Output only. Type of encryption.
        :param Sequence[_builtins.str] kms_key_versions: Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Sequence[_builtins.str]:
        """
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class GetClusterEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str):
        """
        :param _builtins.str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetClusterEncryptionInfoResult(dict):
    def __init__(__self__, *,
                 encryption_type: _builtins.str,
                 kms_key_versions: Sequence[_builtins.str]):
        """
        :param _builtins.str encryption_type: Output only. Type of encryption.
        :param Sequence[_builtins.str] kms_key_versions: Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Sequence[_builtins.str]:
        """
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class GetClusterInitialUserResult(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 user: _builtins.str):
        """
        :param _builtins.str password: The initial password for the user.
        :param _builtins.str user: The database username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The initial password for the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        The database username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetClusterMaintenanceUpdatePolicyResult(dict):
    def __init__(__self__, *,
                 maintenance_windows: Sequence['outputs.GetClusterMaintenanceUpdatePolicyMaintenanceWindowResult']):
        """
        :param Sequence['GetClusterMaintenanceUpdatePolicyMaintenanceWindowArgs'] maintenance_windows: Preferred windows to perform maintenance. Currently limited to 1.
        """
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetClusterMaintenanceUpdatePolicyMaintenanceWindowResult']:
        """
        Preferred windows to perform maintenance. Currently limited to 1.
        """
        return pulumi.get(self, "maintenance_windows")


@pulumi.output_type
class GetClusterMaintenanceUpdatePolicyMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: _builtins.str,
                 start_times: Sequence['outputs.GetClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeResult']):
        """
        :param _builtins.str day: Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        :param Sequence['GetClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs'] start_times: Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_times", start_times)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.GetClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeResult']:
        """
        Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        """
        return pulumi.get(self, "start_times")


@pulumi.output_type
class GetClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: _builtins.int,
                 nanos: _builtins.int,
                 seconds: _builtins.int):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param _builtins.int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param _builtins.int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> _builtins.int:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> _builtins.int:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class GetClusterMigrationSourceResult(dict):
    def __init__(__self__, *,
                 host_port: _builtins.str,
                 reference_id: _builtins.str,
                 source_type: _builtins.str):
        """
        :param _builtins.str host_port: The host and port of the on-premises instance in host:port format
        :param _builtins.str reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param _builtins.str source_type: Type of migration source.
        """
        pulumi.set(__self__, "host_port", host_port)
        pulumi.set(__self__, "reference_id", reference_id)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> _builtins.str:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @_builtins.property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> _builtins.str:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetClusterNetworkConfigResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: _builtins.str,
                 network: _builtins.str):
        """
        :param _builtins.str allocated_ip_range: The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
               If set, the instance IPs for this cluster will be created in the allocated range.
        :param _builtins.str network: The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> _builtins.str:
        """
        The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
        If set, the instance IPs for this cluster will be created in the allocated range.
        """
        return pulumi.get(self, "allocated_ip_range")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetClusterPscConfigResult(dict):
    def __init__(__self__, *,
                 psc_enabled: _builtins.bool,
                 service_owned_project_number: _builtins.int):
        """
        :param _builtins.bool psc_enabled: Create an instance that allows connections from Private Service Connect endpoints to the instance.
        :param _builtins.int service_owned_project_number: The project number that needs to be allowlisted on the network attachment to enable outbound connectivity, if the network attachment is configured to ACCEPT_MANUAL connections.
               In case the network attachment is configured to ACCEPT_AUTOMATIC, this project number does not need to be allowlisted explicitly.
        """
        pulumi.set(__self__, "psc_enabled", psc_enabled)
        pulumi.set(__self__, "service_owned_project_number", service_owned_project_number)

    @_builtins.property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> _builtins.bool:
        """
        Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        return pulumi.get(self, "psc_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceOwnedProjectNumber")
    def service_owned_project_number(self) -> _builtins.int:
        """
        The project number that needs to be allowlisted on the network attachment to enable outbound connectivity, if the network attachment is configured to ACCEPT_MANUAL connections.
        In case the network attachment is configured to ACCEPT_AUTOMATIC, this project number does not need to be allowlisted explicitly.
        """
        return pulumi.get(self, "service_owned_project_number")


@pulumi.output_type
class GetClusterRestoreBackupSourceResult(dict):
    def __init__(__self__, *,
                 backup_name: _builtins.str):
        """
        :param _builtins.str backup_name: The name of the backup that this cluster is restored from.
        """
        pulumi.set(__self__, "backup_name", backup_name)

    @_builtins.property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> _builtins.str:
        """
        The name of the backup that this cluster is restored from.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class GetClusterRestoreContinuousBackupSourceResult(dict):
    def __init__(__self__, *,
                 cluster: _builtins.str,
                 point_in_time: _builtins.str):
        """
        :param _builtins.str cluster: The name of the source cluster that this cluster is restored from.
        :param _builtins.str point_in_time: The point in time that this cluster is restored to, in RFC 3339 format.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "point_in_time", point_in_time)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> _builtins.str:
        """
        The name of the source cluster that this cluster is restored from.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> _builtins.str:
        """
        The point in time that this cluster is restored to, in RFC 3339 format.
        """
        return pulumi.get(self, "point_in_time")


@pulumi.output_type
class GetClusterSecondaryConfigResult(dict):
    def __init__(__self__, *,
                 primary_cluster_name: _builtins.str):
        """
        :param _builtins.str primary_cluster_name: Name of the primary cluster must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "primary_cluster_name", primary_cluster_name)

    @_builtins.property
    @pulumi.getter(name="primaryClusterName")
    def primary_cluster_name(self) -> _builtins.str:
        """
        Name of the primary cluster must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "primary_cluster_name")


@pulumi.output_type
class GetClusterTrialMetadataResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 grace_end_time: _builtins.str,
                 start_time: _builtins.str,
                 upgrade_time: _builtins.str):
        """
        :param _builtins.str end_time: End time of the trial cluster.
        :param _builtins.str grace_end_time: Grace end time of the trial cluster.
        :param _builtins.str start_time: Start time of the trial cluster.
        :param _builtins.str upgrade_time: Upgrade time of the trial cluster to standard cluster.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "grace_end_time", grace_end_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "upgrade_time", upgrade_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        End time of the trial cluster.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="graceEndTime")
    def grace_end_time(self) -> _builtins.str:
        """
        Grace end time of the trial cluster.
        """
        return pulumi.get(self, "grace_end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start time of the trial cluster.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> _builtins.str:
        """
        Upgrade time of the trial cluster to standard cluster.
        """
        return pulumi.get(self, "upgrade_time")


@pulumi.output_type
class GetInstanceClientConnectionConfigResult(dict):
    def __init__(__self__, *,
                 require_connectors: _builtins.bool,
                 ssl_configs: Sequence['outputs.GetInstanceClientConnectionConfigSslConfigResult']):
        """
        :param _builtins.bool require_connectors: Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        :param Sequence['GetInstanceClientConnectionConfigSslConfigArgs'] ssl_configs: SSL config option for this instance.
        """
        pulumi.set(__self__, "require_connectors", require_connectors)
        pulumi.set(__self__, "ssl_configs", ssl_configs)

    @_builtins.property
    @pulumi.getter(name="requireConnectors")
    def require_connectors(self) -> _builtins.bool:
        """
        Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        """
        return pulumi.get(self, "require_connectors")

    @_builtins.property
    @pulumi.getter(name="sslConfigs")
    def ssl_configs(self) -> Sequence['outputs.GetInstanceClientConnectionConfigSslConfigResult']:
        """
        SSL config option for this instance.
        """
        return pulumi.get(self, "ssl_configs")


@pulumi.output_type
class GetInstanceClientConnectionConfigSslConfigResult(dict):
    def __init__(__self__, *,
                 ssl_mode: _builtins.str):
        """
        :param _builtins.str ssl_mode: SSL mode. Specifies client-server SSL/TLS connection behavior. Possible values: ["ENCRYPTED_ONLY", "ALLOW_UNENCRYPTED_AND_ENCRYPTED"]
        """
        pulumi.set(__self__, "ssl_mode", ssl_mode)

    @_builtins.property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> _builtins.str:
        """
        SSL mode. Specifies client-server SSL/TLS connection behavior. Possible values: ["ENCRYPTED_ONLY", "ALLOW_UNENCRYPTED_AND_ENCRYPTED"]
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class GetInstanceMachineConfigResult(dict):
    def __init__(__self__, *,
                 cpu_count: _builtins.int,
                 machine_type: _builtins.str):
        """
        :param _builtins.int cpu_count: The number of CPU's in the VM instance.
        :param _builtins.str machine_type: Machine type of the VM instance.
               E.g. "n2-highmem-4", "n2-highmem-8", "c4a-highmem-4-lssd".
               'cpu_count' must match the number of vCPUs in the machine type.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "machine_type", machine_type)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> _builtins.int:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        Machine type of the VM instance.
        E.g. "n2-highmem-4", "n2-highmem-8", "c4a-highmem-4-lssd".
        'cpu_count' must match the number of vCPUs in the machine type.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class GetInstanceNetworkConfigResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range_override: _builtins.str,
                 authorized_external_networks: Sequence['outputs.GetInstanceNetworkConfigAuthorizedExternalNetworkResult'],
                 enable_outbound_public_ip: _builtins.bool,
                 enable_public_ip: _builtins.bool):
        """
        :param _builtins.str allocated_ip_range_override: Name of the allocated IP range for the private IP AlloyDB instance, for example: "google-managed-services-default".
               If set, the instance IPs will be created from this allocated range and will override the IP range used by the parent cluster.
               The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param Sequence['GetInstanceNetworkConfigAuthorizedExternalNetworkArgs'] authorized_external_networks: A list of external networks authorized to access this instance. This
               field is only allowed to be set when 'enable_public_ip' is set to
               true.
        :param _builtins.bool enable_outbound_public_ip: Enabling outbound public ip for the instance.
        :param _builtins.bool enable_public_ip: Enabling public ip for the instance. If a user wishes to disable this,
               please also clear the list of the authorized external networks set on
               the same instance.
        """
        pulumi.set(__self__, "allocated_ip_range_override", allocated_ip_range_override)
        pulumi.set(__self__, "authorized_external_networks", authorized_external_networks)
        pulumi.set(__self__, "enable_outbound_public_ip", enable_outbound_public_ip)
        pulumi.set(__self__, "enable_public_ip", enable_public_ip)

    @_builtins.property
    @pulumi.getter(name="allocatedIpRangeOverride")
    def allocated_ip_range_override(self) -> _builtins.str:
        """
        Name of the allocated IP range for the private IP AlloyDB instance, for example: "google-managed-services-default".
        If set, the instance IPs will be created from this allocated range and will override the IP range used by the parent cluster.
        The range name must comply with RFC 1035. Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range_override")

    @_builtins.property
    @pulumi.getter(name="authorizedExternalNetworks")
    def authorized_external_networks(self) -> Sequence['outputs.GetInstanceNetworkConfigAuthorizedExternalNetworkResult']:
        """
        A list of external networks authorized to access this instance. This
        field is only allowed to be set when 'enable_public_ip' is set to
        true.
        """
        return pulumi.get(self, "authorized_external_networks")

    @_builtins.property
    @pulumi.getter(name="enableOutboundPublicIp")
    def enable_outbound_public_ip(self) -> _builtins.bool:
        """
        Enabling outbound public ip for the instance.
        """
        return pulumi.get(self, "enable_outbound_public_ip")

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> _builtins.bool:
        """
        Enabling public ip for the instance. If a user wishes to disable this,
        please also clear the list of the authorized external networks set on
        the same instance.
        """
        return pulumi.get(self, "enable_public_ip")


@pulumi.output_type
class GetInstanceNetworkConfigAuthorizedExternalNetworkResult(dict):
    def __init__(__self__, *,
                 cidr_range: _builtins.str):
        """
        :param _builtins.str cidr_range: CIDR range for one authorized network of the instance.
        """
        pulumi.set(__self__, "cidr_range", cidr_range)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> _builtins.str:
        """
        CIDR range for one authorized network of the instance.
        """
        return pulumi.get(self, "cidr_range")


@pulumi.output_type
class GetInstanceObservabilityConfigResult(dict):
    def __init__(__self__, *,
                 assistive_experiences_enabled: _builtins.bool,
                 enabled: _builtins.bool,
                 max_query_string_length: _builtins.int,
                 preserve_comments: _builtins.bool,
                 query_plans_per_minute: _builtins.int,
                 record_application_tags: _builtins.bool,
                 track_active_queries: _builtins.bool,
                 track_wait_event_types: _builtins.bool,
                 track_wait_events: _builtins.bool):
        """
        :param _builtins.bool assistive_experiences_enabled: Whether assistive experiences are enabled for this AlloyDB instance.
        :param _builtins.bool enabled: Observability feature status for an instance.
        :param _builtins.int max_query_string_length: Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        :param _builtins.bool preserve_comments: Preserve comments in the query string.
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        :param _builtins.bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param _builtins.bool track_active_queries: Track actively running queries. If not set, default value is "off".
        :param _builtins.bool track_wait_event_types: Record wait event types during query execution for an instance.
        :param _builtins.bool track_wait_events: Record wait events during query execution for an instance.
        """
        pulumi.set(__self__, "assistive_experiences_enabled", assistive_experiences_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "max_query_string_length", max_query_string_length)
        pulumi.set(__self__, "preserve_comments", preserve_comments)
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "track_active_queries", track_active_queries)
        pulumi.set(__self__, "track_wait_event_types", track_wait_event_types)
        pulumi.set(__self__, "track_wait_events", track_wait_events)

    @_builtins.property
    @pulumi.getter(name="assistiveExperiencesEnabled")
    def assistive_experiences_enabled(self) -> _builtins.bool:
        """
        Whether assistive experiences are enabled for this AlloyDB instance.
        """
        return pulumi.get(self, "assistive_experiences_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Observability feature status for an instance.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="maxQueryStringLength")
    def max_query_string_length(self) -> _builtins.int:
        """
        Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        """
        return pulumi.get(self, "max_query_string_length")

    @_builtins.property
    @pulumi.getter(name="preserveComments")
    def preserve_comments(self) -> _builtins.bool:
        """
        Preserve comments in the query string.
        """
        return pulumi.get(self, "preserve_comments")

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> _builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> _builtins.bool:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="trackActiveQueries")
    def track_active_queries(self) -> _builtins.bool:
        """
        Track actively running queries. If not set, default value is "off".
        """
        return pulumi.get(self, "track_active_queries")

    @_builtins.property
    @pulumi.getter(name="trackWaitEventTypes")
    def track_wait_event_types(self) -> _builtins.bool:
        """
        Record wait event types during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_event_types")

    @_builtins.property
    @pulumi.getter(name="trackWaitEvents")
    def track_wait_events(self) -> _builtins.bool:
        """
        Record wait events during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_events")


@pulumi.output_type
class GetInstancePscInstanceConfigResult(dict):
    def __init__(__self__, *,
                 allowed_consumer_projects: Sequence[_builtins.str],
                 psc_auto_connections: Sequence['outputs.GetInstancePscInstanceConfigPscAutoConnectionResult'],
                 psc_dns_name: _builtins.str,
                 psc_interface_configs: Sequence['outputs.GetInstancePscInstanceConfigPscInterfaceConfigResult'],
                 service_attachment_link: _builtins.str):
        """
        :param Sequence[_builtins.str] allowed_consumer_projects: List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
               These should be specified as project numbers only.
        :param Sequence['GetInstancePscInstanceConfigPscAutoConnectionArgs'] psc_auto_connections: Configurations for setting up PSC service automation.
        :param _builtins.str psc_dns_name: The DNS name of the instance for PSC connectivity.
               Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        :param Sequence['GetInstancePscInstanceConfigPscInterfaceConfigArgs'] psc_interface_configs: Configurations for setting up PSC interfaces attached to the instance
               which are used for outbound connectivity. Currently, AlloyDB supports only 0 or 1 PSC interface.
        :param _builtins.str service_attachment_link: The service attachment created when Private Service Connect (PSC) is enabled for the instance.
               The name of the resource will be in the format of
               'projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>'
        """
        pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        pulumi.set(__self__, "psc_auto_connections", psc_auto_connections)
        pulumi.set(__self__, "psc_dns_name", psc_dns_name)
        pulumi.set(__self__, "psc_interface_configs", psc_interface_configs)
        pulumi.set(__self__, "service_attachment_link", service_attachment_link)

    @_builtins.property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Sequence[_builtins.str]:
        """
        List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
        These should be specified as project numbers only.
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @_builtins.property
    @pulumi.getter(name="pscAutoConnections")
    def psc_auto_connections(self) -> Sequence['outputs.GetInstancePscInstanceConfigPscAutoConnectionResult']:
        """
        Configurations for setting up PSC service automation.
        """
        return pulumi.get(self, "psc_auto_connections")

    @_builtins.property
    @pulumi.getter(name="pscDnsName")
    def psc_dns_name(self) -> _builtins.str:
        """
        The DNS name of the instance for PSC connectivity.
        Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        """
        return pulumi.get(self, "psc_dns_name")

    @_builtins.property
    @pulumi.getter(name="pscInterfaceConfigs")
    def psc_interface_configs(self) -> Sequence['outputs.GetInstancePscInstanceConfigPscInterfaceConfigResult']:
        """
        Configurations for setting up PSC interfaces attached to the instance
        which are used for outbound connectivity. Currently, AlloyDB supports only 0 or 1 PSC interface.
        """
        return pulumi.get(self, "psc_interface_configs")

    @_builtins.property
    @pulumi.getter(name="serviceAttachmentLink")
    def service_attachment_link(self) -> _builtins.str:
        """
        The service attachment created when Private Service Connect (PSC) is enabled for the instance.
        The name of the resource will be in the format of
        'projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>'
        """
        return pulumi.get(self, "service_attachment_link")


@pulumi.output_type
class GetInstancePscInstanceConfigPscAutoConnectionResult(dict):
    def __init__(__self__, *,
                 consumer_network: _builtins.str,
                 consumer_network_status: _builtins.str,
                 consumer_project: _builtins.str,
                 ip_address: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str consumer_network: The consumer network for the PSC service automation, example:
               "projects/vpc-host-project/global/networks/default".
               The consumer network might be hosted a different project than the
               consumer project. The API expects the consumer project specified to be
               the project ID (and not the project number)
        :param _builtins.str consumer_network_status: The status of the service connection policy.
        :param _builtins.str consumer_project: The consumer project to which the PSC service automation endpoint will
               be created. The API expects the consumer project to be the project ID(
               and not the project number).
        :param _builtins.str ip_address: The IP address of the PSC service automation endpoint.
        :param _builtins.str status: The status of the PSC service automation connection.
        """
        pulumi.set(__self__, "consumer_network", consumer_network)
        pulumi.set(__self__, "consumer_network_status", consumer_network_status)
        pulumi.set(__self__, "consumer_project", consumer_project)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="consumerNetwork")
    def consumer_network(self) -> _builtins.str:
        """
        The consumer network for the PSC service automation, example:
        "projects/vpc-host-project/global/networks/default".
        The consumer network might be hosted a different project than the
        consumer project. The API expects the consumer project specified to be
        the project ID (and not the project number)
        """
        return pulumi.get(self, "consumer_network")

    @_builtins.property
    @pulumi.getter(name="consumerNetworkStatus")
    def consumer_network_status(self) -> _builtins.str:
        """
        The status of the service connection policy.
        """
        return pulumi.get(self, "consumer_network_status")

    @_builtins.property
    @pulumi.getter(name="consumerProject")
    def consumer_project(self) -> _builtins.str:
        """
        The consumer project to which the PSC service automation endpoint will
        be created. The API expects the consumer project to be the project ID(
        and not the project number).
        """
        return pulumi.get(self, "consumer_project")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address of the PSC service automation endpoint.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the PSC service automation connection.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancePscInstanceConfigPscInterfaceConfigResult(dict):
    def __init__(__self__, *,
                 network_attachment_resource: _builtins.str):
        """
        :param _builtins.str network_attachment_resource: The network attachment resource created in the consumer project to which the PSC interface will be linked.
               This is of the format: "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".
               The network attachment must be in the same region as the instance.
        """
        pulumi.set(__self__, "network_attachment_resource", network_attachment_resource)

    @_builtins.property
    @pulumi.getter(name="networkAttachmentResource")
    def network_attachment_resource(self) -> _builtins.str:
        """
        The network attachment resource created in the consumer project to which the PSC interface will be linked.
        This is of the format: "projects/${CONSUMER_PROJECT}/regions/${REGION}/networkAttachments/${NETWORK_ATTACHMENT_NAME}".
        The network attachment must be in the same region as the instance.
        """
        return pulumi.get(self, "network_attachment_resource")


@pulumi.output_type
class GetInstanceQueryInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_plans_per_minute: _builtins.int,
                 query_string_length: _builtins.int,
                 record_application_tags: _builtins.bool,
                 record_client_address: _builtins.bool):
        """
        :param _builtins.int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        :param _builtins.int query_string_length: Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        :param _builtins.bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param _builtins.bool record_client_address: Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @_builtins.property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> _builtins.int:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @_builtins.property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> _builtins.int:
        """
        Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        """
        return pulumi.get(self, "query_string_length")

    @_builtins.property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> _builtins.bool:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @_builtins.property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> _builtins.bool:
        """
        Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetInstanceReadPoolConfigResult(dict):
    def __init__(__self__, *,
                 node_count: _builtins.int):
        """
        :param _builtins.int node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        pulumi.set(__self__, "node_count", node_count)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 location_id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str):
        """
        :param _builtins.str display_name: The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        :param Mapping[str, _builtins.str] labels: Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        :param _builtins.str location_id: The canonical id for this location. For example: "us-east1"..
        :param Mapping[str, _builtins.str] metadata: Service-specific metadata. For example the available capacity at the given location.
        :param _builtins.str name: Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> _builtins.str:
        """
        The canonical id for this location. For example: "us-east1"..
        """
        return pulumi.get(self, "location_id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Service-specific metadata. For example the available capacity at the given location.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 accepts_multiple_values: _builtins.bool,
                 flag_name: _builtins.str,
                 integer_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
                 name: _builtins.str,
                 requires_db_restart: _builtins.bool,
                 string_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
                 supported_db_versions: Sequence[_builtins.str],
                 value_type: _builtins.str):
        """
        :param _builtins.bool accepts_multiple_values: Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        :param _builtins.str flag_name: The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsArgs' integer_restrictions: Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        :param _builtins.str name: The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        :param _builtins.bool requires_db_restart: Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsArgs' string_restrictions: Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        :param Sequence[_builtins.str] supported_db_versions: Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        :param _builtins.str value_type: ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        pulumi.set(__self__, "accepts_multiple_values", accepts_multiple_values)
        pulumi.set(__self__, "flag_name", flag_name)
        pulumi.set(__self__, "integer_restrictions", integer_restrictions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "requires_db_restart", requires_db_restart)
        pulumi.set(__self__, "string_restrictions", string_restrictions)
        pulumi.set(__self__, "supported_db_versions", supported_db_versions)
        pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter(name="acceptsMultipleValues")
    def accepts_multiple_values(self) -> _builtins.bool:
        """
        Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        """
        return pulumi.get(self, "accepts_multiple_values")

    @_builtins.property
    @pulumi.getter(name="flagName")
    def flag_name(self) -> _builtins.str:
        """
        The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        """
        return pulumi.get(self, "flag_name")

    @_builtins.property
    @pulumi.getter(name="integerRestrictions")
    def integer_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult':
        """
        Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        """
        return pulumi.get(self, "integer_restrictions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="requiresDbRestart")
    def requires_db_restart(self) -> _builtins.bool:
        """
        Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        """
        return pulumi.get(self, "requires_db_restart")

    @_builtins.property
    @pulumi.getter(name="stringRestrictions")
    def string_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult':
        """
        Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        return pulumi.get(self, "string_restrictions")

    @_builtins.property
    @pulumi.getter(name="supportedDbVersions")
    def supported_db_versions(self) -> Sequence[_builtins.str]:
        """
        Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        """
        return pulumi.get(self, "supported_db_versions")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult(dict):
    def __init__(__self__, *,
                 max_value: _builtins.str,
                 min_value: _builtins.str):
        """
        :param _builtins.str max_value: The maximum value that can be specified, if applicable.
        :param _builtins.str min_value: The minimum value that can be specified, if applicable.
        """
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)

    @_builtins.property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> _builtins.str:
        """
        The maximum value that can be specified, if applicable.
        """
        return pulumi.get(self, "max_value")

    @_builtins.property
    @pulumi.getter(name="minValue")
    def min_value(self) -> _builtins.str:
        """
        The minimum value that can be specified, if applicable.
        """
        return pulumi.get(self, "min_value")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult(dict):
    def __init__(__self__, *,
                 allowed_values: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_values: The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)

    @_builtins.property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Sequence[_builtins.str]:
        """
        The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        return pulumi.get(self, "allowed_values")


