# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApiDeploymentArgs', 'ApiDeployment']

@pulumi.input_type
class ApiDeploymentArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 proxy_id: pulumi.Input[_builtins.str],
                 revision: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ApiDeployment resource.
        :param pulumi.Input[_builtins.str] environment: The Apigee Environment associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] proxy_id: The Apigee API associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] revision: The revision of the API proxy to be deployed.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "proxy_id", proxy_id)
        pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Environment associated with the Apigee API deployment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee API deployment.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee API associated with the Apigee API deployment.
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "proxy_id", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Input[_builtins.str]:
        """
        The revision of the API proxy to be deployed.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class _ApiDeploymentState:
    def __init__(__self__, *,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiDeployment resources.
        :param pulumi.Input[_builtins.str] environment: The Apigee Environment associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] proxy_id: The Apigee API associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] revision: The revision of the API proxy to be deployed.
        """
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if proxy_id is not None:
            pulumi.set(__self__, "proxy_id", proxy_id)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Environment associated with the Apigee API deployment.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee API deployment.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee API associated with the Apigee API deployment.
        """
        return pulumi.get(self, "proxy_id")

    @proxy_id.setter
    def proxy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_id", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The revision of the API proxy to be deployed.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision", value)


@pulumi.type_token("gcp:apigee/apiDeployment:ApiDeployment")
class ApiDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a deployment of an API proxy.

        To get more information about ApiDeployment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.apis.revisions.deployments)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/apigee/docs/api-platform/deploy/ui-deploy-overview)

        ## Example Usage

        ## Import

        ApiDeployment can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}/deployments`

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}`

        * `{{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}/deployments`

        * `{{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}`

        When using the `pulumi import` command, ApiDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}/deployments
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default {{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}/deployments
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default {{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] environment: The Apigee Environment associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] proxy_id: The Apigee API associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] revision: The revision of the API proxy to be deployed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a deployment of an API proxy.

        To get more information about ApiDeployment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.apis.revisions.deployments)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/apigee/docs/api-platform/deploy/ui-deploy-overview)

        ## Example Usage

        ## Import

        ApiDeployment can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}/deployments`

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}`

        * `{{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}/deployments`

        * `{{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}`

        When using the `pulumi import` command, ApiDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}/deployments
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{proxy_id}}/revisions/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default {{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}/deployments
        ```

        ```sh
        $ pulumi import gcp:apigee/apiDeployment:ApiDeployment default {{org_id}}/{{environment}}/{{proxy_id}}/{{revision}}
        ```

        :param str resource_name: The name of the resource.
        :param ApiDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiDeploymentArgs.__new__(ApiDeploymentArgs)

            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if proxy_id is None and not opts.urn:
                raise TypeError("Missing required property 'proxy_id'")
            __props__.__dict__["proxy_id"] = proxy_id
            if revision is None and not opts.urn:
                raise TypeError("Missing required property 'revision'")
            __props__.__dict__["revision"] = revision
        super(ApiDeployment, __self__).__init__(
            'gcp:apigee/apiDeployment:ApiDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_id: Optional[pulumi.Input[_builtins.str]] = None,
            revision: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiDeployment':
        """
        Get an existing ApiDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] environment: The Apigee Environment associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] proxy_id: The Apigee API associated with the Apigee API deployment.
        :param pulumi.Input[_builtins.str] revision: The revision of the API proxy to be deployed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiDeploymentState.__new__(_ApiDeploymentState)

        __props__.__dict__["environment"] = environment
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["proxy_id"] = proxy_id
        __props__.__dict__["revision"] = revision
        return ApiDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Environment associated with the Apigee API deployment.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee API deployment.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="proxyId")
    def proxy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee API associated with the Apigee API deployment.
        """
        return pulumi.get(self, "proxy_id")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Output[_builtins.str]:
        """
        The revision of the API proxy to be deployed.
        """
        return pulumi.get(self, "revision")

