# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiProductArgs', 'ApiProduct']

@pulumi.input_type
class ApiProductArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approval_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']] = None,
                 grpc_operation_group: Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_group: Optional[pulumi.Input['ApiProductOperationGroupArgs']] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_counter_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 space: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApiProduct resource.
        :param pulumi.Input[_builtins.str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API product,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_resources: Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
               The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        :param pulumi.Input[_builtins.str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product.
               Valid values are `auto` or `manual`.
               Possible values are: `auto`, `manual`.
        :param pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
               Use this property to specify the access level of the API product as either public, private, or internal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description of the API product. Include key information about the API product that is not captured by other fields.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
               By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        :param pulumi.Input['ApiProductGraphqlOperationGroupArgs'] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
               Structure is documented below.
        :param pulumi.Input['ApiProductGrpcOperationGroupArgs'] grpc_operation_group: Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Internal name of the API product.
        :param pulumi.Input['ApiProductOperationGroupArgs'] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
               Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
               Apigee rejects requests to API proxies that are not listed.
        :param pulumi.Input[_builtins.str] quota: Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
               For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[_builtins.str] quota_counter_scope: Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
               Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        :param pulumi.Input[_builtins.str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[_builtins.str] quota_time_unit: Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        :param pulumi.Input[_builtins.str] space: Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "org_id", org_id)
        if api_resources is not None:
            pulumi.set(__self__, "api_resources", api_resources)
        if approval_type is not None:
            pulumi.set(__self__, "approval_type", approval_type)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if graphql_operation_group is not None:
            pulumi.set(__self__, "graphql_operation_group", graphql_operation_group)
        if grpc_operation_group is not None:
            pulumi.set(__self__, "grpc_operation_group", grpc_operation_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation_group is not None:
            pulumi.set(__self__, "operation_group", operation_group)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if quota_counter_scope is not None:
            pulumi.set(__self__, "quota_counter_scope", quota_counter_scope)
        if quota_interval is not None:
            pulumi.set(__self__, "quota_interval", quota_interval)
        if quota_time_unit is not None:
            pulumi.set(__self__, "quota_time_unit", quota_time_unit)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if space is not None:
            pulumi.set(__self__, "space", space)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name displayed in the UI or developer portal to developers registering for API access.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee API product,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="apiResources")
    def api_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
        The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        """
        return pulumi.get(self, "api_resources")

    @api_resources.setter
    def api_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_resources", value)

    @_builtins.property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flag that specifies how API keys are approved to access the APIs defined by the API product.
        Valid values are `auto` or `manual`.
        Possible values are: `auto`, `manual`.
        """
        return pulumi.get(self, "approval_type")

    @approval_type.setter
    def approval_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_type", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]]:
        """
        Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
        Use this property to specify the access level of the API product as either public, private, or internal.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the API product. Include key information about the API product that is not captured by other fields.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
        By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environments", value)

    @_builtins.property
    @pulumi.getter(name="graphqlOperationGroup")
    def graphql_operation_group(self) -> Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        Structure is documented below.
        """
        return pulumi.get(self, "graphql_operation_group")

    @graphql_operation_group.setter
    def graphql_operation_group(self, value: Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']]):
        pulumi.set(self, "graphql_operation_group", value)

    @_builtins.property
    @pulumi.getter(name="grpcOperationGroup")
    def grpc_operation_group(self) -> Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']]:
        """
        Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_operation_group")

    @grpc_operation_group.setter
    def grpc_operation_group(self, value: Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']]):
        pulumi.set(self, "grpc_operation_group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internal name of the API product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operationGroup")
    def operation_group(self) -> Optional[pulumi.Input['ApiProductOperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
        Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "operation_group")

    @operation_group.setter
    def operation_group(self, value: Optional[pulumi.Input['ApiProductOperationGroupArgs']]):
        pulumi.set(self, "operation_group", value)

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
        Apigee rejects requests to API proxies that are not listed.
        """
        return pulumi.get(self, "proxies")

    @proxies.setter
    def proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "proxies", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
        For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota", value)

    @_builtins.property
    @pulumi.getter(name="quotaCounterScope")
    def quota_counter_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
        Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        """
        return pulumi.get(self, "quota_counter_scope")

    @quota_counter_scope.setter
    def quota_counter_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_counter_scope", value)

    @_builtins.property
    @pulumi.getter(name="quotaInterval")
    def quota_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "quota_interval")

    @quota_interval.setter
    def quota_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_interval", value)

    @_builtins.property
    @pulumi.getter(name="quotaTimeUnit")
    def quota_time_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        """
        return pulumi.get(self, "quota_time_unit")

    @quota_time_unit.setter
    def quota_time_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_time_unit", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def space(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        return pulumi.get(self, "space")

    @space.setter
    def space(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space", value)


@pulumi.input_type
class _ApiProductState:
    def __init__(__self__, *,
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approval_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']] = None,
                 grpc_operation_group: Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']] = None,
                 last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_group: Optional[pulumi.Input['ApiProductOperationGroupArgs']] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_counter_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 space: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiProduct resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_resources: Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
               The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        :param pulumi.Input[_builtins.str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product.
               Valid values are `auto` or `manual`.
               Possible values are: `auto`, `manual`.
        :param pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
               Use this property to specify the access level of the API product as either public, private, or internal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] created_at: Response only. Creation time of this environment as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] description: Description of the API product. Include key information about the API product that is not captured by other fields.
        :param pulumi.Input[_builtins.str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
               By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        :param pulumi.Input['ApiProductGraphqlOperationGroupArgs'] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
               Structure is documented below.
        :param pulumi.Input['ApiProductGrpcOperationGroupArgs'] grpc_operation_group: Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_modified_at: Response only. Modified time of this environment as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Internal name of the API product.
        :param pulumi.Input['ApiProductOperationGroupArgs'] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
               Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API product,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
               Apigee rejects requests to API proxies that are not listed.
        :param pulumi.Input[_builtins.str] quota: Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
               For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[_builtins.str] quota_counter_scope: Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
               Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        :param pulumi.Input[_builtins.str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[_builtins.str] quota_time_unit: Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        :param pulumi.Input[_builtins.str] space: Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        if api_resources is not None:
            pulumi.set(__self__, "api_resources", api_resources)
        if approval_type is not None:
            pulumi.set(__self__, "approval_type", approval_type)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if graphql_operation_group is not None:
            pulumi.set(__self__, "graphql_operation_group", graphql_operation_group)
        if grpc_operation_group is not None:
            pulumi.set(__self__, "grpc_operation_group", grpc_operation_group)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation_group is not None:
            pulumi.set(__self__, "operation_group", operation_group)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if proxies is not None:
            pulumi.set(__self__, "proxies", proxies)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if quota_counter_scope is not None:
            pulumi.set(__self__, "quota_counter_scope", quota_counter_scope)
        if quota_interval is not None:
            pulumi.set(__self__, "quota_interval", quota_interval)
        if quota_time_unit is not None:
            pulumi.set(__self__, "quota_time_unit", quota_time_unit)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if space is not None:
            pulumi.set(__self__, "space", space)

    @_builtins.property
    @pulumi.getter(name="apiResources")
    def api_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
        The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        """
        return pulumi.get(self, "api_resources")

    @api_resources.setter
    def api_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_resources", value)

    @_builtins.property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flag that specifies how API keys are approved to access the APIs defined by the API product.
        Valid values are `auto` or `manual`.
        Possible values are: `auto`, `manual`.
        """
        return pulumi.get(self, "approval_type")

    @approval_type.setter
    def approval_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_type", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]]:
        """
        Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
        Use this property to specify the access level of the API product as either public, private, or internal.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiProductAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response only. Creation time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the API product. Include key information about the API product that is not captured by other fields.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name displayed in the UI or developer portal to developers registering for API access.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
        By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environments", value)

    @_builtins.property
    @pulumi.getter(name="graphqlOperationGroup")
    def graphql_operation_group(self) -> Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        Structure is documented below.
        """
        return pulumi.get(self, "graphql_operation_group")

    @graphql_operation_group.setter
    def graphql_operation_group(self, value: Optional[pulumi.Input['ApiProductGraphqlOperationGroupArgs']]):
        pulumi.set(self, "graphql_operation_group", value)

    @_builtins.property
    @pulumi.getter(name="grpcOperationGroup")
    def grpc_operation_group(self) -> Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']]:
        """
        Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_operation_group")

    @grpc_operation_group.setter
    def grpc_operation_group(self, value: Optional[pulumi.Input['ApiProductGrpcOperationGroupArgs']]):
        pulumi.set(self, "grpc_operation_group", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response only. Modified time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internal name of the API product.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="operationGroup")
    def operation_group(self) -> Optional[pulumi.Input['ApiProductOperationGroupArgs']]:
        """
        Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
        Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "operation_group")

    @operation_group.setter
    def operation_group(self, value: Optional[pulumi.Input['ApiProductOperationGroupArgs']]):
        pulumi.set(self, "operation_group", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee API product,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
        Apigee rejects requests to API proxies that are not listed.
        """
        return pulumi.get(self, "proxies")

    @proxies.setter
    def proxies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "proxies", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
        For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota", value)

    @_builtins.property
    @pulumi.getter(name="quotaCounterScope")
    def quota_counter_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
        Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        """
        return pulumi.get(self, "quota_counter_scope")

    @quota_counter_scope.setter
    def quota_counter_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_counter_scope", value)

    @_builtins.property
    @pulumi.getter(name="quotaInterval")
    def quota_interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "quota_interval")

    @quota_interval.setter
    def quota_interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_interval", value)

    @_builtins.property
    @pulumi.getter(name="quotaTimeUnit")
    def quota_time_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        """
        return pulumi.get(self, "quota_time_unit")

    @quota_time_unit.setter
    def quota_time_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota_time_unit", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def space(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        return pulumi.get(self, "space")

    @space.setter
    def space(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space", value)


@pulumi.type_token("gcp:apigee/apiProduct:ApiProduct")
class ApiProduct(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approval_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiProductAttributeArgs', 'ApiProductAttributeArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input[Union['ApiProductGraphqlOperationGroupArgs', 'ApiProductGraphqlOperationGroupArgsDict']]] = None,
                 grpc_operation_group: Optional[pulumi.Input[Union['ApiProductGrpcOperationGroupArgs', 'ApiProductGrpcOperationGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_group: Optional[pulumi.Input[Union['ApiProductOperationGroupArgs', 'ApiProductOperationGroupArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_counter_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 space: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An `ApiProduct` in Apigee.

        To get more information about ApiProduct, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.apiproducts#ApiProduct)
        * How-to Guides
            * [Creating an API product](https://cloud.google.com/apigee/docs/api-platform/publish/what-api-product)

        ## Example Usage

        ### Apigee Api Product Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        basic_api_product = gcp.apigee.ApiProduct("basic_api_product",
            org_id=apigee_org.id,
            name="my-product",
            display_name="My Basic API Product",
            approval_type="auto",
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee Api Product With Legacy Operation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        full_api_product = gcp.apigee.ApiProduct("full_api_product",
            org_id=apigee_org.id,
            name="my-product",
            display_name="My full API Product",
            approval_type="auto",
            description="This is a sample API Product created with Terraform.",
            attributes=[{
                "name": "access",
                "value": "private",
            }],
            environments=[
                "dev",
                "hom",
            ],
            proxies=["hello-world"],
            api_resources=[
                "/",
                "/weather/**",
            ],
            scopes=[
                "read:weather",
                "write:reports",
            ],
            quota="10000",
            quota_interval="1",
            quota_time_unit="day",
            quota_counter_scope="PROXY",
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ## Import

        ApiProduct can be imported using any of these accepted formats:

        * `{{org_id}}/apiproducts/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, ApiProduct can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/apiProduct:ApiProduct default {{org_id}}/apiproducts/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/apiProduct:ApiProduct default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_resources: Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
               The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        :param pulumi.Input[_builtins.str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product.
               Valid values are `auto` or `manual`.
               Possible values are: `auto`, `manual`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiProductAttributeArgs', 'ApiProductAttributeArgsDict']]]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
               Use this property to specify the access level of the API product as either public, private, or internal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Description of the API product. Include key information about the API product that is not captured by other fields.
        :param pulumi.Input[_builtins.str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
               By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        :param pulumi.Input[Union['ApiProductGraphqlOperationGroupArgs', 'ApiProductGraphqlOperationGroupArgsDict']] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
               Structure is documented below.
        :param pulumi.Input[Union['ApiProductGrpcOperationGroupArgs', 'ApiProductGrpcOperationGroupArgsDict']] grpc_operation_group: Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Internal name of the API product.
        :param pulumi.Input[Union['ApiProductOperationGroupArgs', 'ApiProductOperationGroupArgsDict']] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
               Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API product,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
               Apigee rejects requests to API proxies that are not listed.
        :param pulumi.Input[_builtins.str] quota: Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
               For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[_builtins.str] quota_counter_scope: Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
               Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        :param pulumi.Input[_builtins.str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[_builtins.str] quota_time_unit: Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        :param pulumi.Input[_builtins.str] space: Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiProductArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `ApiProduct` in Apigee.

        To get more information about ApiProduct, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.apiproducts#ApiProduct)
        * How-to Guides
            * [Creating an API product](https://cloud.google.com/apigee/docs/api-platform/publish/what-api-product)

        ## Example Usage

        ### Apigee Api Product Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        basic_api_product = gcp.apigee.ApiProduct("basic_api_product",
            org_id=apigee_org.id,
            name="my-product",
            display_name="My Basic API Product",
            approval_type="auto",
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ### Apigee Api Product With Legacy Operation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="my-instance",
            location="us-central1",
            org_id=apigee_org.id,
            peering_cidr_range="SLASH_22")
        full_api_product = gcp.apigee.ApiProduct("full_api_product",
            org_id=apigee_org.id,
            name="my-product",
            display_name="My full API Product",
            approval_type="auto",
            description="This is a sample API Product created with Terraform.",
            attributes=[{
                "name": "access",
                "value": "private",
            }],
            environments=[
                "dev",
                "hom",
            ],
            proxies=["hello-world"],
            api_resources=[
                "/",
                "/weather/**",
            ],
            scopes=[
                "read:weather",
                "write:reports",
            ],
            quota="10000",
            quota_interval="1",
            quota_time_unit="day",
            quota_counter_scope="PROXY",
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        ```
        ## Import

        ApiProduct can be imported using any of these accepted formats:

        * `{{org_id}}/apiproducts/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, ApiProduct can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/apiProduct:ApiProduct default {{org_id}}/apiproducts/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/apiProduct:ApiProduct default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ApiProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approval_type: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiProductAttributeArgs', 'ApiProductAttributeArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 graphql_operation_group: Optional[pulumi.Input[Union['ApiProductGraphqlOperationGroupArgs', 'ApiProductGraphqlOperationGroupArgsDict']]] = None,
                 grpc_operation_group: Optional[pulumi.Input[Union['ApiProductGrpcOperationGroupArgs', 'ApiProductGrpcOperationGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_group: Optional[pulumi.Input[Union['ApiProductOperationGroupArgs', 'ApiProductOperationGroupArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_counter_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_interval: Optional[pulumi.Input[_builtins.str]] = None,
                 quota_time_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 space: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiProductArgs.__new__(ApiProductArgs)

            __props__.__dict__["api_resources"] = api_resources
            __props__.__dict__["approval_type"] = approval_type
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["environments"] = environments
            __props__.__dict__["graphql_operation_group"] = graphql_operation_group
            __props__.__dict__["grpc_operation_group"] = grpc_operation_group
            __props__.__dict__["name"] = name
            __props__.__dict__["operation_group"] = operation_group
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["proxies"] = proxies
            __props__.__dict__["quota"] = quota
            __props__.__dict__["quota_counter_scope"] = quota_counter_scope
            __props__.__dict__["quota_interval"] = quota_interval
            __props__.__dict__["quota_time_unit"] = quota_time_unit
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["space"] = space
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_modified_at"] = None
        super(ApiProduct, __self__).__init__(
            'gcp:apigee/apiProduct:ApiProduct',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            approval_type: Optional[pulumi.Input[_builtins.str]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiProductAttributeArgs', 'ApiProductAttributeArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            graphql_operation_group: Optional[pulumi.Input[Union['ApiProductGraphqlOperationGroupArgs', 'ApiProductGraphqlOperationGroupArgsDict']]] = None,
            grpc_operation_group: Optional[pulumi.Input[Union['ApiProductGrpcOperationGroupArgs', 'ApiProductGrpcOperationGroupArgsDict']]] = None,
            last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operation_group: Optional[pulumi.Input[Union['ApiProductOperationGroupArgs', 'ApiProductOperationGroupArgsDict']]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            proxies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            quota: Optional[pulumi.Input[_builtins.str]] = None,
            quota_counter_scope: Optional[pulumi.Input[_builtins.str]] = None,
            quota_interval: Optional[pulumi.Input[_builtins.str]] = None,
            quota_time_unit: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            space: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiProduct':
        """
        Get an existing ApiProduct resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_resources: Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
               The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        :param pulumi.Input[_builtins.str] approval_type: Flag that specifies how API keys are approved to access the APIs defined by the API product.
               Valid values are `auto` or `manual`.
               Possible values are: `auto`, `manual`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiProductAttributeArgs', 'ApiProductAttributeArgsDict']]]] attributes: Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
               Use this property to specify the access level of the API product as either public, private, or internal.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] created_at: Response only. Creation time of this environment as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] description: Description of the API product. Include key information about the API product that is not captured by other fields.
        :param pulumi.Input[_builtins.str] display_name: Name displayed in the UI or developer portal to developers registering for API access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] environments: Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
               By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        :param pulumi.Input[Union['ApiProductGraphqlOperationGroupArgs', 'ApiProductGraphqlOperationGroupArgsDict']] graphql_operation_group: Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
               Structure is documented below.
        :param pulumi.Input[Union['ApiProductGrpcOperationGroupArgs', 'ApiProductGrpcOperationGroupArgsDict']] grpc_operation_group: Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_modified_at: Response only. Modified time of this environment as milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Internal name of the API product.
        :param pulumi.Input[Union['ApiProductOperationGroupArgs', 'ApiProductOperationGroupArgsDict']] operation_group: Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
               Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee API product,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxies: Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
               Apigee rejects requests to API proxies that are not listed.
        :param pulumi.Input[_builtins.str] quota: Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
               For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        :param pulumi.Input[_builtins.str] quota_counter_scope: Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
               Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        :param pulumi.Input[_builtins.str] quota_interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[_builtins.str] quota_time_unit: Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        :param pulumi.Input[_builtins.str] space: Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiProductState.__new__(_ApiProductState)

        __props__.__dict__["api_resources"] = api_resources
        __props__.__dict__["approval_type"] = approval_type
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environments"] = environments
        __props__.__dict__["graphql_operation_group"] = graphql_operation_group
        __props__.__dict__["grpc_operation_group"] = grpc_operation_group
        __props__.__dict__["last_modified_at"] = last_modified_at
        __props__.__dict__["name"] = name
        __props__.__dict__["operation_group"] = operation_group
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["proxies"] = proxies
        __props__.__dict__["quota"] = quota
        __props__.__dict__["quota_counter_scope"] = quota_counter_scope
        __props__.__dict__["quota_interval"] = quota_interval
        __props__.__dict__["quota_time_unit"] = quota_time_unit
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["space"] = space
        return ApiProduct(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiResources")
    def api_resources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Comma-separated list of API resources to be bundled in the API product. By default, the resource paths are mapped from the proxy.pathsuffix variable.
        The proxy path suffix is defined as the URI fragment following the ProxyEndpoint base path. For example, if the apiResources element is defined to be /forecastrss and the base path defined for the API proxy is /weather, then only requests to /weather/forecastrss are permitted by the API product.
        """
        return pulumi.get(self, "api_resources")

    @_builtins.property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Flag that specifies how API keys are approved to access the APIs defined by the API product.
        Valid values are `auto` or `manual`.
        Possible values are: `auto`, `manual`.
        """
        return pulumi.get(self, "approval_type")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Sequence['outputs.ApiProductAttribute']]]:
        """
        Array of attributes that may be used to extend the default API product profile with customer-specific metadata. You can specify a maximum of 18 attributes.
        Use this property to specify the access level of the API product as either public, private, or internal.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Response only. Creation time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the API product. Include key information about the API product that is not captured by other fields.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name displayed in the UI or developer portal to developers registering for API access.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Comma-separated list of environment names to which the API product is bound. Requests to environments that are not listed are rejected.
        By specifying one or more environments, you can bind the resources listed in the API product to a specific environment, preventing developers from accessing those resources through API proxies deployed in another environment.
        """
        return pulumi.get(self, "environments")

    @_builtins.property
    @pulumi.getter(name="graphqlOperationGroup")
    def graphql_operation_group(self) -> pulumi.Output[Optional['outputs.ApiProductGraphqlOperationGroup']]:
        """
        Configuration used to group Apigee proxies or remote services with graphQL operation name, graphQL operation type and quotas. This grouping allows us to precisely set quota for a particular combination of graphQL name and operation type for a particular proxy request. If graphQL name is not set, this would imply quota will be applied on all graphQL requests matching the operation type.
        Structure is documented below.
        """
        return pulumi.get(self, "graphql_operation_group")

    @_builtins.property
    @pulumi.getter(name="grpcOperationGroup")
    def grpc_operation_group(self) -> pulumi.Output[Optional['outputs.ApiProductGrpcOperationGroup']]:
        """
        Optional. Configuration used to group Apigee proxies with gRPC services and method names. This grouping allows us to set quota for a particular proxy with the gRPC service name and method. If a method name is not set, this implies quota and authorization are applied to all gRPC methods implemented by that proxy for that particular gRPC service.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc_operation_group")

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Response only. Modified time of this environment as milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Internal name of the API product.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="operationGroup")
    def operation_group(self) -> pulumi.Output[Optional['outputs.ApiProductOperationGroup']]:
        """
        Configuration used to group Apigee proxies or remote services with resources, method types, and quotas. The resource refers to the resource URI (excluding the base path). With this grouping, the API product creator is able to fine-tune and give precise control over which REST methods have access to specific resources and how many calls can be made (using the quota setting).
        Note: The apiResources setting cannot be specified for both the API product and operation group; otherwise the call will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "operation_group")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee API product,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Comma-separated list of API proxy names to which this API product is bound. By specifying API proxies, you can associate resources in the API product with specific API proxies, preventing developers from accessing those resources through other API proxies.
        Apigee rejects requests to API proxies that are not listed.
        """
        return pulumi.get(self, "proxies")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Number of request messages permitted per app by this API product for the specified quotaInterval and quotaTimeUnit.
        For example, a quota of 50, for a quotaInterval of 12 and a quotaTimeUnit of hours means 50 requests are allowed every 12 hours.
        """
        return pulumi.get(self, "quota")

    @_builtins.property
    @pulumi.getter(name="quotaCounterScope")
    def quota_counter_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scope of the quota decides how the quota counter gets applied and evaluate for quota violation. If the Scope is set as PROXY, then all the operations defined for the APIproduct that are associated with the same proxy will share the same quota counter set at the APIproduct level, making it a global counter at a proxy level. If the Scope is set as OPERATION, then each operations get the counter set at the API product dedicated, making it a local counter. Note that, the QuotaCounterScope applies only when an operation does not have dedicated quota set for itself.
        Possible values are: `QUOTA_COUNTER_SCOPE_UNSPECIFIED`, `PROXY`, `OPERATION`.
        """
        return pulumi.get(self, "quota_counter_scope")

    @_builtins.property
    @pulumi.getter(name="quotaInterval")
    def quota_interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "quota_interval")

    @_builtins.property
    @pulumi.getter(name="quotaTimeUnit")
    def quota_time_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Time unit defined for the quotaInterval. Valid values include second, minute, hour, day, month or year.
        """
        return pulumi.get(self, "quota_time_unit")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Comma-separated list of OAuth scopes that are validated at runtime. Apigee validates that the scopes in any access token presented match the scopes defined in the OAuth policy associated with the API product.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def space(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The resource ID of the parent Space. If not set, the parent resource will be the Organization.
        """
        return pulumi.get(self, "space")

