# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeveloperAppArgs', 'DeveloperApp']

@pulumi.input_type
class DeveloperAppArgs:
    def __init__(__self__, *,
                 callback_url: pulumi.Input[_builtins.str],
                 developer_email: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 api_products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_family: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]] = None,
                 key_expires_in: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DeveloperApp resource.
        :param pulumi.Input[_builtins.str] callback_url: Callback URL used by OAuth 2.0 authorization servers to communicate
               authorization codes back to developer apps.
        :param pulumi.Input[_builtins.str] developer_email: Email address of the developer.
               This value is used to uniquely identify the developer in Apigee hybrid.
               Note that the email address has to be in lowercase only.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_products: List of API products associated with the developer app.
        :param pulumi.Input[_builtins.str] app_family: Developer app family.
        :param pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] key_expires_in: Expiration time, in milliseconds, for the consumer key that is generated
               for the developer app. If not set or left to the default value of -1,
               the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[_builtins.str] name: Name of the developer app.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes to apply to the developer app.
               The specified scopes must already exist for the API product that
               you associate with the developer app.
        :param pulumi.Input[_builtins.str] status: Status of the credential. Valid values include approved or revoked.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "developer_email", developer_email)
        pulumi.set(__self__, "org_id", org_id)
        if api_products is not None:
            pulumi.set(__self__, "api_products", api_products)
        if app_family is not None:
            pulumi.set(__self__, "app_family", app_family)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if key_expires_in is not None:
            pulumi.set(__self__, "key_expires_in", key_expires_in)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[_builtins.str]:
        """
        Callback URL used by OAuth 2.0 authorization servers to communicate
        authorization codes back to developer apps.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="developerEmail")
    def developer_email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address of the developer.
        This value is used to uniquely identify the developer in Apigee hybrid.
        Note that the email address has to be in lowercase only.
        """
        return pulumi.get(self, "developer_email")

    @developer_email.setter
    def developer_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "developer_email", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of API products associated with the developer app.
        """
        return pulumi.get(self, "api_products")

    @api_products.setter
    def api_products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_products", value)

    @_builtins.property
    @pulumi.getter(name="appFamily")
    def app_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Developer app family.
        """
        return pulumi.get(self, "app_family")

    @app_family.setter
    def app_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_family", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="keyExpiresIn")
    def key_expires_in(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration time, in milliseconds, for the consumer key that is generated
        for the developer app. If not set or left to the default value of -1,
        the API key never expires. The expiration time can't be updated after it is set.
        """
        return pulumi.get(self, "key_expires_in")

    @key_expires_in.setter
    def key_expires_in(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_expires_in", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the developer app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes to apply to the developer app.
        The specified scopes must already exist for the API product that
        you associate with the developer app.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the credential. Valid values include approved or revoked.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DeveloperAppState:
    def __init__(__self__, *,
                 api_products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_family: Optional[pulumi.Input[_builtins.str]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppCredentialArgs']]]] = None,
                 developer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_expires_in: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DeveloperApp resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_products: List of API products associated with the developer app.
        :param pulumi.Input[_builtins.str] app_family: Developer app family.
        :param pulumi.Input[_builtins.str] app_id: ID of the developer app. This ID is not user specified but is
               automatically generated on app creation. appId is a UUID.
        :param pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] callback_url: Callback URL used by OAuth 2.0 authorization servers to communicate
               authorization codes back to developer apps.
        :param pulumi.Input[_builtins.str] created_at: Time at which the developer was created in milliseconds since epoch.
        :param pulumi.Input[Sequence[pulumi.Input['DeveloperAppCredentialArgs']]] credentials: Output only. Set of credentials for the developer app consisting of
               the consumer key/secret pairs associated with the API products.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] developer_email: Email address of the developer.
               This value is used to uniquely identify the developer in Apigee hybrid.
               Note that the email address has to be in lowercase only.
        :param pulumi.Input[_builtins.str] developer_id: ID of the developer.
        :param pulumi.Input[_builtins.str] key_expires_in: Expiration time, in milliseconds, for the consumer key that is generated
               for the developer app. If not set or left to the default value of -1,
               the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[_builtins.str] last_modified_at: Time at which the developer was last modified in milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Name of the developer app.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes to apply to the developer app.
               The specified scopes must already exist for the API product that
               you associate with the developer app.
        :param pulumi.Input[_builtins.str] status: Status of the credential. Valid values include approved or revoked.
        """
        if api_products is not None:
            pulumi.set(__self__, "api_products", api_products)
        if app_family is not None:
            pulumi.set(__self__, "app_family", app_family)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if callback_url is not None:
            pulumi.set(__self__, "callback_url", callback_url)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if developer_email is not None:
            pulumi.set(__self__, "developer_email", developer_email)
        if developer_id is not None:
            pulumi.set(__self__, "developer_id", developer_id)
        if key_expires_in is not None:
            pulumi.set(__self__, "key_expires_in", key_expires_in)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of API products associated with the developer app.
        """
        return pulumi.get(self, "api_products")

    @api_products.setter
    def api_products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_products", value)

    @_builtins.property
    @pulumi.getter(name="appFamily")
    def app_family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Developer app family.
        """
        return pulumi.get(self, "app_family")

    @app_family.setter
    def app_family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_family", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the developer app. This ID is not user specified but is
        automatically generated on app creation. appId is a UUID.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Callback URL used by OAuth 2.0 authorization servers to communicate
        authorization codes back to developer apps.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "callback_url", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the developer was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppCredentialArgs']]]]:
        """
        Output only. Set of credentials for the developer app consisting of
        the consumer key/secret pairs associated with the API products.
        Structure is documented below.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeveloperAppCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="developerEmail")
    def developer_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the developer.
        This value is used to uniquely identify the developer in Apigee hybrid.
        Note that the email address has to be in lowercase only.
        """
        return pulumi.get(self, "developer_email")

    @developer_email.setter
    def developer_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_email", value)

    @_builtins.property
    @pulumi.getter(name="developerId")
    def developer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the developer.
        """
        return pulumi.get(self, "developer_id")

    @developer_id.setter
    def developer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_id", value)

    @_builtins.property
    @pulumi.getter(name="keyExpiresIn")
    def key_expires_in(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration time, in milliseconds, for the consumer key that is generated
        for the developer app. If not set or left to the default value of -1,
        the API key never expires. The expiration time can't be updated after it is set.
        """
        return pulumi.get(self, "key_expires_in")

    @key_expires_in.setter
    def key_expires_in(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_expires_in", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the developer was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the developer app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Scopes to apply to the developer app.
        The specified scopes must already exist for the API product that
        you associate with the developer app.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the credential. Valid values include approved or revoked.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("gcp:apigee/developerApp:DeveloperApp")
class DeveloperApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_family: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppAttributeArgs', 'DeveloperAppAttributeArgsDict']]]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 key_expires_in: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an app associated with a developer.
        This API associates the developer app with the specified API product
        and auto-generates an API key for the app to use in calls to API proxies
        inside that API product.

        To get more information about DeveloperApp, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.developers.apps)
        * How-to Guides
            * [Creating a developer](https://cloud.google.com/apigee/docs/api-platform/publish/creating-apps-surface-your-api)

        ## Example Usage

        ### Apigee Developer App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project_google_project["projectId"],
            disable_vpc_peering=True)
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id)
        api_product = gcp.apigee.ApiProduct("api_product",
            org_id=apigee_org.id,
            name="sample-api",
            display_name="A sample API Product",
            approval_type="auto",
            scopes=[
                "read:weather",
                "write:reports",
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        developer = gcp.apigee.Developer("developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        apigee_developer_app = gcp.apigee.DeveloperApp("apigee_developer_app",
            name="sample-app",
            org_id=apigee_org.id,
            developer_id=developer.id,
            developer_email=developer.email,
            callback_url="https://example-call.url",
            api_products=[api_product.name],
            scopes=api_product.scopes)
        project = gcp.organizations.get_project()
        ```
        ### Apigee Developer App Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        project = gcp.organizations.Project("project",
            project_id="prj",
            name="prj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.Sleep("wait_60_seconds", create_duration="60s",
        opts = pulumi.ResourceOptions(depends_on=[project]))
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project.project_id,
            disable_vpc_peering=True,
            opts = pulumi.ResourceOptions(depends_on=[apigee]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id)
        api_product = gcp.apigee.ApiProduct("api_product",
            name="sample-api",
            org_id=apigee_org.id,
            display_name="A sample API Product",
            approval_type="auto",
            scopes=[
                "read:weather",
                "write:reports",
                "write:files",
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        developer = gcp.apigee.Developer("developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        apigee_developer_app = gcp.apigee.DeveloperApp("apigee_developer_app",
            name="sample-app",
            app_family="default",
            developer_email=developer.email,
            org_id=apigee_org.id,
            callback_url="https://example-call.url",
            key_expires_in="-1",
            status="approved",
            api_products=[api_product.name],
            scopes=api_product.scopes,
            attributes=[{
                "name": "sample_name",
                "value": "sample_value",
            }])
        ```

        ## Import

        DeveloperApp can be imported using any of these accepted formats:

        * `{{org_id}}/developers/{{developer_email}}/apps/{{name}}`

        * `{{org_id}}/{{developer_email}}/{{name}}`

        When using the `pulumi import` command, DeveloperApp can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/developerApp:DeveloperApp default {{org_id}}/developers/{{developer_email}}/apps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/developerApp:DeveloperApp default {{org_id}}/{{developer_email}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_products: List of API products associated with the developer app.
        :param pulumi.Input[_builtins.str] app_family: Developer app family.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppAttributeArgs', 'DeveloperAppAttributeArgsDict']]]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] callback_url: Callback URL used by OAuth 2.0 authorization servers to communicate
               authorization codes back to developer apps.
        :param pulumi.Input[_builtins.str] developer_email: Email address of the developer.
               This value is used to uniquely identify the developer in Apigee hybrid.
               Note that the email address has to be in lowercase only.
        :param pulumi.Input[_builtins.str] key_expires_in: Expiration time, in milliseconds, for the consumer key that is generated
               for the developer app. If not set or left to the default value of -1,
               the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[_builtins.str] name: Name of the developer app.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes to apply to the developer app.
               The specified scopes must already exist for the API product that
               you associate with the developer app.
        :param pulumi.Input[_builtins.str] status: Status of the credential. Valid values include approved or revoked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeveloperAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an app associated with a developer.
        This API associates the developer app with the specified API product
        and auto-generates an API key for the app to use in calls to API proxies
        inside that API product.

        To get more information about DeveloperApp, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.developers.apps)
        * How-to Guides
            * [Creating a developer](https://cloud.google.com/apigee/docs/api-platform/publish/creating-apps-surface-your-api)

        ## Example Usage

        ### Apigee Developer App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project_google_project["projectId"],
            disable_vpc_peering=True)
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id)
        api_product = gcp.apigee.ApiProduct("api_product",
            org_id=apigee_org.id,
            name="sample-api",
            display_name="A sample API Product",
            approval_type="auto",
            scopes=[
                "read:weather",
                "write:reports",
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        developer = gcp.apigee.Developer("developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        apigee_developer_app = gcp.apigee.DeveloperApp("apigee_developer_app",
            name="sample-app",
            org_id=apigee_org.id,
            developer_id=developer.id,
            developer_email=developer.email,
            callback_url="https://example-call.url",
            api_products=[api_product.name],
            scopes=api_product.scopes)
        project = gcp.organizations.get_project()
        ```
        ### Apigee Developer App Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumiverse_time as time

        project = gcp.organizations.Project("project",
            project_id="prj",
            name="prj",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.Sleep("wait_60_seconds", create_duration="60s",
        opts = pulumi.ResourceOptions(depends_on=[project]))
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com",
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=project.project_id,
            disable_vpc_peering=True,
            opts = pulumi.ResourceOptions(depends_on=[apigee]))
        apigee_instance = gcp.apigee.Instance("apigee_instance",
            name="instance",
            location="us-central1",
            org_id=apigee_org.id)
        api_product = gcp.apigee.ApiProduct("api_product",
            name="sample-api",
            org_id=apigee_org.id,
            display_name="A sample API Product",
            approval_type="auto",
            scopes=[
                "read:weather",
                "write:reports",
                "write:files",
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        developer = gcp.apigee.Developer("developer",
            email="john.doe@acme.com",
            first_name="John",
            last_name="Doe",
            user_name="john.doe",
            org_id=apigee_org.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_instance]))
        apigee_developer_app = gcp.apigee.DeveloperApp("apigee_developer_app",
            name="sample-app",
            app_family="default",
            developer_email=developer.email,
            org_id=apigee_org.id,
            callback_url="https://example-call.url",
            key_expires_in="-1",
            status="approved",
            api_products=[api_product.name],
            scopes=api_product.scopes,
            attributes=[{
                "name": "sample_name",
                "value": "sample_value",
            }])
        ```

        ## Import

        DeveloperApp can be imported using any of these accepted formats:

        * `{{org_id}}/developers/{{developer_email}}/apps/{{name}}`

        * `{{org_id}}/{{developer_email}}/{{name}}`

        When using the `pulumi import` command, DeveloperApp can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/developerApp:DeveloperApp default {{org_id}}/developers/{{developer_email}}/apps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/developerApp:DeveloperApp default {{org_id}}/{{developer_email}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DeveloperAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeveloperAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_family: Optional[pulumi.Input[_builtins.str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppAttributeArgs', 'DeveloperAppAttributeArgsDict']]]]] = None,
                 callback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 key_expires_in: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeveloperAppArgs.__new__(DeveloperAppArgs)

            __props__.__dict__["api_products"] = api_products
            __props__.__dict__["app_family"] = app_family
            __props__.__dict__["attributes"] = attributes
            if callback_url is None and not opts.urn:
                raise TypeError("Missing required property 'callback_url'")
            __props__.__dict__["callback_url"] = callback_url
            if developer_email is None and not opts.urn:
                raise TypeError("Missing required property 'developer_email'")
            __props__.__dict__["developer_email"] = developer_email
            __props__.__dict__["key_expires_in"] = key_expires_in
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
            __props__.__dict__["app_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["credentials"] = None
            __props__.__dict__["developer_id"] = None
            __props__.__dict__["last_modified_at"] = None
        super(DeveloperApp, __self__).__init__(
            'gcp:apigee/developerApp:DeveloperApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_products: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            app_family: Optional[pulumi.Input[_builtins.str]] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppAttributeArgs', 'DeveloperAppAttributeArgsDict']]]]] = None,
            callback_url: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppCredentialArgs', 'DeveloperAppCredentialArgsDict']]]]] = None,
            developer_email: Optional[pulumi.Input[_builtins.str]] = None,
            developer_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_expires_in: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'DeveloperApp':
        """
        Get an existing DeveloperApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_products: List of API products associated with the developer app.
        :param pulumi.Input[_builtins.str] app_family: Developer app family.
        :param pulumi.Input[_builtins.str] app_id: ID of the developer app. This ID is not user specified but is
               automatically generated on app creation. appId is a UUID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppAttributeArgs', 'DeveloperAppAttributeArgsDict']]]] attributes: Developer attributes (name/value pairs). The custom attribute limit is 18.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] callback_url: Callback URL used by OAuth 2.0 authorization servers to communicate
               authorization codes back to developer apps.
        :param pulumi.Input[_builtins.str] created_at: Time at which the developer was created in milliseconds since epoch.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeveloperAppCredentialArgs', 'DeveloperAppCredentialArgsDict']]]] credentials: Output only. Set of credentials for the developer app consisting of
               the consumer key/secret pairs associated with the API products.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] developer_email: Email address of the developer.
               This value is used to uniquely identify the developer in Apigee hybrid.
               Note that the email address has to be in lowercase only.
        :param pulumi.Input[_builtins.str] developer_id: ID of the developer.
        :param pulumi.Input[_builtins.str] key_expires_in: Expiration time, in milliseconds, for the consumer key that is generated
               for the developer app. If not set or left to the default value of -1,
               the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[_builtins.str] last_modified_at: Time at which the developer was last modified in milliseconds since epoch.
        :param pulumi.Input[_builtins.str] name: Name of the developer app.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Scopes to apply to the developer app.
               The specified scopes must already exist for the API product that
               you associate with the developer app.
        :param pulumi.Input[_builtins.str] status: Status of the credential. Valid values include approved or revoked.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeveloperAppState.__new__(_DeveloperAppState)

        __props__.__dict__["api_products"] = api_products
        __props__.__dict__["app_family"] = app_family
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["callback_url"] = callback_url
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["developer_email"] = developer_email
        __props__.__dict__["developer_id"] = developer_id
        __props__.__dict__["key_expires_in"] = key_expires_in
        __props__.__dict__["last_modified_at"] = last_modified_at
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["status"] = status
        return DeveloperApp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of API products associated with the developer app.
        """
        return pulumi.get(self, "api_products")

    @_builtins.property
    @pulumi.getter(name="appFamily")
    def app_family(self) -> pulumi.Output[_builtins.str]:
        """
        Developer app family.
        """
        return pulumi.get(self, "app_family")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the developer app. This ID is not user specified but is
        automatically generated on app creation. appId is a UUID.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[Sequence['outputs.DeveloperAppAttribute']]]:
        """
        Developer attributes (name/value pairs). The custom attribute limit is 18.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Output[_builtins.str]:
        """
        Callback URL used by OAuth 2.0 authorization servers to communicate
        authorization codes back to developer apps.
        """
        return pulumi.get(self, "callback_url")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the developer was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Sequence['outputs.DeveloperAppCredential']]:
        """
        Output only. Set of credentials for the developer app consisting of
        the consumer key/secret pairs associated with the API products.
        Structure is documented below.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="developerEmail")
    def developer_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the developer.
        This value is used to uniquely identify the developer in Apigee hybrid.
        Note that the email address has to be in lowercase only.
        """
        return pulumi.get(self, "developer_email")

    @_builtins.property
    @pulumi.getter(name="developerId")
    def developer_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the developer.
        """
        return pulumi.get(self, "developer_id")

    @_builtins.property
    @pulumi.getter(name="keyExpiresIn")
    def key_expires_in(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Expiration time, in milliseconds, for the consumer key that is generated
        for the developer app. If not set or left to the default value of -1,
        the API key never expires. The expiration time can't be updated after it is set.
        """
        return pulumi.get(self, "key_expires_in")

    @_builtins.property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the developer was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the developer app.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Scopes to apply to the developer app.
        The specified scopes must already exist for the API product that
        you associate with the developer app.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the credential. Valid values include approved or revoked.
        """
        return pulumi.get(self, "status")

