# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsZoneArgs', 'DnsZone']

@pulumi.input_type
class DnsZoneArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 dns_zone_id: pulumi.Input[_builtins.str],
                 domain: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 peering_config: pulumi.Input['DnsZonePeeringConfigArgs']):
        """
        The set of arguments for constructing a DnsZone resource.
        :param pulumi.Input[_builtins.str] description: Description for the zone.
        :param pulumi.Input[_builtins.str] dns_zone_id: ID of the dns zone.
        :param pulumi.Input[_builtins.str] domain: Doamin for the zone.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input['DnsZonePeeringConfigArgs'] peering_config: Peering zone config
               Structure is documented below.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_zone_id", dns_zone_id)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "peering_config", peering_config)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description for the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the dns zone.
        """
        return pulumi.get(self, "dns_zone_id")

    @dns_zone_id.setter
    def dns_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dns_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        Doamin for the zone.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> pulumi.Input['DnsZonePeeringConfigArgs']:
        """
        Peering zone config
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

    @peering_config.setter
    def peering_config(self, value: pulumi.Input['DnsZonePeeringConfigArgs']):
        pulumi.set(self, "peering_config", value)


@pulumi.input_type
class _DnsZoneState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input['DnsZonePeeringConfigArgs']] = None):
        """
        Input properties used for looking up and filtering DnsZone resources.
        :param pulumi.Input[_builtins.str] description: Description for the zone.
        :param pulumi.Input[_builtins.str] dns_zone_id: ID of the dns zone.
        :param pulumi.Input[_builtins.str] domain: Doamin for the zone.
        :param pulumi.Input[_builtins.str] name: Name of the Dns Zone in the following format:
               organizations/{organization}/dnsZones/{dnsZone}.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input['DnsZonePeeringConfigArgs'] peering_config: Peering zone config
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_zone_id is not None:
            pulumi.set(__self__, "dns_zone_id", dns_zone_id)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if peering_config is not None:
            pulumi.set(__self__, "peering_config", peering_config)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the dns zone.
        """
        return pulumi.get(self, "dns_zone_id")

    @dns_zone_id.setter
    def dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Doamin for the zone.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Dns Zone in the following format:
        organizations/{organization}/dnsZones/{dnsZone}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> Optional[pulumi.Input['DnsZonePeeringConfigArgs']]:
        """
        Peering zone config
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

    @peering_config.setter
    def peering_config(self, value: Optional[pulumi.Input['DnsZonePeeringConfigArgs']]):
        pulumi.set(self, "peering_config", value)


@pulumi.type_token("gcp:apigee/dnsZone:DnsZone")
class DnsZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input[Union['DnsZonePeeringConfigArgs', 'DnsZonePeeringConfigArgsDict']]] = None,
                 __props__=None):
        """
        Apigee Dns Zone.

        To get more information about DnsZone, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.dnsZones/create)
        * How-to Guides
            * [Creating a DnsZone](https://cloud.google.com/apigee/docs/api-platform/get-started/create-dns)

        ## Example Usage

        ### Apigee Dns Zone Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        org = gcp.apigee.Organization("org",
            description="Terraform-provisioned basic Apigee Org without VPC Peering.",
            analytics_region="us-central1",
            project_id=current.project,
            disable_vpc_peering=True)
        apigee_dns_zone = gcp.apigee.DnsZone("apigee_dns_zone",
            org_id=apigee_org["id"],
            dns_zone_id="test1",
            domain="foo.com",
            description="test",
            peering_config={
                "target_project_id": current.project,
                "target_network_id": apigee_network.id,
            })
        ```

        ## Import

        DnsZone can be imported using any of these accepted formats:

        * `{{org_id}}/dnsZones/{{dns_zone_id}}`

        * `{{org_id}}/{{dns_zone_id}}`

        When using the `pulumi import` command, DnsZone can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/dnsZone:DnsZone default {{org_id}}/dnsZones/{{dns_zone_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/dnsZone:DnsZone default {{org_id}}/{{dns_zone_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description for the zone.
        :param pulumi.Input[_builtins.str] dns_zone_id: ID of the dns zone.
        :param pulumi.Input[_builtins.str] domain: Doamin for the zone.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Union['DnsZonePeeringConfigArgs', 'DnsZonePeeringConfigArgsDict']] peering_config: Peering zone config
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Apigee Dns Zone.

        To get more information about DnsZone, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.dnsZones/create)
        * How-to Guides
            * [Creating a DnsZone](https://cloud.google.com/apigee/docs/api-platform/get-started/create-dns)

        ## Example Usage

        ### Apigee Dns Zone Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        org = gcp.apigee.Organization("org",
            description="Terraform-provisioned basic Apigee Org without VPC Peering.",
            analytics_region="us-central1",
            project_id=current.project,
            disable_vpc_peering=True)
        apigee_dns_zone = gcp.apigee.DnsZone("apigee_dns_zone",
            org_id=apigee_org["id"],
            dns_zone_id="test1",
            domain="foo.com",
            description="test",
            peering_config={
                "target_project_id": current.project,
                "target_network_id": apigee_network.id,
            })
        ```

        ## Import

        DnsZone can be imported using any of these accepted formats:

        * `{{org_id}}/dnsZones/{{dns_zone_id}}`

        * `{{org_id}}/{{dns_zone_id}}`

        When using the `pulumi import` command, DnsZone can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/dnsZone:DnsZone default {{org_id}}/dnsZones/{{dns_zone_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/dnsZone:DnsZone default {{org_id}}/{{dns_zone_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DnsZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input[Union['DnsZonePeeringConfigArgs', 'DnsZonePeeringConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsZoneArgs.__new__(DnsZoneArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if dns_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'dns_zone_id'")
            __props__.__dict__["dns_zone_id"] = dns_zone_id
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if peering_config is None and not opts.urn:
                raise TypeError("Missing required property 'peering_config'")
            __props__.__dict__["peering_config"] = peering_config
            __props__.__dict__["name"] = None
        super(DnsZone, __self__).__init__(
            'gcp:apigee/dnsZone:DnsZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            peering_config: Optional[pulumi.Input[Union['DnsZonePeeringConfigArgs', 'DnsZonePeeringConfigArgsDict']]] = None) -> 'DnsZone':
        """
        Get an existing DnsZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description for the zone.
        :param pulumi.Input[_builtins.str] dns_zone_id: ID of the dns zone.
        :param pulumi.Input[_builtins.str] domain: Doamin for the zone.
        :param pulumi.Input[_builtins.str] name: Name of the Dns Zone in the following format:
               organizations/{organization}/dnsZones/{dnsZone}.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee instance,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Union['DnsZonePeeringConfigArgs', 'DnsZonePeeringConfigArgsDict']] peering_config: Peering zone config
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsZoneState.__new__(_DnsZoneState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dns_zone_id"] = dns_zone_id
        __props__.__dict__["domain"] = domain
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["peering_config"] = peering_config
        return DnsZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description for the zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the dns zone.
        """
        return pulumi.get(self, "dns_zone_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        Doamin for the zone.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Dns Zone in the following format:
        organizations/{organization}/dnsZones/{dnsZone}.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee instance,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> pulumi.Output['outputs.DnsZonePeeringConfig']:
        """
        Peering zone config
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

