# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvGroupArgs', 'EnvGroup']

@pulumi.input_type
class EnvGroupArgs:
    def __init__(__self__, *,
                 org_id: pulumi.Input[_builtins.str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvGroup resource.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee environment group,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Hostnames of the environment group.
        :param pulumi.Input[_builtins.str] name: The resource ID of the environment group.
        """
        pulumi.set(__self__, "org_id", org_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee environment group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hostnames of the environment group.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the environment group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EnvGroupState:
    def __init__(__self__, *,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Hostnames of the environment group.
        :param pulumi.Input[_builtins.str] name: The resource ID of the environment group.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee environment group,
               in the format `organizations/{{org_name}}`.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Hostnames of the environment group.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the environment group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee environment group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)


@pulumi.type_token("gcp:apigee/envGroup:EnvGroup")
class EnvGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An `Environment group` in Apigee.

        To get more information about Envgroup, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.envgroups/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage

        ### Apigee Environment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env_grp = gcp.apigee.EnvGroup("env_grp",
            name="my-envgroup",
            hostnames=["abc.foo.com"],
            org_id=apigee_org.id)
        ```

        ## Import

        Envgroup can be imported using any of these accepted formats:

        * `{{org_id}}/envgroups/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Envgroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/envGroup:EnvGroup default {{org_id}}/envgroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/envGroup:EnvGroup default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Hostnames of the environment group.
        :param pulumi.Input[_builtins.str] name: The resource ID of the environment group.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee environment group,
               in the format `organizations/{{org_name}}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Environment group` in Apigee.

        To get more information about Envgroup, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.envgroups/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Example Usage

        ### Apigee Environment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        env_grp = gcp.apigee.EnvGroup("env_grp",
            name="my-envgroup",
            hostnames=["abc.foo.com"],
            org_id=apigee_org.id)
        ```

        ## Import

        Envgroup can be imported using any of these accepted formats:

        * `{{org_id}}/envgroups/{{name}}`

        * `{{org_id}}/{{name}}`

        When using the `pulumi import` command, Envgroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/envGroup:EnvGroup default {{org_id}}/envgroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/envGroup:EnvGroup default {{org_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvGroupArgs.__new__(EnvGroupArgs)

            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["name"] = name
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
        super(EnvGroup, __self__).__init__(
            'gcp:apigee/envGroup:EnvGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvGroup':
        """
        Get an existing EnvGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: Hostnames of the environment group.
        :param pulumi.Input[_builtins.str] name: The resource ID of the environment group.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee environment group,
               in the format `organizations/{{org_name}}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvGroupState.__new__(_EnvGroupState)

        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        return EnvGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Hostnames of the environment group.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the environment group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee environment group,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

