# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentApiRevisionDeploymentArgs', 'EnvironmentApiRevisionDeployment']

@pulumi.input_type
class EnvironmentApiRevisionDeploymentArgs:
    def __init__(__self__, *,
                 api: pulumi.Input[_builtins.str],
                 environment: pulumi.Input[_builtins.str],
                 org_id: pulumi.Input[_builtins.str],
                 revision: pulumi.Input[_builtins.int],
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 sequenced_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EnvironmentApiRevisionDeployment resource.
        :param pulumi.Input[_builtins.str] api: Apigee API proxy name.
        :param pulumi.Input[_builtins.str] environment: Apigee environment name.
        :param pulumi.Input[_builtins.str] org_id: Apigee organization ID.
        :param pulumi.Input[_builtins.int] revision: API proxy revision number to deploy.
        :param pulumi.Input[_builtins.bool] override: If true, replaces other deployed revisions of this proxy in the environment.
        :param pulumi.Input[_builtins.bool] sequenced_rollout: If true, enables sequenced rollout for safe traffic switching.
        :param pulumi.Input[_builtins.str] service_account: Optional service account the deployed proxy runs as.
        """
        pulumi.set(__self__, "api", api)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "revision", revision)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if sequenced_rollout is not None:
            pulumi.set(__self__, "sequenced_rollout", sequenced_rollout)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter
    def api(self) -> pulumi.Input[_builtins.str]:
        """
        Apigee API proxy name.
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Apigee environment name.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        Apigee organization ID.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Input[_builtins.int]:
        """
        API proxy revision number to deploy.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, replaces other deployed revisions of this proxy in the environment.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override", value)

    @_builtins.property
    @pulumi.getter(name="sequencedRollout")
    def sequenced_rollout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables sequenced rollout for safe traffic switching.
        """
        return pulumi.get(self, "sequenced_rollout")

    @sequenced_rollout.setter
    def sequenced_rollout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sequenced_rollout", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional service account the deployed proxy runs as.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)


@pulumi.input_type
class _EnvironmentApiRevisionDeploymentState:
    def __init__(__self__, *,
                 api: Optional[pulumi.Input[_builtins.str]] = None,
                 basepaths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deploy_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision: Optional[pulumi.Input[_builtins.int]] = None,
                 sequenced_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentApiRevisionDeployment resources.
        :param pulumi.Input[_builtins.str] api: Apigee API proxy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] basepaths: Basepaths associated with the deployed proxy.
        :param pulumi.Input[_builtins.str] deploy_start_time: RFC3339 timestamp when deployment started.
        :param pulumi.Input[_builtins.str] environment: Apigee environment name.
        :param pulumi.Input[_builtins.str] org_id: Apigee organization ID.
        :param pulumi.Input[_builtins.bool] override: If true, replaces other deployed revisions of this proxy in the environment.
        :param pulumi.Input[_builtins.int] revision: API proxy revision number to deploy.
        :param pulumi.Input[_builtins.bool] sequenced_rollout: If true, enables sequenced rollout for safe traffic switching.
        :param pulumi.Input[_builtins.str] service_account: Optional service account the deployed proxy runs as.
        :param pulumi.Input[_builtins.str] state: Deployment state reported by Apigee.
        """
        if api is not None:
            pulumi.set(__self__, "api", api)
        if basepaths is not None:
            pulumi.set(__self__, "basepaths", basepaths)
        if deploy_start_time is not None:
            pulumi.set(__self__, "deploy_start_time", deploy_start_time)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if sequenced_rollout is not None:
            pulumi.set(__self__, "sequenced_rollout", sequenced_rollout)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def api(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Apigee API proxy name.
        """
        return pulumi.get(self, "api")

    @api.setter
    def api(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api", value)

    @_builtins.property
    @pulumi.getter
    def basepaths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Basepaths associated with the deployed proxy.
        """
        return pulumi.get(self, "basepaths")

    @basepaths.setter
    def basepaths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "basepaths", value)

    @_builtins.property
    @pulumi.getter(name="deployStartTime")
    def deploy_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RFC3339 timestamp when deployment started.
        """
        return pulumi.get(self, "deploy_start_time")

    @deploy_start_time.setter
    def deploy_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deploy_start_time", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Apigee environment name.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Apigee organization ID.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, replaces other deployed revisions of this proxy in the environment.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        API proxy revision number to deploy.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter(name="sequencedRollout")
    def sequenced_rollout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, enables sequenced rollout for safe traffic switching.
        """
        return pulumi.get(self, "sequenced_rollout")

    @sequenced_rollout.setter
    def sequenced_rollout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sequenced_rollout", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional service account the deployed proxy runs as.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment state reported by Apigee.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment")
class EnvironmentApiRevisionDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision: Optional[pulumi.Input[_builtins.int]] = None,
                 sequenced_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Deploys a specific Apigee API Proxy revision to a given Apigee environment.

        To get more information about EnvironmentApiRevisionDeployment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.apis.revisions.deployments/deploy)
        * How-to Guides
            * [Deploying an API proxy](https://cloud.google.com/apigee/docs/api-platform/deploy/ui-deploy-new#apigee-api)

        ## Example Usage

        ### Apigee Environment Api Revision Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        proxy_deployment_basic = gcp.apigee.EnvironmentApiRevisionDeployment("proxy_deployment_basic",
            org_id="my-org",
            environment="dev",
            api="hello-proxy",
            revision=1,
            override=True,
            sequenced_rollout=True)
        ```

        ## Import

        EnvironmentApiRevisionDeployment can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{api}}/revisions/{{revision}}`

        * `{{org_id}}/{{environment}}/{{api}}/{{revision}}`

        * `{{id}}`

        When using the `pulumi import` command, EnvironmentApiRevisionDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{api}}/revisions/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default {{org_id}}/{{environment}}/{{api}}/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default {{id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api: Apigee API proxy name.
        :param pulumi.Input[_builtins.str] environment: Apigee environment name.
        :param pulumi.Input[_builtins.str] org_id: Apigee organization ID.
        :param pulumi.Input[_builtins.bool] override: If true, replaces other deployed revisions of this proxy in the environment.
        :param pulumi.Input[_builtins.int] revision: API proxy revision number to deploy.
        :param pulumi.Input[_builtins.bool] sequenced_rollout: If true, enables sequenced rollout for safe traffic switching.
        :param pulumi.Input[_builtins.str] service_account: Optional service account the deployed proxy runs as.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentApiRevisionDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Deploys a specific Apigee API Proxy revision to a given Apigee environment.

        To get more information about EnvironmentApiRevisionDeployment, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.apis.revisions.deployments/deploy)
        * How-to Guides
            * [Deploying an API proxy](https://cloud.google.com/apigee/docs/api-platform/deploy/ui-deploy-new#apigee-api)

        ## Example Usage

        ### Apigee Environment Api Revision Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        proxy_deployment_basic = gcp.apigee.EnvironmentApiRevisionDeployment("proxy_deployment_basic",
            org_id="my-org",
            environment="dev",
            api="hello-proxy",
            revision=1,
            override=True,
            sequenced_rollout=True)
        ```

        ## Import

        EnvironmentApiRevisionDeployment can be imported using any of these accepted formats:

        * `organizations/{{org_id}}/environments/{{environment}}/apis/{{api}}/revisions/{{revision}}`

        * `{{org_id}}/{{environment}}/{{api}}/{{revision}}`

        * `{{id}}`

        When using the `pulumi import` command, EnvironmentApiRevisionDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default organizations/{{org_id}}/environments/{{environment}}/apis/{{api}}/revisions/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default {{org_id}}/{{environment}}/{{api}}/{{revision}}
        ```

        ```sh
        $ pulumi import gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment default {{id}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentApiRevisionDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentApiRevisionDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision: Optional[pulumi.Input[_builtins.int]] = None,
                 sequenced_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentApiRevisionDeploymentArgs.__new__(EnvironmentApiRevisionDeploymentArgs)

            if api is None and not opts.urn:
                raise TypeError("Missing required property 'api'")
            __props__.__dict__["api"] = api
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["override"] = override
            if revision is None and not opts.urn:
                raise TypeError("Missing required property 'revision'")
            __props__.__dict__["revision"] = revision
            __props__.__dict__["sequenced_rollout"] = sequenced_rollout
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["basepaths"] = None
            __props__.__dict__["deploy_start_time"] = None
            __props__.__dict__["state"] = None
        super(EnvironmentApiRevisionDeployment, __self__).__init__(
            'gcp:apigee/environmentApiRevisionDeployment:EnvironmentApiRevisionDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api: Optional[pulumi.Input[_builtins.str]] = None,
            basepaths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            deploy_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            override: Optional[pulumi.Input[_builtins.bool]] = None,
            revision: Optional[pulumi.Input[_builtins.int]] = None,
            sequenced_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentApiRevisionDeployment':
        """
        Get an existing EnvironmentApiRevisionDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api: Apigee API proxy name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] basepaths: Basepaths associated with the deployed proxy.
        :param pulumi.Input[_builtins.str] deploy_start_time: RFC3339 timestamp when deployment started.
        :param pulumi.Input[_builtins.str] environment: Apigee environment name.
        :param pulumi.Input[_builtins.str] org_id: Apigee organization ID.
        :param pulumi.Input[_builtins.bool] override: If true, replaces other deployed revisions of this proxy in the environment.
        :param pulumi.Input[_builtins.int] revision: API proxy revision number to deploy.
        :param pulumi.Input[_builtins.bool] sequenced_rollout: If true, enables sequenced rollout for safe traffic switching.
        :param pulumi.Input[_builtins.str] service_account: Optional service account the deployed proxy runs as.
        :param pulumi.Input[_builtins.str] state: Deployment state reported by Apigee.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentApiRevisionDeploymentState.__new__(_EnvironmentApiRevisionDeploymentState)

        __props__.__dict__["api"] = api
        __props__.__dict__["basepaths"] = basepaths
        __props__.__dict__["deploy_start_time"] = deploy_start_time
        __props__.__dict__["environment"] = environment
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["override"] = override
        __props__.__dict__["revision"] = revision
        __props__.__dict__["sequenced_rollout"] = sequenced_rollout
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["state"] = state
        return EnvironmentApiRevisionDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def api(self) -> pulumi.Output[_builtins.str]:
        """
        Apigee API proxy name.
        """
        return pulumi.get(self, "api")

    @_builtins.property
    @pulumi.getter
    def basepaths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Basepaths associated with the deployed proxy.
        """
        return pulumi.get(self, "basepaths")

    @_builtins.property
    @pulumi.getter(name="deployStartTime")
    def deploy_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        RFC3339 timestamp when deployment started.
        """
        return pulumi.get(self, "deploy_start_time")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Apigee environment name.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        Apigee organization ID.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter
    def override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, replaces other deployed revisions of this proxy in the environment.
        """
        return pulumi.get(self, "override")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Output[_builtins.int]:
        """
        API proxy revision number to deploy.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="sequencedRollout")
    def sequenced_rollout(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, enables sequenced rollout for safe traffic switching.
        """
        return pulumi.get(self, "sequenced_rollout")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional service account the deployed proxy runs as.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment state reported by Apigee.
        """
        return pulumi.get(self, "state")

