# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityProfileV2Args', 'SecurityProfileV2']

@pulumi.input_type
class SecurityProfileV2Args:
    def __init__(__self__, *,
                 org_id: pulumi.Input[_builtins.str],
                 profile_assessment_configs: pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]],
                 profile_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityProfileV2 resource.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee Security Profile V2,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]] profile_assessment_configs: A map of the assessment name and the assessment config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] profile_id: Resource ID of the security profile.
        :param pulumi.Input[_builtins.str] description: Description of the security profile.
        """
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "profile_assessment_configs", profile_assessment_configs)
        pulumi.set(__self__, "profile_id", profile_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee Security Profile V2,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="profileAssessmentConfigs")
    def profile_assessment_configs(self) -> pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]]:
        """
        A map of the assessment name and the assessment config.
        Structure is documented below.
        """
        return pulumi.get(self, "profile_assessment_configs")

    @profile_assessment_configs.setter
    def profile_assessment_configs(self, value: pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]]):
        pulumi.set(self, "profile_assessment_configs", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID of the security profile.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _SecurityProfileV2State:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_assessment_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityProfileV2 resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which this profile was created.
        :param pulumi.Input[_builtins.str] description: Description of the security profile.
        :param pulumi.Input[_builtins.str] name: Name of the security profile v2 resource,
               in the format `organizations/{{org_name}}/securityProfilesV2/{{profile_id}}`.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee Security Profile V2,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]] profile_assessment_configs: A map of the assessment name and the assessment config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] profile_id: Resource ID of the security profile.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which this profile was most recently updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if profile_assessment_configs is not None:
            pulumi.set(__self__, "profile_assessment_configs", profile_assessment_configs)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which this profile was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the security profile v2 resource,
        in the format `organizations/{{org_name}}/securityProfilesV2/{{profile_id}}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Apigee Organization associated with the Apigee Security Profile V2,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="profileAssessmentConfigs")
    def profile_assessment_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]]]:
        """
        A map of the assessment name and the assessment config.
        Structure is documented below.
        """
        return pulumi.get(self, "profile_assessment_configs")

    @profile_assessment_configs.setter
    def profile_assessment_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProfileV2ProfileAssessmentConfigArgs']]]]):
        pulumi.set(self, "profile_assessment_configs", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID of the security profile.
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which this profile was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apigee/securityProfileV2:SecurityProfileV2")
class SecurityProfileV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_assessment_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileV2ProfileAssessmentConfigArgs', 'SecurityProfileV2ProfileAssessmentConfigArgsDict']]]]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Security profile for risk assessment version 2 in Apigee.

        To get more information about SecurityProfileV2, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.securityProfilesV2/create)
        * How-to Guides
            * [Creating a security profile](https://cloud.google.com/apigee/docs/api-security/security-scores#security-profiles-v2)

        ## Example Usage

        ### Apigee Security Profile V2 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        security_profile_v2 = gcp.apigee.SecurityProfileV2("security_profile_v2",
            profile_id="my-profile",
            org_id=apigee_org.id,
            description="terraform test description",
            profile_assessment_configs=[
                {
                    "assessment": "auth-policies-check",
                    "weight": "MAJOR",
                },
                {
                    "assessment": "mediation-policies-check",
                    "weight": "MODERATE",
                },
                {
                    "assessment": "threat-policies-check",
                    "weight": "MINOR",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityProfileV2 can be imported using any of these accepted formats:

        * `{{org_id}}/securityProfilesV2/{{profile_id}}`

        * `{{org_id}}/{{profile_id}}`

        When using the `pulumi import` command, SecurityProfileV2 can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityProfileV2:SecurityProfileV2 default {{org_id}}/securityProfilesV2/{{profile_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityProfileV2:SecurityProfileV2 default {{org_id}}/{{profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the security profile.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee Security Profile V2,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileV2ProfileAssessmentConfigArgs', 'SecurityProfileV2ProfileAssessmentConfigArgsDict']]]] profile_assessment_configs: A map of the assessment name and the assessment config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] profile_id: Resource ID of the security profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityProfileV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Security profile for risk assessment version 2 in Apigee.

        To get more information about SecurityProfileV2, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.securityProfilesV2/create)
        * How-to Guides
            * [Creating a security profile](https://cloud.google.com/apigee/docs/api-security/security-scores#security-profiles-v2)

        ## Example Usage

        ### Apigee Security Profile V2 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        current = gcp.organizations.get_client_config()
        apigee_network = gcp.compute.Network("apigee_network", name="apigee-network")
        apigee_range = gcp.compute.GlobalAddress("apigee_range",
            name="apigee-range",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=apigee_network.id)
        apigee_vpc_connection = gcp.servicenetworking.Connection("apigee_vpc_connection",
            network=apigee_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[apigee_range.name])
        apigee_org = gcp.apigee.Organization("apigee_org",
            analytics_region="us-central1",
            project_id=current.project,
            authorized_network=apigee_network.id,
            opts = pulumi.ResourceOptions(depends_on=[apigee_vpc_connection]))
        apigee_org_security_addons_config = gcp.apigee.AddonsConfig("apigee_org_security_addons_config",
            org=apigee_org.name,
            addons_config={
                "api_security_config": {
                    "enabled": True,
                },
            })
        security_profile_v2 = gcp.apigee.SecurityProfileV2("security_profile_v2",
            profile_id="my-profile",
            org_id=apigee_org.id,
            description="terraform test description",
            profile_assessment_configs=[
                {
                    "assessment": "auth-policies-check",
                    "weight": "MAJOR",
                },
                {
                    "assessment": "mediation-policies-check",
                    "weight": "MODERATE",
                },
                {
                    "assessment": "threat-policies-check",
                    "weight": "MINOR",
                },
            ],
            opts = pulumi.ResourceOptions(depends_on=[apigee_org_security_addons_config]))
        ```

        ## Import

        SecurityProfileV2 can be imported using any of these accepted formats:

        * `{{org_id}}/securityProfilesV2/{{profile_id}}`

        * `{{org_id}}/{{profile_id}}`

        When using the `pulumi import` command, SecurityProfileV2 can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/securityProfileV2:SecurityProfileV2 default {{org_id}}/securityProfilesV2/{{profile_id}}
        ```

        ```sh
        $ pulumi import gcp:apigee/securityProfileV2:SecurityProfileV2 default {{org_id}}/{{profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityProfileV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityProfileV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_assessment_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileV2ProfileAssessmentConfigArgs', 'SecurityProfileV2ProfileAssessmentConfigArgsDict']]]]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityProfileV2Args.__new__(SecurityProfileV2Args)

            __props__.__dict__["description"] = description
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if profile_assessment_configs is None and not opts.urn:
                raise TypeError("Missing required property 'profile_assessment_configs'")
            __props__.__dict__["profile_assessment_configs"] = profile_assessment_configs
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(SecurityProfileV2, __self__).__init__(
            'gcp:apigee/securityProfileV2:SecurityProfileV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            profile_assessment_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileV2ProfileAssessmentConfigArgs', 'SecurityProfileV2ProfileAssessmentConfigArgsDict']]]]] = None,
            profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityProfileV2':
        """
        Get an existing SecurityProfileV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which this profile was created.
        :param pulumi.Input[_builtins.str] description: Description of the security profile.
        :param pulumi.Input[_builtins.str] name: Name of the security profile v2 resource,
               in the format `organizations/{{org_name}}/securityProfilesV2/{{profile_id}}`.
        :param pulumi.Input[_builtins.str] org_id: The Apigee Organization associated with the Apigee Security Profile V2,
               in the format `organizations/{{org_name}}`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityProfileV2ProfileAssessmentConfigArgs', 'SecurityProfileV2ProfileAssessmentConfigArgsDict']]]] profile_assessment_configs: A map of the assessment name and the assessment config.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] profile_id: Resource ID of the security profile.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which this profile was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityProfileV2State.__new__(_SecurityProfileV2State)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["profile_assessment_configs"] = profile_assessment_configs
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["update_time"] = update_time
        return SecurityProfileV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which this profile was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the security profile.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the security profile v2 resource,
        in the format `organizations/{{org_name}}/securityProfilesV2/{{profile_id}}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Apigee Organization associated with the Apigee Security Profile V2,
        in the format `organizations/{{org_name}}`.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="profileAssessmentConfigs")
    def profile_assessment_configs(self) -> pulumi.Output[Sequence['outputs.SecurityProfileV2ProfileAssessmentConfig']]:
        """
        A map of the assessment name and the assessment config.
        Structure is documented below.
        """
        return pulumi.get(self, "profile_assessment_configs")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID of the security profile.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which this profile was most recently updated.
        """
        return pulumi.get(self, "update_time")

