# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApiHubInstanceConfigArgs',
    'ApiHubInstanceConfigArgsDict',
    'CurationEndpointArgs',
    'CurationEndpointArgsDict',
    'CurationEndpointApplicationIntegrationEndpointDetailsArgs',
    'CurationEndpointApplicationIntegrationEndpointDetailsArgsDict',
    'CurationPluginInstanceActionArgs',
    'CurationPluginInstanceActionArgsDict',
    'PluginActionsConfigArgs',
    'PluginActionsConfigArgsDict',
    'PluginConfigTemplateArgs',
    'PluginConfigTemplateArgsDict',
    'PluginConfigTemplateAdditionalConfigTemplateArgs',
    'PluginConfigTemplateAdditionalConfigTemplateArgsDict',
    'PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs',
    'PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgsDict',
    'PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs',
    'PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgsDict',
    'PluginConfigTemplateAuthConfigTemplateArgs',
    'PluginConfigTemplateAuthConfigTemplateArgsDict',
    'PluginConfigTemplateAuthConfigTemplateServiceAccountArgs',
    'PluginConfigTemplateAuthConfigTemplateServiceAccountArgsDict',
    'PluginDocumentationArgs',
    'PluginDocumentationArgsDict',
    'PluginHostingServiceArgs',
    'PluginHostingServiceArgsDict',
    'PluginInstanceActionArgs',
    'PluginInstanceActionArgsDict',
    'PluginInstanceActionCurationConfigArgs',
    'PluginInstanceActionCurationConfigArgsDict',
    'PluginInstanceActionCurationConfigCustomCurationArgs',
    'PluginInstanceActionCurationConfigCustomCurationArgsDict',
    'PluginInstanceActionHubInstanceActionArgs',
    'PluginInstanceActionHubInstanceActionArgsDict',
    'PluginInstanceActionHubInstanceActionLastExecutionArgs',
    'PluginInstanceActionHubInstanceActionLastExecutionArgsDict',
    'PluginInstanceAuthConfigArgs',
    'PluginInstanceAuthConfigArgsDict',
    'PluginInstanceAuthConfigApiKeyConfigArgs',
    'PluginInstanceAuthConfigApiKeyConfigArgsDict',
    'PluginInstanceAuthConfigApiKeyConfigApiKeyArgs',
    'PluginInstanceAuthConfigApiKeyConfigApiKeyArgsDict',
    'PluginInstanceAuthConfigGoogleServiceAccountConfigArgs',
    'PluginInstanceAuthConfigGoogleServiceAccountConfigArgsDict',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgsDict',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs',
    'PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgsDict',
    'PluginInstanceAuthConfigUserPasswordConfigArgs',
    'PluginInstanceAuthConfigUserPasswordConfigArgsDict',
    'PluginInstanceAuthConfigUserPasswordConfigPasswordArgs',
    'PluginInstanceAuthConfigUserPasswordConfigPasswordArgsDict',
]

MYPY = False

if not MYPY:
    class ApiHubInstanceConfigArgsDict(TypedDict):
        cmek_key_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The Customer Managed Encryption Key (CMEK) used for data encryption.
        The CMEK name should follow the format of
        `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
        where the location must match the instance location.
        If the CMEK is not provided, a GMEK will be created for the instance.
        """
        disable_search: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. If true, the search will be disabled for the instance. The default value
        is false.
        """
        encryption_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. Encryption type for the region. If the encryption type is CMEK, the
        cmek_key_name must be provided. If no encryption type is provided,
        GMEK will be used.
        Possible values:
        ENCRYPTION_TYPE_UNSPECIFIED
        GMEK
        CMEK
        """
        vertex_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The name of the Vertex AI location where the data store is stored.
        """
elif False:
    ApiHubInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApiHubInstanceConfigArgs:
    def __init__(__self__, *,
                 cmek_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_search: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vertex_location: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] cmek_key_name: Optional. The Customer Managed Encryption Key (CMEK) used for data encryption.
               The CMEK name should follow the format of
               `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
               where the location must match the instance location.
               If the CMEK is not provided, a GMEK will be created for the instance.
        :param pulumi.Input[_builtins.bool] disable_search: Optional. If true, the search will be disabled for the instance. The default value
               is false.
        :param pulumi.Input[_builtins.str] encryption_type: Optional. Encryption type for the region. If the encryption type is CMEK, the
               cmek_key_name must be provided. If no encryption type is provided,
               GMEK will be used.
               Possible values:
               ENCRYPTION_TYPE_UNSPECIFIED
               GMEK
               CMEK
        :param pulumi.Input[_builtins.str] vertex_location: Optional. The name of the Vertex AI location where the data store is stored.
        """
        if cmek_key_name is not None:
            pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        if disable_search is not None:
            pulumi.set(__self__, "disable_search", disable_search)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if vertex_location is not None:
            pulumi.set(__self__, "vertex_location", vertex_location)

    @_builtins.property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The Customer Managed Encryption Key (CMEK) used for data encryption.
        The CMEK name should follow the format of
        `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`,
        where the location must match the instance location.
        If the CMEK is not provided, a GMEK will be created for the instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @cmek_key_name.setter
    def cmek_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cmek_key_name", value)

    @_builtins.property
    @pulumi.getter(name="disableSearch")
    def disable_search(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If true, the search will be disabled for the instance. The default value
        is false.
        """
        return pulumi.get(self, "disable_search")

    @disable_search.setter
    def disable_search(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_search", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Encryption type for the region. If the encryption type is CMEK, the
        cmek_key_name must be provided. If no encryption type is provided,
        GMEK will be used.
        Possible values:
        ENCRYPTION_TYPE_UNSPECIFIED
        GMEK
        CMEK
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="vertexLocation")
    def vertex_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The name of the Vertex AI location where the data store is stored.
        """
        return pulumi.get(self, "vertex_location")

    @vertex_location.setter
    def vertex_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vertex_location", value)


if not MYPY:
    class CurationEndpointArgsDict(TypedDict):
        application_integration_endpoint_details: pulumi.Input['CurationEndpointApplicationIntegrationEndpointDetailsArgsDict']
        """
        The details of the Application Integration endpoint to be triggered for
        curation.
        Structure is documented below.
        """
elif False:
    CurationEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CurationEndpointArgs:
    def __init__(__self__, *,
                 application_integration_endpoint_details: pulumi.Input['CurationEndpointApplicationIntegrationEndpointDetailsArgs']):
        """
        :param pulumi.Input['CurationEndpointApplicationIntegrationEndpointDetailsArgs'] application_integration_endpoint_details: The details of the Application Integration endpoint to be triggered for
               curation.
               Structure is documented below.
        """
        pulumi.set(__self__, "application_integration_endpoint_details", application_integration_endpoint_details)

    @_builtins.property
    @pulumi.getter(name="applicationIntegrationEndpointDetails")
    def application_integration_endpoint_details(self) -> pulumi.Input['CurationEndpointApplicationIntegrationEndpointDetailsArgs']:
        """
        The details of the Application Integration endpoint to be triggered for
        curation.
        Structure is documented below.
        """
        return pulumi.get(self, "application_integration_endpoint_details")

    @application_integration_endpoint_details.setter
    def application_integration_endpoint_details(self, value: pulumi.Input['CurationEndpointApplicationIntegrationEndpointDetailsArgs']):
        pulumi.set(self, "application_integration_endpoint_details", value)


if not MYPY:
    class CurationEndpointApplicationIntegrationEndpointDetailsArgsDict(TypedDict):
        trigger_id: pulumi.Input[_builtins.str]
        """
        The API trigger ID of the Application Integration workflow.
        """
        uri: pulumi.Input[_builtins.str]
        """
        The endpoint URI should be a valid REST URI for triggering an Application
        Integration.
        Format:
        `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        or
        `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        """
elif False:
    CurationEndpointApplicationIntegrationEndpointDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CurationEndpointApplicationIntegrationEndpointDetailsArgs:
    def __init__(__self__, *,
                 trigger_id: pulumi.Input[_builtins.str],
                 uri: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] trigger_id: The API trigger ID of the Application Integration workflow.
        :param pulumi.Input[_builtins.str] uri: The endpoint URI should be a valid REST URI for triggering an Application
               Integration.
               Format:
               `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
               or
               `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        """
        pulumi.set(__self__, "trigger_id", trigger_id)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Input[_builtins.str]:
        """
        The API trigger ID of the Application Integration workflow.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_id", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Input[_builtins.str]:
        """
        The endpoint URI should be a valid REST URI for triggering an Application
        Integration.
        Format:
        `https://integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        or
        `https://{location}-integrations.googleapis.com/v1/{name=projects/*/locations/*/integrations/*}:execute`
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class CurationPluginInstanceActionArgsDict(TypedDict):
        action_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The action ID that is using the curation.
        This should map to one of the action IDs specified
        in action configs in the plugin.
        """
        plugin_instance: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Plugin instance that is using the curation.
        Format is
        `projects/{project}/locations/{locati on}/plugins/{plugin}/instances/{instance}`
        """
elif False:
    CurationPluginInstanceActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CurationPluginInstanceActionArgs:
    def __init__(__self__, *,
                 action_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_instance: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action_id: (Output)
               The action ID that is using the curation.
               This should map to one of the action IDs specified
               in action configs in the plugin.
        :param pulumi.Input[_builtins.str] plugin_instance: (Output)
               Plugin instance that is using the curation.
               Format is
               `projects/{project}/locations/{locati on}/plugins/{plugin}/instances/{instance}`
        """
        if action_id is not None:
            pulumi.set(__self__, "action_id", action_id)
        if plugin_instance is not None:
            pulumi.set(__self__, "plugin_instance", plugin_instance)

    @_builtins.property
    @pulumi.getter(name="actionId")
    def action_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The action ID that is using the curation.
        This should map to one of the action IDs specified
        in action configs in the plugin.
        """
        return pulumi.get(self, "action_id")

    @action_id.setter
    def action_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_id", value)

    @_builtins.property
    @pulumi.getter(name="pluginInstance")
    def plugin_instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Plugin instance that is using the curation.
        Format is
        `projects/{project}/locations/{locati on}/plugins/{plugin}/instances/{instance}`
        """
        return pulumi.get(self, "plugin_instance")

    @plugin_instance.setter
    def plugin_instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugin_instance", value)


if not MYPY:
    class PluginActionsConfigArgsDict(TypedDict):
        description: pulumi.Input[_builtins.str]
        """
        The description of the operation performed by the action.
        """
        display_name: pulumi.Input[_builtins.str]
        """
        The display name of the action.
        """
        id: pulumi.Input[_builtins.str]
        """
        The id of the action.
        """
        trigger_mode: pulumi.Input[_builtins.str]
        """
        The trigger mode supported by the action.
        Possible values:
        TRIGGER_MODE_UNSPECIFIED
        API_HUB_ON_DEMAND_TRIGGER
        API_HUB_SCHEDULE_TRIGGER
        NON_API_HUB_MANAGED
        """
elif False:
    PluginActionsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginActionsConfigArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 id: pulumi.Input[_builtins.str],
                 trigger_mode: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] description: The description of the operation performed by the action.
        :param pulumi.Input[_builtins.str] display_name: The display name of the action.
        :param pulumi.Input[_builtins.str] id: The id of the action.
        :param pulumi.Input[_builtins.str] trigger_mode: The trigger mode supported by the action.
               Possible values:
               TRIGGER_MODE_UNSPECIFIED
               API_HUB_ON_DEMAND_TRIGGER
               API_HUB_SCHEDULE_TRIGGER
               NON_API_HUB_MANAGED
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "trigger_mode", trigger_mode)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the operation performed by the action.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the action.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the action.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="triggerMode")
    def trigger_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The trigger mode supported by the action.
        Possible values:
        TRIGGER_MODE_UNSPECIFIED
        API_HUB_ON_DEMAND_TRIGGER
        API_HUB_SCHEDULE_TRIGGER
        NON_API_HUB_MANAGED
        """
        return pulumi.get(self, "trigger_mode")

    @trigger_mode.setter
    def trigger_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "trigger_mode", value)


if not MYPY:
    class PluginConfigTemplateArgsDict(TypedDict):
        additional_config_templates: NotRequired[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateArgsDict']]]]
        """
        The list of additional configuration variables for the plugin's
        configuration.
        Structure is documented below.
        """
        auth_config_template: NotRequired[pulumi.Input['PluginConfigTemplateAuthConfigTemplateArgsDict']]
        """
        AuthConfigTemplate represents the authentication template for a plugin.
        Structure is documented below.
        """
elif False:
    PluginConfigTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateArgs:
    def __init__(__self__, *,
                 additional_config_templates: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateArgs']]]] = None,
                 auth_config_template: Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateArgs']]] additional_config_templates: The list of additional configuration variables for the plugin's
               configuration.
               Structure is documented below.
        :param pulumi.Input['PluginConfigTemplateAuthConfigTemplateArgs'] auth_config_template: AuthConfigTemplate represents the authentication template for a plugin.
               Structure is documented below.
        """
        if additional_config_templates is not None:
            pulumi.set(__self__, "additional_config_templates", additional_config_templates)
        if auth_config_template is not None:
            pulumi.set(__self__, "auth_config_template", auth_config_template)

    @_builtins.property
    @pulumi.getter(name="additionalConfigTemplates")
    def additional_config_templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateArgs']]]]:
        """
        The list of additional configuration variables for the plugin's
        configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_config_templates")

    @additional_config_templates.setter
    def additional_config_templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateArgs']]]]):
        pulumi.set(self, "additional_config_templates", value)

    @_builtins.property
    @pulumi.getter(name="authConfigTemplate")
    def auth_config_template(self) -> Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateArgs']]:
        """
        AuthConfigTemplate represents the authentication template for a plugin.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config_template")

    @auth_config_template.setter
    def auth_config_template(self, value: Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateArgs']]):
        pulumi.set(self, "auth_config_template", value)


if not MYPY:
    class PluginConfigTemplateAdditionalConfigTemplateArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        ID of the config variable. Must be unique within the configuration.
        """
        value_type: pulumi.Input[_builtins.str]
        """
        Type of the parameter: string, int, bool etc.
        Possible values:
        VALUE_TYPE_UNSPECIFIED
        STRING
        INT
        BOOL
        SECRET
        ENUM
        MULTI_SELECT
        MULTI_STRING
        MULTI_INT
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description.
        """
        enum_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgsDict']]]]
        """
        Enum options. To be populated if `ValueType` is `ENUM`.
        Structure is documented below.
        """
        multi_select_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgsDict']]]]
        """
        Multi select options. To be populated if `ValueType` is `MULTI_SELECT`.
        Structure is documented below.
        """
        required: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Flag represents that this `ConfigVariable` must be provided for a
        PluginInstance.
        """
        validation_regex: NotRequired[pulumi.Input[_builtins.str]]
        """
        Regular expression in RE2 syntax used for validating the `value` of a
        `ConfigVariable`.
        """
elif False:
    PluginConfigTemplateAdditionalConfigTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateAdditionalConfigTemplateArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str],
                 value_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enum_options: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs']]]] = None,
                 multi_select_options: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs']]]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 validation_regex: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: ID of the config variable. Must be unique within the configuration.
        :param pulumi.Input[_builtins.str] value_type: Type of the parameter: string, int, bool etc.
               Possible values:
               VALUE_TYPE_UNSPECIFIED
               STRING
               INT
               BOOL
               SECRET
               ENUM
               MULTI_SELECT
               MULTI_STRING
               MULTI_INT
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs']]] enum_options: Enum options. To be populated if `ValueType` is `ENUM`.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs']]] multi_select_options: Multi select options. To be populated if `ValueType` is `MULTI_SELECT`.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] required: Flag represents that this `ConfigVariable` must be provided for a
               PluginInstance.
        :param pulumi.Input[_builtins.str] validation_regex: Regular expression in RE2 syntax used for validating the `value` of a
               `ConfigVariable`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "value_type", value_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum_options is not None:
            pulumi.set(__self__, "enum_options", enum_options)
        if multi_select_options is not None:
            pulumi.set(__self__, "multi_select_options", multi_select_options)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if validation_regex is not None:
            pulumi.set(__self__, "validation_regex", validation_regex)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the config variable. Must be unique within the configuration.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the parameter: string, int, bool etc.
        Possible values:
        VALUE_TYPE_UNSPECIFIED
        STRING
        INT
        BOOL
        SECRET
        ENUM
        MULTI_SELECT
        MULTI_STRING
        MULTI_INT
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enumOptions")
    def enum_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs']]]]:
        """
        Enum options. To be populated if `ValueType` is `ENUM`.
        Structure is documented below.
        """
        return pulumi.get(self, "enum_options")

    @enum_options.setter
    def enum_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs']]]]):
        pulumi.set(self, "enum_options", value)

    @_builtins.property
    @pulumi.getter(name="multiSelectOptions")
    def multi_select_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs']]]]:
        """
        Multi select options. To be populated if `ValueType` is `MULTI_SELECT`.
        Structure is documented below.
        """
        return pulumi.get(self, "multi_select_options")

    @multi_select_options.setter
    def multi_select_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs']]]]):
        pulumi.set(self, "multi_select_options", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag represents that this `ConfigVariable` must be provided for a
        PluginInstance.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter(name="validationRegex")
    def validation_regex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regular expression in RE2 syntax used for validating the `value` of a
        `ConfigVariable`.
        """
        return pulumi.get(self, "validation_regex")

    @validation_regex.setter
    def validation_regex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_regex", value)


if not MYPY:
    class PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgsDict(TypedDict):
        display_name: pulumi.Input[_builtins.str]
        """
        Display name of the option.
        """
        id: pulumi.Input[_builtins.str]
        """
        Id of the option.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the option.
        """
elif False:
    PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateAdditionalConfigTemplateEnumOptionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] display_name: Display name of the option.
        :param pulumi.Input[_builtins.str] id: Id of the option.
        :param pulumi.Input[_builtins.str] description: Description of the option.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the option.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the option.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the option.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgsDict(TypedDict):
        display_name: pulumi.Input[_builtins.str]
        """
        Display name of the option.
        """
        id: pulumi.Input[_builtins.str]
        """
        Id of the option.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the option.
        """
elif False:
    PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateAdditionalConfigTemplateMultiSelectOptionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] display_name: Display name of the option.
        :param pulumi.Input[_builtins.str] id: Id of the option.
        :param pulumi.Input[_builtins.str] description: Description of the option.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the option.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the option.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the option.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class PluginConfigTemplateAuthConfigTemplateArgsDict(TypedDict):
        supported_auth_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of authentication types supported by the plugin.
        """
        service_account: NotRequired[pulumi.Input['PluginConfigTemplateAuthConfigTemplateServiceAccountArgsDict']]
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
elif False:
    PluginConfigTemplateAuthConfigTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateAuthConfigTemplateArgs:
    def __init__(__self__, *,
                 supported_auth_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 service_account: Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateServiceAccountArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_auth_types: The list of authentication types supported by the plugin.
        :param pulumi.Input['PluginConfigTemplateAuthConfigTemplateServiceAccountArgs'] service_account: Config for Google service account authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "supported_auth_types", supported_auth_types)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="supportedAuthTypes")
    def supported_auth_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of authentication types supported by the plugin.
        """
        return pulumi.get(self, "supported_auth_types")

    @supported_auth_types.setter
    def supported_auth_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "supported_auth_types", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateServiceAccountArgs']]:
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['PluginConfigTemplateAuthConfigTemplateServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class PluginConfigTemplateAuthConfigTemplateServiceAccountArgsDict(TypedDict):
        service_account: pulumi.Input[_builtins.str]
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
elif False:
    PluginConfigTemplateAuthConfigTemplateServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginConfigTemplateAuthConfigTemplateServiceAccountArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] service_account: The service account to be used for authenticating request.
               The `iam.serviceAccounts.getAccessToken` permission should be granted on
               this service account to the impersonator service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[_builtins.str]:
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class PluginDocumentationArgsDict(TypedDict):
        external_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        The uri of the externally hosted documentation.
        """
elif False:
    PluginDocumentationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginDocumentationArgs:
    def __init__(__self__, *,
                 external_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] external_uri: The uri of the externally hosted documentation.
        """
        if external_uri is not None:
            pulumi.set(__self__, "external_uri", external_uri)

    @_builtins.property
    @pulumi.getter(name="externalUri")
    def external_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uri of the externally hosted documentation.
        """
        return pulumi.get(self, "external_uri")

    @external_uri.setter
    def external_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_uri", value)


if not MYPY:
    class PluginHostingServiceArgsDict(TypedDict):
        service_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI of the service implemented by the plugin developer, used to
        invoke the plugin's functionality. This information is only required for
        user defined plugins.
        """
elif False:
    PluginHostingServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginHostingServiceArgs:
    def __init__(__self__, *,
                 service_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] service_uri: The URI of the service implemented by the plugin developer, used to
               invoke the plugin's functionality. This information is only required for
               user defined plugins.
        """
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @_builtins.property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the service implemented by the plugin developer, used to
        invoke the plugin's functionality. This information is only required for
        user defined plugins.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_uri", value)


if not MYPY:
    class PluginInstanceActionArgsDict(TypedDict):
        action_id: pulumi.Input[_builtins.str]
        """
        This should map to one of the action id specified
        in actions_config in the plugin.
        """
        curation_config: NotRequired[pulumi.Input['PluginInstanceActionCurationConfigArgsDict']]
        """
        The curation information for this plugin instance.
        Structure is documented below.
        """
        hub_instance_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionArgsDict']]]]
        """
        (Output)
        The execution status for the plugin instance.
        Structure is documented below.
        """
        schedule_cron_expression: NotRequired[pulumi.Input[_builtins.str]]
        """
        The schedule for this plugin instance action. This can only be set if the
        plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        """
        schedule_time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The time zone for the schedule cron expression. If not provided, UTC will
        be used.


        <a name="nested_actions_actions_hub_instance_action"></a>The `hub_instance_action` block contains:
        """
        state: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The current state of the plugin action in the plugin instance.
        Possible values:
        STATE_UNSPECIFIED
        ENABLED
        DISABLED
        ENABLING
        DISABLING
        ERROR
        """
elif False:
    PluginInstanceActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceActionArgs:
    def __init__(__self__, *,
                 action_id: pulumi.Input[_builtins.str],
                 curation_config: Optional[pulumi.Input['PluginInstanceActionCurationConfigArgs']] = None,
                 hub_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionArgs']]]] = None,
                 schedule_cron_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action_id: This should map to one of the action id specified
               in actions_config in the plugin.
        :param pulumi.Input['PluginInstanceActionCurationConfigArgs'] curation_config: The curation information for this plugin instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionArgs']]] hub_instance_actions: (Output)
               The execution status for the plugin instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] schedule_cron_expression: The schedule for this plugin instance action. This can only be set if the
               plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        :param pulumi.Input[_builtins.str] schedule_time_zone: The time zone for the schedule cron expression. If not provided, UTC will
               be used.
               
               
               <a name="nested_actions_actions_hub_instance_action"></a>The `hub_instance_action` block contains:
        :param pulumi.Input[_builtins.str] state: (Output)
               The current state of the plugin action in the plugin instance.
               Possible values:
               STATE_UNSPECIFIED
               ENABLED
               DISABLED
               ENABLING
               DISABLING
               ERROR
        """
        pulumi.set(__self__, "action_id", action_id)
        if curation_config is not None:
            pulumi.set(__self__, "curation_config", curation_config)
        if hub_instance_actions is not None:
            pulumi.set(__self__, "hub_instance_actions", hub_instance_actions)
        if schedule_cron_expression is not None:
            pulumi.set(__self__, "schedule_cron_expression", schedule_cron_expression)
        if schedule_time_zone is not None:
            pulumi.set(__self__, "schedule_time_zone", schedule_time_zone)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="actionId")
    def action_id(self) -> pulumi.Input[_builtins.str]:
        """
        This should map to one of the action id specified
        in actions_config in the plugin.
        """
        return pulumi.get(self, "action_id")

    @action_id.setter
    def action_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action_id", value)

    @_builtins.property
    @pulumi.getter(name="curationConfig")
    def curation_config(self) -> Optional[pulumi.Input['PluginInstanceActionCurationConfigArgs']]:
        """
        The curation information for this plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "curation_config")

    @curation_config.setter
    def curation_config(self, value: Optional[pulumi.Input['PluginInstanceActionCurationConfigArgs']]):
        pulumi.set(self, "curation_config", value)

    @_builtins.property
    @pulumi.getter(name="hubInstanceActions")
    def hub_instance_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionArgs']]]]:
        """
        (Output)
        The execution status for the plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "hub_instance_actions")

    @hub_instance_actions.setter
    def hub_instance_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionArgs']]]]):
        pulumi.set(self, "hub_instance_actions", value)

    @_builtins.property
    @pulumi.getter(name="scheduleCronExpression")
    def schedule_cron_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule for this plugin instance action. This can only be set if the
        plugin supports API_HUB_SCHEDULE_TRIGGER mode for this action.
        """
        return pulumi.get(self, "schedule_cron_expression")

    @schedule_cron_expression.setter
    def schedule_cron_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_cron_expression", value)

    @_builtins.property
    @pulumi.getter(name="scheduleTimeZone")
    def schedule_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone for the schedule cron expression. If not provided, UTC will
        be used.


        <a name="nested_actions_actions_hub_instance_action"></a>The `hub_instance_action` block contains:
        """
        return pulumi.get(self, "schedule_time_zone")

    @schedule_time_zone.setter
    def schedule_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_time_zone", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The current state of the plugin action in the plugin instance.
        Possible values:
        STATE_UNSPECIFIED
        ENABLED
        DISABLED
        ENABLING
        DISABLING
        ERROR
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class PluginInstanceActionCurationConfigArgsDict(TypedDict):
        curation_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Possible values:
        CURATION_TYPE_UNSPECIFIED
        DEFAULT_CURATION_FOR_API_METADATA
        CUSTOM_CURATION_FOR_API_METADATA
        """
        custom_curation: NotRequired[pulumi.Input['PluginInstanceActionCurationConfigCustomCurationArgsDict']]
        """
        Custom curation information for this plugin instance.
        Structure is documented below.
        """
elif False:
    PluginInstanceActionCurationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceActionCurationConfigArgs:
    def __init__(__self__, *,
                 curation_type: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_curation: Optional[pulumi.Input['PluginInstanceActionCurationConfigCustomCurationArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] curation_type: Possible values:
               CURATION_TYPE_UNSPECIFIED
               DEFAULT_CURATION_FOR_API_METADATA
               CUSTOM_CURATION_FOR_API_METADATA
        :param pulumi.Input['PluginInstanceActionCurationConfigCustomCurationArgs'] custom_curation: Custom curation information for this plugin instance.
               Structure is documented below.
        """
        if curation_type is not None:
            pulumi.set(__self__, "curation_type", curation_type)
        if custom_curation is not None:
            pulumi.set(__self__, "custom_curation", custom_curation)

    @_builtins.property
    @pulumi.getter(name="curationType")
    def curation_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values:
        CURATION_TYPE_UNSPECIFIED
        DEFAULT_CURATION_FOR_API_METADATA
        CUSTOM_CURATION_FOR_API_METADATA
        """
        return pulumi.get(self, "curation_type")

    @curation_type.setter
    def curation_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curation_type", value)

    @_builtins.property
    @pulumi.getter(name="customCuration")
    def custom_curation(self) -> Optional[pulumi.Input['PluginInstanceActionCurationConfigCustomCurationArgs']]:
        """
        Custom curation information for this plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_curation")

    @custom_curation.setter
    def custom_curation(self, value: Optional[pulumi.Input['PluginInstanceActionCurationConfigCustomCurationArgs']]):
        pulumi.set(self, "custom_curation", value)


if not MYPY:
    class PluginInstanceActionCurationConfigCustomCurationArgsDict(TypedDict):
        curation: pulumi.Input[_builtins.str]
        """
        The unique name of the curation resource. This will be the name of the
        curation resource in the format:
        `projects/{project}/locations/{location}/curations/{curation}`
        """
elif False:
    PluginInstanceActionCurationConfigCustomCurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceActionCurationConfigCustomCurationArgs:
    def __init__(__self__, *,
                 curation: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] curation: The unique name of the curation resource. This will be the name of the
               curation resource in the format:
               `projects/{project}/locations/{location}/curations/{curation}`
        """
        pulumi.set(__self__, "curation", curation)

    @_builtins.property
    @pulumi.getter
    def curation(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the curation resource. This will be the name of the
        curation resource in the format:
        `projects/{project}/locations/{location}/curations/{curation}`
        """
        return pulumi.get(self, "curation")

    @curation.setter
    def curation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "curation", value)


if not MYPY:
    class PluginInstanceActionHubInstanceActionArgsDict(TypedDict):
        current_execution_state: NotRequired[pulumi.Input[_builtins.str]]
        """
        The current state of the execution.
        Possible values:
        CURRENT_EXECUTION_STATE_UNSPECIFIED
        RUNNING
        NOT_RUNNING
        """
        last_executions: NotRequired[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionLastExecutionArgsDict']]]]
        """
        The result of the last execution of the plugin instance.
        """
elif False:
    PluginInstanceActionHubInstanceActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceActionHubInstanceActionArgs:
    def __init__(__self__, *,
                 current_execution_state: Optional[pulumi.Input[_builtins.str]] = None,
                 last_executions: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionLastExecutionArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] current_execution_state: The current state of the execution.
               Possible values:
               CURRENT_EXECUTION_STATE_UNSPECIFIED
               RUNNING
               NOT_RUNNING
        :param pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionLastExecutionArgs']]] last_executions: The result of the last execution of the plugin instance.
        """
        if current_execution_state is not None:
            pulumi.set(__self__, "current_execution_state", current_execution_state)
        if last_executions is not None:
            pulumi.set(__self__, "last_executions", last_executions)

    @_builtins.property
    @pulumi.getter(name="currentExecutionState")
    def current_execution_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the execution.
        Possible values:
        CURRENT_EXECUTION_STATE_UNSPECIFIED
        RUNNING
        NOT_RUNNING
        """
        return pulumi.get(self, "current_execution_state")

    @current_execution_state.setter
    def current_execution_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_execution_state", value)

    @_builtins.property
    @pulumi.getter(name="lastExecutions")
    def last_executions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionLastExecutionArgs']]]]:
        """
        The result of the last execution of the plugin instance.
        """
        return pulumi.get(self, "last_executions")

    @last_executions.setter
    def last_executions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluginInstanceActionHubInstanceActionLastExecutionArgs']]]]):
        pulumi.set(self, "last_executions", value)


if not MYPY:
    class PluginInstanceActionHubInstanceActionLastExecutionArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last execution end time of the plugin instance.
        """
        error_message: NotRequired[pulumi.Input[_builtins.str]]
        """
        Error message describing the failure, if any, during Create, Delete or
        ApplyConfig operation corresponding to the plugin instance.This field will
        only be populated if the plugin instance is in the ERROR or FAILED state.
        """
        result: NotRequired[pulumi.Input[_builtins.str]]
        """
        The result of the last execution of the plugin instance.
        Possible values:
        RESULT_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        The last execution start time of the plugin instance.
        """
elif False:
    PluginInstanceActionHubInstanceActionLastExecutionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceActionHubInstanceActionLastExecutionArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 error_message: Optional[pulumi.Input[_builtins.str]] = None,
                 result: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] end_time: The last execution end time of the plugin instance.
        :param pulumi.Input[_builtins.str] error_message: Error message describing the failure, if any, during Create, Delete or
               ApplyConfig operation corresponding to the plugin instance.This field will
               only be populated if the plugin instance is in the ERROR or FAILED state.
        :param pulumi.Input[_builtins.str] result: The result of the last execution of the plugin instance.
               Possible values:
               RESULT_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param pulumi.Input[_builtins.str] start_time: The last execution start time of the plugin instance.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last execution end time of the plugin instance.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message describing the failure, if any, during Create, Delete or
        ApplyConfig operation corresponding to the plugin instance.This field will
        only be populated if the plugin instance is in the ERROR or FAILED state.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_message", value)

    @_builtins.property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The result of the last execution of the plugin instance.
        Possible values:
        RESULT_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "result", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last execution start time of the plugin instance.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class PluginInstanceAuthConfigArgsDict(TypedDict):
        auth_type: pulumi.Input[_builtins.str]
        """
        Possible values:
        AUTH_TYPE_UNSPECIFIED
        NO_AUTH
        GOOGLE_SERVICE_ACCOUNT
        USER_PASSWORD
        API_KEY
        OAUTH2_CLIENT_CREDENTIALS
        """
        api_key_config: NotRequired[pulumi.Input['PluginInstanceAuthConfigApiKeyConfigArgsDict']]
        """
        Config for authentication with API key.
        Structure is documented below.
        """
        google_service_account_config: NotRequired[pulumi.Input['PluginInstanceAuthConfigGoogleServiceAccountConfigArgsDict']]
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
        oauth2_client_credentials_config: NotRequired[pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgsDict']]
        """
        Parameters to support Oauth 2.0 client credentials grant authentication.
        See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
        Structure is documented below.
        """
        user_password_config: NotRequired[pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigArgsDict']]
        """
        Parameters to support Username and Password Authentication.
        Structure is documented below.
        """
elif False:
    PluginInstanceAuthConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[_builtins.str],
                 api_key_config: Optional[pulumi.Input['PluginInstanceAuthConfigApiKeyConfigArgs']] = None,
                 google_service_account_config: Optional[pulumi.Input['PluginInstanceAuthConfigGoogleServiceAccountConfigArgs']] = None,
                 oauth2_client_credentials_config: Optional[pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs']] = None,
                 user_password_config: Optional[pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] auth_type: Possible values:
               AUTH_TYPE_UNSPECIFIED
               NO_AUTH
               GOOGLE_SERVICE_ACCOUNT
               USER_PASSWORD
               API_KEY
               OAUTH2_CLIENT_CREDENTIALS
        :param pulumi.Input['PluginInstanceAuthConfigApiKeyConfigArgs'] api_key_config: Config for authentication with API key.
               Structure is documented below.
        :param pulumi.Input['PluginInstanceAuthConfigGoogleServiceAccountConfigArgs'] google_service_account_config: Config for Google service account authentication.
               Structure is documented below.
        :param pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs'] oauth2_client_credentials_config: Parameters to support Oauth 2.0 client credentials grant authentication.
               See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
               Structure is documented below.
        :param pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigArgs'] user_password_config: Parameters to support Username and Password Authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if api_key_config is not None:
            pulumi.set(__self__, "api_key_config", api_key_config)
        if google_service_account_config is not None:
            pulumi.set(__self__, "google_service_account_config", google_service_account_config)
        if oauth2_client_credentials_config is not None:
            pulumi.set(__self__, "oauth2_client_credentials_config", oauth2_client_credentials_config)
        if user_password_config is not None:
            pulumi.set(__self__, "user_password_config", user_password_config)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[_builtins.str]:
        """
        Possible values:
        AUTH_TYPE_UNSPECIFIED
        NO_AUTH
        GOOGLE_SERVICE_ACCOUNT
        USER_PASSWORD
        API_KEY
        OAUTH2_CLIENT_CREDENTIALS
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_type", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyConfig")
    def api_key_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigApiKeyConfigArgs']]:
        """
        Config for authentication with API key.
        Structure is documented below.
        """
        return pulumi.get(self, "api_key_config")

    @api_key_config.setter
    def api_key_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigApiKeyConfigArgs']]):
        pulumi.set(self, "api_key_config", value)

    @_builtins.property
    @pulumi.getter(name="googleServiceAccountConfig")
    def google_service_account_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigGoogleServiceAccountConfigArgs']]:
        """
        Config for Google service account authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "google_service_account_config")

    @google_service_account_config.setter
    def google_service_account_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigGoogleServiceAccountConfigArgs']]):
        pulumi.set(self, "google_service_account_config", value)

    @_builtins.property
    @pulumi.getter(name="oauth2ClientCredentialsConfig")
    def oauth2_client_credentials_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs']]:
        """
        Parameters to support Oauth 2.0 client credentials grant authentication.
        See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_client_credentials_config")

    @oauth2_client_credentials_config.setter
    def oauth2_client_credentials_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs']]):
        pulumi.set(self, "oauth2_client_credentials_config", value)

    @_builtins.property
    @pulumi.getter(name="userPasswordConfig")
    def user_password_config(self) -> Optional[pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigArgs']]:
        """
        Parameters to support Username and Password Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "user_password_config")

    @user_password_config.setter
    def user_password_config(self, value: Optional[pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigArgs']]):
        pulumi.set(self, "user_password_config", value)


if not MYPY:
    class PluginInstanceAuthConfigApiKeyConfigArgsDict(TypedDict):
        api_key: pulumi.Input['PluginInstanceAuthConfigApiKeyConfigApiKeyArgsDict']
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        http_element_location: pulumi.Input[_builtins.str]
        """
        The location of the API key.
        The default value is QUERY.
        Possible values:
        HTTP_ELEMENT_LOCATION_UNSPECIFIED
        QUERY
        HEADER
        PATH
        BODY
        COOKIE
        """
        name: pulumi.Input[_builtins.str]
        """
        The parameter name of the API key.
        E.g. If the API request is "https://example.com/act?api_key=",
        "api_key" would be the parameter name.
        """
elif False:
    PluginInstanceAuthConfigApiKeyConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigApiKeyConfigArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input['PluginInstanceAuthConfigApiKeyConfigApiKeyArgs'],
                 http_element_location: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input['PluginInstanceAuthConfigApiKeyConfigApiKeyArgs'] api_key: Secret provides a reference to entries in Secret Manager.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] http_element_location: The location of the API key.
               The default value is QUERY.
               Possible values:
               HTTP_ELEMENT_LOCATION_UNSPECIFIED
               QUERY
               HEADER
               PATH
               BODY
               COOKIE
        :param pulumi.Input[_builtins.str] name: The parameter name of the API key.
               E.g. If the API request is "https://example.com/act?api_key=",
               "api_key" would be the parameter name.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "http_element_location", http_element_location)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input['PluginInstanceAuthConfigApiKeyConfigApiKeyArgs']:
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input['PluginInstanceAuthConfigApiKeyConfigApiKeyArgs']):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="httpElementLocation")
    def http_element_location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the API key.
        The default value is QUERY.
        Possible values:
        HTTP_ELEMENT_LOCATION_UNSPECIFIED
        QUERY
        HEADER
        PATH
        BODY
        COOKIE
        """
        return pulumi.get(self, "http_element_location")

    @http_element_location.setter
    def http_element_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "http_element_location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The parameter name of the API key.
        E.g. If the API request is "https://example.com/act?api_key=",
        "api_key" would be the parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class PluginInstanceAuthConfigApiKeyConfigApiKeyArgsDict(TypedDict):
        secret_version: pulumi.Input[_builtins.str]
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.

        <a name="nested_auth_config_oauth2_client_credentials_config"></a>The `oauth2_client_credentials_config` block supports:
        """
elif False:
    PluginInstanceAuthConfigApiKeyConfigApiKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigApiKeyConfigApiKeyArgs:
    def __init__(__self__, *,
                 secret_version: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
               
               <a name="nested_auth_config_oauth2_client_credentials_config"></a>The `oauth2_client_credentials_config` block supports:
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.

        <a name="nested_auth_config_oauth2_client_credentials_config"></a>The `oauth2_client_credentials_config` block supports:
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_version", value)


if not MYPY:
    class PluginInstanceAuthConfigGoogleServiceAccountConfigArgsDict(TypedDict):
        service_account: pulumi.Input[_builtins.str]
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
elif False:
    PluginInstanceAuthConfigGoogleServiceAccountConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigGoogleServiceAccountConfigArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] service_account: The service account to be used for authenticating request.
               The `iam.serviceAccounts.getAccessToken` permission should be granted on
               this service account to the impersonator service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[_builtins.str]:
        """
        The service account to be used for authenticating request.
        The `iam.serviceAccounts.getAccessToken` permission should be granted on
        this service account to the impersonator service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgsDict(TypedDict):
        client_id: pulumi.Input[_builtins.str]
        """
        The client identifier.
        """
        client_secret: pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgsDict']
        """
        Secret provides a reference to entries in Secret Manager.
        """
elif False:
    PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigOauth2ClientCredentialsConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs']):
        """
        :param pulumi.Input[_builtins.str] client_id: The client identifier.
        :param pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs'] client_secret: Secret provides a reference to entries in Secret Manager.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs']:
        """
        Secret provides a reference to entries in Secret Manager.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input['PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs']):
        pulumi.set(self, "client_secret", value)


if not MYPY:
    class PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgsDict(TypedDict):
        secret_version: pulumi.Input[_builtins.str]
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
elif False:
    PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigOauth2ClientCredentialsConfigClientSecretArgs:
    def __init__(__self__, *,
                 secret_version: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_version", value)


if not MYPY:
    class PluginInstanceAuthConfigUserPasswordConfigArgsDict(TypedDict):
        password: pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigPasswordArgsDict']
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        username: pulumi.Input[_builtins.str]
        """
        Username.
        """
elif False:
    PluginInstanceAuthConfigUserPasswordConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigUserPasswordConfigArgs:
    def __init__(__self__, *,
                 password: pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigPasswordArgs'],
                 username: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigPasswordArgs'] password: Secret provides a reference to entries in Secret Manager.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] username: Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigPasswordArgs']:
        """
        Secret provides a reference to entries in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input['PluginInstanceAuthConfigUserPasswordConfigPasswordArgs']):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class PluginInstanceAuthConfigUserPasswordConfigPasswordArgsDict(TypedDict):
        secret_version: pulumi.Input[_builtins.str]
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
elif False:
    PluginInstanceAuthConfigUserPasswordConfigPasswordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PluginInstanceAuthConfigUserPasswordConfigPasswordArgs:
    def __init__(__self__, *,
                 secret_version: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_version: The resource name of the secret version in the format,
               format as: `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name of the secret version in the format,
        format as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_version", value)


