# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiHubInstanceArgs', 'ApiHubInstance']

@pulumi.input_type
class ApiHubInstanceArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['ApiHubInstanceConfigArgs'],
                 location: pulumi.Input[_builtins.str],
                 api_hub_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApiHubInstance resource.
        :param pulumi.Input['ApiHubInstanceConfigArgs'] config: Available configurations to provision an ApiHub Instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] api_hub_instance_id: Optional. Identifier to assign to the Api Hub instance. Must be unique within
               scope of the parent resource. If the field is not provided,
               system generated id will be used.
               This value should be 4-40 characters, and valid characters
               are `/a-z[0-9]-_/`.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the ApiHub instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Instance labels to represent user-provided metadata.
               Refer to cloud documentation on labels for more details.
               https://cloud.google.com/compute/docs/labeling-resources
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "location", location)
        if api_hub_instance_id is not None:
            pulumi.set(__self__, "api_hub_instance_id", api_hub_instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['ApiHubInstanceConfigArgs']:
        """
        Available configurations to provision an ApiHub Instance.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['ApiHubInstanceConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="apiHubInstanceId")
    def api_hub_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Identifier to assign to the Api Hub instance. Must be unique within
        scope of the parent resource. If the field is not provided,
        system generated id will be used.
        This value should be 4-40 characters, and valid characters
        are `/a-z[0-9]-_/`.
        """
        return pulumi.get(self, "api_hub_instance_id")

    @api_hub_instance_id.setter
    def api_hub_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_hub_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Description of the ApiHub instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Instance labels to represent user-provided metadata.
        Refer to cloud documentation on labels for more details.
        https://cloud.google.com/compute/docs/labeling-resources
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ApiHubInstanceState:
    def __init__(__self__, *,
                 api_hub_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input['ApiHubInstanceConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_message: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiHubInstance resources.
        :param pulumi.Input[_builtins.str] api_hub_instance_id: Optional. Identifier to assign to the Api Hub instance. Must be unique within
               scope of the parent resource. If the field is not provided,
               system generated id will be used.
               This value should be 4-40 characters, and valid characters
               are `/a-z[0-9]-_/`.
        :param pulumi.Input['ApiHubInstanceConfigArgs'] config: Available configurations to provision an ApiHub Instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Output only. Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the ApiHub instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Instance labels to represent user-provided metadata.
               Refer to cloud documentation on labels for more details.
               https://cloud.google.com/compute/docs/labeling-resources
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. Format:
               `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: Output only. The current state of the ApiHub instance.
               Possible values:
               STATE_UNSPECIFIED
               INACTIVE
               CREATING
               ACTIVE
               UPDATING
               DELETING
               FAILED
        :param pulumi.Input[_builtins.str] state_message: Output only. Extra information about ApiHub instance state. Currently the message
               would be populated when state is `FAILED`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Last update timestamp.
        """
        if api_hub_instance_id is not None:
            pulumi.set(__self__, "api_hub_instance_id", api_hub_instance_id)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="apiHubInstanceId")
    def api_hub_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Identifier to assign to the Api Hub instance. Must be unique within
        scope of the parent resource. If the field is not provided,
        system generated id will be used.
        This value should be 4-40 characters, and valid characters
        are `/a-z[0-9]-_/`.
        """
        return pulumi.get(self, "api_hub_instance_id")

    @api_hub_instance_id.setter
    def api_hub_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_hub_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ApiHubInstanceConfigArgs']]:
        """
        Available configurations to provision an ApiHub Instance.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ApiHubInstanceConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Creation timestamp.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Description of the ApiHub instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Instance labels to represent user-provided metadata.
        Refer to cloud documentation on labels for more details.
        https://cloud.google.com/compute/docs/labeling-resources
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Format:
        `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The current state of the ApiHub instance.
        Possible values:
        STATE_UNSPECIFIED
        INACTIVE
        CREATING
        ACTIVE
        UPDATING
        DELETING
        FAILED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Extra information about ApiHub instance state. Currently the message
        would be populated when state is `FAILED`.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_message", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Last update timestamp.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apihub/apiHubInstance:ApiHubInstance")
class ApiHubInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_hub_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ApiHubInstanceConfigArgs', 'ApiHubInstanceConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An ApiHubInstance represents the instance resources of the API Hub.
        Currently, only one ApiHub instance is allowed for each project.
        Currently, updation/deletion of ApiHub instance is not allowed.

        ## Example Usage

        ### Apihub Api Hub Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_instance_without_search = gcp.apihub.ApiHubInstance("apihub-instance-without-search",
            location="us-central1",
            config={
                "disable_search": True,
            })
        ```
        ### Apihub Api Hub Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_instance_search = gcp.apihub.ApiHubInstance("apihub-instance-search",
            project="my-project",
            api_hub_instance_id="test-instance-full",
            description="Test API hub instance",
            location="us-central1",
            config={
                "encryption_type": "CMEK",
                "cmek_key_name": "projects/my-project/locations/us-central1/keyRings/apihub/cryptoKeys/apihub-key",
                "disable_search": False,
                "vertex_location": "us",
            },
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        ApiHubInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apiHubInstances/{{api_hub_instance_id}}`

        * `{{project}}/{{location}}/{{api_hub_instance_id}}`

        * `{{location}}/{{api_hub_instance_id}}`

        When using the `pulumi import` command, ApiHubInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default projects/{{project}}/locations/{{location}}/apiHubInstances/{{api_hub_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default {{project}}/{{location}}/{{api_hub_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default {{location}}/{{api_hub_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_hub_instance_id: Optional. Identifier to assign to the Api Hub instance. Must be unique within
               scope of the parent resource. If the field is not provided,
               system generated id will be used.
               This value should be 4-40 characters, and valid characters
               are `/a-z[0-9]-_/`.
        :param pulumi.Input[Union['ApiHubInstanceConfigArgs', 'ApiHubInstanceConfigArgsDict']] config: Available configurations to provision an ApiHub Instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the ApiHub instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Instance labels to represent user-provided metadata.
               Refer to cloud documentation on labels for more details.
               https://cloud.google.com/compute/docs/labeling-resources
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiHubInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An ApiHubInstance represents the instance resources of the API Hub.
        Currently, only one ApiHub instance is allowed for each project.
        Currently, updation/deletion of ApiHub instance is not allowed.

        ## Example Usage

        ### Apihub Api Hub Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_instance_without_search = gcp.apihub.ApiHubInstance("apihub-instance-without-search",
            location="us-central1",
            config={
                "disable_search": True,
            })
        ```
        ### Apihub Api Hub Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_instance_search = gcp.apihub.ApiHubInstance("apihub-instance-search",
            project="my-project",
            api_hub_instance_id="test-instance-full",
            description="Test API hub instance",
            location="us-central1",
            config={
                "encryption_type": "CMEK",
                "cmek_key_name": "projects/my-project/locations/us-central1/keyRings/apihub/cryptoKeys/apihub-key",
                "disable_search": False,
                "vertex_location": "us",
            },
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        ApiHubInstance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apiHubInstances/{{api_hub_instance_id}}`

        * `{{project}}/{{location}}/{{api_hub_instance_id}}`

        * `{{location}}/{{api_hub_instance_id}}`

        When using the `pulumi import` command, ApiHubInstance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default projects/{{project}}/locations/{{location}}/apiHubInstances/{{api_hub_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default {{project}}/{{location}}/{{api_hub_instance_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/apiHubInstance:ApiHubInstance default {{location}}/{{api_hub_instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ApiHubInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiHubInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_hub_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['ApiHubInstanceConfigArgs', 'ApiHubInstanceConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiHubInstanceArgs.__new__(ApiHubInstanceArgs)

            __props__.__dict__["api_hub_instance_id"] = api_hub_instance_id
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiHubInstance, __self__).__init__(
            'gcp:apihub/apiHubInstance:ApiHubInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_hub_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            config: Optional[pulumi.Input[Union['ApiHubInstanceConfigArgs', 'ApiHubInstanceConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_message: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiHubInstance':
        """
        Get an existing ApiHubInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_hub_instance_id: Optional. Identifier to assign to the Api Hub instance. Must be unique within
               scope of the parent resource. If the field is not provided,
               system generated id will be used.
               This value should be 4-40 characters, and valid characters
               are `/a-z[0-9]-_/`.
        :param pulumi.Input[Union['ApiHubInstanceConfigArgs', 'ApiHubInstanceConfigArgsDict']] config: Available configurations to provision an ApiHub Instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Output only. Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Optional. Description of the ApiHub instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Instance labels to represent user-provided metadata.
               Refer to cloud documentation on labels for more details.
               https://cloud.google.com/compute/docs/labeling-resources
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. Format:
               `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: Output only. The current state of the ApiHub instance.
               Possible values:
               STATE_UNSPECIFIED
               INACTIVE
               CREATING
               ACTIVE
               UPDATING
               DELETING
               FAILED
        :param pulumi.Input[_builtins.str] state_message: Output only. Extra information about ApiHub instance state. Currently the message
               would be populated when state is `FAILED`.
        :param pulumi.Input[_builtins.str] update_time: Output only. Last update timestamp.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiHubInstanceState.__new__(_ApiHubInstanceState)

        __props__.__dict__["api_hub_instance_id"] = api_hub_instance_id
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["update_time"] = update_time
        return ApiHubInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiHubInstanceId")
    def api_hub_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Identifier to assign to the Api Hub instance. Must be unique within
        scope of the parent resource. If the field is not provided,
        system generated id will be used.
        This value should be 4-40 characters, and valid characters
        are `/a-z[0-9]-_/`.
        """
        return pulumi.get(self, "api_hub_instance_id")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.ApiHubInstanceConfig']:
        """
        Available configurations to provision an ApiHub Instance.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Creation timestamp.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Description of the ApiHub instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Instance labels to represent user-provided metadata.
        Refer to cloud documentation on labels for more details.
        https://cloud.google.com/compute/docs/labeling-resources
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Format:
        `projects/{project}/locations/{location}/apiHubInstances/{apiHubInstance}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The current state of the ApiHub instance.
        Possible values:
        STATE_UNSPECIFIED
        INACTIVE
        CREATING
        ACTIVE
        UPDATING
        DELETING
        FAILED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Extra information about ApiHub instance state. Currently the message
        would be populated when state is `FAILED`.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Last update timestamp.
        """
        return pulumi.get(self, "update_time")

