# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CurationArgs', 'Curation']

@pulumi.input_type
class CurationArgs:
    def __init__(__self__, *,
                 curation_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 endpoint: pulumi.Input['CurationEndpointArgs'],
                 location: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Curation resource.
        :param pulumi.Input[_builtins.str] curation_id: The ID to use for the curation resource, which will become the final
               component of the curations's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified ID is already used by another curation resource in the API
               hub.
               * If not provided, a system generated ID will be used.
               This value should be 4-500 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] display_name: The display name of the curation.
        :param pulumi.Input['CurationEndpointArgs'] endpoint: The endpoint to be triggered for curation.
               The endpoint will be invoked with a request payload containing
               ApiMetadata.
               Response should contain curated data in the form of
               ApiMetadata.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] description: The description of the curation.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "curation_id", curation_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="curationId")
    def curation_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the curation resource, which will become the final
        component of the curations's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified ID is already used by another curation resource in the API
        hub.
        * If not provided, a system generated ID will be used.
        This value should be 4-500 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "curation_id")

    @curation_id.setter
    def curation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "curation_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the curation.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input['CurationEndpointArgs']:
        """
        The endpoint to be triggered for curation.
        The endpoint will be invoked with a request payload containing
        ApiMetadata.
        Response should contain curated data in the form of
        ApiMetadata.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input['CurationEndpointArgs']):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the curation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CurationState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 curation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input['CurationEndpointArgs']] = None,
                 last_execution_error_code: Optional[pulumi.Input[_builtins.str]] = None,
                 last_execution_error_message: Optional[pulumi.Input[_builtins.str]] = None,
                 last_execution_state: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugin_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input['CurationPluginInstanceActionArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Curation resources.
        :param pulumi.Input[_builtins.str] create_time: The time at which the curation was created.
        :param pulumi.Input[_builtins.str] curation_id: The ID to use for the curation resource, which will become the final
               component of the curations's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified ID is already used by another curation resource in the API
               hub.
               * If not provided, a system generated ID will be used.
               This value should be 4-500 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] description: The description of the curation.
        :param pulumi.Input[_builtins.str] display_name: The display name of the curation.
        :param pulumi.Input['CurationEndpointArgs'] endpoint: The endpoint to be triggered for curation.
               The endpoint will be invoked with a request payload containing
               ApiMetadata.
               Response should contain curated data in the form of
               ApiMetadata.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_execution_error_code: The error code of the last execution of the curation. The error code is
               populated only when the last execution state is failed.
               Possible values:
               ERROR_CODE_UNSPECIFIED
               INTERNAL_ERROR
               UNAUTHORIZED
        :param pulumi.Input[_builtins.str] last_execution_error_message: Error message describing the failure, if any, during the last execution of
               the curation.
        :param pulumi.Input[_builtins.str] last_execution_state: The last execution state of the curation.
               Possible values:
               LAST_EXECUTION_STATE_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the curation.
               Format:
               `projects/{project}/locations/{location}/curations/{curation}`
        :param pulumi.Input[Sequence[pulumi.Input['CurationPluginInstanceActionArgs']]] plugin_instance_actions: The plugin instances and associated actions that are using the curation.
               Note: A particular curation could be used by multiple plugin instances or
               multiple actions in a plugin instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: The time at which the curation was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if curation_id is not None:
            pulumi.set(__self__, "curation_id", curation_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if last_execution_error_code is not None:
            pulumi.set(__self__, "last_execution_error_code", last_execution_error_code)
        if last_execution_error_message is not None:
            pulumi.set(__self__, "last_execution_error_message", last_execution_error_message)
        if last_execution_state is not None:
            pulumi.set(__self__, "last_execution_state", last_execution_state)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugin_instance_actions is not None:
            pulumi.set(__self__, "plugin_instance_actions", plugin_instance_actions)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the curation was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="curationId")
    def curation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the curation resource, which will become the final
        component of the curations's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified ID is already used by another curation resource in the API
        hub.
        * If not provided, a system generated ID will be used.
        This value should be 4-500 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "curation_id")

    @curation_id.setter
    def curation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "curation_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the curation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the curation.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['CurationEndpointArgs']]:
        """
        The endpoint to be triggered for curation.
        The endpoint will be invoked with a request payload containing
        ApiMetadata.
        Response should contain curated data in the form of
        ApiMetadata.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['CurationEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="lastExecutionErrorCode")
    def last_execution_error_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The error code of the last execution of the curation. The error code is
        populated only when the last execution state is failed.
        Possible values:
        ERROR_CODE_UNSPECIFIED
        INTERNAL_ERROR
        UNAUTHORIZED
        """
        return pulumi.get(self, "last_execution_error_code")

    @last_execution_error_code.setter
    def last_execution_error_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_execution_error_code", value)

    @_builtins.property
    @pulumi.getter(name="lastExecutionErrorMessage")
    def last_execution_error_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message describing the failure, if any, during the last execution of
        the curation.
        """
        return pulumi.get(self, "last_execution_error_message")

    @last_execution_error_message.setter
    def last_execution_error_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_execution_error_message", value)

    @_builtins.property
    @pulumi.getter(name="lastExecutionState")
    def last_execution_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last execution state of the curation.
        Possible values:
        LAST_EXECUTION_STATE_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "last_execution_state")

    @last_execution_state.setter
    def last_execution_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_execution_state", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the curation.
        Format:
        `projects/{project}/locations/{location}/curations/{curation}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pluginInstanceActions")
    def plugin_instance_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CurationPluginInstanceActionArgs']]]]:
        """
        The plugin instances and associated actions that are using the curation.
        Note: A particular curation could be used by multiple plugin instances or
        multiple actions in a plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "plugin_instance_actions")

    @plugin_instance_actions.setter
    def plugin_instance_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CurationPluginInstanceActionArgs']]]]):
        pulumi.set(self, "plugin_instance_actions", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the curation was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:apihub/curation:Curation")
class Curation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 curation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['CurationEndpointArgs', 'CurationEndpointArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Apihub Curation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_curation_basic = gcp.apihub.Curation("apihub_curation_basic",
            location="us-central1",
            curation_id="test",
            project="apihub-terraform",
            display_name="Test Curation",
            description="This is a sample curation resource managed by Terraform.",
            endpoint={
                "application_integration_endpoint_details": {
                    "trigger_id": "api_trigger/curation_API_1",
                    "uri": "https://integrations.googleapis.com/v1/projects/1082615593856/locations/us-central1/integrations/curation:execute",
                },
            })
        ```

        ## Import

        Curation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/curations/{{curation_id}}`

        * `{{project}}/{{location}}/{{curation_id}}`

        * `{{location}}/{{curation_id}}`

        When using the `pulumi import` command, Curation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default projects/{{project}}/locations/{{location}}/curations/{{curation_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default {{project}}/{{location}}/{{curation_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default {{location}}/{{curation_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] curation_id: The ID to use for the curation resource, which will become the final
               component of the curations's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified ID is already used by another curation resource in the API
               hub.
               * If not provided, a system generated ID will be used.
               This value should be 4-500 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] description: The description of the curation.
        :param pulumi.Input[_builtins.str] display_name: The display name of the curation.
        :param pulumi.Input[Union['CurationEndpointArgs', 'CurationEndpointArgsDict']] endpoint: The endpoint to be triggered for curation.
               The endpoint will be invoked with a request payload containing
               ApiMetadata.
               Response should contain curated data in the form of
               ApiMetadata.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Apihub Curation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        apihub_curation_basic = gcp.apihub.Curation("apihub_curation_basic",
            location="us-central1",
            curation_id="test",
            project="apihub-terraform",
            display_name="Test Curation",
            description="This is a sample curation resource managed by Terraform.",
            endpoint={
                "application_integration_endpoint_details": {
                    "trigger_id": "api_trigger/curation_API_1",
                    "uri": "https://integrations.googleapis.com/v1/projects/1082615593856/locations/us-central1/integrations/curation:execute",
                },
            })
        ```

        ## Import

        Curation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/curations/{{curation_id}}`

        * `{{project}}/{{location}}/{{curation_id}}`

        * `{{location}}/{{curation_id}}`

        When using the `pulumi import` command, Curation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default projects/{{project}}/locations/{{location}}/curations/{{curation_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default {{project}}/{{location}}/{{curation_id}}
        ```

        ```sh
        $ pulumi import gcp:apihub/curation:Curation default {{location}}/{{curation_id}}
        ```

        :param str resource_name: The name of the resource.
        :param CurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 curation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[Union['CurationEndpointArgs', 'CurationEndpointArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CurationArgs.__new__(CurationArgs)

            if curation_id is None and not opts.urn:
                raise TypeError("Missing required property 'curation_id'")
            __props__.__dict__["curation_id"] = curation_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["last_execution_error_code"] = None
            __props__.__dict__["last_execution_error_message"] = None
            __props__.__dict__["last_execution_state"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["plugin_instance_actions"] = None
            __props__.__dict__["update_time"] = None
        super(Curation, __self__).__init__(
            'gcp:apihub/curation:Curation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            curation_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[Union['CurationEndpointArgs', 'CurationEndpointArgsDict']]] = None,
            last_execution_error_code: Optional[pulumi.Input[_builtins.str]] = None,
            last_execution_error_message: Optional[pulumi.Input[_builtins.str]] = None,
            last_execution_state: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plugin_instance_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CurationPluginInstanceActionArgs', 'CurationPluginInstanceActionArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Curation':
        """
        Get an existing Curation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time at which the curation was created.
        :param pulumi.Input[_builtins.str] curation_id: The ID to use for the curation resource, which will become the final
               component of the curations's resource name. This field is optional.
               * If provided, the same will be used. The service will throw an error if
               the specified ID is already used by another curation resource in the API
               hub.
               * If not provided, a system generated ID will be used.
               This value should be 4-500 characters, and valid characters
               are /a-z[0-9]-_/.
        :param pulumi.Input[_builtins.str] description: The description of the curation.
        :param pulumi.Input[_builtins.str] display_name: The display name of the curation.
        :param pulumi.Input[Union['CurationEndpointArgs', 'CurationEndpointArgsDict']] endpoint: The endpoint to be triggered for curation.
               The endpoint will be invoked with a request payload containing
               ApiMetadata.
               Response should contain curated data in the form of
               ApiMetadata.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] last_execution_error_code: The error code of the last execution of the curation. The error code is
               populated only when the last execution state is failed.
               Possible values:
               ERROR_CODE_UNSPECIFIED
               INTERNAL_ERROR
               UNAUTHORIZED
        :param pulumi.Input[_builtins.str] last_execution_error_message: Error message describing the failure, if any, during the last execution of
               the curation.
        :param pulumi.Input[_builtins.str] last_execution_state: The last execution state of the curation.
               Possible values:
               LAST_EXECUTION_STATE_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the curation.
               Format:
               `projects/{project}/locations/{location}/curations/{curation}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['CurationPluginInstanceActionArgs', 'CurationPluginInstanceActionArgsDict']]]] plugin_instance_actions: The plugin instances and associated actions that are using the curation.
               Note: A particular curation could be used by multiple plugin instances or
               multiple actions in a plugin instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: The time at which the curation was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CurationState.__new__(_CurationState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["curation_id"] = curation_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["last_execution_error_code"] = last_execution_error_code
        __props__.__dict__["last_execution_error_message"] = last_execution_error_message
        __props__.__dict__["last_execution_state"] = last_execution_state
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["plugin_instance_actions"] = plugin_instance_actions
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return Curation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the curation was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="curationId")
    def curation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the curation resource, which will become the final
        component of the curations's resource name. This field is optional.
        * If provided, the same will be used. The service will throw an error if
        the specified ID is already used by another curation resource in the API
        hub.
        * If not provided, a system generated ID will be used.
        This value should be 4-500 characters, and valid characters
        are /a-z[0-9]-_/.
        """
        return pulumi.get(self, "curation_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the curation.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the curation.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output['outputs.CurationEndpoint']:
        """
        The endpoint to be triggered for curation.
        The endpoint will be invoked with a request payload containing
        ApiMetadata.
        Response should contain curated data in the form of
        ApiMetadata.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="lastExecutionErrorCode")
    def last_execution_error_code(self) -> pulumi.Output[_builtins.str]:
        """
        The error code of the last execution of the curation. The error code is
        populated only when the last execution state is failed.
        Possible values:
        ERROR_CODE_UNSPECIFIED
        INTERNAL_ERROR
        UNAUTHORIZED
        """
        return pulumi.get(self, "last_execution_error_code")

    @_builtins.property
    @pulumi.getter(name="lastExecutionErrorMessage")
    def last_execution_error_message(self) -> pulumi.Output[_builtins.str]:
        """
        Error message describing the failure, if any, during the last execution of
        the curation.
        """
        return pulumi.get(self, "last_execution_error_message")

    @_builtins.property
    @pulumi.getter(name="lastExecutionState")
    def last_execution_state(self) -> pulumi.Output[_builtins.str]:
        """
        The last execution state of the curation.
        Possible values:
        LAST_EXECUTION_STATE_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "last_execution_state")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the curation.
        Format:
        `projects/{project}/locations/{location}/curations/{curation}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluginInstanceActions")
    def plugin_instance_actions(self) -> pulumi.Output[Sequence['outputs.CurationPluginInstanceAction']]:
        """
        The plugin instances and associated actions that are using the curation.
        Note: A particular curation could be used by multiple plugin instances or
        multiple actions in a plugin instance.
        Structure is documented below.
        """
        return pulumi.get(self, "plugin_instance_actions")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the curation was last updated.
        """
        return pulumi.get(self, "update_time")

