# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMavenArtifactResult',
    'AwaitableGetMavenArtifactResult',
    'get_maven_artifact',
    'get_maven_artifact_output',
]

@pulumi.output_type
class GetMavenArtifactResult:
    """
    A collection of values returned by getMavenArtifact.
    """
    def __init__(__self__, artifact_id=None, create_time=None, group_id=None, id=None, location=None, name=None, pom_uri=None, project=None, repository_id=None, update_time=None, version=None):
        if artifact_id and not isinstance(artifact_id, str):
            raise TypeError("Expected argument 'artifact_id' to be a str")
        pulumi.set(__self__, "artifact_id", artifact_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pom_uri and not isinstance(pom_uri, str):
            raise TypeError("Expected argument 'pom_uri' to be a str")
        pulumi.set(__self__, "pom_uri", pom_uri)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> _builtins.str:
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time the artifact was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched artifact. Format:  
        ```
        projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/mavenArtifacts/{{group_id}}:{{artifact_id}}:{{version}}
        ```
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pomUri")
    def pom_uri(self) -> _builtins.str:
        """
        URL to access the pom file of the artifact. Example: `us-west4-maven.pkg.dev/test-project/test-repo/com/google/guava/guava/31.0/guava-31.0.pom`
        """
        return pulumi.get(self, "pom_uri")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time the artifact was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the Maven artifact.
        """
        return pulumi.get(self, "version")


class AwaitableGetMavenArtifactResult(GetMavenArtifactResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMavenArtifactResult(
            artifact_id=self.artifact_id,
            create_time=self.create_time,
            group_id=self.group_id,
            id=self.id,
            location=self.location,
            name=self.name,
            pom_uri=self.pom_uri,
            project=self.project,
            repository_id=self.repository_id,
            update_time=self.update_time,
            version=self.version)


def get_maven_artifact(artifact_id: Optional[_builtins.str] = None,
                       group_id: Optional[_builtins.str] = None,
                       location: Optional[_builtins.str] = None,
                       project: Optional[_builtins.str] = None,
                       repository_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMavenArtifactResult:
    """
    This data source fetches information from a provided Artifact Registry repository, based on a the latest version of the artifact and optional version.

    ## Example Usage


    :param _builtins.str artifact_id: The name of the artifact to fetch. Can optionally include a specific version (e.g., `my_artifact:1.2.3`). If no version is provided, the latest version is used.
    :param _builtins.str group_id: Group ID for the artifact. Example: `com.google.guava`
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The ID of the project that owns the repository. If not provided, the provider-level project is used.
    :param _builtins.str repository_id: The ID of the repository containing the Maven artifact.
    """
    __args__ = dict()
    __args__['artifactId'] = artifact_id
    __args__['groupId'] = group_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getMavenArtifact:getMavenArtifact', __args__, opts=opts, typ=GetMavenArtifactResult).value

    return AwaitableGetMavenArtifactResult(
        artifact_id=pulumi.get(__ret__, 'artifact_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        pom_uri=pulumi.get(__ret__, 'pom_uri'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        update_time=pulumi.get(__ret__, 'update_time'),
        version=pulumi.get(__ret__, 'version'))
def get_maven_artifact_output(artifact_id: Optional[pulumi.Input[_builtins.str]] = None,
                              group_id: Optional[pulumi.Input[_builtins.str]] = None,
                              location: Optional[pulumi.Input[_builtins.str]] = None,
                              project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMavenArtifactResult]:
    """
    This data source fetches information from a provided Artifact Registry repository, based on a the latest version of the artifact and optional version.

    ## Example Usage


    :param _builtins.str artifact_id: The name of the artifact to fetch. Can optionally include a specific version (e.g., `my_artifact:1.2.3`). If no version is provided, the latest version is used.
    :param _builtins.str group_id: Group ID for the artifact. Example: `com.google.guava`
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The ID of the project that owns the repository. If not provided, the provider-level project is used.
    :param _builtins.str repository_id: The ID of the repository containing the Maven artifact.
    """
    __args__ = dict()
    __args__['artifactId'] = artifact_id
    __args__['groupId'] = group_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getMavenArtifact:getMavenArtifact', __args__, opts=opts, typ=GetMavenArtifactResult)
    return __ret__.apply(lambda __response__: GetMavenArtifactResult(
        artifact_id=pulumi.get(__response__, 'artifact_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        pom_uri=pulumi.get(__response__, 'pom_uri'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        update_time=pulumi.get(__response__, 'update_time'),
        version=pulumi.get(__response__, 'version')))
