# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNpmPackageResult',
    'AwaitableGetNpmPackageResult',
    'get_npm_package',
    'get_npm_package_output',
]

@pulumi.output_type
class GetNpmPackageResult:
    """
    A collection of values returned by getNpmPackage.
    """
    def __init__(__self__, create_time=None, id=None, location=None, name=None, package_name=None, project=None, repository_id=None, tags=None, update_time=None, version=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time the package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched package. Format:  
        ```
        projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/npmPackages/{{package}}:{{version}}
        ```
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of all Tags attached to this package.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time the package was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the NPM package.
        """
        return pulumi.get(self, "version")


class AwaitableGetNpmPackageResult(GetNpmPackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNpmPackageResult(
            create_time=self.create_time,
            id=self.id,
            location=self.location,
            name=self.name,
            package_name=self.package_name,
            project=self.project,
            repository_id=self.repository_id,
            tags=self.tags,
            update_time=self.update_time,
            version=self.version)


def get_npm_package(location: Optional[_builtins.str] = None,
                    package_name: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    repository_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNpmPackageResult:
    """
    This data source fetches information from a provided Artifact Registry repository, based on a the latest version of the package and optional version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    npm_repo = gcp.artifactregistry.Repository("npm_repo",
        location="us-central1",
        repository_id="my-npm-repo",
        format="NPM")
    latest = gcp.artifactregistry.get_npm_package_output(location=npm_repo.location,
        repository_id=npm_repo.repository_id,
        package_name="example-pkg")
    with_version = gcp.artifactregistry.get_npm_package_output(location=npm_repo.location,
        repository_id=npm_repo.repository_id,
        package_name="example-pkg:1.0.0")
    ```


    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str package_name: The name of the package to fetch. Can optionally include a specific version (e.g., `my_pkg:1.2.3`). If no version is provided, the latest version is used.
    :param _builtins.str project: The ID of the project that owns the repository. If not provided, the provider-level project is used.
    :param _builtins.str repository_id: The ID of the repository containing the NPM package.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getNpmPackage:getNpmPackage', __args__, opts=opts, typ=GetNpmPackageResult).value

    return AwaitableGetNpmPackageResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        package_name=pulumi.get(__ret__, 'package_name'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'),
        version=pulumi.get(__ret__, 'version'))
def get_npm_package_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                           package_name: Optional[pulumi.Input[_builtins.str]] = None,
                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNpmPackageResult]:
    """
    This data source fetches information from a provided Artifact Registry repository, based on a the latest version of the package and optional version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    npm_repo = gcp.artifactregistry.Repository("npm_repo",
        location="us-central1",
        repository_id="my-npm-repo",
        format="NPM")
    latest = gcp.artifactregistry.get_npm_package_output(location=npm_repo.location,
        repository_id=npm_repo.repository_id,
        package_name="example-pkg")
    with_version = gcp.artifactregistry.get_npm_package_output(location=npm_repo.location,
        repository_id=npm_repo.repository_id,
        package_name="example-pkg:1.0.0")
    ```


    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str package_name: The name of the package to fetch. Can optionally include a specific version (e.g., `my_pkg:1.2.3`). If no version is provided, the latest version is used.
    :param _builtins.str project: The ID of the project that owns the repository. If not provided, the provider-level project is used.
    :param _builtins.str repository_id: The ID of the repository containing the NPM package.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getNpmPackage:getNpmPackage', __args__, opts=opts, typ=GetNpmPackageResult)
    return __ret__.apply(lambda __response__: GetNpmPackageResult(
        create_time=pulumi.get(__response__, 'create_time'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        package_name=pulumi.get(__response__, 'package_name'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time'),
        version=pulumi.get(__response__, 'version')))
