# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNpmPackagesResult',
    'AwaitableGetNpmPackagesResult',
    'get_npm_packages',
    'get_npm_packages_output',
]

@pulumi.output_type
class GetNpmPackagesResult:
    """
    A collection of values returned by getNpmPackages.
    """
    def __init__(__self__, id=None, location=None, npm_packages=None, project=None, repository_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if npm_packages and not isinstance(npm_packages, list):
            raise TypeError("Expected argument 'npm_packages' to be a list")
        pulumi.set(__self__, "npm_packages", npm_packages)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="npmPackages")
    def npm_packages(self) -> Sequence['outputs.GetNpmPackagesNpmPackageResult']:
        """
        A list of all retrieved Artifact Registry Npm packages. Structure is defined below.
        """
        return pulumi.get(self, "npm_packages")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")


class AwaitableGetNpmPackagesResult(GetNpmPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNpmPackagesResult(
            id=self.id,
            location=self.location,
            npm_packages=self.npm_packages,
            project=self.project,
            repository_id=self.repository_id)


def get_npm_packages(location: Optional[_builtins.str] = None,
                     project: Optional[_builtins.str] = None,
                     repository_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNpmPackagesResult:
    """
    Get information about Artifact Registry Npm packages.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/nodejs)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.npmPackages/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_packages = gcp.artifactregistry.get_npm_packages(location="us-central1",
        repository_id="example-repo")
    ```


    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getNpmPackages:getNpmPackages', __args__, opts=opts, typ=GetNpmPackagesResult).value

    return AwaitableGetNpmPackagesResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        npm_packages=pulumi.get(__ret__, 'npm_packages'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'))
def get_npm_packages_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                            project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNpmPackagesResult]:
    """
    Get information about Artifact Registry Npm packages.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/nodejs)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.npmPackages/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_packages = gcp.artifactregistry.get_npm_packages(location="us-central1",
        repository_id="example-repo")
    ```


    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getNpmPackages:getNpmPackages', __args__, opts=opts, typ=GetNpmPackagesResult)
    return __ret__.apply(lambda __response__: GetNpmPackagesResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        npm_packages=pulumi.get(__response__, 'npm_packages'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id')))
