# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPackagesResult',
    'AwaitableGetPackagesResult',
    'get_packages',
    'get_packages_output',
]

@pulumi.output_type
class GetPackagesResult:
    """
    A collection of values returned by getPackages.
    """
    def __init__(__self__, filter=None, id=None, location=None, packages=None, project=None, repository_id=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.GetPackagesPackageResult']:
        """
        A list of all retrieved Artifact Registry packages. Structure is defined below.
        """
        return pulumi.get(self, "packages")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")


class AwaitableGetPackagesResult(GetPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPackagesResult(
            filter=self.filter,
            id=self.id,
            location=self.location,
            packages=self.packages,
            project=self.project,
            repository_id=self.repository_id)


def get_packages(filter: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None,
                 repository_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPackagesResult:
    """
    Get information about Artifact Registry packages.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/overview)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_images = gcp.artifactregistry.get_packages(location="us-central1",
        repository_id="example-repo")
    ```


    :param _builtins.str filter: An expression for filtering the results of the request. Filter rules are case insensitive. The fields eligible for filtering are `name` and `annotations`. Further information can be found in the [REST API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages/list#query-parameters).
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getPackages:getPackages', __args__, opts=opts, typ=GetPackagesResult).value

    return AwaitableGetPackagesResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        packages=pulumi.get(__ret__, 'packages'),
        project=pulumi.get(__ret__, 'project'),
        repository_id=pulumi.get(__ret__, 'repository_id'))
def get_packages_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        location: Optional[pulumi.Input[_builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPackagesResult]:
    """
    Get information about Artifact Registry packages.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs/overview)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_images = gcp.artifactregistry.get_packages(location="us-central1",
        repository_id="example-repo")
    ```


    :param _builtins.str filter: An expression for filtering the results of the request. Filter rules are case insensitive. The fields eligible for filtering are `name` and `annotations`. Further information can be found in the [REST API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories.packages/list#query-parameters).
    :param _builtins.str location: The location of the Artifact Registry repository.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getPackages:getPackages', __args__, opts=opts, typ=GetPackagesResult)
    return __ret__.apply(lambda __response__: GetPackagesResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        packages=pulumi.get(__response__, 'packages'),
        project=pulumi.get(__response__, 'project'),
        repository_id=pulumi.get(__response__, 'repository_id')))
