# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVersionResult',
    'AwaitableGetVersionResult',
    'get_version',
    'get_version_output',
]

@pulumi.output_type
class GetVersionResult:
    """
    A collection of values returned by getVersion.
    """
    def __init__(__self__, annotations=None, create_time=None, description=None, id=None, location=None, name=None, package_name=None, project=None, related_tags=None, repository_id=None, update_time=None, version_name=None, view=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if related_tags and not isinstance(related_tags, list):
            raise TypeError("Expected argument 'related_tags' to be a list")
        pulumi.set(__self__, "related_tags", related_tags)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if version_name and not isinstance(version_name, str):
            raise TypeError("Expected argument 'version_name' to be a str")
        pulumi.set(__self__, "version_name", version_name)
        if view and not isinstance(view, str):
            raise TypeError("Expected argument 'view' to be a str")
        pulumi.set(__self__, "view", view)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Client specified annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the version, as specified in its metadata.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the version, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/version1`. If the package part contains slashes, the slashes are escaped.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="relatedTags")
    def related_tags(self) -> Sequence['outputs.GetVersionRelatedTagResult']:
        """
        A list of related tags. Will contain up to 100 tags that reference this version.
        """
        return pulumi.get(self, "related_tags")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was last updated. This includes publishing a new version of the package.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="versionName")
    def version_name(self) -> _builtins.str:
        return pulumi.get(self, "version_name")

    @_builtins.property
    @pulumi.getter
    def view(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "view")


class AwaitableGetVersionResult(GetVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVersionResult(
            annotations=self.annotations,
            create_time=self.create_time,
            description=self.description,
            id=self.id,
            location=self.location,
            name=self.name,
            package_name=self.package_name,
            project=self.project,
            related_tags=self.related_tags,
            repository_id=self.repository_id,
            update_time=self.update_time,
            version_name=self.version_name,
            view=self.view)


def get_version(location: Optional[_builtins.str] = None,
                package_name: Optional[_builtins.str] = None,
                project: Optional[_builtins.str] = None,
                repository_id: Optional[_builtins.str] = None,
                version_name: Optional[_builtins.str] = None,
                view: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVersionResult:
    """
    This data source fetches information of a version from a provided Artifact Registry repository.


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    :param _builtins.str version_name: The name of the version.
    :param _builtins.str view: The view, which determines what version information is returned in a response. Possible values are `"BASIC"` and `"FULL"`. Defaults to `"BASIC"`.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['versionName'] = version_name
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getVersion:getVersion', __args__, opts=opts, typ=GetVersionResult).value

    return AwaitableGetVersionResult(
        annotations=pulumi.get(__ret__, 'annotations'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        package_name=pulumi.get(__ret__, 'package_name'),
        project=pulumi.get(__ret__, 'project'),
        related_tags=pulumi.get(__ret__, 'related_tags'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        update_time=pulumi.get(__ret__, 'update_time'),
        version_name=pulumi.get(__ret__, 'version_name'),
        view=pulumi.get(__ret__, 'view'))
def get_version_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                       package_name: Optional[pulumi.Input[_builtins.str]] = None,
                       project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                       version_name: Optional[pulumi.Input[_builtins.str]] = None,
                       view: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVersionResult]:
    """
    This data source fetches information of a version from a provided Artifact Registry repository.


    :param _builtins.str location: The location of the artifact registry.
    :param _builtins.str package_name: The name of the package.
    :param _builtins.str project: The project ID in which the resource belongs. If it is not provided, the provider project is used.
    :param _builtins.str repository_id: The last part of the repository name to fetch from.
    :param _builtins.str version_name: The name of the version.
    :param _builtins.str view: The view, which determines what version information is returned in a response. Possible values are `"BASIC"` and `"FULL"`. Defaults to `"BASIC"`.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['packageName'] = package_name
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    __args__['versionName'] = version_name
    __args__['view'] = view
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getVersion:getVersion', __args__, opts=opts, typ=GetVersionResult)
    return __ret__.apply(lambda __response__: GetVersionResult(
        annotations=pulumi.get(__response__, 'annotations'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        package_name=pulumi.get(__response__, 'package_name'),
        project=pulumi.get(__response__, 'project'),
        related_tags=pulumi.get(__response__, 'related_tags'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        update_time=pulumi.get(__response__, 'update_time'),
        version_name=pulumi.get(__response__, 'version_name'),
        view=pulumi.get(__response__, 'view')))
