# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RepositoryCleanupPolicy',
    'RepositoryCleanupPolicyCondition',
    'RepositoryCleanupPolicyMostRecentVersions',
    'RepositoryDockerConfig',
    'RepositoryIamBindingCondition',
    'RepositoryIamMemberCondition',
    'RepositoryMavenConfig',
    'RepositoryRemoteRepositoryConfig',
    'RepositoryRemoteRepositoryConfigAptRepository',
    'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository',
    'RepositoryRemoteRepositoryConfigCommonRepository',
    'RepositoryRemoteRepositoryConfigDockerRepository',
    'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigMavenRepository',
    'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigNpmRepository',
    'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigPythonRepository',
    'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigUpstreamCredentials',
    'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials',
    'RepositoryRemoteRepositoryConfigYumRepository',
    'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository',
    'RepositoryVirtualRepositoryConfig',
    'RepositoryVirtualRepositoryConfigUpstreamPolicy',
    'RepositoryVulnerabilityScanningConfig',
    'GetDockerImagesDockerImageResult',
    'GetMavenArtifactsMavenArtifactResult',
    'GetNpmPackagesNpmPackageResult',
    'GetPackagesPackageResult',
    'GetPythonPackagesPythonPackageResult',
    'GetRepositoriesRepositoryResult',
    'GetRepositoryCleanupPolicyResult',
    'GetRepositoryCleanupPolicyConditionResult',
    'GetRepositoryCleanupPolicyMostRecentVersionResult',
    'GetRepositoryDockerConfigResult',
    'GetRepositoryMavenConfigResult',
    'GetRepositoryRemoteRepositoryConfigResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigCommonRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult',
    'GetRepositoryVirtualRepositoryConfigResult',
    'GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult',
    'GetRepositoryVulnerabilityScanningConfigResult',
    'GetTagsTagResult',
    'GetVersionRelatedTagResult',
]

@pulumi.output_type
class RepositoryCleanupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mostRecentVersions":
            suggest = "most_recent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 condition: Optional['outputs.RepositoryCleanupPolicyCondition'] = None,
                 most_recent_versions: Optional['outputs.RepositoryCleanupPolicyMostRecentVersions'] = None):
        """
        :param _builtins.str id: The identifier for this object. Format specified above.
        :param _builtins.str action: Policy action.
               Possible values are: `DELETE`, `KEEP`.
        :param 'RepositoryCleanupPolicyConditionArgs' condition: Policy condition for matching versions.
               Structure is documented below.
        :param 'RepositoryCleanupPolicyMostRecentVersionsArgs' most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if most_recent_versions is not None:
            pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Policy action.
        Possible values are: `DELETE`, `KEEP`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional['outputs.RepositoryCleanupPolicyCondition']:
        """
        Policy condition for matching versions.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Optional['outputs.RepositoryCleanupPolicyMostRecentVersions']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        Structure is documented below.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class RepositoryCleanupPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newerThan":
            suggest = "newer_than"
        elif key == "olderThan":
            suggest = "older_than"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"
        elif key == "tagPrefixes":
            suggest = "tag_prefixes"
        elif key == "tagState":
            suggest = "tag_state"
        elif key == "versionNamePrefixes":
            suggest = "version_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newer_than: Optional[_builtins.str] = None,
                 older_than: Optional[_builtins.str] = None,
                 package_name_prefixes: Optional[Sequence[_builtins.str]] = None,
                 tag_prefixes: Optional[Sequence[_builtins.str]] = None,
                 tag_state: Optional[_builtins.str] = None,
                 version_name_prefixes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str newer_than: Match versions newer than a duration.
        :param _builtins.str older_than: Match versions older than a duration.
        :param Sequence[_builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[_builtins.str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param _builtins.str tag_state: Match versions by tag status.
               Default value is `ANY`.
               Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        :param Sequence[_builtins.str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        if newer_than is not None:
            pulumi.set(__self__, "newer_than", newer_than)
        if older_than is not None:
            pulumi.set(__self__, "older_than", older_than)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        if tag_prefixes is not None:
            pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        if tag_state is not None:
            pulumi.set(__self__, "tag_state", tag_state)
        if version_name_prefixes is not None:
            pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @_builtins.property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> Optional[_builtins.str]:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @_builtins.property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> Optional[_builtins.str]:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @_builtins.property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @_builtins.property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @_builtins.property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> Optional[_builtins.str]:
        """
        Match versions by tag status.
        Default value is `ANY`.
        Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        """
        return pulumi.get(self, "tag_state")

    @_builtins.property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class RepositoryCleanupPolicyMostRecentVersions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keepCount":
            suggest = "keep_count"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyMostRecentVersions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keep_count: Optional[_builtins.int] = None,
                 package_name_prefixes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int keep_count: Minimum number of versions to keep.
        :param Sequence[_builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        if keep_count is not None:
            pulumi.set(__self__, "keep_count", keep_count)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @_builtins.property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @_builtins.property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class RepositoryDockerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutableTags":
            suggest = "immutable_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryDockerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutable_tags: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        if immutable_tags is not None:
            pulumi.set(__self__, "immutable_tags", immutable_tags)

    @_builtins.property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> Optional[_builtins.bool]:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class RepositoryIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryMavenConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSnapshotOverwrites":
            suggest = "allow_snapshot_overwrites"
        elif key == "versionPolicy":
            suggest = "version_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryMavenConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_snapshot_overwrites: Optional[_builtins.bool] = None,
                 version_policy: Optional[_builtins.str] = None):
        """
        :param _builtins.bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param _builtins.str version_policy: Version policy defines the versions that the registry will accept.
               Default value is `VERSION_POLICY_UNSPECIFIED`.
               Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        if allow_snapshot_overwrites is not None:
            pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        if version_policy is not None:
            pulumi.set(__self__, "version_policy", version_policy)

    @_builtins.property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> Optional[_builtins.bool]:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @_builtins.property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> Optional[_builtins.str]:
        """
        Version policy defines the versions that the registry will accept.
        Default value is `VERSION_POLICY_UNSPECIFIED`.
        Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class RepositoryRemoteRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aptRepository":
            suggest = "apt_repository"
        elif key == "commonRepository":
            suggest = "common_repository"
        elif key == "disableUpstreamValidation":
            suggest = "disable_upstream_validation"
        elif key == "dockerRepository":
            suggest = "docker_repository"
        elif key == "mavenRepository":
            suggest = "maven_repository"
        elif key == "npmRepository":
            suggest = "npm_repository"
        elif key == "pythonRepository":
            suggest = "python_repository"
        elif key == "upstreamCredentials":
            suggest = "upstream_credentials"
        elif key == "yumRepository":
            suggest = "yum_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository'] = None,
                 common_repository: Optional['outputs.RepositoryRemoteRepositoryConfigCommonRepository'] = None,
                 description: Optional[_builtins.str] = None,
                 disable_upstream_validation: Optional[_builtins.bool] = None,
                 docker_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository'] = None,
                 maven_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository'] = None,
                 npm_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository'] = None,
                 python_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository'] = None,
                 upstream_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials'] = None,
                 yum_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryArgs' apt_repository: Specific settings for an Apt remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigCommonRepositoryArgs' common_repository: Specific settings for an Artifact Registory remote repository.
               Structure is documented below.
        :param _builtins.str description: The description of the remote source.
        :param _builtins.bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryArgs' docker_repository: Specific settings for a Docker remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryArgs' maven_repository: Specific settings for a Maven remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryArgs' npm_repository: Specific settings for an Npm remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryArgs' python_repository: Specific settings for a Python remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsArgs' upstream_credentials: The credentials used to access the remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryArgs' yum_repository: Specific settings for an Yum remote repository.
               Structure is documented below.
        """
        if apt_repository is not None:
            pulumi.set(__self__, "apt_repository", apt_repository)
        if common_repository is not None:
            pulumi.set(__self__, "common_repository", common_repository)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_upstream_validation is not None:
            pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if maven_repository is not None:
            pulumi.set(__self__, "maven_repository", maven_repository)
        if npm_repository is not None:
            pulumi.set(__self__, "npm_repository", npm_repository)
        if python_repository is not None:
            pulumi.set(__self__, "python_repository", python_repository)
        if upstream_credentials is not None:
            pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        if yum_repository is not None:
            pulumi.set(__self__, "yum_repository", yum_repository)

    @_builtins.property
    @pulumi.getter(name="aptRepository")
    def apt_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository']:
        """
        Specific settings for an Apt remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "apt_repository")

    @_builtins.property
    @pulumi.getter(name="commonRepository")
    def common_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigCommonRepository']:
        """
        Specific settings for an Artifact Registory remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "common_repository")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> Optional[_builtins.bool]:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository']:
        """
        Specific settings for a Docker remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_repository")

    @_builtins.property
    @pulumi.getter(name="mavenRepository")
    def maven_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository']:
        """
        Specific settings for a Maven remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_repository")

    @_builtins.property
    @pulumi.getter(name="npmRepository")
    def npm_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository']:
        """
        Specific settings for an Npm remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "npm_repository")

    @_builtins.property
    @pulumi.getter(name="pythonRepository")
    def python_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository']:
        """
        Specific settings for a Python remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "python_repository")

    @_builtins.property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials']:
        """
        The credentials used to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_credentials")

    @_builtins.property
    @pulumi.getter(name="yumRepository")
    def yum_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository']:
        """
        Specific settings for an Yum remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "yum_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Apt repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: _builtins.str,
                 repository_path: _builtins.str):
        """
        :param _builtins.str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param _builtins.str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @_builtins.property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> _builtins.str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> _builtins.str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigCommonRepository(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: One of:
               a. Artifact Registry Repository resource, e.g. `projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY`
               b. URI to the registry, e.g. `"https://registry-1.docker.io"`
               c. URI to Artifact Registry Repository, e.g. `"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"`
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        One of:
        a. Artifact Registry Repository resource, e.g. `projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY`
        b. URI to the registry, e.g. `"https://registry-1.docker.io"`
        c. URI to Artifact Registry Repository, e.g. `"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigDockerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository'] = None,
                 public_repository: Optional[_builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param _builtins.str public_repository: Address of the remote repository.
               Possible values are: `DOCKER_HUB`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[_builtins.str]:
        """
        Address of the remote repository.
        Possible values are: `DOCKER_HUB`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigMavenRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository'] = None,
                 public_repository: Optional[_builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param _builtins.str public_repository: Address of the remote repository.
               Possible values are: `MAVEN_CENTRAL`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[_builtins.str]:
        """
        Address of the remote repository.
        Possible values are: `MAVEN_CENTRAL`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigNpmRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository'] = None,
                 public_repository: Optional[_builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param _builtins.str public_repository: Address of the remote repository.
               Possible values are: `NPMJS`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[_builtins.str]:
        """
        Address of the remote repository.
        Possible values are: `NPMJS`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigPythonRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository'] = None,
                 public_repository: Optional[_builtins.str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs' custom_repository: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param _builtins.str public_repository: Address of the remote repository.
               Possible values are: `PYPI`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[_builtins.str]:
        """
        Address of the remote repository.
        Possible values are: `PYPI`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usernamePasswordCredentials":
            suggest = "username_password_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username_password_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentialsArgs' username_password_credentials: Use username and password to access the remote repository.
               Structure is documented below.
        """
        if username_password_credentials is not None:
            pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @_builtins.property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials']:
        """
        Use username and password to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretVersion":
            suggest = "password_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_version: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               `projects/{project}/secrets/{secret}/versions/{version}`.
        :param _builtins.str username: The username to access the remote repository.
        """
        if password_secret_version is not None:
            pulumi.set(__self__, "password_secret_version", password_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> Optional[_builtins.str]:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        `projects/{project}/secrets/{secret}/versions/{version}`.
        """
        return pulumi.get(self, "password_secret_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Yum repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: _builtins.str,
                 repository_path: _builtins.str):
        """
        :param _builtins.str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param _builtins.str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @_builtins.property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> _builtins.str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> _builtins.str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryVirtualRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "upstreamPolicies":
            suggest = "upstream_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryVirtualRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 upstream_policies: Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']] = None):
        """
        :param Sequence['RepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
               Structure is documented below.
        """
        if upstream_policies is not None:
            pulumi.set(__self__, "upstream_policies", upstream_policies)

    @_builtins.property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']]:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class RepositoryVirtualRepositoryConfigUpstreamPolicy(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 repository: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The user-provided ID of the upstream policy.
        :param _builtins.int priority: Entries with a greater priority value take precedence in the pull order.
        :param _builtins.str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class RepositoryVulnerabilityScanningConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablementConfig":
            suggest = "enablement_config"
        elif key == "enablementState":
            suggest = "enablement_state"
        elif key == "enablementStateReason":
            suggest = "enablement_state_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryVulnerabilityScanningConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryVulnerabilityScanningConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryVulnerabilityScanningConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enablement_config: Optional[_builtins.str] = None,
                 enablement_state: Optional[_builtins.str] = None,
                 enablement_state_reason: Optional[_builtins.str] = None):
        """
        :param _builtins.str enablement_config: This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository.
               Possible values are: `INHERITED`, `DISABLED`.
        :param _builtins.str enablement_state: (Output)
               This field returns whether scanning is active for this repository.
        :param _builtins.str enablement_state_reason: (Output)
               This provides an explanation for the state of scanning on this repository.
        """
        if enablement_config is not None:
            pulumi.set(__self__, "enablement_config", enablement_config)
        if enablement_state is not None:
            pulumi.set(__self__, "enablement_state", enablement_state)
        if enablement_state_reason is not None:
            pulumi.set(__self__, "enablement_state_reason", enablement_state_reason)

    @_builtins.property
    @pulumi.getter(name="enablementConfig")
    def enablement_config(self) -> Optional[_builtins.str]:
        """
        This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository.
        Possible values are: `INHERITED`, `DISABLED`.
        """
        return pulumi.get(self, "enablement_config")

    @_builtins.property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        This field returns whether scanning is active for this repository.
        """
        return pulumi.get(self, "enablement_state")

    @_builtins.property
    @pulumi.getter(name="enablementStateReason")
    def enablement_state_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        This provides an explanation for the state of scanning on this repository.
        """
        return pulumi.get(self, "enablement_state_reason")


@pulumi.output_type
class GetDockerImagesDockerImageResult(dict):
    def __init__(__self__, *,
                 build_time: _builtins.str,
                 image_name: _builtins.str,
                 image_size_bytes: _builtins.str,
                 media_type: _builtins.str,
                 name: _builtins.str,
                 self_link: _builtins.str,
                 tags: Sequence[_builtins.str],
                 update_time: _builtins.str,
                 upload_time: _builtins.str):
        """
        :param _builtins.str build_time: The time, as a RFC 3339 string, this image was built.
        :param _builtins.str image_name: Extracted short name of the image (last part of `name`, without tag or digest). For example, from `.../nginx@sha256:...` → `nginx`.
        :param _builtins.str image_size_bytes: Calculated size of the image in bytes.
        :param _builtins.str media_type: Media type of this image, e.g. `application/vnd.docker.distribution.manifest.v2+json`.
        :param _builtins.str name: The fully qualified name of the fetched image.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/dockerImages/{{docker_image}}`. For example, `projects/test-project/locations/us-west4/repositories/test-repo/dockerImages/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf`
        :param _builtins.str self_link: The URI to access the image.  For example, `us-west4-docker.pkg.dev/test-project/test-repo/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf`
        :param Sequence[_builtins.str] tags: A list of all tags associated with the image.
        :param _builtins.str update_time: The time, as a RFC 3339 string, this image was updated.
        :param _builtins.str upload_time: The time, as a RFC 3339 string, the image was uploaded. For example, `2014-10-02T15:01:23.045123456Z`.
        """
        pulumi.set(__self__, "build_time", build_time)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "image_size_bytes", image_size_bytes)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "upload_time", upload_time)

    @_builtins.property
    @pulumi.getter(name="buildTime")
    def build_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this image was built.
        """
        return pulumi.get(self, "build_time")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> _builtins.str:
        """
        Extracted short name of the image (last part of `name`, without tag or digest). For example, from `.../nginx@sha256:...` → `nginx`.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="imageSizeBytes")
    def image_size_bytes(self) -> _builtins.str:
        """
        Calculated size of the image in bytes.
        """
        return pulumi.get(self, "image_size_bytes")

    @_builtins.property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> _builtins.str:
        """
        Media type of this image, e.g. `application/vnd.docker.distribution.manifest.v2+json`.
        """
        return pulumi.get(self, "media_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched image.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/dockerImages/{{docker_image}}`. For example, `projects/test-project/locations/us-west4/repositories/test-repo/dockerImages/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI to access the image.  For example, `us-west4-docker.pkg.dev/test-project/test-repo/nginx@sha256:e9954c1fc875017be1c3e36eca16be2d9e9bccc4bf072163515467d6a823c7cf`
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of all tags associated with the image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this image was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="uploadTime")
    def upload_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, the image was uploaded. For example, `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "upload_time")


@pulumi.output_type
class GetMavenArtifactsMavenArtifactResult(dict):
    def __init__(__self__, *,
                 artifact_id: _builtins.str,
                 create_time: _builtins.str,
                 group_id: _builtins.str,
                 name: _builtins.str,
                 pom_uri: _builtins.str,
                 update_time: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str artifact_id: The name of the artifact to fetch.
        :param _builtins.str create_time: The time the artifact was created.
        :param _builtins.str group_id: Group ID for the artifact.
        :param _builtins.str name: The fully qualified name of the fetched artifact. Format:
               ```
               projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/mavenArtifacts/{{group_id}}:{{artifact_id}}:{{version}}
               ```
        :param _builtins.str pom_uri: URL to access the pom file of the artifact.
        :param _builtins.str update_time: The time the artifact was last updated.
        :param _builtins.str version: The version of the Maven artifact.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pom_uri", pom_uri)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> _builtins.str:
        """
        The name of the artifact to fetch.
        """
        return pulumi.get(self, "artifact_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time the artifact was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        Group ID for the artifact.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched artifact. Format:
        ```
        projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}/mavenArtifacts/{{group_id}}:{{artifact_id}}:{{version}}
        ```
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pomUri")
    def pom_uri(self) -> _builtins.str:
        """
        URL to access the pom file of the artifact.
        """
        return pulumi.get(self, "pom_uri")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time the artifact was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the Maven artifact.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetNpmPackagesNpmPackageResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 name: _builtins.str,
                 package_name: _builtins.str,
                 tags: Sequence[_builtins.str],
                 update_time: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str create_time: The time, as a RFC 3339 string, this package was created.
        :param _builtins.str name: The fully qualified name of the fetched package.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/npmPackages/{{npmPackage}}`. For example, `projects/example-project/locations/us-central1/repository/example-repo/npmPackages/my-test-package:0.0.1`
        :param _builtins.str package_name: Extracted short name of the package (last part of `name`, without version). For example, from `.../my-test-package:0.0.1` → `my-test-package`.
        :param Sequence[_builtins.str] tags: The tags associated with the Npm package.
        :param _builtins.str update_time: The time, as a RFC 3339 string, this package was updated.
        :param _builtins.str version: Version of this package.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_name", package_name)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched package.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/npmPackages/{{npmPackage}}`. For example, `projects/example-project/locations/us-central1/repository/example-repo/npmPackages/my-test-package:0.0.1`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        """
        Extracted short name of the package (last part of `name`, without version). For example, from `.../my-test-package:0.0.1` → `my-test-package`.
        """
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags associated with the Npm package.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of this package.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPackagesPackageResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 create_time: _builtins.str,
                 display_name: _builtins.str,
                 name: _builtins.str,
                 update_time: _builtins.str):
        """
        :param Mapping[str, _builtins.str] annotations: Client specified annotations.
        :param _builtins.str create_time: The time, as a RFC 3339 string, this package was created.
        :param _builtins.str display_name: The display name of the package.
        :param _builtins.str name: The name of the package, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`. If the package ID part contains slashes, the slashes are escaped.
        :param _builtins.str update_time: The time, as a RFC 3339 string, this package was last updated. This includes publishing a new version of the package.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Client specified annotations.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the package.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the package, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`. If the package ID part contains slashes, the slashes are escaped.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was last updated. This includes publishing a new version of the package.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetPythonPackagesPythonPackageResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 name: _builtins.str,
                 package_name: _builtins.str,
                 update_time: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str create_time: The time, as a RFC 3339 string, this package was created.
        :param _builtins.str name: The fully qualified name of the fetched package.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/pythonPackages/{{pythonPackage}}`. For example, `projects/example-project/locations/us-central1/repository/example-repo/pythonPackages/my-test-package:0.0.1`
        :param _builtins.str package_name: Extracted short name of the package (last part of `name`, without version). For example, from `.../my-test-package:0.0.1` → `my-test-package`.
        :param _builtins.str update_time: The time, as a RFC 3339 string, this package was updated.
        :param _builtins.str version: Version of this package.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_name", package_name)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified name of the fetched package.  This name has the form: `projects/{{project}}/locations/{{location}}/repository/{{repository_id}}/pythonPackages/{{pythonPackage}}`. For example, `projects/example-project/locations/us-central1/repository/example-repo/pythonPackages/my-test-package:0.0.1`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        """
        Extracted short name of the package (last part of `name`, without version). For example, from `.../my-test-package:0.0.1` → `my-test-package`.
        """
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time, as a RFC 3339 string, this package was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of this package.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRepositoriesRepositoryResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 format: _builtins.str,
                 id: _builtins.str,
                 repository_id: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.str create_time: The time when the repository was created.
        :param _builtins.str description: The user-provided description of the repository.
        :param _builtins.str format: The format of packages that are stored in the repository. Supported formats can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
        :param _builtins.str id: An identifier for the resource with format `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`
        :param _builtins.str repository_id: The last part of the repository name, for example: `"repo1"`
        :param _builtins.str update_time: The time when the repository was last updated.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the repository was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The user-provided description of the repository.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The format of packages that are stored in the repository. Supported formats can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        An identifier for the resource with format `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> _builtins.str:
        """
        The last part of the repository name, for example: `"repo1"`
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time when the repository was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetRepositoryCleanupPolicyResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 conditions: Sequence['outputs.GetRepositoryCleanupPolicyConditionResult'],
                 id: _builtins.str,
                 most_recent_versions: Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']):
        """
        :param _builtins.str action: Policy action. Possible values: ["DELETE", "KEEP"]
        :param Sequence['GetRepositoryCleanupPolicyConditionArgs'] conditions: Policy condition for matching versions.
        :param Sequence['GetRepositoryCleanupPolicyMostRecentVersionArgs'] most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Policy action. Possible values: ["DELETE", "KEEP"]
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyConditionResult']:
        """
        Policy condition for matching versions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class GetRepositoryCleanupPolicyConditionResult(dict):
    def __init__(__self__, *,
                 newer_than: _builtins.str,
                 older_than: _builtins.str,
                 package_name_prefixes: Sequence[_builtins.str],
                 tag_prefixes: Sequence[_builtins.str],
                 tag_state: _builtins.str,
                 version_name_prefixes: Sequence[_builtins.str]):
        """
        :param _builtins.str newer_than: Match versions newer than a duration.
        :param _builtins.str older_than: Match versions older than a duration.
        :param Sequence[_builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[_builtins.str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param _builtins.str tag_state: Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        :param Sequence[_builtins.str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "newer_than", newer_than)
        pulumi.set(__self__, "older_than", older_than)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        pulumi.set(__self__, "tag_state", tag_state)
        pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @_builtins.property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> _builtins.str:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @_builtins.property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> _builtins.str:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @_builtins.property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[_builtins.str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @_builtins.property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Sequence[_builtins.str]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @_builtins.property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> _builtins.str:
        """
        Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        """
        return pulumi.get(self, "tag_state")

    @_builtins.property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Sequence[_builtins.str]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class GetRepositoryCleanupPolicyMostRecentVersionResult(dict):
    def __init__(__self__, *,
                 keep_count: _builtins.int,
                 package_name_prefixes: Sequence[_builtins.str]):
        """
        :param _builtins.int keep_count: Minimum number of versions to keep.
        :param Sequence[_builtins.str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "keep_count", keep_count)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @_builtins.property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> _builtins.int:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @_builtins.property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[_builtins.str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class GetRepositoryDockerConfigResult(dict):
    def __init__(__self__, *,
                 immutable_tags: _builtins.bool):
        """
        :param _builtins.bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        pulumi.set(__self__, "immutable_tags", immutable_tags)

    @_builtins.property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> _builtins.bool:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class GetRepositoryMavenConfigResult(dict):
    def __init__(__self__, *,
                 allow_snapshot_overwrites: _builtins.bool,
                 version_policy: _builtins.str):
        """
        :param _builtins.bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param _builtins.str version_policy: Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        pulumi.set(__self__, "version_policy", version_policy)

    @_builtins.property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> _builtins.bool:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @_builtins.property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> _builtins.str:
        """
        Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 apt_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult'],
                 common_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigCommonRepositoryResult'],
                 description: _builtins.str,
                 disable_upstream_validation: _builtins.bool,
                 docker_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult'],
                 maven_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult'],
                 npm_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult'],
                 python_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult'],
                 upstream_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult'],
                 yum_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryArgs'] apt_repositories: Specific settings for an Apt remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigCommonRepositoryArgs'] common_repositories: Specific settings for an Artifact Registory remote repository.
        :param _builtins.str description: The description of the remote source.
        :param _builtins.bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryArgs'] docker_repositories: Specific settings for a Docker remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryArgs'] maven_repositories: Specific settings for a Maven remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryArgs'] npm_repositories: Specific settings for an Npm remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryArgs'] python_repositories: Specific settings for a Python remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialArgs'] upstream_credentials: The credentials used to access the remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryArgs'] yum_repositories: Specific settings for an Yum remote repository.
        """
        pulumi.set(__self__, "apt_repositories", apt_repositories)
        pulumi.set(__self__, "common_repositories", common_repositories)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        pulumi.set(__self__, "docker_repositories", docker_repositories)
        pulumi.set(__self__, "maven_repositories", maven_repositories)
        pulumi.set(__self__, "npm_repositories", npm_repositories)
        pulumi.set(__self__, "python_repositories", python_repositories)
        pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        pulumi.set(__self__, "yum_repositories", yum_repositories)

    @_builtins.property
    @pulumi.getter(name="aptRepositories")
    def apt_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult']:
        """
        Specific settings for an Apt remote repository.
        """
        return pulumi.get(self, "apt_repositories")

    @_builtins.property
    @pulumi.getter(name="commonRepositories")
    def common_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigCommonRepositoryResult']:
        """
        Specific settings for an Artifact Registory remote repository.
        """
        return pulumi.get(self, "common_repositories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> _builtins.bool:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @_builtins.property
    @pulumi.getter(name="dockerRepositories")
    def docker_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult']:
        """
        Specific settings for a Docker remote repository.
        """
        return pulumi.get(self, "docker_repositories")

    @_builtins.property
    @pulumi.getter(name="mavenRepositories")
    def maven_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult']:
        """
        Specific settings for a Maven remote repository.
        """
        return pulumi.get(self, "maven_repositories")

    @_builtins.property
    @pulumi.getter(name="npmRepositories")
    def npm_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult']:
        """
        Specific settings for an Npm remote repository.
        """
        return pulumi.get(self, "npm_repositories")

    @_builtins.property
    @pulumi.getter(name="pythonRepositories")
    def python_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult']:
        """
        Specific settings for a Python remote repository.
        """
        return pulumi.get(self, "python_repositories")

    @_builtins.property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult']:
        """
        The credentials used to access the remote repository.
        """
        return pulumi.get(self, "upstream_credentials")

    @_builtins.property
    @pulumi.getter(name="yumRepositories")
    def yum_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']:
        """
        Specific settings for an Yum remote repository.
        """
        return pulumi.get(self, "yum_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Apt repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @_builtins.property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: _builtins.str,
                 repository_path: _builtins.str):
        """
        :param _builtins.str repository_base: A common public repository base for Apt, e.g. '"debian/dists/stable"' Possible values: ["DEBIAN", "UBUNTU", "DEBIAN_SNAPSHOT"]
        :param _builtins.str repository_path: Specific repository from the base.
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @_builtins.property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> _builtins.str:
        """
        A common public repository base for Apt, e.g. '"debian/dists/stable"' Possible values: ["DEBIAN", "UBUNTU", "DEBIAN_SNAPSHOT"]
        """
        return pulumi.get(self, "repository_base")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> _builtins.str:
        """
        Specific repository from the base.
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigCommonRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: One of:
               a. Artifact Registry Repository resource, e.g. 'projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY'
               b. URI to the registry, e.g. '"https://registry-1.docker.io"'
               c. URI to Artifact Registry Repository, e.g. '"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"'
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        One of:
        a. Artifact Registry Repository resource, e.g. 'projects/UPSTREAM_PROJECT_ID/locations/REGION/repositories/UPSTREAM_REPOSITORY'
        b. URI to the registry, e.g. '"https://registry-1.docker.io"'
        c. URI to Artifact Registry Repository, e.g. '"https://REGION-docker.pkg.dev/UPSTREAM_PROJECT_ID/UPSTREAM_REPOSITORY"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult'],
                 public_repository: _builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param _builtins.str public_repository: Address of the remote repository. Possible values: ["DOCKER_HUB"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> _builtins.str:
        """
        Address of the remote repository. Possible values: ["DOCKER_HUB"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult'],
                 public_repository: _builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param _builtins.str public_repository: Address of the remote repository. Possible values: ["MAVEN_CENTRAL"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> _builtins.str:
        """
        Address of the remote repository. Possible values: ["MAVEN_CENTRAL"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult'],
                 public_repository: _builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param _builtins.str public_repository: Address of the remote repository. Possible values: ["NPMJS"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> _builtins.str:
        """
        Address of the remote repository. Possible values: ["NPMJS"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult'],
                 public_repository: _builtins.str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs'] custom_repositories: [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        :param _builtins.str public_repository: Address of the remote repository. Possible values: ["PYPI"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @_builtins.property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult']:
        """
        [Deprecated, please use commonRepository instead] Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @_builtins.property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> _builtins.str:
        """
        Address of the remote repository. Possible values: ["PYPI"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: _builtins.str):
        """
        :param _builtins.str uri: Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult(dict):
    def __init__(__self__, *,
                 username_password_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialArgs'] username_password_credentials: Use username and password to access the remote repository.
        """
        pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @_builtins.property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']:
        """
        Use username and password to access the remote repository.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult(dict):
    def __init__(__self__, *,
                 password_secret_version: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               'projects/{project}/secrets/{secret}/versions/{version}'.
        :param _builtins.str username: The username to access the remote repository.
        """
        pulumi.set(__self__, "password_secret_version", password_secret_version)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> _builtins.str:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        'projects/{project}/secrets/{secret}/versions/{version}'.
        """
        return pulumi.get(self, "password_secret_version")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Yum repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @_builtins.property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: _builtins.str,
                 repository_path: _builtins.str):
        """
        :param _builtins.str repository_base: A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        :param _builtins.str repository_path: Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @_builtins.property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> _builtins.str:
        """
        A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        """
        return pulumi.get(self, "repository_base")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> _builtins.str:
        """
        Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 upstream_policies: Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']):
        """
        :param Sequence['GetRepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
        """
        pulumi.set(__self__, "upstream_policies", upstream_policies)

    @_builtins.property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 priority: _builtins.int,
                 repository: _builtins.str):
        """
        :param _builtins.str id: The user-provided ID of the upstream policy.
        :param _builtins.int priority: Entries with a greater priority value take precedence in the pull order.
        :param _builtins.str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "repository", repository)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetRepositoryVulnerabilityScanningConfigResult(dict):
    def __init__(__self__, *,
                 enablement_config: _builtins.str,
                 enablement_state: _builtins.str,
                 enablement_state_reason: _builtins.str):
        """
        :param _builtins.str enablement_config: This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository. Possible values: ["INHERITED", "DISABLED"]
        :param _builtins.str enablement_state: This field returns whether scanning is active for this repository.
        :param _builtins.str enablement_state_reason: This provides an explanation for the state of scanning on this repository.
        """
        pulumi.set(__self__, "enablement_config", enablement_config)
        pulumi.set(__self__, "enablement_state", enablement_state)
        pulumi.set(__self__, "enablement_state_reason", enablement_state_reason)

    @_builtins.property
    @pulumi.getter(name="enablementConfig")
    def enablement_config(self) -> _builtins.str:
        """
        This configures whether vulnerability scanning is automatically performed for artifacts pushed to this repository. Possible values: ["INHERITED", "DISABLED"]
        """
        return pulumi.get(self, "enablement_config")

    @_builtins.property
    @pulumi.getter(name="enablementState")
    def enablement_state(self) -> _builtins.str:
        """
        This field returns whether scanning is active for this repository.
        """
        return pulumi.get(self, "enablement_state")

    @_builtins.property
    @pulumi.getter(name="enablementStateReason")
    def enablement_state_reason(self) -> _builtins.str:
        """
        This provides an explanation for the state of scanning on this repository.
        """
        return pulumi.get(self, "enablement_state_reason")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str name: The name of the tag, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1`. If the package part contains slashes, the slashes are escaped.
        :param _builtins.str version: The version of the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1`. If the package part contains slashes, the slashes are escaped.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the tag.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVersionRelatedTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str name: The name of the version, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/version1`. If the package part contains slashes, the slashes are escaped.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the version, for example: `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/version1`. If the package part contains slashes, the slashes are escaped.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


