# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupPlanAssociationsResult',
    'AwaitableGetBackupPlanAssociationsResult',
    'get_backup_plan_associations',
    'get_backup_plan_associations_output',
]

@pulumi.output_type
class GetBackupPlanAssociationsResult:
    """
    A collection of values returned by getBackupPlanAssociations.
    """
    def __init__(__self__, associations=None, id=None, location=None, project=None, resource_type=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetBackupPlanAssociationsAssociationResult']:
        """
        A list of the backup plan associations found.
        """
        return pulumi.get(self, "associations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        return pulumi.get(self, "resource_type")


class AwaitableGetBackupPlanAssociationsResult(GetBackupPlanAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlanAssociationsResult(
            associations=self.associations,
            id=self.id,
            location=self.location,
            project=self.project,
            resource_type=self.resource_type)


def get_backup_plan_associations(location: Optional[_builtins.str] = None,
                                 project: Optional[_builtins.str] = None,
                                 resource_type: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlanAssociationsResult:
    """
    Provides a list of Backup and DR BackupPlanAssociations for a specific resource type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    compute_instance_associations = gcp.backupdisasterrecovery.get_backup_plan_associations(location="us-central1",
        resource_type="compute.googleapis.com/Instance")
    ```


    :param _builtins.str location: The location where the Backup Plan Association resources reside.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str resource_type: The resource type of the workload. For example, sqladmin.googleapis.com/Instance or compute.googleapis.com/Instance.
           
           - - -
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:backupdisasterrecovery/getBackupPlanAssociations:getBackupPlanAssociations', __args__, opts=opts, typ=GetBackupPlanAssociationsResult).value

    return AwaitableGetBackupPlanAssociationsResult(
        associations=pulumi.get(__ret__, 'associations'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'),
        resource_type=pulumi.get(__ret__, 'resource_type'))
def get_backup_plan_associations_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                                        project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupPlanAssociationsResult]:
    """
    Provides a list of Backup and DR BackupPlanAssociations for a specific resource type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    compute_instance_associations = gcp.backupdisasterrecovery.get_backup_plan_associations(location="us-central1",
        resource_type="compute.googleapis.com/Instance")
    ```


    :param _builtins.str location: The location where the Backup Plan Association resources reside.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str resource_type: The resource type of the workload. For example, sqladmin.googleapis.com/Instance or compute.googleapis.com/Instance.
           
           - - -
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:backupdisasterrecovery/getBackupPlanAssociations:getBackupPlanAssociations', __args__, opts=opts, typ=GetBackupPlanAssociationsResult)
    return __ret__.apply(lambda __response__: GetBackupPlanAssociationsResult(
        associations=pulumi.get(__response__, 'associations'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project'),
        resource_type=pulumi.get(__response__, 'resource_type')))
