# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AppConnectionApplicationEndpointArgs',
    'AppConnectionApplicationEndpointArgsDict',
    'AppConnectionGatewayArgs',
    'AppConnectionGatewayArgsDict',
    'AppConnectorPrincipalInfoArgs',
    'AppConnectorPrincipalInfoArgsDict',
    'AppConnectorPrincipalInfoServiceAccountArgs',
    'AppConnectorPrincipalInfoServiceAccountArgsDict',
    'AppGatewayAllocatedConnectionArgs',
    'AppGatewayAllocatedConnectionArgsDict',
    'SecurityGatewayApplicationEndpointMatcherArgs',
    'SecurityGatewayApplicationEndpointMatcherArgsDict',
    'SecurityGatewayApplicationIamBindingConditionArgs',
    'SecurityGatewayApplicationIamBindingConditionArgsDict',
    'SecurityGatewayApplicationIamMemberConditionArgs',
    'SecurityGatewayApplicationIamMemberConditionArgsDict',
    'SecurityGatewayApplicationUpstreamArgs',
    'SecurityGatewayApplicationUpstreamArgsDict',
    'SecurityGatewayApplicationUpstreamEgressPolicyArgs',
    'SecurityGatewayApplicationUpstreamEgressPolicyArgsDict',
    'SecurityGatewayApplicationUpstreamExternalArgs',
    'SecurityGatewayApplicationUpstreamExternalArgsDict',
    'SecurityGatewayApplicationUpstreamExternalEndpointArgs',
    'SecurityGatewayApplicationUpstreamExternalEndpointArgsDict',
    'SecurityGatewayApplicationUpstreamNetworkArgs',
    'SecurityGatewayApplicationUpstreamNetworkArgsDict',
    'SecurityGatewayApplicationUpstreamProxyProtocolArgs',
    'SecurityGatewayApplicationUpstreamProxyProtocolArgsDict',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgsDict',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgsDict',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgsDict',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgsDict',
    'SecurityGatewayHubArgs',
    'SecurityGatewayHubArgsDict',
    'SecurityGatewayHubInternetGatewayArgs',
    'SecurityGatewayHubInternetGatewayArgsDict',
    'SecurityGatewayIamBindingConditionArgs',
    'SecurityGatewayIamBindingConditionArgsDict',
    'SecurityGatewayIamMemberConditionArgs',
    'SecurityGatewayIamMemberConditionArgsDict',
    'SecurityGatewayProxyProtocolConfigArgs',
    'SecurityGatewayProxyProtocolConfigArgsDict',
    'SecurityGatewayProxyProtocolConfigContextualHeadersArgs',
    'SecurityGatewayProxyProtocolConfigContextualHeadersArgsDict',
    'SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs',
    'SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgsDict',
    'SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs',
    'SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgsDict',
    'SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs',
    'SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgsDict',
    'SecurityGatewayServiceDiscoveryArgs',
    'SecurityGatewayServiceDiscoveryArgsDict',
    'SecurityGatewayServiceDiscoveryApiGatewayArgs',
    'SecurityGatewayServiceDiscoveryApiGatewayArgsDict',
    'SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs',
    'SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgsDict',
]

MYPY = False

if not MYPY:
    class AppConnectionApplicationEndpointArgsDict(TypedDict):
        host: pulumi.Input[_builtins.str]
        """
        Hostname or IP address of the remote application endpoint.
        """
        port: pulumi.Input[_builtins.int]
        """
        Port of the remote application endpoint.
        """
elif False:
    AppConnectionApplicationEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectionApplicationEndpointArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] host: Hostname or IP address of the remote application endpoint.
        :param pulumi.Input[_builtins.int] port: Port of the remote application endpoint.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Port of the remote application endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)


if not MYPY:
    class AppConnectionGatewayArgsDict(TypedDict):
        app_gateway: pulumi.Input[_builtins.str]
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        ingress_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Output)
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Server-defined URI for this resource.
        """
elif False:
    AppConnectionGatewayArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectionGatewayArgs:
    def __init__(__self__, *,
                 app_gateway: pulumi.Input[_builtins.str],
                 ingress_port: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] app_gateway: AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        :param pulumi.Input[_builtins.int] ingress_port: (Output)
               Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        :param pulumi.Input[_builtins.str] type: The type of hosting used by the gateway. Refer to
               https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
               for a list of possible values.
        :param pulumi.Input[_builtins.str] uri: (Output)
               Server-defined URI for this resource.
        """
        pulumi.set(__self__, "app_gateway", app_gateway)
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="appGateway")
    def app_gateway(self) -> pulumi.Input[_builtins.str]:
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        return pulumi.get(self, "app_gateway")

    @app_gateway.setter
    def app_gateway(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_gateway", value)

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Output)
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "ingress_port")

    @ingress_port.setter
    def ingress_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_port", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class AppConnectorPrincipalInfoArgsDict(TypedDict):
        service_account: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgsDict']
        """
        ServiceAccount represents a GCP service account.
        Structure is documented below.
        """
elif False:
    AppConnectorPrincipalInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectorPrincipalInfoArgs:
    def __init__(__self__, *,
                 service_account: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']):
        """
        :param pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs'] service_account: ServiceAccount represents a GCP service account.
               Structure is documented below.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']:
        """
        ServiceAccount represents a GCP service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input['AppConnectorPrincipalInfoServiceAccountArgs']):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class AppConnectorPrincipalInfoServiceAccountArgsDict(TypedDict):
        email: pulumi.Input[_builtins.str]
        """
        Email address of the service account.
        """
elif False:
    AppConnectorPrincipalInfoServiceAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppConnectorPrincipalInfoServiceAccountArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] email: Email address of the service account.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)


if not MYPY:
    class AppGatewayAllocatedConnectionArgsDict(TypedDict):
        ingress_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The ingress port of an allocated connection.
        """
        psc_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        The PSC uri of an allocated connection.
        """
elif False:
    AppGatewayAllocatedConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AppGatewayAllocatedConnectionArgs:
    def __init__(__self__, *,
                 ingress_port: Optional[pulumi.Input[_builtins.int]] = None,
                 psc_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] ingress_port: The ingress port of an allocated connection.
        :param pulumi.Input[_builtins.str] psc_uri: The PSC uri of an allocated connection.
        """
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if psc_uri is not None:
            pulumi.set(__self__, "psc_uri", psc_uri)

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ingress port of an allocated connection.
        """
        return pulumi.get(self, "ingress_port")

    @ingress_port.setter
    def ingress_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_port", value)

    @_builtins.property
    @pulumi.getter(name="pscUri")
    def psc_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The PSC uri of an allocated connection.
        """
        return pulumi.get(self, "psc_uri")

    @psc_uri.setter
    def psc_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psc_uri", value)


if not MYPY:
    class SecurityGatewayApplicationEndpointMatcherArgsDict(TypedDict):
        hostname: pulumi.Input[_builtins.str]
        """
        Required. Hostname of the application.
        """
        ports: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
        """
        Optional. Ports of the application.
        """
elif False:
    SecurityGatewayApplicationEndpointMatcherArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationEndpointMatcherArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 ports: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        """
        :param pulumi.Input[_builtins.str] hostname: Required. Hostname of the application.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] ports: Optional. Ports of the application.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Hostname of the application.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        Optional. Ports of the application.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "ports", value)


if not MYPY:
    class SecurityGatewayApplicationIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    SecurityGatewayApplicationIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayApplicationIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    SecurityGatewayApplicationIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamArgsDict(TypedDict):
        egress_policy: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgsDict']]
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        external: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamExternalArgsDict']]
        """
        List of the external endpoints to forward traffic to.
        Structure is documented below.
        """
        network: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgsDict']]
        """
        Network to forward traffic to.
        Structure is documented below.
        """
        proxy_protocol: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolArgsDict']]
        """
        Shared proxy configuration for all apps.
        Structure is documented below.
        """
elif False:
    SecurityGatewayApplicationUpstreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamArgs:
    def __init__(__self__, *,
                 egress_policy: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']] = None,
                 external: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamExternalArgs']] = None,
                 network: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']] = None,
                 proxy_protocol: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs'] egress_policy: Optional. Routing policy information.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamExternalArgs'] external: List of the external endpoints to forward traffic to.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs'] network: Network to forward traffic to.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolArgs'] proxy_protocol: Shared proxy configuration for all apps.
               Structure is documented below.
        """
        if egress_policy is not None:
            pulumi.set(__self__, "egress_policy", egress_policy)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)

    @_builtins.property
    @pulumi.getter(name="egressPolicy")
    def egress_policy(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']]:
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policy")

    @egress_policy.setter
    def egress_policy(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamEgressPolicyArgs']]):
        pulumi.set(self, "egress_policy", value)

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamExternalArgs']]:
        """
        List of the external endpoints to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamExternalArgs']]):
        pulumi.set(self, "external", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']]:
        """
        Network to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolArgs']]:
        """
        Shared proxy configuration for all apps.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolArgs']]):
        pulumi.set(self, "proxy_protocol", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamEgressPolicyArgsDict(TypedDict):
        regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Required. List of regions where the application sends traffic to.
        """
elif False:
    SecurityGatewayApplicationUpstreamEgressPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamEgressPolicyArgs:
    def __init__(__self__, *,
                 regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: Required. List of regions where the application sends traffic to.
        """
        pulumi.set(__self__, "regions", regions)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Required. List of regions where the application sends traffic to.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "regions", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamExternalArgsDict(TypedDict):
        endpoints: pulumi.Input[Sequence[pulumi.Input['SecurityGatewayApplicationUpstreamExternalEndpointArgsDict']]]
        """
        List of the endpoints to forward traffic to.
        Structure is documented below.
        """
elif False:
    SecurityGatewayApplicationUpstreamExternalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamExternalArgs:
    def __init__(__self__, *,
                 endpoints: pulumi.Input[Sequence[pulumi.Input['SecurityGatewayApplicationUpstreamExternalEndpointArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SecurityGatewayApplicationUpstreamExternalEndpointArgs']]] endpoints: List of the endpoints to forward traffic to.
               Structure is documented below.
        """
        pulumi.set(__self__, "endpoints", endpoints)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[Sequence[pulumi.Input['SecurityGatewayApplicationUpstreamExternalEndpointArgs']]]:
        """
        List of the endpoints to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[Sequence[pulumi.Input['SecurityGatewayApplicationUpstreamExternalEndpointArgs']]]):
        pulumi.set(self, "endpoints", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamExternalEndpointArgsDict(TypedDict):
        hostname: pulumi.Input[_builtins.str]
        """
        Hostname of the endpoint.
        """
        port: pulumi.Input[_builtins.int]
        """
        Port of the endpoint.
        """
elif False:
    SecurityGatewayApplicationUpstreamExternalEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamExternalEndpointArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] hostname: Hostname of the endpoint.
        :param pulumi.Input[_builtins.int] port: Port of the endpoint.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamNetworkArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
elif False:
    SecurityGatewayApplicationUpstreamNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamNetworkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Required. Network name is of the format:
               `projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamProxyProtocolArgsDict(TypedDict):
        allowed_client_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The configuration for the proxy.
        """
        client_ip: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Client IP configuration. The client IP address is included if true.
        """
        contextual_headers: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgsDict']]
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        gateway_identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        metadata_headers: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
elif False:
    SecurityGatewayApplicationUpstreamProxyProtocolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamProxyProtocolArgs:
    def __init__(__self__, *,
                 allowed_client_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 contextual_headers: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs']] = None,
                 gateway_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_headers: The configuration for the proxy.
        :param pulumi.Input[_builtins.bool] client_ip: Client IP configuration. The client IP address is included if true.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs'] contextual_headers: Configuration for the contextual headers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] gateway_identity: Gateway identity configuration.
               Possible values are: `RESOURCE_NAME`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata_headers: Custom resource specific headers along with the values.
               The names should conform to RFC 9110:
               > Field names SHOULD constrain themselves to alphanumeric characters, "-",
               and ".", and SHOULD begin with a letter.
               > Field values SHOULD contain only ASCII printable characters and tab.
        """
        if allowed_client_headers is not None:
            pulumi.set(__self__, "allowed_client_headers", allowed_client_headers)
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)
        if contextual_headers is not None:
            pulumi.set(__self__, "contextual_headers", contextual_headers)
        if gateway_identity is not None:
            pulumi.set(__self__, "gateway_identity", gateway_identity)
        if metadata_headers is not None:
            pulumi.set(__self__, "metadata_headers", metadata_headers)

    @_builtins.property
    @pulumi.getter(name="allowedClientHeaders")
    def allowed_client_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The configuration for the proxy.
        """
        return pulumi.get(self, "allowed_client_headers")

    @allowed_client_headers.setter
    def allowed_client_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_headers", value)

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Client IP configuration. The client IP address is included if true.
        """
        return pulumi.get(self, "client_ip")

    @client_ip.setter
    def client_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_ip", value)

    @_builtins.property
    @pulumi.getter(name="contextualHeaders")
    def contextual_headers(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs']]:
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        return pulumi.get(self, "contextual_headers")

    @contextual_headers.setter
    def contextual_headers(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs']]):
        pulumi.set(self, "contextual_headers", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIdentity")
    def gateway_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        return pulumi.get(self, "gateway_identity")

    @gateway_identity.setter
    def gateway_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_identity", value)

    @_builtins.property
    @pulumi.getter(name="metadataHeaders")
    def metadata_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
        return pulumi.get(self, "metadata_headers")

    @metadata_headers.setter
    def metadata_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata_headers", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgsDict(TypedDict):
        device_info: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgsDict']]
        """
        Device info configuration.
        Structure is documented below.
        """
        group_info: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgsDict']]
        """
        Group info configuration.
        Structure is documented below.
        """
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        user_info: NotRequired[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgsDict']]
        """
        User info configuration.
        Structure is documented below.
        """
elif False:
    SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs:
    def __init__(__self__, *,
                 device_info: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs']] = None,
                 group_info: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs']] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_info: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs'] device_info: Device info configuration.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs'] group_info: Group info configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] output_type: Default output type for all enabled headers.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        :param pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs'] user_info: User info configuration.
               Structure is documented below.
        """
        if device_info is not None:
            pulumi.set(__self__, "device_info", device_info)
        if group_info is not None:
            pulumi.set(__self__, "group_info", group_info)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if user_info is not None:
            pulumi.set(__self__, "user_info", user_info)

    @_builtins.property
    @pulumi.getter(name="deviceInfo")
    def device_info(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs']]:
        """
        Device info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "device_info")

    @device_info.setter
    def device_info(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs']]):
        pulumi.set(self, "device_info", value)

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs']]:
        """
        Group info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_info")

    @group_info.setter
    def group_info(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs']]):
        pulumi.set(self, "group_info", value)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)

    @_builtins.property
    @pulumi.getter(name="userInfo")
    def user_info(self) -> Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs']]:
        """
        User info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "user_info")

    @user_info.setter
    def user_info(self, value: Optional[pulumi.Input['SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs']]):
        pulumi.set(self, "user_info", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated device info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated group info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated user info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayHubArgsDict(TypedDict):
        region: pulumi.Input[_builtins.str]
        """
        The identifier for this object. Format specified above.
        """
        internet_gateway: NotRequired[pulumi.Input['SecurityGatewayHubInternetGatewayArgsDict']]
        """
        Internet Gateway configuration.
        Structure is documented below.
        """
elif False:
    SecurityGatewayHubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayHubArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 internet_gateway: Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']] = None):
        """
        :param pulumi.Input[_builtins.str] region: The identifier for this object. Format specified above.
        :param pulumi.Input['SecurityGatewayHubInternetGatewayArgs'] internet_gateway: Internet Gateway configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "region", region)
        if internet_gateway is not None:
            pulumi.set(__self__, "internet_gateway", internet_gateway)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="internetGateway")
    def internet_gateway(self) -> Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']]:
        """
        Internet Gateway configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_gateway")

    @internet_gateway.setter
    def internet_gateway(self, value: Optional[pulumi.Input['SecurityGatewayHubInternetGatewayArgs']]):
        pulumi.set(self, "internet_gateway", value)


if not MYPY:
    class SecurityGatewayHubInternetGatewayArgsDict(TypedDict):
        assigned_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        (Output)
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
elif False:
    SecurityGatewayHubInternetGatewayArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayHubInternetGatewayArgs:
    def __init__(__self__, *,
                 assigned_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] assigned_ips: (Output)
               Output only. List of IP addresses assigned to the Cloud NAT.
        """
        if assigned_ips is not None:
            pulumi.set(__self__, "assigned_ips", assigned_ips)

    @_builtins.property
    @pulumi.getter(name="assignedIps")
    def assigned_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Output)
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
        return pulumi.get(self, "assigned_ips")

    @assigned_ips.setter
    def assigned_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "assigned_ips", value)


if not MYPY:
    class SecurityGatewayIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    SecurityGatewayIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    SecurityGatewayIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecurityGatewayProxyProtocolConfigArgsDict(TypedDict):
        allowed_client_headers: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The configuration for the proxy.
        """
        client_ip: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Client IP configuration. The client IP address is included if true.
        """
        contextual_headers: NotRequired[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersArgsDict']]
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        gateway_identity: NotRequired[pulumi.Input[_builtins.str]]
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        metadata_headers: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
elif False:
    SecurityGatewayProxyProtocolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayProxyProtocolConfigArgs:
    def __init__(__self__, *,
                 allowed_client_headers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 contextual_headers: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersArgs']] = None,
                 gateway_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_client_headers: The configuration for the proxy.
        :param pulumi.Input[_builtins.bool] client_ip: Client IP configuration. The client IP address is included if true.
        :param pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersArgs'] contextual_headers: Configuration for the contextual headers.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] gateway_identity: Gateway identity configuration.
               Possible values are: `RESOURCE_NAME`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata_headers: Custom resource specific headers along with the values.
               The names should conform to RFC 9110:
               > Field names SHOULD constrain themselves to alphanumeric characters, "-",
               and ".", and SHOULD begin with a letter.
               > Field values SHOULD contain only ASCII printable characters and tab.
        """
        if allowed_client_headers is not None:
            pulumi.set(__self__, "allowed_client_headers", allowed_client_headers)
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)
        if contextual_headers is not None:
            pulumi.set(__self__, "contextual_headers", contextual_headers)
        if gateway_identity is not None:
            pulumi.set(__self__, "gateway_identity", gateway_identity)
        if metadata_headers is not None:
            pulumi.set(__self__, "metadata_headers", metadata_headers)

    @_builtins.property
    @pulumi.getter(name="allowedClientHeaders")
    def allowed_client_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The configuration for the proxy.
        """
        return pulumi.get(self, "allowed_client_headers")

    @allowed_client_headers.setter
    def allowed_client_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_client_headers", value)

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Client IP configuration. The client IP address is included if true.
        """
        return pulumi.get(self, "client_ip")

    @client_ip.setter
    def client_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_ip", value)

    @_builtins.property
    @pulumi.getter(name="contextualHeaders")
    def contextual_headers(self) -> Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersArgs']]:
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        return pulumi.get(self, "contextual_headers")

    @contextual_headers.setter
    def contextual_headers(self, value: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersArgs']]):
        pulumi.set(self, "contextual_headers", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIdentity")
    def gateway_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        return pulumi.get(self, "gateway_identity")

    @gateway_identity.setter
    def gateway_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_identity", value)

    @_builtins.property
    @pulumi.getter(name="metadataHeaders")
    def metadata_headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
        return pulumi.get(self, "metadata_headers")

    @metadata_headers.setter
    def metadata_headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata_headers", value)


if not MYPY:
    class SecurityGatewayProxyProtocolConfigContextualHeadersArgsDict(TypedDict):
        device_info: NotRequired[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgsDict']]
        """
        Device info configuration.
        Structure is documented below.
        """
        group_info: NotRequired[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgsDict']]
        """
        Group info configuration.
        Structure is documented below.
        """
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        user_info: NotRequired[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgsDict']]
        """
        User info configuration.
        Structure is documented below.
        """
elif False:
    SecurityGatewayProxyProtocolConfigContextualHeadersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayProxyProtocolConfigContextualHeadersArgs:
    def __init__(__self__, *,
                 device_info: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs']] = None,
                 group_info: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs']] = None,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_info: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs'] device_info: Device info configuration.
               Structure is documented below.
        :param pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs'] group_info: Group info configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] output_type: Default output type for all enabled headers.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        :param pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs'] user_info: User info configuration.
               Structure is documented below.
        """
        if device_info is not None:
            pulumi.set(__self__, "device_info", device_info)
        if group_info is not None:
            pulumi.set(__self__, "group_info", group_info)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if user_info is not None:
            pulumi.set(__self__, "user_info", user_info)

    @_builtins.property
    @pulumi.getter(name="deviceInfo")
    def device_info(self) -> Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs']]:
        """
        Device info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "device_info")

    @device_info.setter
    def device_info(self, value: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs']]):
        pulumi.set(self, "device_info", value)

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs']]:
        """
        Group info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_info")

    @group_info.setter
    def group_info(self, value: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs']]):
        pulumi.set(self, "group_info", value)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)

    @_builtins.property
    @pulumi.getter(name="userInfo")
    def user_info(self) -> Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs']]:
        """
        User info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "user_info")

    @user_info.setter
    def user_info(self, value: Optional[pulumi.Input['SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs']]):
        pulumi.set(self, "user_info", value)


if not MYPY:
    class SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated device info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated group info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgsDict(TypedDict):
        output_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
elif False:
    SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs:
    def __init__(__self__, *,
                 output_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] output_type: The output type of the delegated user info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_type", value)


if not MYPY:
    class SecurityGatewayServiceDiscoveryArgsDict(TypedDict):
        api_gateway: NotRequired[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayArgsDict']]
        """
        External API configuration.
        Structure is documented below.
        """
elif False:
    SecurityGatewayServiceDiscoveryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayServiceDiscoveryArgs:
    def __init__(__self__, *,
                 api_gateway: Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayArgs'] api_gateway: External API configuration.
               Structure is documented below.
        """
        if api_gateway is not None:
            pulumi.set(__self__, "api_gateway", api_gateway)

    @_builtins.property
    @pulumi.getter(name="apiGateway")
    def api_gateway(self) -> Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayArgs']]:
        """
        External API configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "api_gateway")

    @api_gateway.setter
    def api_gateway(self, value: Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayArgs']]):
        pulumi.set(self, "api_gateway", value)


if not MYPY:
    class SecurityGatewayServiceDiscoveryApiGatewayArgsDict(TypedDict):
        resource_override: NotRequired[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgsDict']]
        """
        Enables fetching resource model updates to alter service behavior per Chrome profile.
        Structure is documented below.
        """
elif False:
    SecurityGatewayServiceDiscoveryApiGatewayArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayServiceDiscoveryApiGatewayArgs:
    def __init__(__self__, *,
                 resource_override: Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs']] = None):
        """
        :param pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs'] resource_override: Enables fetching resource model updates to alter service behavior per Chrome profile.
               Structure is documented below.
        """
        if resource_override is not None:
            pulumi.set(__self__, "resource_override", resource_override)

    @_builtins.property
    @pulumi.getter(name="resourceOverride")
    def resource_override(self) -> Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs']]:
        """
        Enables fetching resource model updates to alter service behavior per Chrome profile.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_override")

    @resource_override.setter
    def resource_override(self, value: Optional[pulumi.Input['SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs']]):
        pulumi.set(self, "resource_override", value)


if not MYPY:
    class SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgsDict(TypedDict):
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Contains uri path fragment where HTTP request is sent.
        """
elif False:
    SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] path: Contains uri path fragment where HTTP request is sent.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contains uri path fragment where HTTP request is sent.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)


