# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppConnectionApplicationEndpoint',
    'AppConnectionGateway',
    'AppConnectorPrincipalInfo',
    'AppConnectorPrincipalInfoServiceAccount',
    'AppGatewayAllocatedConnection',
    'SecurityGatewayApplicationEndpointMatcher',
    'SecurityGatewayApplicationIamBindingCondition',
    'SecurityGatewayApplicationIamMemberCondition',
    'SecurityGatewayApplicationUpstream',
    'SecurityGatewayApplicationUpstreamEgressPolicy',
    'SecurityGatewayApplicationUpstreamExternal',
    'SecurityGatewayApplicationUpstreamExternalEndpoint',
    'SecurityGatewayApplicationUpstreamNetwork',
    'SecurityGatewayApplicationUpstreamProxyProtocol',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo',
    'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo',
    'SecurityGatewayHub',
    'SecurityGatewayHubInternetGateway',
    'SecurityGatewayIamBindingCondition',
    'SecurityGatewayIamMemberCondition',
    'SecurityGatewayProxyProtocolConfig',
    'SecurityGatewayProxyProtocolConfigContextualHeaders',
    'SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo',
    'SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo',
    'SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo',
    'SecurityGatewayServiceDiscovery',
    'SecurityGatewayServiceDiscoveryApiGateway',
    'SecurityGatewayServiceDiscoveryApiGatewayResourceOverride',
    'GetAppConnectionApplicationEndpointResult',
    'GetAppConnectionGatewayResult',
    'GetAppConnectorPrincipalInfoResult',
    'GetAppConnectorPrincipalInfoServiceAccountResult',
    'GetAppGatewayAllocatedConnectionResult',
    'GetSecurityGatewayHubResult',
    'GetSecurityGatewayHubInternetGatewayResult',
    'GetSecurityGatewayProxyProtocolConfigResult',
    'GetSecurityGatewayProxyProtocolConfigContextualHeaderResult',
    'GetSecurityGatewayProxyProtocolConfigContextualHeaderDeviceInfoResult',
    'GetSecurityGatewayProxyProtocolConfigContextualHeaderGroupInfoResult',
    'GetSecurityGatewayProxyProtocolConfigContextualHeaderUserInfoResult',
    'GetSecurityGatewayServiceDiscoveryResult',
    'GetSecurityGatewayServiceDiscoveryApiGatewayResult',
    'GetSecurityGatewayServiceDiscoveryApiGatewayResourceOverrideResult',
]

@pulumi.output_type
class AppConnectionApplicationEndpoint(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str host: Hostname or IP address of the remote application endpoint.
        :param _builtins.int port: Port of the remote application endpoint.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the remote application endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class AppConnectionGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appGateway":
            suggest = "app_gateway"
        elif key == "ingressPort":
            suggest = "ingress_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppConnectionGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppConnectionGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppConnectionGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_gateway: _builtins.str,
                 ingress_port: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str app_gateway: AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        :param _builtins.int ingress_port: (Output)
               Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        :param _builtins.str type: The type of hosting used by the gateway. Refer to
               https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
               for a list of possible values.
        :param _builtins.str uri: (Output)
               Server-defined URI for this resource.
        """
        pulumi.set(__self__, "app_gateway", app_gateway)
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="appGateway")
    def app_gateway(self) -> _builtins.str:
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        return pulumi.get(self, "app_gateway")

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[_builtins.int]:
        """
        (Output)
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "ingress_port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AppConnectorPrincipalInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppConnectorPrincipalInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppConnectorPrincipalInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppConnectorPrincipalInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: 'outputs.AppConnectorPrincipalInfoServiceAccount'):
        """
        :param 'AppConnectorPrincipalInfoServiceAccountArgs' service_account: ServiceAccount represents a GCP service account.
               Structure is documented below.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> 'outputs.AppConnectorPrincipalInfoServiceAccount':
        """
        ServiceAccount represents a GCP service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class AppConnectorPrincipalInfoServiceAccount(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        """
        :param _builtins.str email: Email address of the service account.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class AppGatewayAllocatedConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressPort":
            suggest = "ingress_port"
        elif key == "pscUri":
            suggest = "psc_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppGatewayAllocatedConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppGatewayAllocatedConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppGatewayAllocatedConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_port: Optional[_builtins.int] = None,
                 psc_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.int ingress_port: The ingress port of an allocated connection.
        :param _builtins.str psc_uri: The PSC uri of an allocated connection.
        """
        if ingress_port is not None:
            pulumi.set(__self__, "ingress_port", ingress_port)
        if psc_uri is not None:
            pulumi.set(__self__, "psc_uri", psc_uri)

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> Optional[_builtins.int]:
        """
        The ingress port of an allocated connection.
        """
        return pulumi.get(self, "ingress_port")

    @_builtins.property
    @pulumi.getter(name="pscUri")
    def psc_uri(self) -> Optional[_builtins.str]:
        """
        The PSC uri of an allocated connection.
        """
        return pulumi.get(self, "psc_uri")


@pulumi.output_type
class SecurityGatewayApplicationEndpointMatcher(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 ports: Sequence[_builtins.int]):
        """
        :param _builtins.str hostname: Required. Hostname of the application.
        :param Sequence[_builtins.int] ports: Optional. Ports of the application.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Required. Hostname of the application.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence[_builtins.int]:
        """
        Optional. Ports of the application.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class SecurityGatewayApplicationIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecurityGatewayApplicationIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecurityGatewayApplicationUpstream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressPolicy":
            suggest = "egress_policy"
        elif key == "proxyProtocol":
            suggest = "proxy_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_policy: Optional['outputs.SecurityGatewayApplicationUpstreamEgressPolicy'] = None,
                 external: Optional['outputs.SecurityGatewayApplicationUpstreamExternal'] = None,
                 network: Optional['outputs.SecurityGatewayApplicationUpstreamNetwork'] = None,
                 proxy_protocol: Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocol'] = None):
        """
        :param 'SecurityGatewayApplicationUpstreamEgressPolicyArgs' egress_policy: Optional. Routing policy information.
               Structure is documented below.
        :param 'SecurityGatewayApplicationUpstreamExternalArgs' external: List of the external endpoints to forward traffic to.
               Structure is documented below.
        :param 'SecurityGatewayApplicationUpstreamNetworkArgs' network: Network to forward traffic to.
               Structure is documented below.
        :param 'SecurityGatewayApplicationUpstreamProxyProtocolArgs' proxy_protocol: Shared proxy configuration for all apps.
               Structure is documented below.
        """
        if egress_policy is not None:
            pulumi.set(__self__, "egress_policy", egress_policy)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)

    @_builtins.property
    @pulumi.getter(name="egressPolicy")
    def egress_policy(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamEgressPolicy']:
        """
        Optional. Routing policy information.
        Structure is documented below.
        """
        return pulumi.get(self, "egress_policy")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamExternal']:
        """
        List of the external endpoints to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamNetwork']:
        """
        Network to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocol']:
        """
        Shared proxy configuration for all apps.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy_protocol")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamEgressPolicy(dict):
    def __init__(__self__, *,
                 regions: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] regions: Required. List of regions where the application sends traffic to.
        """
        pulumi.set(__self__, "regions", regions)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence[_builtins.str]:
        """
        Required. List of regions where the application sends traffic to.
        """
        return pulumi.get(self, "regions")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamExternal(dict):
    def __init__(__self__, *,
                 endpoints: Sequence['outputs.SecurityGatewayApplicationUpstreamExternalEndpoint']):
        """
        :param Sequence['SecurityGatewayApplicationUpstreamExternalEndpointArgs'] endpoints: List of the endpoints to forward traffic to.
               Structure is documented below.
        """
        pulumi.set(__self__, "endpoints", endpoints)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.SecurityGatewayApplicationUpstreamExternalEndpoint']:
        """
        List of the endpoints to forward traffic to.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamExternalEndpoint(dict):
    def __init__(__self__, *,
                 hostname: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str hostname: Hostname of the endpoint.
        :param _builtins.int port: Port of the endpoint.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamNetwork(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Required. Network name is of the format:
               `projects/{project}/global/networks/{network}`
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Required. Network name is of the format:
        `projects/{project}/global/networks/{network}`
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamProxyProtocol(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClientHeaders":
            suggest = "allowed_client_headers"
        elif key == "clientIp":
            suggest = "client_ip"
        elif key == "contextualHeaders":
            suggest = "contextual_headers"
        elif key == "gatewayIdentity":
            suggest = "gateway_identity"
        elif key == "metadataHeaders":
            suggest = "metadata_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstreamProxyProtocol. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocol.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocol.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_client_headers: Optional[Sequence[_builtins.str]] = None,
                 client_ip: Optional[_builtins.bool] = None,
                 contextual_headers: Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders'] = None,
                 gateway_identity: Optional[_builtins.str] = None,
                 metadata_headers: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] allowed_client_headers: The configuration for the proxy.
        :param _builtins.bool client_ip: Client IP configuration. The client IP address is included if true.
        :param 'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersArgs' contextual_headers: Configuration for the contextual headers.
               Structure is documented below.
        :param _builtins.str gateway_identity: Gateway identity configuration.
               Possible values are: `RESOURCE_NAME`.
        :param Mapping[str, _builtins.str] metadata_headers: Custom resource specific headers along with the values.
               The names should conform to RFC 9110:
               > Field names SHOULD constrain themselves to alphanumeric characters, "-",
               and ".", and SHOULD begin with a letter.
               > Field values SHOULD contain only ASCII printable characters and tab.
        """
        if allowed_client_headers is not None:
            pulumi.set(__self__, "allowed_client_headers", allowed_client_headers)
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)
        if contextual_headers is not None:
            pulumi.set(__self__, "contextual_headers", contextual_headers)
        if gateway_identity is not None:
            pulumi.set(__self__, "gateway_identity", gateway_identity)
        if metadata_headers is not None:
            pulumi.set(__self__, "metadata_headers", metadata_headers)

    @_builtins.property
    @pulumi.getter(name="allowedClientHeaders")
    def allowed_client_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The configuration for the proxy.
        """
        return pulumi.get(self, "allowed_client_headers")

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[_builtins.bool]:
        """
        Client IP configuration. The client IP address is included if true.
        """
        return pulumi.get(self, "client_ip")

    @_builtins.property
    @pulumi.getter(name="contextualHeaders")
    def contextual_headers(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders']:
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        return pulumi.get(self, "contextual_headers")

    @_builtins.property
    @pulumi.getter(name="gatewayIdentity")
    def gateway_identity(self) -> Optional[_builtins.str]:
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        return pulumi.get(self, "gateway_identity")

    @_builtins.property
    @pulumi.getter(name="metadataHeaders")
    def metadata_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
        return pulumi.get(self, "metadata_headers")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceInfo":
            suggest = "device_info"
        elif key == "groupInfo":
            suggest = "group_info"
        elif key == "outputType":
            suggest = "output_type"
        elif key == "userInfo":
            suggest = "user_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_info: Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo'] = None,
                 group_info: Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo'] = None,
                 output_type: Optional[_builtins.str] = None,
                 user_info: Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo'] = None):
        """
        :param 'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfoArgs' device_info: Device info configuration.
               Structure is documented below.
        :param 'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfoArgs' group_info: Group info configuration.
               Structure is documented below.
        :param _builtins.str output_type: Default output type for all enabled headers.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        :param 'SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfoArgs' user_info: User info configuration.
               Structure is documented below.
        """
        if device_info is not None:
            pulumi.set(__self__, "device_info", device_info)
        if group_info is not None:
            pulumi.set(__self__, "group_info", group_info)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if user_info is not None:
            pulumi.set(__self__, "user_info", user_info)

    @_builtins.property
    @pulumi.getter(name="deviceInfo")
    def device_info(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo']:
        """
        Device info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "device_info")

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo']:
        """
        Group info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_info")

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @_builtins.property
    @pulumi.getter(name="userInfo")
    def user_info(self) -> Optional['outputs.SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo']:
        """
        User info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "user_info")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersDeviceInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated device info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated group info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayApplicationUpstreamProxyProtocolContextualHeadersUserInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated user info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayHub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internetGateway":
            suggest = "internet_gateway"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayHub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayHub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayHub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: _builtins.str,
                 internet_gateway: Optional['outputs.SecurityGatewayHubInternetGateway'] = None):
        """
        :param _builtins.str region: The identifier for this object. Format specified above.
        :param 'SecurityGatewayHubInternetGatewayArgs' internet_gateway: Internet Gateway configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "region", region)
        if internet_gateway is not None:
            pulumi.set(__self__, "internet_gateway", internet_gateway)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="internetGateway")
    def internet_gateway(self) -> Optional['outputs.SecurityGatewayHubInternetGateway']:
        """
        Internet Gateway configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "internet_gateway")


@pulumi.output_type
class SecurityGatewayHubInternetGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedIps":
            suggest = "assigned_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayHubInternetGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayHubInternetGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayHubInternetGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] assigned_ips: (Output)
               Output only. List of IP addresses assigned to the Cloud NAT.
        """
        if assigned_ips is not None:
            pulumi.set(__self__, "assigned_ips", assigned_ips)

    @_builtins.property
    @pulumi.getter(name="assignedIps")
    def assigned_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
        return pulumi.get(self, "assigned_ips")


@pulumi.output_type
class SecurityGatewayIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecurityGatewayIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class SecurityGatewayProxyProtocolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedClientHeaders":
            suggest = "allowed_client_headers"
        elif key == "clientIp":
            suggest = "client_ip"
        elif key == "contextualHeaders":
            suggest = "contextual_headers"
        elif key == "gatewayIdentity":
            suggest = "gateway_identity"
        elif key == "metadataHeaders":
            suggest = "metadata_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayProxyProtocolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayProxyProtocolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayProxyProtocolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_client_headers: Optional[Sequence[_builtins.str]] = None,
                 client_ip: Optional[_builtins.bool] = None,
                 contextual_headers: Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeaders'] = None,
                 gateway_identity: Optional[_builtins.str] = None,
                 metadata_headers: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence[_builtins.str] allowed_client_headers: The configuration for the proxy.
        :param _builtins.bool client_ip: Client IP configuration. The client IP address is included if true.
        :param 'SecurityGatewayProxyProtocolConfigContextualHeadersArgs' contextual_headers: Configuration for the contextual headers.
               Structure is documented below.
        :param _builtins.str gateway_identity: Gateway identity configuration.
               Possible values are: `RESOURCE_NAME`.
        :param Mapping[str, _builtins.str] metadata_headers: Custom resource specific headers along with the values.
               The names should conform to RFC 9110:
               > Field names SHOULD constrain themselves to alphanumeric characters, "-",
               and ".", and SHOULD begin with a letter.
               > Field values SHOULD contain only ASCII printable characters and tab.
        """
        if allowed_client_headers is not None:
            pulumi.set(__self__, "allowed_client_headers", allowed_client_headers)
        if client_ip is not None:
            pulumi.set(__self__, "client_ip", client_ip)
        if contextual_headers is not None:
            pulumi.set(__self__, "contextual_headers", contextual_headers)
        if gateway_identity is not None:
            pulumi.set(__self__, "gateway_identity", gateway_identity)
        if metadata_headers is not None:
            pulumi.set(__self__, "metadata_headers", metadata_headers)

    @_builtins.property
    @pulumi.getter(name="allowedClientHeaders")
    def allowed_client_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The configuration for the proxy.
        """
        return pulumi.get(self, "allowed_client_headers")

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> Optional[_builtins.bool]:
        """
        Client IP configuration. The client IP address is included if true.
        """
        return pulumi.get(self, "client_ip")

    @_builtins.property
    @pulumi.getter(name="contextualHeaders")
    def contextual_headers(self) -> Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeaders']:
        """
        Configuration for the contextual headers.
        Structure is documented below.
        """
        return pulumi.get(self, "contextual_headers")

    @_builtins.property
    @pulumi.getter(name="gatewayIdentity")
    def gateway_identity(self) -> Optional[_builtins.str]:
        """
        Gateway identity configuration.
        Possible values are: `RESOURCE_NAME`.
        """
        return pulumi.get(self, "gateway_identity")

    @_builtins.property
    @pulumi.getter(name="metadataHeaders")
    def metadata_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
        and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
        return pulumi.get(self, "metadata_headers")


@pulumi.output_type
class SecurityGatewayProxyProtocolConfigContextualHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceInfo":
            suggest = "device_info"
        elif key == "groupInfo":
            suggest = "group_info"
        elif key == "outputType":
            suggest = "output_type"
        elif key == "userInfo":
            suggest = "user_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayProxyProtocolConfigContextualHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_info: Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo'] = None,
                 group_info: Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo'] = None,
                 output_type: Optional[_builtins.str] = None,
                 user_info: Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo'] = None):
        """
        :param 'SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfoArgs' device_info: Device info configuration.
               Structure is documented below.
        :param 'SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfoArgs' group_info: Group info configuration.
               Structure is documented below.
        :param _builtins.str output_type: Default output type for all enabled headers.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        :param 'SecurityGatewayProxyProtocolConfigContextualHeadersUserInfoArgs' user_info: User info configuration.
               Structure is documented below.
        """
        if device_info is not None:
            pulumi.set(__self__, "device_info", device_info)
        if group_info is not None:
            pulumi.set(__self__, "group_info", group_info)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if user_info is not None:
            pulumi.set(__self__, "user_info", user_info)

    @_builtins.property
    @pulumi.getter(name="deviceInfo")
    def device_info(self) -> Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo']:
        """
        Device info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "device_info")

    @_builtins.property
    @pulumi.getter(name="groupInfo")
    def group_info(self) -> Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo']:
        """
        Group info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "group_info")

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        Default output type for all enabled headers.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")

    @_builtins.property
    @pulumi.getter(name="userInfo")
    def user_info(self) -> Optional['outputs.SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo']:
        """
        User info configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "user_info")


@pulumi.output_type
class SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersDeviceInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated device info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated device info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated group info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated group info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayProxyProtocolConfigContextualHeadersUserInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str output_type: The output type of the delegated user info.
               Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[_builtins.str]:
        """
        The output type of the delegated user info.
        Possible values are: `PROTOBUF`, `JSON`, `NONE`.
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class SecurityGatewayServiceDiscovery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGateway":
            suggest = "api_gateway"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayServiceDiscovery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayServiceDiscovery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayServiceDiscovery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_gateway: Optional['outputs.SecurityGatewayServiceDiscoveryApiGateway'] = None):
        """
        :param 'SecurityGatewayServiceDiscoveryApiGatewayArgs' api_gateway: External API configuration.
               Structure is documented below.
        """
        if api_gateway is not None:
            pulumi.set(__self__, "api_gateway", api_gateway)

    @_builtins.property
    @pulumi.getter(name="apiGateway")
    def api_gateway(self) -> Optional['outputs.SecurityGatewayServiceDiscoveryApiGateway']:
        """
        External API configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "api_gateway")


@pulumi.output_type
class SecurityGatewayServiceDiscoveryApiGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceOverride":
            suggest = "resource_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGatewayServiceDiscoveryApiGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGatewayServiceDiscoveryApiGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGatewayServiceDiscoveryApiGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_override: Optional['outputs.SecurityGatewayServiceDiscoveryApiGatewayResourceOverride'] = None):
        """
        :param 'SecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs' resource_override: Enables fetching resource model updates to alter service behavior per Chrome profile.
               Structure is documented below.
        """
        if resource_override is not None:
            pulumi.set(__self__, "resource_override", resource_override)

    @_builtins.property
    @pulumi.getter(name="resourceOverride")
    def resource_override(self) -> Optional['outputs.SecurityGatewayServiceDiscoveryApiGatewayResourceOverride']:
        """
        Enables fetching resource model updates to alter service behavior per Chrome profile.
        Structure is documented below.
        """
        return pulumi.get(self, "resource_override")


@pulumi.output_type
class SecurityGatewayServiceDiscoveryApiGatewayResourceOverride(dict):
    def __init__(__self__, *,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: Contains uri path fragment where HTTP request is sent.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Contains uri path fragment where HTTP request is sent.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAppConnectionApplicationEndpointResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str host: Hostname or IP address of the remote application endpoint.
        :param _builtins.int port: Port of the remote application endpoint.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port of the remote application endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetAppConnectionGatewayResult(dict):
    def __init__(__self__, *,
                 app_gateway: _builtins.str,
                 ingress_port: _builtins.int,
                 type: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.str app_gateway: AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        :param _builtins.int ingress_port: Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        :param _builtins.str type: The type of hosting used by the gateway. Refer to
               https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
               for a list of possible values.
        :param _builtins.str uri: Server-defined URI for this resource.
        """
        pulumi.set(__self__, "app_gateway", app_gateway)
        pulumi.set(__self__, "ingress_port", ingress_port)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="appGateway")
    def app_gateway(self) -> _builtins.str:
        """
        AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
        """
        return pulumi.get(self, "app_gateway")

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> _builtins.int:
        """
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "ingress_port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of hosting used by the gateway. Refer to
        https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
        for a list of possible values.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetAppConnectorPrincipalInfoResult(dict):
    def __init__(__self__, *,
                 service_accounts: Sequence['outputs.GetAppConnectorPrincipalInfoServiceAccountResult']):
        """
        :param Sequence['GetAppConnectorPrincipalInfoServiceAccountArgs'] service_accounts: ServiceAccount represents a GCP service account.
        """
        pulumi.set(__self__, "service_accounts", service_accounts)

    @_builtins.property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Sequence['outputs.GetAppConnectorPrincipalInfoServiceAccountResult']:
        """
        ServiceAccount represents a GCP service account.
        """
        return pulumi.get(self, "service_accounts")


@pulumi.output_type
class GetAppConnectorPrincipalInfoServiceAccountResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        """
        :param _builtins.str email: Email address of the service account.
        """
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GetAppGatewayAllocatedConnectionResult(dict):
    def __init__(__self__, *,
                 ingress_port: _builtins.int,
                 psc_uri: _builtins.str):
        """
        :param _builtins.int ingress_port: The ingress port of an allocated connection.
        :param _builtins.str psc_uri: The PSC uri of an allocated connection.
        """
        pulumi.set(__self__, "ingress_port", ingress_port)
        pulumi.set(__self__, "psc_uri", psc_uri)

    @_builtins.property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> _builtins.int:
        """
        The ingress port of an allocated connection.
        """
        return pulumi.get(self, "ingress_port")

    @_builtins.property
    @pulumi.getter(name="pscUri")
    def psc_uri(self) -> _builtins.str:
        """
        The PSC uri of an allocated connection.
        """
        return pulumi.get(self, "psc_uri")


@pulumi.output_type
class GetSecurityGatewayHubResult(dict):
    def __init__(__self__, *,
                 internet_gateways: Sequence['outputs.GetSecurityGatewayHubInternetGatewayResult'],
                 region: _builtins.str):
        """
        :param Sequence['GetSecurityGatewayHubInternetGatewayArgs'] internet_gateways: Internet Gateway configuration.
        """
        pulumi.set(__self__, "internet_gateways", internet_gateways)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="internetGateways")
    def internet_gateways(self) -> Sequence['outputs.GetSecurityGatewayHubInternetGatewayResult']:
        """
        Internet Gateway configuration.
        """
        return pulumi.get(self, "internet_gateways")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetSecurityGatewayHubInternetGatewayResult(dict):
    def __init__(__self__, *,
                 assigned_ips: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] assigned_ips: Output only. List of IP addresses assigned to the Cloud NAT.
        """
        pulumi.set(__self__, "assigned_ips", assigned_ips)

    @_builtins.property
    @pulumi.getter(name="assignedIps")
    def assigned_ips(self) -> Sequence[_builtins.str]:
        """
        Output only. List of IP addresses assigned to the Cloud NAT.
        """
        return pulumi.get(self, "assigned_ips")


@pulumi.output_type
class GetSecurityGatewayProxyProtocolConfigResult(dict):
    def __init__(__self__, *,
                 allowed_client_headers: Sequence[_builtins.str],
                 client_ip: _builtins.bool,
                 contextual_headers: Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderResult'],
                 gateway_identity: _builtins.str,
                 metadata_headers: Mapping[str, _builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_client_headers: The configuration for the proxy.
        :param _builtins.bool client_ip: Client IP configuration. The client IP address is included if true.
        :param Sequence['GetSecurityGatewayProxyProtocolConfigContextualHeaderArgs'] contextual_headers: Configuration for the contextual headers.
        :param _builtins.str gateway_identity: Gateway identity configuration. Possible values: ["RESOURCE_NAME"]
        :param Mapping[str, _builtins.str] metadata_headers: Custom resource specific headers along with the values.
               The names should conform to RFC 9110:
               > Field names SHOULD constrain themselves to alphanumeric characters, "-",
                 and ".", and SHOULD begin with a letter.
               > Field values SHOULD contain only ASCII printable characters and tab.
        """
        pulumi.set(__self__, "allowed_client_headers", allowed_client_headers)
        pulumi.set(__self__, "client_ip", client_ip)
        pulumi.set(__self__, "contextual_headers", contextual_headers)
        pulumi.set(__self__, "gateway_identity", gateway_identity)
        pulumi.set(__self__, "metadata_headers", metadata_headers)

    @_builtins.property
    @pulumi.getter(name="allowedClientHeaders")
    def allowed_client_headers(self) -> Sequence[_builtins.str]:
        """
        The configuration for the proxy.
        """
        return pulumi.get(self, "allowed_client_headers")

    @_builtins.property
    @pulumi.getter(name="clientIp")
    def client_ip(self) -> _builtins.bool:
        """
        Client IP configuration. The client IP address is included if true.
        """
        return pulumi.get(self, "client_ip")

    @_builtins.property
    @pulumi.getter(name="contextualHeaders")
    def contextual_headers(self) -> Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderResult']:
        """
        Configuration for the contextual headers.
        """
        return pulumi.get(self, "contextual_headers")

    @_builtins.property
    @pulumi.getter(name="gatewayIdentity")
    def gateway_identity(self) -> _builtins.str:
        """
        Gateway identity configuration. Possible values: ["RESOURCE_NAME"]
        """
        return pulumi.get(self, "gateway_identity")

    @_builtins.property
    @pulumi.getter(name="metadataHeaders")
    def metadata_headers(self) -> Mapping[str, _builtins.str]:
        """
        Custom resource specific headers along with the values.
        The names should conform to RFC 9110:
        > Field names SHOULD constrain themselves to alphanumeric characters, "-",
          and ".", and SHOULD begin with a letter.
        > Field values SHOULD contain only ASCII printable characters and tab.
        """
        return pulumi.get(self, "metadata_headers")


@pulumi.output_type
class GetSecurityGatewayProxyProtocolConfigContextualHeaderResult(dict):
    def __init__(__self__, *,
                 device_infos: Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderDeviceInfoResult'],
                 group_infos: Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderGroupInfoResult'],
                 output_type: _builtins.str,
                 user_infos: Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderUserInfoResult']):
        """
        :param Sequence['GetSecurityGatewayProxyProtocolConfigContextualHeaderDeviceInfoArgs'] device_infos: Device info configuration.
        :param Sequence['GetSecurityGatewayProxyProtocolConfigContextualHeaderGroupInfoArgs'] group_infos: Group info configuration.
        :param _builtins.str output_type: Default output type for all enabled headers. Possible values: ["PROTOBUF", "JSON", "NONE"]
        :param Sequence['GetSecurityGatewayProxyProtocolConfigContextualHeaderUserInfoArgs'] user_infos: User info configuration.
        """
        pulumi.set(__self__, "device_infos", device_infos)
        pulumi.set(__self__, "group_infos", group_infos)
        pulumi.set(__self__, "output_type", output_type)
        pulumi.set(__self__, "user_infos", user_infos)

    @_builtins.property
    @pulumi.getter(name="deviceInfos")
    def device_infos(self) -> Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderDeviceInfoResult']:
        """
        Device info configuration.
        """
        return pulumi.get(self, "device_infos")

    @_builtins.property
    @pulumi.getter(name="groupInfos")
    def group_infos(self) -> Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderGroupInfoResult']:
        """
        Group info configuration.
        """
        return pulumi.get(self, "group_infos")

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> _builtins.str:
        """
        Default output type for all enabled headers. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        return pulumi.get(self, "output_type")

    @_builtins.property
    @pulumi.getter(name="userInfos")
    def user_infos(self) -> Sequence['outputs.GetSecurityGatewayProxyProtocolConfigContextualHeaderUserInfoResult']:
        """
        User info configuration.
        """
        return pulumi.get(self, "user_infos")


@pulumi.output_type
class GetSecurityGatewayProxyProtocolConfigContextualHeaderDeviceInfoResult(dict):
    def __init__(__self__, *,
                 output_type: _builtins.str):
        """
        :param _builtins.str output_type: The output type of the delegated device info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> _builtins.str:
        """
        The output type of the delegated device info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class GetSecurityGatewayProxyProtocolConfigContextualHeaderGroupInfoResult(dict):
    def __init__(__self__, *,
                 output_type: _builtins.str):
        """
        :param _builtins.str output_type: The output type of the delegated group info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> _builtins.str:
        """
        The output type of the delegated group info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class GetSecurityGatewayProxyProtocolConfigContextualHeaderUserInfoResult(dict):
    def __init__(__self__, *,
                 output_type: _builtins.str):
        """
        :param _builtins.str output_type: The output type of the delegated user info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        pulumi.set(__self__, "output_type", output_type)

    @_builtins.property
    @pulumi.getter(name="outputType")
    def output_type(self) -> _builtins.str:
        """
        The output type of the delegated user info. Possible values: ["PROTOBUF", "JSON", "NONE"]
        """
        return pulumi.get(self, "output_type")


@pulumi.output_type
class GetSecurityGatewayServiceDiscoveryResult(dict):
    def __init__(__self__, *,
                 api_gateways: Sequence['outputs.GetSecurityGatewayServiceDiscoveryApiGatewayResult']):
        """
        :param Sequence['GetSecurityGatewayServiceDiscoveryApiGatewayArgs'] api_gateways: External API configuration.
        """
        pulumi.set(__self__, "api_gateways", api_gateways)

    @_builtins.property
    @pulumi.getter(name="apiGateways")
    def api_gateways(self) -> Sequence['outputs.GetSecurityGatewayServiceDiscoveryApiGatewayResult']:
        """
        External API configuration.
        """
        return pulumi.get(self, "api_gateways")


@pulumi.output_type
class GetSecurityGatewayServiceDiscoveryApiGatewayResult(dict):
    def __init__(__self__, *,
                 resource_overrides: Sequence['outputs.GetSecurityGatewayServiceDiscoveryApiGatewayResourceOverrideResult']):
        """
        :param Sequence['GetSecurityGatewayServiceDiscoveryApiGatewayResourceOverrideArgs'] resource_overrides: Enables fetching resource model updates to alter service behavior per Chrome profile.
        """
        pulumi.set(__self__, "resource_overrides", resource_overrides)

    @_builtins.property
    @pulumi.getter(name="resourceOverrides")
    def resource_overrides(self) -> Sequence['outputs.GetSecurityGatewayServiceDiscoveryApiGatewayResourceOverrideResult']:
        """
        Enables fetching resource model updates to alter service behavior per Chrome profile.
        """
        return pulumi.get(self, "resource_overrides")


@pulumi.output_type
class GetSecurityGatewayServiceDiscoveryApiGatewayResourceOverrideResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Contains uri path fragment where HTTP request is sent.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Contains uri path fragment where HTTP request is sent.
        """
        return pulumi.get(self, "path")


