# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['Datapolicyv2DataPolicyArgs', 'Datapolicyv2DataPolicy']

@pulumi.input_type
class Datapolicyv2DataPolicyArgs:
    def __init__(__self__, *,
                 data_policy_id: pulumi.Input[_builtins.str],
                 data_policy_type: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 data_masking_policy: Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Datapolicyv2DataPolicy resource.
        :param pulumi.Input[_builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be
               unique within a project. Used as {data_policy_id} in part of the resource
               name.
        :param pulumi.Input[_builtins.str] data_policy_type: Type of data policy.
               Possible values:
               DATA_MASKING_POLICY
               RAW_DATA_ACCESS_POLICY
               COLUMN_LEVEL_SECURITY_POLICY
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs'] data_masking_policy: The policy used to specify data masking rule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] etag: The etag for this Data Policy.
               This field is used for UpdateDataPolicy calls. If Data Policy exists, this
               field is required and must match the server's etag. It will also be
               populated in the response of GetDataPolicy, CreateDataPolicy, and
               UpdateDataPolicy calls.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grantees: The list of IAM principals that have Fine Grained Access to the underlying
               data goverened by this data policy.
               Uses the [IAM V2 principal
               syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
               supports principal types users, groups, serviceaccounts, cloudidentity.
               This field is supported in V2 Data Policy only. In case of V1 data policies
               (i.e. verion = 1 and policy_tag is set), this field is not populated.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_policy_id", data_policy_id)
        pulumi.set(__self__, "data_policy_type", data_policy_type)
        pulumi.set(__self__, "location", location)
        if data_masking_policy is not None:
            pulumi.set(__self__, "data_masking_policy", data_masking_policy)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if grantees is not None:
            pulumi.set(__self__, "grantees", grantees)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        User-assigned (human readable) ID of the data policy that needs to be
        unique within a project. Used as {data_policy_id} in part of the resource
        name.
        """
        return pulumi.get(self, "data_policy_id")

    @data_policy_id.setter
    def data_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of data policy.
        Possible values:
        DATA_MASKING_POLICY
        RAW_DATA_ACCESS_POLICY
        COLUMN_LEVEL_SECURITY_POLICY
        """
        return pulumi.get(self, "data_policy_type")

    @data_policy_type.setter
    def data_policy_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']]:
        """
        The policy used to specify data masking rule.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @data_masking_policy.setter
    def data_masking_policy(self, value: Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']]):
        pulumi.set(self, "data_masking_policy", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The etag for this Data Policy.
        This field is used for UpdateDataPolicy calls. If Data Policy exists, this
        field is required and must match the server's etag. It will also be
        populated in the response of GetDataPolicy, CreateDataPolicy, and
        UpdateDataPolicy calls.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def grantees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IAM principals that have Fine Grained Access to the underlying
        data goverened by this data policy.
        Uses the [IAM V2 principal
        syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
        supports principal types users, groups, serviceaccounts, cloudidentity.
        This field is supported in V2 Data Policy only. In case of V1 data policies
        (i.e. verion = 1 and policy_tag is set), this field is not populated.
        """
        return pulumi.get(self, "grantees")

    @grantees.setter
    def grantees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grantees", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _Datapolicyv2DataPolicyState:
    def __init__(__self__, *,
                 data_masking_policy: Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']] = None,
                 data_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Datapolicyv2DataPolicy resources.
        :param pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs'] data_masking_policy: The policy used to specify data masking rule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be
               unique within a project. Used as {data_policy_id} in part of the resource
               name.
        :param pulumi.Input[_builtins.str] data_policy_type: Type of data policy.
               Possible values:
               DATA_MASKING_POLICY
               RAW_DATA_ACCESS_POLICY
               COLUMN_LEVEL_SECURITY_POLICY
        :param pulumi.Input[_builtins.str] etag: The etag for this Data Policy.
               This field is used for UpdateDataPolicy calls. If Data Policy exists, this
               field is required and must match the server's etag. It will also be
               populated in the response of GetDataPolicy, CreateDataPolicy, and
               UpdateDataPolicy calls.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grantees: The list of IAM principals that have Fine Grained Access to the underlying
               data goverened by this data policy.
               Uses the [IAM V2 principal
               syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
               supports principal types users, groups, serviceaccounts, cloudidentity.
               This field is supported in V2 Data Policy only. In case of V1 data policies
               (i.e. verion = 1 and policy_tag is set), this field is not populated.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of this data policy, in the format of
               `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
        :param pulumi.Input[_builtins.str] policy_tag: Policy tag resource name, in the format of
               `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
               policy_tag is supported only for V1 data policies.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] version: The version of the Data Policy resource.
               Possible values:
               V1
               V2
        """
        if data_masking_policy is not None:
            pulumi.set(__self__, "data_masking_policy", data_masking_policy)
        if data_policy_id is not None:
            pulumi.set(__self__, "data_policy_id", data_policy_id)
        if data_policy_type is not None:
            pulumi.set(__self__, "data_policy_type", data_policy_type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if grantees is not None:
            pulumi.set(__self__, "grantees", grantees)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_tag is not None:
            pulumi.set(__self__, "policy_tag", policy_tag)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']]:
        """
        The policy used to specify data masking rule.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @data_masking_policy.setter
    def data_masking_policy(self, value: Optional[pulumi.Input['Datapolicyv2DataPolicyDataMaskingPolicyArgs']]):
        pulumi.set(self, "data_masking_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-assigned (human readable) ID of the data policy that needs to be
        unique within a project. Used as {data_policy_id} in part of the resource
        name.
        """
        return pulumi.get(self, "data_policy_id")

    @data_policy_id.setter
    def data_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of data policy.
        Possible values:
        DATA_MASKING_POLICY
        RAW_DATA_ACCESS_POLICY
        COLUMN_LEVEL_SECURITY_POLICY
        """
        return pulumi.get(self, "data_policy_type")

    @data_policy_type.setter
    def data_policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_policy_type", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The etag for this Data Policy.
        This field is used for UpdateDataPolicy calls. If Data Policy exists, this
        field is required and must match the server's etag. It will also be
        populated in the response of GetDataPolicy, CreateDataPolicy, and
        UpdateDataPolicy calls.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def grantees(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of IAM principals that have Fine Grained Access to the underlying
        data goverened by this data policy.
        Uses the [IAM V2 principal
        syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
        supports principal types users, groups, serviceaccounts, cloudidentity.
        This field is supported in V2 Data Policy only. In case of V1 data policies
        (i.e. verion = 1 and policy_tag is set), this field is not populated.
        """
        return pulumi.get(self, "grantees")

    @grantees.setter
    def grantees(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grantees", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Resource name of this data policy, in the format of
        `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy tag resource name, in the format of
        `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
        policy_tag is supported only for V1 data policies.
        """
        return pulumi.get(self, "policy_tag")

    @policy_tag.setter
    def policy_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_tag", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the Data Policy resource.
        Possible values:
        V1
        V2
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy")
class Datapolicyv2DataPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_masking_policy: Optional[pulumi.Input[Union['Datapolicyv2DataPolicyDataMaskingPolicyArgs', 'Datapolicyv2DataPolicyDataMaskingPolicyArgsDict']]] = None,
                 data_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        BigQuery Data Policy

        To get more information about DataPolicy, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigquerydatapolicy/rest/v2/projects.locations.dataPolicies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/column-data-masking-intro)

        ## Example Usage

        ### Bigquery Datapolicyv2 Datapolicy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("basic_data_policy",
            location="us-central1",
            data_policy_type="RAW_DATA_ACCESS_POLICY",
            data_policy_id="basic_data_policy")
        ```
        ### Bigquery Datapolicyv2 Datapolicy Predefined Masking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        predefined_masking_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("predefined_masking_data_policy",
            location="us-central1",
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "predefined_expression": "SHA256",
            },
            data_policy_id="predefined_masking_data_policy")
        ```
        ### Bigquery Datapolicyv2 Datapolicy Routine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test",
            dataset_id="dataset_id",
            location="us-central1")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }])
        routine_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("routine_data_policy",
            location="us-central1",
            data_policy_id="routine_data_policy",
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "routine": custom_masking_routine.id,
            })
        ```
        ### Bigquery Datapolicyv2 Datapolicy Withgrantees

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_policy_with_grantees = gcp.bigquery.Datapolicyv2DataPolicy("data_policy_with_grantees",
            location="us-central1",
            data_policy_type="RAW_DATA_ACCESS_POLICY",
            grantees=["principal://goog/subject/jane@example.com"],
            data_policy_id="data_policy_with_grantees")
        ```

        ## Import

        DataPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}`

        * `{{project}}/{{location}}/{{data_policy_id}}`

        * `{{location}}/{{data_policy_id}}`

        When using the `pulumi import` command, DataPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default {{project}}/{{location}}/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default {{location}}/{{data_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['Datapolicyv2DataPolicyDataMaskingPolicyArgs', 'Datapolicyv2DataPolicyDataMaskingPolicyArgsDict']] data_masking_policy: The policy used to specify data masking rule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be
               unique within a project. Used as {data_policy_id} in part of the resource
               name.
        :param pulumi.Input[_builtins.str] data_policy_type: Type of data policy.
               Possible values:
               DATA_MASKING_POLICY
               RAW_DATA_ACCESS_POLICY
               COLUMN_LEVEL_SECURITY_POLICY
        :param pulumi.Input[_builtins.str] etag: The etag for this Data Policy.
               This field is used for UpdateDataPolicy calls. If Data Policy exists, this
               field is required and must match the server's etag. It will also be
               populated in the response of GetDataPolicy, CreateDataPolicy, and
               UpdateDataPolicy calls.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grantees: The list of IAM principals that have Fine Grained Access to the underlying
               data goverened by this data policy.
               Uses the [IAM V2 principal
               syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
               supports principal types users, groups, serviceaccounts, cloudidentity.
               This field is supported in V2 Data Policy only. In case of V1 data policies
               (i.e. verion = 1 and policy_tag is set), this field is not populated.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Datapolicyv2DataPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BigQuery Data Policy

        To get more information about DataPolicy, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/bigquerydatapolicy/rest/v2/projects.locations.dataPolicies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/column-data-masking-intro)

        ## Example Usage

        ### Bigquery Datapolicyv2 Datapolicy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("basic_data_policy",
            location="us-central1",
            data_policy_type="RAW_DATA_ACCESS_POLICY",
            data_policy_id="basic_data_policy")
        ```
        ### Bigquery Datapolicyv2 Datapolicy Predefined Masking

        ```python
        import pulumi
        import pulumi_gcp as gcp

        predefined_masking_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("predefined_masking_data_policy",
            location="us-central1",
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "predefined_expression": "SHA256",
            },
            data_policy_id="predefined_masking_data_policy")
        ```
        ### Bigquery Datapolicyv2 Datapolicy Routine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test",
            dataset_id="dataset_id",
            location="us-central1")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }])
        routine_data_policy = gcp.bigquery.Datapolicyv2DataPolicy("routine_data_policy",
            location="us-central1",
            data_policy_id="routine_data_policy",
            data_policy_type="DATA_MASKING_POLICY",
            data_masking_policy={
                "routine": custom_masking_routine.id,
            })
        ```
        ### Bigquery Datapolicyv2 Datapolicy Withgrantees

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_policy_with_grantees = gcp.bigquery.Datapolicyv2DataPolicy("data_policy_with_grantees",
            location="us-central1",
            data_policy_type="RAW_DATA_ACCESS_POLICY",
            grantees=["principal://goog/subject/jane@example.com"],
            data_policy_id="data_policy_with_grantees")
        ```

        ## Import

        DataPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}`

        * `{{project}}/{{location}}/{{data_policy_id}}`

        * `{{location}}/{{data_policy_id}}`

        When using the `pulumi import` command, DataPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default projects/{{project}}/locations/{{location}}/dataPolicies/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default {{project}}/{{location}}/{{data_policy_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy default {{location}}/{{data_policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param Datapolicyv2DataPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Datapolicyv2DataPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_masking_policy: Optional[pulumi.Input[Union['Datapolicyv2DataPolicyDataMaskingPolicyArgs', 'Datapolicyv2DataPolicyDataMaskingPolicyArgsDict']]] = None,
                 data_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 grantees: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Datapolicyv2DataPolicyArgs.__new__(Datapolicyv2DataPolicyArgs)

            __props__.__dict__["data_masking_policy"] = data_masking_policy
            if data_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_policy_id'")
            __props__.__dict__["data_policy_id"] = data_policy_id
            if data_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_policy_type'")
            __props__.__dict__["data_policy_type"] = data_policy_type
            __props__.__dict__["etag"] = etag
            __props__.__dict__["grantees"] = grantees
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["name"] = None
            __props__.__dict__["policy_tag"] = None
            __props__.__dict__["version"] = None
        super(Datapolicyv2DataPolicy, __self__).__init__(
            'gcp:bigquery/datapolicyv2DataPolicy:Datapolicyv2DataPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_masking_policy: Optional[pulumi.Input[Union['Datapolicyv2DataPolicyDataMaskingPolicyArgs', 'Datapolicyv2DataPolicyDataMaskingPolicyArgsDict']]] = None,
            data_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            grantees: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_tag: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Datapolicyv2DataPolicy':
        """
        Get an existing Datapolicyv2DataPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['Datapolicyv2DataPolicyDataMaskingPolicyArgs', 'Datapolicyv2DataPolicyDataMaskingPolicyArgsDict']] data_masking_policy: The policy used to specify data masking rule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_policy_id: User-assigned (human readable) ID of the data policy that needs to be
               unique within a project. Used as {data_policy_id} in part of the resource
               name.
        :param pulumi.Input[_builtins.str] data_policy_type: Type of data policy.
               Possible values:
               DATA_MASKING_POLICY
               RAW_DATA_ACCESS_POLICY
               COLUMN_LEVEL_SECURITY_POLICY
        :param pulumi.Input[_builtins.str] etag: The etag for this Data Policy.
               This field is used for UpdateDataPolicy calls. If Data Policy exists, this
               field is required and must match the server's etag. It will also be
               populated in the response of GetDataPolicy, CreateDataPolicy, and
               UpdateDataPolicy calls.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grantees: The list of IAM principals that have Fine Grained Access to the underlying
               data goverened by this data policy.
               Uses the [IAM V2 principal
               syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
               supports principal types users, groups, serviceaccounts, cloudidentity.
               This field is supported in V2 Data Policy only. In case of V1 data policies
               (i.e. verion = 1 and policy_tag is set), this field is not populated.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. Resource name of this data policy, in the format of
               `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
        :param pulumi.Input[_builtins.str] policy_tag: Policy tag resource name, in the format of
               `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
               policy_tag is supported only for V1 data policies.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] version: The version of the Data Policy resource.
               Possible values:
               V1
               V2
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Datapolicyv2DataPolicyState.__new__(_Datapolicyv2DataPolicyState)

        __props__.__dict__["data_masking_policy"] = data_masking_policy
        __props__.__dict__["data_policy_id"] = data_policy_id
        __props__.__dict__["data_policy_type"] = data_policy_type
        __props__.__dict__["etag"] = etag
        __props__.__dict__["grantees"] = grantees
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_tag"] = policy_tag
        __props__.__dict__["project"] = project
        __props__.__dict__["version"] = version
        return Datapolicyv2DataPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataMaskingPolicy")
    def data_masking_policy(self) -> pulumi.Output[Optional['outputs.Datapolicyv2DataPolicyDataMaskingPolicy']]:
        """
        The policy used to specify data masking rule.
        Structure is documented below.
        """
        return pulumi.get(self, "data_masking_policy")

    @_builtins.property
    @pulumi.getter(name="dataPolicyId")
    def data_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        User-assigned (human readable) ID of the data policy that needs to be
        unique within a project. Used as {data_policy_id} in part of the resource
        name.
        """
        return pulumi.get(self, "data_policy_id")

    @_builtins.property
    @pulumi.getter(name="dataPolicyType")
    def data_policy_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of data policy.
        Possible values:
        DATA_MASKING_POLICY
        RAW_DATA_ACCESS_POLICY
        COLUMN_LEVEL_SECURITY_POLICY
        """
        return pulumi.get(self, "data_policy_type")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        The etag for this Data Policy.
        This field is used for UpdateDataPolicy calls. If Data Policy exists, this
        field is required and must match the server's etag. It will also be
        populated in the response of GetDataPolicy, CreateDataPolicy, and
        UpdateDataPolicy calls.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def grantees(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of IAM principals that have Fine Grained Access to the underlying
        data goverened by this data policy.
        Uses the [IAM V2 principal
        syntax](https://cloud.google.com/iam/docs/principal-identifiers#v2) Only
        supports principal types users, groups, serviceaccounts, cloudidentity.
        This field is supported in V2 Data Policy only. In case of V1 data policies
        (i.e. verion = 1 and policy_tag is set), this field is not populated.
        """
        return pulumi.get(self, "grantees")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Resource name of this data policy, in the format of
        `projects/{project_number}/locations/{location_id}/dataPolicies/{data_policy_id}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyTag")
    def policy_tag(self) -> pulumi.Output[_builtins.str]:
        """
        Policy tag resource name, in the format of
        `projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{policyTag_id}`.
        policy_tag is supported only for V1 data policies.
        """
        return pulumi.get(self, "policy_tag")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the Data Policy resource.
        Possible values:
        V1
        V2
        """
        return pulumi.get(self, "version")

