# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatasetIamPolicyResult',
    'AwaitableGetDatasetIamPolicyResult',
    'get_dataset_iam_policy',
    'get_dataset_iam_policy_output',
]

@pulumi.output_type
class GetDatasetIamPolicyResult:
    """
    A collection of values returned by getDatasetIamPolicy.
    """
    def __init__(__self__, dataset_id=None, etag=None, id=None, policy_data=None, project=None):
        if dataset_id and not isinstance(dataset_id, str):
            raise TypeError("Expected argument 'dataset_id' to be a str")
        pulumi.set(__self__, "dataset_id", dataset_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> _builtins.str:
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetDatasetIamPolicyResult(GetDatasetIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetIamPolicyResult(
            dataset_id=self.dataset_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project)


def get_dataset_iam_policy(dataset_id: Optional[_builtins.str] = None,
                           project: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetIamPolicyResult:
    """
    Retrieves the current IAM policy data for a BigQuery dataset.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigquery.get_dataset_iam_policy(dataset_id=dataset["datasetId"])
    ```


    :param _builtins.str dataset_id: The dataset ID.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigquery/getDatasetIamPolicy:getDatasetIamPolicy', __args__, opts=opts, typ=GetDatasetIamPolicyResult).value

    return AwaitableGetDatasetIamPolicyResult(
        dataset_id=pulumi.get(__ret__, 'dataset_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_dataset_iam_policy_output(dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatasetIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a BigQuery dataset.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigquery.get_dataset_iam_policy(dataset_id=dataset["datasetId"])
    ```


    :param _builtins.str dataset_id: The dataset ID.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigquery/getDatasetIamPolicy:getDatasetIamPolicy', __args__, opts=opts, typ=GetDatasetIamPolicyResult)
    return __ret__.apply(lambda __response__: GetDatasetIamPolicyResult(
        dataset_id=pulumi.get(__response__, 'dataset_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
