# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoutineArgs', 'Routine']

@pulumi.input_type
class RoutineArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[_builtins.str],
                 definition_body: pulumi.Input[_builtins.str],
                 routine_id: pulumi.Input[_builtins.str],
                 routine_type: pulumi.Input[_builtins.str],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]] = None,
                 data_governance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 determinism_level: Optional[pulumi.Input[_builtins.str]] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_function_options: Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']] = None,
                 return_table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_options: Optional[pulumi.Input['RoutineSparkOptionsArgs']] = None):
        """
        The set of arguments for constructing a Routine resource.
        :param pulumi.Input[_builtins.str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[_builtins.str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[_builtins.str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[_builtins.str] routine_type: The type of routine.
               Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        :param pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_governance_type: If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
               Possible values are: `DATA_MASKING`.
        :param pulumi.Input[_builtins.str] description: The description of the routine if defined.
        :param pulumi.Input[_builtins.str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[_builtins.str] language: The language of the routine.
               Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RoutineRemoteFunctionOptionsArgs'] remote_function_options: Remote function specific options.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] return_table_type: Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
               If absent, the return table type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the columns in the evaluated table result will
               be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input[_builtins.str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[_builtins.str] security_mode: Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
               Possible values are: `DEFINER`, `INVOKER`.
        :param pulumi.Input['RoutineSparkOptionsArgs'] spark_options: Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "definition_body", definition_body)
        pulumi.set(__self__, "routine_id", routine_id)
        pulumi.set(__self__, "routine_type", routine_type)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if data_governance_type is not None:
            pulumi.set(__self__, "data_governance_type", data_governance_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if determinism_level is not None:
            pulumi.set(__self__, "determinism_level", determinism_level)
        if imported_libraries is not None:
            pulumi.set(__self__, "imported_libraries", imported_libraries)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remote_function_options is not None:
            pulumi.set(__self__, "remote_function_options", remote_function_options)
        if return_table_type is not None:
            pulumi.set(__self__, "return_table_type", return_table_type)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if spark_options is not None:
            pulumi.set(__self__, "spark_options", spark_options)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dataset containing this routine
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> pulumi.Input[_builtins.str]:
        """
        The body of the routine. For functions, this is the expression in the AS clause.
        If language=SQL, it is the substring inside (but excluding) the parentheses.
        """
        return pulumi.get(self, "definition_body")

    @definition_body.setter
    def definition_body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "definition_body", value)

    @_builtins.property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")

    @routine_id.setter
    def routine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routine_id", value)

    @_builtins.property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of routine.
        Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        """
        return pulumi.get(self, "routine_type")

    @routine_type.setter
    def routine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routine_type", value)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]]:
        """
        Input/output argument of a function or a stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter(name="dataGovernanceType")
    def data_governance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
        Possible values are: `DATA_MASKING`.
        """
        return pulumi.get(self, "data_governance_type")

    @data_governance_type.setter
    def data_governance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_governance_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the routine if defined.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The determinism level of the JavaScript UDF if defined.
        Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        """
        return pulumi.get(self, "determinism_level")

    @determinism_level.setter
    def determinism_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "determinism_level", value)

    @_builtins.property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the
        imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @imported_libraries.setter
    def imported_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "imported_libraries", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the routine.
        Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="remoteFunctionOptions")
    def remote_function_options(self) -> Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']]:
        """
        Remote function specific options.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_function_options")

    @remote_function_options.setter
    def remote_function_options(self, value: Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']]):
        pulumi.set(self, "remote_function_options", value)

    @_builtins.property
    @pulumi.getter(name="returnTableType")
    def return_table_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
        If absent, the return table type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the columns in the evaluated table result will
        be cast to match the column types specificed in return table type, at query time.
        """
        return pulumi.get(self, "return_table_type")

    @return_table_type.setter
    def return_table_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_table_type", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
        If absent, the return type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the evaluated result will be cast to
        the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
        string, any changes to the string will create a diff, even if the JSON itself hasn't
        changed. If the API returns a different value for the same schema, e.g. it switche
        d the order of values or replaced STRUCT field type with RECORD field type, we currently
        cannot suppress the recurring diff this causes. As a workaround, we recommend using
        the schema as returned by the API.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
        Possible values are: `DEFINER`, `INVOKER`.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="sparkOptions")
    def spark_options(self) -> Optional[pulumi.Input['RoutineSparkOptionsArgs']]:
        """
        Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_options")

    @spark_options.setter
    def spark_options(self, value: Optional[pulumi.Input['RoutineSparkOptionsArgs']]):
        pulumi.set(self, "spark_options", value)


@pulumi.input_type
class _RoutineState:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.int]] = None,
                 data_governance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 definition_body: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 determinism_level: Optional[pulumi.Input[_builtins.str]] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_function_options: Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']] = None,
                 return_table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_options: Optional[pulumi.Input['RoutineSparkOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering Routine resources.
        :param pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] creation_time: The time when this routine was created, in milliseconds since the
               epoch.
        :param pulumi.Input[_builtins.str] data_governance_type: If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
               Possible values are: `DATA_MASKING`.
        :param pulumi.Input[_builtins.str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[_builtins.str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[_builtins.str] description: The description of the routine if defined.
        :param pulumi.Input[_builtins.str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[_builtins.str] language: The language of the routine.
               Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        :param pulumi.Input[_builtins.int] last_modified_time: The time when this routine was modified, in milliseconds since the
               epoch.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RoutineRemoteFunctionOptionsArgs'] remote_function_options: Remote function specific options.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] return_table_type: Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
               If absent, the return table type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the columns in the evaluated table result will
               be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input[_builtins.str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[_builtins.str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[_builtins.str] routine_type: The type of routine.
               Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        :param pulumi.Input[_builtins.str] security_mode: Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
               Possible values are: `DEFINER`, `INVOKER`.
        :param pulumi.Input['RoutineSparkOptionsArgs'] spark_options: Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
               Structure is documented below.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if data_governance_type is not None:
            pulumi.set(__self__, "data_governance_type", data_governance_type)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if definition_body is not None:
            pulumi.set(__self__, "definition_body", definition_body)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if determinism_level is not None:
            pulumi.set(__self__, "determinism_level", determinism_level)
        if imported_libraries is not None:
            pulumi.set(__self__, "imported_libraries", imported_libraries)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remote_function_options is not None:
            pulumi.set(__self__, "remote_function_options", remote_function_options)
        if return_table_type is not None:
            pulumi.set(__self__, "return_table_type", return_table_type)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if routine_id is not None:
            pulumi.set(__self__, "routine_id", routine_id)
        if routine_type is not None:
            pulumi.set(__self__, "routine_type", routine_type)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if spark_options is not None:
            pulumi.set(__self__, "spark_options", spark_options)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]]:
        """
        Input/output argument of a function or a stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoutineArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this routine was created, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="dataGovernanceType")
    def data_governance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
        Possible values are: `DATA_MASKING`.
        """
        return pulumi.get(self, "data_governance_type")

    @data_governance_type.setter
    def data_governance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_governance_type", value)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dataset containing this routine
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)

    @_builtins.property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The body of the routine. For functions, this is the expression in the AS clause.
        If language=SQL, it is the substring inside (but excluding) the parentheses.
        """
        return pulumi.get(self, "definition_body")

    @definition_body.setter
    def definition_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "definition_body", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the routine if defined.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The determinism level of the JavaScript UDF if defined.
        Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        """
        return pulumi.get(self, "determinism_level")

    @determinism_level.setter
    def determinism_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "determinism_level", value)

    @_builtins.property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the
        imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @imported_libraries.setter
    def imported_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "imported_libraries", value)

    @_builtins.property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the routine.
        Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "language", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time when this routine was modified, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="remoteFunctionOptions")
    def remote_function_options(self) -> Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']]:
        """
        Remote function specific options.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_function_options")

    @remote_function_options.setter
    def remote_function_options(self, value: Optional[pulumi.Input['RoutineRemoteFunctionOptionsArgs']]):
        pulumi.set(self, "remote_function_options", value)

    @_builtins.property
    @pulumi.getter(name="returnTableType")
    def return_table_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
        If absent, the return table type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the columns in the evaluated table result will
        be cast to match the column types specificed in return table type, at query time.
        """
        return pulumi.get(self, "return_table_type")

    @return_table_type.setter
    def return_table_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_table_type", value)

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
        If absent, the return type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the evaluated result will be cast to
        the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
        string, any changes to the string will create a diff, even if the JSON itself hasn't
        changed. If the API returns a different value for the same schema, e.g. it switche
        d the order of values or replaced STRUCT field type with RECORD field type, we currently
        cannot suppress the recurring diff this causes. As a workaround, we recommend using
        the schema as returned by the API.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "return_type", value)

    @_builtins.property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")

    @routine_id.setter
    def routine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routine_id", value)

    @_builtins.property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of routine.
        Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        """
        return pulumi.get(self, "routine_type")

    @routine_type.setter
    def routine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routine_type", value)

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
        Possible values are: `DEFINER`, `INVOKER`.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_mode", value)

    @_builtins.property
    @pulumi.getter(name="sparkOptions")
    def spark_options(self) -> Optional[pulumi.Input['RoutineSparkOptionsArgs']]:
        """
        Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_options")

    @spark_options.setter
    def spark_options(self, value: Optional[pulumi.Input['RoutineSparkOptionsArgs']]):
        pulumi.set(self, "spark_options", value)


@pulumi.type_token("gcp:bigquery/routine:Routine")
class Routine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutineArgumentArgs', 'RoutineArgumentArgsDict']]]]] = None,
                 data_governance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 definition_body: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 determinism_level: Optional[pulumi.Input[_builtins.str]] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_function_options: Optional[pulumi.Input[Union['RoutineRemoteFunctionOptionsArgs', 'RoutineRemoteFunctionOptionsArgsDict']]] = None,
                 return_table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_options: Optional[pulumi.Input[Union['RoutineSparkOptionsArgs', 'RoutineSparkOptionsArgsDict']]] = None,
                 __props__=None):
        """
        A user-defined function or a stored procedure that belongs to a Dataset

        To get more information about Routine, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)
        * How-to Guides
            * [Routines Intro](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)

        ## Example Usage

        ### Bigquery Routine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="SQL",
            security_mode="INVOKER",
            definition_body="CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);")
        ```
        ### Bigquery Routine Json

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="SCALAR_FUNCTION",
            language="JAVASCRIPT",
            definition_body="CREATE FUNCTION multiplyInputs return x*y;",
            arguments=[
                {
                    "name": "x",
                    "data_type": "{\\"typeKind\\" :  \\"FLOAT64\\"}",
                },
                {
                    "name": "y",
                    "data_type": "{\\"typeKind\\" :  \\"FLOAT64\\"}",
                },
            ],
            return_type="{\\"typeKind\\" :  \\"FLOAT64\\"}")
        ```
        ### Bigquery Routine Tvf

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        ```
        ### Bigquery Routine Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        pyspark = gcp.bigquery.Routine("pyspark",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="PYTHON",
            definition_body=\"\"\"from pyspark.sql import SparkSession

        spark = SparkSession.builder.appName(\\"spark-bigquery-demo\\").getOrCreate()
            
        # Load data from BigQuery.
        words = spark.read.format(\\"bigquery\\") \\\\
          .option(\\"table\\", \\"bigquery-public-data:samples.shakespeare\\") \\\\
          .load()
        words.createOrReplaceTempView(\\"words\\")
            
        # Perform word count.
        word_count = words.select('word', 'word_count').groupBy('word').sum('word_count').withColumnRenamed(\\"sum(word_count)\\", \\"sum_word_count\\")
        word_count.show()
        word_count.printSchema()
            
        # Saving the data to BigQuery
        word_count.write.format(\\"bigquery\\") \\\\
          .option(\\"writeMethod\\", \\"direct\\") \\\\
          .save(\\"wordcount_dataset.wordcount_output\\")
        \"\"\",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
            })
        ```
        ### Bigquery Routine Pyspark Mainfile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        pyspark_mainfile = gcp.bigquery.Routine("pyspark_mainfile",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="PYTHON",
            definition_body="",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
                "main_file_uri": "gs://test-bucket/main.py",
                "py_file_uris": ["gs://test-bucket/lib.py"],
                "file_uris": ["gs://test-bucket/distribute_in_executor.json"],
                "archive_uris": ["gs://test-bucket/distribute_in_executor.tar.gz"],
            })
        ```
        ### Bigquery Routine Spark Jar

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        spark_jar = gcp.bigquery.Routine("spark_jar",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="SCALA",
            definition_body="",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
                "container_image": "gcr.io/my-project-id/my-spark-image:latest",
                "main_class": "com.google.test.jar.MainClass",
                "jar_uris": ["gs://test-bucket/uberjar_spark_spark3.jar"],
                "properties": {
                    "spark.dataproc.scaling.version": "2",
                    "spark.reducer.fetchMigratedShuffle.enabled": "true",
                },
            })
        ```
        ### Bigquery Routine Data Governance Type

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="tf_test_dataset_id_81126")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }],
            return_type="{\\"typeKind\\" :  \\"STRING\\"}")
        ```
        ### Bigquery Routine Remote Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            cloud_resource={})
        remote_function = gcp.bigquery.Routine("remote_function",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="SCALAR_FUNCTION",
            definition_body="",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            remote_function_options={
                "endpoint": "https://us-east1-my_gcf_project.cloudfunctions.net/remote_add",
                "connection": test_connection.name,
                "max_batching_rows": "10",
                "user_defined_context": {
                    "z": "1.5",
                },
            })
        ```

        ## Import

        Routine can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/routines/{{routine_id}}`

        * `{{project}}/{{dataset_id}}/{{routine_id}}`

        * `{{dataset_id}}/{{routine_id}}`

        When using the `pulumi import` command, Routine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default projects/{{project}}/datasets/{{dataset_id}}/routines/{{routine_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default {{project}}/{{dataset_id}}/{{routine_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default {{dataset_id}}/{{routine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutineArgumentArgs', 'RoutineArgumentArgsDict']]]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_governance_type: If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
               Possible values are: `DATA_MASKING`.
        :param pulumi.Input[_builtins.str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[_builtins.str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[_builtins.str] description: The description of the routine if defined.
        :param pulumi.Input[_builtins.str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[_builtins.str] language: The language of the routine.
               Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RoutineRemoteFunctionOptionsArgs', 'RoutineRemoteFunctionOptionsArgsDict']] remote_function_options: Remote function specific options.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] return_table_type: Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
               If absent, the return table type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the columns in the evaluated table result will
               be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input[_builtins.str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[_builtins.str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[_builtins.str] routine_type: The type of routine.
               Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        :param pulumi.Input[_builtins.str] security_mode: Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
               Possible values are: `DEFINER`, `INVOKER`.
        :param pulumi.Input[Union['RoutineSparkOptionsArgs', 'RoutineSparkOptionsArgsDict']] spark_options: Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A user-defined function or a stored procedure that belongs to a Dataset

        To get more information about Routine, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)
        * How-to Guides
            * [Routines Intro](https://cloud.google.com/bigquery/docs/reference/rest/v2/routines)

        ## Example Usage

        ### Bigquery Routine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="SQL",
            security_mode="INVOKER",
            definition_body="CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);")
        ```
        ### Bigquery Routine Json

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="SCALAR_FUNCTION",
            language="JAVASCRIPT",
            definition_body="CREATE FUNCTION multiplyInputs return x*y;",
            arguments=[
                {
                    "name": "x",
                    "data_type": "{\\"typeKind\\" :  \\"FLOAT64\\"}",
                },
                {
                    "name": "y",
                    "data_type": "{\\"typeKind\\" :  \\"FLOAT64\\"}",
                },
            ],
            return_type="{\\"typeKind\\" :  \\"FLOAT64\\"}")
        ```
        ### Bigquery Routine Tvf

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        sproc = gcp.bigquery.Routine("sproc",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        ```
        ### Bigquery Routine Pyspark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        pyspark = gcp.bigquery.Routine("pyspark",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="PYTHON",
            definition_body=\"\"\"from pyspark.sql import SparkSession

        spark = SparkSession.builder.appName(\\"spark-bigquery-demo\\").getOrCreate()
            
        # Load data from BigQuery.
        words = spark.read.format(\\"bigquery\\") \\\\
          .option(\\"table\\", \\"bigquery-public-data:samples.shakespeare\\") \\\\
          .load()
        words.createOrReplaceTempView(\\"words\\")
            
        # Perform word count.
        word_count = words.select('word', 'word_count').groupBy('word').sum('word_count').withColumnRenamed(\\"sum(word_count)\\", \\"sum_word_count\\")
        word_count.show()
        word_count.printSchema()
            
        # Saving the data to BigQuery
        word_count.write.format(\\"bigquery\\") \\\\
          .option(\\"writeMethod\\", \\"direct\\") \\\\
          .save(\\"wordcount_dataset.wordcount_output\\")
        \"\"\",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
            })
        ```
        ### Bigquery Routine Pyspark Mainfile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        pyspark_mainfile = gcp.bigquery.Routine("pyspark_mainfile",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="PYTHON",
            definition_body="",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
                "main_file_uri": "gs://test-bucket/main.py",
                "py_file_uris": ["gs://test-bucket/lib.py"],
                "file_uris": ["gs://test-bucket/distribute_in_executor.json"],
                "archive_uris": ["gs://test-bucket/distribute_in_executor.tar.gz"],
            })
        ```
        ### Bigquery Routine Spark Jar

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            spark={})
        spark_jar = gcp.bigquery.Routine("spark_jar",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="PROCEDURE",
            language="SCALA",
            definition_body="",
            spark_options={
                "connection": test_connection.name,
                "runtime_version": "2.1",
                "container_image": "gcr.io/my-project-id/my-spark-image:latest",
                "main_class": "com.google.test.jar.MainClass",
                "jar_uris": ["gs://test-bucket/uberjar_spark_spark3.jar"],
                "properties": {
                    "spark.dataproc.scaling.version": "2",
                    "spark.reducer.fetchMigratedShuffle.enabled": "true",
                },
            })
        ```
        ### Bigquery Routine Data Governance Type

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="tf_test_dataset_id_81126")
        custom_masking_routine = gcp.bigquery.Routine("custom_masking_routine",
            dataset_id=test.dataset_id,
            routine_id="custom_masking_routine",
            routine_type="SCALAR_FUNCTION",
            language="SQL",
            data_governance_type="DATA_MASKING",
            definition_body="SAFE.REGEXP_REPLACE(ssn, '[0-9]', 'X')",
            arguments=[{
                "name": "ssn",
                "data_type": "{\\"typeKind\\" :  \\"STRING\\"}",
            }],
            return_type="{\\"typeKind\\" :  \\"STRING\\"}")
        ```
        ### Bigquery Routine Remote Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test = gcp.bigquery.Dataset("test", dataset_id="dataset_id")
        test_connection = gcp.bigquery.Connection("test",
            connection_id="connection_id",
            location="US",
            cloud_resource={})
        remote_function = gcp.bigquery.Routine("remote_function",
            dataset_id=test.dataset_id,
            routine_id="routine_id",
            routine_type="SCALAR_FUNCTION",
            definition_body="",
            return_type="{\\"typeKind\\" :  \\"STRING\\"}",
            remote_function_options={
                "endpoint": "https://us-east1-my_gcf_project.cloudfunctions.net/remote_add",
                "connection": test_connection.name,
                "max_batching_rows": "10",
                "user_defined_context": {
                    "z": "1.5",
                },
            })
        ```

        ## Import

        Routine can be imported using any of these accepted formats:

        * `projects/{{project}}/datasets/{{dataset_id}}/routines/{{routine_id}}`

        * `{{project}}/{{dataset_id}}/{{routine_id}}`

        * `{{dataset_id}}/{{routine_id}}`

        When using the `pulumi import` command, Routine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default projects/{{project}}/datasets/{{dataset_id}}/routines/{{routine_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default {{project}}/{{dataset_id}}/{{routine_id}}
        ```

        ```sh
        $ pulumi import gcp:bigquery/routine:Routine default {{dataset_id}}/{{routine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RoutineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutineArgumentArgs', 'RoutineArgumentArgsDict']]]]] = None,
                 data_governance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 definition_body: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 determinism_level: Optional[pulumi.Input[_builtins.str]] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_function_options: Optional[pulumi.Input[Union['RoutineRemoteFunctionOptionsArgs', 'RoutineRemoteFunctionOptionsArgsDict']]] = None,
                 return_table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 return_type: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_options: Optional[pulumi.Input[Union['RoutineSparkOptionsArgs', 'RoutineSparkOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutineArgs.__new__(RoutineArgs)

            __props__.__dict__["arguments"] = arguments
            __props__.__dict__["data_governance_type"] = data_governance_type
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            if definition_body is None and not opts.urn:
                raise TypeError("Missing required property 'definition_body'")
            __props__.__dict__["definition_body"] = definition_body
            __props__.__dict__["description"] = description
            __props__.__dict__["determinism_level"] = determinism_level
            __props__.__dict__["imported_libraries"] = imported_libraries
            __props__.__dict__["language"] = language
            __props__.__dict__["project"] = project
            __props__.__dict__["remote_function_options"] = remote_function_options
            __props__.__dict__["return_table_type"] = return_table_type
            __props__.__dict__["return_type"] = return_type
            if routine_id is None and not opts.urn:
                raise TypeError("Missing required property 'routine_id'")
            __props__.__dict__["routine_id"] = routine_id
            if routine_type is None and not opts.urn:
                raise TypeError("Missing required property 'routine_type'")
            __props__.__dict__["routine_type"] = routine_type
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["spark_options"] = spark_options
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_modified_time"] = None
        super(Routine, __self__).__init__(
            'gcp:bigquery/routine:Routine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RoutineArgumentArgs', 'RoutineArgumentArgsDict']]]]] = None,
            creation_time: Optional[pulumi.Input[_builtins.int]] = None,
            data_governance_type: Optional[pulumi.Input[_builtins.str]] = None,
            dataset_id: Optional[pulumi.Input[_builtins.str]] = None,
            definition_body: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            determinism_level: Optional[pulumi.Input[_builtins.str]] = None,
            imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            language: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            remote_function_options: Optional[pulumi.Input[Union['RoutineRemoteFunctionOptionsArgs', 'RoutineRemoteFunctionOptionsArgsDict']]] = None,
            return_table_type: Optional[pulumi.Input[_builtins.str]] = None,
            return_type: Optional[pulumi.Input[_builtins.str]] = None,
            routine_id: Optional[pulumi.Input[_builtins.str]] = None,
            routine_type: Optional[pulumi.Input[_builtins.str]] = None,
            security_mode: Optional[pulumi.Input[_builtins.str]] = None,
            spark_options: Optional[pulumi.Input[Union['RoutineSparkOptionsArgs', 'RoutineSparkOptionsArgsDict']]] = None) -> 'Routine':
        """
        Get an existing Routine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RoutineArgumentArgs', 'RoutineArgumentArgsDict']]]] arguments: Input/output argument of a function or a stored procedure.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] creation_time: The time when this routine was created, in milliseconds since the
               epoch.
        :param pulumi.Input[_builtins.str] data_governance_type: If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
               Possible values are: `DATA_MASKING`.
        :param pulumi.Input[_builtins.str] dataset_id: The ID of the dataset containing this routine
        :param pulumi.Input[_builtins.str] definition_body: The body of the routine. For functions, this is the expression in the AS clause.
               If language=SQL, it is the substring inside (but excluding) the parentheses.
        :param pulumi.Input[_builtins.str] description: The description of the routine if defined.
        :param pulumi.Input[_builtins.str] determinism_level: The determinism level of the JavaScript UDF if defined.
               Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the
               imported JAVASCRIPT libraries.
        :param pulumi.Input[_builtins.str] language: The language of the routine.
               Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        :param pulumi.Input[_builtins.int] last_modified_time: The time when this routine was modified, in milliseconds since the
               epoch.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RoutineRemoteFunctionOptionsArgs', 'RoutineRemoteFunctionOptionsArgsDict']] remote_function_options: Remote function specific options.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] return_table_type: Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
               If absent, the return table type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the columns in the evaluated table result will
               be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input[_builtins.str] return_type: A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
               If absent, the return type is inferred from definitionBody at query time in each query
               that references this routine. If present, then the evaluated result will be cast to
               the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
               string, any changes to the string will create a diff, even if the JSON itself hasn't
               changed. If the API returns a different value for the same schema, e.g. it switche
               d the order of values or replaced STRUCT field type with RECORD field type, we currently
               cannot suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param pulumi.Input[_builtins.str] routine_id: The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        :param pulumi.Input[_builtins.str] routine_type: The type of routine.
               Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        :param pulumi.Input[_builtins.str] security_mode: Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
               Possible values are: `DEFINER`, `INVOKER`.
        :param pulumi.Input[Union['RoutineSparkOptionsArgs', 'RoutineSparkOptionsArgsDict']] spark_options: Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoutineState.__new__(_RoutineState)

        __props__.__dict__["arguments"] = arguments
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["data_governance_type"] = data_governance_type
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["definition_body"] = definition_body
        __props__.__dict__["description"] = description
        __props__.__dict__["determinism_level"] = determinism_level
        __props__.__dict__["imported_libraries"] = imported_libraries
        __props__.__dict__["language"] = language
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["project"] = project
        __props__.__dict__["remote_function_options"] = remote_function_options
        __props__.__dict__["return_table_type"] = return_table_type
        __props__.__dict__["return_type"] = return_type
        __props__.__dict__["routine_id"] = routine_id
        __props__.__dict__["routine_type"] = routine_type
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["spark_options"] = spark_options
        return Routine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Optional[Sequence['outputs.RoutineArgument']]]:
        """
        Input/output argument of a function or a stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "arguments")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when this routine was created, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="dataGovernanceType")
    def data_governance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If set to DATA_MASKING, the function is validated and made available as a masking function. For more information, see https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask
        Possible values are: `DATA_MASKING`.
        """
        return pulumi.get(self, "data_governance_type")

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dataset containing this routine
        """
        return pulumi.get(self, "dataset_id")

    @_builtins.property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> pulumi.Output[_builtins.str]:
        """
        The body of the routine. For functions, this is the expression in the AS clause.
        If language=SQL, it is the substring inside (but excluding) the parentheses.
        """
        return pulumi.get(self, "definition_body")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the routine if defined.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The determinism level of the JavaScript UDF if defined.
        Possible values are: `DETERMINISM_LEVEL_UNSPECIFIED`, `DETERMINISTIC`, `NOT_DETERMINISTIC`.
        """
        return pulumi.get(self, "determinism_level")

    @_builtins.property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the
        imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @_builtins.property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The language of the routine.
        Possible values are: `SQL`, `JAVASCRIPT`, `PYTHON`, `JAVA`, `SCALA`.
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.int]:
        """
        The time when this routine was modified, in milliseconds since the
        epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="remoteFunctionOptions")
    def remote_function_options(self) -> pulumi.Output[Optional['outputs.RoutineRemoteFunctionOptions']]:
        """
        Remote function specific options.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_function_options")

    @_builtins.property
    @pulumi.getter(name="returnTableType")
    def return_table_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
        If absent, the return table type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the columns in the evaluated table result will
        be cast to match the column types specificed in return table type, at query time.
        """
        return pulumi.get(self, "return_table_type")

    @_builtins.property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
        If absent, the return type is inferred from definitionBody at query time in each query
        that references this routine. If present, then the evaluated result will be cast to
        the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
        string, any changes to the string will create a diff, even if the JSON itself hasn't
        changed. If the API returns a different value for the same schema, e.g. it switche
        d the order of values or replaced STRUCT field type with RECORD field type, we currently
        cannot suppress the recurring diff this causes. As a workaround, we recommend using
        the schema as returned by the API.
        """
        return pulumi.get(self, "return_type")

    @_builtins.property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
        """
        return pulumi.get(self, "routine_id")

    @_builtins.property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of routine.
        Possible values are: `SCALAR_FUNCTION`, `PROCEDURE`, `TABLE_VALUED_FUNCTION`.
        """
        return pulumi.get(self, "routine_type")

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
        Possible values are: `DEFINER`, `INVOKER`.
        """
        return pulumi.get(self, "security_mode")

    @_builtins.property
    @pulumi.getter(name="sparkOptions")
    def spark_options(self) -> pulumi.Output[Optional['outputs.RoutineSparkOptions']]:
        """
        Optional. If language is one of "PYTHON", "JAVA", "SCALA", this field stores the options for spark stored procedure.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_options")

