# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListingArgs', 'Listing']

@pulumi.input_type
class ListingArgs:
    def __init__(__self__, *,
                 data_exchange_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 listing_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 allow_only_metadata_sharing: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigquery_dataset: Optional[pulumi.Input['ListingBigqueryDatasetArgs']] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_provider: Optional[pulumi.Input['ListingDataProviderArgs']] = None,
                 delete_commercial: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[_builtins.str]] = None,
                 icon: Optional[pulumi.Input[_builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher: Optional[pulumi.Input['ListingPublisherArgs']] = None,
                 pubsub_topic: Optional[pulumi.Input['ListingPubsubTopicArgs']] = None,
                 request_access: Optional[pulumi.Input[_builtins.str]] = None,
                 restricted_export_config: Optional[pulumi.Input['ListingRestrictedExportConfigArgs']] = None):
        """
        The set of arguments for constructing a Listing resource.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[_builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] location: The name of the location this data exchange listing.
        :param pulumi.Input[_builtins.bool] allow_only_metadata_sharing: If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        :param pulumi.Input['ListingBigqueryDatasetArgs'] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input['ListingDataProviderArgs'] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] delete_commercial: If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        :param pulumi.Input[_builtins.str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[_builtins.str] discovery_type: Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
               Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        :param pulumi.Input[_builtins.str] documentation: Documentation describing the listing.
        :param pulumi.Input[_builtins.str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[_builtins.str] primary_contact: Email or URL of the primary point of contact of the listing.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ListingPublisherArgs'] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input['ListingPubsubTopicArgs'] pubsub_topic: Pub/Sub topic source.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        :param pulumi.Input['ListingRestrictedExportConfigArgs'] restricted_export_config: If set, restricted export configuration will be propagated and enforced on the linked dataset.
               Structure is documented below.
        """
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "location", location)
        if allow_only_metadata_sharing is not None:
            pulumi.set(__self__, "allow_only_metadata_sharing", allow_only_metadata_sharing)
        if bigquery_dataset is not None:
            pulumi.set(__self__, "bigquery_dataset", bigquery_dataset)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if data_provider is not None:
            pulumi.set(__self__, "data_provider", data_provider)
        if delete_commercial is not None:
            pulumi.set(__self__, "delete_commercial", delete_commercial)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if request_access is not None:
            pulumi.set(__self__, "request_access", request_access)
        if restricted_export_config is not None:
            pulumi.set(__self__, "restricted_export_config", restricted_export_config)

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_exchange_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="allowOnlyMetadataSharing")
    def allow_only_metadata_sharing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        """
        return pulumi.get(self, "allow_only_metadata_sharing")

    @allow_only_metadata_sharing.setter
    def allow_only_metadata_sharing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_only_metadata_sharing", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> Optional[pulumi.Input['ListingBigqueryDatasetArgs']]:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @bigquery_dataset.setter
    def bigquery_dataset(self, value: Optional[pulumi.Input['ListingBigqueryDatasetArgs']]):
        pulumi.set(self, "bigquery_dataset", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> Optional[pulumi.Input['ListingDataProviderArgs']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @data_provider.setter
    def data_provider(self, value: Optional[pulumi.Input['ListingDataProviderArgs']]):
        pulumi.set(self, "data_provider", value)

    @_builtins.property
    @pulumi.getter(name="deleteCommercial")
    def delete_commercial(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        """
        return pulumi.get(self, "delete_commercial")

    @delete_commercial.setter
    def delete_commercial(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_commercial", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
        Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_type", value)

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation", value)

    @_builtins.property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon", value)

    @_builtins.property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @_builtins.property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email or URL of the primary point of contact of the listing.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_contact", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input['ListingPublisherArgs']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input['ListingPublisherArgs']]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input['ListingPubsubTopicArgs']]:
        """
        Pub/Sub topic source.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input['ListingPubsubTopicArgs']]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

    @request_access.setter
    def request_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_access", value)

    @_builtins.property
    @pulumi.getter(name="restrictedExportConfig")
    def restricted_export_config(self) -> Optional[pulumi.Input['ListingRestrictedExportConfigArgs']]:
        """
        If set, restricted export configuration will be propagated and enforced on the linked dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "restricted_export_config")

    @restricted_export_config.setter
    def restricted_export_config(self, value: Optional[pulumi.Input['ListingRestrictedExportConfigArgs']]):
        pulumi.set(self, "restricted_export_config", value)


@pulumi.input_type
class _ListingState:
    def __init__(__self__, *,
                 allow_only_metadata_sharing: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigquery_dataset: Optional[pulumi.Input['ListingBigqueryDatasetArgs']] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 commercial_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCommercialInfoArgs']]]] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_provider: Optional[pulumi.Input['ListingDataProviderArgs']] = None,
                 delete_commercial: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[_builtins.str]] = None,
                 icon: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher: Optional[pulumi.Input['ListingPublisherArgs']] = None,
                 pubsub_topic: Optional[pulumi.Input['ListingPubsubTopicArgs']] = None,
                 request_access: Optional[pulumi.Input[_builtins.str]] = None,
                 restricted_export_config: Optional[pulumi.Input['ListingRestrictedExportConfigArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Listing resources.
        :param pulumi.Input[_builtins.bool] allow_only_metadata_sharing: If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        :param pulumi.Input['ListingBigqueryDatasetArgs'] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['ListingCommercialInfoArgs']]] commercial_infos: Commercial info contains the information about the commercial data products associated with the listing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input['ListingDataProviderArgs'] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] delete_commercial: If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        :param pulumi.Input[_builtins.str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[_builtins.str] discovery_type: Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
               Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[_builtins.str] documentation: Documentation describing the listing.
        :param pulumi.Input[_builtins.str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[_builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] location: The name of the location this data exchange listing.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[_builtins.str] name: The resource name of the listing. e.g. "projects/myproject/locations/US/dataExchanges/123/listings/456"
        :param pulumi.Input[_builtins.str] primary_contact: Email or URL of the primary point of contact of the listing.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ListingPublisherArgs'] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input['ListingPubsubTopicArgs'] pubsub_topic: Pub/Sub topic source.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        :param pulumi.Input['ListingRestrictedExportConfigArgs'] restricted_export_config: If set, restricted export configuration will be propagated and enforced on the linked dataset.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: Current state of the listing.
        """
        if allow_only_metadata_sharing is not None:
            pulumi.set(__self__, "allow_only_metadata_sharing", allow_only_metadata_sharing)
        if bigquery_dataset is not None:
            pulumi.set(__self__, "bigquery_dataset", bigquery_dataset)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if commercial_infos is not None:
            pulumi.set(__self__, "commercial_infos", commercial_infos)
        if data_exchange_id is not None:
            pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        if data_provider is not None:
            pulumi.set(__self__, "data_provider", data_provider)
        if delete_commercial is not None:
            pulumi.set(__self__, "delete_commercial", delete_commercial)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_type is not None:
            pulumi.set(__self__, "discovery_type", discovery_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_linked_dataset_query_user_email is not None:
            pulumi.set(__self__, "log_linked_dataset_query_user_email", log_linked_dataset_query_user_email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if request_access is not None:
            pulumi.set(__self__, "request_access", request_access)
        if restricted_export_config is not None:
            pulumi.set(__self__, "restricted_export_config", restricted_export_config)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="allowOnlyMetadataSharing")
    def allow_only_metadata_sharing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        """
        return pulumi.get(self, "allow_only_metadata_sharing")

    @allow_only_metadata_sharing.setter
    def allow_only_metadata_sharing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_only_metadata_sharing", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> Optional[pulumi.Input['ListingBigqueryDatasetArgs']]:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @bigquery_dataset.setter
    def bigquery_dataset(self, value: Optional[pulumi.Input['ListingBigqueryDatasetArgs']]):
        pulumi.set(self, "bigquery_dataset", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="commercialInfos")
    def commercial_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListingCommercialInfoArgs']]]]:
        """
        Commercial info contains the information about the commercial data products associated with the listing.
        Structure is documented below.
        """
        return pulumi.get(self, "commercial_infos")

    @commercial_infos.setter
    def commercial_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCommercialInfoArgs']]]]):
        pulumi.set(self, "commercial_infos", value)

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_exchange_id", value)

    @_builtins.property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> Optional[pulumi.Input['ListingDataProviderArgs']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @data_provider.setter
    def data_provider(self, value: Optional[pulumi.Input['ListingDataProviderArgs']]):
        pulumi.set(self, "data_provider", value)

    @_builtins.property
    @pulumi.getter(name="deleteCommercial")
    def delete_commercial(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        """
        return pulumi.get(self, "delete_commercial")

    @delete_commercial.setter
    def delete_commercial(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_commercial", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
        Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        """
        return pulumi.get(self, "discovery_type")

    @discovery_type.setter
    def discovery_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "documentation", value)

    @_builtins.property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "icon", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @log_linked_dataset_query_user_email.setter
    def log_linked_dataset_query_user_email(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_linked_dataset_query_user_email", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the listing. e.g. "projects/myproject/locations/US/dataExchanges/123/listings/456"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email or URL of the primary point of contact of the listing.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_contact", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input['ListingPublisherArgs']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input['ListingPublisherArgs']]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input['ListingPubsubTopicArgs']]:
        """
        Pub/Sub topic source.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input['ListingPubsubTopicArgs']]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

    @request_access.setter
    def request_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_access", value)

    @_builtins.property
    @pulumi.getter(name="restrictedExportConfig")
    def restricted_export_config(self) -> Optional[pulumi.Input['ListingRestrictedExportConfigArgs']]:
        """
        If set, restricted export configuration will be propagated and enforced on the linked dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "restricted_export_config")

    @restricted_export_config.setter
    def restricted_export_config(self, value: Optional[pulumi.Input['ListingRestrictedExportConfigArgs']]):
        pulumi.set(self, "restricted_export_config", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current state of the listing.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:bigqueryanalyticshub/listing:Listing")
class Listing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_only_metadata_sharing: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigquery_dataset: Optional[pulumi.Input[Union['ListingBigqueryDatasetArgs', 'ListingBigqueryDatasetArgsDict']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_provider: Optional[pulumi.Input[Union['ListingDataProviderArgs', 'ListingDataProviderArgsDict']]] = None,
                 delete_commercial: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[_builtins.str]] = None,
                 icon: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher: Optional[pulumi.Input[Union['ListingPublisherArgs', 'ListingPublisherArgsDict']]] = None,
                 pubsub_topic: Optional[pulumi.Input[Union['ListingPubsubTopicArgs', 'ListingPubsubTopicArgsDict']]] = None,
                 request_access: Optional[pulumi.Input[_builtins.str]] = None,
                 restricted_export_config: Optional[pulumi.Input[Union['ListingRestrictedExportConfigArgs', 'ListingRestrictedExportConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Bigquery Analytics Hub data exchange listing

        To get more information about Listing, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges.listings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage

        ### Bigquery Analyticshub Listing Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Restricted

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
            },
            restricted_export_config={
                "enabled": True,
                "restrict_query_result": True,
            })
        ```
        ### Bigquery Analyticshub Listing Dcr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="dcr_data_exchange",
            display_name="dcr_data_exchange",
            description="example dcr data exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="dcr_listing",
            friendly_name="dcr_listing",
            description="example dcr data exchange",
            location="US")
        listing_table = gcp.bigquery.Table("listing",
            deletion_protection=False,
            table_id="dcr_listing",
            dataset_id=listing_dataset.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"name\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\"
          },
          {
            \\"name\\": \\"post_abbr\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\"
          },
          {
            \\"name\\": \\"date\\",
            \\"type\\": \\"DATE\\",
            \\"mode\\": \\"NULLABLE\\"
          }
        ]
        \"\"\")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="dcr_listing",
            display_name="dcr_listing",
            description="example dcr data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
                "selected_resources": [{
                    "table": listing_table.id,
                }],
            },
            restricted_export_config={
                "enabled": True,
            })
        ```
        ### Bigquery Analyticshub Listing Log Linked Dataset Query User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing_log_email = gcp.bigqueryanalyticshub.DataExchange("listing_log_email",
            location="US",
            data_exchange_id="tf_test_log_email_de",
            display_name="tf_test_log_email_de",
            description="Example for log email test")
        listing_log_email_dataset = gcp.bigquery.Dataset("listing_log_email",
            dataset_id="tf_test_log_email_ds",
            friendly_name="tf_test_log_email_ds",
            description="Example for log email test",
            location="US")
        listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing_log_email.data_exchange_id,
            listing_id="tf_test_log_email_listing",
            display_name="tf_test_log_email_listing",
            description="Example for log email test",
            log_linked_dataset_query_user_email=True,
            bigquery_dataset={
                "dataset": listing_log_email_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="tf_test_pubsub_data_exchange",
            display_name="tf_test_pubsub_data_exchange",
            description="Example for pubsub topic source")
        tf_test_pubsub_topic = gcp.pubsub.Topic("tf_test_pubsub_topic", name="test_pubsub")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="tf_test_pubsub_listing",
            display_name="tf_test_pubsub_listing",
            description="Example for pubsub topic source",
            pubsub_topic={
                "topic": tf_test_pubsub_topic.id,
                "data_affinity_regions": [
                    "us-central1",
                    "europe-west1",
                ],
            })
        ```
        ### Bigquery Analyticshub Listing Dcr Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        dcr_data_exchange_example = gcp.bigqueryanalyticshub.DataExchange("dcr_data_exchange_example",
            location="us",
            data_exchange_id="tf_test_data_exchange",
            display_name="tf_test_data_exchange",
            description="Example for listing with routine",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        listing = gcp.bigquery.Dataset("listing",
            dataset_id="tf_test_dataset",
            friendly_name="tf_test_dataset",
            description="Example for listing with routine",
            location="us")
        listing_routine = gcp.bigquery.Routine("listing",
            dataset_id=listing.dataset_id,
            routine_id="tf_test_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            description="A DCR routine example.",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=dcr_data_exchange_example.data_exchange_id,
            listing_id="tf_test_listing_routine",
            display_name="tf_test_listing_routine",
            description="Example for listing with routine",
            bigquery_dataset={
                "dataset": listing.id,
                "selected_resources": [{
                    "routine": listing_routine.id,
                }],
            },
            restricted_export_config={
                "enabled": True,
            })
        ```
        ### Bigquery Analyticshub Public Listing

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example public listing",
            discovery_type="DISCOVERY_TYPE_PUBLIC")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example public listing",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example public listing",
            discovery_type="DISCOVERY_TYPE_PUBLIC",
            allow_only_metadata_sharing=False,
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Marketplace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            delete_commercial=True,
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```

        ## Import

        Listing can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}`

        * `{{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}`

        * `{{location}}/{{data_exchange_id}}/{{listing_id}}`

        When using the `pulumi import` command, Listing can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_only_metadata_sharing: If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        :param pulumi.Input[Union['ListingBigqueryDatasetArgs', 'ListingBigqueryDatasetArgsDict']] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[Union['ListingDataProviderArgs', 'ListingDataProviderArgsDict']] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] delete_commercial: If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        :param pulumi.Input[_builtins.str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[_builtins.str] discovery_type: Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
               Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[_builtins.str] documentation: Documentation describing the listing.
        :param pulumi.Input[_builtins.str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[_builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] location: The name of the location this data exchange listing.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[_builtins.str] primary_contact: Email or URL of the primary point of contact of the listing.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ListingPublisherArgs', 'ListingPublisherArgsDict']] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[Union['ListingPubsubTopicArgs', 'ListingPubsubTopicArgsDict']] pubsub_topic: Pub/Sub topic source.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        :param pulumi.Input[Union['ListingRestrictedExportConfigArgs', 'ListingRestrictedExportConfigArgsDict']] restricted_export_config: If set, restricted export configuration will be propagated and enforced on the linked dataset.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Bigquery Analytics Hub data exchange listing

        To get more information about Listing, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges.listings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage

        ### Bigquery Analyticshub Listing Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Restricted

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
            },
            restricted_export_config={
                "enabled": True,
                "restrict_query_result": True,
            })
        ```
        ### Bigquery Analyticshub Listing Dcr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="dcr_data_exchange",
            display_name="dcr_data_exchange",
            description="example dcr data exchange",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="dcr_listing",
            friendly_name="dcr_listing",
            description="example dcr data exchange",
            location="US")
        listing_table = gcp.bigquery.Table("listing",
            deletion_protection=False,
            table_id="dcr_listing",
            dataset_id=listing_dataset.dataset_id,
            schema=\"\"\"[
          {
            \\"name\\": \\"name\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\"
          },
          {
            \\"name\\": \\"post_abbr\\",
            \\"type\\": \\"STRING\\",
            \\"mode\\": \\"NULLABLE\\"
          },
          {
            \\"name\\": \\"date\\",
            \\"type\\": \\"DATE\\",
            \\"mode\\": \\"NULLABLE\\"
          }
        ]
        \"\"\")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="dcr_listing",
            display_name="dcr_listing",
            description="example dcr data exchange",
            bigquery_dataset={
                "dataset": listing_dataset.id,
                "selected_resources": [{
                    "table": listing_table.id,
                }],
            },
            restricted_export_config={
                "enabled": True,
            })
        ```
        ### Bigquery Analyticshub Listing Log Linked Dataset Query User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing_log_email = gcp.bigqueryanalyticshub.DataExchange("listing_log_email",
            location="US",
            data_exchange_id="tf_test_log_email_de",
            display_name="tf_test_log_email_de",
            description="Example for log email test")
        listing_log_email_dataset = gcp.bigquery.Dataset("listing_log_email",
            dataset_id="tf_test_log_email_ds",
            friendly_name="tf_test_log_email_ds",
            description="Example for log email test",
            location="US")
        listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing_log_email.data_exchange_id,
            listing_id="tf_test_log_email_listing",
            display_name="tf_test_log_email_listing",
            description="Example for log email test",
            log_linked_dataset_query_user_email=True,
            bigquery_dataset={
                "dataset": listing_log_email_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="tf_test_pubsub_data_exchange",
            display_name="tf_test_pubsub_data_exchange",
            description="Example for pubsub topic source")
        tf_test_pubsub_topic = gcp.pubsub.Topic("tf_test_pubsub_topic", name="test_pubsub")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="tf_test_pubsub_listing",
            display_name="tf_test_pubsub_listing",
            description="Example for pubsub topic source",
            pubsub_topic={
                "topic": tf_test_pubsub_topic.id,
                "data_affinity_regions": [
                    "us-central1",
                    "europe-west1",
                ],
            })
        ```
        ### Bigquery Analyticshub Listing Dcr Routine

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        dcr_data_exchange_example = gcp.bigqueryanalyticshub.DataExchange("dcr_data_exchange_example",
            location="us",
            data_exchange_id="tf_test_data_exchange",
            display_name="tf_test_data_exchange",
            description="Example for listing with routine",
            sharing_environment_config={
                "dcr_exchange_config": {},
            })
        listing = gcp.bigquery.Dataset("listing",
            dataset_id="tf_test_dataset",
            friendly_name="tf_test_dataset",
            description="Example for listing with routine",
            location="us")
        listing_routine = gcp.bigquery.Routine("listing",
            dataset_id=listing.dataset_id,
            routine_id="tf_test_routine",
            routine_type="TABLE_VALUED_FUNCTION",
            language="SQL",
            description="A DCR routine example.",
            definition_body="SELECT 1 + value AS value\\n",
            arguments=[{
                "name": "value",
                "argument_kind": "FIXED_TYPE",
                "data_type": json.dumps({
                    "typeKind": "INT64",
                }),
            }],
            return_table_type=json.dumps({
                "columns": [{
                    "name": "value",
                    "type": {
                        "typeKind": "INT64",
                    },
                }],
            }))
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=dcr_data_exchange_example.data_exchange_id,
            listing_id="tf_test_listing_routine",
            display_name="tf_test_listing_routine",
            description="Example for listing with routine",
            bigquery_dataset={
                "dataset": listing.id,
                "selected_resources": [{
                    "routine": listing_routine.id,
                }],
            },
            restricted_export_config={
                "enabled": True,
            })
        ```
        ### Bigquery Analyticshub Public Listing

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example public listing",
            discovery_type="DISCOVERY_TYPE_PUBLIC")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example public listing",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example public listing",
            discovery_type="DISCOVERY_TYPE_PUBLIC",
            allow_only_metadata_sharing=False,
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```
        ### Bigquery Analyticshub Listing Marketplace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing = gcp.bigqueryanalyticshub.DataExchange("listing",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listing",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listing",
            location="US",
            data_exchange_id=listing.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            delete_commercial=True,
            bigquery_dataset={
                "dataset": listing_dataset.id,
            })
        ```

        ## Import

        Listing can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}`

        * `{{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}`

        * `{{location}}/{{data_exchange_id}}/{{listing_id}}`

        When using the `pulumi import` command, Listing can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        ```sh
        $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ListingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_only_metadata_sharing: Optional[pulumi.Input[_builtins.bool]] = None,
                 bigquery_dataset: Optional[pulumi.Input[Union['ListingBigqueryDatasetArgs', 'ListingBigqueryDatasetArgsDict']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_provider: Optional[pulumi.Input[Union['ListingDataProviderArgs', 'ListingDataProviderArgsDict']]] = None,
                 delete_commercial: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 documentation: Optional[pulumi.Input[_builtins.str]] = None,
                 icon: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher: Optional[pulumi.Input[Union['ListingPublisherArgs', 'ListingPublisherArgsDict']]] = None,
                 pubsub_topic: Optional[pulumi.Input[Union['ListingPubsubTopicArgs', 'ListingPubsubTopicArgsDict']]] = None,
                 request_access: Optional[pulumi.Input[_builtins.str]] = None,
                 restricted_export_config: Optional[pulumi.Input[Union['ListingRestrictedExportConfigArgs', 'ListingRestrictedExportConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListingArgs.__new__(ListingArgs)

            __props__.__dict__["allow_only_metadata_sharing"] = allow_only_metadata_sharing
            __props__.__dict__["bigquery_dataset"] = bigquery_dataset
            __props__.__dict__["categories"] = categories
            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            __props__.__dict__["data_provider"] = data_provider
            __props__.__dict__["delete_commercial"] = delete_commercial
            __props__.__dict__["description"] = description
            __props__.__dict__["discovery_type"] = discovery_type
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["icon"] = icon
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
            __props__.__dict__["primary_contact"] = primary_contact
            __props__.__dict__["project"] = project
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["pubsub_topic"] = pubsub_topic
            __props__.__dict__["request_access"] = request_access
            __props__.__dict__["restricted_export_config"] = restricted_export_config
            __props__.__dict__["commercial_infos"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(Listing, __self__).__init__(
            'gcp:bigqueryanalyticshub/listing:Listing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_only_metadata_sharing: Optional[pulumi.Input[_builtins.bool]] = None,
            bigquery_dataset: Optional[pulumi.Input[Union['ListingBigqueryDatasetArgs', 'ListingBigqueryDatasetArgsDict']]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            commercial_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListingCommercialInfoArgs', 'ListingCommercialInfoArgsDict']]]]] = None,
            data_exchange_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_provider: Optional[pulumi.Input[Union['ListingDataProviderArgs', 'ListingDataProviderArgsDict']]] = None,
            delete_commercial: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            discovery_type: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            documentation: Optional[pulumi.Input[_builtins.str]] = None,
            icon: Optional[pulumi.Input[_builtins.str]] = None,
            listing_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            log_linked_dataset_query_user_email: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_contact: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            publisher: Optional[pulumi.Input[Union['ListingPublisherArgs', 'ListingPublisherArgsDict']]] = None,
            pubsub_topic: Optional[pulumi.Input[Union['ListingPubsubTopicArgs', 'ListingPubsubTopicArgsDict']]] = None,
            request_access: Optional[pulumi.Input[_builtins.str]] = None,
            restricted_export_config: Optional[pulumi.Input[Union['ListingRestrictedExportConfigArgs', 'ListingRestrictedExportConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'Listing':
        """
        Get an existing Listing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_only_metadata_sharing: If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        :param pulumi.Input[Union['ListingBigqueryDatasetArgs', 'ListingBigqueryDatasetArgsDict']] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListingCommercialInfoArgs', 'ListingCommercialInfoArgsDict']]]] commercial_infos: Commercial info contains the information about the commercial data products associated with the listing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[Union['ListingDataProviderArgs', 'ListingDataProviderArgsDict']] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] delete_commercial: If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        :param pulumi.Input[_builtins.str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[_builtins.str] discovery_type: Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
               Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        :param pulumi.Input[_builtins.str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[_builtins.str] documentation: Documentation describing the listing.
        :param pulumi.Input[_builtins.str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[_builtins.str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[_builtins.str] location: The name of the location this data exchange listing.
        :param pulumi.Input[_builtins.bool] log_linked_dataset_query_user_email: If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        :param pulumi.Input[_builtins.str] name: The resource name of the listing. e.g. "projects/myproject/locations/US/dataExchanges/123/listings/456"
        :param pulumi.Input[_builtins.str] primary_contact: Email or URL of the primary point of contact of the listing.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ListingPublisherArgs', 'ListingPublisherArgsDict']] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[Union['ListingPubsubTopicArgs', 'ListingPubsubTopicArgsDict']] pubsub_topic: Pub/Sub topic source.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        :param pulumi.Input[Union['ListingRestrictedExportConfigArgs', 'ListingRestrictedExportConfigArgsDict']] restricted_export_config: If set, restricted export configuration will be propagated and enforced on the linked dataset.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: Current state of the listing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListingState.__new__(_ListingState)

        __props__.__dict__["allow_only_metadata_sharing"] = allow_only_metadata_sharing
        __props__.__dict__["bigquery_dataset"] = bigquery_dataset
        __props__.__dict__["categories"] = categories
        __props__.__dict__["commercial_infos"] = commercial_infos
        __props__.__dict__["data_exchange_id"] = data_exchange_id
        __props__.__dict__["data_provider"] = data_provider
        __props__.__dict__["delete_commercial"] = delete_commercial
        __props__.__dict__["description"] = description
        __props__.__dict__["discovery_type"] = discovery_type
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation"] = documentation
        __props__.__dict__["icon"] = icon
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["location"] = location
        __props__.__dict__["log_linked_dataset_query_user_email"] = log_linked_dataset_query_user_email
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_contact"] = primary_contact
        __props__.__dict__["project"] = project
        __props__.__dict__["publisher"] = publisher
        __props__.__dict__["pubsub_topic"] = pubsub_topic
        __props__.__dict__["request_access"] = request_access
        __props__.__dict__["restricted_export_config"] = restricted_export_config
        __props__.__dict__["state"] = state
        return Listing(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowOnlyMetadataSharing")
    def allow_only_metadata_sharing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the listing is only available to get the resource metadata. Listing is non subscribable.
        """
        return pulumi.get(self, "allow_only_metadata_sharing")

    @_builtins.property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> pulumi.Output[Optional['outputs.ListingBigqueryDataset']]:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="commercialInfos")
    def commercial_infos(self) -> pulumi.Output[Sequence['outputs.ListingCommercialInfo']]:
        """
        Commercial info contains the information about the commercial data products associated with the listing.
        Structure is documented below.
        """
        return pulumi.get(self, "commercial_infos")

    @_builtins.property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @_builtins.property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> pulumi.Output[Optional['outputs.ListingDataProvider']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @_builtins.property
    @pulumi.getter(name="deleteCommercial")
    def delete_commercial(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the listing is commercial then this field must be set to true, otherwise a failure is thrown. This acts as a safety guard to avoid deleting commercial listings accidentally.
        """
        return pulumi.get(self, "delete_commercial")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of discovery on the discovery page. Cannot be set for a restricted listing. Note that this does not control the visibility of the exchange/listing which is defined by IAM permission.
        Possible values are: `DISCOVERY_TYPE_PRIVATE`, `DISCOVERY_TYPE_PUBLIC`.
        """
        return pulumi.get(self, "discovery_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @_builtins.property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logLinkedDatasetQueryUserEmail")
    def log_linked_dataset_query_user_email(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, subscriber email logging is enabled and all queries on the linked dataset will log the email address of the querying user. Once enabled, this setting cannot be turned off.
        """
        return pulumi.get(self, "log_linked_dataset_query_user_email")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the listing. e.g. "projects/myproject/locations/US/dataExchanges/123/listings/456"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email or URL of the primary point of contact of the listing.
        """
        return pulumi.get(self, "primary_contact")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Output[Optional['outputs.ListingPublisher']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Output[Optional['outputs.ListingPubsubTopic']]:
        """
        Pub/Sub topic source.
        Structure is documented below.
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

    @_builtins.property
    @pulumi.getter(name="restrictedExportConfig")
    def restricted_export_config(self) -> pulumi.Output[Optional['outputs.ListingRestrictedExportConfig']]:
        """
        If set, restricted export configuration will be propagated and enforced on the linked dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "restricted_export_config")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Current state of the listing.
        """
        return pulumi.get(self, "state")

