# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizedViewArgs', 'AuthorizedView']

@pulumi.input_type
class AuthorizedViewArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 table_name: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subset_view: Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']] = None):
        """
        The set of arguments for constructing a AuthorizedView resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance in which the authorized view belongs.
        :param pulumi.Input[_builtins.str] table_name: The name of the Bigtable table in which the authorized view belongs.
        :param pulumi.Input[_builtins.str] name: The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['AuthorizedViewSubsetViewArgs'] subset_view: An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.
               
               -----
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "table_name", table_name)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if subset_view is not None:
            pulumi.set(__self__, "subset_view", subset_view)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Bigtable instance in which the authorized view belongs.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Bigtable table in which the authorized view belongs.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_name", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="subsetView")
    def subset_view(self) -> Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']]:
        """
        An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.

        -----
        """
        return pulumi.get(self, "subset_view")

    @subset_view.setter
    def subset_view(self, value: Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']]):
        pulumi.set(self, "subset_view", value)


@pulumi.input_type
class _AuthorizedViewState:
    def __init__(__self__, *,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subset_view: Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizedView resources.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance in which the authorized view belongs.
        :param pulumi.Input[_builtins.str] name: The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['AuthorizedViewSubsetViewArgs'] subset_view: An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.
               
               -----
        :param pulumi.Input[_builtins.str] table_name: The name of the Bigtable table in which the authorized view belongs.
        """
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if subset_view is not None:
            pulumi.set(__self__, "subset_view", subset_view)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Bigtable instance in which the authorized view belongs.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="subsetView")
    def subset_view(self) -> Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']]:
        """
        An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.

        -----
        """
        return pulumi.get(self, "subset_view")

    @subset_view.setter
    def subset_view(self, value: Optional[pulumi.Input['AuthorizedViewSubsetViewArgs']]):
        pulumi.set(self, "subset_view", value)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Bigtable table in which the authorized view belongs.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_name", value)


@pulumi.type_token("gcp:bigtable/authorizedView:AuthorizedView")
class AuthorizedView(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subset_view: Optional[pulumi.Input[Union['AuthorizedViewSubsetViewArgs', 'AuthorizedViewSubsetViewArgsDict']]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        instance = gcp.bigtable.Instance("instance",
            name="tf-instance",
            clusters=[{
                "cluster_id": "tf-instance-cluster",
                "zone": "us-central1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }])
        table = gcp.bigtable.Table("table",
            name="tf-table",
            instance_name=instance.name,
            split_keys=[
                "a",
                "b",
                "c",
            ],
            column_families=[
                {
                    "family": "family-first",
                },
                {
                    "family": "family-second",
                },
            ],
            change_stream_retention="24h0m0s")
        authorized_view = gcp.bigtable.AuthorizedView("authorized_view",
            name="tf-authorized-view",
            instance_name=instance.name,
            table_name=table.name,
            subset_view={
                "row_prefixes": [std.base64encode(input="prefix#").result],
                "family_subsets": [
                    {
                        "family_name": "family-first",
                        "qualifiers": [
                            std.base64encode(input="qualifier").result,
                            std.base64encode(input="qualifier-second").result,
                        ],
                    },
                    {
                        "family_name": "family-second",
                        "qualifier_prefixes": [""],
                    },
                ],
            })
        ```

        ## Import

        Bigtable Authorized Views can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance_name}}/tables/{{table_name}}/authorizedViews/{{name}}`

        * `{{project}}/{{instance_name}}/{{table_name}}/{{name}}`

        * `{{instance_name}}/{{table_name}}/{{name}}`

        When using the `pulumi import` command, Bigtable Authorized Views can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default projects/{{project}}/instances/{{instance_name}}/tables/{{table_name}}/authorizedViews/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default {{project}}/{{instance_name}}/{{table_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default {{instance_name}}/{{table_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance in which the authorized view belongs.
        :param pulumi.Input[_builtins.str] name: The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['AuthorizedViewSubsetViewArgs', 'AuthorizedViewSubsetViewArgsDict']] subset_view: An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.
               
               -----
        :param pulumi.Input[_builtins.str] table_name: The name of the Bigtable table in which the authorized view belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizedViewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        instance = gcp.bigtable.Instance("instance",
            name="tf-instance",
            clusters=[{
                "cluster_id": "tf-instance-cluster",
                "zone": "us-central1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }])
        table = gcp.bigtable.Table("table",
            name="tf-table",
            instance_name=instance.name,
            split_keys=[
                "a",
                "b",
                "c",
            ],
            column_families=[
                {
                    "family": "family-first",
                },
                {
                    "family": "family-second",
                },
            ],
            change_stream_retention="24h0m0s")
        authorized_view = gcp.bigtable.AuthorizedView("authorized_view",
            name="tf-authorized-view",
            instance_name=instance.name,
            table_name=table.name,
            subset_view={
                "row_prefixes": [std.base64encode(input="prefix#").result],
                "family_subsets": [
                    {
                        "family_name": "family-first",
                        "qualifiers": [
                            std.base64encode(input="qualifier").result,
                            std.base64encode(input="qualifier-second").result,
                        ],
                    },
                    {
                        "family_name": "family-second",
                        "qualifier_prefixes": [""],
                    },
                ],
            })
        ```

        ## Import

        Bigtable Authorized Views can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance_name}}/tables/{{table_name}}/authorizedViews/{{name}}`

        * `{{project}}/{{instance_name}}/{{table_name}}/{{name}}`

        * `{{instance_name}}/{{table_name}}/{{name}}`

        When using the `pulumi import` command, Bigtable Authorized Views can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default projects/{{project}}/instances/{{instance_name}}/tables/{{table_name}}/authorizedViews/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default {{project}}/{{instance_name}}/{{table_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/authorizedView:AuthorizedView default {{instance_name}}/{{table_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizedViewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizedViewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 subset_view: Optional[pulumi.Input[Union['AuthorizedViewSubsetViewArgs', 'AuthorizedViewSubsetViewArgsDict']]] = None,
                 table_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizedViewArgs.__new__(AuthorizedViewArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["subset_view"] = subset_view
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
        super(AuthorizedView, __self__).__init__(
            'gcp:bigtable/authorizedView:AuthorizedView',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            subset_view: Optional[pulumi.Input[Union['AuthorizedViewSubsetViewArgs', 'AuthorizedViewSubsetViewArgsDict']]] = None,
            table_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthorizedView':
        """
        Get an existing AuthorizedView resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance in which the authorized view belongs.
        :param pulumi.Input[_builtins.str] name: The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['AuthorizedViewSubsetViewArgs', 'AuthorizedViewSubsetViewArgsDict']] subset_view: An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.
               
               -----
        :param pulumi.Input[_builtins.str] table_name: The name of the Bigtable table in which the authorized view belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizedViewState.__new__(_AuthorizedViewState)

        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["subset_view"] = subset_view
        __props__.__dict__["table_name"] = table_name
        return AuthorizedView(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Bigtable instance in which the authorized view belongs.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the authorized view. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="subsetView")
    def subset_view(self) -> pulumi.Output[Optional['outputs.AuthorizedViewSubsetView']]:
        """
        An AuthorizedView permitting access to an explicit subset of a Table. Structure is documented below.

        -----
        """
        return pulumi.get(self, "subset_view")

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Bigtable table in which the authorized view belongs.
        """
        return pulumi.get(self, "table_name")

