# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableArgs', 'Table']

@pulumi.input_type
class TableArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 automated_backup_policy: Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']] = None,
                 change_stream_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 column_families: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 split_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Table resource.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance.
        :param pulumi.Input['TableAutomatedBackupPolicyArgs'] automated_backup_policy: Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.
               
               -----
        :param pulumi.Input[_builtins.str] change_stream_retention: Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]] column_families: A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        :param pulumi.Input[_builtins.str] deletion_protection: A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        :param pulumi.Input[_builtins.str] name: The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] row_key_schema: Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
               					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
               				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
               					
               					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
               					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] split_keys: A list of predefined keys to split the table on.
               !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
               to delete/recreate the entire `bigtable.Table` resource.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if change_stream_retention is not None:
            pulumi.set(__self__, "change_stream_retention", change_stream_retention)
        if column_families is not None:
            pulumi.set(__self__, "column_families", column_families)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if row_key_schema is not None:
            pulumi.set(__self__, "row_key_schema", row_key_schema)
        if split_keys is not None:
            pulumi.set(__self__, "split_keys", split_keys)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Bigtable instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']]:
        """
        Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.

        -----
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="changeStreamRetention")
    def change_stream_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        """
        return pulumi.get(self, "change_stream_retention")

    @change_stream_retention.setter
    def change_stream_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_stream_retention", value)

    @_builtins.property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]]:
        """
        A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        """
        return pulumi.get(self, "column_families")

    @column_families.setter
    def column_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]]):
        pulumi.set(self, "column_families", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rowKeySchema")
    def row_key_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
        					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
        				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
        					
        					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
        					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        """
        return pulumi.get(self, "row_key_schema")

    @row_key_schema.setter
    def row_key_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "row_key_schema", value)

    @_builtins.property
    @pulumi.getter(name="splitKeys")
    def split_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of predefined keys to split the table on.
        !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
        to delete/recreate the entire `bigtable.Table` resource.
        """
        return pulumi.get(self, "split_keys")

    @split_keys.setter
    def split_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "split_keys", value)


@pulumi.input_type
class _TableState:
    def __init__(__self__, *,
                 automated_backup_policy: Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']] = None,
                 change_stream_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 column_families: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 split_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Table resources.
        :param pulumi.Input['TableAutomatedBackupPolicyArgs'] automated_backup_policy: Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.
               
               -----
        :param pulumi.Input[_builtins.str] change_stream_retention: Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        :param pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]] column_families: A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        :param pulumi.Input[_builtins.str] deletion_protection: A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance.
        :param pulumi.Input[_builtins.str] name: The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] row_key_schema: Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
               					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
               				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
               					
               					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
               					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] split_keys: A list of predefined keys to split the table on.
               !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
               to delete/recreate the entire `bigtable.Table` resource.
        """
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if change_stream_retention is not None:
            pulumi.set(__self__, "change_stream_retention", change_stream_retention)
        if column_families is not None:
            pulumi.set(__self__, "column_families", column_families)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if row_key_schema is not None:
            pulumi.set(__self__, "row_key_schema", row_key_schema)
        if split_keys is not None:
            pulumi.set(__self__, "split_keys", split_keys)

    @_builtins.property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']]:
        """
        Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.

        -----
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['TableAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="changeStreamRetention")
    def change_stream_retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        """
        return pulumi.get(self, "change_stream_retention")

    @change_stream_retention.setter
    def change_stream_retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "change_stream_retention", value)

    @_builtins.property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]]:
        """
        A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        """
        return pulumi.get(self, "column_families")

    @column_families.setter
    def column_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableColumnFamilyArgs']]]]):
        pulumi.set(self, "column_families", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Bigtable instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rowKeySchema")
    def row_key_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
        					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
        				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
        					
        					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
        					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        """
        return pulumi.get(self, "row_key_schema")

    @row_key_schema.setter
    def row_key_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "row_key_schema", value)

    @_builtins.property
    @pulumi.getter(name="splitKeys")
    def split_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of predefined keys to split the table on.
        !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
        to delete/recreate the entire `bigtable.Table` resource.
        """
        return pulumi.get(self, "split_keys")

    @split_keys.setter
    def split_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "split_keys", value)


@pulumi.type_token("gcp:bigtable/table:Table")
class Table(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_backup_policy: Optional[pulumi.Input[Union['TableAutomatedBackupPolicyArgs', 'TableAutomatedBackupPolicyArgsDict']]] = None,
                 change_stream_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 column_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnFamilyArgs', 'TableColumnFamilyArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 split_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates a Google Cloud Bigtable table inside an instance. For more information see
        [the official documentation](https://cloud.google.com/bigtable/) and
        [API](https://cloud.google.com/bigtable/docs/go/reference).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="tf-instance",
            clusters=[{
                "cluster_id": "tf-instance-cluster",
                "zone": "us-central1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }])
        table = gcp.bigtable.Table("table",
            name="tf-table",
            instance_name=instance.name,
            split_keys=[
                "a",
                "b",
                "c",
            ],
            column_families=[
                {
                    "family": "family-first",
                },
                {
                    "family": "family-second",
                    "type": "intsum",
                },
                {
                    "family": "family-third",
                    "type": \"\"\"        {
        \\t\\t\\t\\t\\t\\"aggregateType\\": {
        \\t\\t\\t\\t\\t\\t\\"max\\": {},
        \\t\\t\\t\\t\\t\\t\\"inputType\\": {
        \\t\\t\\t\\t\\t\\t\\t\\"int64Type\\": {
        \\t\\t\\t\\t\\t\\t\\t\\t\\"encoding\\": {
        \\t\\t\\t\\t\\t\\t\\t\\t\\t\\"bigEndianBytes\\": {}
        \\t\\t\\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t}
        \\t\\t\\t\\t}
        \"\"\",
                },
            ],
            change_stream_retention="24h0m0s",
            automated_backup_policy={
                "retention_period": "72h0m0s",
                "frequency": "24h0m0s",
            })
        ```

        ## Import

        -> **Fields affected by import** The following fields can't be read and will show diffs if set in config when imported: `split_keys`

        Bigtable Tables can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance_name}}/tables/{{name}}`

        * `{{project}}/{{instance_name}}/{{name}}`

        * `{{instance_name}}/{{name}}`

        When using the `pulumi import` command, Bigtable Tables can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/table:Table default projects/{{project}}/instances/{{instance_name}}/tables/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/table:Table default {{project}}/{{instance_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/table:Table default {{instance_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableAutomatedBackupPolicyArgs', 'TableAutomatedBackupPolicyArgsDict']] automated_backup_policy: Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.
               
               -----
        :param pulumi.Input[_builtins.str] change_stream_retention: Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableColumnFamilyArgs', 'TableColumnFamilyArgsDict']]]] column_families: A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        :param pulumi.Input[_builtins.str] deletion_protection: A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance.
        :param pulumi.Input[_builtins.str] name: The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] row_key_schema: Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
               					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
               				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
               					
               					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
               					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] split_keys: A list of predefined keys to split the table on.
               !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
               to delete/recreate the entire `bigtable.Table` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Google Cloud Bigtable table inside an instance. For more information see
        [the official documentation](https://cloud.google.com/bigtable/) and
        [API](https://cloud.google.com/bigtable/docs/go/reference).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.bigtable.Instance("instance",
            name="tf-instance",
            clusters=[{
                "cluster_id": "tf-instance-cluster",
                "zone": "us-central1-b",
                "num_nodes": 3,
                "storage_type": "HDD",
            }])
        table = gcp.bigtable.Table("table",
            name="tf-table",
            instance_name=instance.name,
            split_keys=[
                "a",
                "b",
                "c",
            ],
            column_families=[
                {
                    "family": "family-first",
                },
                {
                    "family": "family-second",
                    "type": "intsum",
                },
                {
                    "family": "family-third",
                    "type": \"\"\"        {
        \\t\\t\\t\\t\\t\\"aggregateType\\": {
        \\t\\t\\t\\t\\t\\t\\"max\\": {},
        \\t\\t\\t\\t\\t\\t\\"inputType\\": {
        \\t\\t\\t\\t\\t\\t\\t\\"int64Type\\": {
        \\t\\t\\t\\t\\t\\t\\t\\t\\"encoding\\": {
        \\t\\t\\t\\t\\t\\t\\t\\t\\t\\"bigEndianBytes\\": {}
        \\t\\t\\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t\\t}
        \\t\\t\\t\\t\\t}
        \\t\\t\\t\\t}
        \"\"\",
                },
            ],
            change_stream_retention="24h0m0s",
            automated_backup_policy={
                "retention_period": "72h0m0s",
                "frequency": "24h0m0s",
            })
        ```

        ## Import

        -> **Fields affected by import** The following fields can't be read and will show diffs if set in config when imported: `split_keys`

        Bigtable Tables can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance_name}}/tables/{{name}}`

        * `{{project}}/{{instance_name}}/{{name}}`

        * `{{instance_name}}/{{name}}`

        When using the `pulumi import` command, Bigtable Tables can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/table:Table default projects/{{project}}/instances/{{instance_name}}/tables/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/table:Table default {{project}}/{{instance_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/table:Table default {{instance_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_backup_policy: Optional[pulumi.Input[Union['TableAutomatedBackupPolicyArgs', 'TableAutomatedBackupPolicyArgsDict']]] = None,
                 change_stream_retention: Optional[pulumi.Input[_builtins.str]] = None,
                 column_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnFamilyArgs', 'TableColumnFamilyArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 split_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableArgs.__new__(TableArgs)

            __props__.__dict__["automated_backup_policy"] = automated_backup_policy
            __props__.__dict__["change_stream_retention"] = change_stream_retention
            __props__.__dict__["column_families"] = column_families
            __props__.__dict__["deletion_protection"] = deletion_protection
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["row_key_schema"] = row_key_schema
            __props__.__dict__["split_keys"] = split_keys
        super(Table, __self__).__init__(
            'gcp:bigtable/table:Table',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automated_backup_policy: Optional[pulumi.Input[Union['TableAutomatedBackupPolicyArgs', 'TableAutomatedBackupPolicyArgsDict']]] = None,
            change_stream_retention: Optional[pulumi.Input[_builtins.str]] = None,
            column_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableColumnFamilyArgs', 'TableColumnFamilyArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            row_key_schema: Optional[pulumi.Input[_builtins.str]] = None,
            split_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Table':
        """
        Get an existing Table resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableAutomatedBackupPolicyArgs', 'TableAutomatedBackupPolicyArgsDict']] automated_backup_policy: Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.
               
               -----
        :param pulumi.Input[_builtins.str] change_stream_retention: Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableColumnFamilyArgs', 'TableColumnFamilyArgsDict']]]] column_families: A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        :param pulumi.Input[_builtins.str] deletion_protection: A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        :param pulumi.Input[_builtins.str] instance_name: The name of the Bigtable instance.
        :param pulumi.Input[_builtins.str] name: The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] row_key_schema: Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
               					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
               				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
               					
               					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
               					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] split_keys: A list of predefined keys to split the table on.
               !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
               to delete/recreate the entire `bigtable.Table` resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableState.__new__(_TableState)

        __props__.__dict__["automated_backup_policy"] = automated_backup_policy
        __props__.__dict__["change_stream_retention"] = change_stream_retention
        __props__.__dict__["column_families"] = column_families
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["row_key_schema"] = row_key_schema
        __props__.__dict__["split_keys"] = split_keys
        return Table(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> pulumi.Output['outputs.TableAutomatedBackupPolicy']:
        """
        Defines an automated backup policy for a table, specified by Retention Period and Frequency. To _create_ a table with automated backup disabled, either omit the automated_backup_policy argument, or set both Retention Period and Frequency properties to "0". To disable automated backup on an _existing_ table that has automated backup enabled, set _both_ Retention Period and Frequency properties to "0". When updating an existing table, to modify the Retention Period or Frequency properties of the resource's automated backup policy, set the respective property to a non-zero value. If the automated_backup_policy argument is not provided in the configuration on update, the resource's automated backup policy will _not_ be modified.

        -----
        """
        return pulumi.get(self, "automated_backup_policy")

    @_builtins.property
    @pulumi.getter(name="changeStreamRetention")
    def change_stream_retention(self) -> pulumi.Output[_builtins.str]:
        """
        Duration to retain change stream data for the table. Set to 0 to disable. Must be between 1 and 7 days.
        """
        return pulumi.get(self, "change_stream_retention")

    @_builtins.property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> pulumi.Output[Optional[Sequence['outputs.TableColumnFamily']]]:
        """
        A group of columns within a table which share a common configuration. This can be specified multiple times. Structure is documented below.
        """
        return pulumi.get(self, "column_families")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.str]:
        """
        A field to make the table protected against data loss i.e. when set to PROTECTED, deleting the table, the column families in the table, and the instance containing the table would be prohibited. If not provided, deletion protection will be set to UNPROTECTED.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Bigtable instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the table. Must be 1-50 characters and must only contain hyphens, underscores, periods, letters and numbers.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="rowKeySchema")
    def row_key_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines the row key schema of a table. To create or update a table with a row key schema, specify this argument.
        					Note that in-place update is not supported, and any in-place modification to the schema will lead to failure.
        				    To update a schema, please clear it (by omitting the field), and update the resource again with a new schema.\\n
        					
        					The schema must be a valid JSON encoded string representing a Type's struct protobuf message. Note that for bytes sequence (like delimited_bytes.delimiter)
        					the delimiter must be base64 encoded. For example, if you want to set a delimiter to a single byte character "#", it should be set to "Iw==", which is the base64 encoding of the byte sequence "#".
        """
        return pulumi.get(self, "row_key_schema")

    @_builtins.property
    @pulumi.getter(name="splitKeys")
    def split_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of predefined keys to split the table on.
        !> **Warning:** Modifying the `split_keys` of an existing table will cause the provider
        to delete/recreate the entire `bigtable.Table` resource.
        """
        return pulumi.get(self, "split_keys")

