# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AuthorityAccessUrl',
    'AuthorityConfig',
    'AuthorityConfigSubjectConfig',
    'AuthorityConfigSubjectConfigSubject',
    'AuthorityConfigSubjectConfigSubjectAltName',
    'AuthorityConfigSubjectKeyId',
    'AuthorityConfigX509Config',
    'AuthorityConfigX509ConfigAdditionalExtension',
    'AuthorityConfigX509ConfigAdditionalExtensionObjectId',
    'AuthorityConfigX509ConfigCaOptions',
    'AuthorityConfigX509ConfigKeyUsage',
    'AuthorityConfigX509ConfigKeyUsageBaseKeyUsage',
    'AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage',
    'AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage',
    'AuthorityConfigX509ConfigNameConstraints',
    'AuthorityConfigX509ConfigPolicyId',
    'AuthorityKeySpec',
    'AuthoritySubordinateConfig',
    'AuthoritySubordinateConfigPemIssuerChain',
    'AuthorityUserDefinedAccessUrls',
    'CaPoolEncryptionSpec',
    'CaPoolIamBindingCondition',
    'CaPoolIamMemberCondition',
    'CaPoolIssuancePolicy',
    'CaPoolIssuancePolicyAllowedIssuanceModes',
    'CaPoolIssuancePolicyAllowedKeyType',
    'CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve',
    'CaPoolIssuancePolicyAllowedKeyTypeRsa',
    'CaPoolIssuancePolicyBaselineValues',
    'CaPoolIssuancePolicyBaselineValuesAdditionalExtension',
    'CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId',
    'CaPoolIssuancePolicyBaselineValuesCaOptions',
    'CaPoolIssuancePolicyBaselineValuesKeyUsage',
    'CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage',
    'CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage',
    'CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage',
    'CaPoolIssuancePolicyBaselineValuesNameConstraints',
    'CaPoolIssuancePolicyBaselineValuesPolicyId',
    'CaPoolIssuancePolicyIdentityConstraints',
    'CaPoolIssuancePolicyIdentityConstraintsCelExpression',
    'CaPoolPublishingOptions',
    'CertificateCertificateDescription',
    'CertificateCertificateDescriptionAuthorityKeyId',
    'CertificateCertificateDescriptionCertFingerprint',
    'CertificateCertificateDescriptionPublicKey',
    'CertificateCertificateDescriptionSubjectDescription',
    'CertificateCertificateDescriptionSubjectDescriptionSubject',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltName',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan',
    'CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId',
    'CertificateCertificateDescriptionSubjectKeyId',
    'CertificateCertificateDescriptionX509Description',
    'CertificateCertificateDescriptionX509DescriptionAdditionalExtension',
    'CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId',
    'CertificateCertificateDescriptionX509DescriptionCaOption',
    'CertificateCertificateDescriptionX509DescriptionKeyUsage',
    'CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage',
    'CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage',
    'CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage',
    'CertificateCertificateDescriptionX509DescriptionNameConstraint',
    'CertificateCertificateDescriptionX509DescriptionPolicyId',
    'CertificateConfig',
    'CertificateConfigPublicKey',
    'CertificateConfigSubjectConfig',
    'CertificateConfigSubjectConfigSubject',
    'CertificateConfigSubjectConfigSubjectAltName',
    'CertificateConfigSubjectKeyId',
    'CertificateConfigX509Config',
    'CertificateConfigX509ConfigAdditionalExtension',
    'CertificateConfigX509ConfigAdditionalExtensionObjectId',
    'CertificateConfigX509ConfigCaOptions',
    'CertificateConfigX509ConfigKeyUsage',
    'CertificateConfigX509ConfigKeyUsageBaseKeyUsage',
    'CertificateConfigX509ConfigKeyUsageExtendedKeyUsage',
    'CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage',
    'CertificateConfigX509ConfigNameConstraints',
    'CertificateConfigX509ConfigPolicyId',
    'CertificateRevocationDetail',
    'CertificateTemplateIamBindingCondition',
    'CertificateTemplateIamMemberCondition',
    'CertificateTemplateIdentityConstraints',
    'CertificateTemplateIdentityConstraintsCelExpression',
    'CertificateTemplatePassthroughExtensions',
    'CertificateTemplatePassthroughExtensionsAdditionalExtension',
    'CertificateTemplatePredefinedValues',
    'CertificateTemplatePredefinedValuesAdditionalExtension',
    'CertificateTemplatePredefinedValuesAdditionalExtensionObjectId',
    'CertificateTemplatePredefinedValuesCaOptions',
    'CertificateTemplatePredefinedValuesKeyUsage',
    'CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage',
    'CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage',
    'CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage',
    'CertificateTemplatePredefinedValuesNameConstraints',
    'CertificateTemplatePredefinedValuesPolicyId',
    'GetAuthorityAccessUrlResult',
    'GetAuthorityConfigResult',
    'GetAuthorityConfigSubjectConfigResult',
    'GetAuthorityConfigSubjectConfigSubjectResult',
    'GetAuthorityConfigSubjectConfigSubjectAltNameResult',
    'GetAuthorityConfigSubjectKeyIdResult',
    'GetAuthorityConfigX509ConfigResult',
    'GetAuthorityConfigX509ConfigAdditionalExtensionResult',
    'GetAuthorityConfigX509ConfigAdditionalExtensionObjectIdResult',
    'GetAuthorityConfigX509ConfigCaOptionResult',
    'GetAuthorityConfigX509ConfigKeyUsageResult',
    'GetAuthorityConfigX509ConfigKeyUsageBaseKeyUsageResult',
    'GetAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageResult',
    'GetAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageResult',
    'GetAuthorityConfigX509ConfigNameConstraintResult',
    'GetAuthorityConfigX509ConfigPolicyIdResult',
    'GetAuthorityKeySpecResult',
    'GetAuthoritySubordinateConfigResult',
    'GetAuthoritySubordinateConfigPemIssuerChainResult',
    'GetAuthorityUserDefinedAccessUrlResult',
]

@pulumi.output_type
class AuthorityAccessUrl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificateAccessUrl":
            suggest = "ca_certificate_access_url"
        elif key == "crlAccessUrls":
            suggest = "crl_access_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityAccessUrl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityAccessUrl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityAccessUrl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate_access_url: Optional[_builtins.str] = None,
                 crl_access_urls: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str ca_certificate_access_url: (Output)
               The URL where this CertificateAuthority's CA certificate is published. This will only be
               set for CAs that have been activated.
        :param Sequence[_builtins.str] crl_access_urls: (Output)
               The URL where this CertificateAuthority's CRLs are published. This will only be set for
               CAs that have been activated.
        """
        if ca_certificate_access_url is not None:
            pulumi.set(__self__, "ca_certificate_access_url", ca_certificate_access_url)
        if crl_access_urls is not None:
            pulumi.set(__self__, "crl_access_urls", crl_access_urls)

    @_builtins.property
    @pulumi.getter(name="caCertificateAccessUrl")
    def ca_certificate_access_url(self) -> Optional[_builtins.str]:
        """
        (Output)
        The URL where this CertificateAuthority's CA certificate is published. This will only be
        set for CAs that have been activated.
        """
        return pulumi.get(self, "ca_certificate_access_url")

    @_builtins.property
    @pulumi.getter(name="crlAccessUrls")
    def crl_access_urls(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        The URL where this CertificateAuthority's CRLs are published. This will only be set for
        CAs that have been activated.
        """
        return pulumi.get(self, "crl_access_urls")


@pulumi.output_type
class AuthorityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectConfig":
            suggest = "subject_config"
        elif key == "x509Config":
            suggest = "x509_config"
        elif key == "subjectKeyId":
            suggest = "subject_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject_config: 'outputs.AuthorityConfigSubjectConfig',
                 x509_config: 'outputs.AuthorityConfigX509Config',
                 subject_key_id: Optional['outputs.AuthorityConfigSubjectKeyId'] = None):
        """
        :param 'AuthorityConfigSubjectConfigArgs' subject_config: Specifies some of the values in a certificate that are related to the subject.
               Structure is documented below.
        :param 'AuthorityConfigX509ConfigArgs' x509_config: Describes how some of the technical X.509 fields in a certificate should be populated.
               Structure is documented below.
        :param 'AuthorityConfigSubjectKeyIdArgs' subject_key_id: When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
               Structure is documented below.
        """
        pulumi.set(__self__, "subject_config", subject_config)
        pulumi.set(__self__, "x509_config", x509_config)
        if subject_key_id is not None:
            pulumi.set(__self__, "subject_key_id", subject_key_id)

    @_builtins.property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.AuthorityConfigSubjectConfig':
        """
        Specifies some of the values in a certificate that are related to the subject.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_config")

    @_builtins.property
    @pulumi.getter(name="x509Config")
    def x509_config(self) -> 'outputs.AuthorityConfigX509Config':
        """
        Describes how some of the technical X.509 fields in a certificate should be populated.
        Structure is documented below.
        """
        return pulumi.get(self, "x509_config")

    @_builtins.property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> Optional['outputs.AuthorityConfigSubjectKeyId']:
        """
        When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
        Structure is documented below.
        """
        return pulumi.get(self, "subject_key_id")


@pulumi.output_type
class AuthorityConfigSubjectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: 'outputs.AuthorityConfigSubjectConfigSubject',
                 subject_alt_name: Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName'] = None):
        """
        :param 'AuthorityConfigSubjectConfigSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'AuthorityConfigSubjectConfigSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> 'outputs.AuthorityConfigSubjectConfigSubject':
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.AuthorityConfigSubjectConfigSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class AuthorityConfigSubjectConfigSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfigSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfigSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfigSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: _builtins.str,
                 country_code: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 organizational_unit: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 street_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str common_name: The common name of the distinguished name.
        :param _builtins.str country_code: The country code of the subject.
        :param _builtins.str locality: The locality or city of the subject.
        :param _builtins.str organization: The organization of the subject.
        :param _builtins.str organizational_unit: The organizational unit of the subject.
        :param _builtins.str postal_code: The postal code of the subject.
        :param _builtins.str province: The province, territory, or regional state of the subject.
        :param _builtins.str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "common_name", common_name)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[_builtins.str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[_builtins.str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[_builtins.str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class AuthorityConfigSubjectConfigSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectConfigSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[_builtins.str]] = None,
                 email_addresses: Optional[Sequence[_builtins.str]] = None,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[_builtins.str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[_builtins.str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[_builtins.str] uris: Contains only valid RFC 3986 URIs.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class AuthorityConfigSubjectKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigSubjectKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigSubjectKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigSubjectKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: The value of the KeyId in lowercase hexadecimal.
               
               <a name="nested_config_x509_config"></a>The `x509_config` block supports:
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The value of the KeyId in lowercase hexadecimal.

        <a name="nested_config_x509_config"></a>The `x509_config` block supports:
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class AuthorityConfigX509Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caOptions":
            suggest = "ca_options"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "nameConstraints":
            suggest = "name_constraints"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_options: 'outputs.AuthorityConfigX509ConfigCaOptions',
                 key_usage: 'outputs.AuthorityConfigX509ConfigKeyUsage',
                 additional_extensions: Optional[Sequence['outputs.AuthorityConfigX509ConfigAdditionalExtension']] = None,
                 aia_ocsp_servers: Optional[Sequence[_builtins.str]] = None,
                 name_constraints: Optional['outputs.AuthorityConfigX509ConfigNameConstraints'] = None,
                 policy_ids: Optional[Sequence['outputs.AuthorityConfigX509ConfigPolicyId']] = None):
        """
        :param 'AuthorityConfigX509ConfigCaOptionsArgs' ca_options: Describes values that are relevant in a CA certificate.
        :param 'AuthorityConfigX509ConfigKeyUsageArgs' key_usage: Indicates the intended use for keys that correspond to a certificate.
        :param Sequence['AuthorityConfigX509ConfigAdditionalExtensionArgs'] additional_extensions: Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        :param Sequence[_builtins.str] aia_ocsp_servers: Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
               "Authority Information Access" extension in the certificate.
        :param 'AuthorityConfigX509ConfigNameConstraintsArgs' name_constraints: Describes the X.509 name constraints extension.
        :param Sequence['AuthorityConfigX509ConfigPolicyIdArgs'] policy_ids: Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        pulumi.set(__self__, "ca_options", ca_options)
        pulumi.set(__self__, "key_usage", key_usage)
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if name_constraints is not None:
            pulumi.set(__self__, "name_constraints", name_constraints)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> 'outputs.AuthorityConfigX509ConfigCaOptions':
        """
        Describes values that are relevant in a CA certificate.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> 'outputs.AuthorityConfigX509ConfigKeyUsage':
        """
        Indicates the intended use for keys that correspond to a certificate.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.AuthorityConfigX509ConfigAdditionalExtension']]:
        """
        Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
        "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Optional['outputs.AuthorityConfigX509ConfigNameConstraints']:
        """
        Describes the X.509 name constraints extension.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[Sequence['outputs.AuthorityConfigX509ConfigPolicyId']]:
        """
        Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class AuthorityConfigX509ConfigAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 object_id: 'outputs.AuthorityConfigX509ConfigAdditionalExtensionObjectId',
                 value: _builtins.str):
        """
        :param _builtins.bool critical: Indicates whether or not this extension is critical (i.e., if the client does not know how to
               handle this extension, the client should consider this to be an error).
        :param 'AuthorityConfigX509ConfigAdditionalExtensionObjectIdArgs' object_id: Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not this extension is critical (i.e., if the client does not know how to
        handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> 'outputs.AuthorityConfigX509ConfigAdditionalExtensionObjectId':
        """
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AuthorityConfigX509ConfigAdditionalExtensionObjectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigAdditionalExtensionObjectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigAdditionalExtensionObjectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigAdditionalExtensionObjectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class AuthorityConfigX509ConfigCaOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"
        elif key == "nonCa":
            suggest = "non_ca"
        elif key == "zeroMaxIssuerPathLength":
            suggest = "zero_max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigCaOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigCaOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigCaOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: _builtins.bool,
                 max_issuer_path_length: Optional[_builtins.int] = None,
                 non_ca: Optional[_builtins.bool] = None,
                 zero_max_issuer_path_length: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_ca: When true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. Setting the value to 0
               requires setting `zero_max_issuer_path_length = true`.
        :param _builtins.bool non_ca: When true, the "CA" in Basic Constraints extension will be set to false.
               If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        :param _builtins.bool zero_max_issuer_path_length: When true, the "path length constraint" in Basic Constraints extension will be set to 0.
               If both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
               the max path length will be omitted from the CA certificate.
        """
        pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)
        if non_ca is not None:
            pulumi.set(__self__, "non_ca", non_ca)
        if zero_max_issuer_path_length is not None:
            pulumi.set(__self__, "zero_max_issuer_path_length", zero_max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> _builtins.bool:
        """
        When true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[_builtins.int]:
        """
        Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. Setting the value to 0
        requires setting `zero_max_issuer_path_length = true`.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @_builtins.property
    @pulumi.getter(name="nonCa")
    def non_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to false.
        If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "non_ca")

    @_builtins.property
    @pulumi.getter(name="zeroMaxIssuerPathLength")
    def zero_max_issuer_path_length(self) -> Optional[_builtins.bool]:
        """
        When true, the "path length constraint" in Basic Constraints extension will be set to 0.
        If both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
        the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "zero_max_issuer_path_length")


@pulumi.output_type
class AuthorityConfigX509ConfigKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usage: 'outputs.AuthorityConfigX509ConfigKeyUsageBaseKeyUsage',
                 extended_key_usage: 'outputs.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage',
                 unknown_extended_key_usages: Optional[Sequence['outputs.AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage']] = None):
        """
        :param 'AuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs' base_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param 'AuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs' extended_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param Sequence['AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
               Structure is documented below.
        """
        pulumi.set(__self__, "base_key_usage", base_key_usage)
        pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> 'outputs.AuthorityConfigX509ConfigKeyUsageBaseKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "base_key_usage")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> 'outputs.AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "extended_key_usage")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[Sequence['outputs.AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage']]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        Structure is documented below.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class AuthorityConfigX509ConfigKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[_builtins.bool] = None,
                 content_commitment: Optional[_builtins.bool] = None,
                 crl_sign: Optional[_builtins.bool] = None,
                 data_encipherment: Optional[_builtins.bool] = None,
                 decipher_only: Optional[_builtins.bool] = None,
                 digital_signature: Optional[_builtins.bool] = None,
                 encipher_only: Optional[_builtins.bool] = None,
                 key_agreement: Optional[_builtins.bool] = None,
                 key_encipherment: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[_builtins.bool]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[_builtins.bool]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[_builtins.bool]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[_builtins.bool] = None,
                 code_signing: Optional[_builtins.bool] = None,
                 email_protection: Optional[_builtins.bool] = None,
                 ocsp_signing: Optional[_builtins.bool] = None,
                 server_auth: Optional[_builtins.bool] = None,
                 time_stamping: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class AuthorityConfigX509ConfigNameConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedDnsNames":
            suggest = "excluded_dns_names"
        elif key == "excludedEmailAddresses":
            suggest = "excluded_email_addresses"
        elif key == "excludedIpRanges":
            suggest = "excluded_ip_ranges"
        elif key == "excludedUris":
            suggest = "excluded_uris"
        elif key == "permittedDnsNames":
            suggest = "permitted_dns_names"
        elif key == "permittedEmailAddresses":
            suggest = "permitted_email_addresses"
        elif key == "permittedIpRanges":
            suggest = "permitted_ip_ranges"
        elif key == "permittedUris":
            suggest = "permitted_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigNameConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigNameConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigNameConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 excluded_dns_names: Optional[Sequence[_builtins.str]] = None,
                 excluded_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 excluded_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 excluded_uris: Optional[Sequence[_builtins.str]] = None,
                 permitted_dns_names: Optional[Sequence[_builtins.str]] = None,
                 permitted_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 permitted_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 permitted_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        """
        pulumi.set(__self__, "critical", critical)
        if excluded_dns_names is not None:
            pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uris is not None:
            pulumi.set(__self__, "excluded_uris", excluded_uris)
        if permitted_dns_names is not None:
            pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uris is not None:
            pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class AuthorityConfigX509ConfigPolicyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityConfigX509ConfigPolicyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityConfigX509ConfigPolicyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityConfigX509ConfigPolicyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class AuthorityKeySpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudKmsKeyVersion":
            suggest = "cloud_kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityKeySpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityKeySpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityKeySpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 cloud_kms_key_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str algorithm: The algorithm to use for creating a managed Cloud KMS key for a for a simplified
               experience. All managed keys will be have their ProtectionLevel as HSM.
               Possible values are: `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, `EC_P384_SHA384`.
        :param _builtins.str cloud_kms_key_version: The resource name for an existing Cloud KMS CryptoKeyVersion in the format
               `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if cloud_kms_key_version is not None:
            pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        The algorithm to use for creating a managed Cloud KMS key for a for a simplified
        experience. All managed keys will be have their ProtectionLevel as HSM.
        Possible values are: `SIGN_HASH_ALGORITHM_UNSPECIFIED`, `RSA_PSS_2048_SHA256`, `RSA_PSS_3072_SHA256`, `RSA_PSS_4096_SHA256`, `RSA_PKCS1_2048_SHA256`, `RSA_PKCS1_3072_SHA256`, `RSA_PKCS1_4096_SHA256`, `EC_P256_SHA256`, `EC_P384_SHA384`.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> Optional[_builtins.str]:
        """
        The resource name for an existing Cloud KMS CryptoKeyVersion in the format
        `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
        """
        return pulumi.get(self, "cloud_kms_key_version")


@pulumi.output_type
class AuthoritySubordinateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthority":
            suggest = "certificate_authority"
        elif key == "pemIssuerChain":
            suggest = "pem_issuer_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthoritySubordinateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthoritySubordinateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthoritySubordinateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority: Optional[_builtins.str] = None,
                 pem_issuer_chain: Optional['outputs.AuthoritySubordinateConfigPemIssuerChain'] = None):
        """
        :param _builtins.str certificate_authority: This can refer to a CertificateAuthority that was used to create a
               subordinate CertificateAuthority. This field is used for information
               and usability purposes only. The resource name is in the format
               `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        :param 'AuthoritySubordinateConfigPemIssuerChainArgs' pem_issuer_chain: Contains the PEM certificate chain for the issuers of this CertificateAuthority,
               but not pem certificate for this CA itself.
               Structure is documented below.
        """
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if pem_issuer_chain is not None:
            pulumi.set(__self__, "pem_issuer_chain", pem_issuer_chain)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[_builtins.str]:
        """
        This can refer to a CertificateAuthority that was used to create a
        subordinate CertificateAuthority. This field is used for information
        and usability purposes only. The resource name is in the format
        `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="pemIssuerChain")
    def pem_issuer_chain(self) -> Optional['outputs.AuthoritySubordinateConfigPemIssuerChain']:
        """
        Contains the PEM certificate chain for the issuers of this CertificateAuthority,
        but not pem certificate for this CA itself.
        Structure is documented below.
        """
        return pulumi.get(self, "pem_issuer_chain")


@pulumi.output_type
class AuthoritySubordinateConfigPemIssuerChain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificates":
            suggest = "pem_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthoritySubordinateConfigPemIssuerChain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthoritySubordinateConfigPemIssuerChain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthoritySubordinateConfigPemIssuerChain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificates: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] pem_certificates: Expected to be in leaf-to-root order according to RFC 5246.
        """
        if pem_certificates is not None:
            pulumi.set(__self__, "pem_certificates", pem_certificates)

    @_builtins.property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> Optional[Sequence[_builtins.str]]:
        """
        Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")


@pulumi.output_type
class AuthorityUserDefinedAccessUrls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aiaIssuingCertificateUrls":
            suggest = "aia_issuing_certificate_urls"
        elif key == "crlAccessUrls":
            suggest = "crl_access_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityUserDefinedAccessUrls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityUserDefinedAccessUrls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityUserDefinedAccessUrls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aia_issuing_certificate_urls: Optional[Sequence[_builtins.str]] = None,
                 crl_access_urls: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] aia_issuing_certificate_urls: A list of URLs where this CertificateAuthority's CA certificate is published that is specified by users.
        :param Sequence[_builtins.str] crl_access_urls: A list of URLs where this CertificateAuthority's CRLs are published that is specified by users.
        """
        if aia_issuing_certificate_urls is not None:
            pulumi.set(__self__, "aia_issuing_certificate_urls", aia_issuing_certificate_urls)
        if crl_access_urls is not None:
            pulumi.set(__self__, "crl_access_urls", crl_access_urls)

    @_builtins.property
    @pulumi.getter(name="aiaIssuingCertificateUrls")
    def aia_issuing_certificate_urls(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of URLs where this CertificateAuthority's CA certificate is published that is specified by users.
        """
        return pulumi.get(self, "aia_issuing_certificate_urls")

    @_builtins.property
    @pulumi.getter(name="crlAccessUrls")
    def crl_access_urls(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of URLs where this CertificateAuthority's CRLs are published that is specified by users.
        """
        return pulumi.get(self, "crl_access_urls")


@pulumi.output_type
class CaPoolEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudKmsKey":
            suggest = "cloud_kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_kms_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str cloud_kms_key: The resource name for an existing Cloud KMS key in the format
               `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        if cloud_kms_key is not None:
            pulumi.set(__self__, "cloud_kms_key", cloud_kms_key)

    @_builtins.property
    @pulumi.getter(name="cloudKmsKey")
    def cloud_kms_key(self) -> Optional[_builtins.str]:
        """
        The resource name for an existing Cloud KMS key in the format
        `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "cloud_kms_key")


@pulumi.output_type
class CaPoolIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class CaPoolIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class CaPoolIssuancePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIssuanceModes":
            suggest = "allowed_issuance_modes"
        elif key == "allowedKeyTypes":
            suggest = "allowed_key_types"
        elif key == "backdateDuration":
            suggest = "backdate_duration"
        elif key == "baselineValues":
            suggest = "baseline_values"
        elif key == "identityConstraints":
            suggest = "identity_constraints"
        elif key == "maximumLifetime":
            suggest = "maximum_lifetime"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_issuance_modes: Optional['outputs.CaPoolIssuancePolicyAllowedIssuanceModes'] = None,
                 allowed_key_types: Optional[Sequence['outputs.CaPoolIssuancePolicyAllowedKeyType']] = None,
                 backdate_duration: Optional[_builtins.str] = None,
                 baseline_values: Optional['outputs.CaPoolIssuancePolicyBaselineValues'] = None,
                 identity_constraints: Optional['outputs.CaPoolIssuancePolicyIdentityConstraints'] = None,
                 maximum_lifetime: Optional[_builtins.str] = None):
        """
        :param 'CaPoolIssuancePolicyAllowedIssuanceModesArgs' allowed_issuance_modes: IssuanceModes specifies the allowed ways in which Certificates may be requested from this CaPool.
               Structure is documented below.
        :param Sequence['CaPoolIssuancePolicyAllowedKeyTypeArgs'] allowed_key_types: If any AllowedKeyType is specified, then the certificate request's public key must match one of the key types listed here.
               Otherwise, any key may be used. You can specify only one key type of those listed here.
               Structure is documented below.
        :param _builtins.str backdate_duration: The duration to backdate all certificates issued from this CaPool. If not set, the
               certificates will be issued with a not_before_time of the issuance time (i.e. the current
               time). If set, the certificates will be issued with a not_before_time of the issuance
               time minus the backdate_duration. The not_after_time will be adjusted to preserve the
               requested lifetime. The backdate_duration must be less than or equal to 48 hours.
        :param 'CaPoolIssuancePolicyBaselineValuesArgs' baseline_values: A set of X.509 values that will be applied to all certificates issued through this CaPool. If a certificate request
               includes conflicting values for the same properties, they will be overwritten by the values defined here. If a certificate
               request uses a CertificateTemplate that defines conflicting predefinedValues for the same properties, the certificate
               issuance request will fail.
               Structure is documented below.
        :param 'CaPoolIssuancePolicyIdentityConstraintsArgs' identity_constraints: Describes constraints on identities that may appear in Certificates issued through this CaPool.
               If this is omitted, then this CaPool will not add restrictions on a certificate's identity.
               Structure is documented below.
        :param _builtins.str maximum_lifetime: The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority
               expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
        """
        if allowed_issuance_modes is not None:
            pulumi.set(__self__, "allowed_issuance_modes", allowed_issuance_modes)
        if allowed_key_types is not None:
            pulumi.set(__self__, "allowed_key_types", allowed_key_types)
        if backdate_duration is not None:
            pulumi.set(__self__, "backdate_duration", backdate_duration)
        if baseline_values is not None:
            pulumi.set(__self__, "baseline_values", baseline_values)
        if identity_constraints is not None:
            pulumi.set(__self__, "identity_constraints", identity_constraints)
        if maximum_lifetime is not None:
            pulumi.set(__self__, "maximum_lifetime", maximum_lifetime)

    @_builtins.property
    @pulumi.getter(name="allowedIssuanceModes")
    def allowed_issuance_modes(self) -> Optional['outputs.CaPoolIssuancePolicyAllowedIssuanceModes']:
        """
        IssuanceModes specifies the allowed ways in which Certificates may be requested from this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_issuance_modes")

    @_builtins.property
    @pulumi.getter(name="allowedKeyTypes")
    def allowed_key_types(self) -> Optional[Sequence['outputs.CaPoolIssuancePolicyAllowedKeyType']]:
        """
        If any AllowedKeyType is specified, then the certificate request's public key must match one of the key types listed here.
        Otherwise, any key may be used. You can specify only one key type of those listed here.
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_key_types")

    @_builtins.property
    @pulumi.getter(name="backdateDuration")
    def backdate_duration(self) -> Optional[_builtins.str]:
        """
        The duration to backdate all certificates issued from this CaPool. If not set, the
        certificates will be issued with a not_before_time of the issuance time (i.e. the current
        time). If set, the certificates will be issued with a not_before_time of the issuance
        time minus the backdate_duration. The not_after_time will be adjusted to preserve the
        requested lifetime. The backdate_duration must be less than or equal to 48 hours.
        """
        return pulumi.get(self, "backdate_duration")

    @_builtins.property
    @pulumi.getter(name="baselineValues")
    def baseline_values(self) -> Optional['outputs.CaPoolIssuancePolicyBaselineValues']:
        """
        A set of X.509 values that will be applied to all certificates issued through this CaPool. If a certificate request
        includes conflicting values for the same properties, they will be overwritten by the values defined here. If a certificate
        request uses a CertificateTemplate that defines conflicting predefinedValues for the same properties, the certificate
        issuance request will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "baseline_values")

    @_builtins.property
    @pulumi.getter(name="identityConstraints")
    def identity_constraints(self) -> Optional['outputs.CaPoolIssuancePolicyIdentityConstraints']:
        """
        Describes constraints on identities that may appear in Certificates issued through this CaPool.
        If this is omitted, then this CaPool will not add restrictions on a certificate's identity.
        Structure is documented below.
        """
        return pulumi.get(self, "identity_constraints")

    @_builtins.property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> Optional[_builtins.str]:
        """
        The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority
        expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
        """
        return pulumi.get(self, "maximum_lifetime")


@pulumi.output_type
class CaPoolIssuancePolicyAllowedIssuanceModes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowConfigBasedIssuance":
            suggest = "allow_config_based_issuance"
        elif key == "allowCsrBasedIssuance":
            suggest = "allow_csr_based_issuance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyAllowedIssuanceModes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyAllowedIssuanceModes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyAllowedIssuanceModes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_config_based_issuance: _builtins.bool,
                 allow_csr_based_issuance: _builtins.bool):
        """
        :param _builtins.bool allow_config_based_issuance: When true, allows callers to create Certificates by specifying a CertificateConfig.
        :param _builtins.bool allow_csr_based_issuance: When true, allows callers to create Certificates by specifying a CSR.
        """
        pulumi.set(__self__, "allow_config_based_issuance", allow_config_based_issuance)
        pulumi.set(__self__, "allow_csr_based_issuance", allow_csr_based_issuance)

    @_builtins.property
    @pulumi.getter(name="allowConfigBasedIssuance")
    def allow_config_based_issuance(self) -> _builtins.bool:
        """
        When true, allows callers to create Certificates by specifying a CertificateConfig.
        """
        return pulumi.get(self, "allow_config_based_issuance")

    @_builtins.property
    @pulumi.getter(name="allowCsrBasedIssuance")
    def allow_csr_based_issuance(self) -> _builtins.bool:
        """
        When true, allows callers to create Certificates by specifying a CSR.
        """
        return pulumi.get(self, "allow_csr_based_issuance")


@pulumi.output_type
class CaPoolIssuancePolicyAllowedKeyType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ellipticCurve":
            suggest = "elliptic_curve"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyAllowedKeyType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyAllowedKeyType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyAllowedKeyType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elliptic_curve: Optional['outputs.CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve'] = None,
                 rsa: Optional['outputs.CaPoolIssuancePolicyAllowedKeyTypeRsa'] = None):
        """
        :param 'CaPoolIssuancePolicyAllowedKeyTypeEllipticCurveArgs' elliptic_curve: Represents an allowed Elliptic Curve key type.
               Structure is documented below.
        :param 'CaPoolIssuancePolicyAllowedKeyTypeRsaArgs' rsa: Describes an RSA key that may be used in a Certificate issued from a CaPool.
               Structure is documented below.
        """
        if elliptic_curve is not None:
            pulumi.set(__self__, "elliptic_curve", elliptic_curve)
        if rsa is not None:
            pulumi.set(__self__, "rsa", rsa)

    @_builtins.property
    @pulumi.getter(name="ellipticCurve")
    def elliptic_curve(self) -> Optional['outputs.CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve']:
        """
        Represents an allowed Elliptic Curve key type.
        Structure is documented below.
        """
        return pulumi.get(self, "elliptic_curve")

    @_builtins.property
    @pulumi.getter
    def rsa(self) -> Optional['outputs.CaPoolIssuancePolicyAllowedKeyTypeRsa']:
        """
        Describes an RSA key that may be used in a Certificate issued from a CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "rsa")


@pulumi.output_type
class CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureAlgorithm":
            suggest = "signature_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyAllowedKeyTypeEllipticCurve.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signature_algorithm: _builtins.str):
        """
        :param _builtins.str signature_algorithm: The algorithm used.
               Possible values are: `ECDSA_P256`, `ECDSA_P384`, `EDDSA_25519`.
        """
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> _builtins.str:
        """
        The algorithm used.
        Possible values are: `ECDSA_P256`, `ECDSA_P384`, `EDDSA_25519`.
        """
        return pulumi.get(self, "signature_algorithm")


@pulumi.output_type
class CaPoolIssuancePolicyAllowedKeyTypeRsa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxModulusSize":
            suggest = "max_modulus_size"
        elif key == "minModulusSize":
            suggest = "min_modulus_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyAllowedKeyTypeRsa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyAllowedKeyTypeRsa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyAllowedKeyTypeRsa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_modulus_size: Optional[_builtins.str] = None,
                 min_modulus_size: Optional[_builtins.str] = None):
        """
        :param _builtins.str max_modulus_size: The maximum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
               service will not enforce an explicit upper bound on RSA modulus sizes.
        :param _builtins.str min_modulus_size: The minimum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
               service-level min RSA modulus size will continue to apply.
        """
        if max_modulus_size is not None:
            pulumi.set(__self__, "max_modulus_size", max_modulus_size)
        if min_modulus_size is not None:
            pulumi.set(__self__, "min_modulus_size", min_modulus_size)

    @_builtins.property
    @pulumi.getter(name="maxModulusSize")
    def max_modulus_size(self) -> Optional[_builtins.str]:
        """
        The maximum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
        service will not enforce an explicit upper bound on RSA modulus sizes.
        """
        return pulumi.get(self, "max_modulus_size")

    @_builtins.property
    @pulumi.getter(name="minModulusSize")
    def min_modulus_size(self) -> Optional[_builtins.str]:
        """
        The minimum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
        service-level min RSA modulus size will continue to apply.
        """
        return pulumi.get(self, "min_modulus_size")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caOptions":
            suggest = "ca_options"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "nameConstraints":
            suggest = "name_constraints"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_options: 'outputs.CaPoolIssuancePolicyBaselineValuesCaOptions',
                 key_usage: 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsage',
                 additional_extensions: Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesAdditionalExtension']] = None,
                 aia_ocsp_servers: Optional[Sequence[_builtins.str]] = None,
                 name_constraints: Optional['outputs.CaPoolIssuancePolicyBaselineValuesNameConstraints'] = None,
                 policy_ids: Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesPolicyId']] = None):
        """
        :param 'CaPoolIssuancePolicyBaselineValuesCaOptionsArgs' ca_options: Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param 'CaPoolIssuancePolicyBaselineValuesKeyUsageArgs' key_usage: Indicates the intended use for keys that correspond to a certificate.
               Structure is documented below.
        :param Sequence['CaPoolIssuancePolicyBaselineValuesAdditionalExtensionArgs'] additional_extensions: Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
               Structure is documented below.
        :param Sequence[_builtins.str] aia_ocsp_servers: Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
               "Authority Information Access" extension in the certificate.
        :param 'CaPoolIssuancePolicyBaselineValuesNameConstraintsArgs' name_constraints: Describes the X.509 name constraints extension.
               Structure is documented below.
        :param Sequence['CaPoolIssuancePolicyBaselineValuesPolicyIdArgs'] policy_ids: Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
               Structure is documented below.
        """
        pulumi.set(__self__, "ca_options", ca_options)
        pulumi.set(__self__, "key_usage", key_usage)
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if name_constraints is not None:
            pulumi.set(__self__, "name_constraints", name_constraints)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> 'outputs.CaPoolIssuancePolicyBaselineValuesCaOptions':
        """
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsage':
        """
        Indicates the intended use for keys that correspond to a certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesAdditionalExtension']]:
        """
        Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
        "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Optional['outputs.CaPoolIssuancePolicyBaselineValuesNameConstraints']:
        """
        Describes the X.509 name constraints extension.
        Structure is documented below.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesPolicyId']]:
        """
        Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 object_id: 'outputs.CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId',
                 value: _builtins.str):
        """
        :param _builtins.bool critical: Indicates whether or not this extension is critical (i.e., if the client does not know how to
               handle this extension, the client should consider this to be an error).
        :param 'CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectIdArgs' object_id: Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not this extension is critical (i.e., if the client does not know how to
        handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> 'outputs.CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId':
        """
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesAdditionalExtensionObjectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesCaOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"
        elif key == "nonCa":
            suggest = "non_ca"
        elif key == "zeroMaxIssuerPathLength":
            suggest = "zero_max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesCaOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesCaOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesCaOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: Optional[_builtins.bool] = None,
                 max_issuer_path_length: Optional[_builtins.int] = None,
                 non_ca: Optional[_builtins.bool] = None,
                 zero_max_issuer_path_length: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_ca: When true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        :param _builtins.bool non_ca: When true, the "CA" in Basic Constraints extension will be set to false.
               If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        :param _builtins.bool zero_max_issuer_path_length: When true, the "path length constraint" in Basic Constraints extension will be set to 0.
               if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
               the max path length will be omitted from the CA certificate.
        """
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)
        if non_ca is not None:
            pulumi.set(__self__, "non_ca", non_ca)
        if zero_max_issuer_path_length is not None:
            pulumi.set(__self__, "zero_max_issuer_path_length", zero_max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[_builtins.int]:
        """
        Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @_builtins.property
    @pulumi.getter(name="nonCa")
    def non_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to false.
        If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "non_ca")

    @_builtins.property
    @pulumi.getter(name="zeroMaxIssuerPathLength")
    def zero_max_issuer_path_length(self) -> Optional[_builtins.bool]:
        """
        When true, the "path length constraint" in Basic Constraints extension will be set to 0.
        if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
        the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "zero_max_issuer_path_length")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usage: 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage',
                 extended_key_usage: 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage',
                 unknown_extended_key_usages: Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage']] = None):
        """
        :param 'CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageArgs' base_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param 'CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageArgs' extended_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param Sequence['CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
               Structure is documented below.
        """
        pulumi.set(__self__, "base_key_usage", base_key_usage)
        pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "base_key_usage")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> 'outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "extended_key_usage")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[Sequence['outputs.CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage']]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        Structure is documented below.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[_builtins.bool] = None,
                 content_commitment: Optional[_builtins.bool] = None,
                 crl_sign: Optional[_builtins.bool] = None,
                 data_encipherment: Optional[_builtins.bool] = None,
                 decipher_only: Optional[_builtins.bool] = None,
                 digital_signature: Optional[_builtins.bool] = None,
                 encipher_only: Optional[_builtins.bool] = None,
                 key_agreement: Optional[_builtins.bool] = None,
                 key_encipherment: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[_builtins.bool]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[_builtins.bool]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[_builtins.bool]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[_builtins.bool] = None,
                 code_signing: Optional[_builtins.bool] = None,
                 email_protection: Optional[_builtins.bool] = None,
                 ocsp_signing: Optional[_builtins.bool] = None,
                 server_auth: Optional[_builtins.bool] = None,
                 time_stamping: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesNameConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedDnsNames":
            suggest = "excluded_dns_names"
        elif key == "excludedEmailAddresses":
            suggest = "excluded_email_addresses"
        elif key == "excludedIpRanges":
            suggest = "excluded_ip_ranges"
        elif key == "excludedUris":
            suggest = "excluded_uris"
        elif key == "permittedDnsNames":
            suggest = "permitted_dns_names"
        elif key == "permittedEmailAddresses":
            suggest = "permitted_email_addresses"
        elif key == "permittedIpRanges":
            suggest = "permitted_ip_ranges"
        elif key == "permittedUris":
            suggest = "permitted_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesNameConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesNameConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesNameConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 excluded_dns_names: Optional[Sequence[_builtins.str]] = None,
                 excluded_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 excluded_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 excluded_uris: Optional[Sequence[_builtins.str]] = None,
                 permitted_dns_names: Optional[Sequence[_builtins.str]] = None,
                 permitted_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 permitted_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 permitted_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        """
        pulumi.set(__self__, "critical", critical)
        if excluded_dns_names is not None:
            pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uris is not None:
            pulumi.set(__self__, "excluded_uris", excluded_uris)
        if permitted_dns_names is not None:
            pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uris is not None:
            pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class CaPoolIssuancePolicyBaselineValuesPolicyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyBaselineValuesPolicyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyBaselineValuesPolicyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyBaselineValuesPolicyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CaPoolIssuancePolicyIdentityConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSubjectAltNamesPassthrough":
            suggest = "allow_subject_alt_names_passthrough"
        elif key == "allowSubjectPassthrough":
            suggest = "allow_subject_passthrough"
        elif key == "celExpression":
            suggest = "cel_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolIssuancePolicyIdentityConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolIssuancePolicyIdentityConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolIssuancePolicyIdentityConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_subject_alt_names_passthrough: _builtins.bool,
                 allow_subject_passthrough: _builtins.bool,
                 cel_expression: Optional['outputs.CaPoolIssuancePolicyIdentityConstraintsCelExpression'] = None):
        """
        :param _builtins.bool allow_subject_alt_names_passthrough: If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
               Otherwise, the requested SubjectAltNames will be discarded.
        :param _builtins.bool allow_subject_passthrough: If this is set, the Subject field may be copied from a certificate request into the signed certificate.
               Otherwise, the requested Subject will be discarded.
        :param 'CaPoolIssuancePolicyIdentityConstraintsCelExpressionArgs' cel_expression: A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a
               certificate is signed. To see the full allowed syntax and some examples,
               see https://cloud.google.com/certificate-authority-service/docs/cel-guide
               Structure is documented below.
        """
        pulumi.set(__self__, "allow_subject_alt_names_passthrough", allow_subject_alt_names_passthrough)
        pulumi.set(__self__, "allow_subject_passthrough", allow_subject_passthrough)
        if cel_expression is not None:
            pulumi.set(__self__, "cel_expression", cel_expression)

    @_builtins.property
    @pulumi.getter(name="allowSubjectAltNamesPassthrough")
    def allow_subject_alt_names_passthrough(self) -> _builtins.bool:
        """
        If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
        Otherwise, the requested SubjectAltNames will be discarded.
        """
        return pulumi.get(self, "allow_subject_alt_names_passthrough")

    @_builtins.property
    @pulumi.getter(name="allowSubjectPassthrough")
    def allow_subject_passthrough(self) -> _builtins.bool:
        """
        If this is set, the Subject field may be copied from a certificate request into the signed certificate.
        Otherwise, the requested Subject will be discarded.
        """
        return pulumi.get(self, "allow_subject_passthrough")

    @_builtins.property
    @pulumi.getter(name="celExpression")
    def cel_expression(self) -> Optional['outputs.CaPoolIssuancePolicyIdentityConstraintsCelExpression']:
        """
        A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a
        certificate is signed. To see the full allowed syntax and some examples,
        see https://cloud.google.com/certificate-authority-service/docs/cel-guide
        Structure is documented below.
        """
        return pulumi.get(self, "cel_expression")


@pulumi.output_type
class CaPoolIssuancePolicyIdentityConstraintsCelExpression(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 title: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str description: Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param _builtins.str location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param _builtins.str title: Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        """
        Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CaPoolPublishingOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishCaCert":
            suggest = "publish_ca_cert"
        elif key == "publishCrl":
            suggest = "publish_crl"
        elif key == "encodingFormat":
            suggest = "encoding_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaPoolPublishingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaPoolPublishingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaPoolPublishingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_ca_cert: _builtins.bool,
                 publish_crl: _builtins.bool,
                 encoding_format: Optional[_builtins.str] = None):
        """
        :param _builtins.bool publish_ca_cert: When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access"
               X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding
               X.509 extension will not be written in issued certificates.
        :param _builtins.bool publish_crl: When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension
               in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not
               be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are
               also rebuilt shortly after a certificate is revoked.
        :param _builtins.str encoding_format: Specifies the encoding format of each CertificateAuthority's CA
               certificate and CRLs. If this is omitted, CA certificates and CRLs
               will be published in PEM.
               Possible values are: `PEM`, `DER`.
        """
        pulumi.set(__self__, "publish_ca_cert", publish_ca_cert)
        pulumi.set(__self__, "publish_crl", publish_crl)
        if encoding_format is not None:
            pulumi.set(__self__, "encoding_format", encoding_format)

    @_builtins.property
    @pulumi.getter(name="publishCaCert")
    def publish_ca_cert(self) -> _builtins.bool:
        """
        When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access"
        X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding
        X.509 extension will not be written in issued certificates.
        """
        return pulumi.get(self, "publish_ca_cert")

    @_builtins.property
    @pulumi.getter(name="publishCrl")
    def publish_crl(self) -> _builtins.bool:
        """
        When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension
        in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not
        be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are
        also rebuilt shortly after a certificate is revoked.
        """
        return pulumi.get(self, "publish_crl")

    @_builtins.property
    @pulumi.getter(name="encodingFormat")
    def encoding_format(self) -> Optional[_builtins.str]:
        """
        Specifies the encoding format of each CertificateAuthority's CA
        certificate and CRLs. If this is omitted, CA certificates and CRLs
        will be published in PEM.
        Possible values are: `PEM`, `DER`.
        """
        return pulumi.get(self, "encoding_format")


@pulumi.output_type
class CertificateCertificateDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aiaIssuingCertificateUrls":
            suggest = "aia_issuing_certificate_urls"
        elif key == "authorityKeyIds":
            suggest = "authority_key_ids"
        elif key == "certFingerprints":
            suggest = "cert_fingerprints"
        elif key == "crlDistributionPoints":
            suggest = "crl_distribution_points"
        elif key == "publicKeys":
            suggest = "public_keys"
        elif key == "subjectDescriptions":
            suggest = "subject_descriptions"
        elif key == "subjectKeyIds":
            suggest = "subject_key_ids"
        elif key == "x509Descriptions":
            suggest = "x509_descriptions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aia_issuing_certificate_urls: Optional[Sequence[_builtins.str]] = None,
                 authority_key_ids: Optional[Sequence['outputs.CertificateCertificateDescriptionAuthorityKeyId']] = None,
                 cert_fingerprints: Optional[Sequence['outputs.CertificateCertificateDescriptionCertFingerprint']] = None,
                 crl_distribution_points: Optional[Sequence[_builtins.str]] = None,
                 public_keys: Optional[Sequence['outputs.CertificateCertificateDescriptionPublicKey']] = None,
                 subject_descriptions: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescription']] = None,
                 subject_key_ids: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectKeyId']] = None,
                 x509_descriptions: Optional[Sequence['outputs.CertificateCertificateDescriptionX509Description']] = None):
        """
        :param Sequence[_builtins.str] aia_issuing_certificate_urls: (Output)
               Describes lists of issuer CA certificate URLs that appear in the "Authority Information Access" extension in the certificate.
        :param Sequence['CertificateCertificateDescriptionAuthorityKeyIdArgs'] authority_key_ids: (Output)
               Identifies the subjectKeyId of the parent certificate, per https://tools.ietf.org/html/rfc5280#section-4.2.1.1
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionCertFingerprintArgs'] cert_fingerprints: (Output)
               The hash of the x.509 certificate.
               Structure is documented below.
        :param Sequence[_builtins.str] crl_distribution_points: (Output)
               Describes a list of locations to obtain CRL information, i.e. the DistributionPoint.fullName described by https://tools.ietf.org/html/rfc5280#section-4.2.1.13
        :param Sequence['CertificateCertificateDescriptionPublicKeyArgs'] public_keys: (Output)
               A PublicKey describes a public key.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionSubjectDescriptionArgs'] subject_descriptions: (Output)
               Describes some of the values in a certificate that are related to the subject and lifetime.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionSubjectKeyIdArgs'] subject_key_ids: (Output)
               Provides a means of identifiying certificates that contain a particular public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionArgs'] x509_descriptions: (Output)
               A structured description of the issued X.509 certificate.
               Structure is documented below.
        """
        if aia_issuing_certificate_urls is not None:
            pulumi.set(__self__, "aia_issuing_certificate_urls", aia_issuing_certificate_urls)
        if authority_key_ids is not None:
            pulumi.set(__self__, "authority_key_ids", authority_key_ids)
        if cert_fingerprints is not None:
            pulumi.set(__self__, "cert_fingerprints", cert_fingerprints)
        if crl_distribution_points is not None:
            pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)
        if subject_descriptions is not None:
            pulumi.set(__self__, "subject_descriptions", subject_descriptions)
        if subject_key_ids is not None:
            pulumi.set(__self__, "subject_key_ids", subject_key_ids)
        if x509_descriptions is not None:
            pulumi.set(__self__, "x509_descriptions", x509_descriptions)

    @_builtins.property
    @pulumi.getter(name="aiaIssuingCertificateUrls")
    def aia_issuing_certificate_urls(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Describes lists of issuer CA certificate URLs that appear in the "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_issuing_certificate_urls")

    @_builtins.property
    @pulumi.getter(name="authorityKeyIds")
    def authority_key_ids(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionAuthorityKeyId']]:
        """
        (Output)
        Identifies the subjectKeyId of the parent certificate, per https://tools.ietf.org/html/rfc5280#section-4.2.1.1
        Structure is documented below.
        """
        return pulumi.get(self, "authority_key_ids")

    @_builtins.property
    @pulumi.getter(name="certFingerprints")
    def cert_fingerprints(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionCertFingerprint']]:
        """
        (Output)
        The hash of the x.509 certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "cert_fingerprints")

    @_builtins.property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Describes a list of locations to obtain CRL information, i.e. the DistributionPoint.fullName described by https://tools.ietf.org/html/rfc5280#section-4.2.1.13
        """
        return pulumi.get(self, "crl_distribution_points")

    @_builtins.property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionPublicKey']]:
        """
        (Output)
        A PublicKey describes a public key.
        Structure is documented below.
        """
        return pulumi.get(self, "public_keys")

    @_builtins.property
    @pulumi.getter(name="subjectDescriptions")
    def subject_descriptions(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescription']]:
        """
        (Output)
        Describes some of the values in a certificate that are related to the subject and lifetime.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_descriptions")

    @_builtins.property
    @pulumi.getter(name="subjectKeyIds")
    def subject_key_ids(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectKeyId']]:
        """
        (Output)
        Provides a means of identifiying certificates that contain a particular public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_key_ids")

    @_builtins.property
    @pulumi.getter(name="x509Descriptions")
    def x509_descriptions(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509Description']]:
        """
        (Output)
        A structured description of the issued X.509 certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "x509_descriptions")


@pulumi.output_type
class CertificateCertificateDescriptionAuthorityKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionAuthorityKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionAuthorityKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionAuthorityKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: (Output)
               Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class CertificateCertificateDescriptionCertFingerprint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Hash":
            suggest = "sha256_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionCertFingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionCertFingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionCertFingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_hash: Optional[_builtins.str] = None):
        """
        :param _builtins.str sha256_hash: (Output)
               The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
        """
        if sha256_hash is not None:
            pulumi.set(__self__, "sha256_hash", sha256_hash)

    @_builtins.property
    @pulumi.getter(name="sha256Hash")
    def sha256_hash(self) -> Optional[_builtins.str]:
        """
        (Output)
        The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
        """
        return pulumi.get(self, "sha256_hash")


@pulumi.output_type
class CertificateCertificateDescriptionPublicKey(dict):
    def __init__(__self__, *,
                 format: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.str format: The format of the public key. Currently, only PEM format is supported.
               Possible values are: `KEY_TYPE_UNSPECIFIED`, `PEM`.
        :param _builtins.str key: Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        if format is not None:
            pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def format(self) -> Optional[_builtins.str]:
        """
        The format of the public key. Currently, only PEM format is supported.
        Possible values are: `KEY_TYPE_UNSPECIFIED`, `PEM`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hexSerialNumber":
            suggest = "hex_serial_number"
        elif key == "notAfterTime":
            suggest = "not_after_time"
        elif key == "notBeforeTime":
            suggest = "not_before_time"
        elif key == "subjectAltNames":
            suggest = "subject_alt_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hex_serial_number: Optional[_builtins.str] = None,
                 lifetime: Optional[_builtins.str] = None,
                 not_after_time: Optional[_builtins.str] = None,
                 not_before_time: Optional[_builtins.str] = None,
                 subject_alt_names: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltName']] = None,
                 subjects: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubject']] = None):
        """
        :param _builtins.str hex_serial_number: (Output)
               The serial number encoded in lowercase hexadecimal.
        :param _builtins.str lifetime: The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
               "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
               fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.str not_after_time: (Output)
               The time at which the certificate expires.
        :param _builtins.str not_before_time: (Output)
               The time at which the certificate becomes valid.
        :param Sequence['CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameArgs'] subject_alt_names: (Output)
               The subject alternative name fields.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionSubjectDescriptionSubjectArgs'] subjects: (Output)
               Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        """
        if hex_serial_number is not None:
            pulumi.set(__self__, "hex_serial_number", hex_serial_number)
        if lifetime is not None:
            pulumi.set(__self__, "lifetime", lifetime)
        if not_after_time is not None:
            pulumi.set(__self__, "not_after_time", not_after_time)
        if not_before_time is not None:
            pulumi.set(__self__, "not_before_time", not_before_time)
        if subject_alt_names is not None:
            pulumi.set(__self__, "subject_alt_names", subject_alt_names)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)

    @_builtins.property
    @pulumi.getter(name="hexSerialNumber")
    def hex_serial_number(self) -> Optional[_builtins.str]:
        """
        (Output)
        The serial number encoded in lowercase hexadecimal.
        """
        return pulumi.get(self, "hex_serial_number")

    @_builtins.property
    @pulumi.getter
    def lifetime(self) -> Optional[_builtins.str]:
        """
        The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
        "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
        fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "lifetime")

    @_builtins.property
    @pulumi.getter(name="notAfterTime")
    def not_after_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the certificate expires.
        """
        return pulumi.get(self, "not_after_time")

    @_builtins.property
    @pulumi.getter(name="notBeforeTime")
    def not_before_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the certificate becomes valid.
        """
        return pulumi.get(self, "not_before_time")

    @_builtins.property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltName']]:
        """
        (Output)
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_names")

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubject']]:
        """
        (Output)
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subjects")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[_builtins.str] = None,
                 country_code: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 organizational_unit: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 street_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str common_name: The common name of the distinguished name.
        :param _builtins.str country_code: The country code of the subject.
        :param _builtins.str locality: The locality or city of the subject.
        :param _builtins.str organization: The organization of the subject.
        :param _builtins.str organizational_unit: The organizational unit of the subject.
        :param _builtins.str postal_code: The postal code of the subject.
        :param _builtins.str province: The province, territory, or regional state of the subject.
        :param _builtins.str street_address: The street address of the subject.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[_builtins.str]:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[_builtins.str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[_builtins.str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[_builtins.str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customSans":
            suggest = "custom_sans"
        elif key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_sans: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan']] = None,
                 dns_names: Optional[Sequence[_builtins.str]] = None,
                 email_addresses: Optional[Sequence[_builtins.str]] = None,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanArgs'] custom_sans: (Output)
               Contains additional subject alternative name values.
               Structure is documented below.
        :param Sequence[_builtins.str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[_builtins.str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[_builtins.str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[_builtins.str] uris: Contains only valid RFC 3986 URIs.
        """
        if custom_sans is not None:
            pulumi.set(__self__, "custom_sans", custom_sans)
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan']]:
        """
        (Output)
        Contains additional subject alternative name values.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_sans")

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obectIds":
            suggest = "obect_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: Optional[_builtins.bool] = None,
                 obect_ids: Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId']] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool critical: (Output)
               Indicates whether or not the name constraints are marked critical.
        :param Sequence['CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectIdArgs'] obect_ids: (Output)
               Describes how some of the technical fields in a certificate should be populated.
               Structure is documented below.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if obect_ids is not None:
            pulumi.set(__self__, "obect_ids", obect_ids)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[_builtins.bool]:
        """
        (Output)
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="obectIds")
    def obect_ids(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId']]:
        """
        (Output)
        Describes how some of the technical fields in a certificate should be populated.
        Structure is documented below.
        """
        return pulumi.get(self, "obect_ids")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSanObectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Optional[Sequence[_builtins.int]] = None):
        """
        :param Sequence[_builtins.int] object_id_paths: (Output)
               An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        if object_id_paths is not None:
            pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Optional[Sequence[_builtins.int]]:
        """
        (Output)
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateCertificateDescriptionSubjectKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionSubjectKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionSubjectKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionSubjectKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: The value of the KeyId in lowercase hexadecimal.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The value of the KeyId in lowercase hexadecimal.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class CertificateCertificateDescriptionX509Description(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "caOptions":
            suggest = "ca_options"
        elif key == "keyUsages":
            suggest = "key_usages"
        elif key == "nameConstraints":
            suggest = "name_constraints"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509Description. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509Description.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509Description.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_extensions: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionAdditionalExtension']] = None,
                 aia_ocsp_servers: Optional[Sequence[_builtins.str]] = None,
                 ca_options: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionCaOption']] = None,
                 key_usages: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsage']] = None,
                 name_constraints: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionNameConstraint']] = None,
                 policy_ids: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionPolicyId']] = None):
        """
        :param Sequence['CertificateCertificateDescriptionX509DescriptionAdditionalExtensionArgs'] additional_extensions: (Output)
               Describes custom X.509 extensions.
               Structure is documented below.
        :param Sequence[_builtins.str] aia_ocsp_servers: (Output)
               Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
               "Authority Information Access" extension in the certificate.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionCaOptionArgs'] ca_options: (Output)
               Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionKeyUsageArgs'] key_usages: (Output)
               Indicates the intended use for keys that correspond to a certificate.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionNameConstraintArgs'] name_constraints: (Output)
               Describes the X.509 name constraints extension.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionPolicyIdArgs'] policy_ids: (Output)
               Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
               Structure is documented below.
        """
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if ca_options is not None:
            pulumi.set(__self__, "ca_options", ca_options)
        if key_usages is not None:
            pulumi.set(__self__, "key_usages", key_usages)
        if name_constraints is not None:
            pulumi.set(__self__, "name_constraints", name_constraints)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionAdditionalExtension']]:
        """
        (Output)
        Describes custom X.509 extensions.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
        "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionCaOption']]:
        """
        (Output)
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsage']]:
        """
        (Output)
        Indicates the intended use for keys that correspond to a certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionNameConstraint']]:
        """
        (Output)
        Describes the X.509 name constraints extension.
        Structure is documented below.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionPolicyId']]:
        """
        (Output)
        Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIds":
            suggest = "object_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: Optional[_builtins.bool] = None,
                 object_ids: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId']] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool critical: Indicates whether or not this extension is critical (i.e., if the client does not know how to
               handle this extension, the client should consider this to be an error).
        :param Sequence['CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectIdArgs'] object_ids: Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if object_ids is not None:
            pulumi.set(__self__, "object_ids", object_ids)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[_builtins.bool]:
        """
        Indicates whether or not this extension is critical (i.e., if the client does not know how to
        handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId']]:
        """
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "object_ids")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionAdditionalExtensionObjectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Optional[Sequence[_builtins.int]] = None):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        if object_id_paths is not None:
            pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Optional[Sequence[_builtins.int]]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionCaOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionCaOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionCaOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionCaOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: Optional[_builtins.bool] = None,
                 max_issuer_path_length: Optional[_builtins.int] = None):
        """
        :param _builtins.bool is_ca: When true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        """
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[_builtins.int]:
        """
        Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        """
        return pulumi.get(self, "max_issuer_path_length")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsages":
            suggest = "base_key_usages"
        elif key == "extendedKeyUsages":
            suggest = "extended_key_usages"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usages: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage']] = None,
                 extended_key_usages: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage']] = None,
                 unknown_extended_key_usages: Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage']] = None):
        """
        :param Sequence['CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageArgs'] base_key_usages: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageArgs'] extended_key_usages: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param Sequence['CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
               Structure is documented below.
        """
        if base_key_usages is not None:
            pulumi.set(__self__, "base_key_usages", base_key_usages)
        if extended_key_usages is not None:
            pulumi.set(__self__, "extended_key_usages", extended_key_usages)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsages")
    def base_key_usages(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage']]:
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "base_key_usages")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsages")
    def extended_key_usages(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage']]:
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "extended_key_usages")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[Sequence['outputs.CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage']]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        Structure is documented below.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[_builtins.bool] = None,
                 content_commitment: Optional[_builtins.bool] = None,
                 crl_sign: Optional[_builtins.bool] = None,
                 data_encipherment: Optional[_builtins.bool] = None,
                 decipher_only: Optional[_builtins.bool] = None,
                 digital_signature: Optional[_builtins.bool] = None,
                 encipher_only: Optional[_builtins.bool] = None,
                 key_agreement: Optional[_builtins.bool] = None,
                 key_encipherment: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[_builtins.bool]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[_builtins.bool]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[_builtins.bool]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[_builtins.bool] = None,
                 code_signing: Optional[_builtins.bool] = None,
                 email_protection: Optional[_builtins.bool] = None,
                 ocsp_signing: Optional[_builtins.bool] = None,
                 server_auth: Optional[_builtins.bool] = None,
                 time_stamping: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Optional[Sequence[_builtins.int]] = None):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        if object_id_paths is not None:
            pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Optional[Sequence[_builtins.int]]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionNameConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedDnsNames":
            suggest = "excluded_dns_names"
        elif key == "excludedEmailAddresses":
            suggest = "excluded_email_addresses"
        elif key == "excludedIpRanges":
            suggest = "excluded_ip_ranges"
        elif key == "excludedUris":
            suggest = "excluded_uris"
        elif key == "permittedDnsNames":
            suggest = "permitted_dns_names"
        elif key == "permittedEmailAddresses":
            suggest = "permitted_email_addresses"
        elif key == "permittedIpRanges":
            suggest = "permitted_ip_ranges"
        elif key == "permittedUris":
            suggest = "permitted_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionNameConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionNameConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionNameConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: Optional[_builtins.bool] = None,
                 excluded_dns_names: Optional[Sequence[_builtins.str]] = None,
                 excluded_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 excluded_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 excluded_uris: Optional[Sequence[_builtins.str]] = None,
                 permitted_dns_names: Optional[Sequence[_builtins.str]] = None,
                 permitted_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 permitted_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 permitted_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        """
        if critical is not None:
            pulumi.set(__self__, "critical", critical)
        if excluded_dns_names is not None:
            pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uris is not None:
            pulumi.set(__self__, "excluded_uris", excluded_uris)
        if permitted_dns_names is not None:
            pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uris is not None:
            pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[_builtins.bool]:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class CertificateCertificateDescriptionX509DescriptionPolicyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCertificateDescriptionX509DescriptionPolicyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCertificateDescriptionX509DescriptionPolicyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCertificateDescriptionX509DescriptionPolicyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Optional[Sequence[_builtins.int]] = None):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        if object_id_paths is not None:
            pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Optional[Sequence[_builtins.int]]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"
        elif key == "subjectConfig":
            suggest = "subject_config"
        elif key == "x509Config":
            suggest = "x509_config"
        elif key == "subjectKeyId":
            suggest = "subject_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: 'outputs.CertificateConfigPublicKey',
                 subject_config: 'outputs.CertificateConfigSubjectConfig',
                 x509_config: 'outputs.CertificateConfigX509Config',
                 subject_key_id: Optional['outputs.CertificateConfigSubjectKeyId'] = None):
        """
        :param 'CertificateConfigPublicKeyArgs' public_key: A PublicKey describes a public key.
               Structure is documented below.
               
               
               <a name="nested_config_x509_config"></a>The `x509_config` block supports:
        :param 'CertificateConfigSubjectConfigArgs' subject_config: Specifies some of the values in a certificate that are related to the subject.
               Structure is documented below.
        :param 'CertificateConfigX509ConfigArgs' x509_config: Describes how some of the technical X.509 fields in a certificate should be populated.
               Structure is documented below.
        :param 'CertificateConfigSubjectKeyIdArgs' subject_key_id: When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
               Structure is documented below.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "subject_config", subject_config)
        pulumi.set(__self__, "x509_config", x509_config)
        if subject_key_id is not None:
            pulumi.set(__self__, "subject_key_id", subject_key_id)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.CertificateConfigPublicKey':
        """
        A PublicKey describes a public key.
        Structure is documented below.


        <a name="nested_config_x509_config"></a>The `x509_config` block supports:
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.CertificateConfigSubjectConfig':
        """
        Specifies some of the values in a certificate that are related to the subject.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_config")

    @_builtins.property
    @pulumi.getter(name="x509Config")
    def x509_config(self) -> 'outputs.CertificateConfigX509Config':
        """
        Describes how some of the technical X.509 fields in a certificate should be populated.
        Structure is documented below.
        """
        return pulumi.get(self, "x509_config")

    @_builtins.property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> Optional['outputs.CertificateConfigSubjectKeyId']:
        """
        When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
        Structure is documented below.
        """
        return pulumi.get(self, "subject_key_id")


@pulumi.output_type
class CertificateConfigPublicKey(dict):
    def __init__(__self__, *,
                 format: _builtins.str,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.str format: The format of the public key. Currently, only PEM format is supported.
               Possible values are: `KEY_TYPE_UNSPECIFIED`, `PEM`.
        :param _builtins.str key: Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        pulumi.set(__self__, "format", format)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The format of the public key. Currently, only PEM format is supported.
        Possible values are: `KEY_TYPE_UNSPECIFIED`, `PEM`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class CertificateConfigSubjectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: 'outputs.CertificateConfigSubjectConfigSubject',
                 subject_alt_name: Optional['outputs.CertificateConfigSubjectConfigSubjectAltName'] = None):
        """
        :param 'CertificateConfigSubjectConfigSubjectArgs' subject: Contains distinguished name fields such as the location and organization.
               Structure is documented below.
        :param 'CertificateConfigSubjectConfigSubjectAltNameArgs' subject_alt_name: The subject alternative name fields.
               Structure is documented below.
        """
        pulumi.set(__self__, "subject", subject)
        if subject_alt_name is not None:
            pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> 'outputs.CertificateConfigSubjectConfigSubject':
        """
        Contains distinguished name fields such as the location and organization.
        Structure is documented below.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> Optional['outputs.CertificateConfigSubjectConfigSubjectAltName']:
        """
        The subject alternative name fields.
        Structure is documented below.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class CertificateConfigSubjectConfigSubject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfigSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfigSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfigSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: _builtins.str,
                 organization: _builtins.str,
                 country_code: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organizational_unit: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 province: Optional[_builtins.str] = None,
                 street_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str common_name: The common name of the distinguished name.
        :param _builtins.str organization: The organization of the subject.
        :param _builtins.str country_code: The country code of the subject.
        :param _builtins.str locality: The locality or city of the subject.
        :param _builtins.str organizational_unit: The organizational unit of the subject.
        :param _builtins.str postal_code: The postal code of the subject.
        :param _builtins.str province: The province, territory, or regional state of the subject.
        :param _builtins.str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "organization", organization)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> _builtins.str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[_builtins.str]:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[_builtins.str]:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> Optional[_builtins.str]:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[_builtins.str]:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class CertificateConfigSubjectConfigSubjectAltName(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectConfigSubjectAltName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectConfigSubjectAltName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_names: Optional[Sequence[_builtins.str]] = None,
                 email_addresses: Optional[Sequence[_builtins.str]] = None,
                 ip_addresses: Optional[Sequence[_builtins.str]] = None,
                 uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[_builtins.str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[_builtins.str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[_builtins.str] uris: Contains only valid RFC 3986 URIs.
        """
        if dns_names is not None:
            pulumi.set(__self__, "dns_names", dns_names)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class CertificateConfigSubjectKeyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigSubjectKeyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigSubjectKeyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigSubjectKeyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: The value of the KeyId in lowercase hexadecimal.
        """
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[_builtins.str]:
        """
        The value of the KeyId in lowercase hexadecimal.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class CertificateConfigX509Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsage":
            suggest = "key_usage"
        elif key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "caOptions":
            suggest = "ca_options"
        elif key == "nameConstraints":
            suggest = "name_constraints"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usage: 'outputs.CertificateConfigX509ConfigKeyUsage',
                 additional_extensions: Optional[Sequence['outputs.CertificateConfigX509ConfigAdditionalExtension']] = None,
                 aia_ocsp_servers: Optional[Sequence[_builtins.str]] = None,
                 ca_options: Optional['outputs.CertificateConfigX509ConfigCaOptions'] = None,
                 name_constraints: Optional['outputs.CertificateConfigX509ConfigNameConstraints'] = None,
                 policy_ids: Optional[Sequence['outputs.CertificateConfigX509ConfigPolicyId']] = None):
        """
        :param 'CertificateConfigX509ConfigKeyUsageArgs' key_usage: (Output)
               Indicates the intended use for keys that correspond to a certificate.
               Structure is documented below.
        :param Sequence['CertificateConfigX509ConfigAdditionalExtensionArgs'] additional_extensions: (Output)
               Describes custom X.509 extensions.
               Structure is documented below.
        :param Sequence[_builtins.str] aia_ocsp_servers: (Output)
               Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
               "Authority Information Access" extension in the certificate.
        :param 'CertificateConfigX509ConfigCaOptionsArgs' ca_options: (Output)
               Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param 'CertificateConfigX509ConfigNameConstraintsArgs' name_constraints: (Output)
               Describes the X.509 name constraints extension.
               Structure is documented below.
        :param Sequence['CertificateConfigX509ConfigPolicyIdArgs'] policy_ids: (Output)
               Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
               Structure is documented below.
        """
        pulumi.set(__self__, "key_usage", key_usage)
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if ca_options is not None:
            pulumi.set(__self__, "ca_options", ca_options)
        if name_constraints is not None:
            pulumi.set(__self__, "name_constraints", name_constraints)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> 'outputs.CertificateConfigX509ConfigKeyUsage':
        """
        (Output)
        Indicates the intended use for keys that correspond to a certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.CertificateConfigX509ConfigAdditionalExtension']]:
        """
        (Output)
        Describes custom X.509 extensions.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Output)
        Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
        "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> Optional['outputs.CertificateConfigX509ConfigCaOptions']:
        """
        (Output)
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Optional['outputs.CertificateConfigX509ConfigNameConstraints']:
        """
        (Output)
        Describes the X.509 name constraints extension.
        Structure is documented below.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[Sequence['outputs.CertificateConfigX509ConfigPolicyId']]:
        """
        (Output)
        Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class CertificateConfigX509ConfigAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 object_id: 'outputs.CertificateConfigX509ConfigAdditionalExtensionObjectId',
                 value: _builtins.str):
        """
        :param _builtins.bool critical: Indicates whether or not this extension is critical (i.e., if the client does not know how to
               handle this extension, the client should consider this to be an error).
        :param 'CertificateConfigX509ConfigAdditionalExtensionObjectIdArgs' object_id: Describes values that are relevant in a CA certificate.
               Structure is documented below.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not this extension is critical (i.e., if the client does not know how to
        handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> 'outputs.CertificateConfigX509ConfigAdditionalExtensionObjectId':
        """
        Describes values that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateConfigX509ConfigAdditionalExtensionObjectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigAdditionalExtensionObjectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigAdditionalExtensionObjectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigAdditionalExtensionObjectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateConfigX509ConfigCaOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"
        elif key == "nonCa":
            suggest = "non_ca"
        elif key == "zeroMaxIssuerPathLength":
            suggest = "zero_max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigCaOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigCaOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigCaOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: Optional[_builtins.bool] = None,
                 max_issuer_path_length: Optional[_builtins.int] = None,
                 non_ca: Optional[_builtins.bool] = None,
                 zero_max_issuer_path_length: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_ca: When true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        :param _builtins.bool non_ca: When true, the "CA" in Basic Constraints extension will be set to false.
               If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        :param _builtins.bool zero_max_issuer_path_length: When true, the "path length constraint" in Basic Constraints extension will be set to 0.
               if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
               the max path length will be omitted from the CA certificate.
        """
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)
        if non_ca is not None:
            pulumi.set(__self__, "non_ca", non_ca)
        if zero_max_issuer_path_length is not None:
            pulumi.set(__self__, "zero_max_issuer_path_length", zero_max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[_builtins.int]:
        """
        Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @_builtins.property
    @pulumi.getter(name="nonCa")
    def non_ca(self) -> Optional[_builtins.bool]:
        """
        When true, the "CA" in Basic Constraints extension will be set to false.
        If both `is_ca` and `non_ca` are unset, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "non_ca")

    @_builtins.property
    @pulumi.getter(name="zeroMaxIssuerPathLength")
    def zero_max_issuer_path_length(self) -> Optional[_builtins.bool]:
        """
        When true, the "path length constraint" in Basic Constraints extension will be set to 0.
        if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
        the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "zero_max_issuer_path_length")


@pulumi.output_type
class CertificateConfigX509ConfigKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usage: 'outputs.CertificateConfigX509ConfigKeyUsageBaseKeyUsage',
                 extended_key_usage: 'outputs.CertificateConfigX509ConfigKeyUsageExtendedKeyUsage',
                 unknown_extended_key_usages: Optional[Sequence['outputs.CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage']] = None):
        """
        :param 'CertificateConfigX509ConfigKeyUsageBaseKeyUsageArgs' base_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param 'CertificateConfigX509ConfigKeyUsageExtendedKeyUsageArgs' extended_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param Sequence['CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
               Structure is documented below.
        """
        pulumi.set(__self__, "base_key_usage", base_key_usage)
        pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> 'outputs.CertificateConfigX509ConfigKeyUsageBaseKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "base_key_usage")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> 'outputs.CertificateConfigX509ConfigKeyUsageExtendedKeyUsage':
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "extended_key_usage")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[Sequence['outputs.CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage']]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        Structure is documented below.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class CertificateConfigX509ConfigKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[_builtins.bool] = None,
                 content_commitment: Optional[_builtins.bool] = None,
                 crl_sign: Optional[_builtins.bool] = None,
                 data_encipherment: Optional[_builtins.bool] = None,
                 decipher_only: Optional[_builtins.bool] = None,
                 digital_signature: Optional[_builtins.bool] = None,
                 encipher_only: Optional[_builtins.bool] = None,
                 key_agreement: Optional[_builtins.bool] = None,
                 key_encipherment: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[_builtins.bool]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[_builtins.bool]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[_builtins.bool]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class CertificateConfigX509ConfigKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[_builtins.bool] = None,
                 code_signing: Optional[_builtins.bool] = None,
                 email_protection: Optional[_builtins.bool] = None,
                 ocsp_signing: Optional[_builtins.bool] = None,
                 server_auth: Optional[_builtins.bool] = None,
                 time_stamping: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateConfigX509ConfigNameConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedDnsNames":
            suggest = "excluded_dns_names"
        elif key == "excludedEmailAddresses":
            suggest = "excluded_email_addresses"
        elif key == "excludedIpRanges":
            suggest = "excluded_ip_ranges"
        elif key == "excludedUris":
            suggest = "excluded_uris"
        elif key == "permittedDnsNames":
            suggest = "permitted_dns_names"
        elif key == "permittedEmailAddresses":
            suggest = "permitted_email_addresses"
        elif key == "permittedIpRanges":
            suggest = "permitted_ip_ranges"
        elif key == "permittedUris":
            suggest = "permitted_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigNameConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigNameConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigNameConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 excluded_dns_names: Optional[Sequence[_builtins.str]] = None,
                 excluded_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 excluded_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 excluded_uris: Optional[Sequence[_builtins.str]] = None,
                 permitted_dns_names: Optional[Sequence[_builtins.str]] = None,
                 permitted_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 permitted_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 permitted_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        """
        pulumi.set(__self__, "critical", critical)
        if excluded_dns_names is not None:
            pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uris is not None:
            pulumi.set(__self__, "excluded_uris", excluded_uris)
        if permitted_dns_names is not None:
            pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uris is not None:
            pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class CertificateConfigX509ConfigPolicyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigX509ConfigPolicyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigX509ConfigPolicyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigX509ConfigPolicyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateRevocationDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revocationState":
            suggest = "revocation_state"
        elif key == "revocationTime":
            suggest = "revocation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateRevocationDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateRevocationDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateRevocationDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revocation_state: Optional[_builtins.str] = None,
                 revocation_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str revocation_state: (Output)
               Indicates why a Certificate was revoked.
        :param _builtins.str revocation_time: (Output)
               The time at which this Certificate was revoked.
        """
        if revocation_state is not None:
            pulumi.set(__self__, "revocation_state", revocation_state)
        if revocation_time is not None:
            pulumi.set(__self__, "revocation_time", revocation_time)

    @_builtins.property
    @pulumi.getter(name="revocationState")
    def revocation_state(self) -> Optional[_builtins.str]:
        """
        (Output)
        Indicates why a Certificate was revoked.
        """
        return pulumi.get(self, "revocation_state")

    @_builtins.property
    @pulumi.getter(name="revocationTime")
    def revocation_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which this Certificate was revoked.
        """
        return pulumi.get(self, "revocation_time")


@pulumi.output_type
class CertificateTemplateIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class CertificateTemplateIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class CertificateTemplateIdentityConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSubjectAltNamesPassthrough":
            suggest = "allow_subject_alt_names_passthrough"
        elif key == "allowSubjectPassthrough":
            suggest = "allow_subject_passthrough"
        elif key == "celExpression":
            suggest = "cel_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplateIdentityConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplateIdentityConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplateIdentityConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_subject_alt_names_passthrough: _builtins.bool,
                 allow_subject_passthrough: _builtins.bool,
                 cel_expression: Optional['outputs.CertificateTemplateIdentityConstraintsCelExpression'] = None):
        """
        :param _builtins.bool allow_subject_alt_names_passthrough: Required. If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
        :param _builtins.bool allow_subject_passthrough: Required. If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
        :param 'CertificateTemplateIdentityConstraintsCelExpressionArgs' cel_expression: Optional. A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a certificate is signed. To see the full allowed syntax and some examples, see https://cloud.google.com/certificate-authority-service/docs/using-cel
               Structure is documented below.
        """
        pulumi.set(__self__, "allow_subject_alt_names_passthrough", allow_subject_alt_names_passthrough)
        pulumi.set(__self__, "allow_subject_passthrough", allow_subject_passthrough)
        if cel_expression is not None:
            pulumi.set(__self__, "cel_expression", cel_expression)

    @_builtins.property
    @pulumi.getter(name="allowSubjectAltNamesPassthrough")
    def allow_subject_alt_names_passthrough(self) -> _builtins.bool:
        """
        Required. If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
        """
        return pulumi.get(self, "allow_subject_alt_names_passthrough")

    @_builtins.property
    @pulumi.getter(name="allowSubjectPassthrough")
    def allow_subject_passthrough(self) -> _builtins.bool:
        """
        Required. If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
        """
        return pulumi.get(self, "allow_subject_passthrough")

    @_builtins.property
    @pulumi.getter(name="celExpression")
    def cel_expression(self) -> Optional['outputs.CertificateTemplateIdentityConstraintsCelExpression']:
        """
        Optional. A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a certificate is signed. To see the full allowed syntax and some examples, see https://cloud.google.com/certificate-authority-service/docs/using-cel
        Structure is documented below.
        """
        return pulumi.get(self, "cel_expression")


@pulumi.output_type
class CertificateTemplateIdentityConstraintsCelExpression(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 expression: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 title: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param _builtins.str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[_builtins.str]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateTemplatePassthroughExtensions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "knownExtensions":
            suggest = "known_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePassthroughExtensions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePassthroughExtensions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePassthroughExtensions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_extensions: Optional[Sequence['outputs.CertificateTemplatePassthroughExtensionsAdditionalExtension']] = None,
                 known_extensions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['CertificateTemplatePassthroughExtensionsAdditionalExtensionArgs'] additional_extensions: Optional. A set of ObjectIds identifying custom X.509 extensions. Will be combined with known_extensions to determine the full set of X.509 extensions.
               Structure is documented below.
        :param Sequence[_builtins.str] known_extensions: Optional. A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
        """
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if known_extensions is not None:
            pulumi.set(__self__, "known_extensions", known_extensions)

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.CertificateTemplatePassthroughExtensionsAdditionalExtension']]:
        """
        Optional. A set of ObjectIds identifying custom X.509 extensions. Will be combined with known_extensions to determine the full set of X.509 extensions.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="knownExtensions")
    def known_extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional. A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
        """
        return pulumi.get(self, "known_extensions")


@pulumi.output_type
class CertificateTemplatePassthroughExtensionsAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePassthroughExtensionsAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePassthroughExtensionsAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePassthroughExtensionsAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: Required. The parts of an OID path. The most significant parts of the path come first.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        Required. The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateTemplatePredefinedValues(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "caOptions":
            suggest = "ca_options"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "nameConstraints":
            suggest = "name_constraints"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValues. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValues.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValues.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_extensions: Optional[Sequence['outputs.CertificateTemplatePredefinedValuesAdditionalExtension']] = None,
                 aia_ocsp_servers: Optional[Sequence[_builtins.str]] = None,
                 ca_options: Optional['outputs.CertificateTemplatePredefinedValuesCaOptions'] = None,
                 key_usage: Optional['outputs.CertificateTemplatePredefinedValuesKeyUsage'] = None,
                 name_constraints: Optional['outputs.CertificateTemplatePredefinedValuesNameConstraints'] = None,
                 policy_ids: Optional[Sequence['outputs.CertificateTemplatePredefinedValuesPolicyId']] = None):
        """
        :param Sequence['CertificateTemplatePredefinedValuesAdditionalExtensionArgs'] additional_extensions: Optional. Describes custom X.509 extensions.
               Structure is documented below.
        :param Sequence[_builtins.str] aia_ocsp_servers: Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        :param 'CertificateTemplatePredefinedValuesCaOptionsArgs' ca_options: Optional. Describes options in this X509Parameters that are relevant in a CA certificate.
               Structure is documented below.
        :param 'CertificateTemplatePredefinedValuesKeyUsageArgs' key_usage: Optional. Indicates the intended use for keys that correspond to a certificate.
               Structure is documented below.
        :param 'CertificateTemplatePredefinedValuesNameConstraintsArgs' name_constraints: Describes the X.509 name constraints extension.
               Structure is documented below.
        :param Sequence['CertificateTemplatePredefinedValuesPolicyIdArgs'] policy_ids: Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
               Structure is documented below.
        """
        if additional_extensions is not None:
            pulumi.set(__self__, "additional_extensions", additional_extensions)
        if aia_ocsp_servers is not None:
            pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        if ca_options is not None:
            pulumi.set(__self__, "ca_options", ca_options)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if name_constraints is not None:
            pulumi.set(__self__, "name_constraints", name_constraints)
        if policy_ids is not None:
            pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Optional[Sequence['outputs.CertificateTemplatePredefinedValuesAdditionalExtension']]:
        """
        Optional. Describes custom X.509 extensions.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> Optional['outputs.CertificateTemplatePredefinedValuesCaOptions']:
        """
        Optional. Describes options in this X509Parameters that are relevant in a CA certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateTemplatePredefinedValuesKeyUsage']:
        """
        Optional. Indicates the intended use for keys that correspond to a certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Optional['outputs.CertificateTemplatePredefinedValuesNameConstraints']:
        """
        Describes the X.509 name constraints extension.
        Structure is documented below.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Optional[Sequence['outputs.CertificateTemplatePredefinedValuesPolicyId']]:
        """
        Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        Structure is documented below.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class CertificateTemplatePredefinedValuesAdditionalExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesAdditionalExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesAdditionalExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesAdditionalExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: 'outputs.CertificateTemplatePredefinedValuesAdditionalExtensionObjectId',
                 value: _builtins.str,
                 critical: Optional[_builtins.bool] = None):
        """
        :param 'CertificateTemplatePredefinedValuesAdditionalExtensionObjectIdArgs' object_id: Required. The OID for this X.509 extension.
               Structure is documented below.
        :param _builtins.str value: Required. The value of this X.509 extension.
        :param _builtins.bool critical: Optional. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "value", value)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> 'outputs.CertificateTemplatePredefinedValuesAdditionalExtensionObjectId':
        """
        Required. The OID for this X.509 extension.
        Structure is documented below.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Required. The value of this X.509 extension.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def critical(self) -> Optional[_builtins.bool]:
        """
        Optional. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")


@pulumi.output_type
class CertificateTemplatePredefinedValuesAdditionalExtensionObjectId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesAdditionalExtensionObjectId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesAdditionalExtensionObjectId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesAdditionalExtensionObjectId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: Required. The parts of an OID path. The most significant parts of the path come first.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        Required. The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateTemplatePredefinedValuesCaOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"
        elif key == "nullCa":
            suggest = "null_ca"
        elif key == "zeroMaxIssuerPathLength":
            suggest = "zero_max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesCaOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesCaOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesCaOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: Optional[_builtins.bool] = None,
                 max_issuer_path_length: Optional[_builtins.int] = None,
                 null_ca: Optional[_builtins.bool] = None,
                 zero_max_issuer_path_length: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool is_ca: Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Optional. Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        :param _builtins.bool null_ca: Optional. When true, the "CA" in Basic Constraints extension will be set to null and omitted from the CA certificate.
               If both `is_ca` and `null_ca` are unset, the "CA" in Basic Constraints extension will be set to false.
               Note that the behavior when `is_ca = false` for this resource is different from the behavior in the Certificate Authority, Certificate and CaPool resources.
        :param _builtins.bool zero_max_issuer_path_length: Optional. When true, the "path length constraint" in Basic Constraints extension will be set to 0.
               if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
               the max path length will be omitted from the CA certificate.
        """
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if max_issuer_path_length is not None:
            pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)
        if null_ca is not None:
            pulumi.set(__self__, "null_ca", null_ca)
        if zero_max_issuer_path_length is not None:
            pulumi.set(__self__, "zero_max_issuer_path_length", zero_max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[_builtins.bool]:
        """
        Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> Optional[_builtins.int]:
        """
        Optional. Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @_builtins.property
    @pulumi.getter(name="nullCa")
    def null_ca(self) -> Optional[_builtins.bool]:
        """
        Optional. When true, the "CA" in Basic Constraints extension will be set to null and omitted from the CA certificate.
        If both `is_ca` and `null_ca` are unset, the "CA" in Basic Constraints extension will be set to false.
        Note that the behavior when `is_ca = false` for this resource is different from the behavior in the Certificate Authority, Certificate and CaPool resources.
        """
        return pulumi.get(self, "null_ca")

    @_builtins.property
    @pulumi.getter(name="zeroMaxIssuerPathLength")
    def zero_max_issuer_path_length(self) -> Optional[_builtins.bool]:
        """
        Optional. When true, the "path length constraint" in Basic Constraints extension will be set to 0.
        if both `max_issuer_path_length` and `zero_max_issuer_path_length` are unset,
        the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "zero_max_issuer_path_length")


@pulumi.output_type
class CertificateTemplatePredefinedValuesKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usage: Optional['outputs.CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage'] = None,
                 extended_key_usage: Optional['outputs.CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage'] = None,
                 unknown_extended_key_usages: Optional[Sequence['outputs.CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage']] = None):
        """
        :param 'CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsageArgs' base_key_usage: Describes high-level ways in which a key may be used.
               Structure is documented below.
        :param 'CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsageArgs' extended_key_usage: Detailed scenarios in which a key may be used.
               Structure is documented below.
        :param Sequence['CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
               Structure is documented below.
        """
        if base_key_usage is not None:
            pulumi.set(__self__, "base_key_usage", base_key_usage)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if unknown_extended_key_usages is not None:
            pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> Optional['outputs.CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage']:
        """
        Describes high-level ways in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "base_key_usage")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional['outputs.CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage']:
        """
        Detailed scenarios in which a key may be used.
        Structure is documented below.
        """
        return pulumi.get(self, "extended_key_usage")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Optional[Sequence['outputs.CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage']]:
        """
        Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
        Structure is documented below.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageBaseKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: Optional[_builtins.bool] = None,
                 content_commitment: Optional[_builtins.bool] = None,
                 crl_sign: Optional[_builtins.bool] = None,
                 data_encipherment: Optional[_builtins.bool] = None,
                 decipher_only: Optional[_builtins.bool] = None,
                 digital_signature: Optional[_builtins.bool] = None,
                 encipher_only: Optional[_builtins.bool] = None,
                 key_agreement: Optional[_builtins.bool] = None,
                 key_encipherment: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        if cert_sign is not None:
            pulumi.set(__self__, "cert_sign", cert_sign)
        if content_commitment is not None:
            pulumi.set(__self__, "content_commitment", content_commitment)
        if crl_sign is not None:
            pulumi.set(__self__, "crl_sign", crl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> Optional[_builtins.bool]:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> Optional[_builtins.bool]:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[_builtins.bool]:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[_builtins.bool]:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[_builtins.bool]:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: Optional[_builtins.bool] = None,
                 code_signing: Optional[_builtins.bool] = None,
                 email_protection: Optional[_builtins.bool] = None,
                 ocsp_signing: Optional[_builtins.bool] = None,
                 server_auth: Optional[_builtins.bool] = None,
                 time_stamping: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        if client_auth is not None:
            pulumi.set(__self__, "client_auth", client_auth)
        if code_signing is not None:
            pulumi.set(__self__, "code_signing", code_signing)
        if email_protection is not None:
            pulumi.set(__self__, "email_protection", email_protection)
        if ocsp_signing is not None:
            pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        if server_auth is not None:
            pulumi.set(__self__, "server_auth", server_auth)
        if time_stamping is not None:
            pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> Optional[_builtins.bool]:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesKeyUsageUnknownExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: Required. The parts of an OID path. The most significant parts of the path come first.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        Required. The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class CertificateTemplatePredefinedValuesNameConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedDnsNames":
            suggest = "excluded_dns_names"
        elif key == "excludedEmailAddresses":
            suggest = "excluded_email_addresses"
        elif key == "excludedIpRanges":
            suggest = "excluded_ip_ranges"
        elif key == "excludedUris":
            suggest = "excluded_uris"
        elif key == "permittedDnsNames":
            suggest = "permitted_dns_names"
        elif key == "permittedEmailAddresses":
            suggest = "permitted_email_addresses"
        elif key == "permittedIpRanges":
            suggest = "permitted_ip_ranges"
        elif key == "permittedUris":
            suggest = "permitted_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesNameConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesNameConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesNameConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: _builtins.bool,
                 excluded_dns_names: Optional[Sequence[_builtins.str]] = None,
                 excluded_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 excluded_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 excluded_uris: Optional[Sequence[_builtins.str]] = None,
                 permitted_dns_names: Optional[Sequence[_builtins.str]] = None,
                 permitted_email_addresses: Optional[Sequence[_builtins.str]] = None,
                 permitted_ip_ranges: Optional[Sequence[_builtins.str]] = None,
                 permitted_uris: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, `example.com`, `www.example.com`, `www.sub.example.com`
               would satisfy `example.com` while `example1.com` does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. `.example.com`) to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like `.example.com`)
        """
        pulumi.set(__self__, "critical", critical)
        if excluded_dns_names is not None:
            pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        if excluded_email_addresses is not None:
            pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        if excluded_ip_ranges is not None:
            pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        if excluded_uris is not None:
            pulumi.set(__self__, "excluded_uris", excluded_uris)
        if permitted_dns_names is not None:
            pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        if permitted_email_addresses is not None:
            pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        if permitted_ip_ranges is not None:
            pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        if permitted_uris is not None:
            pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, `example.com`, `www.example.com`, `www.sub.example.com`
        would satisfy `example.com` while `example1.com` does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. `.example.com`) to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Optional[Sequence[_builtins.str]]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like `.example.com`)
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class CertificateTemplatePredefinedValuesPolicyId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPaths":
            suggest = "object_id_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplatePredefinedValuesPolicyId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplatePredefinedValuesPolicyId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplatePredefinedValuesPolicyId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: Required. The parts of an OID path. The most significant parts of the path come first.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        Required. The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class GetAuthorityAccessUrlResult(dict):
    def __init__(__self__, *,
                 ca_certificate_access_url: _builtins.str,
                 crl_access_urls: Sequence[_builtins.str]):
        """
        :param _builtins.str ca_certificate_access_url: The URL where this CertificateAuthority's CA certificate is published. This will only be
               set for CAs that have been activated.
        :param Sequence[_builtins.str] crl_access_urls: The URL where this CertificateAuthority's CRLs are published. This will only be set for
               CAs that have been activated.
        """
        pulumi.set(__self__, "ca_certificate_access_url", ca_certificate_access_url)
        pulumi.set(__self__, "crl_access_urls", crl_access_urls)

    @_builtins.property
    @pulumi.getter(name="caCertificateAccessUrl")
    def ca_certificate_access_url(self) -> _builtins.str:
        """
        The URL where this CertificateAuthority's CA certificate is published. This will only be
        set for CAs that have been activated.
        """
        return pulumi.get(self, "ca_certificate_access_url")

    @_builtins.property
    @pulumi.getter(name="crlAccessUrls")
    def crl_access_urls(self) -> Sequence[_builtins.str]:
        """
        The URL where this CertificateAuthority's CRLs are published. This will only be set for
        CAs that have been activated.
        """
        return pulumi.get(self, "crl_access_urls")


@pulumi.output_type
class GetAuthorityConfigResult(dict):
    def __init__(__self__, *,
                 subject_configs: Sequence['outputs.GetAuthorityConfigSubjectConfigResult'],
                 subject_key_ids: Sequence['outputs.GetAuthorityConfigSubjectKeyIdResult'],
                 x509_configs: Sequence['outputs.GetAuthorityConfigX509ConfigResult']):
        """
        :param Sequence['GetAuthorityConfigSubjectConfigArgs'] subject_configs: Specifies some of the values in a certificate that are related to the subject.
        :param Sequence['GetAuthorityConfigSubjectKeyIdArgs'] subject_key_ids: When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
        :param Sequence['GetAuthorityConfigX509ConfigArgs'] x509_configs: Describes how some of the technical X.509 fields in a certificate should be populated.
        """
        pulumi.set(__self__, "subject_configs", subject_configs)
        pulumi.set(__self__, "subject_key_ids", subject_key_ids)
        pulumi.set(__self__, "x509_configs", x509_configs)

    @_builtins.property
    @pulumi.getter(name="subjectConfigs")
    def subject_configs(self) -> Sequence['outputs.GetAuthorityConfigSubjectConfigResult']:
        """
        Specifies some of the values in a certificate that are related to the subject.
        """
        return pulumi.get(self, "subject_configs")

    @_builtins.property
    @pulumi.getter(name="subjectKeyIds")
    def subject_key_ids(self) -> Sequence['outputs.GetAuthorityConfigSubjectKeyIdResult']:
        """
        When specified this provides a custom SKI to be used in the certificate. This should only be used to maintain a SKI of an existing CA originally created outside CA service, which was not generated using method (1) described in RFC 5280 section 4.2.1.2..
        """
        return pulumi.get(self, "subject_key_ids")

    @_builtins.property
    @pulumi.getter(name="x509Configs")
    def x509_configs(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigResult']:
        """
        Describes how some of the technical X.509 fields in a certificate should be populated.
        """
        return pulumi.get(self, "x509_configs")


@pulumi.output_type
class GetAuthorityConfigSubjectConfigResult(dict):
    def __init__(__self__, *,
                 subject_alt_names: Sequence['outputs.GetAuthorityConfigSubjectConfigSubjectAltNameResult'],
                 subjects: Sequence['outputs.GetAuthorityConfigSubjectConfigSubjectResult']):
        """
        :param Sequence['GetAuthorityConfigSubjectConfigSubjectAltNameArgs'] subject_alt_names: The subject alternative name fields.
        :param Sequence['GetAuthorityConfigSubjectConfigSubjectArgs'] subjects: Contains distinguished name fields such as the location and organization.
        """
        pulumi.set(__self__, "subject_alt_names", subject_alt_names)
        pulumi.set(__self__, "subjects", subjects)

    @_builtins.property
    @pulumi.getter(name="subjectAltNames")
    def subject_alt_names(self) -> Sequence['outputs.GetAuthorityConfigSubjectConfigSubjectAltNameResult']:
        """
        The subject alternative name fields.
        """
        return pulumi.get(self, "subject_alt_names")

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> Sequence['outputs.GetAuthorityConfigSubjectConfigSubjectResult']:
        """
        Contains distinguished name fields such as the location and organization.
        """
        return pulumi.get(self, "subjects")


@pulumi.output_type
class GetAuthorityConfigSubjectConfigSubjectResult(dict):
    def __init__(__self__, *,
                 common_name: _builtins.str,
                 country_code: _builtins.str,
                 locality: _builtins.str,
                 organization: _builtins.str,
                 organizational_unit: _builtins.str,
                 postal_code: _builtins.str,
                 province: _builtins.str,
                 street_address: _builtins.str):
        """
        :param _builtins.str common_name: The common name of the distinguished name.
        :param _builtins.str country_code: The country code of the subject.
        :param _builtins.str locality: The locality or city of the subject.
        :param _builtins.str organization: The organization of the subject.
        :param _builtins.str organizational_unit: The organizational unit of the subject.
        :param _builtins.str postal_code: The postal code of the subject.
        :param _builtins.str province: The province, territory, or regional state of the subject.
        :param _builtins.str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "organizational_unit", organizational_unit)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "street_address", street_address)

    @_builtins.property
    @pulumi.getter(name="commonName")
    def common_name(self) -> _builtins.str:
        """
        The common name of the distinguished name.
        """
        return pulumi.get(self, "common_name")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> _builtins.str:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> _builtins.str:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> _builtins.str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> _builtins.str:
        """
        The organizational unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> _builtins.str:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def province(self) -> _builtins.str:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> _builtins.str:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class GetAuthorityConfigSubjectConfigSubjectAltNameResult(dict):
    def __init__(__self__, *,
                 dns_names: Sequence[_builtins.str],
                 email_addresses: Sequence[_builtins.str],
                 ip_addresses: Sequence[_builtins.str],
                 uris: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[_builtins.str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[_builtins.str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[_builtins.str] uris: Contains only valid RFC 3986 URIs.
        """
        pulumi.set(__self__, "dns_names", dns_names)
        pulumi.set(__self__, "email_addresses", email_addresses)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "uris", uris)

    @_builtins.property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Sequence[_builtins.str]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Sequence[_builtins.str]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence[_builtins.str]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class GetAuthorityConfigSubjectKeyIdResult(dict):
    def __init__(__self__, *,
                 key_id: _builtins.str):
        """
        :param _builtins.str key_id: The value of the KeyId in lowercase hexadecimal.
        """
        pulumi.set(__self__, "key_id", key_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The value of the KeyId in lowercase hexadecimal.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class GetAuthorityConfigX509ConfigResult(dict):
    def __init__(__self__, *,
                 additional_extensions: Sequence['outputs.GetAuthorityConfigX509ConfigAdditionalExtensionResult'],
                 aia_ocsp_servers: Sequence[_builtins.str],
                 ca_options: Sequence['outputs.GetAuthorityConfigX509ConfigCaOptionResult'],
                 key_usages: Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageResult'],
                 name_constraints: Sequence['outputs.GetAuthorityConfigX509ConfigNameConstraintResult'],
                 policy_ids: Sequence['outputs.GetAuthorityConfigX509ConfigPolicyIdResult']):
        """
        :param Sequence['GetAuthorityConfigX509ConfigAdditionalExtensionArgs'] additional_extensions: Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        :param Sequence[_builtins.str] aia_ocsp_servers: Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
               "Authority Information Access" extension in the certificate.
        :param Sequence['GetAuthorityConfigX509ConfigCaOptionArgs'] ca_options: Describes values that are relevant in a CA certificate.
        :param Sequence['GetAuthorityConfigX509ConfigKeyUsageArgs'] key_usages: Indicates the intended use for keys that correspond to a certificate.
        :param Sequence['GetAuthorityConfigX509ConfigNameConstraintArgs'] name_constraints: Describes the X.509 name constraints extension.
        :param Sequence['GetAuthorityConfigX509ConfigPolicyIdArgs'] policy_ids: Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        pulumi.set(__self__, "additional_extensions", additional_extensions)
        pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        pulumi.set(__self__, "ca_options", ca_options)
        pulumi.set(__self__, "key_usages", key_usages)
        pulumi.set(__self__, "name_constraints", name_constraints)
        pulumi.set(__self__, "policy_ids", policy_ids)

    @_builtins.property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigAdditionalExtensionResult']:
        """
        Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        """
        return pulumi.get(self, "additional_extensions")

    @_builtins.property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Sequence[_builtins.str]:
        """
        Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
        "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @_builtins.property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigCaOptionResult']:
        """
        Describes values that are relevant in a CA certificate.
        """
        return pulumi.get(self, "ca_options")

    @_builtins.property
    @pulumi.getter(name="keyUsages")
    def key_usages(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageResult']:
        """
        Indicates the intended use for keys that correspond to a certificate.
        """
        return pulumi.get(self, "key_usages")

    @_builtins.property
    @pulumi.getter(name="nameConstraints")
    def name_constraints(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigNameConstraintResult']:
        """
        Describes the X.509 name constraints extension.
        """
        return pulumi.get(self, "name_constraints")

    @_builtins.property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigPolicyIdResult']:
        """
        Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        return pulumi.get(self, "policy_ids")


@pulumi.output_type
class GetAuthorityConfigX509ConfigAdditionalExtensionResult(dict):
    def __init__(__self__, *,
                 critical: _builtins.bool,
                 object_ids: Sequence['outputs.GetAuthorityConfigX509ConfigAdditionalExtensionObjectIdResult'],
                 value: _builtins.str):
        """
        :param _builtins.bool critical: Indicates whether or not this extension is critical (i.e., if the client does not know how to
               handle this extension, the client should consider this to be an error).
        :param Sequence['GetAuthorityConfigX509ConfigAdditionalExtensionObjectIdArgs'] object_ids: Describes values that are relevant in a CA certificate.
        :param _builtins.str value: The value of this X.509 extension. A base64-encoded string.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "object_ids", object_ids)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not this extension is critical (i.e., if the client does not know how to
        handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigAdditionalExtensionObjectIdResult']:
        """
        Describes values that are relevant in a CA certificate.
        """
        return pulumi.get(self, "object_ids")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of this X.509 extension. A base64-encoded string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAuthorityConfigX509ConfigAdditionalExtensionObjectIdResult(dict):
    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class GetAuthorityConfigX509ConfigCaOptionResult(dict):
    def __init__(__self__, *,
                 is_ca: _builtins.bool,
                 max_issuer_path_length: _builtins.int,
                 non_ca: _builtins.bool,
                 zero_max_issuer_path_length: _builtins.bool):
        """
        :param _builtins.bool is_ca: When true, the "CA" in Basic Constraints extension will be set to true.
        :param _builtins.int max_issuer_path_length: Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
               subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. Setting the value to 0
               requires setting 'zero_max_issuer_path_length = true'.
        :param _builtins.bool non_ca: When true, the "CA" in Basic Constraints extension will be set to false.
               If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
        :param _builtins.bool zero_max_issuer_path_length: When true, the "path length constraint" in Basic Constraints extension will be set to 0.
               If both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
               the max path length will be omitted from the CA certificate.
        """
        pulumi.set(__self__, "is_ca", is_ca)
        pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)
        pulumi.set(__self__, "non_ca", non_ca)
        pulumi.set(__self__, "zero_max_issuer_path_length", zero_max_issuer_path_length)

    @_builtins.property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> _builtins.bool:
        """
        When true, the "CA" in Basic Constraints extension will be set to true.
        """
        return pulumi.get(self, "is_ca")

    @_builtins.property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> _builtins.int:
        """
        Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
        subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. Setting the value to 0
        requires setting 'zero_max_issuer_path_length = true'.
        """
        return pulumi.get(self, "max_issuer_path_length")

    @_builtins.property
    @pulumi.getter(name="nonCa")
    def non_ca(self) -> _builtins.bool:
        """
        When true, the "CA" in Basic Constraints extension will be set to false.
        If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "non_ca")

    @_builtins.property
    @pulumi.getter(name="zeroMaxIssuerPathLength")
    def zero_max_issuer_path_length(self) -> _builtins.bool:
        """
        When true, the "path length constraint" in Basic Constraints extension will be set to 0.
        If both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
        the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "zero_max_issuer_path_length")


@pulumi.output_type
class GetAuthorityConfigX509ConfigKeyUsageResult(dict):
    def __init__(__self__, *,
                 base_key_usages: Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageBaseKeyUsageResult'],
                 extended_key_usages: Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageResult'],
                 unknown_extended_key_usages: Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageResult']):
        """
        :param Sequence['GetAuthorityConfigX509ConfigKeyUsageBaseKeyUsageArgs'] base_key_usages: Describes high-level ways in which a key may be used.
        :param Sequence['GetAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageArgs'] extended_key_usages: Describes high-level ways in which a key may be used.
        :param Sequence['GetAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageArgs'] unknown_extended_key_usages: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "base_key_usages", base_key_usages)
        pulumi.set(__self__, "extended_key_usages", extended_key_usages)
        pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @_builtins.property
    @pulumi.getter(name="baseKeyUsages")
    def base_key_usages(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageBaseKeyUsageResult']:
        """
        Describes high-level ways in which a key may be used.
        """
        return pulumi.get(self, "base_key_usages")

    @_builtins.property
    @pulumi.getter(name="extendedKeyUsages")
    def extended_key_usages(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageResult']:
        """
        Describes high-level ways in which a key may be used.
        """
        return pulumi.get(self, "extended_key_usages")

    @_builtins.property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Sequence['outputs.GetAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageResult']:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class GetAuthorityConfigX509ConfigKeyUsageBaseKeyUsageResult(dict):
    def __init__(__self__, *,
                 cert_sign: _builtins.bool,
                 content_commitment: _builtins.bool,
                 crl_sign: _builtins.bool,
                 data_encipherment: _builtins.bool,
                 decipher_only: _builtins.bool,
                 digital_signature: _builtins.bool,
                 encipher_only: _builtins.bool,
                 key_agreement: _builtins.bool,
                 key_encipherment: _builtins.bool):
        """
        :param _builtins.bool cert_sign: The key may be used to sign certificates.
        :param _builtins.bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param _builtins.bool crl_sign: The key may be used sign certificate revocation lists.
        :param _builtins.bool data_encipherment: The key may be used to encipher data.
        :param _builtins.bool decipher_only: The key may be used to decipher only.
        :param _builtins.bool digital_signature: The key may be used for digital signatures.
        :param _builtins.bool encipher_only: The key may be used to encipher only.
        :param _builtins.bool key_agreement: The key may be used in a key agreement protocol.
        :param _builtins.bool key_encipherment: The key may be used to encipher other keys.
        """
        pulumi.set(__self__, "cert_sign", cert_sign)
        pulumi.set(__self__, "content_commitment", content_commitment)
        pulumi.set(__self__, "crl_sign", crl_sign)
        pulumi.set(__self__, "data_encipherment", data_encipherment)
        pulumi.set(__self__, "decipher_only", decipher_only)
        pulumi.set(__self__, "digital_signature", digital_signature)
        pulumi.set(__self__, "encipher_only", encipher_only)
        pulumi.set(__self__, "key_agreement", key_agreement)
        pulumi.set(__self__, "key_encipherment", key_encipherment)

    @_builtins.property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> _builtins.bool:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @_builtins.property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> _builtins.bool:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @_builtins.property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> _builtins.bool:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @_builtins.property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> _builtins.bool:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @_builtins.property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> _builtins.bool:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @_builtins.property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> _builtins.bool:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @_builtins.property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> _builtins.bool:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @_builtins.property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> _builtins.bool:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @_builtins.property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> _builtins.bool:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class GetAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageResult(dict):
    def __init__(__self__, *,
                 client_auth: _builtins.bool,
                 code_signing: _builtins.bool,
                 email_protection: _builtins.bool,
                 ocsp_signing: _builtins.bool,
                 server_auth: _builtins.bool,
                 time_stamping: _builtins.bool):
        """
        :param _builtins.bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param _builtins.bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param _builtins.bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param _builtins.bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param _builtins.bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        pulumi.set(__self__, "client_auth", client_auth)
        pulumi.set(__self__, "code_signing", code_signing)
        pulumi.set(__self__, "email_protection", email_protection)
        pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        pulumi.set(__self__, "server_auth", server_auth)
        pulumi.set(__self__, "time_stamping", time_stamping)

    @_builtins.property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @_builtins.property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @_builtins.property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @_builtins.property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @_builtins.property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @_builtins.property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> _builtins.bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class GetAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsageResult(dict):
    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class GetAuthorityConfigX509ConfigNameConstraintResult(dict):
    def __init__(__self__, *,
                 critical: _builtins.bool,
                 excluded_dns_names: Sequence[_builtins.str],
                 excluded_email_addresses: Sequence[_builtins.str],
                 excluded_ip_ranges: Sequence[_builtins.str],
                 excluded_uris: Sequence[_builtins.str],
                 permitted_dns_names: Sequence[_builtins.str],
                 permitted_email_addresses: Sequence[_builtins.str],
                 permitted_ip_ranges: Sequence[_builtins.str],
                 permitted_uris: Sequence[_builtins.str]):
        """
        :param _builtins.bool critical: Indicates whether or not the name constraints are marked critical.
        :param Sequence[_builtins.str] excluded_dns_names: Contains excluded DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, 'example.com', 'www.example.com', 'www.sub.example.com'
               would satisfy 'example.com' while 'example1.com' does not.
        :param Sequence[_builtins.str] excluded_email_addresses: Contains the excluded email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. '.example.com') to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] excluded_ip_ranges: Contains the excluded IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] excluded_uris: Contains the excluded URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like '.example.com')
        :param Sequence[_builtins.str] permitted_dns_names: Contains permitted DNS names. Any DNS name that can be
               constructed by simply adding zero or more labels to
               the left-hand side of the name satisfies the name constraint.
               For example, 'example.com', 'www.example.com', 'www.sub.example.com'
               would satisfy 'example.com' while 'example1.com' does not.
        :param Sequence[_builtins.str] permitted_email_addresses: Contains the permitted email addresses. The value can be a particular
               email address, a hostname to indicate all email addresses on that host or
               a domain with a leading period (e.g. '.example.com') to indicate
               all email addresses in that domain.
        :param Sequence[_builtins.str] permitted_ip_ranges: Contains the permitted IP ranges. For IPv4 addresses, the ranges
               are expressed using CIDR notation as specified in RFC 4632.
               For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
               addresses.
        :param Sequence[_builtins.str] permitted_uris: Contains the permitted URIs that apply to the host part of the name.
               The value can be a hostname or a domain with a
               leading period (like '.example.com')
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "excluded_dns_names", excluded_dns_names)
        pulumi.set(__self__, "excluded_email_addresses", excluded_email_addresses)
        pulumi.set(__self__, "excluded_ip_ranges", excluded_ip_ranges)
        pulumi.set(__self__, "excluded_uris", excluded_uris)
        pulumi.set(__self__, "permitted_dns_names", permitted_dns_names)
        pulumi.set(__self__, "permitted_email_addresses", permitted_email_addresses)
        pulumi.set(__self__, "permitted_ip_ranges", permitted_ip_ranges)
        pulumi.set(__self__, "permitted_uris", permitted_uris)

    @_builtins.property
    @pulumi.getter
    def critical(self) -> _builtins.bool:
        """
        Indicates whether or not the name constraints are marked critical.
        """
        return pulumi.get(self, "critical")

    @_builtins.property
    @pulumi.getter(name="excludedDnsNames")
    def excluded_dns_names(self) -> Sequence[_builtins.str]:
        """
        Contains excluded DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, 'example.com', 'www.example.com', 'www.sub.example.com'
        would satisfy 'example.com' while 'example1.com' does not.
        """
        return pulumi.get(self, "excluded_dns_names")

    @_builtins.property
    @pulumi.getter(name="excludedEmailAddresses")
    def excluded_email_addresses(self) -> Sequence[_builtins.str]:
        """
        Contains the excluded email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. '.example.com') to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "excluded_email_addresses")

    @_builtins.property
    @pulumi.getter(name="excludedIpRanges")
    def excluded_ip_ranges(self) -> Sequence[_builtins.str]:
        """
        Contains the excluded IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "excluded_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="excludedUris")
    def excluded_uris(self) -> Sequence[_builtins.str]:
        """
        Contains the excluded URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like '.example.com')
        """
        return pulumi.get(self, "excluded_uris")

    @_builtins.property
    @pulumi.getter(name="permittedDnsNames")
    def permitted_dns_names(self) -> Sequence[_builtins.str]:
        """
        Contains permitted DNS names. Any DNS name that can be
        constructed by simply adding zero or more labels to
        the left-hand side of the name satisfies the name constraint.
        For example, 'example.com', 'www.example.com', 'www.sub.example.com'
        would satisfy 'example.com' while 'example1.com' does not.
        """
        return pulumi.get(self, "permitted_dns_names")

    @_builtins.property
    @pulumi.getter(name="permittedEmailAddresses")
    def permitted_email_addresses(self) -> Sequence[_builtins.str]:
        """
        Contains the permitted email addresses. The value can be a particular
        email address, a hostname to indicate all email addresses on that host or
        a domain with a leading period (e.g. '.example.com') to indicate
        all email addresses in that domain.
        """
        return pulumi.get(self, "permitted_email_addresses")

    @_builtins.property
    @pulumi.getter(name="permittedIpRanges")
    def permitted_ip_ranges(self) -> Sequence[_builtins.str]:
        """
        Contains the permitted IP ranges. For IPv4 addresses, the ranges
        are expressed using CIDR notation as specified in RFC 4632.
        For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
        addresses.
        """
        return pulumi.get(self, "permitted_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="permittedUris")
    def permitted_uris(self) -> Sequence[_builtins.str]:
        """
        Contains the permitted URIs that apply to the host part of the name.
        The value can be a hostname or a domain with a
        leading period (like '.example.com')
        """
        return pulumi.get(self, "permitted_uris")


@pulumi.output_type
class GetAuthorityConfigX509ConfigPolicyIdResult(dict):
    def __init__(__self__, *,
                 object_id_paths: Sequence[_builtins.int]):
        """
        :param Sequence[_builtins.int] object_id_paths: An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        pulumi.set(__self__, "object_id_paths", object_id_paths)

    @_builtins.property
    @pulumi.getter(name="objectIdPaths")
    def object_id_paths(self) -> Sequence[_builtins.int]:
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        """
        return pulumi.get(self, "object_id_paths")


@pulumi.output_type
class GetAuthorityKeySpecResult(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 cloud_kms_key_version: _builtins.str):
        """
        :param _builtins.str algorithm: The algorithm to use for creating a managed Cloud KMS key for a for a simplified
               experience. All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
        :param _builtins.str cloud_kms_key_version: The resource name for an existing Cloud KMS CryptoKeyVersion in the format
               'projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*'.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        The algorithm to use for creating a managed Cloud KMS key for a for a simplified
        experience. All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> _builtins.str:
        """
        The resource name for an existing Cloud KMS CryptoKeyVersion in the format
        'projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*'.
        """
        return pulumi.get(self, "cloud_kms_key_version")


@pulumi.output_type
class GetAuthoritySubordinateConfigResult(dict):
    def __init__(__self__, *,
                 certificate_authority: _builtins.str,
                 pem_issuer_chains: Sequence['outputs.GetAuthoritySubordinateConfigPemIssuerChainResult']):
        """
        :param _builtins.str certificate_authority: This can refer to a CertificateAuthority that was used to create a
               subordinate CertificateAuthority. This field is used for information
               and usability purposes only. The resource name is in the format
               'projects/*/locations/*/caPools/*/certificateAuthorities/*'.
        :param Sequence['GetAuthoritySubordinateConfigPemIssuerChainArgs'] pem_issuer_chains: Contains the PEM certificate chain for the issuers of this CertificateAuthority,
               but not pem certificate for this CA itself.
        """
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        pulumi.set(__self__, "pem_issuer_chains", pem_issuer_chains)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> _builtins.str:
        """
        This can refer to a CertificateAuthority that was used to create a
        subordinate CertificateAuthority. This field is used for information
        and usability purposes only. The resource name is in the format
        'projects/*/locations/*/caPools/*/certificateAuthorities/*'.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="pemIssuerChains")
    def pem_issuer_chains(self) -> Sequence['outputs.GetAuthoritySubordinateConfigPemIssuerChainResult']:
        """
        Contains the PEM certificate chain for the issuers of this CertificateAuthority,
        but not pem certificate for this CA itself.
        """
        return pulumi.get(self, "pem_issuer_chains")


@pulumi.output_type
class GetAuthoritySubordinateConfigPemIssuerChainResult(dict):
    def __init__(__self__, *,
                 pem_certificates: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] pem_certificates: Expected to be in leaf-to-root order according to RFC 5246.
        """
        pulumi.set(__self__, "pem_certificates", pem_certificates)

    @_builtins.property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> Sequence[_builtins.str]:
        """
        Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")


@pulumi.output_type
class GetAuthorityUserDefinedAccessUrlResult(dict):
    def __init__(__self__, *,
                 aia_issuing_certificate_urls: Sequence[_builtins.str],
                 crl_access_urls: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] aia_issuing_certificate_urls: A list of URLs where this CertificateAuthority's CA certificate is published that is specified by users.
        :param Sequence[_builtins.str] crl_access_urls: A list of URLs where this CertificateAuthority's CRLs are published that is specified by users.
        """
        pulumi.set(__self__, "aia_issuing_certificate_urls", aia_issuing_certificate_urls)
        pulumi.set(__self__, "crl_access_urls", crl_access_urls)

    @_builtins.property
    @pulumi.getter(name="aiaIssuingCertificateUrls")
    def aia_issuing_certificate_urls(self) -> Sequence[_builtins.str]:
        """
        A list of URLs where this CertificateAuthority's CA certificate is published that is specified by users.
        """
        return pulumi.get(self, "aia_issuing_certificate_urls")

    @_builtins.property
    @pulumi.getter(name="crlAccessUrls")
    def crl_access_urls(self) -> Sequence[_builtins.str]:
        """
        A list of URLs where this CertificateAuthority's CRLs are published that is specified by users.
        """
        return pulumi.get(self, "crl_access_urls")


