# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsAuthorizationArgs', 'DnsAuthorization']

@pulumi.input_type
class DnsAuthorizationArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DnsAuthorization resource.
        :param pulumi.Input[_builtins.str] domain: A domain which is being authorized. A DnsAuthorization resource covers a
               single domain and its wildcard, e.g. authorization for "example.com" can
               be used to issue certificates for "example.com" and "*.example.com".
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the DNS Authorization resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
               be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
               FIXED_RECORD DNS authorization uses DNS-01 validation method
               PER_PROJECT_RECORD DNS authorization allows for independent management
               of Google-managed certificates with DNS authorization across multiple
               projects.
               Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        pulumi.set(__self__, "domain", domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        A domain which is being authorized. A DnsAuthorization resource covers a
        single domain and its wildcard, e.g. authorization for "example.com" can
        be used to issue certificates for "example.com" and "*.example.com".
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the DNS Authorization resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
        be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
        FIXED_RECORD DNS authorization uses DNS-01 validation method
        PER_PROJECT_RECORD DNS authorization allows for independent management
        of Google-managed certificates with DNS authorization across multiple
        projects.
        Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DnsAuthorizationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_resource_records: Optional[pulumi.Input[Sequence[pulumi.Input['DnsAuthorizationDnsResourceRecordArgs']]]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DnsAuthorization resources.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['DnsAuthorizationDnsResourceRecordArgs']]] dns_resource_records: The structure describing the DNS Resource Record that needs to be added
               to DNS configuration for the authorization to be usable by
               certificate.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] domain: A domain which is being authorized. A DnsAuthorization resource covers a
               single domain and its wildcard, e.g. authorization for "example.com" can
               be used to issue certificates for "example.com" and "*.example.com".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the DNS Authorization resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] type: type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
               be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
               FIXED_RECORD DNS authorization uses DNS-01 validation method
               PER_PROJECT_RECORD DNS authorization allows for independent management
               of Google-managed certificates with DNS authorization across multiple
               projects.
               Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_resource_records is not None:
            pulumi.set(__self__, "dns_resource_records", dns_resource_records)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsResourceRecords")
    def dns_resource_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsAuthorizationDnsResourceRecordArgs']]]]:
        """
        The structure describing the DNS Resource Record that needs to be added
        to DNS configuration for the authorization to be usable by
        certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "dns_resource_records")

    @dns_resource_records.setter
    def dns_resource_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsAuthorizationDnsResourceRecordArgs']]]]):
        pulumi.set(self, "dns_resource_records", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain which is being authorized. A DnsAuthorization resource covers a
        single domain and its wildcard, e.g. authorization for "example.com" can
        be used to issue certificates for "example.com" and "*.example.com".
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the DNS Authorization resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
        be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
        FIXED_RECORD DNS authorization uses DNS-01 validation method
        PER_PROJECT_RECORD DNS authorization allows for independent management
        of Google-managed certificates with DNS authorization across multiple
        projects.
        Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:certificatemanager/dnsAuthorization:DnsAuthorization")
class DnsAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        DnsAuthorization represents a HTTP-reachable backend for a DnsAuthorization.

        ## Example Usage

        ### Certificate Manager Dns Authorization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificatemanager.DnsAuthorization("default",
            name="dns-auth",
            location="global",
            description="The default dns",
            domain="subdomain.hashicorptest.com")
        pulumi.export("recordNameToInsert", default.dns_resource_records[0].name)
        pulumi.export("recordTypeToInsert", default.dns_resource_records[0].type)
        pulumi.export("recordDataToInsert", default.dns_resource_records[0].data)
        ```
        ### Certificate Manager Dns Authorization Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificatemanager.DnsAuthorization("default",
            name="dns-auth",
            location="us-central1",
            description="reginal dns",
            type="PER_PROJECT_RECORD",
            domain="subdomain.hashicorptest.com")
        ```

        ## Import

        DnsAuthorization can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dnsAuthorizations/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DnsAuthorization can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default projects/{{project}}/locations/{{location}}/dnsAuthorizations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[_builtins.str] domain: A domain which is being authorized. A DnsAuthorization resource covers a
               single domain and its wildcard, e.g. authorization for "example.com" can
               be used to issue certificates for "example.com" and "*.example.com".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the DNS Authorization resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] type: type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
               be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
               FIXED_RECORD DNS authorization uses DNS-01 validation method
               PER_PROJECT_RECORD DNS authorization allows for independent management
               of Google-managed certificates with DNS authorization across multiple
               projects.
               Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        DnsAuthorization represents a HTTP-reachable backend for a DnsAuthorization.

        ## Example Usage

        ### Certificate Manager Dns Authorization Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificatemanager.DnsAuthorization("default",
            name="dns-auth",
            location="global",
            description="The default dns",
            domain="subdomain.hashicorptest.com")
        pulumi.export("recordNameToInsert", default.dns_resource_records[0].name)
        pulumi.export("recordTypeToInsert", default.dns_resource_records[0].type)
        pulumi.export("recordDataToInsert", default.dns_resource_records[0].data)
        ```
        ### Certificate Manager Dns Authorization Regional

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificatemanager.DnsAuthorization("default",
            name="dns-auth",
            location="us-central1",
            description="reginal dns",
            type="PER_PROJECT_RECORD",
            domain="subdomain.hashicorptest.com")
        ```

        ## Import

        DnsAuthorization can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/dnsAuthorizations/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, DnsAuthorization can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default projects/{{project}}/locations/{{location}}/dnsAuthorizations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/dnsAuthorization:DnsAuthorization default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DnsAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsAuthorizationArgs.__new__(DnsAuthorizationArgs)

            __props__.__dict__["description"] = description
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["type"] = type
            __props__.__dict__["dns_resource_records"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DnsAuthorization, __self__).__init__(
            'gcp:certificatemanager/dnsAuthorization:DnsAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_resource_records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsAuthorizationDnsResourceRecordArgs', 'DnsAuthorizationDnsResourceRecordArgsDict']]]]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DnsAuthorization':
        """
        Get an existing DnsAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsAuthorizationDnsResourceRecordArgs', 'DnsAuthorizationDnsResourceRecordArgsDict']]]] dns_resource_records: The structure describing the DNS Resource Record that needs to be added
               to DNS configuration for the authorization to be usable by
               certificate.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] domain: A domain which is being authorized. A DnsAuthorization resource covers a
               single domain and its wildcard, e.g. authorization for "example.com" can
               be used to issue certificates for "example.com" and "*.example.com".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the DNS Authorization resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The Certificate Manager location. If not specified, "global" is used.
        :param pulumi.Input[_builtins.str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] type: type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
               be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
               FIXED_RECORD DNS authorization uses DNS-01 validation method
               PER_PROJECT_RECORD DNS authorization allows for independent management
               of Google-managed certificates with DNS authorization across multiple
               projects.
               Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsAuthorizationState.__new__(_DnsAuthorizationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dns_resource_records"] = dns_resource_records
        __props__.__dict__["domain"] = domain
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["type"] = type
        return DnsAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsResourceRecords")
    def dns_resource_records(self) -> pulumi.Output[Sequence['outputs.DnsAuthorizationDnsResourceRecord']]:
        """
        The structure describing the DNS Resource Record that needs to be added
        to DNS configuration for the authorization to be usable by
        certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "dns_resource_records")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        A domain which is being authorized. A DnsAuthorization resource covers a
        single domain and its wildcard, e.g. authorization for "example.com" can
        be used to issue certificates for "example.com" and "*.example.com".
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of label tags associated with the DNS Authorization resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Certificate Manager location. If not specified, "global" is used.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        type of DNS authorization. If unset during the resource creation, FIXED_RECORD will
        be used for global resources, and PER_PROJECT_RECORD will be used for other locations.
        FIXED_RECORD DNS authorization uses DNS-01 validation method
        PER_PROJECT_RECORD DNS authorization allows for independent management
        of Google-managed certificates with DNS authorization across multiple
        projects.
        Possible values are: `FIXED_RECORD`, `PER_PROJECT_RECORD`.
        """
        return pulumi.get(self, "type")

