# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 audio_processing_config: Optional[pulumi.Input['AppAudioProcessingConfigArgs']] = None,
                 data_store_settings: Optional[pulumi.Input['AppDataStoreSettingsArgs']] = None,
                 default_channel_profile: Optional[pulumi.Input['AppDefaultChannelProfileArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation_metrics_thresholds: Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']] = None,
                 global_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language_settings: Optional[pulumi.Input['AppLanguageSettingsArgs']] = None,
                 logging_settings: Optional[pulumi.Input['AppLoggingSettingsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_settings: Optional[pulumi.Input['AppModelSettingsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 root_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_settings: Optional[pulumi.Input['AppTimeZoneSettingsArgs']] = None,
                 variable_declarations: Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[_builtins.str] app_id: The ID to use for the app, which will become the final component of
               the app's resource name. If not provided, a unique ID will be
               automatically assigned for the app.
        :param pulumi.Input[_builtins.str] display_name: Display name of the app.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['AppAudioProcessingConfigArgs'] audio_processing_config: Configuration for how the input and output audio should be processed and
               delivered.
               Structure is documented below.
        :param pulumi.Input['AppDataStoreSettingsArgs'] data_store_settings: Data store related settings for the app.
               Structure is documented below.
        :param pulumi.Input['AppDefaultChannelProfileArgs'] default_channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the app.
        :param pulumi.Input['AppEvaluationMetricsThresholdsArgs'] evaluation_metrics_thresholds: Threshold settings for metrics in an Evaluation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] global_instruction: Instructions for all the agents in the app.
               You can use this instruction to set up a stable identity or personality
               across all the agents.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrails: List of guardrails for the app.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        :param pulumi.Input['AppLanguageSettingsArgs'] language_settings: Language settings of the app.
               Structure is documented below.
        :param pulumi.Input['AppLoggingSettingsArgs'] logging_settings: Settings to describe the logging behaviors for the app.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata about the app. This field can be used to store additional
               information relevant to the app's details or intended usages.
        :param pulumi.Input['AppModelSettingsArgs'] model_settings: Model settings contains various configurations for the LLM model.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] root_agent: The root agent is the entry point of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        :param pulumi.Input['AppTimeZoneSettingsArgs'] time_zone_settings: TimeZone settings of the app.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]] variable_declarations: The declarations of the variables.
               Structure is documented below.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if audio_processing_config is not None:
            pulumi.set(__self__, "audio_processing_config", audio_processing_config)
        if data_store_settings is not None:
            pulumi.set(__self__, "data_store_settings", data_store_settings)
        if default_channel_profile is not None:
            pulumi.set(__self__, "default_channel_profile", default_channel_profile)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if evaluation_metrics_thresholds is not None:
            pulumi.set(__self__, "evaluation_metrics_thresholds", evaluation_metrics_thresholds)
        if global_instruction is not None:
            pulumi.set(__self__, "global_instruction", global_instruction)
        if guardrails is not None:
            pulumi.set(__self__, "guardrails", guardrails)
        if language_settings is not None:
            pulumi.set(__self__, "language_settings", language_settings)
        if logging_settings is not None:
            pulumi.set(__self__, "logging_settings", logging_settings)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if root_agent is not None:
            pulumi.set(__self__, "root_agent", root_agent)
        if time_zone_settings is not None:
            pulumi.set(__self__, "time_zone_settings", time_zone_settings)
        if variable_declarations is not None:
            pulumi.set(__self__, "variable_declarations", variable_declarations)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the app, which will become the final component of
        the app's resource name. If not provided, a unique ID will be
        automatically assigned for the app.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the app.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="audioProcessingConfig")
    def audio_processing_config(self) -> Optional[pulumi.Input['AppAudioProcessingConfigArgs']]:
        """
        Configuration for how the input and output audio should be processed and
        delivered.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_processing_config")

    @audio_processing_config.setter
    def audio_processing_config(self, value: Optional[pulumi.Input['AppAudioProcessingConfigArgs']]):
        pulumi.set(self, "audio_processing_config", value)

    @_builtins.property
    @pulumi.getter(name="dataStoreSettings")
    def data_store_settings(self) -> Optional[pulumi.Input['AppDataStoreSettingsArgs']]:
        """
        Data store related settings for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_settings")

    @data_store_settings.setter
    def data_store_settings(self, value: Optional[pulumi.Input['AppDataStoreSettingsArgs']]):
        pulumi.set(self, "data_store_settings", value)

    @_builtins.property
    @pulumi.getter(name="defaultChannelProfile")
    def default_channel_profile(self) -> Optional[pulumi.Input['AppDefaultChannelProfileArgs']]:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "default_channel_profile")

    @default_channel_profile.setter
    def default_channel_profile(self, value: Optional[pulumi.Input['AppDefaultChannelProfileArgs']]):
        pulumi.set(self, "default_channel_profile", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="evaluationMetricsThresholds")
    def evaluation_metrics_thresholds(self) -> Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']]:
        """
        Threshold settings for metrics in an Evaluation.
        Structure is documented below.
        """
        return pulumi.get(self, "evaluation_metrics_thresholds")

    @evaluation_metrics_thresholds.setter
    def evaluation_metrics_thresholds(self, value: Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']]):
        pulumi.set(self, "evaluation_metrics_thresholds", value)

    @_builtins.property
    @pulumi.getter(name="globalInstruction")
    def global_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions for all the agents in the app.
        You can use this instruction to set up a stable identity or personality
        across all the agents.
        """
        return pulumi.get(self, "global_instruction")

    @global_instruction.setter
    def global_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instruction", value)

    @_builtins.property
    @pulumi.getter
    def guardrails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of guardrails for the app.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        """
        return pulumi.get(self, "guardrails")

    @guardrails.setter
    def guardrails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guardrails", value)

    @_builtins.property
    @pulumi.getter(name="languageSettings")
    def language_settings(self) -> Optional[pulumi.Input['AppLanguageSettingsArgs']]:
        """
        Language settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "language_settings")

    @language_settings.setter
    def language_settings(self, value: Optional[pulumi.Input['AppLanguageSettingsArgs']]):
        pulumi.set(self, "language_settings", value)

    @_builtins.property
    @pulumi.getter(name="loggingSettings")
    def logging_settings(self) -> Optional[pulumi.Input['AppLoggingSettingsArgs']]:
        """
        Settings to describe the logging behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_settings")

    @logging_settings.setter
    def logging_settings(self, value: Optional[pulumi.Input['AppLoggingSettingsArgs']]):
        pulumi.set(self, "logging_settings", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata about the app. This field can be used to store additional
        information relevant to the app's details or intended usages.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['AppModelSettingsArgs']]:
        """
        Model settings contains various configurations for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['AppModelSettingsArgs']]):
        pulumi.set(self, "model_settings", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rootAgent")
    def root_agent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root agent is the entry point of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        """
        return pulumi.get(self, "root_agent")

    @root_agent.setter
    def root_agent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_agent", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneSettings")
    def time_zone_settings(self) -> Optional[pulumi.Input['AppTimeZoneSettingsArgs']]:
        """
        TimeZone settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "time_zone_settings")

    @time_zone_settings.setter
    def time_zone_settings(self, value: Optional[pulumi.Input['AppTimeZoneSettingsArgs']]):
        pulumi.set(self, "time_zone_settings", value)

    @_builtins.property
    @pulumi.getter(name="variableDeclarations")
    def variable_declarations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]]:
        """
        The declarations of the variables.
        Structure is documented below.
        """
        return pulumi.get(self, "variable_declarations")

    @variable_declarations.setter
    def variable_declarations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]]):
        pulumi.set(self, "variable_declarations", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_processing_config: Optional[pulumi.Input['AppAudioProcessingConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_store_settings: Optional[pulumi.Input['AppDataStoreSettingsArgs']] = None,
                 default_channel_profile: Optional[pulumi.Input['AppDefaultChannelProfileArgs']] = None,
                 deployment_count: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation_metrics_thresholds: Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']] = None,
                 global_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language_settings: Optional[pulumi.Input['AppLanguageSettingsArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_settings: Optional[pulumi.Input['AppLoggingSettingsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_settings: Optional[pulumi.Input['AppModelSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 root_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_settings: Optional[pulumi.Input['AppTimeZoneSettingsArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_declarations: Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input[_builtins.str] app_id: The ID to use for the app, which will become the final component of
               the app's resource name. If not provided, a unique ID will be
               automatically assigned for the app.
        :param pulumi.Input['AppAudioProcessingConfigArgs'] audio_processing_config: Configuration for how the input and output audio should be processed and
               delivered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the app was created.
        :param pulumi.Input['AppDataStoreSettingsArgs'] data_store_settings: Data store related settings for the app.
               Structure is documented below.
        :param pulumi.Input['AppDefaultChannelProfileArgs'] default_channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] deployment_count: Number of deployments in the app.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the app.
        :param pulumi.Input[_builtins.str] display_name: Display name of the app.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input['AppEvaluationMetricsThresholdsArgs'] evaluation_metrics_thresholds: Threshold settings for metrics in an Evaluation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] global_instruction: Instructions for all the agents in the app.
               You can use this instruction to set up a stable identity or personality
               across all the agents.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrails: List of guardrails for the app.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        :param pulumi.Input['AppLanguageSettingsArgs'] language_settings: Language settings of the app.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['AppLoggingSettingsArgs'] logging_settings: Settings to describe the logging behaviors for the app.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata about the app. This field can be used to store additional
               information relevant to the app's details or intended usages.
        :param pulumi.Input['AppModelSettingsArgs'] model_settings: Model settings contains various configurations for the LLM model.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] root_agent: The root agent is the entry point of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        :param pulumi.Input['AppTimeZoneSettingsArgs'] time_zone_settings: TimeZone settings of the app.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the app was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]] variable_declarations: The declarations of the variables.
               Structure is documented below.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if audio_processing_config is not None:
            pulumi.set(__self__, "audio_processing_config", audio_processing_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_settings is not None:
            pulumi.set(__self__, "data_store_settings", data_store_settings)
        if default_channel_profile is not None:
            pulumi.set(__self__, "default_channel_profile", default_channel_profile)
        if deployment_count is not None:
            pulumi.set(__self__, "deployment_count", deployment_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if evaluation_metrics_thresholds is not None:
            pulumi.set(__self__, "evaluation_metrics_thresholds", evaluation_metrics_thresholds)
        if global_instruction is not None:
            pulumi.set(__self__, "global_instruction", global_instruction)
        if guardrails is not None:
            pulumi.set(__self__, "guardrails", guardrails)
        if language_settings is not None:
            pulumi.set(__self__, "language_settings", language_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_settings is not None:
            pulumi.set(__self__, "logging_settings", logging_settings)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if root_agent is not None:
            pulumi.set(__self__, "root_agent", root_agent)
        if time_zone_settings is not None:
            pulumi.set(__self__, "time_zone_settings", time_zone_settings)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if variable_declarations is not None:
            pulumi.set(__self__, "variable_declarations", variable_declarations)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the app, which will become the final component of
        the app's resource name. If not provided, a unique ID will be
        automatically assigned for the app.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="audioProcessingConfig")
    def audio_processing_config(self) -> Optional[pulumi.Input['AppAudioProcessingConfigArgs']]:
        """
        Configuration for how the input and output audio should be processed and
        delivered.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_processing_config")

    @audio_processing_config.setter
    def audio_processing_config(self, value: Optional[pulumi.Input['AppAudioProcessingConfigArgs']]):
        pulumi.set(self, "audio_processing_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the app was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataStoreSettings")
    def data_store_settings(self) -> Optional[pulumi.Input['AppDataStoreSettingsArgs']]:
        """
        Data store related settings for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_settings")

    @data_store_settings.setter
    def data_store_settings(self, value: Optional[pulumi.Input['AppDataStoreSettingsArgs']]):
        pulumi.set(self, "data_store_settings", value)

    @_builtins.property
    @pulumi.getter(name="defaultChannelProfile")
    def default_channel_profile(self) -> Optional[pulumi.Input['AppDefaultChannelProfileArgs']]:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "default_channel_profile")

    @default_channel_profile.setter
    def default_channel_profile(self, value: Optional[pulumi.Input['AppDefaultChannelProfileArgs']]):
        pulumi.set(self, "default_channel_profile", value)

    @_builtins.property
    @pulumi.getter(name="deploymentCount")
    def deployment_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of deployments in the app.
        """
        return pulumi.get(self, "deployment_count")

    @deployment_count.setter
    def deployment_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deployment_count", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the app.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="evaluationMetricsThresholds")
    def evaluation_metrics_thresholds(self) -> Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']]:
        """
        Threshold settings for metrics in an Evaluation.
        Structure is documented below.
        """
        return pulumi.get(self, "evaluation_metrics_thresholds")

    @evaluation_metrics_thresholds.setter
    def evaluation_metrics_thresholds(self, value: Optional[pulumi.Input['AppEvaluationMetricsThresholdsArgs']]):
        pulumi.set(self, "evaluation_metrics_thresholds", value)

    @_builtins.property
    @pulumi.getter(name="globalInstruction")
    def global_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions for all the agents in the app.
        You can use this instruction to set up a stable identity or personality
        across all the agents.
        """
        return pulumi.get(self, "global_instruction")

    @global_instruction.setter
    def global_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "global_instruction", value)

    @_builtins.property
    @pulumi.getter
    def guardrails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of guardrails for the app.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        """
        return pulumi.get(self, "guardrails")

    @guardrails.setter
    def guardrails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "guardrails", value)

    @_builtins.property
    @pulumi.getter(name="languageSettings")
    def language_settings(self) -> Optional[pulumi.Input['AppLanguageSettingsArgs']]:
        """
        Language settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "language_settings")

    @language_settings.setter
    def language_settings(self, value: Optional[pulumi.Input['AppLanguageSettingsArgs']]):
        pulumi.set(self, "language_settings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingSettings")
    def logging_settings(self) -> Optional[pulumi.Input['AppLoggingSettingsArgs']]:
        """
        Settings to describe the logging behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_settings")

    @logging_settings.setter
    def logging_settings(self, value: Optional[pulumi.Input['AppLoggingSettingsArgs']]):
        pulumi.set(self, "logging_settings", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata about the app. This field can be used to store additional
        information relevant to the app's details or intended usages.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['AppModelSettingsArgs']]:
        """
        Model settings contains various configurations for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['AppModelSettingsArgs']]):
        pulumi.set(self, "model_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The unique identifier of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="rootAgent")
    def root_agent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root agent is the entry point of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        """
        return pulumi.get(self, "root_agent")

    @root_agent.setter
    def root_agent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_agent", value)

    @_builtins.property
    @pulumi.getter(name="timeZoneSettings")
    def time_zone_settings(self) -> Optional[pulumi.Input['AppTimeZoneSettingsArgs']]:
        """
        TimeZone settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "time_zone_settings")

    @time_zone_settings.setter
    def time_zone_settings(self, value: Optional[pulumi.Input['AppTimeZoneSettingsArgs']]):
        pulumi.set(self, "time_zone_settings", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the app was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="variableDeclarations")
    def variable_declarations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]]:
        """
        The declarations of the variables.
        Structure is documented below.
        """
        return pulumi.get(self, "variable_declarations")

    @variable_declarations.setter
    def variable_declarations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppVariableDeclarationArgs']]]]):
        pulumi.set(self, "variable_declarations", value)


@pulumi.type_token("gcp:ces/app:App")
class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_processing_config: Optional[pulumi.Input[Union['AppAudioProcessingConfigArgs', 'AppAudioProcessingConfigArgsDict']]] = None,
                 data_store_settings: Optional[pulumi.Input[Union['AppDataStoreSettingsArgs', 'AppDataStoreSettingsArgsDict']]] = None,
                 default_channel_profile: Optional[pulumi.Input[Union['AppDefaultChannelProfileArgs', 'AppDefaultChannelProfileArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation_metrics_thresholds: Optional[pulumi.Input[Union['AppEvaluationMetricsThresholdsArgs', 'AppEvaluationMetricsThresholdsArgsDict']]] = None,
                 global_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language_settings: Optional[pulumi.Input[Union['AppLanguageSettingsArgs', 'AppLanguageSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_settings: Optional[pulumi.Input[Union['AppLoggingSettingsArgs', 'AppLoggingSettingsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_settings: Optional[pulumi.Input[Union['AppModelSettingsArgs', 'AppModelSettingsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 root_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_settings: Optional[pulumi.Input[Union['AppTimeZoneSettingsArgs', 'AppTimeZoneSettingsArgsDict']]] = None,
                 variable_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppVariableDeclarationArgs', 'AppVariableDeclarationArgsDict']]]]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Ces App Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        ces_app_basic = gcp.ces.App("ces_app_basic",
            app_id="app-id",
            location="us",
            description="Basic CES App example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            audio_processing_config={
                "synthesize_speech_configs": [
                    {
                        "language_code": "en-US",
                        "voice": "en-US-Standard-A",
                        "speaking_rate": 1,
                    },
                    {
                        "language_code": "es-ES",
                        "voice": "es-ES-Standard-A",
                        "speaking_rate": 0.95,
                    },
                ],
                "barge_in_config": {
                    "barge_in_awareness": True,
                },
                "inactivity_timeout": "300s",
                "ambient_sound_config": {
                    "prebuilt_ambient_sound": "room_2",
                    "volume_gain_db": -6,
                },
            },
            logging_settings={
                "redaction_config": {
                    "enable_redaction": True,
                    "inspect_template": "projects/fake-project/locations/us/inspectTemplates/example-inspect",
                    "deidentify_template": "projects/fake-project/locations/us/deidentifyTemplates/example-deidentify",
                },
                "audio_recording_config": {
                    "gcs_bucket": "gs://fake-app-audio-recordings",
                    "gcs_path_prefix": "projects/fake-project/location/us/app/test-app/123/$session/123",
                },
                "bigquery_export_settings": {
                    "dataset": "projects/fake-project/datasets/fake_app_logs",
                    "enabled": False,
                    "project": "projects/fake-project",
                },
                "cloud_logging_settings": {
                    "enable_cloud_logging": True,
                },
                "conversation_logging_settings": {
                    "disable_conversation_logging": True,
                },
            },
            model_settings={
                "model": "gemini-1.5-flash",
                "temperature": 0.5,
            },
            evaluation_metrics_thresholds={
                "golden_evaluation_metrics_thresholds": {
                    "turn_level_metrics_thresholds": {
                        "semantic_similarity_success_threshold": 3,
                        "overall_tool_invocation_correctness_threshold": 1,
                    },
                    "expectation_level_metrics_thresholds": {
                        "tool_invocation_parameter_correctness_threshold": 1,
                    },
                },
            },
            variable_declarations=[{
                "name": "test",
                "description": "test",
                "schema": {
                    "description": "schema description",
                    "type": "ARRAY",
                    "nullable": True,
                    "requireds": ["some_property"],
                    "enums": [
                        "VALUE_A",
                        "VALUE_B",
                    ],
                    "ref": "#/defs/MyDefinition",
                    "unique_items": True,
                    "defs": json.dumps({
                        "SimpleString": {
                            "type": "STRING",
                            "description": "A simple string definition",
                        },
                    }),
                    "any_of": json.dumps([{
                        "type": "STRING",
                        "description": "any_of option 1: string",
                    }]),
                    "default": json.dumps(False),
                    "prefix_items": json.dumps([{
                        "type": "ARRAY",
                        "description": "prefix item 1",
                    }]),
                    "additional_properties": json.dumps({
                        "type": "BOOLEAN",
                    }),
                    "properties": json.dumps({
                        "name": {
                            "type": "STRING",
                            "description": "A name",
                        },
                    }),
                    "items": json.dumps({
                        "type": "ARRAY",
                        "description": "An array",
                    }),
                },
            }],
            global_instruction="You are a virtual assistant for an e-commerce platform. Be friendly and helpful.",
            guardrails=[],
            default_channel_profile={
                "channel_type": "WEB_UI",
                "disable_barge_in_control": False,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CONCISE",
                },
                "profile_id": "profile-id",
                "web_widget_config": {
                    "modality": "CHAT_ONLY",
                    "theme": "LIGHT",
                    "web_widget_title": "Help Assistant",
                },
            },
            metadata={
                "deployment_env": "test",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ```
        ### Ces App Ambient Sound Gcs Uri

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        ces_app_ambient_sound_gcs_uri = gcp.ces.App("ces_app_ambient_sound_gcs_uri",
            app_id="app-id",
            location="us",
            description="Basic CES App example",
            display_name="my-app-ambient-sound-gcs-uri",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            audio_processing_config={
                "synthesize_speech_configs": [
                    {
                        "language_code": "en-US",
                        "voice": "en-US-Standard-A",
                        "speaking_rate": 1,
                    },
                    {
                        "language_code": "es-ES",
                        "voice": "es-ES-Standard-A",
                        "speaking_rate": 0.95,
                    },
                ],
                "barge_in_config": {
                    "barge_in_awareness": True,
                },
                "inactivity_timeout": "300s",
                "ambient_sound_config": {
                    "gcs_uri": "gs://fake-bucket/sounds/ambient.wav",
                    "volume_gain_db": -6,
                },
            },
            logging_settings={
                "redaction_config": {
                    "enable_redaction": True,
                    "inspect_template": "projects/fake-project/locations/us/inspectTemplates/example-inspect",
                    "deidentify_template": "projects/fake-project/locations/us/deidentifyTemplates/example-deidentify",
                },
                "audio_recording_config": {
                    "gcs_bucket": "gs://fake-app-audio-recordings",
                    "gcs_path_prefix": "projects/fake-project/location/us/app/fake-app/123/$session/123",
                },
                "bigquery_export_settings": {
                    "dataset": "projects/fake-project/datasets/fake_app_logs",
                    "enabled": False,
                    "project": "projects/fake-project",
                },
                "cloud_logging_settings": {
                    "enable_cloud_logging": True,
                },
                "conversation_logging_settings": {
                    "disable_conversation_logging": True,
                },
            },
            model_settings={
                "model": "gemini-1.5-flash",
                "temperature": 0.5,
            },
            evaluation_metrics_thresholds={
                "golden_evaluation_metrics_thresholds": {
                    "turn_level_metrics_thresholds": {
                        "semantic_similarity_success_threshold": 3,
                        "overall_tool_invocation_correctness_threshold": 1,
                    },
                    "expectation_level_metrics_thresholds": {
                        "tool_invocation_parameter_correctness_threshold": 1,
                    },
                },
            },
            variable_declarations=[{
                "name": "test",
                "description": "test",
                "schema": {
                    "description": "schema description",
                    "type": "ARRAY",
                    "nullable": True,
                    "requireds": ["some_property"],
                    "enums": [
                        "VALUE_A",
                        "VALUE_B",
                    ],
                    "ref": "#/defs/MyDefinition",
                    "unique_items": True,
                    "defs": json.dumps({
                        "SimpleString": {
                            "type": "STRING",
                            "description": "A simple string definition",
                        },
                    }),
                    "any_of": json.dumps([{
                        "type": "STRING",
                        "description": "any_of option 1: string",
                    }]),
                    "default": json.dumps(False),
                    "prefix_items": json.dumps([{
                        "type": "ARRAY",
                        "description": "prefix item 1",
                    }]),
                    "additional_properties": json.dumps({
                        "type": "BOOLEAN",
                    }),
                    "properties": json.dumps({
                        "name": {
                            "type": "STRING",
                            "description": "A name",
                        },
                    }),
                    "items": json.dumps({
                        "type": "ARRAY",
                        "description": "An array",
                    }),
                },
            }],
            global_instruction="You are a virtual assistant for an e-commerce platform. Be friendly and helpful.",
            guardrails=[],
            default_channel_profile={
                "channel_type": "WEB_UI",
                "disable_barge_in_control": False,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CONCISE",
                },
                "profile_id": "profile-id",
                "web_widget_config": {
                    "modality": "CHAT_ONLY",
                    "theme": "LIGHT",
                    "web_widget_title": "Help Assistant",
                },
            },
            metadata={
                "deployment_env": "test",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ```

        ## Import

        App can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, App can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/app:App default projects/{{project}}/locations/{{location}}/apps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/app:App default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/app:App default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID to use for the app, which will become the final component of
               the app's resource name. If not provided, a unique ID will be
               automatically assigned for the app.
        :param pulumi.Input[Union['AppAudioProcessingConfigArgs', 'AppAudioProcessingConfigArgsDict']] audio_processing_config: Configuration for how the input and output audio should be processed and
               delivered.
               Structure is documented below.
        :param pulumi.Input[Union['AppDataStoreSettingsArgs', 'AppDataStoreSettingsArgsDict']] data_store_settings: Data store related settings for the app.
               Structure is documented below.
        :param pulumi.Input[Union['AppDefaultChannelProfileArgs', 'AppDefaultChannelProfileArgsDict']] default_channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the app.
        :param pulumi.Input[_builtins.str] display_name: Display name of the app.
        :param pulumi.Input[Union['AppEvaluationMetricsThresholdsArgs', 'AppEvaluationMetricsThresholdsArgsDict']] evaluation_metrics_thresholds: Threshold settings for metrics in an Evaluation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] global_instruction: Instructions for all the agents in the app.
               You can use this instruction to set up a stable identity or personality
               across all the agents.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrails: List of guardrails for the app.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        :param pulumi.Input[Union['AppLanguageSettingsArgs', 'AppLanguageSettingsArgsDict']] language_settings: Language settings of the app.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['AppLoggingSettingsArgs', 'AppLoggingSettingsArgsDict']] logging_settings: Settings to describe the logging behaviors for the app.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata about the app. This field can be used to store additional
               information relevant to the app's details or intended usages.
        :param pulumi.Input[Union['AppModelSettingsArgs', 'AppModelSettingsArgsDict']] model_settings: Model settings contains various configurations for the LLM model.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] root_agent: The root agent is the entry point of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        :param pulumi.Input[Union['AppTimeZoneSettingsArgs', 'AppTimeZoneSettingsArgsDict']] time_zone_settings: TimeZone settings of the app.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppVariableDeclarationArgs', 'AppVariableDeclarationArgsDict']]]] variable_declarations: The declarations of the variables.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Ces App Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        ces_app_basic = gcp.ces.App("ces_app_basic",
            app_id="app-id",
            location="us",
            description="Basic CES App example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            audio_processing_config={
                "synthesize_speech_configs": [
                    {
                        "language_code": "en-US",
                        "voice": "en-US-Standard-A",
                        "speaking_rate": 1,
                    },
                    {
                        "language_code": "es-ES",
                        "voice": "es-ES-Standard-A",
                        "speaking_rate": 0.95,
                    },
                ],
                "barge_in_config": {
                    "barge_in_awareness": True,
                },
                "inactivity_timeout": "300s",
                "ambient_sound_config": {
                    "prebuilt_ambient_sound": "room_2",
                    "volume_gain_db": -6,
                },
            },
            logging_settings={
                "redaction_config": {
                    "enable_redaction": True,
                    "inspect_template": "projects/fake-project/locations/us/inspectTemplates/example-inspect",
                    "deidentify_template": "projects/fake-project/locations/us/deidentifyTemplates/example-deidentify",
                },
                "audio_recording_config": {
                    "gcs_bucket": "gs://fake-app-audio-recordings",
                    "gcs_path_prefix": "projects/fake-project/location/us/app/test-app/123/$session/123",
                },
                "bigquery_export_settings": {
                    "dataset": "projects/fake-project/datasets/fake_app_logs",
                    "enabled": False,
                    "project": "projects/fake-project",
                },
                "cloud_logging_settings": {
                    "enable_cloud_logging": True,
                },
                "conversation_logging_settings": {
                    "disable_conversation_logging": True,
                },
            },
            model_settings={
                "model": "gemini-1.5-flash",
                "temperature": 0.5,
            },
            evaluation_metrics_thresholds={
                "golden_evaluation_metrics_thresholds": {
                    "turn_level_metrics_thresholds": {
                        "semantic_similarity_success_threshold": 3,
                        "overall_tool_invocation_correctness_threshold": 1,
                    },
                    "expectation_level_metrics_thresholds": {
                        "tool_invocation_parameter_correctness_threshold": 1,
                    },
                },
            },
            variable_declarations=[{
                "name": "test",
                "description": "test",
                "schema": {
                    "description": "schema description",
                    "type": "ARRAY",
                    "nullable": True,
                    "requireds": ["some_property"],
                    "enums": [
                        "VALUE_A",
                        "VALUE_B",
                    ],
                    "ref": "#/defs/MyDefinition",
                    "unique_items": True,
                    "defs": json.dumps({
                        "SimpleString": {
                            "type": "STRING",
                            "description": "A simple string definition",
                        },
                    }),
                    "any_of": json.dumps([{
                        "type": "STRING",
                        "description": "any_of option 1: string",
                    }]),
                    "default": json.dumps(False),
                    "prefix_items": json.dumps([{
                        "type": "ARRAY",
                        "description": "prefix item 1",
                    }]),
                    "additional_properties": json.dumps({
                        "type": "BOOLEAN",
                    }),
                    "properties": json.dumps({
                        "name": {
                            "type": "STRING",
                            "description": "A name",
                        },
                    }),
                    "items": json.dumps({
                        "type": "ARRAY",
                        "description": "An array",
                    }),
                },
            }],
            global_instruction="You are a virtual assistant for an e-commerce platform. Be friendly and helpful.",
            guardrails=[],
            default_channel_profile={
                "channel_type": "WEB_UI",
                "disable_barge_in_control": False,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CONCISE",
                },
                "profile_id": "profile-id",
                "web_widget_config": {
                    "modality": "CHAT_ONLY",
                    "theme": "LIGHT",
                    "web_widget_title": "Help Assistant",
                },
            },
            metadata={
                "deployment_env": "test",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ```
        ### Ces App Ambient Sound Gcs Uri

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        ces_app_ambient_sound_gcs_uri = gcp.ces.App("ces_app_ambient_sound_gcs_uri",
            app_id="app-id",
            location="us",
            description="Basic CES App example",
            display_name="my-app-ambient-sound-gcs-uri",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            audio_processing_config={
                "synthesize_speech_configs": [
                    {
                        "language_code": "en-US",
                        "voice": "en-US-Standard-A",
                        "speaking_rate": 1,
                    },
                    {
                        "language_code": "es-ES",
                        "voice": "es-ES-Standard-A",
                        "speaking_rate": 0.95,
                    },
                ],
                "barge_in_config": {
                    "barge_in_awareness": True,
                },
                "inactivity_timeout": "300s",
                "ambient_sound_config": {
                    "gcs_uri": "gs://fake-bucket/sounds/ambient.wav",
                    "volume_gain_db": -6,
                },
            },
            logging_settings={
                "redaction_config": {
                    "enable_redaction": True,
                    "inspect_template": "projects/fake-project/locations/us/inspectTemplates/example-inspect",
                    "deidentify_template": "projects/fake-project/locations/us/deidentifyTemplates/example-deidentify",
                },
                "audio_recording_config": {
                    "gcs_bucket": "gs://fake-app-audio-recordings",
                    "gcs_path_prefix": "projects/fake-project/location/us/app/fake-app/123/$session/123",
                },
                "bigquery_export_settings": {
                    "dataset": "projects/fake-project/datasets/fake_app_logs",
                    "enabled": False,
                    "project": "projects/fake-project",
                },
                "cloud_logging_settings": {
                    "enable_cloud_logging": True,
                },
                "conversation_logging_settings": {
                    "disable_conversation_logging": True,
                },
            },
            model_settings={
                "model": "gemini-1.5-flash",
                "temperature": 0.5,
            },
            evaluation_metrics_thresholds={
                "golden_evaluation_metrics_thresholds": {
                    "turn_level_metrics_thresholds": {
                        "semantic_similarity_success_threshold": 3,
                        "overall_tool_invocation_correctness_threshold": 1,
                    },
                    "expectation_level_metrics_thresholds": {
                        "tool_invocation_parameter_correctness_threshold": 1,
                    },
                },
            },
            variable_declarations=[{
                "name": "test",
                "description": "test",
                "schema": {
                    "description": "schema description",
                    "type": "ARRAY",
                    "nullable": True,
                    "requireds": ["some_property"],
                    "enums": [
                        "VALUE_A",
                        "VALUE_B",
                    ],
                    "ref": "#/defs/MyDefinition",
                    "unique_items": True,
                    "defs": json.dumps({
                        "SimpleString": {
                            "type": "STRING",
                            "description": "A simple string definition",
                        },
                    }),
                    "any_of": json.dumps([{
                        "type": "STRING",
                        "description": "any_of option 1: string",
                    }]),
                    "default": json.dumps(False),
                    "prefix_items": json.dumps([{
                        "type": "ARRAY",
                        "description": "prefix item 1",
                    }]),
                    "additional_properties": json.dumps({
                        "type": "BOOLEAN",
                    }),
                    "properties": json.dumps({
                        "name": {
                            "type": "STRING",
                            "description": "A name",
                        },
                    }),
                    "items": json.dumps({
                        "type": "ARRAY",
                        "description": "An array",
                    }),
                },
            }],
            global_instruction="You are a virtual assistant for an e-commerce platform. Be friendly and helpful.",
            guardrails=[],
            default_channel_profile={
                "channel_type": "WEB_UI",
                "disable_barge_in_control": False,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CONCISE",
                },
                "profile_id": "profile-id",
                "web_widget_config": {
                    "modality": "CHAT_ONLY",
                    "theme": "LIGHT",
                    "web_widget_title": "Help Assistant",
                },
            },
            metadata={
                "deployment_env": "test",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ```

        ## Import

        App can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, App can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/app:App default projects/{{project}}/locations/{{location}}/apps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/app:App default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/app:App default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 audio_processing_config: Optional[pulumi.Input[Union['AppAudioProcessingConfigArgs', 'AppAudioProcessingConfigArgsDict']]] = None,
                 data_store_settings: Optional[pulumi.Input[Union['AppDataStoreSettingsArgs', 'AppDataStoreSettingsArgsDict']]] = None,
                 default_channel_profile: Optional[pulumi.Input[Union['AppDefaultChannelProfileArgs', 'AppDefaultChannelProfileArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 evaluation_metrics_thresholds: Optional[pulumi.Input[Union['AppEvaluationMetricsThresholdsArgs', 'AppEvaluationMetricsThresholdsArgsDict']]] = None,
                 global_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 language_settings: Optional[pulumi.Input[Union['AppLanguageSettingsArgs', 'AppLanguageSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_settings: Optional[pulumi.Input[Union['AppLoggingSettingsArgs', 'AppLoggingSettingsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 model_settings: Optional[pulumi.Input[Union['AppModelSettingsArgs', 'AppModelSettingsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 root_agent: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone_settings: Optional[pulumi.Input[Union['AppTimeZoneSettingsArgs', 'AppTimeZoneSettingsArgsDict']]] = None,
                 variable_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppVariableDeclarationArgs', 'AppVariableDeclarationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["audio_processing_config"] = audio_processing_config
            __props__.__dict__["data_store_settings"] = data_store_settings
            __props__.__dict__["default_channel_profile"] = default_channel_profile
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["evaluation_metrics_thresholds"] = evaluation_metrics_thresholds
            __props__.__dict__["global_instruction"] = global_instruction
            __props__.__dict__["guardrails"] = guardrails
            __props__.__dict__["language_settings"] = language_settings
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_settings"] = logging_settings
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["model_settings"] = model_settings
            __props__.__dict__["project"] = project
            __props__.__dict__["root_agent"] = root_agent
            __props__.__dict__["time_zone_settings"] = time_zone_settings
            __props__.__dict__["variable_declarations"] = variable_declarations
            __props__.__dict__["create_time"] = None
            __props__.__dict__["deployment_count"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(App, __self__).__init__(
            'gcp:ces/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            audio_processing_config: Optional[pulumi.Input[Union['AppAudioProcessingConfigArgs', 'AppAudioProcessingConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_store_settings: Optional[pulumi.Input[Union['AppDataStoreSettingsArgs', 'AppDataStoreSettingsArgsDict']]] = None,
            default_channel_profile: Optional[pulumi.Input[Union['AppDefaultChannelProfileArgs', 'AppDefaultChannelProfileArgsDict']]] = None,
            deployment_count: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            evaluation_metrics_thresholds: Optional[pulumi.Input[Union['AppEvaluationMetricsThresholdsArgs', 'AppEvaluationMetricsThresholdsArgsDict']]] = None,
            global_instruction: Optional[pulumi.Input[_builtins.str]] = None,
            guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            language_settings: Optional[pulumi.Input[Union['AppLanguageSettingsArgs', 'AppLanguageSettingsArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging_settings: Optional[pulumi.Input[Union['AppLoggingSettingsArgs', 'AppLoggingSettingsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            model_settings: Optional[pulumi.Input[Union['AppModelSettingsArgs', 'AppModelSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            root_agent: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone_settings: Optional[pulumi.Input[Union['AppTimeZoneSettingsArgs', 'AppTimeZoneSettingsArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            variable_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppVariableDeclarationArgs', 'AppVariableDeclarationArgsDict']]]]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID to use for the app, which will become the final component of
               the app's resource name. If not provided, a unique ID will be
               automatically assigned for the app.
        :param pulumi.Input[Union['AppAudioProcessingConfigArgs', 'AppAudioProcessingConfigArgsDict']] audio_processing_config: Configuration for how the input and output audio should be processed and
               delivered.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the app was created.
        :param pulumi.Input[Union['AppDataStoreSettingsArgs', 'AppDataStoreSettingsArgsDict']] data_store_settings: Data store related settings for the app.
               Structure is documented below.
        :param pulumi.Input[Union['AppDefaultChannelProfileArgs', 'AppDefaultChannelProfileArgsDict']] default_channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.int] deployment_count: Number of deployments in the app.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the app.
        :param pulumi.Input[_builtins.str] display_name: Display name of the app.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[Union['AppEvaluationMetricsThresholdsArgs', 'AppEvaluationMetricsThresholdsArgsDict']] evaluation_metrics_thresholds: Threshold settings for metrics in an Evaluation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] global_instruction: Instructions for all the agents in the app.
               You can use this instruction to set up a stable identity or personality
               across all the agents.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] guardrails: List of guardrails for the app.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        :param pulumi.Input[Union['AppLanguageSettingsArgs', 'AppLanguageSettingsArgsDict']] language_settings: Language settings of the app.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['AppLoggingSettingsArgs', 'AppLoggingSettingsArgsDict']] logging_settings: Settings to describe the logging behaviors for the app.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata about the app. This field can be used to store additional
               information relevant to the app's details or intended usages.
        :param pulumi.Input[Union['AppModelSettingsArgs', 'AppModelSettingsArgsDict']] model_settings: Model settings contains various configurations for the LLM model.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] root_agent: The root agent is the entry point of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        :param pulumi.Input[Union['AppTimeZoneSettingsArgs', 'AppTimeZoneSettingsArgsDict']] time_zone_settings: TimeZone settings of the app.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the app was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppVariableDeclarationArgs', 'AppVariableDeclarationArgsDict']]]] variable_declarations: The declarations of the variables.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["audio_processing_config"] = audio_processing_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_settings"] = data_store_settings
        __props__.__dict__["default_channel_profile"] = default_channel_profile
        __props__.__dict__["deployment_count"] = deployment_count
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["evaluation_metrics_thresholds"] = evaluation_metrics_thresholds
        __props__.__dict__["global_instruction"] = global_instruction
        __props__.__dict__["guardrails"] = guardrails
        __props__.__dict__["language_settings"] = language_settings
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_settings"] = logging_settings
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["model_settings"] = model_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["root_agent"] = root_agent
        __props__.__dict__["time_zone_settings"] = time_zone_settings
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["variable_declarations"] = variable_declarations
        return App(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the app, which will become the final component of
        the app's resource name. If not provided, a unique ID will be
        automatically assigned for the app.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="audioProcessingConfig")
    def audio_processing_config(self) -> pulumi.Output[Optional['outputs.AppAudioProcessingConfig']]:
        """
        Configuration for how the input and output audio should be processed and
        delivered.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_processing_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the app was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataStoreSettings")
    def data_store_settings(self) -> pulumi.Output[Optional['outputs.AppDataStoreSettings']]:
        """
        Data store related settings for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "data_store_settings")

    @_builtins.property
    @pulumi.getter(name="defaultChannelProfile")
    def default_channel_profile(self) -> pulumi.Output[Optional['outputs.AppDefaultChannelProfile']]:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "default_channel_profile")

    @_builtins.property
    @pulumi.getter(name="deploymentCount")
    def deployment_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of deployments in the app.
        """
        return pulumi.get(self, "deployment_count")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description of the app.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the app.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="evaluationMetricsThresholds")
    def evaluation_metrics_thresholds(self) -> pulumi.Output[Optional['outputs.AppEvaluationMetricsThresholds']]:
        """
        Threshold settings for metrics in an Evaluation.
        Structure is documented below.
        """
        return pulumi.get(self, "evaluation_metrics_thresholds")

    @_builtins.property
    @pulumi.getter(name="globalInstruction")
    def global_instruction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instructions for all the agents in the app.
        You can use this instruction to set up a stable identity or personality
        across all the agents.
        """
        return pulumi.get(self, "global_instruction")

    @_builtins.property
    @pulumi.getter
    def guardrails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of guardrails for the app.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/guardrails/{guardrail}`
        """
        return pulumi.get(self, "guardrails")

    @_builtins.property
    @pulumi.getter(name="languageSettings")
    def language_settings(self) -> pulumi.Output[Optional['outputs.AppLanguageSettings']]:
        """
        Language settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "language_settings")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loggingSettings")
    def logging_settings(self) -> pulumi.Output[Optional['outputs.AppLoggingSettings']]:
        """
        Settings to describe the logging behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_settings")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata about the app. This field can be used to store additional
        information relevant to the app's details or intended usages.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> pulumi.Output[Optional['outputs.AppModelSettings']]:
        """
        Model settings contains various configurations for the LLM model.
        Structure is documented below.
        """
        return pulumi.get(self, "model_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The unique identifier of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="rootAgent")
    def root_agent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The root agent is the entry point of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}/agents/{agent}`
        """
        return pulumi.get(self, "root_agent")

    @_builtins.property
    @pulumi.getter(name="timeZoneSettings")
    def time_zone_settings(self) -> pulumi.Output[Optional['outputs.AppTimeZoneSettings']]:
        """
        TimeZone settings of the app.
        Structure is documented below.
        """
        return pulumi.get(self, "time_zone_settings")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the app was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="variableDeclarations")
    def variable_declarations(self) -> pulumi.Output[Optional[Sequence['outputs.AppVariableDeclaration']]]:
        """
        The declarations of the variables.
        Structure is documented below.
        """
        return pulumi.get(self, "variable_declarations")

