# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[_builtins.str],
                 app_version: pulumi.Input[_builtins.str],
                 channel_profile: pulumi.Input['DeploymentChannelProfileArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] app_version: The resource name of the app version to deploy.
               Format:
               projects/{project}/locations/{location}/apps/{app}/versions/{version}
        :param pulumi.Input['DeploymentChannelProfileArgs'] channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Display name of the deployment.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "app_version", app_version)
        pulumi.set(__self__, "channel_profile", channel_profile)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name of the app version to deploy.
        Format:
        projects/{project}/locations/{location}/apps/{app}/versions/{version}
        """
        return pulumi.get(self, "app_version")

    @app_version.setter
    def app_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_version", value)

    @_builtins.property
    @pulumi.getter(name="channelProfile")
    def channel_profile(self) -> pulumi.Input['DeploymentChannelProfileArgs']:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "channel_profile")

    @channel_profile.setter
    def channel_profile(self, value: pulumi.Input['DeploymentChannelProfileArgs']):
        pulumi.set(self, "channel_profile", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the deployment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_profile: Optional[pulumi.Input['DeploymentChannelProfileArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] app_version: The resource name of the app version to deploy.
               Format:
               projects/{project}/locations/{location}/apps/{app}/versions/{version}
        :param pulumi.Input['DeploymentChannelProfileArgs'] channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when this deployment was created.
        :param pulumi.Input[_builtins.str] display_name: Display name of the deployment.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the deployment.
               Format:
               projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when this deployment was last updated.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_version is not None:
            pulumi.set(__self__, "app_version", app_version)
        if channel_profile is not None:
            pulumi.set(__self__, "channel_profile", channel_profile)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the app version to deploy.
        Format:
        projects/{project}/locations/{location}/apps/{app}/versions/{version}
        """
        return pulumi.get(self, "app_version")

    @app_version.setter
    def app_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_version", value)

    @_builtins.property
    @pulumi.getter(name="channelProfile")
    def channel_profile(self) -> Optional[pulumi.Input['DeploymentChannelProfileArgs']]:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "channel_profile")

    @channel_profile.setter
    def channel_profile(self, value: Optional[pulumi.Input['DeploymentChannelProfileArgs']]):
        pulumi.set(self, "channel_profile", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when this deployment was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the deployment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the deployment.
        Format:
        projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when this deployment was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:ces/deployment:Deployment")
class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_profile: Optional[pulumi.Input[Union['DeploymentChannelProfileArgs', 'DeploymentChannelProfileArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Ces Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_app = gcp.ces.App("my-app",
            location="us",
            display_name="my-app",
            app_id="app-id",
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        my_deployment = gcp.ces.Deployment("my-deployment",
            location="us",
            display_name="my-deployment",
            app=my_app.name,
            app_version="projects/example-project/locations/us/apps/example-app/versions/example-version",
            channel_profile={
                "channel_type": "API",
                "disable_barge_in_control": True,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CHATTY",
                },
                "profile_id": "temp_profile_id",
                "web_widget_config": {
                    "modality": "CHAT_AND_VOICE",
                    "theme": "DARK",
                    "web_widget_title": "temp_webwidget_title",
                },
            })
        ```

        ## Import

        Deployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/deployments/{{name}}`

        * `{{project}}/{{location}}/{{app}}/{{name}}`

        * `{{location}}/{{app}}/{{name}}`

        When using the `pulumi import` command, Deployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default projects/{{project}}/locations/{{location}}/apps/{{app}}/deployments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default {{project}}/{{location}}/{{app}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default {{location}}/{{app}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] app_version: The resource name of the app version to deploy.
               Format:
               projects/{project}/locations/{location}/apps/{app}/versions/{version}
        :param pulumi.Input[Union['DeploymentChannelProfileArgs', 'DeploymentChannelProfileArgsDict']] channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Display name of the deployment.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Ces Deployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_app = gcp.ces.App("my-app",
            location="us",
            display_name="my-app",
            app_id="app-id",
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        my_deployment = gcp.ces.Deployment("my-deployment",
            location="us",
            display_name="my-deployment",
            app=my_app.name,
            app_version="projects/example-project/locations/us/apps/example-app/versions/example-version",
            channel_profile={
                "channel_type": "API",
                "disable_barge_in_control": True,
                "disable_dtmf": True,
                "persona_property": {
                    "persona": "CHATTY",
                },
                "profile_id": "temp_profile_id",
                "web_widget_config": {
                    "modality": "CHAT_AND_VOICE",
                    "theme": "DARK",
                    "web_widget_title": "temp_webwidget_title",
                },
            })
        ```

        ## Import

        Deployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/deployments/{{name}}`

        * `{{project}}/{{location}}/{{app}}/{{name}}`

        * `{{location}}/{{app}}/{{name}}`

        When using the `pulumi import` command, Deployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default projects/{{project}}/locations/{{location}}/apps/{{app}}/deployments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default {{project}}/{{location}}/{{app}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/deployment:Deployment default {{location}}/{{app}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 app_version: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_profile: Optional[pulumi.Input[Union['DeploymentChannelProfileArgs', 'DeploymentChannelProfileArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            if app_version is None and not opts.urn:
                raise TypeError("Missing required property 'app_version'")
            __props__.__dict__["app_version"] = app_version
            if channel_profile is None and not opts.urn:
                raise TypeError("Missing required property 'channel_profile'")
            __props__.__dict__["channel_profile"] = channel_profile
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Deployment, __self__).__init__(
            'gcp:ces/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[_builtins.str]] = None,
            app_version: Optional[pulumi.Input[_builtins.str]] = None,
            channel_profile: Optional[pulumi.Input[Union['DeploymentChannelProfileArgs', 'DeploymentChannelProfileArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] app_version: The resource name of the app version to deploy.
               Format:
               projects/{project}/locations/{location}/apps/{app}/versions/{version}
        :param pulumi.Input[Union['DeploymentChannelProfileArgs', 'DeploymentChannelProfileArgsDict']] channel_profile: A ChannelProfile configures the agent's behavior for a specific communication
               channel, such as web UI or telephony.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when this deployment was created.
        :param pulumi.Input[_builtins.str] display_name: Display name of the deployment.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the deployment.
               Format:
               projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when this deployment was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["app"] = app
        __props__.__dict__["app_version"] = app_version
        __props__.__dict__["channel_profile"] = channel_profile
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="appVersion")
    def app_version(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the app version to deploy.
        Format:
        projects/{project}/locations/{location}/apps/{app}/versions/{version}
        """
        return pulumi.get(self, "app_version")

    @_builtins.property
    @pulumi.getter(name="channelProfile")
    def channel_profile(self) -> pulumi.Output['outputs.DeploymentChannelProfile']:
        """
        A ChannelProfile configures the agent's behavior for a specific communication
        channel, such as web UI or telephony.
        Structure is documented below.
        """
        return pulumi.get(self, "channel_profile")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when this deployment was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the deployment.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the deployment.
        Format:
        projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when this deployment was last updated.
        """
        return pulumi.get(self, "update_time")

