# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExampleArgs', 'Example']

@pulumi.input_type
class ExampleArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 example_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Example resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] display_name: Display name of the example.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the example.
        :param pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]] messages: The collection of messages that make up the conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "example_id", example_id)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Display name of the example.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="exampleId")
    def example_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "example_id")

    @example_id.setter
    def example_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "example_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the example.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]]:
        """
        The collection of messages that make up the conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ExampleState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 example_id: Optional[pulumi.Input[_builtins.str]] = None,
                 invalid: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Example resources.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the example was created.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the example.
        :param pulumi.Input[_builtins.str] display_name: Display name of the example.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.bool] invalid: The example may become invalid if referencing resources are deleted.
               Invalid examples will not be used as few-shot examples.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]] messages: The collection of messages that make up the conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the example.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the example was last updated.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if example_id is not None:
            pulumi.set(__self__, "example_id", example_id)
        if invalid is not None:
            pulumi.set(__self__, "invalid", invalid)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the example was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the example.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of the example.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="exampleId")
    def example_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "example_id")

    @example_id.setter
    def example_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "example_id", value)

    @_builtins.property
    @pulumi.getter
    def invalid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The example may become invalid if referencing resources are deleted.
        Invalid examples will not be used as few-shot examples.
        """
        return pulumi.get(self, "invalid")

    @invalid.setter
    def invalid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invalid", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]]:
        """
        The collection of messages that make up the conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExampleMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The unique identifier of the example.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the example was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:ces/example:Example")
class Example(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 example_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExampleMessageArgs', 'ExampleMessageArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An example represents a sample conversation between the user and the agent(s).

        ## Example Usage

        ### Ces Example Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_app = gcp.ces.App("my-app",
            location="us",
            display_name="my-app",
            app_id="app-id",
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        my_example = gcp.ces.Example("my-example",
            location="us",
            display_name="my-example",
            app=my_app.name,
            example_id="example-id",
            description="example description",
            messages=[{
                "chunks": [
                    {
                        "image": {
                            "mime_type": "image/png",
                            "data": std.base64encode(input="This is some fake image binary data.").result,
                        },
                    },
                    {
                        "text": "text_data",
                    },
                    {
                        "updated_variables": json.dumps({
                            "var1": "val1",
                            "var2": "val2",
                        }),
                    },
                ],
                "role": "agent",
            }])
        ```

        ## Import

        Example can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/examples/{{name}}`

        * `{{project}}/{{location}}/{{app}}/{{name}}`

        * `{{location}}/{{app}}/{{name}}`

        When using the `pulumi import` command, Example can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/example:Example default projects/{{project}}/locations/{{location}}/apps/{{app}}/examples/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/example:Example default {{project}}/{{location}}/{{app}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/example:Example default {{location}}/{{app}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the example.
        :param pulumi.Input[_builtins.str] display_name: Display name of the example.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExampleMessageArgs', 'ExampleMessageArgsDict']]]] messages: The collection of messages that make up the conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExampleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An example represents a sample conversation between the user and the agent(s).

        ## Example Usage

        ### Ces Example Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_app = gcp.ces.App("my-app",
            location="us",
            display_name="my-app",
            app_id="app-id",
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        my_example = gcp.ces.Example("my-example",
            location="us",
            display_name="my-example",
            app=my_app.name,
            example_id="example-id",
            description="example description",
            messages=[{
                "chunks": [
                    {
                        "image": {
                            "mime_type": "image/png",
                            "data": std.base64encode(input="This is some fake image binary data.").result,
                        },
                    },
                    {
                        "text": "text_data",
                    },
                    {
                        "updated_variables": json.dumps({
                            "var1": "val1",
                            "var2": "val2",
                        }),
                    },
                ],
                "role": "agent",
            }])
        ```

        ## Import

        Example can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/examples/{{name}}`

        * `{{project}}/{{location}}/{{app}}/{{name}}`

        * `{{location}}/{{app}}/{{name}}`

        When using the `pulumi import` command, Example can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/example:Example default projects/{{project}}/locations/{{location}}/apps/{{app}}/examples/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/example:Example default {{project}}/{{location}}/{{app}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:ces/example:Example default {{location}}/{{app}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ExampleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExampleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 example_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExampleMessageArgs', 'ExampleMessageArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExampleArgs.__new__(ExampleArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if example_id is None and not opts.urn:
                raise TypeError("Missing required property 'example_id'")
            __props__.__dict__["example_id"] = example_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["messages"] = messages
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["invalid"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Example, __self__).__init__(
            'gcp:ces/example:Example',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            example_id: Optional[pulumi.Input[_builtins.str]] = None,
            invalid: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExampleMessageArgs', 'ExampleMessageArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Example':
        """
        Get an existing Example resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the example was created.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the example.
        :param pulumi.Input[_builtins.str] display_name: Display name of the example.
        :param pulumi.Input[_builtins.str] etag: Etag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.bool] invalid: The example may become invalid if referencing resources are deleted.
               Invalid examples will not be used as few-shot examples.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExampleMessageArgs', 'ExampleMessageArgsDict']]]] messages: The collection of messages that make up the conversation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the example.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the example was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExampleState.__new__(_ExampleState)

        __props__.__dict__["app"] = app
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["example_id"] = example_id
        __props__.__dict__["invalid"] = invalid
        __props__.__dict__["location"] = location
        __props__.__dict__["messages"] = messages
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return Example(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`, defining the app the example belongs to. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the example was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description of the example.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Display name of the example.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Etag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="exampleId")
    def example_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "example_id")

    @_builtins.property
    @pulumi.getter
    def invalid(self) -> pulumi.Output[_builtins.bool]:
        """
        The example may become invalid if referencing resources are deleted.
        Invalid examples will not be used as few-shot examples.
        """
        return pulumi.get(self, "invalid")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`, defining what region the parent app is in. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def messages(self) -> pulumi.Output[Optional[Sequence['outputs.ExampleMessage']]]:
        """
        The collection of messages that make up the conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "messages")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The unique identifier of the example.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/examples/{example}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the example was last updated.
        """
        return pulumi.get(self, "update_time")

