# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppAudioProcessingConfig',
    'AppAudioProcessingConfigAmbientSoundConfig',
    'AppAudioProcessingConfigBargeInConfig',
    'AppAudioProcessingConfigSynthesizeSpeechConfig',
    'AppDataStoreSettings',
    'AppDataStoreSettingsEngine',
    'AppDefaultChannelProfile',
    'AppDefaultChannelProfilePersonaProperty',
    'AppDefaultChannelProfileWebWidgetConfig',
    'AppEvaluationMetricsThresholds',
    'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds',
    'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds',
    'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds',
    'AppLanguageSettings',
    'AppLoggingSettings',
    'AppLoggingSettingsAudioRecordingConfig',
    'AppLoggingSettingsBigqueryExportSettings',
    'AppLoggingSettingsCloudLoggingSettings',
    'AppLoggingSettingsConversationLoggingSettings',
    'AppLoggingSettingsRedactionConfig',
    'AppModelSettings',
    'AppTimeZoneSettings',
    'AppVariableDeclaration',
    'AppVariableDeclarationSchema',
    'DeploymentChannelProfile',
    'DeploymentChannelProfilePersonaProperty',
    'DeploymentChannelProfileWebWidgetConfig',
    'ExampleMessage',
    'ExampleMessageChunk',
    'ExampleMessageChunkImage',
    'ToolsetOpenApiToolset',
    'ToolsetOpenApiToolsetApiAuthentication',
    'ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig',
    'ToolsetOpenApiToolsetApiAuthenticationOauthConfig',
    'ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig',
    'ToolsetOpenApiToolsetApiAuthenticationServiceAgentIdTokenAuthConfig',
    'ToolsetOpenApiToolsetServiceDirectoryConfig',
    'ToolsetOpenApiToolsetTlsConfig',
    'ToolsetOpenApiToolsetTlsConfigCaCert',
]

@pulumi.output_type
class AppAudioProcessingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ambientSoundConfig":
            suggest = "ambient_sound_config"
        elif key == "bargeInConfig":
            suggest = "barge_in_config"
        elif key == "inactivityTimeout":
            suggest = "inactivity_timeout"
        elif key == "synthesizeSpeechConfigs":
            suggest = "synthesize_speech_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAudioProcessingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAudioProcessingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAudioProcessingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ambient_sound_config: Optional['outputs.AppAudioProcessingConfigAmbientSoundConfig'] = None,
                 barge_in_config: Optional['outputs.AppAudioProcessingConfigBargeInConfig'] = None,
                 inactivity_timeout: Optional[_builtins.str] = None,
                 synthesize_speech_configs: Optional[Sequence['outputs.AppAudioProcessingConfigSynthesizeSpeechConfig']] = None):
        """
        :param 'AppAudioProcessingConfigAmbientSoundConfigArgs' ambient_sound_config: Configuration for the ambient sound to be played with the synthesized agent
               response, to enhance the naturalness of the conversation.
               Structure is documented below.
        :param 'AppAudioProcessingConfigBargeInConfigArgs' barge_in_config: Configuration for how the user barge-in activities should be handled.
               Structure is documented below.
        :param _builtins.str inactivity_timeout: The duration of user inactivity (no speech or interaction) before the agent
               prompts the user for reengagement. If not set, the agent will not prompt
               the user for reengagement.
        :param Sequence['AppAudioProcessingConfigSynthesizeSpeechConfigArgs'] synthesize_speech_configs: Configuration of how the agent response should be synthesized, mapping from
               the language code to SynthesizeSpeechConfig.
               If the configuration for the specified language code is not found, the
               configuration for the root language code will be used. For example, if the
               map contains "en-us" and "en", and the specified language code is "en-gb",
               then "en" configuration will be used.
               Note: Language code is case-insensitive.
               Structure is documented below.
        """
        if ambient_sound_config is not None:
            pulumi.set(__self__, "ambient_sound_config", ambient_sound_config)
        if barge_in_config is not None:
            pulumi.set(__self__, "barge_in_config", barge_in_config)
        if inactivity_timeout is not None:
            pulumi.set(__self__, "inactivity_timeout", inactivity_timeout)
        if synthesize_speech_configs is not None:
            pulumi.set(__self__, "synthesize_speech_configs", synthesize_speech_configs)

    @_builtins.property
    @pulumi.getter(name="ambientSoundConfig")
    def ambient_sound_config(self) -> Optional['outputs.AppAudioProcessingConfigAmbientSoundConfig']:
        """
        Configuration for the ambient sound to be played with the synthesized agent
        response, to enhance the naturalness of the conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "ambient_sound_config")

    @_builtins.property
    @pulumi.getter(name="bargeInConfig")
    def barge_in_config(self) -> Optional['outputs.AppAudioProcessingConfigBargeInConfig']:
        """
        Configuration for how the user barge-in activities should be handled.
        Structure is documented below.
        """
        return pulumi.get(self, "barge_in_config")

    @_builtins.property
    @pulumi.getter(name="inactivityTimeout")
    def inactivity_timeout(self) -> Optional[_builtins.str]:
        """
        The duration of user inactivity (no speech or interaction) before the agent
        prompts the user for reengagement. If not set, the agent will not prompt
        the user for reengagement.
        """
        return pulumi.get(self, "inactivity_timeout")

    @_builtins.property
    @pulumi.getter(name="synthesizeSpeechConfigs")
    def synthesize_speech_configs(self) -> Optional[Sequence['outputs.AppAudioProcessingConfigSynthesizeSpeechConfig']]:
        """
        Configuration of how the agent response should be synthesized, mapping from
        the language code to SynthesizeSpeechConfig.
        If the configuration for the specified language code is not found, the
        configuration for the root language code will be used. For example, if the
        map contains "en-us" and "en", and the specified language code is "en-gb",
        then "en" configuration will be used.
        Note: Language code is case-insensitive.
        Structure is documented below.
        """
        return pulumi.get(self, "synthesize_speech_configs")


@pulumi.output_type
class AppAudioProcessingConfigAmbientSoundConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsUri":
            suggest = "gcs_uri"
        elif key == "prebuiltAmbientSound":
            suggest = "prebuilt_ambient_sound"
        elif key == "volumeGainDb":
            suggest = "volume_gain_db"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAudioProcessingConfigAmbientSoundConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAudioProcessingConfigAmbientSoundConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAudioProcessingConfigAmbientSoundConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_uri: Optional[_builtins.str] = None,
                 prebuilt_ambient_sound: Optional[_builtins.str] = None,
                 volume_gain_db: Optional[_builtins.float] = None):
        """
        :param _builtins.str gcs_uri: Ambient noise as a mono-channel, 16kHz WAV file stored in [Cloud
               Storage](https://cloud.google.com/storage).
               Note: Please make sure the CES service agent
               `service-@gcp-sa-ces.iam.gserviceaccount.com` has
               `storage.objects.get` permission to the Cloud Storage object.
        :param _builtins.str prebuilt_ambient_sound: Name of the prebuilt ambient sound.
               Valid values are: - "coffee_shop" - "keyboard" - "keypad" - "hum"
               -"office_1" - "office_2" - "office_3"
               -"room_1" - "room_2" - "room_3"
               -"room_4" - "room_5" - "air_conditioner"
        :param _builtins.float volume_gain_db: Volume gain (in dB) of the normal native volume supported by
               ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
               0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
               will play at approximately half the amplitude of the normal native signal
               amplitude. A value of +6.0 (dB) will play at approximately twice the
               amplitude of the normal native signal amplitude. We strongly recommend not
               to exceed +10 (dB) as there's usually no effective increase in loudness for
               any value greater than that.
        """
        if gcs_uri is not None:
            pulumi.set(__self__, "gcs_uri", gcs_uri)
        if prebuilt_ambient_sound is not None:
            pulumi.set(__self__, "prebuilt_ambient_sound", prebuilt_ambient_sound)
        if volume_gain_db is not None:
            pulumi.set(__self__, "volume_gain_db", volume_gain_db)

    @_builtins.property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> Optional[_builtins.str]:
        """
        Ambient noise as a mono-channel, 16kHz WAV file stored in [Cloud
        Storage](https://cloud.google.com/storage).
        Note: Please make sure the CES service agent
        `service-@gcp-sa-ces.iam.gserviceaccount.com` has
        `storage.objects.get` permission to the Cloud Storage object.
        """
        return pulumi.get(self, "gcs_uri")

    @_builtins.property
    @pulumi.getter(name="prebuiltAmbientSound")
    def prebuilt_ambient_sound(self) -> Optional[_builtins.str]:
        """
        Name of the prebuilt ambient sound.
        Valid values are: - "coffee_shop" - "keyboard" - "keypad" - "hum"
        -"office_1" - "office_2" - "office_3"
        -"room_1" - "room_2" - "room_3"
        -"room_4" - "room_5" - "air_conditioner"
        """
        return pulumi.get(self, "prebuilt_ambient_sound")

    @_builtins.property
    @pulumi.getter(name="volumeGainDb")
    def volume_gain_db(self) -> Optional[_builtins.float]:
        """
        Volume gain (in dB) of the normal native volume supported by
        ambient noise, in the range [-96.0, 16.0]. If unset, or set to a value of
        0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
        will play at approximately half the amplitude of the normal native signal
        amplitude. A value of +6.0 (dB) will play at approximately twice the
        amplitude of the normal native signal amplitude. We strongly recommend not
        to exceed +10 (dB) as there's usually no effective increase in loudness for
        any value greater than that.
        """
        return pulumi.get(self, "volume_gain_db")


@pulumi.output_type
class AppAudioProcessingConfigBargeInConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bargeInAwareness":
            suggest = "barge_in_awareness"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAudioProcessingConfigBargeInConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAudioProcessingConfigBargeInConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAudioProcessingConfigBargeInConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 barge_in_awareness: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool barge_in_awareness: If enabled, the agent will adapt its next response based on the assumption
               that the user hasn't heard the full preceding agent message.
               This should not be used in scenarios where agent responses are displayed
               visually.
        """
        if barge_in_awareness is not None:
            pulumi.set(__self__, "barge_in_awareness", barge_in_awareness)

    @_builtins.property
    @pulumi.getter(name="bargeInAwareness")
    def barge_in_awareness(self) -> Optional[_builtins.bool]:
        """
        If enabled, the agent will adapt its next response based on the assumption
        that the user hasn't heard the full preceding agent message.
        This should not be used in scenarios where agent responses are displayed
        visually.
        """
        return pulumi.get(self, "barge_in_awareness")


@pulumi.output_type
class AppAudioProcessingConfigSynthesizeSpeechConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"
        elif key == "speakingRate":
            suggest = "speaking_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAudioProcessingConfigSynthesizeSpeechConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAudioProcessingConfigSynthesizeSpeechConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAudioProcessingConfigSynthesizeSpeechConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 language_code: _builtins.str,
                 speaking_rate: Optional[_builtins.float] = None,
                 voice: Optional[_builtins.str] = None):
        """
        :param _builtins.str language_code: The identifier for this object. Format specified above.
        :param _builtins.float speaking_rate: The speaking rate/speed in the range [0.25, 2.0]. 1.0 is the normal native
               speed supported by the specific voice. 2.0 is twice as fast, and 0.5 is
               half as fast. Values outside of the range [0.25, 2.0] will return an error.
        :param _builtins.str voice: The name of the voice. If not set, the service will choose a
               voice based on the other parameters such as language_code.
               For the list of available voices, please refer to Supported voices and
               languages from Cloud Text-to-Speech.
        """
        pulumi.set(__self__, "language_code", language_code)
        if speaking_rate is not None:
            pulumi.set(__self__, "speaking_rate", speaking_rate)
        if voice is not None:
            pulumi.set(__self__, "voice", voice)

    @_builtins.property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "language_code")

    @_builtins.property
    @pulumi.getter(name="speakingRate")
    def speaking_rate(self) -> Optional[_builtins.float]:
        """
        The speaking rate/speed in the range [0.25, 2.0]. 1.0 is the normal native
        speed supported by the specific voice. 2.0 is twice as fast, and 0.5 is
        half as fast. Values outside of the range [0.25, 2.0] will return an error.
        """
        return pulumi.get(self, "speaking_rate")

    @_builtins.property
    @pulumi.getter
    def voice(self) -> Optional[_builtins.str]:
        """
        The name of the voice. If not set, the service will choose a
        voice based on the other parameters such as language_code.
        For the list of available voices, please refer to Supported voices and
        languages from Cloud Text-to-Speech.
        """
        return pulumi.get(self, "voice")


@pulumi.output_type
class AppDataStoreSettings(dict):
    def __init__(__self__, *,
                 engines: Optional[Sequence['outputs.AppDataStoreSettingsEngine']] = None):
        """
        :param Sequence['AppDataStoreSettingsEngineArgs'] engines: (Output)
               The engines for the app.
               Structure is documented below.
               
               
               <a name="nested_data_store_settings_engines"></a>The `engines` block contains:
        """
        if engines is not None:
            pulumi.set(__self__, "engines", engines)

    @_builtins.property
    @pulumi.getter
    def engines(self) -> Optional[Sequence['outputs.AppDataStoreSettingsEngine']]:
        """
        (Output)
        The engines for the app.
        Structure is documented below.


        <a name="nested_data_store_settings_engines"></a>The `engines` block contains:
        """
        return pulumi.get(self, "engines")


@pulumi.output_type
class AppDataStoreSettingsEngine(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Identifier. The unique identifier of the app.
               Format: `projects/{project}/locations/{location}/apps/{app}`
        :param _builtins.str type: The type of the engine.
               Possible values:
               ENGINE_TYPE_SEARCH
               ENGINE_TYPE_CHAT
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Identifier. The unique identifier of the app.
        Format: `projects/{project}/locations/{location}/apps/{app}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the engine.
        Possible values:
        ENGINE_TYPE_SEARCH
        ENGINE_TYPE_CHAT
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AppDefaultChannelProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelType":
            suggest = "channel_type"
        elif key == "disableBargeInControl":
            suggest = "disable_barge_in_control"
        elif key == "disableDtmf":
            suggest = "disable_dtmf"
        elif key == "personaProperty":
            suggest = "persona_property"
        elif key == "profileId":
            suggest = "profile_id"
        elif key == "webWidgetConfig":
            suggest = "web_widget_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDefaultChannelProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDefaultChannelProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDefaultChannelProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_type: Optional[_builtins.str] = None,
                 disable_barge_in_control: Optional[_builtins.bool] = None,
                 disable_dtmf: Optional[_builtins.bool] = None,
                 persona_property: Optional['outputs.AppDefaultChannelProfilePersonaProperty'] = None,
                 profile_id: Optional[_builtins.str] = None,
                 web_widget_config: Optional['outputs.AppDefaultChannelProfileWebWidgetConfig'] = None):
        """
        :param _builtins.str channel_type: The type of the channel profile.
               Possible values:
               UNKNOWN
               WEB_UI
               API
               TWILIO
               GOOGLE_TELEPHONY_PLATFORM
               CONTACT_CENTER_AS_A_SERVICE
        :param _builtins.bool disable_barge_in_control: Whether to disable user barge-in in the conversation.
               - true: User interruptions are disabled while the agent is speaking.
               - false: The agent retains automatic control over when the user can interrupt.
        :param _builtins.bool disable_dtmf: Whether to disable DTMF (dual-tone multi-frequency).
        :param 'AppDefaultChannelProfilePersonaPropertyArgs' persona_property: Represents the persona property of a channel.
               Structure is documented below.
        :param _builtins.str profile_id: The unique identifier of the channel profile.
        :param 'AppDefaultChannelProfileWebWidgetConfigArgs' web_widget_config: Message for configuration for the web widget.
               Structure is documented below.
        """
        if channel_type is not None:
            pulumi.set(__self__, "channel_type", channel_type)
        if disable_barge_in_control is not None:
            pulumi.set(__self__, "disable_barge_in_control", disable_barge_in_control)
        if disable_dtmf is not None:
            pulumi.set(__self__, "disable_dtmf", disable_dtmf)
        if persona_property is not None:
            pulumi.set(__self__, "persona_property", persona_property)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if web_widget_config is not None:
            pulumi.set(__self__, "web_widget_config", web_widget_config)

    @_builtins.property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> Optional[_builtins.str]:
        """
        The type of the channel profile.
        Possible values:
        UNKNOWN
        WEB_UI
        API
        TWILIO
        GOOGLE_TELEPHONY_PLATFORM
        CONTACT_CENTER_AS_A_SERVICE
        """
        return pulumi.get(self, "channel_type")

    @_builtins.property
    @pulumi.getter(name="disableBargeInControl")
    def disable_barge_in_control(self) -> Optional[_builtins.bool]:
        """
        Whether to disable user barge-in in the conversation.
        - true: User interruptions are disabled while the agent is speaking.
        - false: The agent retains automatic control over when the user can interrupt.
        """
        return pulumi.get(self, "disable_barge_in_control")

    @_builtins.property
    @pulumi.getter(name="disableDtmf")
    def disable_dtmf(self) -> Optional[_builtins.bool]:
        """
        Whether to disable DTMF (dual-tone multi-frequency).
        """
        return pulumi.get(self, "disable_dtmf")

    @_builtins.property
    @pulumi.getter(name="personaProperty")
    def persona_property(self) -> Optional['outputs.AppDefaultChannelProfilePersonaProperty']:
        """
        Represents the persona property of a channel.
        Structure is documented below.
        """
        return pulumi.get(self, "persona_property")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of the channel profile.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="webWidgetConfig")
    def web_widget_config(self) -> Optional['outputs.AppDefaultChannelProfileWebWidgetConfig']:
        """
        Message for configuration for the web widget.
        Structure is documented below.
        """
        return pulumi.get(self, "web_widget_config")


@pulumi.output_type
class AppDefaultChannelProfilePersonaProperty(dict):
    def __init__(__self__, *,
                 persona: Optional[_builtins.str] = None):
        """
        :param _builtins.str persona: The persona of the channel.
               Possible values:
               UNKNOWN
               CONCISE
               CHATTY
        """
        if persona is not None:
            pulumi.set(__self__, "persona", persona)

    @_builtins.property
    @pulumi.getter
    def persona(self) -> Optional[_builtins.str]:
        """
        The persona of the channel.
        Possible values:
        UNKNOWN
        CONCISE
        CHATTY
        """
        return pulumi.get(self, "persona")


@pulumi.output_type
class AppDefaultChannelProfileWebWidgetConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webWidgetTitle":
            suggest = "web_widget_title"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDefaultChannelProfileWebWidgetConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDefaultChannelProfileWebWidgetConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDefaultChannelProfileWebWidgetConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modality: Optional[_builtins.str] = None,
                 theme: Optional[_builtins.str] = None,
                 web_widget_title: Optional[_builtins.str] = None):
        """
        :param _builtins.str modality: The modality of the web widget.
               Possible values:
               UNKNOWN_MODALITY
               CHAT_AND_VOICE
               VOICE_ONLY
               CHAT_ONLY
        :param _builtins.str theme: The theme of the web widget.
               Possible values:
               UNKNOWN_THEME
               LIGHT
               DARK
        :param _builtins.str web_widget_title: The title of the web widget.
        """
        if modality is not None:
            pulumi.set(__self__, "modality", modality)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if web_widget_title is not None:
            pulumi.set(__self__, "web_widget_title", web_widget_title)

    @_builtins.property
    @pulumi.getter
    def modality(self) -> Optional[_builtins.str]:
        """
        The modality of the web widget.
        Possible values:
        UNKNOWN_MODALITY
        CHAT_AND_VOICE
        VOICE_ONLY
        CHAT_ONLY
        """
        return pulumi.get(self, "modality")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[_builtins.str]:
        """
        The theme of the web widget.
        Possible values:
        UNKNOWN_THEME
        LIGHT
        DARK
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter(name="webWidgetTitle")
    def web_widget_title(self) -> Optional[_builtins.str]:
        """
        The title of the web widget.
        """
        return pulumi.get(self, "web_widget_title")


@pulumi.output_type
class AppEvaluationMetricsThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "goldenEvaluationMetricsThresholds":
            suggest = "golden_evaluation_metrics_thresholds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEvaluationMetricsThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEvaluationMetricsThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEvaluationMetricsThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 golden_evaluation_metrics_thresholds: Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds'] = None):
        """
        :param 'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsArgs' golden_evaluation_metrics_thresholds: Settings for golden evaluations.
               Structure is documented below.
        """
        if golden_evaluation_metrics_thresholds is not None:
            pulumi.set(__self__, "golden_evaluation_metrics_thresholds", golden_evaluation_metrics_thresholds)

    @_builtins.property
    @pulumi.getter(name="goldenEvaluationMetricsThresholds")
    def golden_evaluation_metrics_thresholds(self) -> Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds']:
        """
        Settings for golden evaluations.
        Structure is documented below.
        """
        return pulumi.get(self, "golden_evaluation_metrics_thresholds")


@pulumi.output_type
class AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expectationLevelMetricsThresholds":
            suggest = "expectation_level_metrics_thresholds"
        elif key == "turnLevelMetricsThresholds":
            suggest = "turn_level_metrics_thresholds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expectation_level_metrics_thresholds: Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds'] = None,
                 turn_level_metrics_thresholds: Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds'] = None):
        """
        :param 'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholdsArgs' expectation_level_metrics_thresholds: Expectation level metrics thresholds.
               Structure is documented below.
        :param 'AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholdsArgs' turn_level_metrics_thresholds: Turn level metrics thresholds.
               Structure is documented below.
        """
        if expectation_level_metrics_thresholds is not None:
            pulumi.set(__self__, "expectation_level_metrics_thresholds", expectation_level_metrics_thresholds)
        if turn_level_metrics_thresholds is not None:
            pulumi.set(__self__, "turn_level_metrics_thresholds", turn_level_metrics_thresholds)

    @_builtins.property
    @pulumi.getter(name="expectationLevelMetricsThresholds")
    def expectation_level_metrics_thresholds(self) -> Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds']:
        """
        Expectation level metrics thresholds.
        Structure is documented below.
        """
        return pulumi.get(self, "expectation_level_metrics_thresholds")

    @_builtins.property
    @pulumi.getter(name="turnLevelMetricsThresholds")
    def turn_level_metrics_thresholds(self) -> Optional['outputs.AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds']:
        """
        Turn level metrics thresholds.
        Structure is documented below.
        """
        return pulumi.get(self, "turn_level_metrics_thresholds")


@pulumi.output_type
class AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "toolInvocationParameterCorrectnessThreshold":
            suggest = "tool_invocation_parameter_correctness_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsExpectationLevelMetricsThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tool_invocation_parameter_correctness_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float tool_invocation_parameter_correctness_threshold: The success threshold for individual tool invocation parameter
               correctness. Must be a float between 0 and 1. Default is 1.0.
        """
        if tool_invocation_parameter_correctness_threshold is not None:
            pulumi.set(__self__, "tool_invocation_parameter_correctness_threshold", tool_invocation_parameter_correctness_threshold)

    @_builtins.property
    @pulumi.getter(name="toolInvocationParameterCorrectnessThreshold")
    def tool_invocation_parameter_correctness_threshold(self) -> Optional[_builtins.float]:
        """
        The success threshold for individual tool invocation parameter
        correctness. Must be a float between 0 and 1. Default is 1.0.
        """
        return pulumi.get(self, "tool_invocation_parameter_correctness_threshold")


@pulumi.output_type
class AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "overallToolInvocationCorrectnessThreshold":
            suggest = "overall_tool_invocation_correctness_threshold"
        elif key == "semanticSimilaritySuccessThreshold":
            suggest = "semantic_similarity_success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppEvaluationMetricsThresholdsGoldenEvaluationMetricsThresholdsTurnLevelMetricsThresholds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 overall_tool_invocation_correctness_threshold: Optional[_builtins.float] = None,
                 semantic_similarity_success_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.float overall_tool_invocation_correctness_threshold: The success threshold for overall tool invocation correctness. Must be
               a float between 0 and 1. Default is 1.0.
        :param _builtins.int semantic_similarity_success_threshold: The success threshold for semantic similarity. Must be an integer
               between 0 and 4. Default is >= 3.
        """
        if overall_tool_invocation_correctness_threshold is not None:
            pulumi.set(__self__, "overall_tool_invocation_correctness_threshold", overall_tool_invocation_correctness_threshold)
        if semantic_similarity_success_threshold is not None:
            pulumi.set(__self__, "semantic_similarity_success_threshold", semantic_similarity_success_threshold)

    @_builtins.property
    @pulumi.getter(name="overallToolInvocationCorrectnessThreshold")
    def overall_tool_invocation_correctness_threshold(self) -> Optional[_builtins.float]:
        """
        The success threshold for overall tool invocation correctness. Must be
        a float between 0 and 1. Default is 1.0.
        """
        return pulumi.get(self, "overall_tool_invocation_correctness_threshold")

    @_builtins.property
    @pulumi.getter(name="semanticSimilaritySuccessThreshold")
    def semantic_similarity_success_threshold(self) -> Optional[_builtins.int]:
        """
        The success threshold for semantic similarity. Must be an integer
        between 0 and 4. Default is >= 3.
        """
        return pulumi.get(self, "semantic_similarity_success_threshold")


@pulumi.output_type
class AppLanguageSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLanguageCode":
            suggest = "default_language_code"
        elif key == "enableMultilingualSupport":
            suggest = "enable_multilingual_support"
        elif key == "fallbackAction":
            suggest = "fallback_action"
        elif key == "supportedLanguageCodes":
            suggest = "supported_language_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLanguageSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLanguageSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLanguageSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_language_code: Optional[_builtins.str] = None,
                 enable_multilingual_support: Optional[_builtins.bool] = None,
                 fallback_action: Optional[_builtins.str] = None,
                 supported_language_codes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str default_language_code: The default language code of the app.
        :param _builtins.bool enable_multilingual_support: Enables multilingual support. If true, agents in the app will use pre-built
               instructions to improve handling of multilingual input.
        :param _builtins.str fallback_action: The action to perform when an agent receives input in an unsupported
               language.
               This can be a predefined action or a custom tool call.
               Valid values are:
               - A tool's full resource name, which triggers a specific tool execution.
               - A predefined system action, such as "escalate" or "exit", which triggers
               an EndSession signal with corresponding metadata
               to terminate the conversation.
        :param Sequence[_builtins.str] supported_language_codes: List of languages codes supported by the app, in addition to the
               `default_language_code`.
        """
        if default_language_code is not None:
            pulumi.set(__self__, "default_language_code", default_language_code)
        if enable_multilingual_support is not None:
            pulumi.set(__self__, "enable_multilingual_support", enable_multilingual_support)
        if fallback_action is not None:
            pulumi.set(__self__, "fallback_action", fallback_action)
        if supported_language_codes is not None:
            pulumi.set(__self__, "supported_language_codes", supported_language_codes)

    @_builtins.property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> Optional[_builtins.str]:
        """
        The default language code of the app.
        """
        return pulumi.get(self, "default_language_code")

    @_builtins.property
    @pulumi.getter(name="enableMultilingualSupport")
    def enable_multilingual_support(self) -> Optional[_builtins.bool]:
        """
        Enables multilingual support. If true, agents in the app will use pre-built
        instructions to improve handling of multilingual input.
        """
        return pulumi.get(self, "enable_multilingual_support")

    @_builtins.property
    @pulumi.getter(name="fallbackAction")
    def fallback_action(self) -> Optional[_builtins.str]:
        """
        The action to perform when an agent receives input in an unsupported
        language.
        This can be a predefined action or a custom tool call.
        Valid values are:
        - A tool's full resource name, which triggers a specific tool execution.
        - A predefined system action, such as "escalate" or "exit", which triggers
        an EndSession signal with corresponding metadata
        to terminate the conversation.
        """
        return pulumi.get(self, "fallback_action")

    @_builtins.property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of languages codes supported by the app, in addition to the
        `default_language_code`.
        """
        return pulumi.get(self, "supported_language_codes")


@pulumi.output_type
class AppLoggingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioRecordingConfig":
            suggest = "audio_recording_config"
        elif key == "bigqueryExportSettings":
            suggest = "bigquery_export_settings"
        elif key == "cloudLoggingSettings":
            suggest = "cloud_logging_settings"
        elif key == "conversationLoggingSettings":
            suggest = "conversation_logging_settings"
        elif key == "redactionConfig":
            suggest = "redaction_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLoggingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLoggingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLoggingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_recording_config: Optional['outputs.AppLoggingSettingsAudioRecordingConfig'] = None,
                 bigquery_export_settings: Optional['outputs.AppLoggingSettingsBigqueryExportSettings'] = None,
                 cloud_logging_settings: Optional['outputs.AppLoggingSettingsCloudLoggingSettings'] = None,
                 conversation_logging_settings: Optional['outputs.AppLoggingSettingsConversationLoggingSettings'] = None,
                 redaction_config: Optional['outputs.AppLoggingSettingsRedactionConfig'] = None):
        """
        :param 'AppLoggingSettingsAudioRecordingConfigArgs' audio_recording_config: Configuration for how the audio interactions should be recorded.
               Structure is documented below.
        :param 'AppLoggingSettingsBigqueryExportSettingsArgs' bigquery_export_settings: Settings to describe the BigQuery export behaviors for the app.
               Structure is documented below.
        :param 'AppLoggingSettingsCloudLoggingSettingsArgs' cloud_logging_settings: Settings to describe the Cloud Logging behaviors for the app.
               Structure is documented below.
        :param 'AppLoggingSettingsConversationLoggingSettingsArgs' conversation_logging_settings: Settings to describe the conversation logging behaviors for the app.
               Structure is documented below.
        :param 'AppLoggingSettingsRedactionConfigArgs' redaction_config: Configuration to instruct how sensitive data should be handled.
               Structure is documented below.
        """
        if audio_recording_config is not None:
            pulumi.set(__self__, "audio_recording_config", audio_recording_config)
        if bigquery_export_settings is not None:
            pulumi.set(__self__, "bigquery_export_settings", bigquery_export_settings)
        if cloud_logging_settings is not None:
            pulumi.set(__self__, "cloud_logging_settings", cloud_logging_settings)
        if conversation_logging_settings is not None:
            pulumi.set(__self__, "conversation_logging_settings", conversation_logging_settings)
        if redaction_config is not None:
            pulumi.set(__self__, "redaction_config", redaction_config)

    @_builtins.property
    @pulumi.getter(name="audioRecordingConfig")
    def audio_recording_config(self) -> Optional['outputs.AppLoggingSettingsAudioRecordingConfig']:
        """
        Configuration for how the audio interactions should be recorded.
        Structure is documented below.
        """
        return pulumi.get(self, "audio_recording_config")

    @_builtins.property
    @pulumi.getter(name="bigqueryExportSettings")
    def bigquery_export_settings(self) -> Optional['outputs.AppLoggingSettingsBigqueryExportSettings']:
        """
        Settings to describe the BigQuery export behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_export_settings")

    @_builtins.property
    @pulumi.getter(name="cloudLoggingSettings")
    def cloud_logging_settings(self) -> Optional['outputs.AppLoggingSettingsCloudLoggingSettings']:
        """
        Settings to describe the Cloud Logging behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_logging_settings")

    @_builtins.property
    @pulumi.getter(name="conversationLoggingSettings")
    def conversation_logging_settings(self) -> Optional['outputs.AppLoggingSettingsConversationLoggingSettings']:
        """
        Settings to describe the conversation logging behaviors for the app.
        Structure is documented below.
        """
        return pulumi.get(self, "conversation_logging_settings")

    @_builtins.property
    @pulumi.getter(name="redactionConfig")
    def redaction_config(self) -> Optional['outputs.AppLoggingSettingsRedactionConfig']:
        """
        Configuration to instruct how sensitive data should be handled.
        Structure is documented below.
        """
        return pulumi.get(self, "redaction_config")


@pulumi.output_type
class AppLoggingSettingsAudioRecordingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsBucket":
            suggest = "gcs_bucket"
        elif key == "gcsPathPrefix":
            suggest = "gcs_path_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLoggingSettingsAudioRecordingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLoggingSettingsAudioRecordingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLoggingSettingsAudioRecordingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_bucket: Optional[_builtins.str] = None,
                 gcs_path_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str gcs_bucket: The [Cloud Storage](https://cloud.google.com/storage) bucket to store the
               session audio recordings. The URI must start with "gs://".
               Note: If the Cloud Storage bucket is in a different project from the app,
               you should grant `storage.objects.create` permission to the CES service
               agent `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        :param _builtins.str gcs_path_prefix: The Cloud Storage path prefix for audio recordings.
               This prefix can include the following placeholders, which will be
               dynamically substituted at serving time:
               - $project:   project ID
               - $location:  app location
               - $app:       app ID
               - $date:      session date in YYYY-MM-DD format
               - $session:   session ID
               If the path prefix is not specified, the default prefix
               `$project/$location/$app/$date/$session/` will be used.
        """
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if gcs_path_prefix is not None:
            pulumi.set(__self__, "gcs_path_prefix", gcs_path_prefix)

    @_builtins.property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[_builtins.str]:
        """
        The [Cloud Storage](https://cloud.google.com/storage) bucket to store the
        session audio recordings. The URI must start with "gs://".
        Note: If the Cloud Storage bucket is in a different project from the app,
        you should grant `storage.objects.create` permission to the CES service
        agent `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        """
        return pulumi.get(self, "gcs_bucket")

    @_builtins.property
    @pulumi.getter(name="gcsPathPrefix")
    def gcs_path_prefix(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage path prefix for audio recordings.
        This prefix can include the following placeholders, which will be
        dynamically substituted at serving time:
        - $project:   project ID
        - $location:  app location
        - $app:       app ID
        - $date:      session date in YYYY-MM-DD format
        - $session:   session ID
        If the path prefix is not specified, the default prefix
        `$project/$location/$app/$date/$session/` will be used.
        """
        return pulumi.get(self, "gcs_path_prefix")


@pulumi.output_type
class AppLoggingSettingsBigqueryExportSettings(dict):
    def __init__(__self__, *,
                 dataset: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 project: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset: The BigQuery dataset to export the data to.
        :param _builtins.bool enabled: Indicates whether the BigQuery export is enabled.
        :param _builtins.str project: The project ID of the BigQuery dataset to export the data to.
               Note: If the BigQuery dataset is in a different project from the app, you should grant
               roles/bigquery.admin role to the CES service agent service-<PROJECT-
               NUMBER>@gcp-sa-ces.iam.gserviceaccount.com.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[_builtins.str]:
        """
        The BigQuery dataset to export the data to.
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the BigQuery export is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The project ID of the BigQuery dataset to export the data to.
        Note: If the BigQuery dataset is in a different project from the app, you should grant
        roles/bigquery.admin role to the CES service agent service-<PROJECT-
        NUMBER>@gcp-sa-ces.iam.gserviceaccount.com.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class AppLoggingSettingsCloudLoggingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableCloudLogging":
            suggest = "enable_cloud_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLoggingSettingsCloudLoggingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLoggingSettingsCloudLoggingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLoggingSettingsCloudLoggingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_cloud_logging: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_cloud_logging: Whether to enable Cloud Logging for the sessions.
        """
        if enable_cloud_logging is not None:
            pulumi.set(__self__, "enable_cloud_logging", enable_cloud_logging)

    @_builtins.property
    @pulumi.getter(name="enableCloudLogging")
    def enable_cloud_logging(self) -> Optional[_builtins.bool]:
        """
        Whether to enable Cloud Logging for the sessions.
        """
        return pulumi.get(self, "enable_cloud_logging")


@pulumi.output_type
class AppLoggingSettingsConversationLoggingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableConversationLogging":
            suggest = "disable_conversation_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLoggingSettingsConversationLoggingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLoggingSettingsConversationLoggingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLoggingSettingsConversationLoggingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_conversation_logging: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool disable_conversation_logging: Whether to disable conversation logging for the sessions.
        """
        if disable_conversation_logging is not None:
            pulumi.set(__self__, "disable_conversation_logging", disable_conversation_logging)

    @_builtins.property
    @pulumi.getter(name="disableConversationLogging")
    def disable_conversation_logging(self) -> Optional[_builtins.bool]:
        """
        Whether to disable conversation logging for the sessions.
        """
        return pulumi.get(self, "disable_conversation_logging")


@pulumi.output_type
class AppLoggingSettingsRedactionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deidentifyTemplate":
            suggest = "deidentify_template"
        elif key == "enableRedaction":
            suggest = "enable_redaction"
        elif key == "inspectTemplate":
            suggest = "inspect_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLoggingSettingsRedactionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLoggingSettingsRedactionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLoggingSettingsRedactionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deidentify_template: Optional[_builtins.str] = None,
                 enable_redaction: Optional[_builtins.bool] = None,
                 inspect_template: Optional[_builtins.str] = None):
        """
        :param _builtins.str deidentify_template: [DLP](https://cloud.google.com/dlp/docs) deidentify template name to
               instruct on how to de-identify content.
               Format:
               `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}`
        :param _builtins.bool enable_redaction: If true, redaction will be applied in various logging scenarios, including
               conversation history, Cloud Logging and audio recording.
        :param _builtins.str inspect_template: [DLP](https://cloud.google.com/dlp/docs) inspect template name to configure
               detection of sensitive data types.
               Format:
               `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
        """
        if deidentify_template is not None:
            pulumi.set(__self__, "deidentify_template", deidentify_template)
        if enable_redaction is not None:
            pulumi.set(__self__, "enable_redaction", enable_redaction)
        if inspect_template is not None:
            pulumi.set(__self__, "inspect_template", inspect_template)

    @_builtins.property
    @pulumi.getter(name="deidentifyTemplate")
    def deidentify_template(self) -> Optional[_builtins.str]:
        """
        [DLP](https://cloud.google.com/dlp/docs) deidentify template name to
        instruct on how to de-identify content.
        Format:
        `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}`
        """
        return pulumi.get(self, "deidentify_template")

    @_builtins.property
    @pulumi.getter(name="enableRedaction")
    def enable_redaction(self) -> Optional[_builtins.bool]:
        """
        If true, redaction will be applied in various logging scenarios, including
        conversation history, Cloud Logging and audio recording.
        """
        return pulumi.get(self, "enable_redaction")

    @_builtins.property
    @pulumi.getter(name="inspectTemplate")
    def inspect_template(self) -> Optional[_builtins.str]:
        """
        [DLP](https://cloud.google.com/dlp/docs) inspect template name to configure
        detection of sensitive data types.
        Format:
        `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
        """
        return pulumi.get(self, "inspect_template")


@pulumi.output_type
class AppModelSettings(dict):
    def __init__(__self__, *,
                 model: Optional[_builtins.str] = None,
                 temperature: Optional[_builtins.float] = None):
        """
        :param _builtins.str model: The LLM model that the agent should use.
               If not set, the agent will inherit the model from its parent agent.
        :param _builtins.float temperature: If set, this temperature will be used for the LLM model. Temperature
               controls the randomness of the model's responses. Lower temperatures
               produce responses that are more predictable. Higher temperatures produce
               responses that are more creative.
        """
        if model is not None:
            pulumi.set(__self__, "model", model)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[_builtins.str]:
        """
        The LLM model that the agent should use.
        If not set, the agent will inherit the model from its parent agent.
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter
    def temperature(self) -> Optional[_builtins.float]:
        """
        If set, this temperature will be used for the LLM model. Temperature
        controls the randomness of the model's responses. Lower temperatures
        produce responses that are more predictable. Higher temperatures produce
        responses that are more creative.
        """
        return pulumi.get(self, "temperature")


@pulumi.output_type
class AppTimeZoneSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTimeZoneSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTimeZoneSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTimeZoneSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str time_zone: The time zone of the app from the time zone database, e.g., America/Los_Angeles, Europe/Paris.
        """
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The time zone of the app from the time zone database, e.g., America/Los_Angeles, Europe/Paris.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class AppVariableDeclaration(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 name: _builtins.str,
                 schema: 'outputs.AppVariableDeclarationSchema'):
        """
        :param _builtins.str description: The description of the variable.
        :param _builtins.str name: The name of the variable. The name must start with a letter or underscore
               and contain only letters, numbers, or underscores.
        :param 'AppVariableDeclarationSchemaArgs' schema: Represents a select subset of an OpenAPI 3.0 schema object.
               Structure is documented below.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the variable. The name must start with a letter or underscore
        and contain only letters, numbers, or underscores.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> 'outputs.AppVariableDeclarationSchema':
        """
        Represents a select subset of an OpenAPI 3.0 schema object.
        Structure is documented below.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class AppVariableDeclarationSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "anyOf":
            suggest = "any_of"
        elif key == "prefixItems":
            suggest = "prefix_items"
        elif key == "uniqueItems":
            suggest = "unique_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppVariableDeclarationSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppVariableDeclarationSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppVariableDeclarationSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 additional_properties: Optional[_builtins.str] = None,
                 any_of: Optional[_builtins.str] = None,
                 default: Optional[_builtins.str] = None,
                 defs: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 enums: Optional[Sequence[_builtins.str]] = None,
                 items: Optional[_builtins.str] = None,
                 nullable: Optional[_builtins.bool] = None,
                 prefix_items: Optional[_builtins.str] = None,
                 properties: Optional[_builtins.str] = None,
                 ref: Optional[_builtins.str] = None,
                 requireds: Optional[Sequence[_builtins.str]] = None,
                 unique_items: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: The type of the data.
               Possible values:
               STRING
               INTEGER
               NUMBER
               BOOLEAN
               OBJECT
               ARRAY
        :param _builtins.str additional_properties: Optional. Defines the schema for additional properties allowed in an object.
               The value must be a valid JSON string representing the Schema object.
               (Note: OpenAPI also allows a boolean, this definition expects a Schema JSON).
        :param _builtins.str any_of: Optional. The instance value should be valid against at least one of the schemas in this list.
        :param _builtins.str default: Optional. Default value of the data. Represents a dynamically typed value
               which can be either null, a number, a string, a boolean, a struct,
               or a list of values. The provided default value must be compatible
               with the defined 'type' and other schema constraints.
        :param _builtins.str defs: A map of definitions for use by ref. Only allowed at the root of the schema.
        :param _builtins.str description: The description of the data.
        :param Sequence[_builtins.str] enums: Possible values of the element of primitive type with enum format.
               Examples:
               1. We can define direction as :
               {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
               2. We can define apartment number as :
               {type:INTEGER, format:enum, enum:["101", "201", "301"]}
        :param _builtins.str items: Schema of the elements of Type.ARRAY.
        :param _builtins.bool nullable: Indicates if the value may be null.
        :param _builtins.str prefix_items: Optional. Schemas of initial elements of Type.ARRAY.
        :param _builtins.str properties: Properties of Type.OBJECT.
        :param _builtins.str ref: Allows indirect references between schema nodes. The value should be a
               valid reference to a child of the root `defs`.
               For example, the following schema defines a reference to a schema node
               named "Pet":
               type: object
               properties:
               pet:
               ref: #/defs/Pet
               defs:
               Pet:
               type: object
               properties:
               name:
               type: string
               The value of the "pet" property is a reference to the schema node
               named "Pet".
               See details in
               https://json-schema.org/understanding-json-schema/structuring.
        :param Sequence[_builtins.str] requireds: Required properties of Type.OBJECT.
        :param _builtins.bool unique_items: Indicate the items in the array must be unique. Only applies to TYPE.ARRAY.
        """
        pulumi.set(__self__, "type", type)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if defs is not None:
            pulumi.set(__self__, "defs", defs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enums is not None:
            pulumi.set(__self__, "enums", enums)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if prefix_items is not None:
            pulumi.set(__self__, "prefix_items", prefix_items)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if requireds is not None:
            pulumi.set(__self__, "requireds", requireds)
        if unique_items is not None:
            pulumi.set(__self__, "unique_items", unique_items)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the data.
        Possible values:
        STRING
        INTEGER
        NUMBER
        BOOLEAN
        OBJECT
        ARRAY
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[_builtins.str]:
        """
        Optional. Defines the schema for additional properties allowed in an object.
        The value must be a valid JSON string representing the Schema object.
        (Note: OpenAPI also allows a boolean, this definition expects a Schema JSON).
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[_builtins.str]:
        """
        Optional. The instance value should be valid against at least one of the schemas in this list.
        """
        return pulumi.get(self, "any_of")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[_builtins.str]:
        """
        Optional. Default value of the data. Represents a dynamically typed value
        which can be either null, a number, a string, a boolean, a struct,
        or a list of values. The provided default value must be compatible
        with the defined 'type' and other schema constraints.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def defs(self) -> Optional[_builtins.str]:
        """
        A map of definitions for use by ref. Only allowed at the root of the schema.
        """
        return pulumi.get(self, "defs")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the data.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enums(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values of the element of primitive type with enum format.
        Examples:
        1. We can define direction as :
        {type:STRING, format:enum, enum:["EAST", NORTH", "SOUTH", "WEST"]}
        2. We can define apartment number as :
        {type:INTEGER, format:enum, enum:["101", "201", "301"]}
        """
        return pulumi.get(self, "enums")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[_builtins.str]:
        """
        Schema of the elements of Type.ARRAY.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def nullable(self) -> Optional[_builtins.bool]:
        """
        Indicates if the value may be null.
        """
        return pulumi.get(self, "nullable")

    @_builtins.property
    @pulumi.getter(name="prefixItems")
    def prefix_items(self) -> Optional[_builtins.str]:
        """
        Optional. Schemas of initial elements of Type.ARRAY.
        """
        return pulumi.get(self, "prefix_items")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[_builtins.str]:
        """
        Properties of Type.OBJECT.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[_builtins.str]:
        """
        Allows indirect references between schema nodes. The value should be a
        valid reference to a child of the root `defs`.
        For example, the following schema defines a reference to a schema node
        named "Pet":
        type: object
        properties:
        pet:
        ref: #/defs/Pet
        defs:
        Pet:
        type: object
        properties:
        name:
        type: string
        The value of the "pet" property is a reference to the schema node
        named "Pet".
        See details in
        https://json-schema.org/understanding-json-schema/structuring.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter
    def requireds(self) -> Optional[Sequence[_builtins.str]]:
        """
        Required properties of Type.OBJECT.
        """
        return pulumi.get(self, "requireds")

    @_builtins.property
    @pulumi.getter(name="uniqueItems")
    def unique_items(self) -> Optional[_builtins.bool]:
        """
        Indicate the items in the array must be unique. Only applies to TYPE.ARRAY.
        """
        return pulumi.get(self, "unique_items")


@pulumi.output_type
class DeploymentChannelProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelType":
            suggest = "channel_type"
        elif key == "disableBargeInControl":
            suggest = "disable_barge_in_control"
        elif key == "disableDtmf":
            suggest = "disable_dtmf"
        elif key == "personaProperty":
            suggest = "persona_property"
        elif key == "profileId":
            suggest = "profile_id"
        elif key == "webWidgetConfig":
            suggest = "web_widget_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentChannelProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentChannelProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentChannelProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_type: Optional[_builtins.str] = None,
                 disable_barge_in_control: Optional[_builtins.bool] = None,
                 disable_dtmf: Optional[_builtins.bool] = None,
                 persona_property: Optional['outputs.DeploymentChannelProfilePersonaProperty'] = None,
                 profile_id: Optional[_builtins.str] = None,
                 web_widget_config: Optional['outputs.DeploymentChannelProfileWebWidgetConfig'] = None):
        """
        :param _builtins.str channel_type: The type of the channel profile.
               Possible values:
               UNKNOWN
               WEB_UI
               API
               TWILIO
               GOOGLE_TELEPHONY_PLATFORM
               CONTACT_CENTER_AS_A_SERVICE
        :param _builtins.bool disable_barge_in_control: Whether to disable user barge-in control in the conversation.
               - **true**: User interruptions are disabled while the agent is speaking.
               - **false**: The agent retains automatic control over when the user can
               interrupt.
        :param _builtins.bool disable_dtmf: Whether to disable DTMF (dual-tone multi-frequency).
        :param 'DeploymentChannelProfilePersonaPropertyArgs' persona_property: Represents the persona property of a channel.
               Structure is documented below.
        :param _builtins.str profile_id: The unique identifier of the channel profile.
        :param 'DeploymentChannelProfileWebWidgetConfigArgs' web_widget_config: Message for configuration for the web widget.
               Structure is documented below.
        """
        if channel_type is not None:
            pulumi.set(__self__, "channel_type", channel_type)
        if disable_barge_in_control is not None:
            pulumi.set(__self__, "disable_barge_in_control", disable_barge_in_control)
        if disable_dtmf is not None:
            pulumi.set(__self__, "disable_dtmf", disable_dtmf)
        if persona_property is not None:
            pulumi.set(__self__, "persona_property", persona_property)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if web_widget_config is not None:
            pulumi.set(__self__, "web_widget_config", web_widget_config)

    @_builtins.property
    @pulumi.getter(name="channelType")
    def channel_type(self) -> Optional[_builtins.str]:
        """
        The type of the channel profile.
        Possible values:
        UNKNOWN
        WEB_UI
        API
        TWILIO
        GOOGLE_TELEPHONY_PLATFORM
        CONTACT_CENTER_AS_A_SERVICE
        """
        return pulumi.get(self, "channel_type")

    @_builtins.property
    @pulumi.getter(name="disableBargeInControl")
    def disable_barge_in_control(self) -> Optional[_builtins.bool]:
        """
        Whether to disable user barge-in control in the conversation.
        - **true**: User interruptions are disabled while the agent is speaking.
        - **false**: The agent retains automatic control over when the user can
        interrupt.
        """
        return pulumi.get(self, "disable_barge_in_control")

    @_builtins.property
    @pulumi.getter(name="disableDtmf")
    def disable_dtmf(self) -> Optional[_builtins.bool]:
        """
        Whether to disable DTMF (dual-tone multi-frequency).
        """
        return pulumi.get(self, "disable_dtmf")

    @_builtins.property
    @pulumi.getter(name="personaProperty")
    def persona_property(self) -> Optional['outputs.DeploymentChannelProfilePersonaProperty']:
        """
        Represents the persona property of a channel.
        Structure is documented below.
        """
        return pulumi.get(self, "persona_property")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[_builtins.str]:
        """
        The unique identifier of the channel profile.
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="webWidgetConfig")
    def web_widget_config(self) -> Optional['outputs.DeploymentChannelProfileWebWidgetConfig']:
        """
        Message for configuration for the web widget.
        Structure is documented below.
        """
        return pulumi.get(self, "web_widget_config")


@pulumi.output_type
class DeploymentChannelProfilePersonaProperty(dict):
    def __init__(__self__, *,
                 persona: Optional[_builtins.str] = None):
        """
        :param _builtins.str persona: The persona of the channel.
               Possible values:
               UNKNOWN
               CONCISE
               CHATTY
        """
        if persona is not None:
            pulumi.set(__self__, "persona", persona)

    @_builtins.property
    @pulumi.getter
    def persona(self) -> Optional[_builtins.str]:
        """
        The persona of the channel.
        Possible values:
        UNKNOWN
        CONCISE
        CHATTY
        """
        return pulumi.get(self, "persona")


@pulumi.output_type
class DeploymentChannelProfileWebWidgetConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webWidgetTitle":
            suggest = "web_widget_title"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentChannelProfileWebWidgetConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentChannelProfileWebWidgetConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentChannelProfileWebWidgetConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modality: Optional[_builtins.str] = None,
                 theme: Optional[_builtins.str] = None,
                 web_widget_title: Optional[_builtins.str] = None):
        """
        :param _builtins.str modality: The modality of the web widget.
               Possible values:
               UNKNOWN_MODALITY
               CHAT_AND_VOICE
               VOICE_ONLY
               CHAT_ONLY
        :param _builtins.str theme: The theme of the web widget.
               Possible values:
               UNKNOWN_THEME
               LIGHT
               DARK
        :param _builtins.str web_widget_title: The title of the web widget.
        """
        if modality is not None:
            pulumi.set(__self__, "modality", modality)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if web_widget_title is not None:
            pulumi.set(__self__, "web_widget_title", web_widget_title)

    @_builtins.property
    @pulumi.getter
    def modality(self) -> Optional[_builtins.str]:
        """
        The modality of the web widget.
        Possible values:
        UNKNOWN_MODALITY
        CHAT_AND_VOICE
        VOICE_ONLY
        CHAT_ONLY
        """
        return pulumi.get(self, "modality")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[_builtins.str]:
        """
        The theme of the web widget.
        Possible values:
        UNKNOWN_THEME
        LIGHT
        DARK
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter(name="webWidgetTitle")
    def web_widget_title(self) -> Optional[_builtins.str]:
        """
        The title of the web widget.
        """
        return pulumi.get(self, "web_widget_title")


@pulumi.output_type
class ExampleMessage(dict):
    def __init__(__self__, *,
                 chunks: Optional[Sequence['outputs.ExampleMessageChunk']] = None,
                 role: Optional[_builtins.str] = None):
        """
        :param Sequence['ExampleMessageChunkArgs'] chunks: Content of the message as a series of chunks.
               Structure is documented below.
        :param _builtins.str role: The role within the conversation, e.g., user, agent.
        """
        if chunks is not None:
            pulumi.set(__self__, "chunks", chunks)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def chunks(self) -> Optional[Sequence['outputs.ExampleMessageChunk']]:
        """
        Content of the message as a series of chunks.
        Structure is documented below.
        """
        return pulumi.get(self, "chunks")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        The role within the conversation, e.g., user, agent.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ExampleMessageChunk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updatedVariables":
            suggest = "updated_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExampleMessageChunk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExampleMessageChunk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExampleMessageChunk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: Optional['outputs.ExampleMessageChunkImage'] = None,
                 text: Optional[_builtins.str] = None,
                 updated_variables: Optional[_builtins.str] = None):
        """
        :param 'ExampleMessageChunkImageArgs' image: Represents an image input or output in the conversation.
               Structure is documented below.
        :param _builtins.str text: Text data.
        :param _builtins.str updated_variables: A struct represents variables that were updated in the conversation,
               keyed by variable names.
        """
        if image is not None:
            pulumi.set(__self__, "image", image)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if updated_variables is not None:
            pulumi.set(__self__, "updated_variables", updated_variables)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional['outputs.ExampleMessageChunkImage']:
        """
        Represents an image input or output in the conversation.
        Structure is documented below.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def text(self) -> Optional[_builtins.str]:
        """
        Text data.
        """
        return pulumi.get(self, "text")

    @_builtins.property
    @pulumi.getter(name="updatedVariables")
    def updated_variables(self) -> Optional[_builtins.str]:
        """
        A struct represents variables that were updated in the conversation,
        keyed by variable names.
        """
        return pulumi.get(self, "updated_variables")


@pulumi.output_type
class ExampleMessageChunkImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExampleMessageChunkImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExampleMessageChunkImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExampleMessageChunkImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: _builtins.str,
                 mime_type: _builtins.str):
        """
        :param _builtins.str data: Raw bytes of the image.
        :param _builtins.str mime_type: The IANA standard MIME type of the source data.
               Supported image types includes:
               * image/png
               * image/jpeg
               * image/webp
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "mime_type", mime_type)

    @_builtins.property
    @pulumi.getter
    def data(self) -> _builtins.str:
        """
        Raw bytes of the image.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> _builtins.str:
        """
        The IANA standard MIME type of the source data.
        Supported image types includes:
        * image/png
        * image/jpeg
        * image/webp
        """
        return pulumi.get(self, "mime_type")


@pulumi.output_type
class ToolsetOpenApiToolset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openApiSchema":
            suggest = "open_api_schema"
        elif key == "apiAuthentication":
            suggest = "api_authentication"
        elif key == "ignoreUnknownFields":
            suggest = "ignore_unknown_fields"
        elif key == "serviceDirectoryConfig":
            suggest = "service_directory_config"
        elif key == "tlsConfig":
            suggest = "tls_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_api_schema: _builtins.str,
                 api_authentication: Optional['outputs.ToolsetOpenApiToolsetApiAuthentication'] = None,
                 ignore_unknown_fields: Optional[_builtins.bool] = None,
                 service_directory_config: Optional['outputs.ToolsetOpenApiToolsetServiceDirectoryConfig'] = None,
                 tls_config: Optional['outputs.ToolsetOpenApiToolsetTlsConfig'] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str open_api_schema: The OpenAPI schema of the toolset.
        :param 'ToolsetOpenApiToolsetApiAuthenticationArgs' api_authentication: Authentication information required for API calls.
               Structure is documented below.
        :param _builtins.bool ignore_unknown_fields: If true, the agent will ignore unknown fields in the API response for all
               operations defined in the OpenAPI schema.
        :param 'ToolsetOpenApiToolsetServiceDirectoryConfigArgs' service_directory_config: Configuration for tools using Service Directory.
               Structure is documented below.
        :param 'ToolsetOpenApiToolsetTlsConfigArgs' tls_config: The TLS configuration.
               Structure is documented below.
        :param _builtins.str url: (Output)
               The server URL of the Open API schema.
               This field is only set in toolsets in the environment dependencies
               during the export process if the schema contains a server url.
               During the import process, if this url is present in the environment dependencies
               and the schema has the $env_var placeholder,
               it will replace the placeholder in the schema.
        """
        pulumi.set(__self__, "open_api_schema", open_api_schema)
        if api_authentication is not None:
            pulumi.set(__self__, "api_authentication", api_authentication)
        if ignore_unknown_fields is not None:
            pulumi.set(__self__, "ignore_unknown_fields", ignore_unknown_fields)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="openApiSchema")
    def open_api_schema(self) -> _builtins.str:
        """
        The OpenAPI schema of the toolset.
        """
        return pulumi.get(self, "open_api_schema")

    @_builtins.property
    @pulumi.getter(name="apiAuthentication")
    def api_authentication(self) -> Optional['outputs.ToolsetOpenApiToolsetApiAuthentication']:
        """
        Authentication information required for API calls.
        Structure is documented below.
        """
        return pulumi.get(self, "api_authentication")

    @_builtins.property
    @pulumi.getter(name="ignoreUnknownFields")
    def ignore_unknown_fields(self) -> Optional[_builtins.bool]:
        """
        If true, the agent will ignore unknown fields in the API response for all
        operations defined in the OpenAPI schema.
        """
        return pulumi.get(self, "ignore_unknown_fields")

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional['outputs.ToolsetOpenApiToolsetServiceDirectoryConfig']:
        """
        Configuration for tools using Service Directory.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional['outputs.ToolsetOpenApiToolsetTlsConfig']:
        """
        The TLS configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "tls_config")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        (Output)
        The server URL of the Open API schema.
        This field is only set in toolsets in the environment dependencies
        during the export process if the schema contains a server url.
        During the import process, if this url is present in the environment dependencies
        and the schema has the $env_var placeholder,
        it will replace the placeholder in the schema.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ToolsetOpenApiToolsetApiAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyConfig":
            suggest = "api_key_config"
        elif key == "oauthConfig":
            suggest = "oauth_config"
        elif key == "serviceAccountAuthConfig":
            suggest = "service_account_auth_config"
        elif key == "serviceAgentIdTokenAuthConfig":
            suggest = "service_agent_id_token_auth_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetApiAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetApiAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetApiAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_config: Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig'] = None,
                 oauth_config: Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationOauthConfig'] = None,
                 service_account_auth_config: Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig'] = None,
                 service_agent_id_token_auth_config: Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationServiceAgentIdTokenAuthConfig'] = None):
        """
        :param 'ToolsetOpenApiToolsetApiAuthenticationApiKeyConfigArgs' api_key_config: Configurations for authentication with API key.
               Structure is documented below.
        :param 'ToolsetOpenApiToolsetApiAuthenticationOauthConfigArgs' oauth_config: Configurations for authentication with OAuth.
               Structure is documented below.
        :param 'ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfigArgs' service_account_auth_config: Configurations for authentication using a custom service account.
               Structure is documented below.
        :param 'ToolsetOpenApiToolsetApiAuthenticationServiceAgentIdTokenAuthConfigArgs' service_agent_id_token_auth_config: Configurations for authentication with [ID
               token](https://cloud.google.com/docs/authentication/token-types#id) generated
               from service agent.
        """
        if api_key_config is not None:
            pulumi.set(__self__, "api_key_config", api_key_config)
        if oauth_config is not None:
            pulumi.set(__self__, "oauth_config", oauth_config)
        if service_account_auth_config is not None:
            pulumi.set(__self__, "service_account_auth_config", service_account_auth_config)
        if service_agent_id_token_auth_config is not None:
            pulumi.set(__self__, "service_agent_id_token_auth_config", service_agent_id_token_auth_config)

    @_builtins.property
    @pulumi.getter(name="apiKeyConfig")
    def api_key_config(self) -> Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig']:
        """
        Configurations for authentication with API key.
        Structure is documented below.
        """
        return pulumi.get(self, "api_key_config")

    @_builtins.property
    @pulumi.getter(name="oauthConfig")
    def oauth_config(self) -> Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationOauthConfig']:
        """
        Configurations for authentication with OAuth.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_config")

    @_builtins.property
    @pulumi.getter(name="serviceAccountAuthConfig")
    def service_account_auth_config(self) -> Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig']:
        """
        Configurations for authentication using a custom service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_auth_config")

    @_builtins.property
    @pulumi.getter(name="serviceAgentIdTokenAuthConfig")
    def service_agent_id_token_auth_config(self) -> Optional['outputs.ToolsetOpenApiToolsetApiAuthenticationServiceAgentIdTokenAuthConfig']:
        """
        Configurations for authentication with [ID
        token](https://cloud.google.com/docs/authentication/token-types#id) generated
        from service agent.
        """
        return pulumi.get(self, "service_agent_id_token_auth_config")


@pulumi.output_type
class ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeySecretVersion":
            suggest = "api_key_secret_version"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "requestLocation":
            suggest = "request_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationApiKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_secret_version: _builtins.str,
                 key_name: _builtins.str,
                 request_location: _builtins.str):
        """
        :param _builtins.str api_key_secret_version: The name of the SecretManager secret version resource storing the API key.
               Format: `projects/{project}/secrets/{secret}/versions/{version}`
               Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
               service agent
               `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        :param _builtins.str key_name: The parameter name or the header name of the API key.
               E.g., If the API request is "https://example.com/act?X-Api-Key=", "X-Api-Key" would be the parameter name.
        :param _builtins.str request_location: Key location in the request.
               Possible values:
               HEADER
               QUERY_STRING
        """
        pulumi.set(__self__, "api_key_secret_version", api_key_secret_version)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "request_location", request_location)

    @_builtins.property
    @pulumi.getter(name="apiKeySecretVersion")
    def api_key_secret_version(self) -> _builtins.str:
        """
        The name of the SecretManager secret version resource storing the API key.
        Format: `projects/{project}/secrets/{secret}/versions/{version}`
        Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
        service agent
        `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        """
        return pulumi.get(self, "api_key_secret_version")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The parameter name or the header name of the API key.
        E.g., If the API request is "https://example.com/act?X-Api-Key=", "X-Api-Key" would be the parameter name.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="requestLocation")
    def request_location(self) -> _builtins.str:
        """
        Key location in the request.
        Possible values:
        HEADER
        QUERY_STRING
        """
        return pulumi.get(self, "request_location")


@pulumi.output_type
class ToolsetOpenApiToolsetApiAuthenticationOauthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecretVersion":
            suggest = "client_secret_version"
        elif key == "oauthGrantType":
            suggest = "oauth_grant_type"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetApiAuthenticationOauthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationOauthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationOauthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret_version: _builtins.str,
                 oauth_grant_type: _builtins.str,
                 token_endpoint: _builtins.str,
                 scopes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str client_id: The client ID from the OAuth provider.
        :param _builtins.str client_secret_version: The name of the SecretManager secret version resource storing the
               client secret.
               Format: `projects/{project}/secrets/{secret}/versions/{version}`
               Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
               service agent
               `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        :param _builtins.str oauth_grant_type: OAuth grant types.
               Possible values:
               CLIENT_CREDENTIAL
        :param _builtins.str token_endpoint: The token endpoint in the OAuth provider to exchange for an access token.
        :param Sequence[_builtins.str] scopes: The OAuth scopes to grant.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret_version", client_secret_version)
        pulumi.set(__self__, "oauth_grant_type", oauth_grant_type)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID from the OAuth provider.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecretVersion")
    def client_secret_version(self) -> _builtins.str:
        """
        The name of the SecretManager secret version resource storing the
        client secret.
        Format: `projects/{project}/secrets/{secret}/versions/{version}`
        Note: You should grant `roles/secretmanager.secretAccessor` role to the CES
        service agent
        `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        """
        return pulumi.get(self, "client_secret_version")

    @_builtins.property
    @pulumi.getter(name="oauthGrantType")
    def oauth_grant_type(self) -> _builtins.str:
        """
        OAuth grant types.
        Possible values:
        CLIENT_CREDENTIAL
        """
        return pulumi.get(self, "oauth_grant_type")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> _builtins.str:
        """
        The token endpoint in the OAuth provider to exchange for an access token.
        """
        return pulumi.get(self, "token_endpoint")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The OAuth scopes to grant.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetApiAuthenticationServiceAccountAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: _builtins.str):
        """
        :param _builtins.str service_account: The email address of the service account used for authenticatation. CES
               uses this service account to exchange an access token and the access token
               is then sent in the `Authorization` header of the request.
               The service account must have the
               `roles/iam.serviceAccountTokenCreator` role granted to the
               CES service agent
               `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        """
        pulumi.set(__self__, "service_account", service_account)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The email address of the service account used for authenticatation. CES
        uses this service account to exchange an access token and the access token
        is then sent in the `Authorization` header of the request.
        The service account must have the
        `roles/iam.serviceAccountTokenCreator` role granted to the
        CES service agent
        `service-@gcp-sa-ces.iam.gserviceaccount.com`.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class ToolsetOpenApiToolsetApiAuthenticationServiceAgentIdTokenAuthConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ToolsetOpenApiToolsetServiceDirectoryConfig(dict):
    def __init__(__self__, *,
                 service: _builtins.str):
        """
        :param _builtins.str service: The name of [Service
               Directory](https://cloud.google.com/service-directory) service.
               Format:
               `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`.
               Location of the service directory must be the same as the location of the
               app.
        """
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of [Service
        Directory](https://cloud.google.com/service-directory) service.
        Format:
        `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`.
        Location of the service directory must be the same as the location of the
        app.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ToolsetOpenApiToolsetTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCerts":
            suggest = "ca_certs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certs: Sequence['outputs.ToolsetOpenApiToolsetTlsConfigCaCert']):
        """
        :param Sequence['ToolsetOpenApiToolsetTlsConfigCaCertArgs'] ca_certs: Specifies a list of allowed custom CA certificates for HTTPS
               verification.
               Structure is documented below.
        """
        pulumi.set(__self__, "ca_certs", ca_certs)

    @_builtins.property
    @pulumi.getter(name="caCerts")
    def ca_certs(self) -> Sequence['outputs.ToolsetOpenApiToolsetTlsConfigCaCert']:
        """
        Specifies a list of allowed custom CA certificates for HTTPS
        verification.
        Structure is documented below.
        """
        return pulumi.get(self, "ca_certs")


@pulumi.output_type
class ToolsetOpenApiToolsetTlsConfigCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolsetOpenApiToolsetTlsConfigCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolsetOpenApiToolsetTlsConfigCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolsetOpenApiToolsetTlsConfigCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: _builtins.str,
                 display_name: _builtins.str):
        """
        :param _builtins.str cert: The allowed custom CA certificates (in DER format) for
               HTTPS verification. This overrides the default SSL trust store. If this
               is empty or unspecified, CES will use Google's default trust
               store to verify certificates. N.B. Make sure the HTTPS server
               certificates are signed with "subject alt name". For instance a
               certificate can be self-signed using the following command,
               openssl x509 -req -days 200 -in example.com.csr \\
               -signkey example.com.key \\
               -out example.com.crt \\
               -extfile <(printf "\\nsubjectAltName='DNS:www.example.com'")
        :param _builtins.str display_name: The name of the allowed custom CA certificates. This
               can be used to disambiguate the custom CA certificates.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> _builtins.str:
        """
        The allowed custom CA certificates (in DER format) for
        HTTPS verification. This overrides the default SSL trust store. If this
        is empty or unspecified, CES will use Google's default trust
        store to verify certificates. N.B. Make sure the HTTPS server
        certificates are signed with "subject alt name". For instance a
        certificate can be self-signed using the following command,
        openssl x509 -req -days 200 -in example.com.csr \\
        -signkey example.com.key \\
        -out example.com.crt \\
        -extfile <(printf "\\nsubjectAltName='DNS:www.example.com'")
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The name of the allowed custom CA certificates. This
        can be used to disambiguate the custom CA certificates.
        """
        return pulumi.get(self, "display_name")


