# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ToolsetArgs', 'Toolset']

@pulumi.input_type
class ToolsetArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 toolset_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 open_api_toolset: Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Toolset resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] toolset_id: The ID to use for the toolset, which will become the final component of
               the toolset's resource name. If not provided, a unique ID will be
               automatically assigned for the toolset.
        :param pulumi.Input[_builtins.str] description: The description of the toolset.
        :param pulumi.Input[_builtins.str] display_name: The display name of the toolset. Must be unique within the same app.
        :param pulumi.Input[_builtins.str] execution_type: Possible values:
               SYNCHRONOUS
               ASYNCHRONOUS
        :param pulumi.Input['ToolsetOpenApiToolsetArgs'] open_api_toolset: A toolset that contains a list of tools that are defined by an OpenAPI
               schema.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "toolset_id", toolset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_type is not None:
            pulumi.set(__self__, "execution_type", execution_type)
        if open_api_toolset is not None:
            pulumi.set(__self__, "open_api_toolset", open_api_toolset)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="toolsetId")
    def toolset_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the toolset, which will become the final component of
        the toolset's resource name. If not provided, a unique ID will be
        automatically assigned for the toolset.
        """
        return pulumi.get(self, "toolset_id")

    @toolset_id.setter
    def toolset_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "toolset_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the toolset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the toolset. Must be unique within the same app.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values:
        SYNCHRONOUS
        ASYNCHRONOUS
        """
        return pulumi.get(self, "execution_type")

    @execution_type.setter
    def execution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_type", value)

    @_builtins.property
    @pulumi.getter(name="openApiToolset")
    def open_api_toolset(self) -> Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']]:
        """
        A toolset that contains a list of tools that are defined by an OpenAPI
        schema.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_toolset")

    @open_api_toolset.setter
    def open_api_toolset(self, value: Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']]):
        pulumi.set(self, "open_api_toolset", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ToolsetState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_api_toolset: Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 toolset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Toolset resources.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the toolset was created.
        :param pulumi.Input[_builtins.str] description: The description of the toolset.
        :param pulumi.Input[_builtins.str] display_name: The display name of the toolset. Must be unique within the same app.
        :param pulumi.Input[_builtins.str] etag: ETag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.str] execution_type: Possible values:
               SYNCHRONOUS
               ASYNCHRONOUS
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the toolset.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        :param pulumi.Input['ToolsetOpenApiToolsetArgs'] open_api_toolset: A toolset that contains a list of tools that are defined by an OpenAPI
               schema.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] toolset_id: The ID to use for the toolset, which will become the final component of
               the toolset's resource name. If not provided, a unique ID will be
               automatically assigned for the toolset.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the toolset was last updated.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_type is not None:
            pulumi.set(__self__, "execution_type", execution_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_api_toolset is not None:
            pulumi.set(__self__, "open_api_toolset", open_api_toolset)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if toolset_id is not None:
            pulumi.set(__self__, "toolset_id", toolset_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the toolset was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the toolset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the toolset. Must be unique within the same app.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ETag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values:
        SYNCHRONOUS
        ASYNCHRONOUS
        """
        return pulumi.get(self, "execution_type")

    @execution_type.setter
    def execution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The unique identifier of the toolset.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openApiToolset")
    def open_api_toolset(self) -> Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']]:
        """
        A toolset that contains a list of tools that are defined by an OpenAPI
        schema.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_toolset")

    @open_api_toolset.setter
    def open_api_toolset(self, value: Optional[pulumi.Input['ToolsetOpenApiToolsetArgs']]):
        pulumi.set(self, "open_api_toolset", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="toolsetId")
    def toolset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the toolset, which will become the final component of
        the toolset's resource name. If not provided, a unique ID will be
        automatically assigned for the toolset.
        """
        return pulumi.get(self, "toolset_id")

    @toolset_id.setter
    def toolset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "toolset_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the toolset was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:ces/toolset:Toolset")
class Toolset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 open_api_toolset: Optional[pulumi.Input[Union['ToolsetOpenApiToolsetArgs', 'ToolsetOpenApiToolsetArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 toolset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Description

        ## Example Usage

        ### Ces Toolset Openapi Service Account Auth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_service_account_auth_config = gcp.ces.Toolset("ces_toolset_openapi_service_account_auth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "service_account_auth_config": {
                        "service_account": "testaccount@gmail.com",
                    },
                },
            })
        ```
        ### Ces Toolset Openapi Oauth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_oauth_config = gcp.ces.Toolset("ces_toolset_openapi_oauth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "oauth_config": {
                        "oauth_grant_type": "CLIENT_CREDENTIAL",
                        "client_id": "example_client_id",
                        "client_secret_version": "projects/fake-project/secrets/fake-secret/versions/version1",
                        "token_endpoint": "123",
                        "scopes": ["scope1"],
                    },
                },
            })
        ```
        ### Ces Toolset Openapi Service Agent Id Token Auth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_service_agent_id_token_auth_config = gcp.ces.Toolset("ces_toolset_openapi_service_agent_id_token_auth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "service_agent_id_token_auth_config": {},
                },
            })
        ```
        ### Ces Toolset Openapi Api Key Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_api_key_config = gcp.ces.Toolset("ces_toolset_openapi_api_key_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            description="Test description",
            execution_type="SYNCHRONOUS",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "api_key_config": {
                        "key_name": "ExampleKey",
                        "api_key_secret_version": "projects/fake-project/secrets/fake-secret/versions/version-1",
                        "request_location": "HEADER",
                    },
                },
            })
        ```

        ## Import

        Toolset can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/toolsets/{{toolset_id}}`

        * `{{project}}/{{location}}/{{app}}/{{toolset_id}}`

        * `{{location}}/{{app}}/{{toolset_id}}`

        When using the `pulumi import` command, Toolset can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default projects/{{project}}/locations/{{location}}/apps/{{app}}/toolsets/{{toolset_id}}
        ```

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default {{project}}/{{location}}/{{app}}/{{toolset_id}}
        ```

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default {{location}}/{{app}}/{{toolset_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] description: The description of the toolset.
        :param pulumi.Input[_builtins.str] display_name: The display name of the toolset. Must be unique within the same app.
        :param pulumi.Input[_builtins.str] execution_type: Possible values:
               SYNCHRONOUS
               ASYNCHRONOUS
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['ToolsetOpenApiToolsetArgs', 'ToolsetOpenApiToolsetArgsDict']] open_api_toolset: A toolset that contains a list of tools that are defined by an OpenAPI
               schema.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] toolset_id: The ID to use for the toolset, which will become the final component of
               the toolset's resource name. If not provided, a unique ID will be
               automatically assigned for the toolset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ToolsetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Description

        ## Example Usage

        ### Ces Toolset Openapi Service Account Auth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_service_account_auth_config = gcp.ces.Toolset("ces_toolset_openapi_service_account_auth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "service_account_auth_config": {
                        "service_account": "testaccount@gmail.com",
                    },
                },
            })
        ```
        ### Ces Toolset Openapi Oauth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_oauth_config = gcp.ces.Toolset("ces_toolset_openapi_oauth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "oauth_config": {
                        "oauth_grant_type": "CLIENT_CREDENTIAL",
                        "client_id": "example_client_id",
                        "client_secret_version": "projects/fake-project/secrets/fake-secret/versions/version1",
                        "token_endpoint": "123",
                        "scopes": ["scope1"],
                    },
                },
            })
        ```
        ### Ces Toolset Openapi Service Agent Id Token Auth Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_service_agent_id_token_auth_config = gcp.ces.Toolset("ces_toolset_openapi_service_agent_id_token_auth_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "service_agent_id_token_auth_config": {},
                },
            })
        ```
        ### Ces Toolset Openapi Api Key Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ces_app_for_toolset = gcp.ces.App("ces_app_for_toolset",
            app_id="app-id",
            location="us",
            description="App used as parent for CES Toolset example",
            display_name="my-app",
            language_settings={
                "default_language_code": "en-US",
                "supported_language_codes": [
                    "es-ES",
                    "fr-FR",
                ],
                "enable_multilingual_support": True,
                "fallback_action": "escalate",
            },
            time_zone_settings={
                "time_zone": "America/Los_Angeles",
            })
        ces_toolset_openapi_api_key_config = gcp.ces.Toolset("ces_toolset_openapi_api_key_config",
            toolset_id="toolset1",
            location="us",
            app=ces_app_for_toolset.app_id,
            display_name="Basic toolset display name",
            description="Test description",
            execution_type="SYNCHRONOUS",
            open_api_toolset={
                "open_api_schema": \"\"\"openapi: 3.0.0
        info:
          title: My Sample API
          version: 1.0.0
          description: A simple API example
        servers:
          - url: https://api.example.com/v1
        paths: {}
        \"\"\",
                "ignore_unknown_fields": False,
                "tls_config": {
                    "ca_certs": [{
                        "display_name": "example",
                        "cert": "ZXhhbXBsZQ==",
                    }],
                },
                "service_directory_config": {
                    "service": "projects/example/locations/us/namespaces/namespace/services/service",
                },
                "api_authentication": {
                    "api_key_config": {
                        "key_name": "ExampleKey",
                        "api_key_secret_version": "projects/fake-project/secrets/fake-secret/versions/version-1",
                        "request_location": "HEADER",
                    },
                },
            })
        ```

        ## Import

        Toolset can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/apps/{{app}}/toolsets/{{toolset_id}}`

        * `{{project}}/{{location}}/{{app}}/{{toolset_id}}`

        * `{{location}}/{{app}}/{{toolset_id}}`

        When using the `pulumi import` command, Toolset can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default projects/{{project}}/locations/{{location}}/apps/{{app}}/toolsets/{{toolset_id}}
        ```

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default {{project}}/{{location}}/{{app}}/{{toolset_id}}
        ```

        ```sh
        $ pulumi import gcp:ces/toolset:Toolset default {{location}}/{{app}}/{{toolset_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ToolsetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ToolsetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 open_api_toolset: Optional[pulumi.Input[Union['ToolsetOpenApiToolsetArgs', 'ToolsetOpenApiToolsetArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 toolset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ToolsetArgs.__new__(ToolsetArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["execution_type"] = execution_type
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["open_api_toolset"] = open_api_toolset
            __props__.__dict__["project"] = project
            if toolset_id is None and not opts.urn:
                raise TypeError("Missing required property 'toolset_id'")
            __props__.__dict__["toolset_id"] = toolset_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(Toolset, __self__).__init__(
            'gcp:ces/toolset:Toolset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            execution_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            open_api_toolset: Optional[pulumi.Input[Union['ToolsetOpenApiToolsetArgs', 'ToolsetOpenApiToolsetArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            toolset_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Toolset':
        """
        Get an existing Toolset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] create_time: Timestamp when the toolset was created.
        :param pulumi.Input[_builtins.str] description: The description of the toolset.
        :param pulumi.Input[_builtins.str] display_name: The display name of the toolset. Must be unique within the same app.
        :param pulumi.Input[_builtins.str] etag: ETag used to ensure the object hasn't changed during a read-modify-write
               operation. If the etag is empty, the update will overwrite any concurrent
               changes.
        :param pulumi.Input[_builtins.str] execution_type: Possible values:
               SYNCHRONOUS
               ASYNCHRONOUS
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The unique identifier of the toolset.
               Format:
               `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        :param pulumi.Input[Union['ToolsetOpenApiToolsetArgs', 'ToolsetOpenApiToolsetArgsDict']] open_api_toolset: A toolset that contains a list of tools that are defined by an OpenAPI
               schema.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] toolset_id: The ID to use for the toolset, which will become the final component of
               the toolset's resource name. If not provided, a unique ID will be
               automatically assigned for the toolset.
        :param pulumi.Input[_builtins.str] update_time: Timestamp when the toolset was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ToolsetState.__new__(_ToolsetState)

        __props__.__dict__["app"] = app
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_type"] = execution_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["open_api_toolset"] = open_api_toolset
        __props__.__dict__["project"] = project
        __props__.__dict__["toolset_id"] = toolset_id
        __props__.__dict__["update_time"] = update_time
        return Toolset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def app(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "app")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the toolset was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the toolset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of the toolset. Must be unique within the same app.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        ETag used to ensure the object hasn't changed during a read-modify-write
        operation. If the etag is empty, the update will overwrite any concurrent
        changes.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Possible values:
        SYNCHRONOUS
        ASYNCHRONOUS
        """
        return pulumi.get(self, "execution_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The unique identifier of the toolset.
        Format:
        `projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openApiToolset")
    def open_api_toolset(self) -> pulumi.Output[Optional['outputs.ToolsetOpenApiToolset']]:
        """
        A toolset that contains a list of tools that are defined by an OpenAPI
        schema.
        Structure is documented below.
        """
        return pulumi.get(self, "open_api_toolset")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="toolsetId")
    def toolset_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the toolset, which will become the final component of
        the toolset's resource name. If not provided, a unique ID will be
        automatically assigned for the toolset.
        """
        return pulumi.get(self, "toolset_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the toolset was last updated.
        """
        return pulumi.get(self, "update_time")

