# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RetrohuntArgs', 'Retrohunt']

@pulumi.input_type
class RetrohuntArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 process_interval: pulumi.Input['RetrohuntProcessIntervalArgs'],
                 rule: pulumi.Input[_builtins.str],
                 retrohunt_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Retrohunt resource.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input['RetrohuntProcessIntervalArgs'] process_interval: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] retrohunt_id: The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "process_interval", process_interval)
        pulumi.set(__self__, "rule", rule)
        if retrohunt_id is not None:
            pulumi.set(__self__, "retrohunt_id", retrohunt_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="processInterval")
    def process_interval(self) -> pulumi.Input['RetrohuntProcessIntervalArgs']:
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a
        Timestamp end (exclusive).
        The start must be less than or equal to the end.
        When the start equals the end, the interval is empty (matches no time).
        When both start and end are unspecified, the interval matches any time.
        Structure is documented below.
        """
        return pulumi.get(self, "process_interval")

    @process_interval.setter
    def process_interval(self, value: pulumi.Input['RetrohuntProcessIntervalArgs']):
        pulumi.set(self, "process_interval", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Input[_builtins.str]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="RetrohuntId")
    def retrohunt_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        """
        return pulumi.get(self, "retrohunt_id")

    @retrohunt_id.setter
    def retrohunt_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrohunt_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RetrohuntState:
    def __init__(__self__, *,
                 retrohunt_id: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_intervals: Optional[pulumi.Input[Sequence[pulumi.Input['RetrohuntExecutionIntervalArgs']]]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 process_interval: Optional[pulumi.Input['RetrohuntProcessIntervalArgs']] = None,
                 progress_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Retrohunt resources.
        :param pulumi.Input[_builtins.str] retrohunt_id: The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        :param pulumi.Input[Sequence[pulumi.Input['RetrohuntExecutionIntervalArgs']]] execution_intervals: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] name: The resource name of the retrohunt.
               Retrohunt is the child of a rule revision. {rule} in the format below is
               structured as {rule_id@revision_id}.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}
        :param pulumi.Input['RetrohuntProcessIntervalArgs'] process_interval: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.float] progress_percentage: Output only. Percent progress of the retrohunt towards completion, from 0.00 to 100.00.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] state: Output only. The state of the retrohunt.
               Possible values:
               RUNNING
               DONE
               CANCELLED
               FAILED
        """
        if retrohunt_id is not None:
            pulumi.set(__self__, "retrohunt_id", retrohunt_id)
        if execution_intervals is not None:
            pulumi.set(__self__, "execution_intervals", execution_intervals)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if process_interval is not None:
            pulumi.set(__self__, "process_interval", process_interval)
        if progress_percentage is not None:
            pulumi.set(__self__, "progress_percentage", progress_percentage)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="RetrohuntId")
    def retrohunt_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        """
        return pulumi.get(self, "retrohunt_id")

    @retrohunt_id.setter
    def retrohunt_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrohunt_id", value)

    @_builtins.property
    @pulumi.getter(name="executionIntervals")
    def execution_intervals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RetrohuntExecutionIntervalArgs']]]]:
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a
        Timestamp end (exclusive).
        The start must be less than or equal to the end.
        When the start equals the end, the interval is empty (matches no time).
        When both start and end are unspecified, the interval matches any time.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_intervals")

    @execution_intervals.setter
    def execution_intervals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RetrohuntExecutionIntervalArgs']]]]):
        pulumi.set(self, "execution_intervals", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the retrohunt.
        Retrohunt is the child of a rule revision. {rule} in the format below is
        structured as {rule_id@revision_id}.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="processInterval")
    def process_interval(self) -> Optional[pulumi.Input['RetrohuntProcessIntervalArgs']]:
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a
        Timestamp end (exclusive).
        The start must be less than or equal to the end.
        When the start equals the end, the interval is empty (matches no time).
        When both start and end are unspecified, the interval matches any time.
        Structure is documented below.
        """
        return pulumi.get(self, "process_interval")

    @process_interval.setter
    def process_interval(self, value: Optional[pulumi.Input['RetrohuntProcessIntervalArgs']]):
        pulumi.set(self, "process_interval", value)

    @_builtins.property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Output only. Percent progress of the retrohunt towards completion, from 0.00 to 100.00.
        """
        return pulumi.get(self, "progress_percentage")

    @progress_percentage.setter
    def progress_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "progress_percentage", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The state of the retrohunt.
        Possible values:
        RUNNING
        DONE
        CANCELLED
        FAILED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:chronicle/retrohunt:Retrohunt")
class Retrohunt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 retrohunt_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 process_interval: Optional[pulumi.Input[Union['RetrohuntProcessIntervalArgs', 'RetrohuntProcessIntervalArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Retrohunt is an execution of a Rule over a time range in the past.

        To get more information about Retrohunt, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.rules.retrohunts)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Retrohunt Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="FORCE",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.Retrohunt("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            process_interval={
                "start_time": "2025-01-01T00:00:00Z",
                "end_time": "2025-01-01T12:00:00Z",
            })
        ```

        ## Import

        Retrohunt can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/retrohunts/{{retrohunt}}`

        * `{{project}}/{{location}}/{{instance}}/{{rule}}/{{retrohunt}}`

        * `{{location}}/{{instance}}/{{rule}}/{{retrohunt}}`

        When using the `pulumi import` command, Retrohunt can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/retrohunts/{{retrohunt}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default {{project}}/{{location}}/{{instance}}/{{rule}}/{{retrohunt}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default {{location}}/{{instance}}/{{rule}}/{{retrohunt}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] retrohunt_id: The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[Union['RetrohuntProcessIntervalArgs', 'RetrohuntProcessIntervalArgsDict']] process_interval: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RetrohuntArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Retrohunt is an execution of a Rule over a time range in the past.

        To get more information about Retrohunt, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.rules.retrohunts)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Retrohunt Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="FORCE",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.Retrohunt("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            process_interval={
                "start_time": "2025-01-01T00:00:00Z",
                "end_time": "2025-01-01T12:00:00Z",
            })
        ```

        ## Import

        Retrohunt can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/retrohunts/{{retrohunt}}`

        * `{{project}}/{{location}}/{{instance}}/{{rule}}/{{retrohunt}}`

        * `{{location}}/{{instance}}/{{rule}}/{{retrohunt}}`

        When using the `pulumi import` command, Retrohunt can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/retrohunts/{{retrohunt}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default {{project}}/{{location}}/{{instance}}/{{rule}}/{{retrohunt}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/retrohunt:Retrohunt default {{location}}/{{instance}}/{{rule}}/{{retrohunt}}
        ```

        :param str resource_name: The name of the resource.
        :param RetrohuntArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RetrohuntArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 retrohunt_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 process_interval: Optional[pulumi.Input[Union['RetrohuntProcessIntervalArgs', 'RetrohuntProcessIntervalArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RetrohuntArgs.__new__(RetrohuntArgs)

            __props__.__dict__["retrohunt_id"] = retrohunt_id
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if process_interval is None and not opts.urn:
                raise TypeError("Missing required property 'process_interval'")
            __props__.__dict__["process_interval"] = process_interval
            __props__.__dict__["project"] = project
            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
            __props__.__dict__["execution_intervals"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["progress_percentage"] = None
            __props__.__dict__["state"] = None
        super(Retrohunt, __self__).__init__(
            'gcp:chronicle/retrohunt:Retrohunt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            retrohunt_id: Optional[pulumi.Input[_builtins.str]] = None,
            execution_intervals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RetrohuntExecutionIntervalArgs', 'RetrohuntExecutionIntervalArgsDict']]]]] = None,
            instance: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            process_interval: Optional[pulumi.Input[Union['RetrohuntProcessIntervalArgs', 'RetrohuntProcessIntervalArgsDict']]] = None,
            progress_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'Retrohunt':
        """
        Get an existing Retrohunt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] retrohunt_id: The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RetrohuntExecutionIntervalArgs', 'RetrohuntExecutionIntervalArgsDict']]]] execution_intervals: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] name: The resource name of the retrohunt.
               Retrohunt is the child of a rule revision. {rule} in the format below is
               structured as {rule_id@revision_id}.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}
        :param pulumi.Input[Union['RetrohuntProcessIntervalArgs', 'RetrohuntProcessIntervalArgsDict']] process_interval: Represents a time interval, encoded as a Timestamp start (inclusive) and a
               Timestamp end (exclusive).
               The start must be less than or equal to the end.
               When the start equals the end, the interval is empty (matches no time).
               When both start and end are unspecified, the interval matches any time.
               Structure is documented below.
        :param pulumi.Input[_builtins.float] progress_percentage: Output only. Percent progress of the retrohunt towards completion, from 0.00 to 100.00.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] state: Output only. The state of the retrohunt.
               Possible values:
               RUNNING
               DONE
               CANCELLED
               FAILED
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RetrohuntState.__new__(_RetrohuntState)

        __props__.__dict__["retrohunt_id"] = retrohunt_id
        __props__.__dict__["execution_intervals"] = execution_intervals
        __props__.__dict__["instance"] = instance
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["process_interval"] = process_interval
        __props__.__dict__["progress_percentage"] = progress_percentage
        __props__.__dict__["project"] = project
        __props__.__dict__["rule"] = rule
        __props__.__dict__["state"] = state
        return Retrohunt(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="RetrohuntId")
    def retrohunt_id(self) -> pulumi.Output[_builtins.str]:
        """
        The retrohunt ID of the Retrohunt. A retrohunt is an execution of a Rule over a time range in the past.
        """
        return pulumi.get(self, "retrohunt_id")

    @_builtins.property
    @pulumi.getter(name="executionIntervals")
    def execution_intervals(self) -> pulumi.Output[Sequence['outputs.RetrohuntExecutionInterval']]:
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a
        Timestamp end (exclusive).
        The start must be less than or equal to the end.
        When the start equals the end, the interval is empty (matches no time).
        When both start and end are unspecified, the interval matches any time.
        Structure is documented below.
        """
        return pulumi.get(self, "execution_intervals")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the retrohunt.
        Retrohunt is the child of a rule revision. {rule} in the format below is
        structured as {rule_id@revision_id}.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="processInterval")
    def process_interval(self) -> pulumi.Output['outputs.RetrohuntProcessInterval']:
        """
        Represents a time interval, encoded as a Timestamp start (inclusive) and a
        Timestamp end (exclusive).
        The start must be less than or equal to the end.
        When the start equals the end, the interval is empty (matches no time).
        When both start and end are unspecified, the interval matches any time.
        Structure is documented below.
        """
        return pulumi.get(self, "process_interval")

    @_builtins.property
    @pulumi.getter(name="progressPercentage")
    def progress_percentage(self) -> pulumi.Output[_builtins.float]:
        """
        Output only. Percent progress of the retrohunt towards completion, from 0.00 to 100.00.
        """
        return pulumi.get(self, "progress_percentage")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[_builtins.str]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The state of the retrohunt.
        Possible values:
        RUNNING
        DONE
        CANCELLED
        FAILED
        """
        return pulumi.get(self, "state")

