# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleDeploymentArgs', 'RuleDeployment']

@pulumi.input_type
class RuleDeploymentArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 rule: pulumi.Input[_builtins.str],
                 alerting: Optional[pulumi.Input[_builtins.bool]] = None,
                 archived: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 run_frequency: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RuleDeployment resource.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.bool] alerting: Whether detections resulting from this deployment should be considered
               alerts.
        :param pulumi.Input[_builtins.bool] archived: The archive state of the rule deployment.
               Cannot be set to true unless enabled is set to false i.e.
               archiving requires a two-step process: first, disable the rule by
               setting 'enabled' to false, then set 'archive' to true.
               If set to true, alerting will automatically be set to false.
               If currently set to true, enabled, alerting, and run_frequency cannot be
               updated.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently deployed continuously against incoming data.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] run_frequency: The run frequency of the rule deployment.
               Possible values:
               LIVE
               HOURLY
               DAILY
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "rule", rule)
        if alerting is not None:
            pulumi.set(__self__, "alerting", alerting)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if run_frequency is not None:
            pulumi.set(__self__, "run_frequency", run_frequency)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Input[_builtins.str]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether detections resulting from this deployment should be considered
        alerts.
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alerting", value)

    @_builtins.property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The archive state of the rule deployment.
        Cannot be set to true unless enabled is set to false i.e.
        archiving requires a two-step process: first, disable the rule by
        setting 'enabled' to false, then set 'archive' to true.
        If set to true, alerting will automatically be set to false.
        If currently set to true, enabled, alerting, and run_frequency cannot be
        updated.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "archived", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is currently deployed continuously against incoming data.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="runFrequency")
    def run_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The run frequency of the rule deployment.
        Possible values:
        LIVE
        HOURLY
        DAILY
        """
        return pulumi.get(self, "run_frequency")

    @run_frequency.setter
    def run_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_frequency", value)


@pulumi.input_type
class _RuleDeploymentState:
    def __init__(__self__, *,
                 alerting: Optional[pulumi.Input[_builtins.bool]] = None,
                 archive_time: Optional[pulumi.Input[_builtins.str]] = None,
                 archived: Optional[pulumi.Input[_builtins.bool]] = None,
                 consumer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 execution_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 last_alert_status_change_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 producer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 run_frequency: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleDeployment resources.
        :param pulumi.Input[_builtins.bool] alerting: Whether detections resulting from this deployment should be considered
               alerts.
        :param pulumi.Input[_builtins.str] archive_time: Output only. The timestamp when the rule deployment archive state was last set to true. If the rule deployment's current archive state is not set to true, the field will be empty.
        :param pulumi.Input[_builtins.bool] archived: The archive state of the rule deployment.
               Cannot be set to true unless enabled is set to false i.e.
               archiving requires a two-step process: first, disable the rule by
               setting 'enabled' to false, then set 'archive' to true.
               If set to true, alerting will automatically be set to false.
               If currently set to true, enabled, alerting, and run_frequency cannot be
               updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consumer_rules: Output only. The names of the associated/chained consumer rules. Rules are considered
               consumers of this rule if their rule text explicitly filters on this rule's ruleid.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently deployed continuously against incoming data.
        :param pulumi.Input[_builtins.str] execution_state: The execution state of the rule deployment.
               Possible values:
               DEFAULT
               LIMITED
               PAUSED
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] last_alert_status_change_time: Output only. The timestamp when the rule deployment alert state was lastly changed. This is filled regardless of the current alert state.E.g. if the current alert status is false, this timestamp will be the timestamp when the alert status was changed to false.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] name: The resource name of the rule deployment.
               Note that RuleDeployment is a child of the overall Rule, not any individual
               revision, so the resource ID segment for the Rule resource must not
               reference a specific revision.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_rules: Output only. The names of the associated/chained producer rules. Rules are considered
               producers for this rule if this rule explicitly filters on their ruleid.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] run_frequency: The run frequency of the rule deployment.
               Possible values:
               LIVE
               HOURLY
               DAILY
        """
        if alerting is not None:
            pulumi.set(__self__, "alerting", alerting)
        if archive_time is not None:
            pulumi.set(__self__, "archive_time", archive_time)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if consumer_rules is not None:
            pulumi.set(__self__, "consumer_rules", consumer_rules)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if execution_state is not None:
            pulumi.set(__self__, "execution_state", execution_state)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if last_alert_status_change_time is not None:
            pulumi.set(__self__, "last_alert_status_change_time", last_alert_status_change_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if producer_rules is not None:
            pulumi.set(__self__, "producer_rules", producer_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if run_frequency is not None:
            pulumi.set(__self__, "run_frequency", run_frequency)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether detections resulting from this deployment should be considered
        alerts.
        """
        return pulumi.get(self, "alerting")

    @alerting.setter
    def alerting(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "alerting", value)

    @_builtins.property
    @pulumi.getter(name="archiveTime")
    def archive_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The timestamp when the rule deployment archive state was last set to true. If the rule deployment's current archive state is not set to true, the field will be empty.
        """
        return pulumi.get(self, "archive_time")

    @archive_time.setter
    def archive_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "archive_time", value)

    @_builtins.property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The archive state of the rule deployment.
        Cannot be set to true unless enabled is set to false i.e.
        archiving requires a two-step process: first, disable the rule by
        setting 'enabled' to false, then set 'archive' to true.
        If set to true, alerting will automatically be set to false.
        If currently set to true, enabled, alerting, and run_frequency cannot be
        updated.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "archived", value)

    @_builtins.property
    @pulumi.getter(name="consumerRules")
    def consumer_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Output only. The names of the associated/chained consumer rules. Rules are considered
        consumers of this rule if their rule text explicitly filters on this rule's ruleid.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "consumer_rules")

    @consumer_rules.setter
    def consumer_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "consumer_rules", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is currently deployed continuously against incoming data.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="executionState")
    def execution_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The execution state of the rule deployment.
        Possible values:
        DEFAULT
        LIMITED
        PAUSED
        """
        return pulumi.get(self, "execution_state")

    @execution_state.setter
    def execution_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_state", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter(name="lastAlertStatusChangeTime")
    def last_alert_status_change_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The timestamp when the rule deployment alert state was lastly changed. This is filled regardless of the current alert state.E.g. if the current alert status is false, this timestamp will be the timestamp when the alert status was changed to false.
        """
        return pulumi.get(self, "last_alert_status_change_time")

    @last_alert_status_change_time.setter
    def last_alert_status_change_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_alert_status_change_time", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the rule deployment.
        Note that RuleDeployment is a child of the overall Rule, not any individual
        revision, so the resource ID segment for the Rule resource must not
        reference a specific revision.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="producerRules")
    def producer_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Output only. The names of the associated/chained producer rules. Rules are considered
        producers for this rule if this rule explicitly filters on their ruleid.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "producer_rules")

    @producer_rules.setter
    def producer_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "producer_rules", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule", value)

    @_builtins.property
    @pulumi.getter(name="runFrequency")
    def run_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The run frequency of the rule deployment.
        Possible values:
        LIVE
        HOURLY
        DAILY
        """
        return pulumi.get(self, "run_frequency")

    @run_frequency.setter
    def run_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_frequency", value)


@pulumi.type_token("gcp:chronicle/ruleDeployment:RuleDeployment")
class RuleDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting: Optional[pulumi.Input[_builtins.bool]] = None,
                 archived: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 run_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The RuleDeployment resource represents the deployment state of a Rule.

        To get more information about RuleDeployment, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/RuleDeployment)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Ruledeployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=True,
            alerting=True,
            archived=False,
            run_frequency="DAILY")
        ```
        ### Chronicle Ruledeployment Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=False,
            run_frequency="LIVE")
        ```
        ### Chronicle Ruledeployment Run Frequency Missing

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=True,
            alerting=True,
            archived=False)
        ```

        ## Import

        RuleDeployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/deployment`

        * `{{project}}/{{location}}/{{instance}}/{{rule}}`

        * `{{location}}/{{instance}}/{{rule}}`

        When using the `pulumi import` command, RuleDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/deployment
        ```

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default {{project}}/{{location}}/{{instance}}/{{rule}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default {{location}}/{{instance}}/{{rule}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alerting: Whether detections resulting from this deployment should be considered
               alerts.
        :param pulumi.Input[_builtins.bool] archived: The archive state of the rule deployment.
               Cannot be set to true unless enabled is set to false i.e.
               archiving requires a two-step process: first, disable the rule by
               setting 'enabled' to false, then set 'archive' to true.
               If set to true, alerting will automatically be set to false.
               If currently set to true, enabled, alerting, and run_frequency cannot be
               updated.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently deployed continuously against incoming data.
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] run_frequency: The run frequency of the rule deployment.
               Possible values:
               LIVE
               HOURLY
               DAILY
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The RuleDeployment resource represents the deployment state of a Rule.

        To get more information about RuleDeployment, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/RuleDeployment)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Ruledeployment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=True,
            alerting=True,
            archived=False,
            run_frequency="DAILY")
        ```
        ### Chronicle Ruledeployment Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=False,
            run_frequency="LIVE")
        ```
        ### Chronicle Ruledeployment Run Frequency Missing

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_rule = gcp.chronicle.Rule("my-rule",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        example = gcp.chronicle.RuleDeployment("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            rule=len(std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result).apply(lambda length: std.split(separator="/",
                text=google_chronicle_rule["my-rule"]["name"]).result[length - 1]),
            enabled=True,
            alerting=True,
            archived=False)
        ```

        ## Import

        RuleDeployment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/deployment`

        * `{{project}}/{{location}}/{{instance}}/{{rule}}`

        * `{{location}}/{{instance}}/{{rule}}`

        When using the `pulumi import` command, RuleDeployment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule}}/deployment
        ```

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default {{project}}/{{location}}/{{instance}}/{{rule}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/ruleDeployment:RuleDeployment default {{location}}/{{instance}}/{{rule}}
        ```

        :param str resource_name: The name of the resource.
        :param RuleDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerting: Optional[pulumi.Input[_builtins.bool]] = None,
                 archived: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rule: Optional[pulumi.Input[_builtins.str]] = None,
                 run_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleDeploymentArgs.__new__(RuleDeploymentArgs)

            __props__.__dict__["alerting"] = alerting
            __props__.__dict__["archived"] = archived
            __props__.__dict__["enabled"] = enabled
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
            __props__.__dict__["run_frequency"] = run_frequency
            __props__.__dict__["archive_time"] = None
            __props__.__dict__["consumer_rules"] = None
            __props__.__dict__["execution_state"] = None
            __props__.__dict__["last_alert_status_change_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["producer_rules"] = None
        super(RuleDeployment, __self__).__init__(
            'gcp:chronicle/ruleDeployment:RuleDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerting: Optional[pulumi.Input[_builtins.bool]] = None,
            archive_time: Optional[pulumi.Input[_builtins.str]] = None,
            archived: Optional[pulumi.Input[_builtins.bool]] = None,
            consumer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            execution_state: Optional[pulumi.Input[_builtins.str]] = None,
            instance: Optional[pulumi.Input[_builtins.str]] = None,
            last_alert_status_change_time: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            producer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            rule: Optional[pulumi.Input[_builtins.str]] = None,
            run_frequency: Optional[pulumi.Input[_builtins.str]] = None) -> 'RuleDeployment':
        """
        Get an existing RuleDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] alerting: Whether detections resulting from this deployment should be considered
               alerts.
        :param pulumi.Input[_builtins.str] archive_time: Output only. The timestamp when the rule deployment archive state was last set to true. If the rule deployment's current archive state is not set to true, the field will be empty.
        :param pulumi.Input[_builtins.bool] archived: The archive state of the rule deployment.
               Cannot be set to true unless enabled is set to false i.e.
               archiving requires a two-step process: first, disable the rule by
               setting 'enabled' to false, then set 'archive' to true.
               If set to true, alerting will automatically be set to false.
               If currently set to true, enabled, alerting, and run_frequency cannot be
               updated.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] consumer_rules: Output only. The names of the associated/chained consumer rules. Rules are considered
               consumers of this rule if their rule text explicitly filters on this rule's ruleid.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently deployed continuously against incoming data.
        :param pulumi.Input[_builtins.str] execution_state: The execution state of the rule deployment.
               Possible values:
               DEFAULT
               LIMITED
               PAUSED
        :param pulumi.Input[_builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[_builtins.str] last_alert_status_change_time: Output only. The timestamp when the rule deployment alert state was lastly changed. This is filled regardless of the current alert state.E.g. if the current alert status is false, this timestamp will be the timestamp when the alert status was changed to false.
        :param pulumi.Input[_builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[_builtins.str] name: The resource name of the rule deployment.
               Note that RuleDeployment is a child of the overall Rule, not any individual
               revision, so the resource ID segment for the Rule resource must not
               reference a specific revision.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] producer_rules: Output only. The names of the associated/chained producer rules. Rules are considered
               producers for this rule if this rule explicitly filters on their ruleid.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] rule: The Rule ID of the rule.
        :param pulumi.Input[_builtins.str] run_frequency: The run frequency of the rule deployment.
               Possible values:
               LIVE
               HOURLY
               DAILY
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleDeploymentState.__new__(_RuleDeploymentState)

        __props__.__dict__["alerting"] = alerting
        __props__.__dict__["archive_time"] = archive_time
        __props__.__dict__["archived"] = archived
        __props__.__dict__["consumer_rules"] = consumer_rules
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["execution_state"] = execution_state
        __props__.__dict__["instance"] = instance
        __props__.__dict__["last_alert_status_change_time"] = last_alert_status_change_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["producer_rules"] = producer_rules
        __props__.__dict__["project"] = project
        __props__.__dict__["rule"] = rule
        __props__.__dict__["run_frequency"] = run_frequency
        return RuleDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alerting(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether detections resulting from this deployment should be considered
        alerts.
        """
        return pulumi.get(self, "alerting")

    @_builtins.property
    @pulumi.getter(name="archiveTime")
    def archive_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The timestamp when the rule deployment archive state was last set to true. If the rule deployment's current archive state is not set to true, the field will be empty.
        """
        return pulumi.get(self, "archive_time")

    @_builtins.property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The archive state of the rule deployment.
        Cannot be set to true unless enabled is set to false i.e.
        archiving requires a two-step process: first, disable the rule by
        setting 'enabled' to false, then set 'archive' to true.
        If set to true, alerting will automatically be set to false.
        If currently set to true, enabled, alerting, and run_frequency cannot be
        updated.
        """
        return pulumi.get(self, "archived")

    @_builtins.property
    @pulumi.getter(name="consumerRules")
    def consumer_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Output only. The names of the associated/chained consumer rules. Rules are considered
        consumers of this rule if their rule text explicitly filters on this rule's ruleid.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "consumer_rules")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the rule is currently deployed continuously against incoming data.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="executionState")
    def execution_state(self) -> pulumi.Output[_builtins.str]:
        """
        The execution state of the rule deployment.
        Possible values:
        DEFAULT
        LIMITED
        PAUSED
        """
        return pulumi.get(self, "execution_state")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="lastAlertStatusChangeTime")
    def last_alert_status_change_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The timestamp when the rule deployment alert state was lastly changed. This is filled regardless of the current alert state.E.g. if the current alert status is false, this timestamp will be the timestamp when the alert status was changed to false.
        """
        return pulumi.get(self, "last_alert_status_change_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the rule deployment.
        Note that RuleDeployment is a child of the overall Rule, not any individual
        revision, so the resource ID segment for the Rule resource must not
        reference a specific revision.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="producerRules")
    def producer_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Output only. The names of the associated/chained producer rules. Rules are considered
        producers for this rule if this rule explicitly filters on their ruleid.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "producer_rules")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> pulumi.Output[_builtins.str]:
        """
        The Rule ID of the rule.
        """
        return pulumi.get(self, "rule")

    @_builtins.property
    @pulumi.getter(name="runFrequency")
    def run_frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The run frequency of the rule deployment.
        Possible values:
        LIVE
        HOURLY
        DAILY
        """
        return pulumi.get(self, "run_frequency")

