# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RegistrationContactSettings',
    'RegistrationContactSettingsAdminContact',
    'RegistrationContactSettingsAdminContactPostalAddress',
    'RegistrationContactSettingsRegistrantContact',
    'RegistrationContactSettingsRegistrantContactPostalAddress',
    'RegistrationContactSettingsTechnicalContact',
    'RegistrationContactSettingsTechnicalContactPostalAddress',
    'RegistrationDnsSettings',
    'RegistrationDnsSettingsCustomDns',
    'RegistrationDnsSettingsCustomDnsDsRecord',
    'RegistrationDnsSettingsGlueRecord',
    'RegistrationManagementSettings',
    'RegistrationYearlyPrice',
]

@pulumi.output_type
class RegistrationContactSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminContact":
            suggest = "admin_contact"
        elif key == "registrantContact":
            suggest = "registrant_contact"
        elif key == "technicalContact":
            suggest = "technical_contact"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_contact: 'outputs.RegistrationContactSettingsAdminContact',
                 privacy: _builtins.str,
                 registrant_contact: 'outputs.RegistrationContactSettingsRegistrantContact',
                 technical_contact: 'outputs.RegistrationContactSettingsTechnicalContact'):
        """
        :param 'RegistrationContactSettingsAdminContactArgs' admin_contact: Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
               Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
               avoid domain suspension.
               Structure is documented below.
        :param _builtins.str privacy: Required. Privacy setting for the contacts associated with the Registration.
               Values are PUBLIC_CONTACT_DATA, PRIVATE_CONTACT_DATA, and REDACTED_CONTACT_DATA
        :param 'RegistrationContactSettingsRegistrantContactArgs' registrant_contact: Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
               Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
               avoid domain suspension.
               Structure is documented below.
        :param 'RegistrationContactSettingsTechnicalContactArgs' technical_contact: Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
               Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
               avoid domain suspension.
               Structure is documented below.
        """
        pulumi.set(__self__, "admin_contact", admin_contact)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "registrant_contact", registrant_contact)
        pulumi.set(__self__, "technical_contact", technical_contact)

    @_builtins.property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> 'outputs.RegistrationContactSettingsAdminContact':
        """
        Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
        Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
        avoid domain suspension.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_contact")

    @_builtins.property
    @pulumi.getter
    def privacy(self) -> _builtins.str:
        """
        Required. Privacy setting for the contacts associated with the Registration.
        Values are PUBLIC_CONTACT_DATA, PRIVATE_CONTACT_DATA, and REDACTED_CONTACT_DATA
        """
        return pulumi.get(self, "privacy")

    @_builtins.property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> 'outputs.RegistrationContactSettingsRegistrantContact':
        """
        Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
        Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
        avoid domain suspension.
        Structure is documented below.
        """
        return pulumi.get(self, "registrant_contact")

    @_builtins.property
    @pulumi.getter(name="technicalContact")
    def technical_contact(self) -> 'outputs.RegistrationContactSettingsTechnicalContact':
        """
        Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.
        Warning: For new Registrations, the registrant receives an email confirmation that they must complete within 15 days to
        avoid domain suspension.
        Structure is documented below.
        """
        return pulumi.get(self, "technical_contact")


@pulumi.output_type
class RegistrationContactSettingsAdminContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalAddress":
            suggest = "postal_address"
        elif key == "faxNumber":
            suggest = "fax_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsAdminContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsAdminContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsAdminContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: _builtins.str,
                 phone_number: _builtins.str,
                 postal_address: 'outputs.RegistrationContactSettingsAdminContactPostalAddress',
                 fax_number: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: Required. Email address of the contact.
        :param _builtins.str phone_number: Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        :param 'RegistrationContactSettingsAdminContactPostalAddressArgs' postal_address: Required. Postal address of the contact.
               Structure is documented below.
        :param _builtins.str fax_number: Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_address", postal_address)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Required. Email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> 'outputs.RegistrationContactSettingsAdminContactPostalAddress':
        """
        Required. Postal address of the contact.
        Structure is documented below.
        """
        return pulumi.get(self, "postal_address")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "fax_number")


@pulumi.output_type
class RegistrationContactSettingsAdminContactPostalAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionCode":
            suggest = "region_code"
        elif key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsAdminContactPostalAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsAdminContactPostalAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsAdminContactPostalAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_code: _builtins.str,
                 address_lines: Optional[Sequence[_builtins.str]] = None,
                 administrative_area: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 recipients: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str region_code: Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
               ensure the value is correct. See https://cldr.unicode.org/ and
               https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param Sequence[_builtins.str] address_lines: Unstructured address lines describing the lower levels of an address.
               Because values in addressLines do not have type information and may sometimes contain multiple values in a single
               field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
               "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
               is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
               the most specific line of an address can be selected based on the language.
        :param _builtins.str administrative_area: Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
               a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
               (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
               this should be left unpopulated.
        :param _builtins.str locality: Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
               where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        :param _builtins.str organization: The name of the organization at the address.
        :param _builtins.str postal_code: Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
               they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[_builtins.str] recipients: The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
               it might contain "care of" information.
        """
        pulumi.set(__self__, "region_code", region_code)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if administrative_area is not None:
            pulumi.set(__self__, "administrative_area", administrative_area)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> _builtins.str:
        """
        Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
        ensure the value is correct. See https://cldr.unicode.org/ and
        https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[Sequence[_builtins.str]]:
        """
        Unstructured address lines describing the lower levels of an address.
        Because values in addressLines do not have type information and may sometimes contain multiple values in a single
        field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
        "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
        is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
        the most specific line of an address can be selected based on the language.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> Optional[_builtins.str]:
        """
        Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
        a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
        (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
        this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
        where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
        they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Optional[Sequence[_builtins.str]]:
        """
        The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
        it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")


@pulumi.output_type
class RegistrationContactSettingsRegistrantContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalAddress":
            suggest = "postal_address"
        elif key == "faxNumber":
            suggest = "fax_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsRegistrantContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsRegistrantContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsRegistrantContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: _builtins.str,
                 phone_number: _builtins.str,
                 postal_address: 'outputs.RegistrationContactSettingsRegistrantContactPostalAddress',
                 fax_number: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: Required. Email address of the contact.
        :param _builtins.str phone_number: Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        :param 'RegistrationContactSettingsRegistrantContactPostalAddressArgs' postal_address: Required. Postal address of the contact.
               Structure is documented below.
        :param _builtins.str fax_number: Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_address", postal_address)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Required. Email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> 'outputs.RegistrationContactSettingsRegistrantContactPostalAddress':
        """
        Required. Postal address of the contact.
        Structure is documented below.
        """
        return pulumi.get(self, "postal_address")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "fax_number")


@pulumi.output_type
class RegistrationContactSettingsRegistrantContactPostalAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionCode":
            suggest = "region_code"
        elif key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsRegistrantContactPostalAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsRegistrantContactPostalAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsRegistrantContactPostalAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_code: _builtins.str,
                 address_lines: Optional[Sequence[_builtins.str]] = None,
                 administrative_area: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 recipients: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str region_code: Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
               ensure the value is correct. See https://cldr.unicode.org/ and
               https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param Sequence[_builtins.str] address_lines: Unstructured address lines describing the lower levels of an address.
               Because values in addressLines do not have type information and may sometimes contain multiple values in a single
               field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
               "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
               is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
               the most specific line of an address can be selected based on the language.
        :param _builtins.str administrative_area: Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
               a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
               (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
               this should be left unpopulated.
        :param _builtins.str locality: Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
               where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        :param _builtins.str organization: The name of the organization at the address.
        :param _builtins.str postal_code: Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
               they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[_builtins.str] recipients: The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
               it might contain "care of" information.
        """
        pulumi.set(__self__, "region_code", region_code)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if administrative_area is not None:
            pulumi.set(__self__, "administrative_area", administrative_area)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> _builtins.str:
        """
        Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
        ensure the value is correct. See https://cldr.unicode.org/ and
        https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[Sequence[_builtins.str]]:
        """
        Unstructured address lines describing the lower levels of an address.
        Because values in addressLines do not have type information and may sometimes contain multiple values in a single
        field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
        "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
        is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
        the most specific line of an address can be selected based on the language.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> Optional[_builtins.str]:
        """
        Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
        a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
        (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
        this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
        where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
        they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Optional[Sequence[_builtins.str]]:
        """
        The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
        it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")


@pulumi.output_type
class RegistrationContactSettingsTechnicalContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalAddress":
            suggest = "postal_address"
        elif key == "faxNumber":
            suggest = "fax_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsTechnicalContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsTechnicalContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsTechnicalContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: _builtins.str,
                 phone_number: _builtins.str,
                 postal_address: 'outputs.RegistrationContactSettingsTechnicalContactPostalAddress',
                 fax_number: Optional[_builtins.str] = None):
        """
        :param _builtins.str email: Required. Email address of the contact.
        :param _builtins.str phone_number: Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        :param 'RegistrationContactSettingsTechnicalContactPostalAddressArgs' postal_address: Required. Postal address of the contact.
               Structure is documented below.
        :param _builtins.str fax_number: Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_address", postal_address)
        if fax_number is not None:
            pulumi.set(__self__, "fax_number", fax_number)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Required. Email address of the contact.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> _builtins.str:
        """
        Required. Phone number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> 'outputs.RegistrationContactSettingsTechnicalContactPostalAddress':
        """
        Required. Postal address of the contact.
        Structure is documented below.
        """
        return pulumi.get(self, "postal_address")

    @_builtins.property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> Optional[_builtins.str]:
        """
        Fax number of the contact in international format. For example, "+1-800-555-0123".
        """
        return pulumi.get(self, "fax_number")


@pulumi.output_type
class RegistrationContactSettingsTechnicalContactPostalAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionCode":
            suggest = "region_code"
        elif key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "postalCode":
            suggest = "postal_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationContactSettingsTechnicalContactPostalAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationContactSettingsTechnicalContactPostalAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationContactSettingsTechnicalContactPostalAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region_code: _builtins.str,
                 address_lines: Optional[Sequence[_builtins.str]] = None,
                 administrative_area: Optional[_builtins.str] = None,
                 locality: Optional[_builtins.str] = None,
                 organization: Optional[_builtins.str] = None,
                 postal_code: Optional[_builtins.str] = None,
                 recipients: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str region_code: Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
               ensure the value is correct. See https://cldr.unicode.org/ and
               https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param Sequence[_builtins.str] address_lines: Unstructured address lines describing the lower levels of an address.
               Because values in addressLines do not have type information and may sometimes contain multiple values in a single
               field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
               "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
               is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
               the most specific line of an address can be selected based on the language.
        :param _builtins.str administrative_area: Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
               a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
               (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
               this should be left unpopulated.
        :param _builtins.str locality: Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
               where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        :param _builtins.str organization: The name of the organization at the address.
        :param _builtins.str postal_code: Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
               they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[_builtins.str] recipients: The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
               it might contain "care of" information.
        """
        pulumi.set(__self__, "region_code", region_code)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if administrative_area is not None:
            pulumi.set(__self__, "administrative_area", administrative_area)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @_builtins.property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> _builtins.str:
        """
        Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the user to
        ensure the value is correct. See https://cldr.unicode.org/ and
        https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[Sequence[_builtins.str]]:
        """
        Unstructured address lines describing the lower levels of an address.
        Because values in addressLines do not have type information and may sometimes contain multiple values in a single
        field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be
        "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language
        is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way,
        the most specific line of an address can be selected based on the language.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> Optional[_builtins.str]:
        """
        Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state,
        a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community
        (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland
        this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @_builtins.property
    @pulumi.getter
    def locality(self) -> Optional[_builtins.str]:
        """
        Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world
        where localities are not well defined or do not fit into this structure well, leave locality empty and use addressLines.
        """
        return pulumi.get(self, "locality")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[_builtins.str]:
        """
        The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[_builtins.str]:
        """
        Postal code of the address. Not all countries use or require postal codes to be present, but where they are used,
        they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> Optional[Sequence[_builtins.str]]:
        """
        The recipient at the address. This field may, under certain circumstances, contain multiline information. For example,
        it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")


@pulumi.output_type
class RegistrationDnsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customDns":
            suggest = "custom_dns"
        elif key == "glueRecords":
            suggest = "glue_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDnsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDnsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDnsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_dns: Optional['outputs.RegistrationDnsSettingsCustomDns'] = None,
                 glue_records: Optional[Sequence['outputs.RegistrationDnsSettingsGlueRecord']] = None):
        """
        :param 'RegistrationDnsSettingsCustomDnsArgs' custom_dns: Configuration for an arbitrary DNS provider.
               Structure is documented below.
        :param Sequence['RegistrationDnsSettingsGlueRecordArgs'] glue_records: The list of glue records for this Registration. Commonly empty.
               Structure is documented below.
        """
        if custom_dns is not None:
            pulumi.set(__self__, "custom_dns", custom_dns)
        if glue_records is not None:
            pulumi.set(__self__, "glue_records", glue_records)

    @_builtins.property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> Optional['outputs.RegistrationDnsSettingsCustomDns']:
        """
        Configuration for an arbitrary DNS provider.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_dns")

    @_builtins.property
    @pulumi.getter(name="glueRecords")
    def glue_records(self) -> Optional[Sequence['outputs.RegistrationDnsSettingsGlueRecord']]:
        """
        The list of glue records for this Registration. Commonly empty.
        Structure is documented below.
        """
        return pulumi.get(self, "glue_records")


@pulumi.output_type
class RegistrationDnsSettingsCustomDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameServers":
            suggest = "name_servers"
        elif key == "dsRecords":
            suggest = "ds_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDnsSettingsCustomDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDnsSettingsCustomDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDnsSettingsCustomDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_servers: Sequence[_builtins.str],
                 ds_records: Optional[Sequence['outputs.RegistrationDnsSettingsCustomDnsDsRecord']] = None):
        """
        :param Sequence[_builtins.str] name_servers: Required. A list of name servers that store the DNS zone for this domain. Each name server is a domain
               name, with Unicode domain names expressed in Punycode format.
        :param Sequence['RegistrationDnsSettingsCustomDnsDsRecordArgs'] ds_records: The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide
               the values to set here. If this field is empty, DNSSEC is disabled.
               Structure is documented below.
        """
        pulumi.set(__self__, "name_servers", name_servers)
        if ds_records is not None:
            pulumi.set(__self__, "ds_records", ds_records)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[_builtins.str]:
        """
        Required. A list of name servers that store the DNS zone for this domain. Each name server is a domain
        name, with Unicode domain names expressed in Punycode format.
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter(name="dsRecords")
    def ds_records(self) -> Optional[Sequence['outputs.RegistrationDnsSettingsCustomDnsDsRecord']]:
        """
        The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide
        the values to set here. If this field is empty, DNSSEC is disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "ds_records")


@pulumi.output_type
class RegistrationDnsSettingsCustomDnsDsRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "digestType":
            suggest = "digest_type"
        elif key == "keyTag":
            suggest = "key_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDnsSettingsCustomDnsDsRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDnsSettingsCustomDnsDsRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDnsSettingsCustomDnsDsRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.str] = None,
                 digest: Optional[_builtins.str] = None,
                 digest_type: Optional[_builtins.str] = None,
                 key_tag: Optional[_builtins.int] = None):
        """
        :param _builtins.str algorithm: The algorithm used to generate the referenced DNSKEY.
        :param _builtins.str digest: The digest generated from the referenced DNSKEY.
        :param _builtins.str digest_type: The hash function used to generate the digest of the referenced DNSKEY.
        :param _builtins.int key_tag: The key tag of the record. Must be set in range 0 -- 65535.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if digest_type is not None:
            pulumi.set(__self__, "digest_type", digest_type)
        if key_tag is not None:
            pulumi.set(__self__, "key_tag", key_tag)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.str]:
        """
        The algorithm used to generate the referenced DNSKEY.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def digest(self) -> Optional[_builtins.str]:
        """
        The digest generated from the referenced DNSKEY.
        """
        return pulumi.get(self, "digest")

    @_builtins.property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> Optional[_builtins.str]:
        """
        The hash function used to generate the digest of the referenced DNSKEY.
        """
        return pulumi.get(self, "digest_type")

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> Optional[_builtins.int]:
        """
        The key tag of the record. Must be set in range 0 -- 65535.
        """
        return pulumi.get(self, "key_tag")


@pulumi.output_type
class RegistrationDnsSettingsGlueRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "ipv4Addresses":
            suggest = "ipv4_addresses"
        elif key == "ipv6Addresses":
            suggest = "ipv6_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationDnsSettingsGlueRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationDnsSettingsGlueRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationDnsSettingsGlueRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: _builtins.str,
                 ipv4_addresses: Optional[Sequence[_builtins.str]] = None,
                 ipv6_addresses: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str host_name: Required. Domain name of the host in Punycode format.
        :param Sequence[_builtins.str] ipv4_addresses: List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
               At least one of ipv4_address and ipv6_address must be set.
        :param Sequence[_builtins.str] ipv6_addresses: List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
               At least one of ipv4_address and ipv6_address must be set.
        """
        pulumi.set(__self__, "host_name", host_name)
        if ipv4_addresses is not None:
            pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Required. Domain name of the host in Punycode format.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
        At least one of ipv4_address and ipv6_address must be set.
        """
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. 198.51.100.1).
        At least one of ipv4_address and ipv6_address must be set.
        """
        return pulumi.get(self, "ipv6_addresses")


@pulumi.output_type
class RegistrationManagementSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredRenewalMethod":
            suggest = "preferred_renewal_method"
        elif key == "renewalMethod":
            suggest = "renewal_method"
        elif key == "transferLockState":
            suggest = "transfer_lock_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationManagementSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationManagementSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationManagementSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_renewal_method: Optional[_builtins.str] = None,
                 renewal_method: Optional[_builtins.str] = None,
                 transfer_lock_state: Optional[_builtins.str] = None):
        """
        :param _builtins.str preferred_renewal_method: The desired renewal method for this Registration. The actual renewalMethod is automatically updated to reflect this choice.
               If unset or equal to RENEWAL_METHOD_UNSPECIFIED, the actual renewalMethod is treated as if it were set to AUTOMATIC_RENEWAL.
               You cannot use RENEWAL_DISABLED during resource creation, and you can update the renewal status only when the Registration
               resource has state ACTIVE or SUSPENDED.
               When preferredRenewalMethod is set to AUTOMATIC_RENEWAL, the actual renewalMethod can be set to RENEWAL_DISABLED in case of
               problems with the billing account or reported domain abuse. In such cases, check the issues field on the Registration. After
               the problem is resolved, the renewalMethod is automatically updated to preferredRenewalMethod in a few hours.
        :param _builtins.str renewal_method: (Output)
               Output only. The actual renewal method for this Registration. When preferredRenewalMethod is set to AUTOMATIC_RENEWAL,
               the actual renewalMethod can be equal to RENEWAL_DISABLED—for example, when there are problems with the billing account
               or reported domain abuse. In such cases, check the issues field on the Registration. After the problem is resolved, the
               renewalMethod is automatically updated to preferredRenewalMethod in a few hours.
        :param _builtins.str transfer_lock_state: Controls whether the domain can be transferred to another registrar. Values are UNLOCKED or LOCKED.
        """
        if preferred_renewal_method is not None:
            pulumi.set(__self__, "preferred_renewal_method", preferred_renewal_method)
        if renewal_method is not None:
            pulumi.set(__self__, "renewal_method", renewal_method)
        if transfer_lock_state is not None:
            pulumi.set(__self__, "transfer_lock_state", transfer_lock_state)

    @_builtins.property
    @pulumi.getter(name="preferredRenewalMethod")
    def preferred_renewal_method(self) -> Optional[_builtins.str]:
        """
        The desired renewal method for this Registration. The actual renewalMethod is automatically updated to reflect this choice.
        If unset or equal to RENEWAL_METHOD_UNSPECIFIED, the actual renewalMethod is treated as if it were set to AUTOMATIC_RENEWAL.
        You cannot use RENEWAL_DISABLED during resource creation, and you can update the renewal status only when the Registration
        resource has state ACTIVE or SUSPENDED.
        When preferredRenewalMethod is set to AUTOMATIC_RENEWAL, the actual renewalMethod can be set to RENEWAL_DISABLED in case of
        problems with the billing account or reported domain abuse. In such cases, check the issues field on the Registration. After
        the problem is resolved, the renewalMethod is automatically updated to preferredRenewalMethod in a few hours.
        """
        return pulumi.get(self, "preferred_renewal_method")

    @_builtins.property
    @pulumi.getter(name="renewalMethod")
    def renewal_method(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The actual renewal method for this Registration. When preferredRenewalMethod is set to AUTOMATIC_RENEWAL,
        the actual renewalMethod can be equal to RENEWAL_DISABLED—for example, when there are problems with the billing account
        or reported domain abuse. In such cases, check the issues field on the Registration. After the problem is resolved, the
        renewalMethod is automatically updated to preferredRenewalMethod in a few hours.
        """
        return pulumi.get(self, "renewal_method")

    @_builtins.property
    @pulumi.getter(name="transferLockState")
    def transfer_lock_state(self) -> Optional[_builtins.str]:
        """
        Controls whether the domain can be transferred to another registrar. Values are UNLOCKED or LOCKED.
        """
        return pulumi.get(self, "transfer_lock_state")


@pulumi.output_type
class RegistrationYearlyPrice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistrationYearlyPrice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistrationYearlyPrice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistrationYearlyPrice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 currency_code: Optional[_builtins.str] = None,
                 units: Optional[_builtins.str] = None):
        """
        :param _builtins.str currency_code: The three-letter currency code defined in ISO 4217.
        :param _builtins.str units: The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[_builtins.str]:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter
    def units(self) -> Optional[_builtins.str]:
        """
        The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")


