# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FunctionBuildConfig',
    'FunctionBuildConfigAutomaticUpdatePolicy',
    'FunctionBuildConfigOnDeployUpdatePolicy',
    'FunctionBuildConfigSource',
    'FunctionBuildConfigSourceRepoSource',
    'FunctionBuildConfigSourceStorageSource',
    'FunctionEventTrigger',
    'FunctionEventTriggerEventFilter',
    'FunctionIamBindingCondition',
    'FunctionIamMemberCondition',
    'FunctionServiceConfig',
    'FunctionServiceConfigDirectVpcNetworkInterface',
    'FunctionServiceConfigSecretEnvironmentVariable',
    'FunctionServiceConfigSecretVolume',
    'FunctionServiceConfigSecretVolumeVersion',
    'GetFunctionBuildConfigResult',
    'GetFunctionBuildConfigAutomaticUpdatePolicyResult',
    'GetFunctionBuildConfigOnDeployUpdatePolicyResult',
    'GetFunctionBuildConfigSourceResult',
    'GetFunctionBuildConfigSourceRepoSourceResult',
    'GetFunctionBuildConfigSourceStorageSourceResult',
    'GetFunctionEventTriggerResult',
    'GetFunctionEventTriggerEventFilterResult',
    'GetFunctionServiceConfigResult',
    'GetFunctionServiceConfigDirectVpcNetworkInterfaceResult',
    'GetFunctionServiceConfigSecretEnvironmentVariableResult',
    'GetFunctionServiceConfigSecretVolumeResult',
    'GetFunctionServiceConfigSecretVolumeVersionResult',
]

@pulumi.output_type
class FunctionBuildConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticUpdatePolicy":
            suggest = "automatic_update_policy"
        elif key == "dockerRepository":
            suggest = "docker_repository"
        elif key == "entryPoint":
            suggest = "entry_point"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "onDeployUpdatePolicy":
            suggest = "on_deploy_update_policy"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_update_policy: Optional['outputs.FunctionBuildConfigAutomaticUpdatePolicy'] = None,
                 build: Optional[_builtins.str] = None,
                 docker_repository: Optional[_builtins.str] = None,
                 entry_point: Optional[_builtins.str] = None,
                 environment_variables: Optional[Mapping[str, _builtins.str]] = None,
                 on_deploy_update_policy: Optional['outputs.FunctionBuildConfigOnDeployUpdatePolicy'] = None,
                 runtime: Optional[_builtins.str] = None,
                 service_account: Optional[_builtins.str] = None,
                 source: Optional['outputs.FunctionBuildConfigSource'] = None,
                 worker_pool: Optional[_builtins.str] = None):
        """
        :param 'FunctionBuildConfigAutomaticUpdatePolicyArgs' automatic_update_policy: Security patches are applied automatically to the runtime without requiring
               the function to be redeployed.
        :param _builtins.str build: (Output)
               The Cloud Build name of the latest successful
               deployment of the function.
        :param _builtins.str docker_repository: User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        :param _builtins.str entry_point: The name of the function (as defined in source code) that will be executed.
               Defaults to the resource name suffix, if not specified. For backward
               compatibility, if function with given name is not found, then the system
               will try to use function named "function". For Node.js this is name of a
               function exported by the module specified in source_location.
        :param Mapping[str, _builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param 'FunctionBuildConfigOnDeployUpdatePolicyArgs' on_deploy_update_policy: Security patches are only applied when a function is redeployed.
               Structure is documented below.
        :param _builtins.str runtime: The runtime in which to run the function. Required when deploying a new
               function, optional when updating an existing function.
        :param _builtins.str service_account: The fully-qualified name of the service account to be used for building the container.
        :param 'FunctionBuildConfigSourceArgs' source: The location of the function source code.
               Structure is documented below.
        :param _builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        if automatic_update_policy is not None:
            pulumi.set(__self__, "automatic_update_policy", automatic_update_policy)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if on_deploy_update_policy is not None:
            pulumi.set(__self__, "on_deploy_update_policy", on_deploy_update_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="automaticUpdatePolicy")
    def automatic_update_policy(self) -> Optional['outputs.FunctionBuildConfigAutomaticUpdatePolicy']:
        """
        Security patches are applied automatically to the runtime without requiring
        the function to be redeployed.
        """
        return pulumi.get(self, "automatic_update_policy")

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[_builtins.str]:
        """
        (Output)
        The Cloud Build name of the latest successful
        deployment of the function.
        """
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[_builtins.str]:
        """
        User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        """
        return pulumi.get(self, "docker_repository")

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[_builtins.str]:
        """
        The name of the function (as defined in source code) that will be executed.
        Defaults to the resource name suffix, if not specified. For backward
        compatibility, if function with given name is not found, then the system
        will try to use function named "function". For Node.js this is name of a
        function exported by the module specified in source_location.
        """
        return pulumi.get(self, "entry_point")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="onDeployUpdatePolicy")
    def on_deploy_update_policy(self) -> Optional['outputs.FunctionBuildConfigOnDeployUpdatePolicy']:
        """
        Security patches are only applied when a function is redeployed.
        Structure is documented below.
        """
        return pulumi.get(self, "on_deploy_update_policy")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        The runtime in which to run the function. Required when deploying a new
        function, optional when updating an existing function.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        The fully-qualified name of the service account to be used for building the container.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional['outputs.FunctionBuildConfigSource']:
        """
        The location of the function source code.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[_builtins.str]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class FunctionBuildConfigAutomaticUpdatePolicy(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class FunctionBuildConfigOnDeployUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigOnDeployUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigOnDeployUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigOnDeployUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str runtime_version: (Output)
               The runtime version which was used during latest function deployment.
        """
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[_builtins.str]:
        """
        (Output)
        The runtime version which was used during latest function deployment.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionBuildConfigSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: Optional['outputs.FunctionBuildConfigSourceRepoSource'] = None,
                 storage_source: Optional['outputs.FunctionBuildConfigSourceStorageSource'] = None):
        """
        :param 'FunctionBuildConfigSourceRepoSourceArgs' repo_source: If provided, get the source from this location in a Cloud Source Repository.
               Structure is documented below.
        :param 'FunctionBuildConfigSourceStorageSourceArgs' storage_source: If provided, get the source from this location in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @_builtins.property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional['outputs.FunctionBuildConfigSourceRepoSource']:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @_builtins.property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional['outputs.FunctionBuildConfigSourceStorageSource']:
        """
        If provided, get the source from this location in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class FunctionBuildConfigSourceRepoSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigSourceRepoSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigSourceRepoSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigSourceRepoSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: Optional[_builtins.str] = None,
                 commit_sha: Optional[_builtins.str] = None,
                 dir: Optional[_builtins.str] = None,
                 invert_regex: Optional[_builtins.bool] = None,
                 project_id: Optional[_builtins.str] = None,
                 repo_name: Optional[_builtins.str] = None,
                 tag_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch_name: Regex matching branches to build.
        :param _builtins.str commit_sha: Regex matching tags to build.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does
               NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository. If omitted, the
               project ID requesting the build is assumed.
        :param _builtins.str repo_name: Name of the Cloud Source Repository.
        :param _builtins.str tag_name: Regex matching tags to build.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[_builtins.str]:
        """
        Regex matching branches to build.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[_builtins.str]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> Optional[_builtins.str]:
        """
        Directory, relative to the source root, in which to run the build.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[_builtins.bool]:
        """
        Only trigger a build if the revision regex does
        NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the
        project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[_builtins.str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[_builtins.str]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class FunctionBuildConfigSourceStorageSource(dict):
    def __init__(__self__, *,
                 bucket: Optional[_builtins.str] = None,
                 generation: Optional[_builtins.int] = None,
                 object: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: Google Cloud Storage bucket containing the source
        :param _builtins.int generation: Google Cloud Storage generation for the object. If the generation
               is omitted, the latest generation will be used.
        :param _builtins.str object: Google Cloud Storage object containing the source.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        Google Cloud Storage bucket containing the source
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.int]:
        """
        Google Cloud Storage generation for the object. If the generation
        is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def object(self) -> Optional[_builtins.str]:
        """
        Google Cloud Storage object containing the source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FunctionEventTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "eventFilters":
            suggest = "event_filters"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "triggerRegion":
            suggest = "trigger_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionEventTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: _builtins.str,
                 event_filters: Optional[Sequence['outputs.FunctionEventTriggerEventFilter']] = None,
                 pubsub_topic: Optional[_builtins.str] = None,
                 retry_policy: Optional[_builtins.str] = None,
                 service_account_email: Optional[_builtins.str] = None,
                 trigger: Optional[_builtins.str] = None,
                 trigger_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str event_type: Required. The type of event to observe.
        :param Sequence['FunctionEventTriggerEventFilterArgs'] event_filters: Criteria used to filter events.
               Structure is documented below.
        :param _builtins.str pubsub_topic: The name of a Pub/Sub topic in the same project that will be used
               as the transport topic for the event delivery.
        :param _builtins.str retry_policy: Describes the retry policy in case of function's execution failure.
               Retried execution is charged as any other execution.
               Possible values are: `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, `RETRY_POLICY_RETRY`.
        :param _builtins.str service_account_email: Optional. The email of the trigger's service account. The service account
               must have permission to invoke Cloud Run services. If empty, defaults to the
               Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        :param _builtins.str trigger: (Output)
               Output only. The resource name of the Eventarc trigger.
        :param _builtins.str trigger_region: The region that the trigger will be in. The trigger will only receive
               events originating in this region. It can be the same
               region as the function, a different region or multi-region, or the global
               region. If not provided, defaults to the same region as the function.
        """
        pulumi.set(__self__, "event_type", event_type)
        if event_filters is not None:
            pulumi.set(__self__, "event_filters", event_filters)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if trigger_region is not None:
            pulumi.set(__self__, "trigger_region", trigger_region)

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> _builtins.str:
        """
        Required. The type of event to observe.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Optional[Sequence['outputs.FunctionEventTriggerEventFilter']]:
        """
        Criteria used to filter events.
        Structure is documented below.
        """
        return pulumi.get(self, "event_filters")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[_builtins.str]:
        """
        The name of a Pub/Sub topic in the same project that will be used
        as the transport topic for the event delivery.
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[_builtins.str]:
        """
        Describes the retry policy in case of function's execution failure.
        Retried execution is charged as any other execution.
        Possible values are: `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, `RETRY_POLICY_RETRY`.
        """
        return pulumi.get(self, "retry_policy")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[_builtins.str]:
        """
        Optional. The email of the trigger's service account. The service account
        must have permission to invoke Cloud Run services. If empty, defaults to the
        Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The resource name of the Eventarc trigger.
        """
        return pulumi.get(self, "trigger")

    @_builtins.property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> Optional[_builtins.str]:
        """
        The region that the trigger will be in. The trigger will only receive
        events originating in this region. It can be the same
        region as the function, a different region or multi-region, or the global
        region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")


@pulumi.output_type
class FunctionEventTriggerEventFilter(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 value: _builtins.str,
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str attribute: 'Required. The name of a CloudEvents attribute.
               Currently, only a subset of attributes are supported for filtering. Use the `gcloud eventarc providers describe` command to learn more about events and their attributes.
               Do not filter for the 'type' attribute here, as this is already achieved by the resource's `event_type` attribute.
        :param _builtins.str value: Required. The value for the attribute.
               If the operator field is set as `match-path-pattern`, this value can be a path pattern instead of an exact value.
        :param _builtins.str operator: Optional. The operator used for matching the events with the value of
               the filter. If not specified, only events that have an exact key-value
               pair specified in the filter are matched.
               The only allowed value is `match-path-pattern`.
               [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "value", value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        'Required. The name of a CloudEvents attribute.
        Currently, only a subset of attributes are supported for filtering. Use the `gcloud eventarc providers describe` command to learn more about events and their attributes.
        Do not filter for the 'type' attribute here, as this is already achieved by the resource's `event_type` attribute.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Required. The value for the attribute.
        If the operator field is set as `match-path-pattern`, this value can be a path pattern instead of an exact value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        Optional. The operator used for matching the events with the value of
        the filter. If not specified, only events that have an exact key-value
        pair specified in the filter are matched.
        The only allowed value is `match-path-pattern`.
        [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class FunctionIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allTrafficOnLatestRevision":
            suggest = "all_traffic_on_latest_revision"
        elif key == "availableCpu":
            suggest = "available_cpu"
        elif key == "availableMemory":
            suggest = "available_memory"
        elif key == "binaryAuthorizationPolicy":
            suggest = "binary_authorization_policy"
        elif key == "directVpcEgress":
            suggest = "direct_vpc_egress"
        elif key == "directVpcNetworkInterfaces":
            suggest = "direct_vpc_network_interfaces"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "gcfUri":
            suggest = "gcf_uri"
        elif key == "ingressSettings":
            suggest = "ingress_settings"
        elif key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"
        elif key == "secretEnvironmentVariables":
            suggest = "secret_environment_variables"
        elif key == "secretVolumes":
            suggest = "secret_volumes"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "vpcConnector":
            suggest = "vpc_connector"
        elif key == "vpcConnectorEgressSettings":
            suggest = "vpc_connector_egress_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_traffic_on_latest_revision: Optional[_builtins.bool] = None,
                 available_cpu: Optional[_builtins.str] = None,
                 available_memory: Optional[_builtins.str] = None,
                 binary_authorization_policy: Optional[_builtins.str] = None,
                 direct_vpc_egress: Optional[_builtins.str] = None,
                 direct_vpc_network_interfaces: Optional[Sequence['outputs.FunctionServiceConfigDirectVpcNetworkInterface']] = None,
                 environment_variables: Optional[Mapping[str, _builtins.str]] = None,
                 gcf_uri: Optional[_builtins.str] = None,
                 ingress_settings: Optional[_builtins.str] = None,
                 max_instance_count: Optional[_builtins.int] = None,
                 max_instance_request_concurrency: Optional[_builtins.int] = None,
                 min_instance_count: Optional[_builtins.int] = None,
                 secret_environment_variables: Optional[Sequence['outputs.FunctionServiceConfigSecretEnvironmentVariable']] = None,
                 secret_volumes: Optional[Sequence['outputs.FunctionServiceConfigSecretVolume']] = None,
                 service: Optional[_builtins.str] = None,
                 service_account_email: Optional[_builtins.str] = None,
                 timeout_seconds: Optional[_builtins.int] = None,
                 uri: Optional[_builtins.str] = None,
                 vpc_connector: Optional[_builtins.str] = None,
                 vpc_connector_egress_settings: Optional[_builtins.str] = None):
        """
        :param _builtins.bool all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. Defaults to true.
        :param _builtins.str available_cpu: The number of CPUs used in a single container instance. Default value is calculated from available memory.
        :param _builtins.str available_memory: The amount of memory available for a function.
               Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
               supplied the value is interpreted as bytes.
        :param _builtins.str binary_authorization_policy: The binary authorization policy to be checked when deploying the Cloud Run service.
        :param _builtins.str direct_vpc_egress: Egress settings for direct VPC. If not provided, it defaults to VPC_EGRESS_PRIVATE_RANGES_ONLY.
               Possible values are: `VPC_EGRESS_ALL_TRAFFIC`, `VPC_EGRESS_PRIVATE_RANGES_ONLY`.
        :param Sequence['FunctionServiceConfigDirectVpcNetworkInterfaceArgs'] direct_vpc_network_interfaces: The Direct VPC network interface for the Cloud Function. Currently only a single Direct VPC is supported.
               Structure is documented below.
        :param Mapping[str, _builtins.str] environment_variables: Environment variables that shall be available during function execution.
        :param _builtins.str gcf_uri: (Output)
               URIs of the Service deployed
        :param _builtins.str ingress_settings: Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
               Default value is `ALLOW_ALL`.
               Possible values are: `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, `ALLOW_INTERNAL_AND_GCLB`.
        :param _builtins.int max_instance_count: The limit on the maximum number of function instances that may coexist at a
               given time.
        :param _builtins.int max_instance_request_concurrency: Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        :param _builtins.int min_instance_count: The limit on the minimum number of function instances that may coexist at a
               given time.
        :param Sequence['FunctionServiceConfigSecretEnvironmentVariableArgs'] secret_environment_variables: Secret environment variables configuration.
               Structure is documented below.
        :param Sequence['FunctionServiceConfigSecretVolumeArgs'] secret_volumes: Secret volumes configuration.
               Structure is documented below.
        :param _builtins.str service: (Output)
               Name of the service associated with a Function.
        :param _builtins.str service_account_email: The email of the service account for this function.
        :param _builtins.int timeout_seconds: The function execution timeout. Execution is considered failed and
               can be terminated if the function is not completed at the end of the
               timeout period. Defaults to 60 seconds.
        :param _builtins.str uri: (Output)
               URI of the Service deployed.
        :param _builtins.str vpc_connector: The Serverless VPC Access connector that this cloud function can connect to.
        :param _builtins.str vpc_connector_egress_settings: Available egress settings.
               Possible values are: `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, `ALL_TRAFFIC`.
        """
        if all_traffic_on_latest_revision is not None:
            pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        if available_cpu is not None:
            pulumi.set(__self__, "available_cpu", available_cpu)
        if available_memory is not None:
            pulumi.set(__self__, "available_memory", available_memory)
        if binary_authorization_policy is not None:
            pulumi.set(__self__, "binary_authorization_policy", binary_authorization_policy)
        if direct_vpc_egress is not None:
            pulumi.set(__self__, "direct_vpc_egress", direct_vpc_egress)
        if direct_vpc_network_interfaces is not None:
            pulumi.set(__self__, "direct_vpc_network_interfaces", direct_vpc_network_interfaces)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if gcf_uri is not None:
            pulumi.set(__self__, "gcf_uri", gcf_uri)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if secret_volumes is not None:
            pulumi.set(__self__, "secret_volumes", secret_volumes)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @_builtins.property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> Optional[_builtins.bool]:
        """
        Whether 100% of traffic is routed to the latest revision. Defaults to true.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @_builtins.property
    @pulumi.getter(name="availableCpu")
    def available_cpu(self) -> Optional[_builtins.str]:
        """
        The number of CPUs used in a single container instance. Default value is calculated from available memory.
        """
        return pulumi.get(self, "available_cpu")

    @_builtins.property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> Optional[_builtins.str]:
        """
        The amount of memory available for a function.
        Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        supplied the value is interpreted as bytes.
        """
        return pulumi.get(self, "available_memory")

    @_builtins.property
    @pulumi.getter(name="binaryAuthorizationPolicy")
    def binary_authorization_policy(self) -> Optional[_builtins.str]:
        """
        The binary authorization policy to be checked when deploying the Cloud Run service.
        """
        return pulumi.get(self, "binary_authorization_policy")

    @_builtins.property
    @pulumi.getter(name="directVpcEgress")
    def direct_vpc_egress(self) -> Optional[_builtins.str]:
        """
        Egress settings for direct VPC. If not provided, it defaults to VPC_EGRESS_PRIVATE_RANGES_ONLY.
        Possible values are: `VPC_EGRESS_ALL_TRAFFIC`, `VPC_EGRESS_PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "direct_vpc_egress")

    @_builtins.property
    @pulumi.getter(name="directVpcNetworkInterfaces")
    def direct_vpc_network_interfaces(self) -> Optional[Sequence['outputs.FunctionServiceConfigDirectVpcNetworkInterface']]:
        """
        The Direct VPC network interface for the Cloud Function. Currently only a single Direct VPC is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "direct_vpc_network_interfaces")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="gcfUri")
    def gcf_uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        URIs of the Service deployed
        """
        return pulumi.get(self, "gcf_uri")

    @_builtins.property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[_builtins.str]:
        """
        Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
        Default value is `ALLOW_ALL`.
        Possible values are: `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, `ALLOW_INTERNAL_AND_GCLB`.
        """
        return pulumi.get(self, "ingress_settings")

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[_builtins.int]:
        """
        The limit on the maximum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[_builtins.int]:
        """
        The limit on the minimum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretEnvironmentVariable']]:
        """
        Secret environment variables configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_environment_variables")

    @_builtins.property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretVolume']]:
        """
        Secret volumes configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_volumes")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        (Output)
        Name of the service associated with a Function.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[_builtins.str]:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        The function execution timeout. Execution is considered failed and
        can be terminated if the function is not completed at the end of the
        timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        URI of the Service deployed.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[_builtins.str]:
        """
        The Serverless VPC Access connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @_builtins.property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[_builtins.str]:
        """
        Available egress settings.
        Possible values are: `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, `ALL_TRAFFIC`.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")


@pulumi.output_type
class FunctionServiceConfigDirectVpcNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str network: The name of the VPC network to which the function will be connected. Specify either a VPC network or a subnet, or both. If you specify only a network, the subnet uses the same name as the network.
        :param _builtins.str subnetwork: The name of the VPC subnetwork that the Cloud Function resource will get IPs from. Specify either a VPC network or a subnet, or both. If both network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Function resource.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The name of the VPC network to which the function will be connected. Specify either a VPC network or a subnet, or both. If you specify only a network, the subnet uses the same name as the network.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The name of the VPC subnetwork that the Cloud Function resource will get IPs from. Specify either a VPC network or a subnet, or both. If both network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network tags applied to this Cloud Function resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class FunctionServiceConfigSecretEnvironmentVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfigSecretEnvironmentVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfigSecretEnvironmentVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfigSecretEnvironmentVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 project_id: _builtins.str,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str key: Name of the environment variable.
        :param _builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param _builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param _builtins.str version: Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FunctionServiceConfigSecretVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfigSecretVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfigSecretVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfigSecretVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 project_id: _builtins.str,
                 secret: _builtins.str,
                 versions: Optional[Sequence['outputs.FunctionServiceConfigSecretVolumeVersion']] = None):
        """
        :param _builtins.str mount_path: The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        :param _builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param _builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param Sequence['FunctionServiceConfigSecretVolumeVersionArgs'] versions: List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
               Structure is documented below.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretVolumeVersion']]:
        """
        List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        Structure is documented below.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class FunctionServiceConfigSecretVolumeVersion(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str path: Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        :param _builtins.str version: Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionBuildConfigResult(dict):
    def __init__(__self__, *,
                 automatic_update_policies: Sequence['outputs.GetFunctionBuildConfigAutomaticUpdatePolicyResult'],
                 build: _builtins.str,
                 docker_repository: _builtins.str,
                 entry_point: _builtins.str,
                 environment_variables: Mapping[str, _builtins.str],
                 on_deploy_update_policies: Sequence['outputs.GetFunctionBuildConfigOnDeployUpdatePolicyResult'],
                 runtime: _builtins.str,
                 service_account: _builtins.str,
                 sources: Sequence['outputs.GetFunctionBuildConfigSourceResult'],
                 worker_pool: _builtins.str):
        """
        :param Sequence['GetFunctionBuildConfigAutomaticUpdatePolicyArgs'] automatic_update_policies: Security patches are applied automatically to the runtime without requiring
               the function to be redeployed.
        :param _builtins.str build: The Cloud Build name of the latest successful
               deployment of the function.
        :param _builtins.str docker_repository: User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        :param _builtins.str entry_point: The name of the function (as defined in source code) that will be executed.
               Defaults to the resource name suffix, if not specified. For backward
               compatibility, if function with given name is not found, then the system
               will try to use function named "function". For Node.js this is name of a
               function exported by the module specified in source_location.
        :param Mapping[str, _builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param Sequence['GetFunctionBuildConfigOnDeployUpdatePolicyArgs'] on_deploy_update_policies: Security patches are only applied when a function is redeployed.
        :param _builtins.str runtime: The runtime in which to run the function. Required when deploying a new
               function, optional when updating an existing function.
        :param _builtins.str service_account: The fully-qualified name of the service account to be used for building the container.
        :param Sequence['GetFunctionBuildConfigSourceArgs'] sources: The location of the function source code.
        :param _builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        pulumi.set(__self__, "automatic_update_policies", automatic_update_policies)
        pulumi.set(__self__, "build", build)
        pulumi.set(__self__, "docker_repository", docker_repository)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "on_deploy_update_policies", on_deploy_update_policies)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="automaticUpdatePolicies")
    def automatic_update_policies(self) -> Sequence['outputs.GetFunctionBuildConfigAutomaticUpdatePolicyResult']:
        """
        Security patches are applied automatically to the runtime without requiring
        the function to be redeployed.
        """
        return pulumi.get(self, "automatic_update_policies")

    @_builtins.property
    @pulumi.getter
    def build(self) -> _builtins.str:
        """
        The Cloud Build name of the latest successful
        deployment of the function.
        """
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> _builtins.str:
        """
        User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        """
        return pulumi.get(self, "docker_repository")

    @_builtins.property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> _builtins.str:
        """
        The name of the function (as defined in source code) that will be executed.
        Defaults to the resource name suffix, if not specified. For backward
        compatibility, if function with given name is not found, then the system
        will try to use function named "function". For Node.js this is name of a
        function exported by the module specified in source_location.
        """
        return pulumi.get(self, "entry_point")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, _builtins.str]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="onDeployUpdatePolicies")
    def on_deploy_update_policies(self) -> Sequence['outputs.GetFunctionBuildConfigOnDeployUpdatePolicyResult']:
        """
        Security patches are only applied when a function is redeployed.
        """
        return pulumi.get(self, "on_deploy_update_policies")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> _builtins.str:
        """
        The runtime in which to run the function. Required when deploying a new
        function, optional when updating an existing function.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        The fully-qualified name of the service account to be used for building the container.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceResult']:
        """
        The location of the function source code.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> _builtins.str:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class GetFunctionBuildConfigAutomaticUpdatePolicyResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetFunctionBuildConfigOnDeployUpdatePolicyResult(dict):
    def __init__(__self__, *,
                 runtime_version: _builtins.str):
        """
        :param _builtins.str runtime_version: The runtime version which was used during latest function deployment.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> _builtins.str:
        """
        The runtime version which was used during latest function deployment.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class GetFunctionBuildConfigSourceResult(dict):
    def __init__(__self__, *,
                 repo_sources: Sequence['outputs.GetFunctionBuildConfigSourceRepoSourceResult'],
                 storage_sources: Sequence['outputs.GetFunctionBuildConfigSourceStorageSourceResult']):
        """
        :param Sequence['GetFunctionBuildConfigSourceRepoSourceArgs'] repo_sources: If provided, get the source from this location in a Cloud Source Repository.
        :param Sequence['GetFunctionBuildConfigSourceStorageSourceArgs'] storage_sources: If provided, get the source from this location in Google Cloud Storage.
        """
        pulumi.set(__self__, "repo_sources", repo_sources)
        pulumi.set(__self__, "storage_sources", storage_sources)

    @_builtins.property
    @pulumi.getter(name="repoSources")
    def repo_sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceRepoSourceResult']:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_sources")

    @_builtins.property
    @pulumi.getter(name="storageSources")
    def storage_sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceStorageSourceResult']:
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_sources")


@pulumi.output_type
class GetFunctionBuildConfigSourceRepoSourceResult(dict):
    def __init__(__self__, *,
                 branch_name: _builtins.str,
                 commit_sha: _builtins.str,
                 dir: _builtins.str,
                 invert_regex: _builtins.bool,
                 project_id: _builtins.str,
                 repo_name: _builtins.str,
                 tag_name: _builtins.str):
        """
        :param _builtins.str branch_name: Regex matching branches to build.
        :param _builtins.str commit_sha: Regex matching tags to build.
        :param _builtins.str dir: Directory, relative to the source root, in which to run the build.
        :param _builtins.bool invert_regex: Only trigger a build if the revision regex does
               NOT match the revision regex.
        :param _builtins.str project_id: ID of the project that owns the Cloud Source Repository. If omitted, the
               project ID requesting the build is assumed.
        :param _builtins.str repo_name: Name of the Cloud Source Repository.
        :param _builtins.str tag_name: Regex matching tags to build.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "tag_name", tag_name)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> _builtins.str:
        """
        Regex matching branches to build.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> _builtins.str:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "commit_sha")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> _builtins.str:
        """
        Directory, relative to the source root, in which to run the build.
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> _builtins.bool:
        """
        Only trigger a build if the revision regex does
        NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the
        project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> _builtins.str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> _builtins.str:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class GetFunctionBuildConfigSourceStorageSourceResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 generation: _builtins.int,
                 object: _builtins.str):
        """
        :param _builtins.str bucket: Google Cloud Storage bucket containing the source
        :param _builtins.int generation: Google Cloud Storage generation for the object. If the generation
               is omitted, the latest generation will be used.
        :param _builtins.str object: Google Cloud Storage object containing the source.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Google Cloud Storage bucket containing the source
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.int:
        """
        Google Cloud Storage generation for the object. If the generation
        is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        Google Cloud Storage object containing the source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetFunctionEventTriggerResult(dict):
    def __init__(__self__, *,
                 event_filters: Sequence['outputs.GetFunctionEventTriggerEventFilterResult'],
                 event_type: _builtins.str,
                 pubsub_topic: _builtins.str,
                 retry_policy: _builtins.str,
                 service_account_email: _builtins.str,
                 trigger: _builtins.str,
                 trigger_region: _builtins.str):
        """
        :param Sequence['GetFunctionEventTriggerEventFilterArgs'] event_filters: Criteria used to filter events.
        :param _builtins.str event_type: Required. The type of event to observe.
        :param _builtins.str pubsub_topic: The name of a Pub/Sub topic in the same project that will be used
               as the transport topic for the event delivery.
        :param _builtins.str retry_policy: Describes the retry policy in case of function's execution failure.
               Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]
        :param _builtins.str service_account_email: Optional. The email of the trigger's service account. The service account
               must have permission to invoke Cloud Run services. If empty, defaults to the
               Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        :param _builtins.str trigger: Output only. The resource name of the Eventarc trigger.
        :param _builtins.str trigger_region: The region that the trigger will be in. The trigger will only receive
               events originating in this region. It can be the same
               region as the function, a different region or multi-region, or the global
               region. If not provided, defaults to the same region as the function.
        """
        pulumi.set(__self__, "event_filters", event_filters)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        pulumi.set(__self__, "retry_policy", retry_policy)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "trigger", trigger)
        pulumi.set(__self__, "trigger_region", trigger_region)

    @_builtins.property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Sequence['outputs.GetFunctionEventTriggerEventFilterResult']:
        """
        Criteria used to filter events.
        """
        return pulumi.get(self, "event_filters")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> _builtins.str:
        """
        Required. The type of event to observe.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> _builtins.str:
        """
        The name of a Pub/Sub topic in the same project that will be used
        as the transport topic for the event delivery.
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> _builtins.str:
        """
        Describes the retry policy in case of function's execution failure.
        Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]
        """
        return pulumi.get(self, "retry_policy")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> _builtins.str:
        """
        Optional. The email of the trigger's service account. The service account
        must have permission to invoke Cloud Run services. If empty, defaults to the
        Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> _builtins.str:
        """
        Output only. The resource name of the Eventarc trigger.
        """
        return pulumi.get(self, "trigger")

    @_builtins.property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> _builtins.str:
        """
        The region that the trigger will be in. The trigger will only receive
        events originating in this region. It can be the same
        region as the function, a different region or multi-region, or the global
        region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")


@pulumi.output_type
class GetFunctionEventTriggerEventFilterResult(dict):
    def __init__(__self__, *,
                 attribute: _builtins.str,
                 operator: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str attribute: 'Required. The name of a CloudEvents attribute.
               Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
               Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.
        :param _builtins.str operator: Optional. The operator used for matching the events with the value of
               the filter. If not specified, only events that have an exact key-value
               pair specified in the filter are matched.
               The only allowed value is 'match-path-pattern'.
               [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        :param _builtins.str value: Required. The value for the attribute.
               If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def attribute(self) -> _builtins.str:
        """
        'Required. The name of a CloudEvents attribute.
        Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
        Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.
        """
        return pulumi.get(self, "attribute")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Optional. The operator used for matching the events with the value of
        the filter. If not specified, only events that have an exact key-value
        pair specified in the filter are matched.
        The only allowed value is 'match-path-pattern'.
        [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Required. The value for the attribute.
        If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetFunctionServiceConfigResult(dict):
    def __init__(__self__, *,
                 all_traffic_on_latest_revision: _builtins.bool,
                 available_cpu: _builtins.str,
                 available_memory: _builtins.str,
                 binary_authorization_policy: _builtins.str,
                 direct_vpc_egress: _builtins.str,
                 direct_vpc_network_interfaces: Sequence['outputs.GetFunctionServiceConfigDirectVpcNetworkInterfaceResult'],
                 environment_variables: Mapping[str, _builtins.str],
                 gcf_uri: _builtins.str,
                 ingress_settings: _builtins.str,
                 max_instance_count: _builtins.int,
                 max_instance_request_concurrency: _builtins.int,
                 min_instance_count: _builtins.int,
                 secret_environment_variables: Sequence['outputs.GetFunctionServiceConfigSecretEnvironmentVariableResult'],
                 secret_volumes: Sequence['outputs.GetFunctionServiceConfigSecretVolumeResult'],
                 service: _builtins.str,
                 service_account_email: _builtins.str,
                 timeout_seconds: _builtins.int,
                 uri: _builtins.str,
                 vpc_connector: _builtins.str,
                 vpc_connector_egress_settings: _builtins.str):
        """
        :param _builtins.bool all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. Defaults to true.
        :param _builtins.str available_cpu: The number of CPUs used in a single container instance. Default value is calculated from available memory.
        :param _builtins.str available_memory: The amount of memory available for a function.
               Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
               supplied the value is interpreted as bytes.
        :param _builtins.str binary_authorization_policy: The binary authorization policy to be checked when deploying the Cloud Run service.
        :param _builtins.str direct_vpc_egress: Egress settings for direct VPC. If not provided, it defaults to VPC_EGRESS_PRIVATE_RANGES_ONLY. Possible values: ["VPC_EGRESS_ALL_TRAFFIC", "VPC_EGRESS_PRIVATE_RANGES_ONLY"]
        :param Sequence['GetFunctionServiceConfigDirectVpcNetworkInterfaceArgs'] direct_vpc_network_interfaces: The Direct VPC network interface for the Cloud Function. Currently only a single Direct VPC is supported.
        :param Mapping[str, _builtins.str] environment_variables: Environment variables that shall be available during function execution.
        :param _builtins.str gcf_uri: URIs of the Service deployed
        :param _builtins.str ingress_settings: Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]
        :param _builtins.int max_instance_count: The limit on the maximum number of function instances that may coexist at a
               given time.
        :param _builtins.int max_instance_request_concurrency: Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        :param _builtins.int min_instance_count: The limit on the minimum number of function instances that may coexist at a
               given time.
        :param Sequence['GetFunctionServiceConfigSecretEnvironmentVariableArgs'] secret_environment_variables: Secret environment variables configuration.
        :param Sequence['GetFunctionServiceConfigSecretVolumeArgs'] secret_volumes: Secret volumes configuration.
        :param _builtins.str service: Name of the service associated with a Function.
        :param _builtins.str service_account_email: The email of the service account for this function.
        :param _builtins.int timeout_seconds: The function execution timeout. Execution is considered failed and
               can be terminated if the function is not completed at the end of the
               timeout period. Defaults to 60 seconds.
        :param _builtins.str uri: URI of the Service deployed.
        :param _builtins.str vpc_connector: The Serverless VPC Access connector that this cloud function can connect to.
        :param _builtins.str vpc_connector_egress_settings: Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]
        """
        pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        pulumi.set(__self__, "available_cpu", available_cpu)
        pulumi.set(__self__, "available_memory", available_memory)
        pulumi.set(__self__, "binary_authorization_policy", binary_authorization_policy)
        pulumi.set(__self__, "direct_vpc_egress", direct_vpc_egress)
        pulumi.set(__self__, "direct_vpc_network_interfaces", direct_vpc_network_interfaces)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "gcf_uri", gcf_uri)
        pulumi.set(__self__, "ingress_settings", ingress_settings)
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        pulumi.set(__self__, "min_instance_count", min_instance_count)
        pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        pulumi.set(__self__, "secret_volumes", secret_volumes)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "vpc_connector", vpc_connector)
        pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @_builtins.property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> _builtins.bool:
        """
        Whether 100% of traffic is routed to the latest revision. Defaults to true.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @_builtins.property
    @pulumi.getter(name="availableCpu")
    def available_cpu(self) -> _builtins.str:
        """
        The number of CPUs used in a single container instance. Default value is calculated from available memory.
        """
        return pulumi.get(self, "available_cpu")

    @_builtins.property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> _builtins.str:
        """
        The amount of memory available for a function.
        Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        supplied the value is interpreted as bytes.
        """
        return pulumi.get(self, "available_memory")

    @_builtins.property
    @pulumi.getter(name="binaryAuthorizationPolicy")
    def binary_authorization_policy(self) -> _builtins.str:
        """
        The binary authorization policy to be checked when deploying the Cloud Run service.
        """
        return pulumi.get(self, "binary_authorization_policy")

    @_builtins.property
    @pulumi.getter(name="directVpcEgress")
    def direct_vpc_egress(self) -> _builtins.str:
        """
        Egress settings for direct VPC. If not provided, it defaults to VPC_EGRESS_PRIVATE_RANGES_ONLY. Possible values: ["VPC_EGRESS_ALL_TRAFFIC", "VPC_EGRESS_PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "direct_vpc_egress")

    @_builtins.property
    @pulumi.getter(name="directVpcNetworkInterfaces")
    def direct_vpc_network_interfaces(self) -> Sequence['outputs.GetFunctionServiceConfigDirectVpcNetworkInterfaceResult']:
        """
        The Direct VPC network interface for the Cloud Function. Currently only a single Direct VPC is supported.
        """
        return pulumi.get(self, "direct_vpc_network_interfaces")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, _builtins.str]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="gcfUri")
    def gcf_uri(self) -> _builtins.str:
        """
        URIs of the Service deployed
        """
        return pulumi.get(self, "gcf_uri")

    @_builtins.property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> _builtins.str:
        """
        Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]
        """
        return pulumi.get(self, "ingress_settings")

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> _builtins.int:
        """
        The limit on the maximum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> _builtins.int:
        """
        Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> _builtins.int:
        """
        The limit on the minimum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Sequence['outputs.GetFunctionServiceConfigSecretEnvironmentVariableResult']:
        """
        Secret environment variables configuration.
        """
        return pulumi.get(self, "secret_environment_variables")

    @_builtins.property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Sequence['outputs.GetFunctionServiceConfigSecretVolumeResult']:
        """
        Secret volumes configuration.
        """
        return pulumi.get(self, "secret_volumes")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        Name of the service associated with a Function.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> _builtins.str:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        The function execution timeout. Execution is considered failed and
        can be terminated if the function is not completed at the end of the
        timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        URI of the Service deployed.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> _builtins.str:
        """
        The Serverless VPC Access connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @_builtins.property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> _builtins.str:
        """
        Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]
        """
        return pulumi.get(self, "vpc_connector_egress_settings")


@pulumi.output_type
class GetFunctionServiceConfigDirectVpcNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 subnetwork: _builtins.str,
                 tags: Sequence[_builtins.str]):
        """
        :param _builtins.str network: The name of the VPC network to which the function will be connected. Specify either a VPC network or a subnet, or both. If you specify only a network, the subnet uses the same name as the network.
        :param _builtins.str subnetwork: The name of the VPC subnetwork that the Cloud Function resource will get IPs from. Specify either a VPC network or a subnet, or both. If both network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Function resource.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The name of the VPC network to which the function will be connected. Specify either a VPC network or a subnet, or both. If you specify only a network, the subnet uses the same name as the network.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The name of the VPC subnetwork that the Cloud Function resource will get IPs from. Specify either a VPC network or a subnet, or both. If both network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Network tags applied to this Cloud Function resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetFunctionServiceConfigSecretEnvironmentVariableResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 project_id: _builtins.str,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str key: Name of the environment variable.
        :param _builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param _builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param _builtins.str version: Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionServiceConfigSecretVolumeResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 project_id: _builtins.str,
                 secret: _builtins.str,
                 versions: Sequence['outputs.GetFunctionServiceConfigSecretVolumeVersionResult']):
        """
        :param _builtins.str mount_path: The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        :param _builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param _builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param Sequence['GetFunctionServiceConfigSecretVolumeVersionArgs'] versions: List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetFunctionServiceConfigSecretVolumeVersionResult']:
        """
        List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetFunctionServiceConfigSecretVolumeVersionResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str path: Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        :param _builtins.str version: Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")


