# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, customer=None, id=None, name=None, policy_queries=None, setting=None, type=None):
        if customer and not isinstance(customer, str):
            raise TypeError("Expected argument 'customer' to be a str")
        pulumi.set(__self__, "customer", customer)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_queries and not isinstance(policy_queries, list):
            raise TypeError("Expected argument 'policy_queries' to be a list")
        pulumi.set(__self__, "policy_queries", policy_queries)
        if setting and not isinstance(setting, str):
            raise TypeError("Expected argument 'setting' to be a str")
        pulumi.set(__self__, "setting", setting)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def customer(self) -> _builtins.str:
        """
        The customer that the policy belongs to.
        """
        return pulumi.get(self, "customer")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name of the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyQueries")
    def policy_queries(self) -> Sequence['outputs.GetPolicyPolicyQueryResult']:
        """
        A list containing the CEL query that defines which entities the policy applies to. Structure is documented below.
        """
        return pulumi.get(self, "policy_queries")

    @_builtins.property
    @pulumi.getter
    def setting(self) -> _builtins.str:
        """
        The setting configured by this policy, represented as a JSON string.
        """
        return pulumi.get(self, "setting")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the policy.
        """
        return pulumi.get(self, "type")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            customer=self.customer,
            id=self.id,
            name=self.name,
            policy_queries=self.policy_queries,
            setting=self.setting,
            type=self.type)


def get_policy(name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Use this data source to retrieve a Cloud Identity policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test = gcp.cloudidentity.get_policy(name="policies/{policy_id}")
    pulumi.export("policyCustomer", test.customer)
    pulumi.export("policyQueryQuery", test.policy_queries[0].query)
    pulumi.export("policyQueryOrgUnit", test.policy_queries[0].org_unit)
    pulumi.export("policyQueryGroup", test.policy_queries[0].group)
    pulumi.export("policyQuerySortOrder", test.policy_queries[0].sort_order)
    pulumi.export("policySetting", test.setting)
    ```


    :param _builtins.str name: The resource name of the policy to retrieve. Format: `policies/{policy_id}`.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:cloudidentity/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        customer=pulumi.get(__ret__, 'customer'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy_queries=pulumi.get(__ret__, 'policy_queries'),
        setting=pulumi.get(__ret__, 'setting'),
        type=pulumi.get(__ret__, 'type'))
def get_policy_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyResult]:
    """
    Use this data source to retrieve a Cloud Identity policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test = gcp.cloudidentity.get_policy(name="policies/{policy_id}")
    pulumi.export("policyCustomer", test.customer)
    pulumi.export("policyQueryQuery", test.policy_queries[0].query)
    pulumi.export("policyQueryOrgUnit", test.policy_queries[0].org_unit)
    pulumi.export("policyQueryGroup", test.policy_queries[0].group)
    pulumi.export("policyQuerySortOrder", test.policy_queries[0].sort_order)
    pulumi.export("policySetting", test.setting)
    ```


    :param _builtins.str name: The resource name of the policy to retrieve. Format: `policies/{policy_id}`.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:cloudidentity/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyResult(
        customer=pulumi.get(__response__, 'customer'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policy_queries=pulumi.get(__response__, 'policy_queries'),
        setting=pulumi.get(__response__, 'setting'),
        type=pulumi.get(__response__, 'type')))
