# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GroupAdditionalGroupKey',
    'GroupGroupKey',
    'GroupMembershipMemberKey',
    'GroupMembershipPreferredMemberKey',
    'GroupMembershipRole',
    'GroupMembershipRoleExpiryDetail',
    'GetGroupLookupGroupKeyResult',
    'GetGroupMembershipsMembershipResult',
    'GetGroupMembershipsMembershipMemberKeyResult',
    'GetGroupMembershipsMembershipPreferredMemberKeyResult',
    'GetGroupMembershipsMembershipRoleResult',
    'GetGroupMembershipsMembershipRoleExpiryDetailResult',
    'GetGroupTransitiveMembershipsMembershipResult',
    'GetGroupTransitiveMembershipsMembershipPreferredMemberKeyResult',
    'GetGroupTransitiveMembershipsMembershipRoleResult',
    'GetGroupsGroupResult',
    'GetGroupsGroupAdditionalGroupKeyResult',
    'GetGroupsGroupGroupKeyResult',
    'GetPolicyPolicyQueryResult',
]

@pulumi.output_type
class GroupAdditionalGroupKey(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: (Output)
               The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param _builtins.str namespace: (Output)
               The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        (Output)
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        (Output)
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GroupGroupKey(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GroupMembershipMemberKey(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GroupMembershipPreferredMemberKey(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the entity.
               For Google-managed entities, the id must be the email address of an existing
               group or user.
               For external-identity-mapped entities, the id must be a string conforming
               to the Identity Source's requirements.
               Must be unique within a namespace.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not specified, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If specified, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GroupMembershipRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiryDetail":
            suggest = "expiry_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMembershipRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMembershipRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMembershipRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 expiry_detail: Optional['outputs.GroupMembershipRoleExpiryDetail'] = None):
        """
        :param _builtins.str name: The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER.
               Possible values are: `OWNER`, `MANAGER`, `MEMBER`.
        :param 'GroupMembershipRoleExpiryDetailArgs' expiry_detail: The MembershipRole expiry details, only supported for MEMBER role.
               Other roles cannot be accompanied with MEMBER role having expiry.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if expiry_detail is not None:
            pulumi.set(__self__, "expiry_detail", expiry_detail)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the MembershipRole. Must be one of OWNER, MANAGER, MEMBER.
        Possible values are: `OWNER`, `MANAGER`, `MEMBER`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="expiryDetail")
    def expiry_detail(self) -> Optional['outputs.GroupMembershipRoleExpiryDetail']:
        """
        The MembershipRole expiry details, only supported for MEMBER role.
        Other roles cannot be accompanied with MEMBER role having expiry.
        Structure is documented below.
        """
        return pulumi.get(self, "expiry_detail")


@pulumi.output_type
class GroupMembershipRoleExpiryDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMembershipRoleExpiryDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMembershipRoleExpiryDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMembershipRoleExpiryDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: _builtins.str):
        """
        :param _builtins.str expire_time: The time at which the MembershipRole will expire.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time at which the MembershipRole will expire.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class GetGroupLookupGroupKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: (Required) The ID of the entity.
               For Google-managed entities, the id is the email address of an existing group or user.
               For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: (Optional) The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required) The ID of the entity.
        For Google-managed entities, the id is the email address of an existing group or user.
        For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        (Optional) The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupMembershipsMembershipResult(dict):
    def __init__(__self__, *,
                 create_ignore_already_exists: _builtins.bool,
                 create_time: _builtins.str,
                 group: _builtins.str,
                 member_keys: Sequence['outputs.GetGroupMembershipsMembershipMemberKeyResult'],
                 name: _builtins.str,
                 preferred_member_keys: Sequence['outputs.GetGroupMembershipsMembershipPreferredMemberKeyResult'],
                 roles: Sequence['outputs.GetGroupMembershipsMembershipRoleResult'],
                 type: _builtins.str,
                 update_time: _builtins.str):
        """
        :param _builtins.bool create_ignore_already_exists: If set to true, skip group member creation if a membership with the same name already exists. Defaults to false.
        :param _builtins.str create_time: The time when the Membership was created.
        :param _builtins.str group: The parent Group resource under which to lookup the Membership names. Must be of the form groups/{group_id}.
        :param Sequence['GetGroupMembershipsMembershipMemberKeyArgs'] member_keys: EntityKey of the member.  Structure is documented below.
        :param _builtins.str name: The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        :param Sequence['GetGroupMembershipsMembershipPreferredMemberKeyArgs'] preferred_member_keys: EntityKey of the member.  Structure is documented below.
        :param Sequence['GetGroupMembershipsMembershipRoleArgs'] roles: The MembershipRoles that apply to the Membership. Structure is documented below.
        :param _builtins.str type: The type of the membership.
        :param _builtins.str update_time: The time when the Membership was last updated.
        """
        pulumi.set(__self__, "create_ignore_already_exists", create_ignore_already_exists)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "member_keys", member_keys)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "preferred_member_keys", preferred_member_keys)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createIgnoreAlreadyExists")
    def create_ignore_already_exists(self) -> _builtins.bool:
        """
        If set to true, skip group member creation if a membership with the same name already exists. Defaults to false.
        """
        return pulumi.get(self, "create_ignore_already_exists")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the Membership was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        The parent Group resource under which to lookup the Membership names. Must be of the form groups/{group_id}.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="memberKeys")
    def member_keys(self) -> Sequence['outputs.GetGroupMembershipsMembershipMemberKeyResult']:
        """
        EntityKey of the member.  Structure is documented below.
        """
        return pulumi.get(self, "member_keys")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="preferredMemberKeys")
    def preferred_member_keys(self) -> Sequence['outputs.GetGroupMembershipsMembershipPreferredMemberKeyResult']:
        """
        EntityKey of the member.  Structure is documented below.
        """
        return pulumi.get(self, "preferred_member_keys")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetGroupMembershipsMembershipRoleResult']:
        """
        The MembershipRoles that apply to the Membership. Structure is documented below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the membership.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time when the Membership was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetGroupMembershipsMembershipMemberKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str id: The ID of the entity. For Google-managed entities, the id is the email address of an existing
               group or user. For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity. For Google-managed entities, the id is the email address of an existing
        group or user. For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupMembershipsMembershipPreferredMemberKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str id: The ID of the entity. For Google-managed entities, the id is the email address of an existing
               group or user. For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity. For Google-managed entities, the id is the email address of an existing
        group or user. For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupMembershipsMembershipRoleResult(dict):
    def __init__(__self__, *,
                 expiry_details: Sequence['outputs.GetGroupMembershipsMembershipRoleExpiryDetailResult'],
                 name: _builtins.str):
        """
        :param Sequence['GetGroupMembershipsMembershipRoleExpiryDetailArgs'] expiry_details: The MembershipRole expiry details, only supported for MEMBER role.
               Other roles cannot be accompanied with MEMBER role having expiry.
        :param _builtins.str name: The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        pulumi.set(__self__, "expiry_details", expiry_details)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="expiryDetails")
    def expiry_details(self) -> Sequence['outputs.GetGroupMembershipsMembershipRoleExpiryDetailResult']:
        """
        The MembershipRole expiry details, only supported for MEMBER role.
        Other roles cannot be accompanied with MEMBER role having expiry.
        """
        return pulumi.get(self, "expiry_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the MembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetGroupMembershipsMembershipRoleExpiryDetailResult(dict):
    def __init__(__self__, *,
                 expire_time: _builtins.str):
        """
        :param _builtins.str expire_time: The time at which the MembershipRole will expire.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
               
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time at which the MembershipRole will expire.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.

        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class GetGroupTransitiveMembershipsMembershipResult(dict):
    def __init__(__self__, *,
                 member: _builtins.str,
                 preferred_member_keys: Sequence['outputs.GetGroupTransitiveMembershipsMembershipPreferredMemberKeyResult'],
                 relation_type: _builtins.str,
                 roles: Sequence['outputs.GetGroupTransitiveMembershipsMembershipRoleResult']):
        """
        :param _builtins.str member: EntityKey of the member.  This value will be either a userKey in the format `users/000000000000000000000` with a numerical id or a groupKey in the format `groups/000ab0000ab0000` with a hexadecimal id.
        :param Sequence['GetGroupTransitiveMembershipsMembershipPreferredMemberKeyArgs'] preferred_member_keys: EntityKey of the member.  Structure is documented below.
        :param _builtins.str relation_type: The relation between the group and the transitive member. The value can be DIRECT, INDIRECT, or DIRECT_AND_INDIRECT.
        :param Sequence['GetGroupTransitiveMembershipsMembershipRoleArgs'] roles: The TransitiveMembershipRoles that apply to the Membership. Structure is documented below.
        """
        pulumi.set(__self__, "member", member)
        pulumi.set(__self__, "preferred_member_keys", preferred_member_keys)
        pulumi.set(__self__, "relation_type", relation_type)
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter
    def member(self) -> _builtins.str:
        """
        EntityKey of the member.  This value will be either a userKey in the format `users/000000000000000000000` with a numerical id or a groupKey in the format `groups/000ab0000ab0000` with a hexadecimal id.
        """
        return pulumi.get(self, "member")

    @_builtins.property
    @pulumi.getter(name="preferredMemberKeys")
    def preferred_member_keys(self) -> Sequence['outputs.GetGroupTransitiveMembershipsMembershipPreferredMemberKeyResult']:
        """
        EntityKey of the member.  Structure is documented below.
        """
        return pulumi.get(self, "preferred_member_keys")

    @_builtins.property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> _builtins.str:
        """
        The relation between the group and the transitive member. The value can be DIRECT, INDIRECT, or DIRECT_AND_INDIRECT.
        """
        return pulumi.get(self, "relation_type")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetGroupTransitiveMembershipsMembershipRoleResult']:
        """
        The TransitiveMembershipRoles that apply to the Membership. Structure is documented below.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class GetGroupTransitiveMembershipsMembershipPreferredMemberKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str id: The ID of the entity. For Google-managed entities, the id is the email address of an existing
               group or user. For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity. For Google-managed entities, the id is the email address of an existing
        group or user. For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupTransitiveMembershipsMembershipRoleResult(dict):
    def __init__(__self__, *,
                 role: _builtins.str):
        """
        :param _builtins.str role: The name of the TransitiveMembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The name of the TransitiveMembershipRole. One of OWNER, MANAGER, MEMBER.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 additional_group_keys: Sequence['outputs.GetGroupsGroupAdditionalGroupKeyResult'],
                 create_time: _builtins.str,
                 description: _builtins.str,
                 display_name: _builtins.str,
                 group_keys: Sequence['outputs.GetGroupsGroupGroupKeyResult'],
                 initial_group_config: _builtins.str,
                 labels: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 parent: _builtins.str,
                 update_time: _builtins.str):
        """
        :param Sequence['GetGroupsGroupAdditionalGroupKeyArgs'] additional_group_keys: Additional group keys associated with the Group
        :param _builtins.str create_time: The time when the Group was created.
        :param _builtins.str description: An extended description to help users determine the purpose of a Group.
        :param _builtins.str display_name: The display name of the Group.
        :param Sequence['GetGroupsGroupGroupKeyArgs'] group_keys: EntityKey of the Group.  Structure is documented below.
        :param _builtins.str initial_group_config: The initial configuration options for creating a Group.
               
               See the
               [API reference](https://cloud.google.com/identity/docs/reference/rest/v1beta1/groups/create#initialgroupconfig)
               for possible values. Default value: "EMPTY" Possible values: ["INITIAL_GROUP_CONFIG_UNSPECIFIED", "WITH_INITIAL_OWNER", "EMPTY"]
        :param Mapping[str, _builtins.str] labels: The labels that apply to the Group.
               Contains 'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
               'system/groups/external': '' if the Group is an external-identity-mapped group.
        :param _builtins.str name: Resource name of the Group in the format: groups/{group_id}, where `group_id` is the unique ID assigned to the Group.
        :param _builtins.str parent: The parent resource under which to list all Groups. Must be of the form identitysources/{identity_source_id} for external- identity-mapped groups or customers/{customer_id} for Google Groups.
        :param _builtins.str update_time: The time when the Group was last updated.
        """
        pulumi.set(__self__, "additional_group_keys", additional_group_keys)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "group_keys", group_keys)
        pulumi.set(__self__, "initial_group_config", initial_group_config)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="additionalGroupKeys")
    def additional_group_keys(self) -> Sequence['outputs.GetGroupsGroupAdditionalGroupKeyResult']:
        """
        Additional group keys associated with the Group
        """
        return pulumi.get(self, "additional_group_keys")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time when the Group was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        An extended description to help users determine the purpose of a Group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="groupKeys")
    def group_keys(self) -> Sequence['outputs.GetGroupsGroupGroupKeyResult']:
        """
        EntityKey of the Group.  Structure is documented below.
        """
        return pulumi.get(self, "group_keys")

    @_builtins.property
    @pulumi.getter(name="initialGroupConfig")
    def initial_group_config(self) -> _builtins.str:
        """
        The initial configuration options for creating a Group.

        See the
        [API reference](https://cloud.google.com/identity/docs/reference/rest/v1beta1/groups/create#initialgroupconfig)
        for possible values. Default value: "EMPTY" Possible values: ["INITIAL_GROUP_CONFIG_UNSPECIFIED", "WITH_INITIAL_OWNER", "EMPTY"]
        """
        return pulumi.get(self, "initial_group_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        The labels that apply to the Group.
        Contains 'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
        'system/groups/external': '' if the Group is an external-identity-mapped group.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Resource name of the Group in the format: groups/{group_id}, where `group_id` is the unique ID assigned to the Group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        """
        The parent resource under which to list all Groups. Must be of the form identitysources/{identity_source_id} for external- identity-mapped groups or customers/{customer_id} for Google Groups.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time when the Group was last updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetGroupsGroupAdditionalGroupKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str id: The ID of the entity.
               For Google-managed entities, the id is the email address of an existing group or user.
               For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity.
        For Google-managed entities, the id is the email address of an existing group or user.
        For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetGroupsGroupGroupKeyResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str id: The ID of the entity.
               For Google-managed entities, the id is the email address of an existing group or user.
               For external-identity-mapped entities, the id is a string conforming
               to the Identity Source's requirements.
        :param _builtins.str namespace: The namespace in which the entity exists.
               If not populated, the EntityKey represents a Google-managed entity
               such as a Google user or a Google Group.
               If populated, the EntityKey represents an external-identity-mapped group.
               The namespace must correspond to an identity source created in Admin Console
               and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the entity.
        For Google-managed entities, the id is the email address of an existing group or user.
        For external-identity-mapped entities, the id is a string conforming
        to the Identity Source's requirements.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace in which the entity exists.
        If not populated, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If populated, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetPolicyPolicyQueryResult(dict):
    def __init__(__self__, *,
                 group: _builtins.str,
                 org_unit: _builtins.str,
                 query: _builtins.str,
                 sort_order: _builtins.float):
        """
        :param _builtins.str group: The group that the policy applies to.
        :param _builtins.str org_unit: The org unit that the policy applies to.
        :param _builtins.str query: The query that defines which entities the policy applies to.
        :param _builtins.float sort_order: The sort order of the policy.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "org_unit", org_unit)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "sort_order", sort_order)

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        The group that the policy applies to.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="orgUnit")
    def org_unit(self) -> _builtins.str:
        """
        The org unit that the policy applies to.
        """
        return pulumi.get(self, "org_unit")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        The query that defines which entities the policy applies to.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> _builtins.float:
        """
        The sort order of the policy.
        """
        return pulumi.get(self, "sort_order")


