# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSQuotaInfoResult',
    'AwaitableGetSQuotaInfoResult',
    'get_s_quota_info',
    'get_s_quota_info_output',
]

@pulumi.output_type
class GetSQuotaInfoResult:
    """
    A collection of values returned by getSQuotaInfo.
    """
    def __init__(__self__, container_type=None, dimensions=None, dimensions_infos=None, id=None, is_concurrent=None, is_fixed=None, is_precise=None, metric=None, metric_display_name=None, metric_unit=None, name=None, parent=None, quota_display_name=None, quota_id=None, quota_increase_eligibilities=None, refresh_interval=None, service=None, service_request_quota_uri=None):
        if container_type and not isinstance(container_type, str):
            raise TypeError("Expected argument 'container_type' to be a str")
        pulumi.set(__self__, "container_type", container_type)
        if dimensions and not isinstance(dimensions, list):
            raise TypeError("Expected argument 'dimensions' to be a list")
        pulumi.set(__self__, "dimensions", dimensions)
        if dimensions_infos and not isinstance(dimensions_infos, list):
            raise TypeError("Expected argument 'dimensions_infos' to be a list")
        pulumi.set(__self__, "dimensions_infos", dimensions_infos)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_concurrent and not isinstance(is_concurrent, bool):
            raise TypeError("Expected argument 'is_concurrent' to be a bool")
        pulumi.set(__self__, "is_concurrent", is_concurrent)
        if is_fixed and not isinstance(is_fixed, bool):
            raise TypeError("Expected argument 'is_fixed' to be a bool")
        pulumi.set(__self__, "is_fixed", is_fixed)
        if is_precise and not isinstance(is_precise, bool):
            raise TypeError("Expected argument 'is_precise' to be a bool")
        pulumi.set(__self__, "is_precise", is_precise)
        if metric and not isinstance(metric, str):
            raise TypeError("Expected argument 'metric' to be a str")
        pulumi.set(__self__, "metric", metric)
        if metric_display_name and not isinstance(metric_display_name, str):
            raise TypeError("Expected argument 'metric_display_name' to be a str")
        pulumi.set(__self__, "metric_display_name", metric_display_name)
        if metric_unit and not isinstance(metric_unit, str):
            raise TypeError("Expected argument 'metric_unit' to be a str")
        pulumi.set(__self__, "metric_unit", metric_unit)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if quota_display_name and not isinstance(quota_display_name, str):
            raise TypeError("Expected argument 'quota_display_name' to be a str")
        pulumi.set(__self__, "quota_display_name", quota_display_name)
        if quota_id and not isinstance(quota_id, str):
            raise TypeError("Expected argument 'quota_id' to be a str")
        pulumi.set(__self__, "quota_id", quota_id)
        if quota_increase_eligibilities and not isinstance(quota_increase_eligibilities, list):
            raise TypeError("Expected argument 'quota_increase_eligibilities' to be a list")
        pulumi.set(__self__, "quota_increase_eligibilities", quota_increase_eligibilities)
        if refresh_interval and not isinstance(refresh_interval, str):
            raise TypeError("Expected argument 'refresh_interval' to be a str")
        pulumi.set(__self__, "refresh_interval", refresh_interval)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)
        if service_request_quota_uri and not isinstance(service_request_quota_uri, str):
            raise TypeError("Expected argument 'service_request_quota_uri' to be a str")
        pulumi.set(__self__, "service_request_quota_uri", service_request_quota_uri)

    @_builtins.property
    @pulumi.getter(name="containerType")
    def container_type(self) -> _builtins.str:
        """
        (Output) The container type of the QuotaInfo.
        """
        return pulumi.get(self, "container_type")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence[_builtins.str]:
        """
        The map of dimensions for this dimensions info. The key of a map entry is "region", "zone" or the name of a service specific dimension, and the value of a map entry is the value of the dimension. If a dimension does not appear in the map of dimensions, the dimensions info applies to all the dimension values except for those that have another DimenisonInfo instance configured for the specific value. Example: {"provider" : "Foo Inc"} where "provider" is a service specific dimension of a quota.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="dimensionsInfos")
    def dimensions_infos(self) -> Sequence['outputs.GetSQuotaInfoDimensionsInfoResult']:
        """
        (Output) The collection of dimensions info ordered by their dimensions from more specific ones to less specific ones.
        """
        return pulumi.get(self, "dimensions_infos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isConcurrent")
    def is_concurrent(self) -> _builtins.bool:
        """
        (Output) Whether the quota is a concurrent quota. Concurrent quotas are enforced on the total number of concurrent operations in flight at any given time.
        """
        return pulumi.get(self, "is_concurrent")

    @_builtins.property
    @pulumi.getter(name="isFixed")
    def is_fixed(self) -> _builtins.bool:
        """
        (Output) Whether the quota value is fixed or adjustable.
        """
        return pulumi.get(self, "is_fixed")

    @_builtins.property
    @pulumi.getter(name="isPrecise")
    def is_precise(self) -> _builtins.bool:
        """
        (Output) Whether this is a precise quota. A precise quota is tracked with absolute precision. In contrast, an imprecise quota is not tracked with precision.
        """
        return pulumi.get(self, "is_precise")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> _builtins.str:
        """
        (Output) The metric of the quota. It specifies the resources consumption the quota is defined for, for example: `compute.googleapis.com/cpus`.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter(name="metricDisplayName")
    def metric_display_name(self) -> _builtins.str:
        """
        (Output) The display name of the quota metric.
        """
        return pulumi.get(self, "metric_display_name")

    @_builtins.property
    @pulumi.getter(name="metricUnit")
    def metric_unit(self) -> _builtins.str:
        """
        (Output) The unit in which the metric value is reported, e.g., `MByte`.
        """
        return pulumi.get(self, "metric_unit")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Output) Resource name of this QuotaInfo, for example: `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="quotaDisplayName")
    def quota_display_name(self) -> _builtins.str:
        """
        (Output) The display name of the quota.
        """
        return pulumi.get(self, "quota_display_name")

    @_builtins.property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> _builtins.str:
        return pulumi.get(self, "quota_id")

    @_builtins.property
    @pulumi.getter(name="quotaIncreaseEligibilities")
    def quota_increase_eligibilities(self) -> Sequence['outputs.GetSQuotaInfoQuotaIncreaseEligibilityResult']:
        """
        (Output) Whether it is eligible to request a higher quota value for this quota.
        """
        return pulumi.get(self, "quota_increase_eligibilities")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> _builtins.str:
        """
        (Output) The reset time interval for the quota. Refresh interval applies to rate quota only. Example: "minute" for per minute, "day" for per day, or "10 seconds" for every 10 seconds.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter(name="serviceRequestQuotaUri")
    def service_request_quota_uri(self) -> _builtins.str:
        """
        (Output) URI to the page where users can request more quota for the cloud service, for example: `https://console.cloud.google.com/iam-admin/quotas`.
        """
        return pulumi.get(self, "service_request_quota_uri")


class AwaitableGetSQuotaInfoResult(GetSQuotaInfoResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSQuotaInfoResult(
            container_type=self.container_type,
            dimensions=self.dimensions,
            dimensions_infos=self.dimensions_infos,
            id=self.id,
            is_concurrent=self.is_concurrent,
            is_fixed=self.is_fixed,
            is_precise=self.is_precise,
            metric=self.metric,
            metric_display_name=self.metric_display_name,
            metric_unit=self.metric_unit,
            name=self.name,
            parent=self.parent,
            quota_display_name=self.quota_display_name,
            quota_id=self.quota_id,
            quota_increase_eligibilities=self.quota_increase_eligibilities,
            refresh_interval=self.refresh_interval,
            service=self.service,
            service_request_quota_uri=self.service_request_quota_uri)


def get_s_quota_info(parent: Optional[_builtins.str] = None,
                     quota_id: Optional[_builtins.str] = None,
                     service: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSQuotaInfoResult:
    """
    Provides information about a particular quota for a given project, folder or organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_quota_info = gcp.cloudquota.get_s_quota_info(parent="projects/my-project",
        service="compute.googleapis.com",
        quota_id="CPUS-per-project-region")
    ```


    :param _builtins.str parent: The parent of the quota info. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number].
    :param _builtins.str quota_id: The id of the quota, which is unique within the service.
    :param _builtins.str service: The name of the service in which the quota is defined.
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['quotaId'] = quota_id
    __args__['service'] = service
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:cloudquota/getSQuotaInfo:getSQuotaInfo', __args__, opts=opts, typ=GetSQuotaInfoResult).value

    return AwaitableGetSQuotaInfoResult(
        container_type=pulumi.get(__ret__, 'container_type'),
        dimensions=pulumi.get(__ret__, 'dimensions'),
        dimensions_infos=pulumi.get(__ret__, 'dimensions_infos'),
        id=pulumi.get(__ret__, 'id'),
        is_concurrent=pulumi.get(__ret__, 'is_concurrent'),
        is_fixed=pulumi.get(__ret__, 'is_fixed'),
        is_precise=pulumi.get(__ret__, 'is_precise'),
        metric=pulumi.get(__ret__, 'metric'),
        metric_display_name=pulumi.get(__ret__, 'metric_display_name'),
        metric_unit=pulumi.get(__ret__, 'metric_unit'),
        name=pulumi.get(__ret__, 'name'),
        parent=pulumi.get(__ret__, 'parent'),
        quota_display_name=pulumi.get(__ret__, 'quota_display_name'),
        quota_id=pulumi.get(__ret__, 'quota_id'),
        quota_increase_eligibilities=pulumi.get(__ret__, 'quota_increase_eligibilities'),
        refresh_interval=pulumi.get(__ret__, 'refresh_interval'),
        service=pulumi.get(__ret__, 'service'),
        service_request_quota_uri=pulumi.get(__ret__, 'service_request_quota_uri'))
def get_s_quota_info_output(parent: Optional[pulumi.Input[_builtins.str]] = None,
                            quota_id: Optional[pulumi.Input[_builtins.str]] = None,
                            service: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSQuotaInfoResult]:
    """
    Provides information about a particular quota for a given project, folder or organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_quota_info = gcp.cloudquota.get_s_quota_info(parent="projects/my-project",
        service="compute.googleapis.com",
        quota_id="CPUS-per-project-region")
    ```


    :param _builtins.str parent: The parent of the quota info. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number].
    :param _builtins.str quota_id: The id of the quota, which is unique within the service.
    :param _builtins.str service: The name of the service in which the quota is defined.
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['quotaId'] = quota_id
    __args__['service'] = service
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:cloudquota/getSQuotaInfo:getSQuotaInfo', __args__, opts=opts, typ=GetSQuotaInfoResult)
    return __ret__.apply(lambda __response__: GetSQuotaInfoResult(
        container_type=pulumi.get(__response__, 'container_type'),
        dimensions=pulumi.get(__response__, 'dimensions'),
        dimensions_infos=pulumi.get(__response__, 'dimensions_infos'),
        id=pulumi.get(__response__, 'id'),
        is_concurrent=pulumi.get(__response__, 'is_concurrent'),
        is_fixed=pulumi.get(__response__, 'is_fixed'),
        is_precise=pulumi.get(__response__, 'is_precise'),
        metric=pulumi.get(__response__, 'metric'),
        metric_display_name=pulumi.get(__response__, 'metric_display_name'),
        metric_unit=pulumi.get(__response__, 'metric_unit'),
        name=pulumi.get(__response__, 'name'),
        parent=pulumi.get(__response__, 'parent'),
        quota_display_name=pulumi.get(__response__, 'quota_display_name'),
        quota_id=pulumi.get(__response__, 'quota_id'),
        quota_increase_eligibilities=pulumi.get(__response__, 'quota_increase_eligibilities'),
        refresh_interval=pulumi.get(__response__, 'refresh_interval'),
        service=pulumi.get(__response__, 'service'),
        service_request_quota_uri=pulumi.get(__response__, 'service_request_quota_uri')))
