# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 create_notebook_execution_job_request: pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs'],
                 cron: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 max_concurrent_run_count: pulumi.Input[_builtins.str],
                 allow_queueing: Optional[pulumi.Input[_builtins.bool]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 max_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs'] create_notebook_execution_job_request: Request for google_colab_notebook_execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the Schedule.
        :param pulumi.Input[_builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[_builtins.str] max_concurrent_run_count: Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        :param pulumi.Input[_builtins.bool] allow_queueing: Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        :param pulumi.Input[_builtins.str] end_time: Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] max_run_count: Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] start_time: The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        pulumi.set(__self__, "create_notebook_execution_job_request", create_notebook_execution_job_request)
        pulumi.set(__self__, "cron", cron)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "max_concurrent_run_count", max_concurrent_run_count)
        if allow_queueing is not None:
            pulumi.set(__self__, "allow_queueing", allow_queueing)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if max_run_count is not None:
            pulumi.set(__self__, "max_run_count", max_run_count)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="createNotebookExecutionJobRequest")
    def create_notebook_execution_job_request(self) -> pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs']:
        """
        Request for google_colab_notebook_execution.
        Structure is documented below.
        """
        return pulumi.get(self, "create_notebook_execution_job_request")

    @create_notebook_execution_job_request.setter
    def create_notebook_execution_job_request(self, value: pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs']):
        pulumi.set(self, "create_notebook_execution_job_request", value)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> pulumi.Input[_builtins.str]:
        """
        Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The display name of the Schedule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentRunCount")
    def max_concurrent_run_count(self) -> pulumi.Input[_builtins.str]:
        """
        Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        """
        return pulumi.get(self, "max_concurrent_run_count")

    @max_concurrent_run_count.setter
    def max_concurrent_run_count(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "max_concurrent_run_count", value)

    @_builtins.property
    @pulumi.getter(name="allowQueueing")
    def allow_queueing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        """
        return pulumi.get(self, "allow_queueing")

    @allow_queueing.setter
    def allow_queueing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_queueing", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="maxRunCount")
    def max_run_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        """
        return pulumi.get(self, "max_run_count")

    @max_run_count.setter
    def max_run_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_run_count", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 allow_queueing: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_notebook_execution_job_request: Optional[pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs']] = None,
                 cron: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 max_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input[_builtins.bool] allow_queueing: Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        :param pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs'] create_notebook_execution_job_request: Request for google_colab_notebook_execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the Schedule.
        :param pulumi.Input[_builtins.str] end_time: Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[_builtins.str] max_concurrent_run_count: Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        :param pulumi.Input[_builtins.str] max_run_count: Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        :param pulumi.Input[_builtins.str] name: The resource name of the Schedule
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] start_time: The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] state: Output only. The state of the schedule.
        """
        if allow_queueing is not None:
            pulumi.set(__self__, "allow_queueing", allow_queueing)
        if create_notebook_execution_job_request is not None:
            pulumi.set(__self__, "create_notebook_execution_job_request", create_notebook_execution_job_request)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_concurrent_run_count is not None:
            pulumi.set(__self__, "max_concurrent_run_count", max_concurrent_run_count)
        if max_run_count is not None:
            pulumi.set(__self__, "max_run_count", max_run_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="allowQueueing")
    def allow_queueing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        """
        return pulumi.get(self, "allow_queueing")

    @allow_queueing.setter
    def allow_queueing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_queueing", value)

    @_builtins.property
    @pulumi.getter(name="createNotebookExecutionJobRequest")
    def create_notebook_execution_job_request(self) -> Optional[pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs']]:
        """
        Request for google_colab_notebook_execution.
        Structure is documented below.
        """
        return pulumi.get(self, "create_notebook_execution_job_request")

    @create_notebook_execution_job_request.setter
    def create_notebook_execution_job_request(self, value: Optional[pulumi.Input['ScheduleCreateNotebookExecutionJobRequestArgs']]):
        pulumi.set(self, "create_notebook_execution_job_request", value)

    @_builtins.property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cron", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The display name of the Schedule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentRunCount")
    def max_concurrent_run_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        """
        return pulumi.get(self, "max_concurrent_run_count")

    @max_concurrent_run_count.setter
    def max_concurrent_run_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_concurrent_run_count", value)

    @_builtins.property
    @pulumi.getter(name="maxRunCount")
    def max_run_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        """
        return pulumi.get(self, "max_run_count")

    @max_run_count.setter
    def max_run_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_run_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Schedule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The state of the schedule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:colab/schedule:Schedule")
class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_queueing: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_notebook_execution_job_request: Optional[pulumi.Input[Union['ScheduleCreateNotebookExecutionJobRequestArgs', 'ScheduleCreateNotebookExecutionJobRequestArgsDict']]] = None,
                 cron: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 max_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        'Colab Enterprise Notebook Execution Schedules.'

        To get more information about Schedule, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.schedules)
        * How-to Guides
            * [Schedule a notebook run](https://cloud.google.com/colab/docs/schedule-notebook-run)

        ## Example Usage

        ### Colab Schedule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              \\"cells\\": [
                {
                  \\"cell_type\\": \\"code\\",
                  \\"execution_count\\": null,
                  \\"metadata\\": {},
                  \\"outputs\\": [],
                  \\"source\\": [
                    \\"print(\\\\\\"Hello, World!\\\\\\")\\"
                  ]
                }
              ],
              \\"metadata\\": {
                \\"kernelspec\\": {
                  \\"display_name\\": \\"Python 3\\",
                  \\"language\\": \\"python\\",
                  \\"name\\": \\"python3\\"
                },
                \\"language_info\\": {
                  \\"codemirror_mode\\": {
                    \\"name\\": \\"ipython\\",
                    \\"version\\": 3
                  },
                  \\"file_extension\\": \\".py\\",
                  \\"mimetype\\": \\"text/x-python\\",
                  \\"name\\": \\"python\\",
                  \\"nbconvert_exporter\\": \\"python\\",
                  \\"pygments_lexer\\": \\"ipython3\\",
                  \\"version\\": \\"3.8.5\\"
                }
              },
              \\"nbformat\\": 4,
              \\"nbformat_minor\\": 4
            }
        \"\"\")
        schedule = gcp.colab.Schedule("schedule",
            display_name="basic-schedule",
            location="us-west1",
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "gcs_notebook_source": {
                        "uri": pulumi.Output.all(
                            bucket=notebook.bucket,
                            name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                        "generation": notebook.generation,
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Schedule Paused

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              \\"cells\\": [
                {
                  \\"cell_type\\": \\"code\\",
                  \\"execution_count\\": null,
                  \\"metadata\\": {},
                  \\"outputs\\": [],
                  \\"source\\": [
                    \\"print(\\\\\\"Hello, World!\\\\\\")\\"
                  ]
                }
              ],
              \\"metadata\\": {
                \\"kernelspec\\": {
                  \\"display_name\\": \\"Python 3\\",
                  \\"language\\": \\"python\\",
                  \\"name\\": \\"python3\\"
                },
                \\"language_info\\": {
                  \\"codemirror_mode\\": {
                    \\"name\\": \\"ipython\\",
                    \\"version\\": 3
                  },
                  \\"file_extension\\": \\".py\\",
                  \\"mimetype\\": \\"text/x-python\\",
                  \\"name\\": \\"python\\",
                  \\"nbconvert_exporter\\": \\"python\\",
                  \\"pygments_lexer\\": \\"ipython3\\",
                  \\"version\\": \\"3.8.5\\"
                }
              },
              \\"nbformat\\": 4,
              \\"nbformat_minor\\": 4
            }
        \"\"\")
        schedule = gcp.colab.Schedule("schedule",
            display_name="paused-schedule",
            location="us-west1",
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            desired_state="PAUSED",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "gcs_notebook_source": {
                        "uri": pulumi.Output.all(
                            bucket=notebook.bucket,
                            name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                        "generation": notebook.generation,
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Schedule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="secret-data")
        dataform_repository = gcp.dataform.Repository("dataform_repository",
            name="dataform-repository",
            display_name="dataform_repository",
            npmrc_environment_variables_secret_version=secret_version.id,
            kms_key_name="my-key",
            labels={
                "label_foo1": "label-bar1",
            },
            git_remote_settings={
                "url": "https://github.com/OWNER/REPOSITORY.git",
                "default_branch": "main",
                "authentication_token_secret_version": secret_version.id,
            },
            workspace_compilation_overrides={
                "default_database": "database",
                "schema_suffix": "_suffix",
                "table_prefix": "prefix_",
            })
        schedule = gcp.colab.Schedule("schedule",
            display_name="full-schedule",
            location="us-west1",
            allow_queueing=True,
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            max_run_count="5",
            start_time="2014-10-02T15:01:23Z",
            end_time="2014-10-10T15:01:23Z",
            desired_state="ACTIVE",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "execution_timeout": "86400s",
                    "dataform_repository_source": {
                        "commit_sha": "randomsha123",
                        "dataform_repository_resource_name": dataform_repository.name.apply(lambda name: f"projects/my-project-name/locations/us-west1/repositories/{name}"),
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                    secret_version,
                    dataform_repository,
                ]))
        ```

        ## Import

        Schedule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/schedules/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Schedule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default projects/{{project}}/locations/{{location}}/schedules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_queueing: Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        :param pulumi.Input[Union['ScheduleCreateNotebookExecutionJobRequestArgs', 'ScheduleCreateNotebookExecutionJobRequestArgsDict']] create_notebook_execution_job_request: Request for google_colab_notebook_execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the Schedule.
        :param pulumi.Input[_builtins.str] end_time: Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[_builtins.str] max_concurrent_run_count: Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        :param pulumi.Input[_builtins.str] max_run_count: Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] start_time: The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        'Colab Enterprise Notebook Execution Schedules.'

        To get more information about Schedule, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.schedules)
        * How-to Guides
            * [Schedule a notebook run](https://cloud.google.com/colab/docs/schedule-notebook-run)

        ## Example Usage

        ### Colab Schedule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              \\"cells\\": [
                {
                  \\"cell_type\\": \\"code\\",
                  \\"execution_count\\": null,
                  \\"metadata\\": {},
                  \\"outputs\\": [],
                  \\"source\\": [
                    \\"print(\\\\\\"Hello, World!\\\\\\")\\"
                  ]
                }
              ],
              \\"metadata\\": {
                \\"kernelspec\\": {
                  \\"display_name\\": \\"Python 3\\",
                  \\"language\\": \\"python\\",
                  \\"name\\": \\"python3\\"
                },
                \\"language_info\\": {
                  \\"codemirror_mode\\": {
                    \\"name\\": \\"ipython\\",
                    \\"version\\": 3
                  },
                  \\"file_extension\\": \\".py\\",
                  \\"mimetype\\": \\"text/x-python\\",
                  \\"name\\": \\"python\\",
                  \\"nbconvert_exporter\\": \\"python\\",
                  \\"pygments_lexer\\": \\"ipython3\\",
                  \\"version\\": \\"3.8.5\\"
                }
              },
              \\"nbformat\\": 4,
              \\"nbformat_minor\\": 4
            }
        \"\"\")
        schedule = gcp.colab.Schedule("schedule",
            display_name="basic-schedule",
            location="us-west1",
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "gcs_notebook_source": {
                        "uri": pulumi.Output.all(
                            bucket=notebook.bucket,
                            name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                        "generation": notebook.generation,
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Schedule Paused

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              \\"cells\\": [
                {
                  \\"cell_type\\": \\"code\\",
                  \\"execution_count\\": null,
                  \\"metadata\\": {},
                  \\"outputs\\": [],
                  \\"source\\": [
                    \\"print(\\\\\\"Hello, World!\\\\\\")\\"
                  ]
                }
              ],
              \\"metadata\\": {
                \\"kernelspec\\": {
                  \\"display_name\\": \\"Python 3\\",
                  \\"language\\": \\"python\\",
                  \\"name\\": \\"python3\\"
                },
                \\"language_info\\": {
                  \\"codemirror_mode\\": {
                    \\"name\\": \\"ipython\\",
                    \\"version\\": 3
                  },
                  \\"file_extension\\": \\".py\\",
                  \\"mimetype\\": \\"text/x-python\\",
                  \\"name\\": \\"python\\",
                  \\"nbconvert_exporter\\": \\"python\\",
                  \\"pygments_lexer\\": \\"ipython3\\",
                  \\"version\\": \\"3.8.5\\"
                }
              },
              \\"nbformat\\": 4,
              \\"nbformat_minor\\": 4
            }
        \"\"\")
        schedule = gcp.colab.Schedule("schedule",
            display_name="paused-schedule",
            location="us-west1",
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            desired_state="PAUSED",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "gcs_notebook_source": {
                        "uri": pulumi.Output.all(
                            bucket=notebook.bucket,
                            name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                        "generation": notebook.generation,
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Schedule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="secret-data")
        dataform_repository = gcp.dataform.Repository("dataform_repository",
            name="dataform-repository",
            display_name="dataform_repository",
            npmrc_environment_variables_secret_version=secret_version.id,
            kms_key_name="my-key",
            labels={
                "label_foo1": "label-bar1",
            },
            git_remote_settings={
                "url": "https://github.com/OWNER/REPOSITORY.git",
                "default_branch": "main",
                "authentication_token_secret_version": secret_version.id,
            },
            workspace_compilation_overrides={
                "default_database": "database",
                "schema_suffix": "_suffix",
                "table_prefix": "prefix_",
            })
        schedule = gcp.colab.Schedule("schedule",
            display_name="full-schedule",
            location="us-west1",
            allow_queueing=True,
            max_concurrent_run_count="2",
            cron="TZ=America/Los_Angeles * * * * *",
            max_run_count="5",
            start_time="2014-10-02T15:01:23Z",
            end_time="2014-10-10T15:01:23Z",
            desired_state="ACTIVE",
            create_notebook_execution_job_request={
                "notebook_execution_job": {
                    "display_name": "Notebook execution",
                    "execution_timeout": "86400s",
                    "dataform_repository_source": {
                        "commit_sha": "randomsha123",
                        "dataform_repository_resource_name": dataform_repository.name.apply(lambda name: f"projects/my-project-name/locations/us-west1/repositories/{name}"),
                    },
                    "notebook_runtime_template_resource_name": pulumi.Output.all(
                        project=my_runtime_template.project,
                        location=my_runtime_template.location,
                        name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
                    "gcs_output_uri": output_bucket.name.apply(lambda name: f"gs://{name}"),
                    "service_account": "my@service-account.com",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                    secret_version,
                    dataform_repository,
                ]))
        ```

        ## Import

        Schedule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/schedules/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Schedule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default projects/{{project}}/locations/{{location}}/schedules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/schedule:Schedule default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_queueing: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_notebook_execution_job_request: Optional[pulumi.Input[Union['ScheduleCreateNotebookExecutionJobRequestArgs', 'ScheduleCreateNotebookExecutionJobRequestArgsDict']]] = None,
                 cron: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrent_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 max_run_count: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            __props__.__dict__["allow_queueing"] = allow_queueing
            if create_notebook_execution_job_request is None and not opts.urn:
                raise TypeError("Missing required property 'create_notebook_execution_job_request'")
            __props__.__dict__["create_notebook_execution_job_request"] = create_notebook_execution_job_request
            if cron is None and not opts.urn:
                raise TypeError("Missing required property 'cron'")
            __props__.__dict__["cron"] = cron
            __props__.__dict__["desired_state"] = desired_state
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["end_time"] = end_time
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if max_concurrent_run_count is None and not opts.urn:
                raise TypeError("Missing required property 'max_concurrent_run_count'")
            __props__.__dict__["max_concurrent_run_count"] = max_concurrent_run_count
            __props__.__dict__["max_run_count"] = max_run_count
            __props__.__dict__["project"] = project
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(Schedule, __self__).__init__(
            'gcp:colab/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_queueing: Optional[pulumi.Input[_builtins.bool]] = None,
            create_notebook_execution_job_request: Optional[pulumi.Input[Union['ScheduleCreateNotebookExecutionJobRequestArgs', 'ScheduleCreateNotebookExecutionJobRequestArgsDict']]] = None,
            cron: Optional[pulumi.Input[_builtins.str]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_concurrent_run_count: Optional[pulumi.Input[_builtins.str]] = None,
            max_run_count: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_queueing: Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        :param pulumi.Input[Union['ScheduleCreateNotebookExecutionJobRequestArgs', 'ScheduleCreateNotebookExecutionJobRequestArgsDict']] create_notebook_execution_job_request: Request for google_colab_notebook_execution.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the Schedule.
        :param pulumi.Input[_builtins.str] end_time: Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[_builtins.str] max_concurrent_run_count: Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        :param pulumi.Input[_builtins.str] max_run_count: Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        :param pulumi.Input[_builtins.str] name: The resource name of the Schedule
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] start_time: The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        :param pulumi.Input[_builtins.str] state: Output only. The state of the schedule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["allow_queueing"] = allow_queueing
        __props__.__dict__["create_notebook_execution_job_request"] = create_notebook_execution_job_request
        __props__.__dict__["cron"] = cron
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["location"] = location
        __props__.__dict__["max_concurrent_run_count"] = max_concurrent_run_count
        __props__.__dict__["max_run_count"] = max_run_count
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["state"] = state
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowQueueing")
    def allow_queueing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether new scheduled runs can be queued when max_concurrent_runs limit is reached. If set to true, new runs will be queued instead of skipped. Default to false.
        """
        return pulumi.get(self, "allow_queueing")

    @_builtins.property
    @pulumi.getter(name="createNotebookExecutionJobRequest")
    def create_notebook_execution_job_request(self) -> pulumi.Output['outputs.ScheduleCreateNotebookExecutionJobRequest']:
        """
        Request for google_colab_notebook_execution.
        Structure is documented below.
        """
        return pulumi.get(self, "create_notebook_execution_job_request")

    @_builtins.property
    @pulumi.getter
    def cron(self) -> pulumi.Output[_builtins.str]:
        """
        Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled runs.
        """
        return pulumi.get(self, "cron")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Desired state of the Colab Schedule. Set this field to `ACTIVE` to start/resume the schedule, and `PAUSED` to pause the schedule.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The display name of the Schedule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Timestamp after which no new runs can be scheduled. If specified, the schedule will be completed when either end_time is reached or when scheduled_run_count >= max_run_count. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentRunCount")
    def max_concurrent_run_count(self) -> pulumi.Output[_builtins.str]:
        """
        Maximum number of runs that can be started concurrently for this Schedule. This is the limit for starting the scheduled requests and not the execution of the notebook execution jobs created by the requests.
        """
        return pulumi.get(self, "max_concurrent_run_count")

    @_builtins.property
    @pulumi.getter(name="maxRunCount")
    def max_run_count(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Maximum run count of the schedule. If specified, The schedule will be completed when either startedRunCount >= maxRunCount or when endTime is reached. If not specified, new runs will keep getting scheduled until this Schedule is paused or deleted. Already scheduled runs will be allowed to complete. Unset if not specified.
        """
        return pulumi.get(self, "max_run_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Schedule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp after which the first run can be scheduled. Defaults to the schedule creation time. Must be in the RFC 3339 (https://www.ietf.org/rfc/rfc3339.txt) format.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The state of the schedule.
        """
        return pulumi.get(self, "state")

