# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserWorkloadsSecretResult',
    'AwaitableGetUserWorkloadsSecretResult',
    'get_user_workloads_secret',
    'get_user_workloads_secret_output',
]

@pulumi.output_type
class GetUserWorkloadsSecretResult:
    """
    A collection of values returned by getUserWorkloadsSecret.
    """
    def __init__(__self__, data=None, environment=None, id=None, name=None, project=None, region=None):
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetUserWorkloadsSecretResult(GetUserWorkloadsSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserWorkloadsSecretResult(
            data=self.data,
            environment=self.environment,
            id=self.id,
            name=self.name,
            project=self.project,
            region=self.region)


def get_user_workloads_secret(environment: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              project: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserWorkloadsSecretResult:
    """
    Provides access to Kubernetes Secret configuration for a given project, region and Composer Environment.

    To get more information about Composer User Workloads Secrets, see:

    * [API documentation](https://cloud.google.com/composer/docs/reference/rest/v1/projects.locations.environments.userWorkloadsSecrets)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
        environment=example_environment.name,
        name="example-secret",
        data={
            "username": std.base64encode(input="username").result,
            "password": std.base64encode(input="password").result,
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_secret_output(environment=name,
        name=google_composer_user_workloads_secret["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param _builtins.str environment: Environment where the Secret is stored.
    :param _builtins.str name: Name of the Secret.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str region: The location or Compute Engine region of the environment.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:composer/getUserWorkloadsSecret:getUserWorkloadsSecret', __args__, opts=opts, typ=GetUserWorkloadsSecretResult).value

    return AwaitableGetUserWorkloadsSecretResult(
        data=pulumi.get(__ret__, 'data'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))
def get_user_workloads_secret_output(environment: Optional[pulumi.Input[_builtins.str]] = None,
                                     name: Optional[pulumi.Input[_builtins.str]] = None,
                                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserWorkloadsSecretResult]:
    """
    Provides access to Kubernetes Secret configuration for a given project, region and Composer Environment.

    To get more information about Composer User Workloads Secrets, see:

    * [API documentation](https://cloud.google.com/composer/docs/reference/rest/v1/projects.locations.environments.userWorkloadsSecrets)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
        environment=example_environment.name,
        name="example-secret",
        data={
            "username": std.base64encode(input="username").result,
            "password": std.base64encode(input="password").result,
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_secret_output(environment=name,
        name=google_composer_user_workloads_secret["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param _builtins.str environment: Environment where the Secret is stored.
    :param _builtins.str name: Name of the Secret.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param _builtins.str region: The location or Compute Engine region of the environment.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:composer/getUserWorkloadsSecret:getUserWorkloadsSecret', __args__, opts=opts, typ=GetUserWorkloadsSecretResult)
    return __ret__.apply(lambda __response__: GetUserWorkloadsSecretResult(
        data=pulumi.get(__response__, 'data'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region')))
