# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInterconnectLocationResult',
    'AwaitableGetInterconnectLocationResult',
    'get_interconnect_location',
    'get_interconnect_location_output',
]

@pulumi.output_type
class GetInterconnectLocationResult:
    """
    A collection of values returned by getInterconnectLocation.
    """
    def __init__(__self__, address=None, availability_zone=None, city=None, continent=None, description=None, facility_provider=None, facility_provider_facility_id=None, id=None, name=None, peeringdb_facility_id=None, project=None, self_link=None, status=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if continent and not isinstance(continent, str):
            raise TypeError("Expected argument 'continent' to be a str")
        pulumi.set(__self__, "continent", continent)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if facility_provider and not isinstance(facility_provider, str):
            raise TypeError("Expected argument 'facility_provider' to be a str")
        pulumi.set(__self__, "facility_provider", facility_provider)
        if facility_provider_facility_id and not isinstance(facility_provider_facility_id, str):
            raise TypeError("Expected argument 'facility_provider_facility_id' to be a str")
        pulumi.set(__self__, "facility_provider_facility_id", facility_provider_facility_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peeringdb_facility_id and not isinstance(peeringdb_facility_id, str):
            raise TypeError("Expected argument 'peeringdb_facility_id' to be a str")
        pulumi.set(__self__, "peeringdb_facility_id", peeringdb_facility_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The postal address of the Point of Presence.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone for this InterconnectLocation.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        The city for this location.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def continent(self) -> _builtins.str:
        """
        The continent for this location.
        """
        return pulumi.get(self, "continent")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A textual description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="facilityProvider")
    def facility_provider(self) -> _builtins.str:
        """
        The name of the provider for this facility.
        """
        return pulumi.get(self, "facility_provider")

    @_builtins.property
    @pulumi.getter(name="facilityProviderFacilityId")
    def facility_provider_facility_id(self) -> _builtins.str:
        """
        A provider-assigned Identifier for this facility.
        """
        return pulumi.get(self, "facility_provider_facility_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peeringdbFacilityId")
    def peeringdb_facility_id(self) -> _builtins.str:
        """
        The PeeringDB facility ID for this facility.
        """
        return pulumi.get(self, "peeringdb_facility_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of this InterconnectLocation.
        """
        return pulumi.get(self, "status")


class AwaitableGetInterconnectLocationResult(GetInterconnectLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInterconnectLocationResult(
            address=self.address,
            availability_zone=self.availability_zone,
            city=self.city,
            continent=self.continent,
            description=self.description,
            facility_provider=self.facility_provider,
            facility_provider_facility_id=self.facility_provider_facility_id,
            id=self.id,
            name=self.name,
            peeringdb_facility_id=self.peeringdb_facility_id,
            project=self.project,
            self_link=self.self_link,
            status=self.status)


def get_interconnect_location(name: Optional[_builtins.str] = None,
                              project: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInterconnectLocationResult:
    """
    Get the details of a single interconnect location. For more information see
    the official [API](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectLocations/get) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    this = gcp.compute.get_interconnect_location(name="iad-zone1-1")
    this_interconnect = gcp.compute.Interconnect("this",
        project=this.project,
        location=this.self_link,
        name="my-dedicated-connection-1")
    ```


    :param _builtins.str name: The name of the interconnect location.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getInterconnectLocation:getInterconnectLocation', __args__, opts=opts, typ=GetInterconnectLocationResult).value

    return AwaitableGetInterconnectLocationResult(
        address=pulumi.get(__ret__, 'address'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        city=pulumi.get(__ret__, 'city'),
        continent=pulumi.get(__ret__, 'continent'),
        description=pulumi.get(__ret__, 'description'),
        facility_provider=pulumi.get(__ret__, 'facility_provider'),
        facility_provider_facility_id=pulumi.get(__ret__, 'facility_provider_facility_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        peeringdb_facility_id=pulumi.get(__ret__, 'peeringdb_facility_id'),
        project=pulumi.get(__ret__, 'project'),
        self_link=pulumi.get(__ret__, 'self_link'),
        status=pulumi.get(__ret__, 'status'))
def get_interconnect_location_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                     project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInterconnectLocationResult]:
    """
    Get the details of a single interconnect location. For more information see
    the official [API](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectLocations/get) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    this = gcp.compute.get_interconnect_location(name="iad-zone1-1")
    this_interconnect = gcp.compute.Interconnect("this",
        project=this.project,
        location=this.self_link,
        name="my-dedicated-connection-1")
    ```


    :param _builtins.str name: The name of the interconnect location.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getInterconnectLocation:getInterconnectLocation', __args__, opts=opts, typ=GetInterconnectLocationResult)
    return __ret__.apply(lambda __response__: GetInterconnectLocationResult(
        address=pulumi.get(__response__, 'address'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        city=pulumi.get(__response__, 'city'),
        continent=pulumi.get(__response__, 'continent'),
        description=pulumi.get(__response__, 'description'),
        facility_provider=pulumi.get(__response__, 'facility_provider'),
        facility_provider_facility_id=pulumi.get(__response__, 'facility_provider_facility_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        peeringdb_facility_id=pulumi.get(__response__, 'peeringdb_facility_id'),
        project=pulumi.get(__response__, 'project'),
        self_link=pulumi.get(__response__, 'self_link'),
        status=pulumi.get(__response__, 'status')))
