# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInterconnectLocationsResult',
    'AwaitableGetInterconnectLocationsResult',
    'get_interconnect_locations',
    'get_interconnect_locations_output',
]

@pulumi.output_type
class GetInterconnectLocationsResult:
    """
    A collection of values returned by getInterconnectLocations.
    """
    def __init__(__self__, id=None, locations=None, project=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetInterconnectLocationsLocationResult']:
        """
        A list of interconnect locations. Each location will have the following attributes:
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetInterconnectLocationsResult(GetInterconnectLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInterconnectLocationsResult(
            id=self.id,
            locations=self.locations,
            project=self.project)


def get_interconnect_locations(project: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInterconnectLocationsResult:
    """
    Get a list of interconnect locations. For more information see
    the official [API](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectLocations/list) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    all = gcp.compute.get_interconnect_locations()
    pulumi.export("interconnectLocations", all.locations)
    ```


    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getInterconnectLocations:getInterconnectLocations', __args__, opts=opts, typ=GetInterconnectLocationsResult).value

    return AwaitableGetInterconnectLocationsResult(
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'),
        project=pulumi.get(__ret__, 'project'))
def get_interconnect_locations_output(project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInterconnectLocationsResult]:
    """
    Get a list of interconnect locations. For more information see
    the official [API](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectLocations/list) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    all = gcp.compute.get_interconnect_locations()
    pulumi.export("interconnectLocations", all.locations)
    ```


    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getInterconnectLocations:getInterconnectLocations', __args__, opts=opts, typ=GetInterconnectLocationsResult)
    return __ret__.apply(lambda __response__: GetInterconnectLocationsResult(
        id=pulumi.get(__response__, 'id'),
        locations=pulumi.get(__response__, 'locations'),
        project=pulumi.get(__response__, 'project')))
