# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMachineImageIamPolicyResult',
    'AwaitableGetMachineImageIamPolicyResult',
    'get_machine_image_iam_policy',
    'get_machine_image_iam_policy_output',
]

@pulumi.output_type
class GetMachineImageIamPolicyResult:
    """
    A collection of values returned by getMachineImageIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, machine_image=None, policy_data=None, project=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if machine_image and not isinstance(machine_image, str):
            raise TypeError("Expected argument 'machine_image' to be a str")
        pulumi.set(__self__, "machine_image", machine_image)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="machineImage")
    def machine_image(self) -> _builtins.str:
        return pulumi.get(self, "machine_image")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `compute.MachineImageIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetMachineImageIamPolicyResult(GetMachineImageIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMachineImageIamPolicyResult(
            etag=self.etag,
            id=self.id,
            machine_image=self.machine_image,
            policy_data=self.policy_data,
            project=self.project)


def get_machine_image_iam_policy(machine_image: Optional[_builtins.str] = None,
                                 project: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMachineImageIamPolicyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.compute.get_machine_image_iam_policy(project=image["project"],
        machine_image=image["name"])
    ```


    :param _builtins.str machine_image: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['machineImage'] = machine_image
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getMachineImageIamPolicy:getMachineImageIamPolicy', __args__, opts=opts, typ=GetMachineImageIamPolicyResult).value

    return AwaitableGetMachineImageIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        machine_image=pulumi.get(__ret__, 'machine_image'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_machine_image_iam_policy_output(machine_image: Optional[pulumi.Input[_builtins.str]] = None,
                                        project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMachineImageIamPolicyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.compute.get_machine_image_iam_policy(project=image["project"],
        machine_image=image["name"])
    ```


    :param _builtins.str machine_image: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['machineImage'] = machine_image
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getMachineImageIamPolicy:getMachineImageIamPolicy', __args__, opts=opts, typ=GetMachineImageIamPolicyResult)
    return __ret__.apply(lambda __response__: GetMachineImageIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        machine_image=pulumi.get(__response__, 'machine_image'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
