# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMachineTypesResult',
    'AwaitableGetMachineTypesResult',
    'get_machine_types',
    'get_machine_types_output',
]

@pulumi.output_type
class GetMachineTypesResult:
    """
    A collection of values returned by getMachineTypes.
    """
    def __init__(__self__, filter=None, id=None, machine_types=None, project=None, zone=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if machine_types and not isinstance(machine_types, list):
            raise TypeError("Expected argument 'machine_types' to be a list")
        pulumi.set(__self__, "machine_types", machine_types)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> Sequence['outputs.GetMachineTypesMachineTypeResult']:
        """
        The list of machine types matching the provided filter. Structure is documented below.
        """
        return pulumi.get(self, "machine_types")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetMachineTypesResult(GetMachineTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMachineTypesResult(
            filter=self.filter,
            id=self.id,
            machine_types=self.machine_types,
            project=self.project,
            zone=self.zone)


def get_machine_types(filter: Optional[_builtins.str] = None,
                      project: Optional[_builtins.str] = None,
                      zone: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMachineTypesResult:
    """
    Provides access to available Google Compute machine types in a zone for a given project.
    See more about [machine type availability](https://cloud.google.com/compute/docs/regions-zones#available) in the upstream docs.

    To get more information about machine types, see:

    * [API Documentation](https://cloud.google.com/compute/docs/reference/rest/v1/machineTypes/list)
    * [Comparison Guide](https://cloud.google.com/compute/docs/machine-resource)

    ## Example Usage

    ### Property-Based Availability

    Create a VM instance template for each machine type with 16GB of memory and 8 CPUs available in the provided zone.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example = gcp.compute.get_machine_types(filter="memoryMb = 16384 AND guestCpus = 8",
        zone=zone)
    example_instance_template = []
    for range in [{"key": k, "value": v} for [k, v] in enumerate(std.toset(input=[__item.name for __item in example.machine_types]).result)]:
        example_instance_template.append(gcp.compute.InstanceTemplate(f"example-{range['key']}",
            machine_type=range["value"],
            disks=[{
                "source_image": "debian-cloud/debian-11",
                "auto_delete": True,
                "boot": True,
            }]))
    ```

    ### Machine Family Preference

    Create an instance template, preferring `c3` machine family if available in the provided zone, otherwise falling back to `c2` and finally `n2`.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example = gcp.compute.get_machine_types(filter="memoryMb = 16384 AND guestCpus = 4",
        zone=zone)
    example_instance_template = gcp.compute.InstanceTemplate("example",
        machine_type=std.coalescelist(input=[
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="c3-").result],
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="c2-").result],
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="n2-").result],
        ]).result[0],
        disks=[{
            "source_image": "debian-cloud/debian-11",
            "auto_delete": True,
            "boot": True,
        }])
    ```


    :param _builtins.str filter: A filter expression that filters machine types listed in the response.
    :param _builtins.str project: Project from which to list available zones. Defaults to project declared in the provider.
    :param _builtins.str zone: Zone from which to list machine types.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getMachineTypes:getMachineTypes', __args__, opts=opts, typ=GetMachineTypesResult).value

    return AwaitableGetMachineTypesResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        machine_types=pulumi.get(__ret__, 'machine_types'),
        project=pulumi.get(__ret__, 'project'),
        zone=pulumi.get(__ret__, 'zone'))
def get_machine_types_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMachineTypesResult]:
    """
    Provides access to available Google Compute machine types in a zone for a given project.
    See more about [machine type availability](https://cloud.google.com/compute/docs/regions-zones#available) in the upstream docs.

    To get more information about machine types, see:

    * [API Documentation](https://cloud.google.com/compute/docs/reference/rest/v1/machineTypes/list)
    * [Comparison Guide](https://cloud.google.com/compute/docs/machine-resource)

    ## Example Usage

    ### Property-Based Availability

    Create a VM instance template for each machine type with 16GB of memory and 8 CPUs available in the provided zone.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example = gcp.compute.get_machine_types(filter="memoryMb = 16384 AND guestCpus = 8",
        zone=zone)
    example_instance_template = []
    for range in [{"key": k, "value": v} for [k, v] in enumerate(std.toset(input=[__item.name for __item in example.machine_types]).result)]:
        example_instance_template.append(gcp.compute.InstanceTemplate(f"example-{range['key']}",
            machine_type=range["value"],
            disks=[{
                "source_image": "debian-cloud/debian-11",
                "auto_delete": True,
                "boot": True,
            }]))
    ```

    ### Machine Family Preference

    Create an instance template, preferring `c3` machine family if available in the provided zone, otherwise falling back to `c2` and finally `n2`.

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example = gcp.compute.get_machine_types(filter="memoryMb = 16384 AND guestCpus = 4",
        zone=zone)
    example_instance_template = gcp.compute.InstanceTemplate("example",
        machine_type=std.coalescelist(input=[
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="c3-").result],
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="c2-").result],
            [mt.name for mt in example.machine_types if std.startswith(input=mt.name,
                prefix="n2-").result],
        ]).result[0],
        disks=[{
            "source_image": "debian-cloud/debian-11",
            "auto_delete": True,
            "boot": True,
        }])
    ```


    :param _builtins.str filter: A filter expression that filters machine types listed in the response.
    :param _builtins.str project: Project from which to list available zones. Defaults to project declared in the provider.
    :param _builtins.str zone: Zone from which to list machine types.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getMachineTypes:getMachineTypes', __args__, opts=opts, typ=GetMachineTypesResult)
    return __ret__.apply(lambda __response__: GetMachineTypesResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        machine_types=pulumi.get(__response__, 'machine_types'),
        project=pulumi.get(__response__, 'project'),
        zone=pulumi.get(__response__, 'zone')))
