# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkPeeringResult',
    'AwaitableGetNetworkPeeringResult',
    'get_network_peering',
    'get_network_peering_output',
]

@pulumi.output_type
class GetNetworkPeeringResult:
    """
    A collection of values returned by getNetworkPeering.
    """
    def __init__(__self__, export_custom_routes=None, export_subnet_routes_with_public_ip=None, id=None, import_custom_routes=None, import_subnet_routes_with_public_ip=None, name=None, network=None, peer_network=None, stack_type=None, state=None, state_details=None, update_strategy=None):
        if export_custom_routes and not isinstance(export_custom_routes, bool):
            raise TypeError("Expected argument 'export_custom_routes' to be a bool")
        pulumi.set(__self__, "export_custom_routes", export_custom_routes)
        if export_subnet_routes_with_public_ip and not isinstance(export_subnet_routes_with_public_ip, bool):
            raise TypeError("Expected argument 'export_subnet_routes_with_public_ip' to be a bool")
        pulumi.set(__self__, "export_subnet_routes_with_public_ip", export_subnet_routes_with_public_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_custom_routes and not isinstance(import_custom_routes, bool):
            raise TypeError("Expected argument 'import_custom_routes' to be a bool")
        pulumi.set(__self__, "import_custom_routes", import_custom_routes)
        if import_subnet_routes_with_public_ip and not isinstance(import_subnet_routes_with_public_ip, bool):
            raise TypeError("Expected argument 'import_subnet_routes_with_public_ip' to be a bool")
        pulumi.set(__self__, "import_subnet_routes_with_public_ip", import_subnet_routes_with_public_ip)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if peer_network and not isinstance(peer_network, str):
            raise TypeError("Expected argument 'peer_network' to be a str")
        pulumi.set(__self__, "peer_network", peer_network)
        if stack_type and not isinstance(stack_type, str):
            raise TypeError("Expected argument 'stack_type' to be a str")
        pulumi.set(__self__, "stack_type", stack_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_details and not isinstance(state_details, str):
            raise TypeError("Expected argument 'state_details' to be a str")
        pulumi.set(__self__, "state_details", state_details)
        if update_strategy and not isinstance(update_strategy, str):
            raise TypeError("Expected argument 'update_strategy' to be a str")
        pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter(name="exportCustomRoutes")
    def export_custom_routes(self) -> _builtins.bool:
        return pulumi.get(self, "export_custom_routes")

    @_builtins.property
    @pulumi.getter(name="exportSubnetRoutesWithPublicIp")
    def export_subnet_routes_with_public_ip(self) -> _builtins.bool:
        return pulumi.get(self, "export_subnet_routes_with_public_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="importCustomRoutes")
    def import_custom_routes(self) -> _builtins.bool:
        return pulumi.get(self, "import_custom_routes")

    @_builtins.property
    @pulumi.getter(name="importSubnetRoutesWithPublicIp")
    def import_subnet_routes_with_public_ip(self) -> _builtins.bool:
        return pulumi.get(self, "import_subnet_routes_with_public_ip")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="peerNetwork")
    def peer_network(self) -> _builtins.str:
        return pulumi.get(self, "peer_network")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> _builtins.str:
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> _builtins.str:
        return pulumi.get(self, "state_details")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> _builtins.str:
        return pulumi.get(self, "update_strategy")


class AwaitableGetNetworkPeeringResult(GetNetworkPeeringResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkPeeringResult(
            export_custom_routes=self.export_custom_routes,
            export_subnet_routes_with_public_ip=self.export_subnet_routes_with_public_ip,
            id=self.id,
            import_custom_routes=self.import_custom_routes,
            import_subnet_routes_with_public_ip=self.import_subnet_routes_with_public_ip,
            name=self.name,
            network=self.network,
            peer_network=self.peer_network,
            stack_type=self.stack_type,
            state=self.state,
            state_details=self.state_details,
            update_strategy=self.update_strategy)


def get_network_peering(name: Optional[_builtins.str] = None,
                        network: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkPeeringResult:
    """
    Get information of a specified compute network peering. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/vpc/vpc-peering)
    and
    [API](https://cloud.google.com/compute/docs/reference/latest/networks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.compute.Network("default",
        name="foobar",
        auto_create_subnetworks=False)
    other = gcp.compute.Network("other",
        name="other",
        auto_create_subnetworks=False)
    peering1 = gcp.compute.NetworkPeering("peering1",
        name="peering1",
        network=default.self_link,
        peer_network=other.self_link)
    peering2 = gcp.compute.NetworkPeering("peering2",
        name="peering2",
        network=other.self_link,
        peer_network=default.self_link)
    peering1_ds = gcp.compute.get_network_peering_output(name=peering1.name,
        network=peering1.network)
    ```


    :param _builtins.str name: Name of the peering.
    :param _builtins.str network: The primary network of the peering.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['network'] = network
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getNetworkPeering:getNetworkPeering', __args__, opts=opts, typ=GetNetworkPeeringResult).value

    return AwaitableGetNetworkPeeringResult(
        export_custom_routes=pulumi.get(__ret__, 'export_custom_routes'),
        export_subnet_routes_with_public_ip=pulumi.get(__ret__, 'export_subnet_routes_with_public_ip'),
        id=pulumi.get(__ret__, 'id'),
        import_custom_routes=pulumi.get(__ret__, 'import_custom_routes'),
        import_subnet_routes_with_public_ip=pulumi.get(__ret__, 'import_subnet_routes_with_public_ip'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        peer_network=pulumi.get(__ret__, 'peer_network'),
        stack_type=pulumi.get(__ret__, 'stack_type'),
        state=pulumi.get(__ret__, 'state'),
        state_details=pulumi.get(__ret__, 'state_details'),
        update_strategy=pulumi.get(__ret__, 'update_strategy'))
def get_network_peering_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               network: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkPeeringResult]:
    """
    Get information of a specified compute network peering. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/vpc/vpc-peering)
    and
    [API](https://cloud.google.com/compute/docs/reference/latest/networks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.compute.Network("default",
        name="foobar",
        auto_create_subnetworks=False)
    other = gcp.compute.Network("other",
        name="other",
        auto_create_subnetworks=False)
    peering1 = gcp.compute.NetworkPeering("peering1",
        name="peering1",
        network=default.self_link,
        peer_network=other.self_link)
    peering2 = gcp.compute.NetworkPeering("peering2",
        name="peering2",
        network=other.self_link,
        peer_network=default.self_link)
    peering1_ds = gcp.compute.get_network_peering_output(name=peering1.name,
        network=peering1.network)
    ```


    :param _builtins.str name: Name of the peering.
    :param _builtins.str network: The primary network of the peering.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['network'] = network
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getNetworkPeering:getNetworkPeering', __args__, opts=opts, typ=GetNetworkPeeringResult)
    return __ret__.apply(lambda __response__: GetNetworkPeeringResult(
        export_custom_routes=pulumi.get(__response__, 'export_custom_routes'),
        export_subnet_routes_with_public_ip=pulumi.get(__response__, 'export_subnet_routes_with_public_ip'),
        id=pulumi.get(__response__, 'id'),
        import_custom_routes=pulumi.get(__response__, 'import_custom_routes'),
        import_subnet_routes_with_public_ip=pulumi.get(__response__, 'import_subnet_routes_with_public_ip'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        peer_network=pulumi.get(__response__, 'peer_network'),
        stack_type=pulumi.get(__response__, 'stack_type'),
        state=pulumi.get(__response__, 'state'),
        state_details=pulumi.get(__response__, 'state_details'),
        update_strategy=pulumi.get(__response__, 'update_strategy')))
