# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetReservationBlockResult',
    'AwaitableGetReservationBlockResult',
    'get_reservation_block',
    'get_reservation_block_output',
]

@pulumi.output_type
class GetReservationBlockResult:
    """
    A collection of values returned by getReservationBlock.
    """
    def __init__(__self__, block_count=None, creation_timestamp=None, health_infos=None, id=None, in_use_count=None, kind=None, name=None, physical_topologies=None, project=None, reservation=None, reservation_maintenances=None, reservation_sub_block_count=None, reservation_sub_block_in_use_count=None, resource_id=None, self_link=None, self_link_with_id=None, status=None, zone=None):
        if block_count and not isinstance(block_count, int):
            raise TypeError("Expected argument 'block_count' to be a int")
        pulumi.set(__self__, "block_count", block_count)
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if health_infos and not isinstance(health_infos, list):
            raise TypeError("Expected argument 'health_infos' to be a list")
        pulumi.set(__self__, "health_infos", health_infos)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_use_count and not isinstance(in_use_count, int):
            raise TypeError("Expected argument 'in_use_count' to be a int")
        pulumi.set(__self__, "in_use_count", in_use_count)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if physical_topologies and not isinstance(physical_topologies, list):
            raise TypeError("Expected argument 'physical_topologies' to be a list")
        pulumi.set(__self__, "physical_topologies", physical_topologies)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if reservation and not isinstance(reservation, str):
            raise TypeError("Expected argument 'reservation' to be a str")
        pulumi.set(__self__, "reservation", reservation)
        if reservation_maintenances and not isinstance(reservation_maintenances, list):
            raise TypeError("Expected argument 'reservation_maintenances' to be a list")
        pulumi.set(__self__, "reservation_maintenances", reservation_maintenances)
        if reservation_sub_block_count and not isinstance(reservation_sub_block_count, int):
            raise TypeError("Expected argument 'reservation_sub_block_count' to be a int")
        pulumi.set(__self__, "reservation_sub_block_count", reservation_sub_block_count)
        if reservation_sub_block_in_use_count and not isinstance(reservation_sub_block_in_use_count, int):
            raise TypeError("Expected argument 'reservation_sub_block_in_use_count' to be a int")
        pulumi.set(__self__, "reservation_sub_block_in_use_count", reservation_sub_block_in_use_count)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id and not isinstance(self_link_with_id, str):
            raise TypeError("Expected argument 'self_link_with_id' to be a str")
        pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="blockCount")
    def block_count(self) -> _builtins.int:
        """
        The number of resources that are allocated in this reservation block.
        """
        return pulumi.get(self, "block_count")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> _builtins.str:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="healthInfos")
    def health_infos(self) -> Sequence['outputs.GetReservationBlockHealthInfoResult']:
        """
        Health information for the reservation block. Structure is documented below.
        """
        return pulumi.get(self, "health_infos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inUseCount")
    def in_use_count(self) -> _builtins.int:
        """
        The number of instances that are currently in use on this reservation block.
        """
        return pulumi.get(self, "in_use_count")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        Type of the resource. Always `compute#reservationBlock` for reservation blocks.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="physicalTopologies")
    def physical_topologies(self) -> Sequence['outputs.GetReservationBlockPhysicalTopologyResult']:
        """
        The physical topology of the reservation block. Structure is documented below.
        """
        return pulumi.get(self, "physical_topologies")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def reservation(self) -> _builtins.str:
        return pulumi.get(self, "reservation")

    @_builtins.property
    @pulumi.getter(name="reservationMaintenances")
    def reservation_maintenances(self) -> Sequence['outputs.GetReservationBlockReservationMaintenanceResult']:
        """
        Maintenance information for this reservation block. Structure is documented below.
        """
        return pulumi.get(self, "reservation_maintenances")

    @_builtins.property
    @pulumi.getter(name="reservationSubBlockCount")
    def reservation_sub_block_count(self) -> _builtins.int:
        """
        The number of reservation sub-blocks associated with this reservation block.
        """
        return pulumi.get(self, "reservation_sub_block_count")

    @_builtins.property
    @pulumi.getter(name="reservationSubBlockInUseCount")
    def reservation_sub_block_in_use_count(self) -> _builtins.int:
        """
        The number of in-use reservation sub-blocks associated with this reservation block.
        """
        return pulumi.get(self, "reservation_sub_block_in_use_count")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        Server-defined fully-qualified URL for this resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> _builtins.str:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the reservation block.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetReservationBlockResult(GetReservationBlockResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservationBlockResult(
            block_count=self.block_count,
            creation_timestamp=self.creation_timestamp,
            health_infos=self.health_infos,
            id=self.id,
            in_use_count=self.in_use_count,
            kind=self.kind,
            name=self.name,
            physical_topologies=self.physical_topologies,
            project=self.project,
            reservation=self.reservation,
            reservation_maintenances=self.reservation_maintenances,
            reservation_sub_block_count=self.reservation_sub_block_count,
            reservation_sub_block_in_use_count=self.reservation_sub_block_in_use_count,
            resource_id=self.resource_id,
            self_link=self.self_link,
            self_link_with_id=self.self_link_with_id,
            status=self.status,
            zone=self.zone)


def get_reservation_block(name: Optional[_builtins.str] = None,
                          project: Optional[_builtins.str] = None,
                          reservation: Optional[_builtins.str] = None,
                          zone: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservationBlockResult:
    """
    Get information about a Google Compute Engine Reservation Block. Reservation blocks are automatically created by Google Cloud within reservations and represent a physical grouping of resources.

    For more information see the [official documentation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
    and the [API](https://cloud.google.com/compute/docs/reference/rest/v1/reservationBlocks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    block = gcp.compute.get_reservation_block(name="my-reservation-block",
        reservation="my-reservation",
        zone="us-central1-a")
    pulumi.export("blockStatus", block.status)
    pulumi.export("blockInUseCount", block.in_use_count)
    ```


    :param _builtins.str name: The name of the reservation block.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str reservation: The name of the parent reservation.
    :param _builtins.str zone: The zone where the reservation block resides.
           
           - - -
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['reservation'] = reservation
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getReservationBlock:getReservationBlock', __args__, opts=opts, typ=GetReservationBlockResult).value

    return AwaitableGetReservationBlockResult(
        block_count=pulumi.get(__ret__, 'block_count'),
        creation_timestamp=pulumi.get(__ret__, 'creation_timestamp'),
        health_infos=pulumi.get(__ret__, 'health_infos'),
        id=pulumi.get(__ret__, 'id'),
        in_use_count=pulumi.get(__ret__, 'in_use_count'),
        kind=pulumi.get(__ret__, 'kind'),
        name=pulumi.get(__ret__, 'name'),
        physical_topologies=pulumi.get(__ret__, 'physical_topologies'),
        project=pulumi.get(__ret__, 'project'),
        reservation=pulumi.get(__ret__, 'reservation'),
        reservation_maintenances=pulumi.get(__ret__, 'reservation_maintenances'),
        reservation_sub_block_count=pulumi.get(__ret__, 'reservation_sub_block_count'),
        reservation_sub_block_in_use_count=pulumi.get(__ret__, 'reservation_sub_block_in_use_count'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        self_link=pulumi.get(__ret__, 'self_link'),
        self_link_with_id=pulumi.get(__ret__, 'self_link_with_id'),
        status=pulumi.get(__ret__, 'status'),
        zone=pulumi.get(__ret__, 'zone'))
def get_reservation_block_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                 project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 reservation: Optional[pulumi.Input[_builtins.str]] = None,
                                 zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReservationBlockResult]:
    """
    Get information about a Google Compute Engine Reservation Block. Reservation blocks are automatically created by Google Cloud within reservations and represent a physical grouping of resources.

    For more information see the [official documentation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
    and the [API](https://cloud.google.com/compute/docs/reference/rest/v1/reservationBlocks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    block = gcp.compute.get_reservation_block(name="my-reservation-block",
        reservation="my-reservation",
        zone="us-central1-a")
    pulumi.export("blockStatus", block.status)
    pulumi.export("blockInUseCount", block.in_use_count)
    ```


    :param _builtins.str name: The name of the reservation block.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str reservation: The name of the parent reservation.
    :param _builtins.str zone: The zone where the reservation block resides.
           
           - - -
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['reservation'] = reservation
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getReservationBlock:getReservationBlock', __args__, opts=opts, typ=GetReservationBlockResult)
    return __ret__.apply(lambda __response__: GetReservationBlockResult(
        block_count=pulumi.get(__response__, 'block_count'),
        creation_timestamp=pulumi.get(__response__, 'creation_timestamp'),
        health_infos=pulumi.get(__response__, 'health_infos'),
        id=pulumi.get(__response__, 'id'),
        in_use_count=pulumi.get(__response__, 'in_use_count'),
        kind=pulumi.get(__response__, 'kind'),
        name=pulumi.get(__response__, 'name'),
        physical_topologies=pulumi.get(__response__, 'physical_topologies'),
        project=pulumi.get(__response__, 'project'),
        reservation=pulumi.get(__response__, 'reservation'),
        reservation_maintenances=pulumi.get(__response__, 'reservation_maintenances'),
        reservation_sub_block_count=pulumi.get(__response__, 'reservation_sub_block_count'),
        reservation_sub_block_in_use_count=pulumi.get(__response__, 'reservation_sub_block_in_use_count'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        self_link=pulumi.get(__response__, 'self_link'),
        self_link_with_id=pulumi.get(__response__, 'self_link_with_id'),
        status=pulumi.get(__response__, 'status'),
        zone=pulumi.get(__response__, 'zone')))
